// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    AsyncInitable, AsyncResult, BusType, Cancellable, DBusConnection, DBusObjectManager,
    DBusObjectManagerClientFlags, DBusObjectProxy, DBusProxy, Initable, ffi,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GDBusObjectManagerClient")]
    pub struct DBusObjectManagerClient(Object<ffi::GDBusObjectManagerClient, ffi::GDBusObjectManagerClientClass>) @implements AsyncInitable, DBusObjectManager, Initable;

    match fn {
        type_ => || ffi::g_dbus_object_manager_client_get_type(),
    }
}

impl DBusObjectManagerClient {
    pub const NONE: Option<&'static DBusObjectManagerClient> = None;

    #[doc(alias = "g_dbus_object_manager_client_new_for_bus_sync")]
    #[doc(alias = "new_for_bus_sync")]
    #[allow(dead_code)]
    pub(crate) fn for_bus_sync_impl(
        bus_type: BusType,
        flags: DBusObjectManagerClientFlags,
        name: &str,
        object_path: &str,
        get_proxy_type_func: Option<
            Box_<
                dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type + 'static,
            >,
        >,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<DBusObjectManagerClient, glib::Error> {
        let get_proxy_type_func_data: Box_<
            Option<
                Box_<
                    dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type
                        + 'static,
                >,
            >,
        > = Box_::new(get_proxy_type_func);
        unsafe extern "C" fn get_proxy_type_func_func(
            manager: *mut ffi::GDBusObjectManagerClient,
            object_path: *const std::ffi::c_char,
            interface_name: *const std::ffi::c_char,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::GType {
            unsafe {
                let manager = from_glib_borrow(manager);
                let object_path: Borrowed<glib::GString> = from_glib_borrow(object_path);
                let interface_name: Borrowed<Option<glib::GString>> =
                    from_glib_borrow(interface_name);
                let callback = &*(data as *mut Option<
                    Box_<
                        dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type
                            + 'static,
                    >,
                >);
                if let Some(ref callback) = *callback {
                    callback(
                        &manager,
                        object_path.as_str(),
                        (*interface_name).as_ref().map(|s| s.as_str()),
                    )
                } else {
                    panic!("cannot get closure...")
                }
                .into_glib()
            }
        }
        let get_proxy_type_func = if get_proxy_type_func_data.is_some() {
            Some(get_proxy_type_func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn get_proxy_type_destroy_notify_func(data: glib::ffi::gpointer) {
            unsafe {
                let _callback = Box_::from_raw(
                    data as *mut Option<
                        Box_<
                            dyn Fn(
                                    &DBusObjectManagerClient,
                                    &str,
                                    Option<&str>,
                                ) -> glib::types::Type
                                + 'static,
                        >,
                    >,
                );
            }
        }
        let destroy_call6 = Some(get_proxy_type_destroy_notify_func as _);
        let super_callback0: Box_<
            Option<
                Box_<
                    dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type
                        + 'static,
                >,
            >,
        > = get_proxy_type_func_data;
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::g_dbus_object_manager_client_new_for_bus_sync(
                bus_type.into_glib(),
                flags.into_glib(),
                name.to_glib_none().0,
                object_path.to_glib_none().0,
                get_proxy_type_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call6,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_dbus_object_manager_client_new_sync")]
    #[doc(alias = "new_sync")]
    #[allow(dead_code)]
    pub(crate) fn new_sync_impl(
        connection: &DBusConnection,
        flags: DBusObjectManagerClientFlags,
        name: Option<&str>,
        object_path: &str,
        get_proxy_type_func: Option<
            Box_<
                dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type + 'static,
            >,
        >,
        cancellable: Option<&impl IsA<Cancellable>>,
    ) -> Result<DBusObjectManagerClient, glib::Error> {
        let get_proxy_type_func_data: Box_<
            Option<
                Box_<
                    dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type
                        + 'static,
                >,
            >,
        > = Box_::new(get_proxy_type_func);
        unsafe extern "C" fn get_proxy_type_func_func(
            manager: *mut ffi::GDBusObjectManagerClient,
            object_path: *const std::ffi::c_char,
            interface_name: *const std::ffi::c_char,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::GType {
            unsafe {
                let manager = from_glib_borrow(manager);
                let object_path: Borrowed<glib::GString> = from_glib_borrow(object_path);
                let interface_name: Borrowed<Option<glib::GString>> =
                    from_glib_borrow(interface_name);
                let callback = &*(data as *mut Option<
                    Box_<
                        dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type
                            + 'static,
                    >,
                >);
                if let Some(ref callback) = *callback {
                    callback(
                        &manager,
                        object_path.as_str(),
                        (*interface_name).as_ref().map(|s| s.as_str()),
                    )
                } else {
                    panic!("cannot get closure...")
                }
                .into_glib()
            }
        }
        let get_proxy_type_func = if get_proxy_type_func_data.is_some() {
            Some(get_proxy_type_func_func as _)
        } else {
            None
        };
        unsafe extern "C" fn get_proxy_type_destroy_notify_func(data: glib::ffi::gpointer) {
            unsafe {
                let _callback = Box_::from_raw(
                    data as *mut Option<
                        Box_<
                            dyn Fn(
                                    &DBusObjectManagerClient,
                                    &str,
                                    Option<&str>,
                                ) -> glib::types::Type
                                + 'static,
                        >,
                    >,
                );
            }
        }
        let destroy_call6 = Some(get_proxy_type_destroy_notify_func as _);
        let super_callback0: Box_<
            Option<
                Box_<
                    dyn Fn(&DBusObjectManagerClient, &str, Option<&str>) -> glib::types::Type
                        + 'static,
                >,
            >,
        > = get_proxy_type_func_data;
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::g_dbus_object_manager_client_new_sync(
                connection.to_glib_none().0,
                flags.into_glib(),
                name.to_glib_none().0,
                object_path.to_glib_none().0,
                get_proxy_type_func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call6,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl std::fmt::Display for DBusObjectManagerClient {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&DBusObjectManagerClientExt::name(self))
    }
}

unsafe impl Send for DBusObjectManagerClient {}
unsafe impl Sync for DBusObjectManagerClient {}

pub trait DBusObjectManagerClientExt: IsA<DBusObjectManagerClient> + 'static {
    #[doc(alias = "g_dbus_object_manager_client_get_connection")]
    #[doc(alias = "get_connection")]
    fn connection(&self) -> DBusConnection {
        unsafe {
            from_glib_none(ffi::g_dbus_object_manager_client_get_connection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_client_get_flags")]
    #[doc(alias = "get_flags")]
    fn flags(&self) -> DBusObjectManagerClientFlags {
        unsafe {
            from_glib(ffi::g_dbus_object_manager_client_get_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_client_get_name")]
    #[doc(alias = "get_name")]
    fn name(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::g_dbus_object_manager_client_get_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_client_get_name_owner")]
    #[doc(alias = "get_name_owner")]
    #[doc(alias = "name-owner")]
    fn name_owner(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::g_dbus_object_manager_client_get_name_owner(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "interface-proxy-signal")]
    fn connect_interface_proxy_signal<
        F: Fn(&Self, &DBusObjectProxy, &DBusProxy, &str, &str, &glib::Variant) + Send + Sync + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn interface_proxy_signal_trampoline<
            P: IsA<DBusObjectManagerClient>,
            F: Fn(&P, &DBusObjectProxy, &DBusProxy, &str, &str, &glib::Variant)
                + Send
                + Sync
                + 'static,
        >(
            this: *mut ffi::GDBusObjectManagerClient,
            object_proxy: *mut ffi::GDBusObjectProxy,
            interface_proxy: *mut ffi::GDBusProxy,
            sender_name: *mut std::ffi::c_char,
            signal_name: *mut std::ffi::c_char,
            parameters: *mut glib::ffi::GVariant,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    DBusObjectManagerClient::from_glib_borrow(this).unsafe_cast_ref(),
                    &from_glib_borrow(object_proxy),
                    &from_glib_borrow(interface_proxy),
                    &glib::GString::from_glib_borrow(sender_name),
                    &glib::GString::from_glib_borrow(signal_name),
                    &from_glib_borrow(parameters),
                )
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"interface-proxy-signal".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    interface_proxy_signal_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "name-owner")]
    fn connect_name_owner_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_name_owner_trampoline<
            P: IsA<DBusObjectManagerClient>,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut ffi::GDBusObjectManagerClient,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(DBusObjectManagerClient::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::name-owner".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_name_owner_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<DBusObjectManagerClient>> DBusObjectManagerClientExt for O {}
