LIBVNCSERVER_VERSION?=0.9.14
BUILD_DIR?=/tmp/vncdo
PYTHON?=python3




LIBVNCSERVER_TGZ?=LibVNCServer-$(LIBVNCSERVER_VERSION).tar.gz
LIBVNCSERVER_URL?=https://github.com/LibVNC/libvncserver/archive/refs/tags/$(LIBVNCSERVER_TGZ)

LIBVNCSERVER_DIR?=$(BUILD_DIR)/libvncserver-LibVNCServer-$(LIBVNCSERVER_VERSION)
LIBVNCSERVER_MAKEFILE=$(LIBVNCSERVER_DIR)/Makefile
LIBVNCSERVER_MAKEFILE_SRCS=$(wildcard $(LIBVNCSERVER_DIR)/*.cmake)


LIBVNCSERVER_EXAMPLES=vncev
LIBVNCSERVER_EXAMPLES:=$(addprefix $(LIBVNCSERVER_DIR)/examples/, $(LIBVNCSERVER_EXAMPLES))

LIBVNCSERVER_EXAMPLES_SRCS=$(addsuffix .c, $(LIBVNCSERVER_EXAMPLES))

libvnc-examples: $(LIBVNCSERVER_EXAMPLES)

.PHONY: veryclean
veryclean:
	rm -rf $(BUILD_DIR)

.PHONY: clean
clean:
	rm -f $(LIBVNCSERVER_EXAMPLES)


$(BUILD_DIR)/$(LIBVNCSERVER_TGZ):
	curl -L --create-dirs $(LIBVNCSERVER_URL) -o $@


$(LIBVNCSERVER_DIR): $(BUILD_DIR)/$(LIBVNCSERVER_TGZ)
	tar xfzv $< -C $(BUILD_DIR)

$(LIBVNCSERVER_MAKEFILE): $(LIBVNCSERVER_MAKEFILE_SRCS)
	cd $(LIBVNCSERVER_DIR) && cmake .


$(LIBVNCSERVER_EXAMPLES_SRCS): $(LIBVNCSERVER_DIR) $(LIBVNCSERVER_MAKEFILE)

$(LIBVNCSERVER_EXAMPLES): $(LIBVNCSERVER_EXAMPLES_SRCS)
	$(MAKE) -C $(LIBVNCSERVER_DIR)

.PHONY: test-libvnc
test-libvnc: export PATH:=$(PATH):$(LIBVNCSERVER_DIR)/examples
test-libvnc:
	$(PYTHON) -m unittest discover $(UNITTEST_ARGS) tests/functional
