% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{juice}
\alias{juice}
\title{Extract transformed training set}
\usage{
juice(object, ..., composition = "tibble")
}
\arguments{
\item{object}{A \code{recipe} object that has been prepared
with the option \code{retain = TRUE}.}

\item{...}{One or more selector functions to choose which variables will be
returned by the function. See \code{\link[=selections]{selections()}} for more details.
If no selectors are given, the default is to use
\code{\link[=everything]{everything()}}.}

\item{composition}{Either "tibble", "matrix", "data.frame", or
"dgCMatrix" for the format of the processed data set. Note that
all computations during the baking process are done in a
non-sparse format. Also, note that this argument should be
called \strong{after} any selectors and the selectors should only
resolve to numeric columns (otherwise an error is thrown).}
}
\description{
As of \code{recipes} version 0.1.14, \strong{\code{juice()} is superseded} in favor of
\code{bake(object, new_data = NULL)}.
}
\details{
As steps are estimated by \code{prep}, these operations are
applied to the training set. Rather than running \code{bake()}
to duplicate this processing, this function will return
variables from the processed training set.

When preparing a recipe, if the training data set is
retained using \code{retain = TRUE}, there is no need to \code{bake()} the
recipe to get the preprocessed training set.

\code{juice()} will return the results of a recipe where \emph{all steps}
have been applied to the data, irrespective of the value of
the step's \code{skip} argument.
}
\seealso{
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}} \code{\link[=bake.recipe]{bake.recipe()}}
}
