% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-information2.R
\name{information2}
\alias{information2}
\alias{information2.lvmfit}
\alias{information2.lvmfit2}
\alias{information.lvmfit2}
\title{Expected Information With Small Sample Correction.}
\usage{
information2(object, as.lava, ssc, ...)

\method{information2}{lvmfit}(object, as.lava = TRUE, ssc = lava.options()$ssc, ...)

\method{information2}{lvmfit2}(object, as.lava = TRUE, ...)

\method{information}{lvmfit2}(x, ...)
}
\arguments{
\item{object, x}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{as.lava}{[logical] if \code{TRUE}, uses the same names as when using \code{stats::coef}.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (\code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}
}
\value{
A matrix with as many rows and columns as the number of coefficients.
}
\description{
Extract the expected information matrix from a latent variable model.
Similar to \code{lava::information} but with small sample correction.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the information matrix.
}
\examples{
#### simulate data ####
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- Sequence.lvm(0)
set.seed(10)
d <- lava::sim(m,n)

#### linear models ####
e.lm <- lm(formula.lvm,data=d)

#### latent variable models ####
e.lvm <- estimate(lvm(formula.lvm),data=d)
information(e.lvm)
information2(e.lvm)
information2(e.lvm)[1:4,1:4] -  solve(vcov(e.lm))

}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{extractor}
\keyword{smallSampleCorrection}
