# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import IdentityProviderType

if TYPE_CHECKING:
    from .. import models as _models


class AdministratorProperties(_Model):
    """The local administrator login properties.

    :ivar user_name: The administrator user name.
    :vartype user_name: str
    :ivar password: The administrator password.
    :vartype password: str
    """

    user_name: Optional[str] = rest_field(name="userName", visibility=["read", "create", "update"])
    """The administrator user name."""
    password: Optional[str] = rest_field(visibility=["create", "update"])
    """The administrator password."""

    @overload
    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AuthConfigProperties(_Model):
    """The authentication configuration for the Mongo cluster.

    :ivar allowed_modes: Allowed authentication modes for data access on the cluster.
    :vartype allowed_modes: list[str or ~azure.mgmt.mongocluster.models.AuthenticationMode]
    """

    allowed_modes: Optional[list[Union[str, "_models.AuthenticationMode"]]] = rest_field(
        name="allowedModes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allowed authentication modes for data access on the cluster."""

    @overload
    def __init__(
        self,
        *,
        allowed_modes: Optional[list[Union[str, "_models.AuthenticationMode"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BackupProperties(_Model):
    """The backup properties of the cluster. This includes the earliest restore time and retention
    settings.

    :ivar earliest_restore_time: Earliest restore timestamp in UTC ISO8601 format.
    :vartype earliest_restore_time: str
    """

    earliest_restore_time: Optional[str] = rest_field(name="earliestRestoreTime", visibility=["read"])
    """Earliest restore timestamp in UTC ISO8601 format."""


class CheckNameAvailabilityRequest(_Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the resource for which availability needs to be checked."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource type."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityResponse(_Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.mongocluster.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is not available.
    :vartype message: str
    """

    name_available: Optional[bool] = rest_field(
        name="nameAvailable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the resource name is available."""
    reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The reason why the given name is not available. Known values are: \"Invalid\" and
     \"AlreadyExists\"."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed reason why the given name is not available."""

    @overload
    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComputeProperties(_Model):
    """The compute properties of the cluster. This includes the virtual-cores/memory and scaling
    options applied to servers in the cluster.

    :ivar tier: The compute tier to assign to the cluster, where each tier maps to a virtual-core
     and memory size. Example values: 'M30', 'M40'.
    :vartype tier: str
    """

    tier: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The compute tier to assign to the cluster, where each tier maps to a virtual-core and memory
     size. Example values: 'M30', 'M40'."""

    @overload
    def __init__(
        self,
        *,
        tier: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectionString(_Model):
    """Connection string for the mongo cluster.

    :ivar connection_string: Value of the connection string.
    :vartype connection_string: str
    :ivar description: Description of the connection string.
    :vartype description: str
    :ivar name: Name of the connection string.
    :vartype name: str
    """

    connection_string: Optional[str] = rest_field(name="connectionString", visibility=["read"])
    """Value of the connection string."""
    description: Optional[str] = rest_field(visibility=["read"])
    """Description of the connection string."""
    name: Optional[str] = rest_field(visibility=["read"])
    """Name of the connection string."""


class CustomerManagedKeyEncryptionProperties(_Model):
    """Customer managed key encryption settings.

    :ivar key_encryption_key_identity: The identity used to access the key encryption key.
    :vartype key_encryption_key_identity: ~azure.mgmt.mongocluster.models.KeyEncryptionKeyIdentity
    :ivar key_encryption_key_url: The URI of the key vault key used for encryption.
    :vartype key_encryption_key_url: str
    """

    key_encryption_key_identity: Optional["_models.KeyEncryptionKeyIdentity"] = rest_field(
        name="keyEncryptionKeyIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity used to access the key encryption key."""
    key_encryption_key_url: Optional[str] = rest_field(
        name="keyEncryptionKeyUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URI of the key vault key used for encryption."""

    @overload
    def __init__(
        self,
        *,
        key_encryption_key_identity: Optional["_models.KeyEncryptionKeyIdentity"] = None,
        key_encryption_key_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataApiProperties(_Model):
    """Data API properties.

    :ivar mode: The mode to indicate whether the Mongo Data API is enabled for a cluster. Known
     values are: "Enabled" and "Disabled".
    :vartype mode: str or ~azure.mgmt.mongocluster.models.DataApiMode
    """

    mode: Optional[Union[str, "_models.DataApiMode"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The mode to indicate whether the Mongo Data API is enabled for a cluster. Known values are:
     \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.DataApiMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DatabaseRole(_Model):
    """Database role definition that is assigned to a user.

    :ivar db: Database scope that the role is assigned to. Required.
    :vartype db: str
    :ivar role: The role that is assigned to the user on the database scope. Required. "root"
    :vartype role: str or ~azure.mgmt.mongocluster.models.UserRole
    """

    db: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Database scope that the role is assigned to. Required."""
    role: Union[str, "_models.UserRole"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The role that is assigned to the user on the database scope. Required. \"root\""""

    @overload
    def __init__(
        self,
        *,
        db: str,
        role: Union[str, "_models.UserRole"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionProperties(_Model):
    """The encryption configuration for the mongo cluster.

    :ivar customer_managed_key_encryption: Customer managed key encryption settings.
    :vartype customer_managed_key_encryption:
     ~azure.mgmt.mongocluster.models.CustomerManagedKeyEncryptionProperties
    """

    customer_managed_key_encryption: Optional["_models.CustomerManagedKeyEncryptionProperties"] = rest_field(
        name="customerManagedKeyEncryption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer managed key encryption settings."""

    @overload
    def __init__(
        self,
        *,
        customer_managed_key_encryption: Optional["_models.CustomerManagedKeyEncryptionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IdentityProvider(_Model):
    """Defines a user's identity provider definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EntraIdentityProvider

    :ivar type: The type of identity provider that the user belongs to. Required.
     "MicrosoftEntraID"
    :vartype type: str or ~azure.mgmt.mongocluster.models.IdentityProviderType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of identity provider that the user belongs to. Required. \"MicrosoftEntraID\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntraIdentityProvider(IdentityProvider, discriminator="MicrosoftEntraID"):
    """Defines a Microsoft Entra ID Mongo user.

    :ivar type: The type of identity provider that the user belongs to. Required. Microsoft Entra
     ID provider.
    :vartype type: str or ~azure.mgmt.mongocluster.models.MICROSOFT_ENTRA_ID
    :ivar properties: The Entra identity properties for the user. Required.
    :vartype properties: ~azure.mgmt.mongocluster.models.EntraIdentityProviderProperties
    """

    type: Literal[IdentityProviderType.MICROSOFT_ENTRA_ID] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of identity provider that the user belongs to. Required. Microsoft Entra ID provider."""
    properties: "_models.EntraIdentityProviderProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Entra identity properties for the user. Required."""

    @overload
    def __init__(
        self,
        *,
        properties: "_models.EntraIdentityProviderProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = IdentityProviderType.MICROSOFT_ENTRA_ID  # type: ignore


class EntraIdentityProviderProperties(_Model):
    """Microsoft Entra ID provider properties.

    :ivar principal_type: The principal type of the user. Required. Known values are: "user" and
     "servicePrincipal".
    :vartype principal_type: str or ~azure.mgmt.mongocluster.models.EntraPrincipalType
    """

    principal_type: Union[str, "_models.EntraPrincipalType"] = rest_field(
        name="principalType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The principal type of the user. Required. Known values are: \"user\" and \"servicePrincipal\"."""

    @overload
    def __init__(
        self,
        *,
        principal_type: Union[str, "_models.EntraPrincipalType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.mongocluster.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.mongocluster.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.mongocluster.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    """


class FirewallRule(ProxyResource):
    """Represents a mongo cluster firewall rule.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.FirewallRuleProperties
    """

    properties: Optional["_models.FirewallRuleProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FirewallRuleProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FirewallRuleProperties(_Model):
    """The properties of a mongo cluster firewall rule.

    :ivar provisioning_state: The provisioning state of the firewall rule. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", "Updating", and "Dropping".
    :vartype provisioning_state: str or ~azure.mgmt.mongocluster.models.ProvisioningState
    :ivar start_ip_address: The start IP address of the mongo cluster firewall rule. Must be IPv4
     format. Required.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address of the mongo cluster firewall rule. Must be IPv4
     format. Required.
    :vartype end_ip_address: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the firewall rule. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"InProgress\", \"Updating\", and \"Dropping\"."""
    start_ip_address: str = rest_field(
        name="startIpAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """The start IP address of the mongo cluster firewall rule. Must be IPv4 format. Required."""
    end_ip_address: str = rest_field(name="endIpAddress", visibility=["read", "create", "update", "delete", "query"])
    """The end IP address of the mongo cluster firewall rule. Must be IPv4 format. Required."""

    @overload
    def __init__(
        self,
        *,
        start_ip_address: str,
        end_ip_address: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HighAvailabilityProperties(_Model):
    """The high availability properties of the cluster.

    :ivar target_mode: The target high availability mode requested for the cluster. Known values
     are: "Disabled", "SameZone", and "ZoneRedundantPreferred".
    :vartype target_mode: str or ~azure.mgmt.mongocluster.models.HighAvailabilityMode
    """

    target_mode: Optional[Union[str, "_models.HighAvailabilityMode"]] = rest_field(
        name="targetMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The target high availability mode requested for the cluster. Known values are: \"Disabled\",
     \"SameZone\", and \"ZoneRedundantPreferred\"."""

    @overload
    def __init__(
        self,
        *,
        target_mode: Optional[Union[str, "_models.HighAvailabilityMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyEncryptionKeyIdentity(_Model):
    """The identity used for key encryption key.

    :ivar identity_type: The type of identity. Only 'UserAssignedIdentity' is supported.
     "UserAssignedIdentity"
    :vartype identity_type: str or ~azure.mgmt.mongocluster.models.KeyEncryptionKeyIdentityType
    :ivar user_assigned_identity_resource_id: The user assigned identity resource id.
    :vartype user_assigned_identity_resource_id: str
    """

    identity_type: Optional[Union[str, "_models.KeyEncryptionKeyIdentityType"]] = rest_field(
        name="identityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity. Only 'UserAssignedIdentity' is supported. \"UserAssignedIdentity\""""
    user_assigned_identity_resource_id: Optional[str] = rest_field(
        name="userAssignedIdentityResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user assigned identity resource id."""

    @overload
    def __init__(
        self,
        *,
        identity_type: Optional[Union[str, "_models.KeyEncryptionKeyIdentityType"]] = None,
        user_assigned_identity_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ListConnectionStringsResult(_Model):
    """The connection strings for the given mongo cluster.

    :ivar connection_strings: An array that contains the connection strings for a mongo cluster.
    :vartype connection_strings: list[~azure.mgmt.mongocluster.models.ConnectionString]
    """

    connection_strings: Optional[list["_models.ConnectionString"]] = rest_field(
        name="connectionStrings", visibility=["read"]
    )
    """An array that contains the connection strings for a mongo cluster."""


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.mongocluster.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.mongocluster.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MongoCluster(TrackedResource):
    """Represents a mongo cluster resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.MongoClusterProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.mongocluster.models.ManagedServiceIdentity
    """

    properties: Optional["_models.MongoClusterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.MongoClusterProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MongoClusterProperties(_Model):
    """The properties of a mongo cluster.

    :ivar create_mode: The mode to create a mongo cluster. Known values are: "Default",
     "PointInTimeRestore", "GeoReplica", and "Replica".
    :vartype create_mode: str or ~azure.mgmt.mongocluster.models.CreateMode
    :ivar restore_parameters: The parameters to create a point-in-time restore mongo cluster.
    :vartype restore_parameters: ~azure.mgmt.mongocluster.models.MongoClusterRestoreParameters
    :ivar replica_parameters: The parameters to create a replica mongo cluster.
    :vartype replica_parameters: ~azure.mgmt.mongocluster.models.MongoClusterReplicaParameters
    :ivar administrator: The local administrator properties for the mongo cluster.
    :vartype administrator: ~azure.mgmt.mongocluster.models.AdministratorProperties
    :ivar server_version: The Mongo DB server version. Defaults to the latest available version if
     not specified.
    :vartype server_version: str
    :ivar connection_string: The default mongo connection string for the cluster.
    :vartype connection_string: str
    :ivar provisioning_state: The provisioning state of the mongo cluster. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", "Updating", and "Dropping".
    :vartype provisioning_state: str or ~azure.mgmt.mongocluster.models.ProvisioningState
    :ivar cluster_status: The status of the mongo cluster. Known values are: "Ready",
     "Provisioning", "Updating", "Starting", "Stopping", "Stopped", and "Dropping".
    :vartype cluster_status: str or ~azure.mgmt.mongocluster.models.MongoClusterStatus
    :ivar public_network_access: Whether or not public endpoint access is allowed for this mongo
     cluster. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.mongocluster.models.PublicNetworkAccess
    :ivar high_availability: The high availability properties of the mongo cluster.
    :vartype high_availability: ~azure.mgmt.mongocluster.models.HighAvailabilityProperties
    :ivar storage: The storage properties of the mongo cluster.
    :vartype storage: ~azure.mgmt.mongocluster.models.StorageProperties
    :ivar sharding: The sharding properties of the mongo cluster.
    :vartype sharding: ~azure.mgmt.mongocluster.models.ShardingProperties
    :ivar compute: The compute properties of the mongo cluster.
    :vartype compute: ~azure.mgmt.mongocluster.models.ComputeProperties
    :ivar backup: The backup properties of the mongo cluster.
    :vartype backup: ~azure.mgmt.mongocluster.models.BackupProperties
    :ivar data_api: The Data API properties of the mongo cluster.
    :vartype data_api: ~azure.mgmt.mongocluster.models.DataApiProperties
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.mongocluster.models.PrivateEndpointConnection]
    :ivar preview_features: List of private endpoint connections.
    :vartype preview_features: list[str or ~azure.mgmt.mongocluster.models.PreviewFeature]
    :ivar replica: The replication properties for the mongo cluster.
    :vartype replica: ~azure.mgmt.mongocluster.models.ReplicationProperties
    :ivar infrastructure_version: The infrastructure version the cluster is provisioned on.
    :vartype infrastructure_version: str
    :ivar auth_config: The authentication configuration for the cluster.
    :vartype auth_config: ~azure.mgmt.mongocluster.models.AuthConfigProperties
    :ivar encryption: The encryption configuration for the cluster. Depends on identity being
     configured.
    :vartype encryption: ~azure.mgmt.mongocluster.models.EncryptionProperties
    """

    create_mode: Optional[Union[str, "_models.CreateMode"]] = rest_field(
        name="createMode", visibility=["read", "create"]
    )
    """The mode to create a mongo cluster. Known values are: \"Default\", \"PointInTimeRestore\",
     \"GeoReplica\", and \"Replica\"."""
    restore_parameters: Optional["_models.MongoClusterRestoreParameters"] = rest_field(
        name="restoreParameters", visibility=["read", "create"]
    )
    """The parameters to create a point-in-time restore mongo cluster."""
    replica_parameters: Optional["_models.MongoClusterReplicaParameters"] = rest_field(
        name="replicaParameters", visibility=["read", "create"]
    )
    """The parameters to create a replica mongo cluster."""
    administrator: Optional["_models.AdministratorProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The local administrator properties for the mongo cluster."""
    server_version: Optional[str] = rest_field(
        name="serverVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Mongo DB server version. Defaults to the latest available version if not specified."""
    connection_string: Optional[str] = rest_field(name="connectionString", visibility=["read"])
    """The default mongo connection string for the cluster."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the mongo cluster. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"InProgress\", \"Updating\", and \"Dropping\"."""
    cluster_status: Optional[Union[str, "_models.MongoClusterStatus"]] = rest_field(
        name="clusterStatus", visibility=["read"]
    )
    """The status of the mongo cluster. Known values are: \"Ready\", \"Provisioning\", \"Updating\",
     \"Starting\", \"Stopping\", \"Stopped\", and \"Dropping\"."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether or not public endpoint access is allowed for this mongo cluster. Known values are:
     \"Enabled\" and \"Disabled\"."""
    high_availability: Optional["_models.HighAvailabilityProperties"] = rest_field(
        name="highAvailability", visibility=["read", "create", "update", "delete", "query"]
    )
    """The high availability properties of the mongo cluster."""
    storage: Optional["_models.StorageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage properties of the mongo cluster."""
    sharding: Optional["_models.ShardingProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sharding properties of the mongo cluster."""
    compute: Optional["_models.ComputeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The compute properties of the mongo cluster."""
    backup: Optional["_models.BackupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The backup properties of the mongo cluster."""
    data_api: Optional["_models.DataApiProperties"] = rest_field(
        name="dataApi", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Data API properties of the mongo cluster."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnection"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """List of private endpoint connections."""
    preview_features: Optional[list[Union[str, "_models.PreviewFeature"]]] = rest_field(
        name="previewFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of private endpoint connections."""
    replica: Optional["_models.ReplicationProperties"] = rest_field(visibility=["read"])
    """The replication properties for the mongo cluster."""
    infrastructure_version: Optional[str] = rest_field(name="infrastructureVersion", visibility=["read"])
    """The infrastructure version the cluster is provisioned on."""
    auth_config: Optional["_models.AuthConfigProperties"] = rest_field(
        name="authConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authentication configuration for the cluster."""
    encryption: Optional["_models.EncryptionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption configuration for the cluster. Depends on identity being configured."""

    @overload
    def __init__(
        self,
        *,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        restore_parameters: Optional["_models.MongoClusterRestoreParameters"] = None,
        replica_parameters: Optional["_models.MongoClusterReplicaParameters"] = None,
        administrator: Optional["_models.AdministratorProperties"] = None,
        server_version: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        high_availability: Optional["_models.HighAvailabilityProperties"] = None,
        storage: Optional["_models.StorageProperties"] = None,
        sharding: Optional["_models.ShardingProperties"] = None,
        compute: Optional["_models.ComputeProperties"] = None,
        backup: Optional["_models.BackupProperties"] = None,
        data_api: Optional["_models.DataApiProperties"] = None,
        preview_features: Optional[list[Union[str, "_models.PreviewFeature"]]] = None,
        auth_config: Optional["_models.AuthConfigProperties"] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MongoClusterReplicaParameters(_Model):
    """Parameters used for replica operations.

    :ivar source_resource_id: The id of the replication source cluster. Required.
    :vartype source_resource_id: str
    :ivar source_location: The location of the source cluster. Required.
    :vartype source_location: str
    """

    source_resource_id: str = rest_field(
        name="sourceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The id of the replication source cluster. Required."""
    source_location: str = rest_field(name="sourceLocation", visibility=["read", "create", "update", "delete", "query"])
    """The location of the source cluster. Required."""

    @overload
    def __init__(
        self,
        *,
        source_resource_id: str,
        source_location: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MongoClusterRestoreParameters(_Model):
    """Parameters used for restore operations.

    :ivar point_in_time_utc: UTC point in time to restore a mongo cluster.
    :vartype point_in_time_utc: ~datetime.datetime
    :ivar source_resource_id: Resource ID to locate the source cluster to restore.
    :vartype source_resource_id: str
    """

    point_in_time_utc: Optional[datetime.datetime] = rest_field(
        name="pointInTimeUTC", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """UTC point in time to restore a mongo cluster."""
    source_resource_id: Optional[str] = rest_field(
        name="sourceResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource ID to locate the source cluster to restore."""

    @overload
    def __init__(
        self,
        *,
        point_in_time_utc: Optional[datetime.datetime] = None,
        source_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MongoClusterUpdate(_Model):
    """The type used for update operations of the MongoCluster.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.mongocluster.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.MongoClusterUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.MongoClusterUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.MongoClusterUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MongoClusterUpdateProperties(_Model):
    """The updatable properties of the MongoCluster.

    :ivar administrator: The local administrator properties for the mongo cluster.
    :vartype administrator: ~azure.mgmt.mongocluster.models.AdministratorProperties
    :ivar server_version: The Mongo DB server version. Defaults to the latest available version if
     not specified.
    :vartype server_version: str
    :ivar public_network_access: Whether or not public endpoint access is allowed for this mongo
     cluster. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.mongocluster.models.PublicNetworkAccess
    :ivar high_availability: The high availability properties of the mongo cluster.
    :vartype high_availability: ~azure.mgmt.mongocluster.models.HighAvailabilityProperties
    :ivar storage: The storage properties of the mongo cluster.
    :vartype storage: ~azure.mgmt.mongocluster.models.StorageProperties
    :ivar sharding: The sharding properties of the mongo cluster.
    :vartype sharding: ~azure.mgmt.mongocluster.models.ShardingProperties
    :ivar compute: The compute properties of the mongo cluster.
    :vartype compute: ~azure.mgmt.mongocluster.models.ComputeProperties
    :ivar backup: The backup properties of the mongo cluster.
    :vartype backup: ~azure.mgmt.mongocluster.models.BackupProperties
    :ivar data_api: The Data API properties of the mongo cluster.
    :vartype data_api: ~azure.mgmt.mongocluster.models.DataApiProperties
    :ivar preview_features: List of private endpoint connections.
    :vartype preview_features: list[str or ~azure.mgmt.mongocluster.models.PreviewFeature]
    :ivar auth_config: The authentication configuration for the cluster.
    :vartype auth_config: ~azure.mgmt.mongocluster.models.AuthConfigProperties
    :ivar encryption: The encryption configuration for the cluster. Depends on identity being
     configured.
    :vartype encryption: ~azure.mgmt.mongocluster.models.EncryptionProperties
    """

    administrator: Optional["_models.AdministratorProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The local administrator properties for the mongo cluster."""
    server_version: Optional[str] = rest_field(
        name="serverVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Mongo DB server version. Defaults to the latest available version if not specified."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether or not public endpoint access is allowed for this mongo cluster. Known values are:
     \"Enabled\" and \"Disabled\"."""
    high_availability: Optional["_models.HighAvailabilityProperties"] = rest_field(
        name="highAvailability", visibility=["read", "create", "update", "delete", "query"]
    )
    """The high availability properties of the mongo cluster."""
    storage: Optional["_models.StorageProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage properties of the mongo cluster."""
    sharding: Optional["_models.ShardingProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sharding properties of the mongo cluster."""
    compute: Optional["_models.ComputeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The compute properties of the mongo cluster."""
    backup: Optional["_models.BackupProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The backup properties of the mongo cluster."""
    data_api: Optional["_models.DataApiProperties"] = rest_field(
        name="dataApi", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Data API properties of the mongo cluster."""
    preview_features: Optional[list[Union[str, "_models.PreviewFeature"]]] = rest_field(
        name="previewFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of private endpoint connections."""
    auth_config: Optional["_models.AuthConfigProperties"] = rest_field(
        name="authConfig", visibility=["read", "create", "update", "delete", "query"]
    )
    """The authentication configuration for the cluster."""
    encryption: Optional["_models.EncryptionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption configuration for the cluster. Depends on identity being configured."""

    @overload
    def __init__(
        self,
        *,
        administrator: Optional["_models.AdministratorProperties"] = None,
        server_version: Optional[str] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        high_availability: Optional["_models.HighAvailabilityProperties"] = None,
        storage: Optional["_models.StorageProperties"] = None,
        sharding: Optional["_models.ShardingProperties"] = None,
        compute: Optional["_models.ComputeProperties"] = None,
        backup: Optional["_models.BackupProperties"] = None,
        data_api: Optional["_models.DataApiProperties"] = None,
        preview_features: Optional[list[Union[str, "_models.PreviewFeature"]]] = None,
        auth_config: Optional["_models.AuthConfigProperties"] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.mongocluster.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.mongocluster.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.mongocluster.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PrivateEndpoint(_Model):
    """The private endpoint resource.

    :ivar id: The resource identifier of the private endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource identifier of the private endpoint."""


class PrivateEndpointConnection(Resource):
    """The private endpoint connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The private endpoint connection properties.
    :vartype properties: ~azure.mgmt.mongocluster.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The private endpoint connection properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionProperties(_Model):
    """Properties of the private endpoint connection.

    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.mongocluster.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.mongocluster.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.mongocluster.models.PrivateEndpointConnectionProvisioningState
    """

    group_ids: Optional[list[str]] = rest_field(name="groupIds", visibility=["read"])
    """The group ids for the private endpoint resource."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private endpoint resource."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """A collection of information about the state of the connection between service consumer and
     provider. Required."""
    provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the private endpoint connection resource. Known values are:
     \"Succeeded\", \"Creating\", \"Deleting\", and \"Failed\"."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[list[str]] = rest_field(
        name="requiredZoneNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link resource private link DNS zone name."""

    @overload
    def __init__(
        self,
        *,
        required_zone_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateLinkServiceConnectionState(_Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.mongocluster.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the connection has been Approved/Rejected/Removed by the owner of the
     service. Known values are: \"Pending\", \"Approved\", and \"Rejected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for approval/rejection of the connection."""
    actions_required: Optional[str] = rest_field(
        name="actionsRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """A message indicating if changes on the service provider require any updates on the consumer."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PromoteReplicaRequest(_Model):
    """Promote replica request properties.

    :ivar promote_option: The promote option to apply to the operation. Required. "Forced"
    :vartype promote_option: str or ~azure.mgmt.mongocluster.models.PromoteOption
    :ivar mode: The mode to apply to the promote operation. Value is optional and default value is
     'Switchover'. "Switchover"
    :vartype mode: str or ~azure.mgmt.mongocluster.models.PromoteMode
    """

    promote_option: Union[str, "_models.PromoteOption"] = rest_field(
        name="promoteOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """The promote option to apply to the operation. Required. \"Forced\""""
    mode: Optional[Union[str, "_models.PromoteMode"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The mode to apply to the promote operation. Value is optional and default value is
     'Switchover'. \"Switchover\""""

    @overload
    def __init__(
        self,
        *,
        promote_option: Union[str, "_models.PromoteOption"],
        mode: Optional[Union[str, "_models.PromoteMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Replica(ProxyResource):
    """Represents a mongo cluster replica.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.MongoClusterProperties
    """

    properties: Optional["_models.MongoClusterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.MongoClusterProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReplicationProperties(_Model):
    """Replica properties of the mongo cluster.

    :ivar source_resource_id: The resource id the source cluster for the replica cluster.
    :vartype source_resource_id: str
    :ivar role: The replication role of the cluster. Known values are: "Primary", "AsyncReplica",
     and "GeoAsyncReplica".
    :vartype role: str or ~azure.mgmt.mongocluster.models.ReplicationRole
    :ivar replication_state: The replication link state of the replica cluster. Known values are:
     "Active", "Catchup", "Provisioning", "Updating", "Broken", and "Reconfiguring".
    :vartype replication_state: str or ~azure.mgmt.mongocluster.models.ReplicationState
    """

    source_resource_id: Optional[str] = rest_field(name="sourceResourceId", visibility=["read"])
    """The resource id the source cluster for the replica cluster."""
    role: Optional[Union[str, "_models.ReplicationRole"]] = rest_field(visibility=["read"])
    """The replication role of the cluster. Known values are: \"Primary\", \"AsyncReplica\", and
     \"GeoAsyncReplica\"."""
    replication_state: Optional[Union[str, "_models.ReplicationState"]] = rest_field(
        name="replicationState", visibility=["read"]
    )
    """The replication link state of the replica cluster. Known values are: \"Active\", \"Catchup\",
     \"Provisioning\", \"Updating\", \"Broken\", and \"Reconfiguring\"."""


class ShardingProperties(_Model):
    """The sharding properties of the cluster. This includes the shard count and scaling options for
    the cluster.

    :ivar shard_count: Number of shards to provision on the cluster.
    :vartype shard_count: int
    """

    shard_count: Optional[int] = rest_field(
        name="shardCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of shards to provision on the cluster."""

    @overload
    def __init__(
        self,
        *,
        shard_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StorageProperties(_Model):
    """The storage properties of the cluster. This includes the data storage size and scaling applied
    to servers in the cluster.

    :ivar size_gb: The size of the data disk assigned to each server.
    :vartype size_gb: int
    :ivar type: The type of storage to provision the cluster servers with. Known values are:
     "PremiumSSD" and "PremiumSSDv2".
    :vartype type: str or ~azure.mgmt.mongocluster.models.StorageType
    """

    size_gb: Optional[int] = rest_field(name="sizeGb", visibility=["read", "create", "update", "delete", "query"])
    """The size of the data disk assigned to each server."""
    type: Optional[Union[str, "_models.StorageType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of storage to provision the cluster servers with. Known values are: \"PremiumSSD\" and
     \"PremiumSSDv2\"."""

    @overload
    def __init__(
        self,
        *,
        size_gb: Optional[int] = None,
        type: Optional[Union[str, "_models.StorageType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.mongocluster.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.mongocluster.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class User(ProxyResource):
    """Represents a Mongo cluster user.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mongocluster.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.mongocluster.models.UserProperties
    """

    properties: Optional["_models.UserProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.UserProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class UserProperties(_Model):
    """Definition of Mongo user resource on a cluster.

    :ivar provisioning_state: The provisioning state of the user. Known values are: "Succeeded",
     "Failed", "Canceled", "InProgress", "Updating", and "Dropping".
    :vartype provisioning_state: str or ~azure.mgmt.mongocluster.models.ProvisioningState
    :ivar identity_provider: The user's identity provider definition.
    :vartype identity_provider: ~azure.mgmt.mongocluster.models.IdentityProvider
    :ivar roles: Database roles that are assigned to the user.
    :vartype roles: list[~azure.mgmt.mongocluster.models.DatabaseRole]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the user. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"InProgress\", \"Updating\", and \"Dropping\"."""
    identity_provider: Optional["_models.IdentityProvider"] = rest_field(
        name="identityProvider", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user's identity provider definition."""
    roles: Optional[list["_models.DatabaseRole"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Database roles that are assigned to the user."""

    @overload
    def __init__(
        self,
        *,
        identity_provider: Optional["_models.IdentityProvider"] = None,
        roles: Optional[list["_models.DatabaseRole"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
