# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DevBoxActionDelayStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The result of the delay operation on this action."""

    SUCCEEDED = "Succeeded"
    """The delay operation succeeded."""
    FAILED = "Failed"
    """The delay operation failed."""


class DevBoxActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of action which will take place on a Dev Box."""

    STOP = "Stop"
    """The action will stop the Dev Box."""


class DevBoxProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the provisioning state of the Dev Box."""

    SUCCEEDED = "Succeeded"
    """Dev Box was successfully provisioned."""
    FAILED = "Failed"
    """Dev Box failed to provision."""
    CANCELED = "Canceled"
    """Dev Box provision was canceled."""
    CREATING = "Creating"
    """Dev Box is being created."""
    DELETING = "Deleting"
    """Dev Box is being deleted."""
    UPDATING = "Updating"
    """Dev Box is updating."""
    STARTING = "Starting"
    """Dev Box is starting."""
    STOPPING = "Stopping"
    """Dev Box is stopping."""
    PROVISIONING = "Provisioning"
    """Dev Box is provisioning."""
    PROVISIONED_WITH_WARNING = "ProvisionedWithWarning"
    """Dev Box was provisioned with warning."""
    IN_GRACE_PERIOD = "InGracePeriod"
    """Dev Box is in grace period."""
    NOT_PROVISIONED = "NotProvisioned"
    """Dev Box is not provisioned."""


class EnvironmentProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the environment."""

    SUCCEEDED = "Succeeded"
    """The environment was successfully provisioned."""
    FAILED = "Failed"
    """The environment failed to provision."""
    CANCELED = "Canceled"
    """The environment provisioning was canceled."""
    CREATING = "Creating"
    """The environment is creating."""
    ACCEPTED = "Accepted"
    """The environment was accepted."""
    DELETING = "Deleting"
    """The environment is deleting."""
    UPDATING = "Updating"
    """The environment is updating."""
    PREPARING = "Preparing"
    """The environment is preparing."""
    RUNNING = "Running"
    """The environment is running."""
    SYNCING = "Syncing"
    """The environment is Syncing."""
    MOVING_RESOURCES = "MovingResources"
    """The environment is moving resources."""
    TRANSIENT_FAILURE = "TransientFailure"
    """The environment has a transient failure."""
    STORAGE_PROVISIONING_FAILED = "StorageProvisioningFailed"
    """The environment storage provisioning failed."""


class EnvironmentTypeStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether an environment type is enabled for use in a project."""

    ENABLED = "Enabled"
    """The environment type is enabled for use in the project."""
    DISABLED = "Disabled"
    """The environment type is not enabled for use in the project."""


class HibernateSupport(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether hibernate is supported and enabled, disabled, or unsupported by the operating
    system. Unknown hibernate support is represented as null.
    """

    ENABLED = "Enabled"
    """Hibernate is enabled."""
    DISABLED = "Disabled"
    """Hibernate is not enabled."""
    OS_UNSUPPORTED = "OsUnsupported"
    """Hibernate is not supported by the operating system."""


class LocalAdministratorStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether owners of Dev Boxes in a pool are local administrators on the Dev Boxes."""

    ENABLED = "Enabled"
    """Owners of Dev Boxes in the pool are local administrators on the Dev Boxes."""
    DISABLED = "Disabled"
    """Owners of Dev Boxes in the pool are not local administrators on the Dev Boxes."""


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum describing allowed operation states."""

    NOT_STARTED = "NotStarted"
    """The operation has not started."""
    RUNNING = "Running"
    """The operation is in progress."""
    SUCCEEDED = "Succeeded"
    """The operation has completed successfully."""
    FAILED = "Failed"
    """The operation has failed."""
    CANCELED = "Canceled"
    """The operation has been canceled by the user."""


class OSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operating system type."""

    WINDOWS = "Windows"
    """The Windows operating system."""


class ParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of data a parameter accepts."""

    ARRAY = "array"
    """The parameter accepts an array of values."""
    BOOLEAN = "boolean"
    """The parameter accepts a boolean value."""
    INTEGER = "integer"
    """The parameter accepts an integer value."""
    NUMBER = "number"
    """The parameter accepts a number value."""
    OBJECT = "object"
    """The parameter accepts an object value."""
    STRING = "string"
    """The parameter accepts a string value."""


class PoolHealthStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Pool status indicating whether a pool is available to create Dev Boxes."""

    UNKNOWN = "Unknown"
    """The pool health status is not known."""
    PENDING = "Pending"
    """The pool health status waiting for health checks to run."""
    HEALTHY = "Healthy"
    """The pool health status is healthy."""
    WARNING = "Warning"
    """The pool health status has one or more warnings."""
    UNHEALTHY = "Unhealthy"
    """The pool health status is not healthy."""


class PowerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The power states of a Dev Box."""

    UNKNOWN = "Unknown"
    """The Dev Box power state is not known."""
    RUNNING = "Running"
    """The Dev Box is running."""
    DEALLOCATED = "Deallocated"
    """The Dev Box is deallocated."""
    POWERED_OFF = "PoweredOff"
    """The Dev Box is powered off."""
    HIBERNATED = "Hibernated"
    """The Dev Box is hibernated."""


class ScheduledFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The frequency of task execution."""

    DAILY = "Daily"
    """The scheduled task will run every day."""


class ScheduledType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The supported types for a scheduled task."""

    STOP_DEV_BOX = "StopDevBox"
    """The scheduled task will stop impacted Dev Boxes."""


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the Dev Box compute."""

    GENERAL_I_8C32GB256SSD_V2 = "general_i_8c32gb256ssd_v2"
    """Intel, 8 vCPU, 32 GB RAM, 256 GB Storage."""
    GENERAL_I_8C32GB512SSD_V2 = "general_i_8c32gb512ssd_v2"
    """Intel, 8 vCPU, 32 GB RAM, 512 GB Storage."""
    GENERAL_I_8C32GB1024SSD_V2 = "general_i_8c32gb1024ssd_v2"
    """Intel, 8 vCPU, 32 GB RAM, 1024 GB Storage."""
    GENERAL_I_8C32GB2048SSD_V2 = "general_i_8c32gb2048ssd_v2"
    """Intel, 8 vCPU, 32 GB RAM, 2048 GB Storage."""
    GENERAL_I_16C64GB256SSD_V2 = "general_i_16c64gb256ssd_v2"
    """Intel, 16 vCPU, 64 GB RAM, 256 GB Storage."""
    GENERAL_I_16C64GB512SSD_V2 = "general_i_16c64gb512ssd_v2"
    """Intel, 16 vCPU, 64 GB RAM, 512 GB Storage."""
    GENERAL_I_16C64GB1024SSD_V2 = "general_i_16c64gb1024ssd_v2"
    """Intel, 16 vCPU, 64 GB RAM, 1024 GB Storage."""
    GENERAL_I_16C64GB2048SSD_V2 = "general_i_16c64gb2048ssd_v2"
    """Intel, 16 vCPU, 64 GB RAM, 2048 GB Storage."""
    GENERAL_I_32C128GB512SSD_V2 = "general_i_32c128gb512ssd_v2"
    """Intel, 32 vCPU, 128 GB RAM, 512 GB Storage."""
    GENERAL_I_32C128GB1024SSD_V2 = "general_i_32c128gb1024ssd_v2"
    """Intel, 32 vCPU, 128 GB RAM, 1024 GB Storage."""
    GENERAL_I_32C128GB2048SSD_V2 = "general_i_32c128gb2048ssd_v2"
    """Intel, 32 vCPU, 128 GB RAM, 2048 GB Storage."""
    GENERAL_A_8C32GB256SSD_V2 = "general_a_8c32gb256ssd_v2"
    """AMD, 8 vCPU, 32 GB RAM, 256 GB Storage."""
    GENERAL_A_8C32GB512SSD_V2 = "general_a_8c32gb512ssd_v2"
    """AMD, 8 vCPU, 32 GB RAM, 512 GB Storage."""
    GENERAL_A_8C32GB1024SSD_V2 = "general_a_8c32gb1024ssd_v2"
    """AMD, 8 vCPU, 32 GB RAM, 1024 GB Storage."""
    GENERAL_A_8C32GB2048SSD_V2 = "general_a_8c32gb2048ssd_v2"
    """AMD, 8 vCPU, 32 GB RAM, 2048 GB Storage."""
    GENERAL_A_16C64GB256SSD_V2 = "general_a_16c64gb256ssd_v2"
    """AMD, 16 vCPU, 64 GB RAM, 256 GB Storage."""
    GENERAL_A_16C64GB512SSD_V2 = "general_a_16c64gb512ssd_v2"
    """AMD, 16 vCPU, 64 GB RAM, 512 GB Storage."""
    GENERAL_A_16C64GB1024SSD_V2 = "general_a_16c64gb1024ssd_v2"
    """AMD, 16 vCPU, 64 GB RAM, 1024 GB Storage."""
    GENERAL_A_16C64GB2048SSD_V2 = "general_a_16c64gb2048ssd_v2"
    """AMD, 16 vCPU, 64 GB RAM, 2048 GB Storage."""
    GENERAL_A_32C128GB512SSD_V2 = "general_a_32c128gb512ssd_v2"
    """AMD, 32 vCPU, 128 GB RAM, 512 GB Storage."""
    GENERAL_A_32C128GB1024SSD_V2 = "general_a_32c128gb1024ssd_v2"
    """AMD, 32 vCPU, 128 GB RAM, 1024 GB Storage."""
    GENERAL_A_32C128GB2048SSD_V2 = "general_a_32c128gb2048ssd_v2"
    """AMD, 32 vCPU, 128 GB RAM, 2048 GB Storage."""


class StopOnDisconnectStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the feature to stop the devbox on disconnect once the grace period has lapsed
    is enabled.
    """

    ENABLED = "Enabled"
    """Stop on disconnect is enabled on the Dev Box."""
    DISABLED = "Disabled"
    """Stop on disconnect is not enabled on the Dev Box."""
