# Coq Code of Conduct #

The Coq development team and the user community are made up of a mixture of
professionals and volunteers from all over the world.
Diversity brings variety of perspectives that can be very valuable, but it can
also lead to communication issues and unhappiness. Therefore, we have a few
ground rules that we ask people to adhere to.
These rules apply equally to core developers (who should lead by example),
occasional contributors and those seeking help and guidance.
Their goal is that everyone feels safe and welcome when contributing to Coq or
interacting with others in Coq related forums.

These rules apply to all spaces managed by the Coq development team.
This includes the GitHub repository, the Discourse forum, the Zulip chat, the mailing lists,
physical events like Coq working groups and workshops, and any other forums
created or managed by the development team which the community uses for
communication. In addition, violations of these rules outside these spaces may
affect a person's ability to participate within them.

- **Be friendly and patient.**
- **Be welcoming.**
  We strive to be a community that welcomes and supports people of all
  backgrounds and identities. This includes, but is not limited to people of
  any origin, color, status, educational level, gender identity, sexual
  orientation, age, culture and beliefs, and mental and physical ability.
- **Be considerate.**
  Your work will be used by other people, and you in turn will depend on the
  work of others. Any decision you take will affect users and colleagues, and
  you should take those consequences into account when making decisions.
- **Be respectful.**
  Not all of us will agree all the time, but disagreement is no excuse for poor
  behavior and poor manners. We might all experience some frustration now and
  then, but we cannot allow that frustration to turn into a personal attack.
  It's important to remember that a community where people feel uncomfortable
  or threatened is not a productive one. Members of the Coq development team
  and user community should be respectful when dealing with other members as
  well as with people outside the community.
- **Be careful in the words that you choose.**
  Be kind to others. Do not insult or put down other participants. Harassment
  and other exclusionary behavior aren't acceptable.
  * Violent language or threats or personal insults have no chance to
    resolve a dispute or to let a discussion flourish. Worse, they can
    hurt durably, or generate durable fears. They are thus unwelcome.
  * Not everyone is comfortable with sexually explicit or violent
    material, even as a joke. In an online open multicultural world, you
    don't know who might be listening. So be cautious and responsible
    with your words.
  * Discussions are online and recorded for posterity; we all have our
    right for privacy and online gossiping as well as posting or threatening to
    post other people's personally identifying information is prohibited.
- **Remember that what you write in a public online forum might be read by
  many people you don't know.**
  Consider what image your words will give to outsiders of the development
  team / the user community as a whole. Try to avoid references to private
  knowledge to be understandable by anyone.
- **Coq online forums are only to discuss Coq-related subjects.**
  Unrelated political discussions or long digressions are unwelcome,
  even for illustration or comparison purposes.
- **When we disagree, try to understand why.**
  Disagreements, both social and technical, happen all the time and Coq is no
  exception. It is important that we resolve disagreements and differing views
  constructively. Remember that we are different. Different people
  have different perspectives on issues. Being unable to understand why someone
  holds a viewpoint doesn't mean that they're wrong.
- **It is human to make errors, and please try not to take things personally.**
  Please do not answer aggressively to problematic behavior and simply
  signal the issue. If actions have been taken with you (e.g. bans or simple
  demands of apology, of rephrasing or keeping personal beliefs or troubles
  private), please understand that they are not intended as aggression or
  punishment ― even if they feel harsh to you ― but as ways to enforce a
  calm communication for the other participants and to give you the opportunity
  to change your behavior. We understand you may feel hurt, or maybe you had a
  bad day, so please take this opportunity to question yourself, cool down if
  necessary and do not persist in the exact same behavior you have been
  reported for.


## Interaction on Coq forums (Zulip, Discourse, etc.) ##

Anyone is welcome to ask questions and bring answers, provided they
respect the aforementioned rules. In addition we ask that
- you do your best to put your questions into their context by
  providing Coq code or pointers to it, and enough indications to
  understand where the Coq goals or error message come from.
- if you are running through educational material, we kindly ask you
  to explicitly state it, and that answers do not solve such exercises
  for you, but only provide hints.

Admins and moderators will, at their discretion, review and remove
some content, and provide indications or warnings to users. Repeatedly
not taking into accounts these warnings may result into a temporary or
permanent ban.

Based on forum histories, short technical questions with brief code examples
in the proper context are the most likely to receive useful answers. In
contrast, long and open-ended questions or comments usually see less engagement.
This is not to say that long questions or comments that otherwise abide by the
rules are discouraged, only that users should carefully set expectations about
what answers they are likely to receive.

## Enforcement ##

If you believe someone is violating the code of conduct, we ask that you report
it by emailing the Coq Code of Conduct enforcement team at
<coq-conduct@inria.fr> or, at your discretion, any member of the team.
Confidentiality with regard to the reporter of an
incident will be maintained while dealing with it.

In particular, you should seek support from the team instead of dealing by
yourself with a behavior that you consider hurtful. This applies to members of
the enforcement team as well, who shouldn't deal by themselves with violations
in discussions in which they are a participant.

Depending on the violation, the team can choose to address a private or public
warning to the offender, request an apology, or ban them for a short or a long
period from interacting on one or all of our forums.

Except in case of serious violations, the team will always try a pedagogical
approach first (the offender does not necessarily realize immediately why their
behavior is wrong). We consider short bans to form part of the pedagogical
approach, especially when they come with explanatory comments, as this can give
some time to the offender to calm down and think about their actions.

The members of the team are currently:

- Matthieu Sozeau
- Nicolas Tabareau
- Théo Zimmermann

## Questions? ##

If you have questions, feel free to write to <coq-conduct@inria.fr>.

## Attribution ##

This text is adapted from the [Django Code of Conduct][django-code-of-conduct]
which itself was adapted from the Speak Up! Community Code of Conduct.

## License ##

<a rel="license" href="http://creativecommons.org/licenses/by/4.0/">
<img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by/4.0/88x31.png">
</a><br>
This work is licensed under a
<a rel="license" href="http://creativecommons.org/licenses/by/4.0/">
Creative Commons Attribution 4.0 International License
</a>.

[django-code-of-conduct]: https://web.archive.org/web/20180714161115/https://www.djangoproject.com/conduct/
