/*
 * Copyright (c) 2022, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SPM_REG_H
#define SPM_REG_H

#include <platform_def.h>

/* Register_SPM_CFG */
#define MD32PCM_CFG_BASE                (SPM_BASE + 0xA00)
#define POWERON_CONFIG_EN               (SPM_BASE + 0x000)
#define SPM_POWER_ON_VAL0               (SPM_BASE + 0x004)
#define SPM_POWER_ON_VAL1               (SPM_BASE + 0x008)
#define SPM_CLK_CON                     (SPM_BASE + 0x00C)
#define SPM_CLK_SETTLE                  (SPM_BASE + 0x010)
#define SPM_AP_STANDBY_CON              (SPM_BASE + 0x014)
#define PCM_CON0                        (SPM_BASE + 0x018)
#define PCM_CON1                        (SPM_BASE + 0x01C)
#define SPM_POWER_ON_VAL2               (SPM_BASE + 0x020)
#define SPM_POWER_ON_VAL3               (SPM_BASE + 0x024)
#define PCM_REG_DATA_INI                (SPM_BASE + 0x028)
#define PCM_PWR_IO_EN                   (SPM_BASE + 0x02C)
#define PCM_TIMER_VAL                   (SPM_BASE + 0x030)
#define PCM_WDT_VAL                     (SPM_BASE + 0x034)
#define SPM_SW_RST_CON                  (SPM_BASE + 0x040)
#define SPM_SW_RST_CON_SET              (SPM_BASE + 0x044)
#define SPM_SW_RST_CON_CLR              (SPM_BASE + 0x048)
#define SPM_ARBITER_EN                  (SPM_BASE + 0x050)
#define SCPSYS_CLK_CON                  (SPM_BASE + 0x054)
#define SPM_SRAM_RSV_CON                (SPM_BASE + 0x058)
#define SPM_SWINT                       (SPM_BASE + 0x05C)
#define SPM_SWINT_SET                   (SPM_BASE + 0x060)
#define SPM_SWINT_CLR                   (SPM_BASE + 0x064)
#define SPM_SCP_MAILBOX                 (SPM_BASE + 0x068)
#define SCP_SPM_MAILBOX                 (SPM_BASE + 0x06C)
#define SPM_SCP_IRQ                     (SPM_BASE + 0x070)
#define SPM_CPU_WAKEUP_EVENT            (SPM_BASE + 0x074)
#define SPM_IRQ_MASK                    (SPM_BASE + 0x078)
#define SPM_SRC_REQ                     (SPM_BASE + 0x080)
#define SPM_SRC_MASK                    (SPM_BASE + 0x084)
#define SPM_SRC2_MASK                   (SPM_BASE + 0x088)
#define SPM_SRC3_MASK                   (SPM_BASE + 0x090)
#define SPM_SRC4_MASK                   (SPM_BASE + 0x094)
#define SPM_WAKEUP_EVENT_MASK2          (SPM_BASE + 0x098)
#define SPM_WAKEUP_EVENT_MASK           (SPM_BASE + 0x09C)
#define SPM_WAKEUP_EVENT_SENS           (SPM_BASE + 0x0A0)
#define SPM_WAKEUP_EVENT_CLEAR          (SPM_BASE + 0x0A4)
#define SPM_WAKEUP_EVENT_EXT_MASK       (SPM_BASE + 0x0A8)
#define SCP_CLK_CON                     (SPM_BASE + 0x0AC)
#define PCM_DEBUG_CON                   (SPM_BASE + 0x0B0)
#define DDREN_DBC_CON                   (SPM_BASE + 0x0B4)
#define SPM_RESOURCE_ACK_CON0           (SPM_BASE + 0x0B8)
#define SPM_RESOURCE_ACK_CON1           (SPM_BASE + 0x0BC)
#define SPM_RESOURCE_ACK_CON2           (SPM_BASE + 0x0C0)
#define SPM_RESOURCE_ACK_CON3           (SPM_BASE + 0x0C4)
#define SPM_RESOURCE_ACK_CON4           (SPM_BASE + 0x0C8)
#define SPM_SRAM_CON                    (SPM_BASE + 0x0CC)
#define PCM_REG0_DATA                   (SPM_BASE + 0x100)
#define PCM_REG2_DATA                   (SPM_BASE + 0x104)
#define PCM_REG6_DATA                   (SPM_BASE + 0x108)
#define PCM_REG7_DATA                   (SPM_BASE + 0x10C)
#define PCM_REG13_DATA                  (SPM_BASE + 0x110)
#define SRC_REQ_STA_0                   (SPM_BASE + 0x114)
#define SRC_REQ_STA_1                   (SPM_BASE + 0x118)
#define SRC_REQ_STA_2                   (SPM_BASE + 0x120)
#define SRC_REQ_STA_3                   (SPM_BASE + 0x124)
#define SRC_REQ_STA_4                   (SPM_BASE + 0x128)
#define PCM_TIMER_OUT                   (SPM_BASE + 0x130)
#define PCM_WDT_OUT                     (SPM_BASE + 0x134)
#define SPM_IRQ_STA                     (SPM_BASE + 0x138)
#define MD32PCM_WAKEUP_STA              (SPM_BASE + 0x13C)
#define MD32PCM_EVENT_STA               (SPM_BASE + 0x140)
#define SPM_WAKEUP_STA                  (SPM_BASE + 0x144)
#define SPM_WAKEUP_EXT_STA              (SPM_BASE + 0x148)
#define SPM_WAKEUP_MISC                 (SPM_BASE + 0x14C)
#define MM_DVFS_HALT                    (SPM_BASE + 0x150)
#define SUBSYS_IDLE_STA                 (SPM_BASE + 0x164)
#define PCM_STA                         (SPM_BASE + 0x168)
#define PWR_STATUS                      (SPM_BASE + 0x16C)
#define PWR_STATUS_2ND                  (SPM_BASE + 0x170)
#define CPU_PWR_STATUS                  (SPM_BASE + 0x174)
#define CPU_PWR_STATUS_2ND              (SPM_BASE + 0x178)
#define SPM_VTCXO_EVENT_COUNT_STA       (SPM_BASE + 0x17C)
#define SPM_INFRA_EVENT_COUNT_STA       (SPM_BASE + 0x180)
#define SPM_VRF18_EVENT_COUNT_STA       (SPM_BASE + 0x184)
#define SPM_APSRC_EVENT_COUNT_STA       (SPM_BASE + 0x188)
#define SPM_DDREN_EVENT_COUNT_STA       (SPM_BASE + 0x18C)
#define MD32PCM_STA                     (SPM_BASE + 0x190)
#define MD32PCM_PC                      (SPM_BASE + 0x194)
#define OTHER_PWR_STATUS                (SPM_BASE + 0x198)
#define DVFSRC_EVENT_STA                (SPM_BASE + 0x19C)
#define BUS_PROTECT_RDY                 (SPM_BASE + 0x1A0)
#define BUS_PROTECT1_RDY                (SPM_BASE + 0x1A4)
#define BUS_PROTECT2_RDY                (SPM_BASE + 0x1A8)
#define BUS_PROTECT3_RDY                (SPM_BASE + 0x1AC)
#define BUS_PROTECT4_RDY                (SPM_BASE + 0x1B0)
#define BUS_PROTECT5_RDY                (SPM_BASE + 0x1B4)
#define BUS_PROTECT6_RDY                (SPM_BASE + 0x1B8)
#define BUS_PROTECT7_RDY                (SPM_BASE + 0x1BC)
#define BUS_PROTECT8_RDY                (SPM_BASE + 0x1C0)
#define BUS_PROTECT9_RDY                (SPM_BASE + 0x1C4)
#define SPM_TWAM_LAST_STA0              (SPM_BASE + 0x1D0)
#define SPM_TWAM_LAST_STA1              (SPM_BASE + 0x1D4)
#define SPM_TWAM_LAST_STA2              (SPM_BASE + 0x1D8)
#define SPM_TWAM_LAST_STA3              (SPM_BASE + 0x1DC)
#define SPM_TWAM_CURR_STA0              (SPM_BASE + 0x1E0)
#define SPM_TWAM_CURR_STA1              (SPM_BASE + 0x1E4)
#define SPM_TWAM_CURR_STA2              (SPM_BASE + 0x1E8)
#define SPM_TWAM_CURR_STA3              (SPM_BASE + 0x1EC)
#define SPM_TWAM_TIMER_OUT              (SPM_BASE + 0x1F0)
#define SPM_CG_CHECK_STA                (SPM_BASE + 0x1F4)
#define SPM_DVFS_STA                    (SPM_BASE + 0x1F8)
#define SPM_DVFS_OPP_STA                (SPM_BASE + 0x1FC)
#define CPUEB_PWR_CON                   (SPM_BASE + 0x200)
#define SPM_MCUSYS_PWR_CON              (SPM_BASE + 0x204)
#define SPM_CPUTOP_PWR_CON              (SPM_BASE + 0x208)
#define SPM_CPU0_PWR_CON                (SPM_BASE + 0x20C)
#define SPM_CPU1_PWR_CON                (SPM_BASE + 0x210)
#define SPM_CPU2_PWR_CON                (SPM_BASE + 0x214)
#define SPM_CPU3_PWR_CON                (SPM_BASE + 0x218)
#define SPM_CPU4_PWR_CON                (SPM_BASE + 0x21C)
#define SPM_CPU5_PWR_CON                (SPM_BASE + 0x220)
#define SPM_CPU6_PWR_CON                (SPM_BASE + 0x224)
#define SPM_CPU7_PWR_CON                (SPM_BASE + 0x228)
#define ARMPLL_CLK_CON                  (SPM_BASE + 0x22C)
#define MCUSYS_IDLE_STA                 (SPM_BASE + 0x230)
#define GIC_WAKEUP_STA                  (SPM_BASE + 0x234)
#define CPU_SPARE_CON                   (SPM_BASE + 0x238)
#define CPU_SPARE_CON_SET               (SPM_BASE + 0x23C)
#define CPU_SPARE_CON_CLR               (SPM_BASE + 0x240)
#define ARMPLL_CLK_SEL                  (SPM_BASE + 0x244)
#define EXT_INT_WAKEUP_REQ              (SPM_BASE + 0x248)
#define EXT_INT_WAKEUP_REQ_SET          (SPM_BASE + 0x24C)
#define EXT_INT_WAKEUP_REQ_CLR          (SPM_BASE + 0x250)
#define CPU_IRQ_MASK                    (SPM_BASE + 0x260)
#define CPU_IRQ_MASK_SET                (SPM_BASE + 0x264)
#define CPU_IRQ_MASK_CLR                (SPM_BASE + 0x268)
#define CPU_WFI_EN                      (SPM_BASE + 0x280)
#define CPU_WFI_EN_SET                  (SPM_BASE + 0x284)
#define CPU_WFI_EN_CLR                  (SPM_BASE + 0x288)
#define SYSRAM_CON                      (SPM_BASE + 0x290)
#define SYSROM_CON                      (SPM_BASE + 0x294)
#define ROOT_CPUTOP_ADDR                (SPM_BASE + 0x2A0)
#define ROOT_CORE_ADDR                  (SPM_BASE + 0x2A4)
#define SPM2SW_MAILBOX_0                (SPM_BASE + 0x2D0)
#define SPM2SW_MAILBOX_1                (SPM_BASE + 0x2D4)
#define SPM2SW_MAILBOX_2                (SPM_BASE + 0x2D8)
#define SPM2SW_MAILBOX_3                (SPM_BASE + 0x2DC)
#define SW2SPM_INT                      (SPM_BASE + 0x2E0)
#define SW2SPM_INT_SET                  (SPM_BASE + 0x2E4)
#define SW2SPM_INT_CLR                  (SPM_BASE + 0x2E8)
#define SW2SPM_MAILBOX_0                (SPM_BASE + 0x2EC)
#define SW2SPM_MAILBOX_1                (SPM_BASE + 0x2F0)
#define SW2SPM_MAILBOX_2                (SPM_BASE + 0x2F4)
#define SW2SPM_MAILBOX_3                (SPM_BASE + 0x2F8)
#define SW2SPM_CFG                      (SPM_BASE + 0x2FC)
#define MFG0_PWR_CON                    (SPM_BASE + 0x300)
#define MFG1_PWR_CON                    (SPM_BASE + 0x304)
#define MFG2_PWR_CON                    (SPM_BASE + 0x308)
#define MFG3_PWR_CON                    (SPM_BASE + 0x30C)
#define MFG4_PWR_CON                    (SPM_BASE + 0x310)
#define MFG5_PWR_CON                    (SPM_BASE + 0x314)
#define IFR_PWR_CON                     (SPM_BASE + 0x318)
#define IFR_SUB_PWR_CON                 (SPM_BASE + 0x31C)
#define PERI_PWR_CON                    (SPM_BASE + 0x320)
#define PEXTP_MAC_TOP_P0_PWR_CON        (SPM_BASE + 0x324)
#define PEXTP_PHY_TOP_PWR_CON           (SPM_BASE + 0x328)
#define APHY_N_PWR_CON                  (SPM_BASE + 0x32C)
#define APHY_S_PWR_CON                  (SPM_BASE + 0x330)
#define ETHER_PWR_CON                   (SPM_BASE + 0x338)
#define DPY0_PWR_CON                    (SPM_BASE + 0x33C)
#define DPY1_PWR_CON                    (SPM_BASE + 0x340)
#define DPM0_PWR_CON                    (SPM_BASE + 0x344)
#define DPM1_PWR_CON                    (SPM_BASE + 0x348)
#define AUDIO_PWR_CON                   (SPM_BASE + 0x34C)
#define AUDIO_ASRC_PWR_CON              (SPM_BASE + 0x350)
#define ADSP_PWR_CON                    (SPM_BASE + 0x354)
#define ADSP_INFRA_PWR_CON              (SPM_BASE + 0x358)
#define ADSP_AO_PWR_CON                 (SPM_BASE + 0x35C)
#define VPPSYS0_PWR_CON                 (SPM_BASE + 0x360)
#define VPPSYS1_PWR_CON                 (SPM_BASE + 0x364)
#define VDOSYS0_PWR_CON                 (SPM_BASE + 0x368)
#define VDOSYS1_PWR_CON                 (SPM_BASE + 0x36C)
#define WPESYS_PWR_CON                  (SPM_BASE + 0x370)
#define DP_TX_PWR_CON                   (SPM_BASE + 0x374)
#define EDP_TX_PWR_CON                  (SPM_BASE + 0x378)
#define HDMI_TX_PWR_CON                 (SPM_BASE + 0x37C)
#define VDE0_PWR_CON                    (SPM_BASE + 0x380)
#define VDE1_PWR_CON                    (SPM_BASE + 0x384)
#define VDE2_PWR_CON                    (SPM_BASE + 0x388)
#define VEN_PWR_CON                     (SPM_BASE + 0x38C)
#define VEN_CORE1_PWR_CON               (SPM_BASE + 0x390)
#define CAM_MAIN_PWR_CON                (SPM_BASE + 0x394)
#define CAM_SUBA_PWR_CON                (SPM_BASE + 0x398)
#define CAM_SUBB_PWR_CON                (SPM_BASE + 0x39C)
#define CAM_VCORE_PWR_CON               (SPM_BASE + 0x3A0)
#define IMG_VCORE_PWR_CON               (SPM_BASE + 0x3A4)
#define IMG_MAIN_PWR_CON                (SPM_BASE + 0x3A8)
#define IMG_DIP_PWR_CON                 (SPM_BASE + 0x3AC)
#define IMG_IPE_PWR_CON                 (SPM_BASE + 0x3B0)
#define NNA0_PWR_CON                    (SPM_BASE + 0x3B4)
#define NNA1_PWR_CON                    (SPM_BASE + 0x3B8)
#define IPNNA_PWR_CON                   (SPM_BASE + 0x3C0)
#define CSI_RX_TOP_PWR_CON              (SPM_BASE + 0x3C4)
#define SSPM_SRAM_CON                   (SPM_BASE + 0x3CC)
#define SCP_SRAM_CON                    (SPM_BASE + 0x3D0)
#define DEVAPC_IFR_SRAM_CON             (SPM_BASE + 0x3D8)
#define DEVAPC_SUBIFR_SRAM_CON          (SPM_BASE + 0x3DC)
#define DEVAPC_ACP_SRAM_CON             (SPM_BASE + 0x3E0)
#define USB_SRAM_CON                    (SPM_BASE + 0x3E4)
#define DUMMY_SRAM_CON                  (SPM_BASE + 0x3E8)
#define EXT_BUCK_ISO                    (SPM_BASE + 0x3EC)
#define MSDC_SRAM_CON                   (SPM_BASE + 0x3F0)
#define DEBUGTOP_SRAM_CON               (SPM_BASE + 0x3F4)
#define DPMAIF_SRAM_CON                 (SPM_BASE + 0x3F8)
#define GCPU_SRAM_CON                   (SPM_BASE + 0x3FC)
#define SPM_MEM_CK_SEL                  (SPM_BASE + 0x400)
#define SPM_BUS_PROTECT_MASK_B          (SPM_BASE + 0x404)
#define SPM_BUS_PROTECT1_MASK_B         (SPM_BASE + 0x408)
#define SPM_BUS_PROTECT2_MASK_B         (SPM_BASE + 0x40C)
#define SPM_BUS_PROTECT3_MASK_B         (SPM_BASE + 0x410)
#define SPM_BUS_PROTECT4_MASK_B         (SPM_BASE + 0x414)
#define SPM_BUS_PROTECT5_MASK_B         (SPM_BASE + 0x418)
#define SPM_BUS_PROTECT6_MASK_B         (SPM_BASE + 0x41C)
#define SPM_BUS_PROTECT7_MASK_B         (SPM_BASE + 0x420)
#define SPM_BUS_PROTECT8_MASK_B         (SPM_BASE + 0x424)
#define SPM_BUS_PROTECT9_MASK_B         (SPM_BASE + 0x428)
#define SPM_EMI_BW_MODE                 (SPM_BASE + 0x42C)
#define SPM2MM_CON                      (SPM_BASE + 0x434)
#define SPM2CPUEB_CON                   (SPM_BASE + 0x438)
#define AP_MDSRC_REQ                    (SPM_BASE + 0x43C)
#define SPM2EMI_ENTER_ULPM              (SPM_BASE + 0x440)
#define SPM_PLL_CON                     (SPM_BASE + 0x444)
#define RC_SPM_CTRL                     (SPM_BASE + 0x448)
#define SPM_DRAM_MCU_SW_CON_0           (SPM_BASE + 0x44C)
#define SPM_DRAM_MCU_SW_CON_1           (SPM_BASE + 0x450)
#define SPM_DRAM_MCU_SW_CON_2           (SPM_BASE + 0x454)
#define SPM_DRAM_MCU_SW_CON_3           (SPM_BASE + 0x458)
#define SPM_DRAM_MCU_SW_CON_4           (SPM_BASE + 0x45C)
#define SPM_DRAM_MCU_STA_0              (SPM_BASE + 0x460)
#define SPM_DRAM_MCU_STA_1              (SPM_BASE + 0x464)
#define SPM_DRAM_MCU_STA_2              (SPM_BASE + 0x468)
#define SPM_DRAM_MCU_SW_SEL_0           (SPM_BASE + 0x46C)
#define RELAY_DVFS_LEVEL                (SPM_BASE + 0x470)
#define DRAMC_DPY_CLK_SW_CON_0          (SPM_BASE + 0x474)
#define DRAMC_DPY_CLK_SW_CON_1          (SPM_BASE + 0x478)
#define DRAMC_DPY_CLK_SW_CON_2          (SPM_BASE + 0x47C)
#define DRAMC_DPY_CLK_SW_CON_3          (SPM_BASE + 0x480)
#define DRAMC_DPY_CLK_SW_SEL_0          (SPM_BASE + 0x484)
#define DRAMC_DPY_CLK_SW_SEL_1          (SPM_BASE + 0x488)
#define DRAMC_DPY_CLK_SW_SEL_2          (SPM_BASE + 0x48C)
#define DRAMC_DPY_CLK_SW_SEL_3          (SPM_BASE + 0x490)
#define DRAMC_DPY_CLK_SPM_CON           (SPM_BASE + 0x494)
#define SPM_DVFS_LEVEL                  (SPM_BASE + 0x498)
#define SPM_CIRQ_CON                    (SPM_BASE + 0x49C)
#define SPM_DVFS_MISC                   (SPM_BASE + 0x4A0)
#define RG_MODULE_SW_CG_0_MASK_REQ_0    (SPM_BASE + 0x4A4)
#define RG_MODULE_SW_CG_0_MASK_REQ_1    (SPM_BASE + 0x4A8)
#define RG_MODULE_SW_CG_0_MASK_REQ_2    (SPM_BASE + 0x4AC)
#define RG_MODULE_SW_CG_1_MASK_REQ_0    (SPM_BASE + 0x4B0)
#define RG_MODULE_SW_CG_1_MASK_REQ_1    (SPM_BASE + 0x4B4)
#define RG_MODULE_SW_CG_1_MASK_REQ_2    (SPM_BASE + 0x4B8)
#define RG_MODULE_SW_CG_2_MASK_REQ_0    (SPM_BASE + 0x4BC)
#define RG_MODULE_SW_CG_2_MASK_REQ_1    (SPM_BASE + 0x4C0)
#define RG_MODULE_SW_CG_2_MASK_REQ_2    (SPM_BASE + 0x4C4)
#define RG_MODULE_SW_CG_3_MASK_REQ_0    (SPM_BASE + 0x4C8)
#define RG_MODULE_SW_CG_3_MASK_REQ_1    (SPM_BASE + 0x4CC)
#define RG_MODULE_SW_CG_3_MASK_REQ_2    (SPM_BASE + 0x4D0)
#define PWR_STATUS_MASK_REQ_0           (SPM_BASE + 0x4D4)
#define PWR_STATUS_MASK_REQ_1           (SPM_BASE + 0x4D8)
#define PWR_STATUS_MASK_REQ_2           (SPM_BASE + 0x4DC)
#define SPM_CG_CHECK_CON                (SPM_BASE + 0x4E0)
#define SPM_SRC_RDY_STA                 (SPM_BASE + 0x4E4)
#define SPM_DVS_DFS_LEVEL               (SPM_BASE + 0x4E8)
#define SPM_FORCE_DVFS                  (SPM_BASE + 0x4EC)
#define DRAMC_MCU_SRAM_CON              (SPM_BASE + 0x4F0)
#define DRAMC_MCU2_SRAM_CON             (SPM_BASE + 0x4F4)
#define DPY_SHU_SRAM_CON                (SPM_BASE + 0x4F8)
#define DPY_SHU2_SRAM_CON               (SPM_BASE + 0x4FC)
#define SPM_DPM_P2P_STA                 (SPM_BASE + 0x514)
#define SPM_DPM_P2P_CON                 (SPM_BASE + 0x518)
#define SPM_SW_FLAG_0                   (SPM_BASE + 0x600)
#define SPM_SW_DEBUG_0                  (SPM_BASE + 0x604)
#define SPM_SW_FLAG_1                   (SPM_BASE + 0x608)
#define SPM_SW_DEBUG_1                  (SPM_BASE + 0x60C)
#define SPM_SW_RSV_0                    (SPM_BASE + 0x610)
#define SPM_SW_RSV_1                    (SPM_BASE + 0x614)
#define SPM_SW_RSV_2                    (SPM_BASE + 0x618)
#define SPM_SW_RSV_3                    (SPM_BASE + 0x61C)
#define SPM_SW_RSV_4                    (SPM_BASE + 0x620)
#define SPM_SW_RSV_5                    (SPM_BASE + 0x624)
#define SPM_SW_RSV_6                    (SPM_BASE + 0x628)
#define SPM_SW_RSV_7                    (SPM_BASE + 0x62C)
#define SPM_SW_RSV_8                    (SPM_BASE + 0x630)
#define SPM_BK_WAKE_EVENT               (SPM_BASE + 0x634)
#define SPM_BK_VTCXO_DUR                (SPM_BASE + 0x638)
#define SPM_BK_WAKE_MISC                (SPM_BASE + 0x63C)
#define SPM_BK_PCM_TIMER                (SPM_BASE + 0x640)
#define ULPOSC_CON                      (SPM_BASE + 0x644)
#define SPM_RSV_CON_0                   (SPM_BASE + 0x650)
#define SPM_RSV_CON_1                   (SPM_BASE + 0x654)
#define SPM_RSV_STA_0                   (SPM_BASE + 0x658)
#define SPM_RSV_STA_1                   (SPM_BASE + 0x65C)
#define SPM_SPARE_CON                   (SPM_BASE + 0x660)
#define SPM_SPARE_CON_SET               (SPM_BASE + 0x664)
#define SPM_SPARE_CON_CLR               (SPM_BASE + 0x668)
#define SPM_CROSS_WAKE_M00_REQ          (SPM_BASE + 0x66C)
#define SPM_CROSS_WAKE_M01_REQ          (SPM_BASE + 0x670)
#define SPM_CROSS_WAKE_M02_REQ          (SPM_BASE + 0x674)
#define SPM_CROSS_WAKE_M03_REQ          (SPM_BASE + 0x678)
#define SCP_VCORE_LEVEL                 (SPM_BASE + 0x67C)
#define SC_MM_CK_SEL_CON                (SPM_BASE + 0x680)
#define SPARE_ACK_MASK                  (SPM_BASE + 0x684)
#define SPM_DV_CON_0                    (SPM_BASE + 0x68C)
#define SPM_DV_CON_1                    (SPM_BASE + 0x690)
#define SPM_DV_STA                      (SPM_BASE + 0x694)
#define CONN_XOWCN_DEBUG_EN             (SPM_BASE + 0x698)
#define SPM_SEMA_M0                     (SPM_BASE + 0x69C)
#define SPM_SEMA_M1                     (SPM_BASE + 0x6A0)
#define SPM_SEMA_M2                     (SPM_BASE + 0x6A4)
#define SPM_SEMA_M3                     (SPM_BASE + 0x6A8)
#define SPM_SEMA_M4                     (SPM_BASE + 0x6AC)
#define SPM_SEMA_M5                     (SPM_BASE + 0x6B0)
#define SPM_SEMA_M6                     (SPM_BASE + 0x6B4)
#define SPM_SEMA_M7                     (SPM_BASE + 0x6B8)
#define SPM2ADSP_MAILBOX                (SPM_BASE + 0x6BC)
#define ADSP2SPM_MAILBOX                (SPM_BASE + 0x6C0)
#define SPM_ADSP_IRQ                    (SPM_BASE + 0x6C4)
#define SPM_MD32_IRQ                    (SPM_BASE + 0x6C8)
#define SPM2PMCU_MAILBOX_0              (SPM_BASE + 0x6CC)
#define SPM2PMCU_MAILBOX_1              (SPM_BASE + 0x6D0)
#define SPM2PMCU_MAILBOX_2              (SPM_BASE + 0x6D4)
#define SPM2PMCU_MAILBOX_3              (SPM_BASE + 0x6D8)
#define PMCU2SPM_MAILBOX_0              (SPM_BASE + 0x6DC)
#define PMCU2SPM_MAILBOX_1              (SPM_BASE + 0x6E0)
#define PMCU2SPM_MAILBOX_2              (SPM_BASE + 0x6E4)
#define PMCU2SPM_MAILBOX_3              (SPM_BASE + 0x6E8)
#define SPM_AP_SEMA                     (SPM_BASE + 0x6F8)
#define SPM_SPM_SEMA                    (SPM_BASE + 0x6FC)
#define SPM_DVFS_CON                    (SPM_BASE + 0x700)
#define SPM_DVFS_CON_STA                (SPM_BASE + 0x704)
#define SPM_PMIC_SPMI_CON               (SPM_BASE + 0x708)
#define SPM_DVFS_CMD0                   (SPM_BASE + 0x710)
#define SPM_DVFS_CMD1                   (SPM_BASE + 0x714)
#define SPM_DVFS_CMD2                   (SPM_BASE + 0x718)
#define SPM_DVFS_CMD3                   (SPM_BASE + 0x71C)
#define SPM_DVFS_CMD4                   (SPM_BASE + 0x720)
#define SPM_DVFS_CMD5                   (SPM_BASE + 0x724)
#define SPM_DVFS_CMD6                   (SPM_BASE + 0x728)
#define SPM_DVFS_CMD7                   (SPM_BASE + 0x72C)
#define SPM_DVFS_CMD8                   (SPM_BASE + 0x730)
#define SPM_DVFS_CMD9                   (SPM_BASE + 0x734)
#define SPM_DVFS_CMD10                  (SPM_BASE + 0x738)
#define SPM_DVFS_CMD11                  (SPM_BASE + 0x73C)
#define SPM_DVFS_CMD12                  (SPM_BASE + 0x740)
#define SPM_DVFS_CMD13                  (SPM_BASE + 0x744)
#define SPM_DVFS_CMD14                  (SPM_BASE + 0x748)
#define SPM_DVFS_CMD15                  (SPM_BASE + 0x74C)
#define SPM_DVFS_CMD16                  (SPM_BASE + 0x750)
#define SPM_DVFS_CMD17                  (SPM_BASE + 0x754)
#define SPM_DVFS_CMD18                  (SPM_BASE + 0x758)
#define SPM_DVFS_CMD19                  (SPM_BASE + 0x75C)
#define SPM_DVFS_CMD20                  (SPM_BASE + 0x760)
#define SPM_DVFS_CMD21                  (SPM_BASE + 0x764)
#define SPM_DVFS_CMD22                  (SPM_BASE + 0x768)
#define SPM_DVFS_CMD23                  (SPM_BASE + 0x76C)
#define SYS_TIMER_VALUE_L               (SPM_BASE + 0x770)
#define SYS_TIMER_VALUE_H               (SPM_BASE + 0x774)
#define SYS_TIMER_START_L               (SPM_BASE + 0x778)
#define SYS_TIMER_START_H               (SPM_BASE + 0x77C)
#define SYS_TIMER_LATCH_L_00            (SPM_BASE + 0x780)
#define SYS_TIMER_LATCH_H_00            (SPM_BASE + 0x784)
#define SYS_TIMER_LATCH_L_01            (SPM_BASE + 0x788)
#define SYS_TIMER_LATCH_H_01            (SPM_BASE + 0x78C)
#define SYS_TIMER_LATCH_L_02            (SPM_BASE + 0x790)
#define SYS_TIMER_LATCH_H_02            (SPM_BASE + 0x794)
#define SYS_TIMER_LATCH_L_03            (SPM_BASE + 0x798)
#define SYS_TIMER_LATCH_H_03            (SPM_BASE + 0x79C)
#define SYS_TIMER_LATCH_L_04            (SPM_BASE + 0x7A0)
#define SYS_TIMER_LATCH_H_04            (SPM_BASE + 0x7A4)
#define SYS_TIMER_LATCH_L_05            (SPM_BASE + 0x7A8)
#define SYS_TIMER_LATCH_H_05            (SPM_BASE + 0x7AC)
#define SYS_TIMER_LATCH_L_06            (SPM_BASE + 0x7B0)
#define SYS_TIMER_LATCH_H_06            (SPM_BASE + 0x7B4)
#define SYS_TIMER_LATCH_L_07            (SPM_BASE + 0x7B8)
#define SYS_TIMER_LATCH_H_07            (SPM_BASE + 0x7BC)
#define SYS_TIMER_LATCH_L_08            (SPM_BASE + 0x7C0)
#define SYS_TIMER_LATCH_H_08            (SPM_BASE + 0x7C4)
#define SYS_TIMER_LATCH_L_09            (SPM_BASE + 0x7C8)
#define SYS_TIMER_LATCH_H_09            (SPM_BASE + 0x7CC)
#define SYS_TIMER_LATCH_L_10            (SPM_BASE + 0x7D0)
#define SYS_TIMER_LATCH_H_10            (SPM_BASE + 0x7D4)
#define SYS_TIMER_LATCH_L_11            (SPM_BASE + 0x7D8)
#define SYS_TIMER_LATCH_H_11            (SPM_BASE + 0x7DC)
#define SYS_TIMER_LATCH_L_12            (SPM_BASE + 0x7E0)
#define SYS_TIMER_LATCH_H_12            (SPM_BASE + 0x7E4)
#define SYS_TIMER_LATCH_L_13            (SPM_BASE + 0x7E8)
#define SYS_TIMER_LATCH_H_13            (SPM_BASE + 0x7EC)
#define SYS_TIMER_LATCH_L_14            (SPM_BASE + 0x7F0)
#define SYS_TIMER_LATCH_H_14            (SPM_BASE + 0x7F4)
#define SYS_TIMER_LATCH_L_15            (SPM_BASE + 0x7F8)
#define SYS_TIMER_LATCH_H_15            (SPM_BASE + 0x7FC)
#define PCM_WDT_LATCH_0                 (SPM_BASE + 0x800)
#define PCM_WDT_LATCH_1                 (SPM_BASE + 0x804)
#define PCM_WDT_LATCH_2                 (SPM_BASE + 0x808)
#define PCM_WDT_LATCH_3                 (SPM_BASE + 0x80C)
#define PCM_WDT_LATCH_4                 (SPM_BASE + 0x810)
#define PCM_WDT_LATCH_5                 (SPM_BASE + 0x814)
#define PCM_WDT_LATCH_6                 (SPM_BASE + 0x818)
#define PCM_WDT_LATCH_7                 (SPM_BASE + 0x81C)
#define PCM_WDT_LATCH_8                 (SPM_BASE + 0x820)
#define PCM_WDT_LATCH_9                 (SPM_BASE + 0x824)
#define PCM_WDT_LATCH_10                (SPM_BASE + 0x828)
#define PCM_WDT_LATCH_11                (SPM_BASE + 0x82C)
#define PCM_WDT_LATCH_12                (SPM_BASE + 0x830)
#define PCM_WDT_LATCH_13                (SPM_BASE + 0x834)
#define PCM_WDT_LATCH_14                (SPM_BASE + 0x838)
#define PCM_WDT_LATCH_15                (SPM_BASE + 0x83C)
#define PCM_WDT_LATCH_16                (SPM_BASE + 0x840)
#define PCM_WDT_LATCH_17                (SPM_BASE + 0x844)
#define PCM_WDT_LATCH_18                (SPM_BASE + 0x848)
#define PCM_WDT_LATCH_SPARE_0           (SPM_BASE + 0x84C)
#define PCM_WDT_LATCH_SPARE_1           (SPM_BASE + 0x850)
#define PCM_WDT_LATCH_SPARE_2           (SPM_BASE + 0x854)
#define DRAMC_GATING_ERR_LATCH_CH0_0    (SPM_BASE + 0x8A0)
#define DRAMC_GATING_ERR_LATCH_CH0_1    (SPM_BASE + 0x8A4)
#define DRAMC_GATING_ERR_LATCH_CH0_2    (SPM_BASE + 0x8A8)
#define DRAMC_GATING_ERR_LATCH_CH0_3    (SPM_BASE + 0x8AC)
#define DRAMC_GATING_ERR_LATCH_CH0_4    (SPM_BASE + 0x8B0)
#define DRAMC_GATING_ERR_LATCH_CH0_5    (SPM_BASE + 0x8B4)
#define DRAMC_GATING_ERR_LATCH_SPARE_0  (SPM_BASE + 0x8F4)
#define SPM_ACK_CHK_CON_0               (SPM_BASE + 0x900)
#define SPM_ACK_CHK_PC_0                (SPM_BASE + 0x904)
#define SPM_ACK_CHK_SEL_0               (SPM_BASE + 0x908)
#define SPM_ACK_CHK_TIMER_0             (SPM_BASE + 0x90C)
#define SPM_ACK_CHK_STA_0               (SPM_BASE + 0x910)
#define SPM_ACK_CHK_SWINT_0             (SPM_BASE + 0x914)
#define SPM_ACK_CHK_CON_1               (SPM_BASE + 0x920)
#define SPM_ACK_CHK_PC_1                (SPM_BASE + 0x924)
#define SPM_ACK_CHK_SEL_1               (SPM_BASE + 0x928)
#define SPM_ACK_CHK_TIMER_1             (SPM_BASE + 0x92C)
#define SPM_ACK_CHK_STA_1               (SPM_BASE + 0x930)
#define SPM_ACK_CHK_SWINT_1             (SPM_BASE + 0x934)
#define SPM_ACK_CHK_CON_2               (SPM_BASE + 0x940)
#define SPM_ACK_CHK_PC_2                (SPM_BASE + 0x944)
#define SPM_ACK_CHK_SEL_2               (SPM_BASE + 0x948)
#define SPM_ACK_CHK_TIMER_2             (SPM_BASE + 0x94C)
#define SPM_ACK_CHK_STA_2               (SPM_BASE + 0x950)
#define SPM_ACK_CHK_SWINT_2             (SPM_BASE + 0x954)
#define SPM_ACK_CHK_CON_3               (SPM_BASE + 0x960)
#define SPM_ACK_CHK_PC_3                (SPM_BASE + 0x964)
#define SPM_ACK_CHK_SEL_3               (SPM_BASE + 0x968)
#define SPM_ACK_CHK_TIMER_3             (SPM_BASE + 0x96C)
#define SPM_ACK_CHK_STA_3               (SPM_BASE + 0x970)
#define SPM_ACK_CHK_SWINT_3             (SPM_BASE + 0x974)
#define SPM_COUNTER_0                   (SPM_BASE + 0x978)
#define SPM_COUNTER_1                   (SPM_BASE + 0x97C)
#define SPM_COUNTER_2                   (SPM_BASE + 0x980)
#define SYS_TIMER_CON                   (SPM_BASE + 0x98C)
#define SPM_TWAM_CON                    (SPM_BASE + 0x990)
#define SPM_TWAM_WINDOW_LEN             (SPM_BASE + 0x994)
#define SPM_TWAM_IDLE_SEL               (SPM_BASE + 0x998)
#define SPM_TWAM_EVENT_CLEAR            (SPM_BASE + 0x99C)
#define PMSR_LAST_DAT                   (SPM_BASE + 0xF00)
#define PMSR_LAST_CNT                   (SPM_BASE + 0xF04)
#define PMSR_LAST_ACK                   (SPM_BASE + 0xF08)
#define SPM_PMSR_SEL_CON0               (SPM_BASE + 0xF10)
#define SPM_PMSR_SEL_CON1               (SPM_BASE + 0xF14)
#define SPM_PMSR_SEL_CON2               (SPM_BASE + 0xF18)
#define SPM_PMSR_SEL_CON3               (SPM_BASE + 0xF1C)
#define SPM_PMSR_SEL_CON4               (SPM_BASE + 0xF20)
#define SPM_PMSR_SEL_CON5               (SPM_BASE + 0xF24)
#define SPM_PMSR_SEL_CON6               (SPM_BASE + 0xF28)
#define SPM_PMSR_SEL_CON7               (SPM_BASE + 0xF2C)
#define SPM_PMSR_SEL_CON8               (SPM_BASE + 0xF30)
#define SPM_PMSR_SEL_CON9               (SPM_BASE + 0xF34)
#define SPM_PMSR_SEL_CON10              (SPM_BASE + 0xF3C)
#define SPM_PMSR_SEL_CON11              (SPM_BASE + 0xF40)
#define SPM_PMSR_TIEMR_STA0             (SPM_BASE + 0xFB8)
#define SPM_PMSR_TIEMR_STA1             (SPM_BASE + 0xFBC)
#define SPM_PMSR_TIEMR_STA2             (SPM_BASE + 0xFC0)
#define SPM_PMSR_GENERAL_CON0           (SPM_BASE + 0xFC4)
#define SPM_PMSR_GENERAL_CON1           (SPM_BASE + 0xFC8)
#define SPM_PMSR_GENERAL_CON2           (SPM_BASE + 0xFCC)
#define SPM_PMSR_GENERAL_CON3           (SPM_BASE + 0xFD0)
#define SPM_PMSR_GENERAL_CON4           (SPM_BASE + 0xFD4)
#define SPM_PMSR_GENERAL_CON5           (SPM_BASE + 0xFD8)
#define SPM_PMSR_SW_RESET               (SPM_BASE + 0xFDC)
#define SPM_PMSR_MON_CON0               (SPM_BASE + 0xFE0)
#define SPM_PMSR_MON_CON1               (SPM_BASE + 0xFE4)
#define SPM_PMSR_MON_CON2               (SPM_BASE + 0xFE8)
#define SPM_PMSR_LEN_CON0               (SPM_BASE + 0xFEC)
#define SPM_PMSR_LEN_CON1               (SPM_BASE + 0xFF0)
#define SPM_PMSR_LEN_CON2               (SPM_BASE + 0xFF4)

#endif /* SPM_REG_H */
