/*
 * Copyright (c) 2019-2023, Intel Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SOCFPGA_F2SDRAMMANAGER_H
#define SOCFPGA_F2SDRAMMANAGER_H

#include "socfpga_plat_def.h"

/* FPGA2SDRAM Register Map */
#define SOCFPGA_F2SDRAMMGR_SIDEBANDMGR_FLAGINSTATUS0	0x14
#define SOCFPGA_F2SDRAMMGR_SIDEBANDMGR_FLAGOUTCLR0	0x54
#define SOCFPGA_F2SDRAMMGR_SIDEBANDMGR_FLAGOUTSET0	0x50

#define FLAGOUTCLR0_F2SDRAM0_ENABLE		(BIT(8))
#define FLAGOUTSETCLR_F2SDRAM0_ENABLE		(BIT(1))
#define FLAGOUTSETCLR_F2SDRAM1_ENABLE		(BIT(4))
#define FLAGOUTSETCLR_F2SDRAM2_ENABLE		(BIT(7))

#define FLAGOUTSETCLR_F2SDRAM0_IDLEREQ		(BIT(0))
#define FLAGOUTSETCLR_F2SDRAM1_IDLEREQ		(BIT(3))
#define FLAGOUTSETCLR_F2SDRAM2_IDLEREQ		(BIT(6))
#define FLAGINSTATUS_F2SDRAM0_IDLEACK		(BIT(1))
#define FLAGINSTATUS_F2SDRAM1_IDLEACK		(BIT(5))
#define FLAGINSTATUS_F2SDRAM2_IDLEACK		(BIT(9))
#define FLAGINSTATUS_F2SDRAM0_CMDIDLE		(BIT(2))
#define FLAGINSTATUS_F2SDRAM1_CMDIDLE		(BIT(6))
#define FLAGINSTATUS_F2SDRAM2_CMDIDLE		(BIT(10))
#define FLAGINSTATUS_F2SDRAM0_NOCIDLE		(BIT(0))
#define FLAGINSTATUS_F2SDRAM1_NOCIDLE		(BIT(4))
#define FLAGINSTATUS_F2SDRAM2_NOCIDLE		(BIT(8))

#define FLAGOUTSETCLR_F2SDRAM0_FORCE_DRAIN	(BIT(2))
#define FLAGOUTSETCLR_F2SDRAM1_FORCE_DRAIN	(BIT(5))
#define FLAGOUTSETCLR_F2SDRAM2_FORCE_DRAIN	(BIT(8))

#define FLAGINSTATUS_F2SOC_RESPEMPTY		(BIT(3))
#define FLAGINSTATUS_F2SDRAM0_RESPEMPTY		(BIT(3))
#define FLAGINSTATUS_F2SDRAM1_RESPEMPTY		(BIT(7))
#define FLAGINSTATUS_F2SDRAM2_RESPEMPTY		(BIT(11))
#define FLAGINSTATUS_F2S_FM_TRACKERIDLE		(BIT(4))

#define SOCFPGA_F2SDRAMMGR(_reg)	(SOCFPGA_F2SDRAMMGR_REG_BASE \
						+ (SOCFPGA_F2SDRAMMGR_##_reg))

#endif /* SOCFPGA_F2SDRAMMGR_H */
