/*
 * Copyright (c) 2022-2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(ARM_COMPUTE_ENABLE_SME2)

#include <algorithm>
#include <cstddef>

namespace arm_conv {
namespace depthwise {

void sme2_fp32bf16fp32_planar_5x5_s2_4rows_dot_za_impl(
  const float *inptr,
  size_t ld_in_row,
  size_t ld_in_col,
  size_t ld_in_vl,
  unsigned int pad_top,
  unsigned int valid_input_rows,
  unsigned int pad_left,
  unsigned int valid_input_cols,
  const float *weights,
  const float *bias,
  float **outptrs,
  const size_t *outlds,
  const size_t *outvllds,
  unsigned int output_cols,
  unsigned int start_channel,
  unsigned int valid_channels,
  float act_min,
  float act_max
)
{
  struct Args
  {
    const float *inptr;
    size_t ld_in_vl;
    long unsigned int pad_top, pad_bottom, pad_left;
    const float *weights;
    const float *bias;
    long unsigned int input_cols, output_cols;
    float **outptrs;
    const size_t *ld_out_cols;
    const size_t *ld_out_vls;
    long unsigned int current_channel, n_channels;
    float clamp_min, clamp_max;
  };

  Args args = { inptr, ld_in_vl, pad_top, 11u - std::min(11u, pad_top + valid_input_rows), pad_left, weights, bias, valid_input_cols, output_cols, outptrs, outlds, outvllds, start_channel, valid_channels, act_min, act_max };

  __asm__ __volatile__(
    "ldr x3, [%x[args], %[offsetof_Args_pad_bottom]]\n"
    "mov x20, #0xb\n"
    ".inst 0xd503477f  // SMSTART ZA\n"
    "sub x20, x20, x3\n"
    "ldr x4, [%x[args], %[offsetof_Args_pad_top]]\n"
    "ptrue p2.b\n"
    ".inst 0x25207812  // ptrue pn10.b\n"
    "ld1rw { z13.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_min]]\n"
    "ldr x5, [%x[args], %[offsetof_Args_n_channels]]\n"
    "whilelt p1.s, XZR, x5\n"
    "whilelt p9.s, XZR, x20\n"
    "ld1rw { z12.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_max]]\n"
    "whilelt p8.s, XZR, x4\n"
    "addvl SP, SP, #-15\n"
    "ldr x6, [%x[args], %[offsetof_Args_current_channel]]\n"
    "eor p8.b, p2/Z, p8.b, p9.b\n"
    "1:"  // Channel loop
    "ldr x20, [%x[args], %[offsetof_Args_bias]]\n"
    "fmov z16.s, #0x0\n"
    "cbz x20, 2f\n"
    "ld1w { z16.s }, p1/Z, [x20, x6, LSL #2]\n"
    "2:"  // Load bias: Done
    "ldr x21, [%x[args], %[offsetof_Args_weights]]\n"
    "mov x20, x21\n"
    "ld1w { z31.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z8.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aabef  // bfcvt z15.h, p2/M, z31.s\n"
    "incb x21\n"
    "ld1w { z18.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aaa4e  // bfcvt z14.h, p2/M, z18.s\n"
    "addvl x24, SP, #15\n"
    "ld1w { z17.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aa90f  // bfcvtnt z15.h, p2/M, z8.s\n"
    "addvl x24, x24, #-3\n"
    "ld1w { z18.s }, p2/Z, [x20]\n"
    "mov x20, x21\n"
    "st1h { z15.h }, p2, [x24]\n"
    ".inst 0x648aaa2e  // bfcvtnt z14.h, p2/M, z17.s\n"
    "ld1w { z29.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aabb5  // bfcvt z21.h, p2/M, z29.s\n"
    "incb x21\n"
    "ld1w { z17.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z14.h }, p2, [x24, #1, MUL VL]\n"
    ".inst 0x658aaa58  // bfcvt z24.h, p2/M, z18.s\n"
    "ld1w { z26.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aab41  // bfcvt z1.h, p2/M, z26.s\n"
    ".inst 0x648aaa35  // bfcvtnt z21.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z24.h }, p2, [x24, #2, MUL VL]\n"
    "addvl x24, x24, #-3\n"
    "ld1w { z9.s }, p2/Z, [x20]\n"
    "mov x20, x21\n"
    "st1h { z21.h }, p2, [x24]\n"
    ".inst 0x648aaa21  // bfcvtnt z1.h, p2/M, z17.s\n"
    "ld1w { z3.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "incb x21\n"
    ".inst 0x658aa864  // bfcvt z4.h, p2/M, z3.s\n"
    "ld1w { z31.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aa92b  // bfcvt z11.h, p2/M, z9.s\n"
    "st1h { z1.h }, p2, [x24, #1, MUL VL]\n"
    "ld1w { z18.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aaa46  // bfcvt z6.h, p2/M, z18.s\n"
    "st1h { z11.h }, p2, [x24, #2, MUL VL]\n"
    "ld1w { z5.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "addvl x24, x24, #-3\n"
    ".inst 0x648aabe4  // bfcvtnt z4.h, p2/M, z31.s\n"
    "ld1w { z27.s }, p2/Z, [x20]\n"
    "mov x20, x21\n"
    "st1h { z4.h }, p2, [x24]\n"
    ".inst 0x648aa8a6  // bfcvtnt z6.h, p2/M, z5.s\n"
    "ld1w { z9.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aa938  // bfcvt z24.h, p2/M, z9.s\n"
    "incb x21\n"
    "ld1w { z17.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aab75  // bfcvt z21.h, p2/M, z27.s\n"
    "st1h { z6.h }, p2, [x24, #1, MUL VL]\n"
    "ld1w { z31.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aaa38  // bfcvtnt z24.h, p2/M, z17.s\n"
    ".inst 0x658aabf9  // bfcvt z25.h, p2/M, z31.s\n"
    "ld1w { z18.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ldr x7, [%x[args], %[offsetof_Args_input_cols]]\n"
    "st1h { z21.h }, p2, [x24, #2, MUL VL]\n"
    "ld1w { z11.s }, p2/Z, [x20]\n"
    "mov x21, x21\n"
    "addvl x24, x24, #-3\n"
    "st1h { z24.h }, p2, [x24]\n"
    "ld1w { z17.s }, p2/Z, [x21]\n"
    "incb x21, ALL, MUL #5\n"
    ".inst 0x648aaa59  // bfcvtnt z25.h, p2/M, z18.s\n"
    "st1h { z25.h }, p2, [x24, #1, MUL VL]\n"
    "ld1w { z8.s }, p2/Z, [x21]\n"
    "incb x21, ALL, MUL #5\n"
    ".inst 0x658aaa29  // bfcvt z9.h, p2/M, z17.s\n"
    ".inst 0x658aa976  // bfcvt z22.h, p2/M, z11.s\n"
    "ld1w { z28.s }, p2/Z, [x21]\n"
    "incb x21, ALL, MUL #5\n"
    ".inst 0x658aab85  // bfcvt z5.h, p2/M, z28.s\n"
    "ldr x17, [%x[args], %[offsetof_Args_inptr]]\n"
    "ld1w { z25.s }, p2/Z, [x21]\n"
    "incb x21, ALL, MUL #5\n"
    "sub x20, x7, #0x1\n"
    "st1h { z22.h }, p2, [x24, #2, MUL VL]\n"
    "ld1w { z11.s }, p2/Z, [x21]\n"
    "orr x23, x20, %x[ld_in_col], LSL #18\n"
    "addvl x24, x24, #-3\n"
    "mov z17.d, z16.d\n"
    "orr x23, x5, x23, LSL #20\n"
    "mov x22, #0xb\n"
    "mov z18.d, z16.d\n"
    "mov z19.d, z16.d\n"
    "add x21, x4, x3\n"
    "lsl x20, %x[ld_in_row], #0x2\n"
    ".inst 0x648aa909  // bfcvtnt z9.h, p2/M, z8.s\n"
    "st1h { z9.h }, p2, [x24]\n"
    ".inst 0x648aab25  // bfcvtnt z5.h, p2/M, z25.s\n"
    "st1h { z5.h }, p2, [x24, #1, MUL VL]\n"
    ".inst 0x658aa97b  // bfcvt z27.h, p2/M, z11.s\n"
    "mov x8, #0x0\n"
    "st1h { z27.h }, p2, [x24, #2, MUL VL]\n"
    "ldr x16, [%x[args], %[offsetof_Args_output_cols]]\n"
    "lsl x23, x23, #0x2\n"
    "sub x22, x22, x21\n"
    "madd x20, x20, x4, x17\n"
    "3:"  // Issue prefetches
    "subs x22, x22, #0x1\n"
    ".inst 0xf8b74a9c  // rprfm pldstrm, x23, [x20]\n"
    "add x20, x20, %x[ld_in_col], LSL #2\n"
    "bgt 3b\n"
    "ldr x23, [%x[args], %[offsetof_Args_outptrs]]\n"
    "lsl x20, %x[ld_in_row], #0x2\n"
    "msub x17, x4, x20, x17\n"
    ".inst 0xc0040e00  // mova za.d[x8, #0], { z16.d-z19.d }\n"
    "ldr x20, [%x[args], %[offsetof_Args_ld_out_cols]]\n"
    ".inst 0xc0040e01  // mova za.d[x8, #1], { z16.d-z19.d }\n"
    "mov x22, #0x4\n"
    "ldp x15, x14, [x23], #0x10\n"
    ".inst 0xc0040e02  // mova za.d[x8, #2], { z16.d-z19.d }\n"
    "ldp x13, x11, [x20], #0x10\n"
    ".inst 0xc0040e03  // mova za.d[x8, #3], { z16.d-z19.d }\n"
    "ldr x21, [%x[args], %[offsetof_Args_pad_left]]\n"
    ".inst 0xc0040e04  // mova za.d[x8, #4], { z16.d-z19.d }\n"
    "ldp x10, x9, [x23], #0x10\n"
    "ldp x28, x27, [x20], #0x10\n"
    "cbz x21, 5f\n"
    "cmp x21, x22\n"
    "csel x20, x21, x22, LT\n"
    "sub x21, x21, x20\n"
    "sub x22, x22, x20\n"
    "cbz x21, 5f\n"
    ".inst 0xc0060c04  // mova { z4.d-z7.d }, za.d[x8, #0]\n"
    "and x22, x21, #0x1\n"
    "add x21, x21, #0x1\n"
    ".inst 0xc1acc9a4  // fclamp { z4.s-z7.s }, z13.s, z12.s\n"
    "lsr x21, x21, #0x1\n"
    "sub x16, x16, x21\n"
    "4:"  // Left padding
    "subs x21, x21, #0x1\n"
    "st1w { z4.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    "st1w { z5.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z6.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z7.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "bgt 4b\n"
    "5:"  // Left padding: End
    "adds XZR, x4, x3\n"
    "bne 12f\n"
    "cbz x22, 10f\n"
    "cmp x22, #0x1\n"
    "sub x7, x7, x22\n"
    "beq 9f\n"
    "cmp x22, #0x2\n"
    "beq 8f\n"
    "cmp x22, #0x3\n"
    "beq 7f\n"
    "6:"  // Unpadded: 4 priming loads
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z0.s }, p1/Z, [x17]\n"
    ".inst 0x658aa816  // bfcvt z22.h, p2/M, z0.s\n"
    "addvl x20, SP, #12\n"
    "ld1w { z9.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa936  // bfcvtnt z22.h, p2/M, z9.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z28.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab97  // bfcvt z23.h, p2/M, z28.s\n"
    "ld1w { z20.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa97  // bfcvtnt z23.h, p2/M, z20.s\n"
    "ld1w { z20.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa98  // bfcvt z24.h, p2/M, z20.s\n"
    "ld1w { z29.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aabb8  // bfcvtnt z24.h, p2/M, z29.s\n"
    "ld1w { z30.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabd9  // bfcvt z25.h, p2/M, z30.s\n"
    "ld1w { z9.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa939  // bfcvtnt z25.h, p2/M, z9.s\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab5a  // bfcvt z26.h, p2/M, z26.s\n"
    ".inst 0xa1402a83  // ld1h { z3.h, z11.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc13312d0  // bfdot za.s[x8, 0], { z22.h-z25.h }, z3.h\n"
    "ld1w { z9.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa93a  // bfcvtnt z26.h, p2/M, z9.s\n"
    ".inst 0xc13b12f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z11.h\n"
    "ld1w { z9.s }, p1/Z, [x21]\n"
    ".inst 0x658aa93b  // bfcvt z27.h, p2/M, z9.s\n"
    "ld1h { z9.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1391310  // bfdot za.s[x8, 0], { z24.h-z27.h }, z9.h\n"
    "7:"  // Unpadded: 3 priming loads
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z27.s }, p1/Z, [x17]\n"
    ".inst 0x658aab7d  // bfcvt z29.h, p2/M, z27.s\n"
    "addvl x20, SP, #9\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab5d  // bfcvtnt z29.h, p2/M, z26.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z9.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa93e  // bfcvt z30.h, p2/M, z9.s\n"
    "ld1w { z20.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa9e  // bfcvtnt z30.h, p2/M, z20.s\n"
    "ld1w { z25.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab3f  // bfcvt z31.h, p2/M, z25.s\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab5f  // bfcvtnt z31.h, p2/M, z26.s\n"
    "ld1w { z27.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab60  // bfcvt z0.h, p2/M, z27.s\n"
    "ld1w { z9.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa920  // bfcvtnt z0.h, p2/M, z9.s\n"
    "ld1w { z23.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaae1  // bfcvt z1.h, p2/M, z23.s\n"
    ".inst 0xa0402a84  // ld1h { z4.h-z5.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc13413b0  // bfdot za.s[x8, 0], { z29.h-z0.h }, z4.h\n"
    "ld1w { z9.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa921  // bfcvtnt z1.h, p2/M, z9.s\n"
    ".inst 0xc13513d0  // bfdot za.s[x8, 0], { z30.h-z1.h }, z5.h\n"
    "ld1w { z29.s }, p1/Z, [x21]\n"
    ".inst 0x658aaba2  // bfcvt z2.h, p2/M, z29.s\n"
    "ld1h { z9.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc13913f0  // bfdot za.s[x8, 0], { z31.h-z2.h }, z9.h\n"
    "8:"  // Unpadded: 2 priming loads
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z27.s }, p1/Z, [x17]\n"
    ".inst 0x658aab7a  // bfcvt z26.h, p2/M, z27.s\n"
    "addvl x21, SP, #6\n"
    "ld1w { z21.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaaba  // bfcvtnt z26.h, p2/M, z21.s\n"
    "addvl x20, SP, #12\n"
    "ld1w { z25.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab3b  // bfcvt z27.h, p2/M, z25.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z4.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa89b  // bfcvtnt z27.h, p2/M, z4.s\n"
    "ld1w { z10.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa95c  // bfcvt z28.h, p2/M, z10.s\n"
    "ld1w { z4.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa89c  // bfcvtnt z28.h, p2/M, z4.s\n"
    "ld1w { z5.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8bd  // bfcvt z29.h, p2/M, z5.s\n"
    "ld1w { z5.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa8bd  // bfcvtnt z29.h, p2/M, z5.s\n"
    "ld1w { z5.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8be  // bfcvt z30.h, p2/M, z5.s\n"
    ".inst 0xa0402aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc13e1350  // bfdot za.s[x8, 0], { z26.h-z29.h }, z14.h\n"
    "ld1w { z5.s }, p1/Z, [x22]\n"
    ".inst 0x648aa8be  // bfcvtnt z30.h, p2/M, z5.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13f1370  // bfdot za.s[x8, 0], { z27.h-z30.h }, z15.h\n"
    ".inst 0xa0402a88  // ld1h { z8.h-z9.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1381351  // bfdot za.s[x8, 1], { z26.h-z29.h }, z8.h\n"
    "ld1w { z23.s }, p1/Z, [x22]\n"
    ".inst 0x658aaaff  // bfcvt z31.h, p2/M, z23.s\n"
    ".inst 0xc1391371  // bfdot za.s[x8, 1], { z27.h-z30.h }, z9.h\n"
    "ld1h { z0.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc1301390  // bfdot za.s[x8, 0], { z28.h-z31.h }, z0.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1301391  // bfdot za.s[x8, 1], { z28.h-z31.h }, z0.h\n"
    "9:"  // Unpadded: 1 priming loads
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z27.s }, p1/Z, [x17]\n"
    ".inst 0x658aab77  // bfcvt z23.h, p2/M, z27.s\n"
    "addvl x21, SP, #3\n"
    "ld1w { z24.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab17  // bfcvtnt z23.h, p2/M, z24.s\n"
    "addvl x20, SP, #9\n"
    "ld1w { z31.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabf8  // bfcvt z24.h, p2/M, z31.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z6.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa8d8  // bfcvtnt z24.h, p2/M, z6.s\n"
    "ld1w { z28.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab99  // bfcvt z25.h, p2/M, z28.s\n"
    "ld1w { z26.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab59  // bfcvtnt z25.h, p2/M, z26.s\n"
    "ld1w { z28.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab9a  // bfcvt z26.h, p2/M, z28.s\n"
    "ld1w { z4.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa89a  // bfcvtnt z26.h, p2/M, z4.s\n"
    "ld1w { z20.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa9b  // bfcvt z27.h, p2/M, z20.s\n"
    ".inst 0xa1402aa0  // ld1h { z0.h, z8.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc13012f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z0.h\n"
    "ld1w { z20.s }, p1/Z, [x22]\n"
    ".inst 0x648aaa9b  // bfcvtnt z27.h, p2/M, z20.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1381310  // bfdot za.s[x8, 0], { z24.h-z27.h }, z8.h\n"
    ".inst 0xa0402a82  // ld1h { z2.h-z3.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc13212f1  // bfdot za.s[x8, 1], { z23.h-z26.h }, z2.h\n"
    "ld1w { z11.s }, p1/Z, [x22]\n"
    ".inst 0x658aa97c  // bfcvt z28.h, p2/M, z11.s\n"
    ".inst 0xc1331311  // bfdot za.s[x8, 1], { z24.h-z27.h }, z3.h\n"
    "ld1h { z4.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc1341330  // bfdot za.s[x8, 0], { z25.h-z28.h }, z4.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1301331  // bfdot za.s[x8, 1], { z25.h-z28.h }, z0.h\n"
    "10:"  // Unpadded: 0 priming loads
    "cmp x7, #0x2\n"
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    "ld1h { z7.h }, p2/Z, [SP, #2, MUL VL]\n"
    "blt 20f\n"
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z27.s }, p1/Z, [x17]\n"
    ".inst 0x658aab75  // bfcvt z21.h, p2/M, z27.s\n"
    "sub x7, x7, #0x2\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "sub x16, x16, #0x1\n"
    ".inst 0x648aab55  // bfcvtnt z21.h, p2/M, z26.s\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab56  // bfcvt z22.h, p2/M, z26.s\n"
    "lsr x20, x7, #0x1\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "cmp x20, x16\n"
    ".inst 0x648aab56  // bfcvtnt z22.h, p2/M, z26.s\n"
    "ld1w { z8.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa917  // bfcvt z23.h, p2/M, z8.s\n"
    "csel x26, x20, x16, LT\n"
    "ld1w { z2.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa857  // bfcvtnt z23.h, p2/M, z2.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z6.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8d8  // bfcvt z24.h, p2/M, z6.s\n"
    "and x7, x7, #0x1\n"
    "ld1w { z15.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa9f8  // bfcvtnt z24.h, p2/M, z15.s\n"
    "sub x16, x16, x26\n"
    "ld1w { z27.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab79  // bfcvt z25.h, p2/M, z27.s\n"
    "ld1w { z26.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab59  // bfcvtnt z25.h, p2/M, z26.s\n"
    "ld1w { z27.s }, p1/Z, [x21]\n"
    ".inst 0x658aab7a  // bfcvt z26.h, p2/M, z27.s\n"
    "cbz x26, 19f\n"
    "11:"  // Unpadded: Main loop
    ".inst 0xc13312b0  // bfdot za.s[x8, 0], { z21.h-z24.h }, z3.h\n"
    "addvl x25, SP, #6\n"
    "addvl x24, SP, #12\n"
    "ld1w { z14.s }, p1/Z, [x17]\n"
    ".inst 0xc13b12d0  // bfdot za.s[x8, 0], { z22.h-z25.h }, z11.h\n"
    ".inst 0xa1402b20  // ld1h { z0.h, z8.h }, pn10.b/Z, [x25]\n"
    "add x23, x17, %x[ld_in_row], LSL #2\n"
    "addvl x22, SP, #3\n"
    ".inst 0xc13012b1  // bfdot za.s[x8, 1], { z21.h-z24.h }, z0.h\n"
    "ld1w { z27.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    ".inst 0xc13812d1  // bfdot za.s[x8, 1], { z22.h-z25.h }, z8.h\n"
    ".inst 0xa1402b00  // ld1h { z0.h, z8.h }, pn10.b/Z, [x24]\n"
    "addvl x21, SP, #9\n"
    "add x20, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13012b2  // bfdot za.s[x8, 2], { z21.h-z24.h }, z0.h\n"
    "ld1w { z2.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa9d5  // bfcvt z21.h, p2/M, z14.s\n"
    ".inst 0xc13712f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z7.h\n"
    "ld1h { z11.h }, p2/Z, [x25, #2, MUL VL]\n"
    ".inst 0x648aab75  // bfcvtnt z21.h, p2/M, z27.s\n"
    "subs x26, x26, #0x1\n"
    "ld1w { z14.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13812d2  // bfdot za.s[x8, 2], { z22.h-z25.h }, z8.h\n"
    ".inst 0x658aa856  // bfcvt z22.h, p2/M, z2.s\n"
    "ld1w { z7.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13b12f1  // bfdot za.s[x8, 1], { z23.h-z26.h }, z11.h\n"
    ".inst 0x648aa9d6  // bfcvtnt z22.h, p2/M, z14.s\n"
    "ld1w { z31.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc0060c08  // mova { z8.d-z11.d }, za.d[x8, #0]\n"
    ".inst 0xc1acc9a8  // fclamp { z8.s-z11.s }, z13.s, z12.s\n"
    "ld1h { z0.h }, p2/Z, [x24, #2, MUL VL]\n"
    ".inst 0xc13012f2  // bfdot za.s[x8, 2], { z23.h-z26.h }, z0.h\n"
    ".inst 0x658aa8f7  // bfcvt z23.h, p2/M, z7.s\n"
    "add x8, x8, #0x1\n"
    "ld1w { z26.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab58  // bfcvt z24.h, p2/M, z26.s\n"
    ".inst 0x648aabf7  // bfcvtnt z23.h, p2/M, z31.s\n"
    "ld1w { z2.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa858  // bfcvtnt z24.h, p2/M, z2.s\n"
    "st1w { z8.s }, p1, [x15]\n"
    "ld1w { z0.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa819  // bfcvt z25.h, p2/M, z0.s\n"
    "add x15, x15, x13, LSL #2\n"
    ".inst 0xa0402ac2  // ld1h { z2.h-z3.h }, pn10.b/Z, [x22]\n"
    ".inst 0xc13212b0  // bfdot za.s[x8, 0], { z21.h-z24.h }, z2.h\n"
    "st1w { z9.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    "ld1w { z26.s }, p1/Z, [x23]\n"
    ".inst 0x648aab59  // bfcvtnt z25.h, p2/M, z26.s\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13312d0  // bfdot za.s[x8, 0], { z22.h-z25.h }, z3.h\n"
    ".inst 0xa1402aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc13112b1  // bfdot za.s[x8, 1], { z21.h-z24.h }, z1.h\n"
    "st1w { z10.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "ld1w { z26.s }, p1/Z, [x23]\n"
    ".inst 0x658aab5a  // bfcvt z26.h, p2/M, z26.s\n"
    ".inst 0xc13912d1  // bfdot za.s[x8, 1], { z22.h-z25.h }, z9.h\n"
    "ld1w { z31.s }, p1/Z, [x17]\n"
    ".inst 0x658aabf5  // bfcvt z21.h, p2/M, z31.s\n"
    "st1w { z11.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "ld1w { z30.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc0040e04  // mova za.d[x8, #4], { z16.d-z19.d }\n"
    ".inst 0x648aabd5  // bfcvtnt z21.h, p2/M, z30.s\n"
    "ld1w { z0.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa816  // bfcvt z22.h, p2/M, z0.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z1.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa836  // bfcvtnt z22.h, p2/M, z1.s\n"
    "ld1w { z11.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1h { z2.h }, p2/Z, [x22, #2, MUL VL]\n"
    ".inst 0xc13212f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z2.h\n"
    "ld1w { z28.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z14.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z27.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1h { z4.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc13412f1  // bfdot za.s[x8, 1], { z23.h-z26.h }, z4.h\n"
    ".inst 0x658aa977  // bfcvt z23.h, p2/M, z11.s\n"
    "ld1w { z29.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa9d8  // bfcvt z24.h, p2/M, z14.s\n"
    ".inst 0x658aabb9  // bfcvt z25.h, p2/M, z29.s\n"
    "ld1w { z5.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab97  // bfcvtnt z23.h, p2/M, z28.s\n"
    ".inst 0x648aab78  // bfcvtnt z24.h, p2/M, z27.s\n"
    "ld1w { z11.s }, p1/Z, [x20]\n"
    ".inst 0x648aa8b9  // bfcvtnt z25.h, p2/M, z5.s\n"
    ".inst 0x658aa97a  // bfcvt z26.h, p2/M, z11.s\n"
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    "ld1h { z7.h }, p2/Z, [SP, #2, MUL VL]\n"
    "bgt 11b\n"
    "b 19f\n"
    "12:"  // Padded
    "cbz x22, 17f\n"
    "cmp x22, #0x1\n"
    "sub x7, x7, x22\n"
    "beq 16f\n"
    "cmp x22, #0x2\n"
    "beq 15f\n"
    "cmp x22, #0x3\n"
    "beq 14f\n"
    "13:"  // Padded: 4 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z1.s }, p0/Z, [x17]\n"
    ".inst 0x658aa837  // bfcvt z23.h, p2/M, z1.s\n"
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z29.s }, p0/Z, [x21]\n"
    ".inst 0x648aabb7  // bfcvtnt z23.h, p2/M, z29.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z30.s }, p0/Z, [x21]\n"
    ".inst 0x658aabd8  // bfcvt z24.h, p2/M, z30.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z15.s }, p0/Z, [x21]\n"
    ".inst 0x648aa9f8  // bfcvtnt z24.h, p2/M, z15.s\n"
    "mov x12, #0x4\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z27.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab79  // bfcvt z25.h, p2/M, z27.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z20.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa99  // bfcvtnt z25.h, p2/M, z20.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z10.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa95a  // bfcvt z26.h, p2/M, z10.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x8\n"
    "ld1w { z8.s }, p0/Z, [x21]\n"
    ".inst 0x648aa91a  // bfcvtnt z26.h, p2/M, z8.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z28.s }, p0/Z, [x21]\n"
    ".inst 0x658aab9b  // bfcvt z27.h, p2/M, z28.s\n"
    "addvl x20, SP, #12\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1402a81  // ld1h { z1.h, z9.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc13112f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z1.h\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z28.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab9b  // bfcvtnt z27.h, p2/M, z28.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z0.s }, p0/Z, [x21]\n"
    ".inst 0x658aa81c  // bfcvt z28.h, p2/M, z0.s\n"
    ".inst 0xc1391310  // bfdot za.s[x8, 0], { z24.h-z27.h }, z9.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    ".inst 0xc1301330  // bfdot za.s[x8, 0], { z25.h-z28.h }, z0.h\n"
    "14:"  // Padded: 3 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z21.s }, p0/Z, [x17]\n"
    ".inst 0x658aaab4  // bfcvt z20.h, p2/M, z21.s\n"
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z27.s }, p0/Z, [x21]\n"
    ".inst 0x648aab74  // bfcvtnt z20.h, p2/M, z27.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z27.s }, p0/Z, [x21]\n"
    ".inst 0x658aab75  // bfcvt z21.h, p2/M, z27.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z27.s }, p0/Z, [x21]\n"
    ".inst 0x648aab75  // bfcvtnt z21.h, p2/M, z27.s\n"
    "mov x12, #0x4\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z29.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabb6  // bfcvt z22.h, p2/M, z29.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z27.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab76  // bfcvtnt z22.h, p2/M, z27.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z27.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab77  // bfcvt z23.h, p2/M, z27.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x8\n"
    "ld1w { z8.s }, p0/Z, [x21]\n"
    ".inst 0x648aa917  // bfcvtnt z23.h, p2/M, z8.s\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z28.s }, p0/Z, [x21]\n"
    ".inst 0x658aab98  // bfcvt z24.h, p2/M, z28.s\n"
    "addvl x20, SP, #9\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1402a81  // ld1h { z1.h, z9.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1311290  // bfdot za.s[x8, 0], { z20.h-z23.h }, z1.h\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z0.s }, p0/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa818  // bfcvtnt z24.h, p2/M, z0.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z1.s }, p0/Z, [x21]\n"
    ".inst 0x658aa839  // bfcvt z25.h, p2/M, z1.s\n"
    ".inst 0xc13912b0  // bfdot za.s[x8, 0], { z21.h-z24.h }, z9.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    ".inst 0xc13012d0  // bfdot za.s[x8, 0], { z22.h-z25.h }, z0.h\n"
    "15:"  // Padded: 2 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z6.s }, p0/Z, [x17]\n"
    ".inst 0x658aa8da  // bfcvt z26.h, p2/M, z6.s\n"
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z29.s }, p0/Z, [x22]\n"
    ".inst 0x648aabba  // bfcvtnt z26.h, p2/M, z29.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z28.s }, p0/Z, [x22]\n"
    ".inst 0x658aab9b  // bfcvt z27.h, p2/M, z28.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z14.s }, p0/Z, [x22]\n"
    ".inst 0x648aa9db  // bfcvtnt z27.h, p2/M, z14.s\n"
    "mov x12, #0x4\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z24.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab1c  // bfcvt z28.h, p2/M, z24.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z1.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa83c  // bfcvtnt z28.h, p2/M, z1.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z3.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa87d  // bfcvt z29.h, p2/M, z3.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x8\n"
    "ld1w { z0.s }, p0/Z, [x22]\n"
    ".inst 0x648aa81d  // bfcvtnt z29.h, p2/M, z0.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z24.s }, p0/Z, [x22]\n"
    ".inst 0x658aab1e  // bfcvt z30.h, p2/M, z24.s\n"
    "addvl x21, SP, #6\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1402aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc1311350  // bfdot za.s[x8, 0], { z26.h-z29.h }, z1.h\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z23.s }, p0/Z, [x22]\n"
    ".inst 0x648aaafe  // bfcvtnt z30.h, p2/M, z23.s\n"
    "addvl x20, SP, #12\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xc1391370  // bfdot za.s[x8, 0], { z27.h-z30.h }, z9.h\n"
    ".inst 0xa0402a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20]\n"
    "ld1w { z31.s }, p0/Z, [x22]\n"
    ".inst 0xc1301351  // bfdot za.s[x8, 1], { z26.h-z29.h }, z0.h\n"
    ".inst 0x658aabff  // bfcvt z31.h, p2/M, z31.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1h { z0.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc1311371  // bfdot za.s[x8, 1], { z27.h-z30.h }, z1.h\n"
    ".inst 0xc1301390  // bfdot za.s[x8, 0], { z28.h-z31.h }, z0.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1301391  // bfdot za.s[x8, 1], { z28.h-z31.h }, z0.h\n"
    "16:"  // Padded: 1 priming loads
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z22.s }, p0/Z, [x17]\n"
    ".inst 0x658aaad5  // bfcvt z21.h, p2/M, z22.s\n"
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z3.s }, p0/Z, [x22]\n"
    ".inst 0x648aa875  // bfcvtnt z21.h, p2/M, z3.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z20.s }, p0/Z, [x22]\n"
    ".inst 0x658aaa96  // bfcvt z22.h, p2/M, z20.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z25.s }, p0/Z, [x22]\n"
    ".inst 0x648aab36  // bfcvtnt z22.h, p2/M, z25.s\n"
    "mov x12, #0x4\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z24.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab17  // bfcvt z23.h, p2/M, z24.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z0.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa817  // bfcvtnt z23.h, p2/M, z0.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z7.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8f8  // bfcvt z24.h, p2/M, z7.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x8\n"
    "ld1w { z28.s }, p0/Z, [x22]\n"
    ".inst 0x648aab98  // bfcvtnt z24.h, p2/M, z28.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z6.s }, p0/Z, [x22]\n"
    ".inst 0x658aa8d9  // bfcvt z25.h, p2/M, z6.s\n"
    "addvl x21, SP, #3\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xa1402aa1  // ld1h { z1.h, z9.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc13112b0  // bfdot za.s[x8, 0], { z21.h-z24.h }, z1.h\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z6.s }, p0/Z, [x22]\n"
    ".inst 0x648aa8d9  // bfcvtnt z25.h, p2/M, z6.s\n"
    "addvl x20, SP, #9\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xc13912d0  // bfdot za.s[x8, 0], { z22.h-z25.h }, z9.h\n"
    ".inst 0xa0402a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20]\n"
    "ld1w { z3.s }, p0/Z, [x22]\n"
    ".inst 0xc13012b1  // bfdot za.s[x8, 1], { z21.h-z24.h }, z0.h\n"
    ".inst 0x658aa87a  // bfcvt z26.h, p2/M, z3.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1h { z0.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc13112d1  // bfdot za.s[x8, 1], { z22.h-z25.h }, z1.h\n"
    ".inst 0xc13012f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z0.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc13012f1  // bfdot za.s[x8, 1], { z23.h-z26.h }, z0.h\n"
    "17:"  // Padded: 0 priming loads
    "cmp x7, #0x2\n"
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    "ld1h { z7.h }, p2/Z, [SP, #2, MUL VL]\n"
    "blt 20f\n"
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z25.s }, p0/Z, [x17]\n"
    ".inst 0x658aab35  // bfcvt z21.h, p2/M, z25.s\n"
    "add x20, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    ".inst 0x648aab75  // bfcvtnt z21.h, p2/M, z27.s\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    ".inst 0x658aab76  // bfcvt z22.h, p2/M, z27.s\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    ".inst 0x648aab76  // bfcvtnt z22.h, p2/M, z27.s\n"
    "mov x12, #0x4\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab77  // bfcvt z23.h, p2/M, z27.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z25.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab37  // bfcvtnt z23.h, p2/M, z25.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z26.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab58  // bfcvt z24.h, p2/M, z26.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x8\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    ".inst 0x648aab78  // bfcvtnt z24.h, p2/M, z27.s\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    ".inst 0x658aab79  // bfcvt z25.h, p2/M, z27.s\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z26.s }, p0/Z, [x20]\n"
    ".inst 0x648aab59  // bfcvtnt z25.h, p2/M, z26.s\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    ".inst 0x658aab7a  // bfcvt z26.h, p2/M, z27.s\n"
    "sub x7, x7, #0x2\n"
    "sub x16, x16, #0x1\n"
    "lsr x20, x7, #0x1\n"
    "cmp x20, x16\n"
    "csel x24, x20, x16, LT\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "and x7, x7, #0x1\n"
    "sub x16, x16, x24\n"
    "cbz x24, 19f\n"
    "18:"  // Padded: Main loop
    ".inst 0xc13312b0  // bfdot za.s[x8, 0], { z21.h-z24.h }, z3.h\n"
    "addvl x23, SP, #6\n"
    "addvl x21, SP, #12\n"
    ".inst 0xc13b12d0  // bfdot za.s[x8, 0], { z22.h-z25.h }, z11.h\n"
    ".inst 0xa0402ae0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x23]\n"
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc13012b1  // bfdot za.s[x8, 1], { z21.h-z24.h }, z0.h\n"
    "ld1w { z9.s }, p0/Z, [x17]\n"
    "add x20, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc13112d1  // bfdot za.s[x8, 1], { z22.h-z25.h }, z1.h\n"
    ".inst 0xa0402aa0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x21]\n"
    "addvl x22, SP, #3\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    ".inst 0xc13012b2  // bfdot za.s[x8, 2], { z21.h-z24.h }, z0.h\n"
    "ld1w { z14.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0xc13712f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z7.h\n"
    "mov x12, #0x4\n"
    "ld1h { z0.h }, p2/Z, [x23, #2, MUL VL]\n"
    ".inst 0xc13112d2  // bfdot za.s[x8, 2], { z22.h-z25.h }, z1.h\n"
    ".inst 0x658aa921  // bfcvt z1.h, p2/M, z9.s\n"
    "ld1w { z15.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc13012f1  // bfdot za.s[x8, 1], { z23.h-z26.h }, z0.h\n"
    "ld1w { z9.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0x658aab62  // bfcvt z2.h, p2/M, z27.s\n"
    "ld1w { z27.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0x648aa9c1  // bfcvtnt z1.h, p2/M, z14.s\n"
    "ld1h { z0.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc13012f2  // bfdot za.s[x8, 2], { z23.h-z26.h }, z0.h\n"
    ".inst 0x658aa923  // bfcvt z3.h, p2/M, z9.s\n"
    "addvl x21, SP, #9\n"
    "ld1w { z9.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0x658aa924  // bfcvt z4.h, p2/M, z9.s\n"
    "mov x12, #0x8\n"
    "ld1w { z24.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa9e2  // bfcvtnt z2.h, p2/M, z15.s\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z9.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aab63  // bfcvtnt z3.h, p2/M, z27.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0x648aab04  // bfcvtnt z4.h, p2/M, z24.s\n"
    ".inst 0x658aa925  // bfcvt z5.h, p2/M, z9.s\n"
    ".inst 0xa1402ac0  // ld1h { z0.h, z8.h }, pn10.b/Z, [x22]\n"
    "ld1w { z30.s }, p0/Z, [x20]\n"
    ".inst 0xc0060c18  // mova { z24.d-z27.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    ".inst 0x648aabc5  // bfcvtnt z5.h, p2/M, z30.s\n"
    ".inst 0xc1301030  // bfdot za.s[x8, 0], { z1.h-z4.h }, z0.h\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z29.s }, p0/Z, [x20]\n"
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc1381050  // bfdot za.s[x8, 0], { z2.h-z5.h }, z8.h\n"
    ".inst 0xa1402aa6  // ld1h { z6.h, z14.h }, pn10.b/Z, [x21]\n"
    "ld1w { z0.s }, p0/Z, [x17]\n"
    "add x20, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc1361031  // bfdot za.s[x8, 1], { z1.h-z4.h }, z6.h\n"
    "ld1w { z10.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0x658aaba6  // bfcvt z6.h, p2/M, z29.s\n"
    "ld1w { z9.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0xc13e1051  // bfdot za.s[x8, 1], { z2.h-z5.h }, z14.h\n"
    "mov x12, #0x4\n"
    "ld1w { z29.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa815  // bfcvt z21.h, p2/M, z0.s\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z31.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa936  // bfcvt z22.h, p2/M, z9.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1h { z0.h }, p2/Z, [x22, #2, MUL VL]\n"
    ".inst 0xc1301070  // bfdot za.s[x8, 0], { z3.h-z6.h }, z0.h\n"
    "subs x24, x24, #0x1\n"
    "ld1w { z15.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0xc1acc9b8  // fclamp { z24.s-z27.s }, z13.s, z12.s\n"
    "ld1w { z30.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "st1w { z24.s }, p1, [x15]\n"
    "mov x12, #0x8\n"
    "ld1w { z14.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "st1w { z25.s }, p1, [x14]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1h { z0.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc1301071  // bfdot za.s[x8, 1], { z3.h-z6.h }, z0.h\n"
    ".inst 0x658aabf7  // bfcvt z23.h, p2/M, z31.s\n"
    "ld1w { z8.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0x658aabd8  // bfcvt z24.h, p2/M, z30.s\n"
    "ld1w { z4.s }, p0/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0x658aa919  // bfcvt z25.h, p2/M, z8.s\n"
    "ld1w { z5.s }, p0/Z, [x20]\n"
    "add x15, x15, x13, LSL #2\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z26.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z27.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040e04  // mova za.d[x8, #4], { z16.d-z19.d }\n"
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    ".inst 0x648aa955  // bfcvtnt z21.h, p2/M, z10.s\n"
    ".inst 0x648aabb6  // bfcvtnt z22.h, p2/M, z29.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1h { z7.h }, p2/Z, [SP, #2, MUL VL]\n"
    ".inst 0x648aa9f7  // bfcvtnt z23.h, p2/M, z15.s\n"
    ".inst 0x648aa9d8  // bfcvtnt z24.h, p2/M, z14.s\n"
    ".inst 0x648aa899  // bfcvtnt z25.h, p2/M, z4.s\n"
    ".inst 0x658aa8ba  // bfcvt z26.h, p2/M, z5.s\n"
    "bgt 18b\n"
    "19:"  // Main loop tail
    ".inst 0xc13312b0  // bfdot za.s[x8, 0], { z21.h-z24.h }, z3.h\n"
    "addvl x24, SP, #6\n"
    "addvl x23, SP, #12\n"
    ".inst 0xc13b12d0  // bfdot za.s[x8, 0], { z22.h-z25.h }, z11.h\n"
    ".inst 0xa0402b00  // ld1h { z0.h-z1.h }, pn10.b/Z, [x24]\n"
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc13012b1  // bfdot za.s[x8, 1], { z21.h-z24.h }, z0.h\n"
    "ld1w { z5.s }, p0/Z, [x17]\n"
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc13112d1  // bfdot za.s[x8, 1], { z22.h-z25.h }, z1.h\n"
    ".inst 0xa0402ae0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x23]\n"
    "addvl x21, SP, #3\n"
    "addvl x20, SP, #9\n"
    ".inst 0xc13012b2  // bfdot za.s[x8, 2], { z21.h-z24.h }, z0.h\n"
    "ld1w { z29.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z2.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0xc13712f0  // bfdot za.s[x8, 0], { z23.h-z26.h }, z7.h\n"
    "mov x12, #0x4\n"
    "ld1h { z0.h }, p2/Z, [x24, #2, MUL VL]\n"
    ".inst 0xc13112d2  // bfdot za.s[x8, 2], { z22.h-z25.h }, z1.h\n"
    ".inst 0x658aa8bb  // bfcvt z27.h, p2/M, z5.s\n"
    "ld1w { z20.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0xc13012f1  // bfdot za.s[x8, 1], { z23.h-z26.h }, z0.h\n"
    "ld1w { z1.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0x658aa85c  // bfcvt z28.h, p2/M, z2.s\n"
    "ld1w { z14.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    ".inst 0x648aabbb  // bfcvtnt z27.h, p2/M, z29.s\n"
    "ld1h { z0.h }, p2/Z, [x23, #2, MUL VL]\n"
    ".inst 0xc13012f2  // bfdot za.s[x8, 2], { z23.h-z26.h }, z0.h\n"
    ".inst 0x658aa83d  // bfcvt z29.h, p2/M, z1.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z1.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    ".inst 0x658aa83e  // bfcvt z30.h, p2/M, z1.s\n"
    "mov x12, #0x8\n"
    "ld1w { z31.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa9c  // bfcvtnt z28.h, p2/M, z20.s\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z26.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa9dd  // bfcvtnt z29.h, p2/M, z14.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0x648aabfe  // bfcvtnt z30.h, p2/M, z31.s\n"
    ".inst 0x658aab5f  // bfcvt z31.h, p2/M, z26.s\n"
    ".inst 0xa1402aa2  // ld1h { z2.h, z10.h }, pn10.b/Z, [x21]\n"
    "ld1w { z9.s }, p0/Z, [x22]\n"
    ".inst 0xc0060c04  // mova { z4.d-z7.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    ".inst 0x648aa93f  // bfcvtnt z31.h, p2/M, z9.s\n"
    ".inst 0xc1321370  // bfdot za.s[x8, 0], { z27.h-z30.h }, z2.h\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z26.s }, p0/Z, [x22]\n"
    ".inst 0xc13a1390  // bfdot za.s[x8, 0], { z28.h-z31.h }, z10.h\n"
    ".inst 0xa1402a82  // ld1h { z2.h, z10.h }, pn10.b/Z, [x20]\n"
    ".inst 0x658aab40  // bfcvt z0.h, p2/M, z26.s\n"
    ".inst 0xc1321371  // bfdot za.s[x8, 1], { z27.h-z30.h }, z2.h\n"
    "ld1h { z9.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc1acc9a4  // fclamp { z4.s-z7.s }, z13.s, z12.s\n"
    ".inst 0xc13a1391  // bfdot za.s[x8, 1], { z28.h-z31.h }, z10.h\n"
    "st1w { z4.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    ".inst 0xa1402be3  // ld1h { z3.h, z11.h }, pn10.b/Z, [SP]\n"
    ".inst 0xc13913b0  // bfdot za.s[x8, 0], { z29.h-z0.h }, z9.h\n"
    "ld1h { z9.h }, p2/Z, [x20, #2, MUL VL]\n"
    "st1w { z5.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z6.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    ".inst 0xc0040e04  // mova za.d[x8, #4], { z16.d-z19.d }\n"
    "st1w { z7.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc13913b1  // bfdot za.s[x8, 1], { z29.h-z0.h }, z9.h\n"
    "ld1h { z7.h }, p2/Z, [SP, #2, MUL VL]\n"
    "20:"  // Main loop skip tail
    "cbz x7, 21f\n"  // Skip remainder inputs
    "mov x12, #0x0\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z25.s }, p0/Z, [x17]\n"
    ".inst 0x658aab3d  // bfcvt z29.h, p2/M, z25.s\n"
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z26.s }, p0/Z, [x22]\n"
    ".inst 0x648aab5d  // bfcvtnt z29.h, p2/M, z26.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z25.s }, p0/Z, [x22]\n"
    ".inst 0x658aab3e  // bfcvt z30.h, p2/M, z25.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "ld1w { z24.s }, p0/Z, [x22]\n"
    ".inst 0x648aab1e  // bfcvtnt z30.h, p2/M, z24.s\n"
    "mov x12, #0x4\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z26.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab5f  // bfcvt z31.h, p2/M, z26.s\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z9.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa93f  // bfcvtnt z31.h, p2/M, z9.s\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "ld1w { z9.s }, p0/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa920  // bfcvt z0.h, p2/M, z9.s\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "mov x12, #0x8\n"
    "ld1w { z24.s }, p0/Z, [x22]\n"
    ".inst 0x648aab00  // bfcvtnt z0.h, p2/M, z24.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "ld1w { z9.s }, p0/Z, [x22]\n"
    ".inst 0x658aa921  // bfcvt z1.h, p2/M, z9.s\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z25.s }, p0/Z, [x22]\n"
    ".inst 0x648aab21  // bfcvtnt z1.h, p2/M, z25.s\n"
    ".inst 0xc13313b0  // bfdot za.s[x8, 0], { z29.h-z0.h }, z3.h\n"
    "addvl x21, SP, #6\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13b13d0  // bfdot za.s[x8, 0], { z30.h-z1.h }, z11.h\n"
    ".inst 0xa0402aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "addvl x20, SP, #12\n"
    ".inst 0xc13e13b1  // bfdot za.s[x8, 1], { z29.h-z0.h }, z14.h\n"
    "ld1w { z25.s }, p0/Z, [x22]\n"
    ".inst 0x658aab22  // bfcvt z2.h, p2/M, z25.s\n"
    "sub x16, x16, #0x1\n"
    ".inst 0xc13f13d1  // bfdot za.s[x8, 1], { z30.h-z1.h }, z15.h\n"
    ".inst 0xa0402a8e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc13e13b2  // bfdot za.s[x8, 2], { z29.h-z0.h }, z14.h\n"
    ".inst 0xc13713f0  // bfdot za.s[x8, 0], { z31.h-z2.h }, z7.h\n"
    "ld1h { z4.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc13f13d2  // bfdot za.s[x8, 2], { z30.h-z1.h }, z15.h\n"
    ".inst 0xc13413f1  // bfdot za.s[x8, 1], { z31.h-z2.h }, z4.h\n"
    "ld1h { z9.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc0060c04  // mova { z4.d-z7.d }, za.d[x8, #0]\n"
    ".inst 0xc1acc9a4  // fclamp { z4.s-z7.s }, z13.s, z12.s\n"
    "st1w { z4.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    ".inst 0xc13913f2  // bfdot za.s[x8, 2], { z31.h-z2.h }, z9.h\n"
    "add x8, x8, #0x1\n"
    "st1w { z5.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z6.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    ".inst 0xc0040e04  // mova za.d[x8, #4], { z16.d-z19.d }\n"
    "st1w { z7.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "21:"  // Tail input: End
    "cbz x16, 23f\n"
    "22:"  // Right padding loop
    ".inst 0xc0060c04  // mova { z4.d-z7.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    "subs x16, x16, #0x1\n"
    ".inst 0xc1acc9a4  // fclamp { z4.s-z7.s }, z13.s, z12.s\n"
    "st1w { z4.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    ".inst 0xc0040e04  // mova za.d[x8, #4], { z16.d-z19.d }\n"
    "st1w { z5.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z6.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z7.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "bgt 22b\n"
    "23:"  // End
    "ldr x20, [%x[args], %[offsetof_Args_weights]]\n"
    "incb x20, ALL, MUL #16\n"
    "incb x20, ALL, MUL #9\n"
    "str x20, [%x[args], %[offsetof_Args_weights]]\n"
    "ldr x21, [%x[args], %[offsetof_Args_ld_in_vl]]\n"
    "incw x6\n"
    "whilelt p1.s, x6, x5\n"
    "ldr x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "add x20, x20, x21, LSL #2\n"
    "str x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "ldr x25, [%x[args], %[offsetof_Args_outptrs]]\n"
    "ldr x24, [%x[args], %[offsetof_Args_ld_out_vls]]\n"
    "ldp x23, x22, [x25, #0x0]\n"
    "ldp x21, x20, [x24, #0x0]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x0]\n"
    "ldp x23, x22, [x25, #0x10]\n"
    "ldp x21, x20, [x24, #0x10]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x10]\n"
    "b.any 1b\n"
    "addvl SP, SP, #15\n"
    ".inst 0xd503467f  // SMSTOP\n"
    :
    : [args] "r" (&args), [ld_in_col] "r" (ld_in_col), [ld_in_row] "r" (ld_in_row), [offsetof_Args_bias] "I" (offsetof(Args, bias)), [offsetof_Args_clamp_max] "I" (offsetof(Args, clamp_max)), [offsetof_Args_clamp_min] "I" (offsetof(Args, clamp_min)), [offsetof_Args_current_channel] "I" (offsetof(Args, current_channel)), [offsetof_Args_inptr] "I" (offsetof(Args, inptr)), [offsetof_Args_input_cols] "I" (offsetof(Args, input_cols)), [offsetof_Args_ld_in_vl] "I" (offsetof(Args, ld_in_vl)), [offsetof_Args_ld_out_cols] "I" (offsetof(Args, ld_out_cols)), [offsetof_Args_ld_out_vls] "I" (offsetof(Args, ld_out_vls)), [offsetof_Args_n_channels] "I" (offsetof(Args, n_channels)), [offsetof_Args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_Args_output_cols] "I" (offsetof(Args, output_cols)), [offsetof_Args_pad_bottom] "I" (offsetof(Args, pad_bottom)), [offsetof_Args_pad_left] "I" (offsetof(Args, pad_left)), [offsetof_Args_pad_top] "I" (offsetof(Args, pad_top)), [offsetof_Args_weights] "I" (offsetof(Args, weights))
    : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SME2)
