/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2023 Broadcom
 * All rights reserved.
 */

#ifndef ULP_TEMPLATE_DB_H_
#define ULP_TEMPLATE_DB_H_

#define BNXT_ULP_REGFILE_MAX_SZ 61
#define BNXT_ULP_MAX_NUM_DEVICES 4
#define BNXT_ULP_LOG2_MAX_NUM_DEV 2
#define BNXT_ULP_GEN_TBL_MAX_SZ 36
#define BNXT_ULP_CLASS_SIG_TBL_MAX_SZ 1048576
#define BNXT_ULP_CLASS_MATCH_LIST_MAX_SZ 1907
#define BNXT_ULP_CLASS_HID_LOW_PRIME 4049
#define BNXT_ULP_CLASS_HID_HIGH_PRIME 7919
#define BNXT_ULP_CLASS_HID_SHFTR 29
#define BNXT_ULP_CLASS_HID_SHFTL 28
#define BNXT_ULP_CLASS_HID_MASK 1048575
#define BNXT_ULP_ACT_SIG_TBL_MAX_SZ 32768
#define BNXT_ULP_ACT_MATCH_LIST_MAX_SZ 546
#define BNXT_ULP_ACT_HID_LOW_PRIME 7919
#define BNXT_ULP_ACT_HID_HIGH_PRIME 7919
#define BNXT_ULP_ACT_HID_SHFTR 25
#define BNXT_ULP_ACT_HID_SHFTL 27
#define BNXT_ULP_ACT_HID_MASK 32767
#define BNXT_ULP_APP_RESOURCE_RESV_LIST_MAX_SZ 46
#define BNXT_ULP_GLB_RESOURCE_TBL_MAX_SZ 537
#define BNXT_ULP_APP_GLB_RESOURCE_TBL_MAX_SZ 187
#define BNXT_ULP_RESOURCE_RESV_LIST_MAX_SZ 970
#define BNXT_ULP_APP_CAP_TBL_MAX_SZ 25
#define BNXT_ULP_COND_GOTO_REJECT 1023
#define BNXT_ULP_COND_GOTO_RF 0x10000
#define BNXT_ULP_GLB_FIELD_TBL_SHIFT 7
#define BNXT_ULP_HDR_SIG_ID_SHIFT 5
#define BNXT_ULP_APP_ID_CONFIG 0
#define BNXT_ULP_APP_ID_SHIFT 4
#define BNXT_ULP_GLB_FIELD_TBL_SIZE 13805
#define ULP_WH_PLUS_CLASS_TMPL_LIST_SIZE 6
#define ULP_WH_PLUS_CLASS_TBL_LIST_SIZE 89
#define ULP_WH_PLUS_CLASS_KEY_INFO_LIST_SIZE 606
#define ULP_WH_PLUS_CLASS_IDENT_LIST_SIZE 26
#define ULP_WH_PLUS_CLASS_RESULT_FIELD_LIST_SIZE 618
#define ULP_WH_PLUS_CLASS_COND_LIST_SIZE 49
#define ULP_THOR_CLASS_TMPL_LIST_SIZE 6
#define ULP_THOR_CLASS_TBL_LIST_SIZE 124
#define ULP_THOR_CLASS_KEY_INFO_LIST_SIZE 2514
#define ULP_THOR_CLASS_IDENT_LIST_SIZE 38
#define ULP_THOR_CLASS_RESULT_FIELD_LIST_SIZE 1517
#define ULP_THOR_CLASS_COND_LIST_SIZE 55
#define ULP_WH_PLUS_ACT_TMPL_LIST_SIZE 11
#define ULP_WH_PLUS_ACT_TBL_LIST_SIZE 46
#define ULP_WH_PLUS_ACT_KEY_INFO_LIST_SIZE 2
#define ULP_WH_PLUS_ACT_IDENT_LIST_SIZE 1
#define ULP_WH_PLUS_ACT_RESULT_FIELD_LIST_SIZE 616
#define ULP_WH_PLUS_ACT_COND_LIST_SIZE 65
#define ULP_THOR_ACT_TMPL_LIST_SIZE 11
#define ULP_THOR_ACT_TBL_LIST_SIZE 96
#define ULP_THOR_ACT_KEY_INFO_LIST_SIZE 34
#define ULP_THOR_ACT_IDENT_LIST_SIZE 19
#define ULP_THOR_ACT_RESULT_FIELD_LIST_SIZE 794
#define ULP_THOR_ACT_COND_LIST_SIZE 75

enum bnxt_ulp_act_bit {
	BNXT_ULP_ACT_BIT_MARK                = 0x0000000000000001,
	BNXT_ULP_ACT_BIT_DROP                = 0x0000000000000002,
	BNXT_ULP_ACT_BIT_COUNT               = 0x0000000000000004,
	BNXT_ULP_ACT_BIT_RSS                 = 0x0000000000000008,
	BNXT_ULP_ACT_BIT_METER               = 0x0000000000000010,
	BNXT_ULP_ACT_BIT_VXLAN_DECAP         = 0x0000000000000020,
	BNXT_ULP_ACT_BIT_POP_MPLS            = 0x0000000000000040,
	BNXT_ULP_ACT_BIT_PUSH_MPLS           = 0x0000000000000080,
	BNXT_ULP_ACT_BIT_MAC_SWAP            = 0x0000000000000100,
	BNXT_ULP_ACT_BIT_SET_MAC_SRC         = 0x0000000000000200,
	BNXT_ULP_ACT_BIT_SET_MAC_DST         = 0x0000000000000400,
	BNXT_ULP_ACT_BIT_POP_VLAN            = 0x0000000000000800,
	BNXT_ULP_ACT_BIT_PUSH_VLAN           = 0x0000000000001000,
	BNXT_ULP_ACT_BIT_SET_VLAN_PCP        = 0x0000000000002000,
	BNXT_ULP_ACT_BIT_SET_VLAN_VID        = 0x0000000000004000,
	BNXT_ULP_ACT_BIT_SET_IPV4_SRC        = 0x0000000000008000,
	BNXT_ULP_ACT_BIT_SET_IPV4_DST        = 0x0000000000010000,
	BNXT_ULP_ACT_BIT_SET_IPV6_SRC        = 0x0000000000020000,
	BNXT_ULP_ACT_BIT_SET_IPV6_DST        = 0x0000000000040000,
	BNXT_ULP_ACT_BIT_DEC_TTL             = 0x0000000000080000,
	BNXT_ULP_ACT_BIT_SET_TP_SRC          = 0x0000000000100000,
	BNXT_ULP_ACT_BIT_SET_TP_DST          = 0x0000000000200000,
	BNXT_ULP_ACT_BIT_VXLAN_ENCAP         = 0x0000000000400000,
	BNXT_ULP_ACT_BIT_JUMP                = 0x0000000000800000,
	BNXT_ULP_ACT_BIT_SHARED              = 0x0000000001000000,
	BNXT_ULP_ACT_BIT_SAMPLE              = 0x0000000002000000,
	BNXT_ULP_ACT_BIT_SHARED_SAMPLE       = 0x0000000004000000,
	BNXT_ULP_ACT_BIT_QUEUE               = 0x0000000008000000,
	BNXT_ULP_ACT_BIT_DELETE              = 0x0000000010000000,
	BNXT_ULP_ACT_BIT_UPDATE              = 0x0000000020000000,
	BNXT_ULP_ACT_BIT_SHARED_METER        = 0x0000000040000000,
	BNXT_ULP_ACT_BIT_METER_PROFILE       = 0x0000000080000000,
	BNXT_ULP_ACT_BIT_GOTO_CHAIN          = 0x0000000100000000,
	BNXT_ULP_ACT_BIT_VF_TO_VF            = 0x0000000200000000,
	BNXT_ULP_ACT_BIT_IP_ENCAP            = 0x0000000400000000,
	BNXT_ULP_ACT_BIT_IP_DECAP            = 0x0000000800000000,
	BNXT_ULP_ACT_BIT_L2_ENCAP            = 0x0000001000000000,
	BNXT_ULP_ACT_BIT_L2_DECAP            = 0x0000002000000000,
	BNXT_ULP_ACT_BIT_LAST                = 0x0000004000000000
};

enum bnxt_ulp_hdr_bit {
	BNXT_ULP_HDR_BIT_O_ETH               = 0x0000000000000001,
	BNXT_ULP_HDR_BIT_OO_VLAN             = 0x0000000000000002,
	BNXT_ULP_HDR_BIT_OI_VLAN             = 0x0000000000000004,
	BNXT_ULP_HDR_BIT_O_IPV4              = 0x0000000000000008,
	BNXT_ULP_HDR_BIT_O_IPV6              = 0x0000000000000010,
	BNXT_ULP_HDR_BIT_O_TCP               = 0x0000000000000020,
	BNXT_ULP_HDR_BIT_O_UDP               = 0x0000000000000040,
	BNXT_ULP_HDR_BIT_O_ICMP              = 0x0000000000000080,
	BNXT_ULP_HDR_BIT_T_VXLAN             = 0x0000000000000100,
	BNXT_ULP_HDR_BIT_T_GRE               = 0x0000000000000200,
	BNXT_ULP_HDR_BIT_I_ETH               = 0x0000000000000400,
	BNXT_ULP_HDR_BIT_IO_VLAN             = 0x0000000000000800,
	BNXT_ULP_HDR_BIT_II_VLAN             = 0x0000000000001000,
	BNXT_ULP_HDR_BIT_I_IPV4              = 0x0000000000002000,
	BNXT_ULP_HDR_BIT_I_IPV6              = 0x0000000000004000,
	BNXT_ULP_HDR_BIT_I_TCP               = 0x0000000000008000,
	BNXT_ULP_HDR_BIT_I_UDP               = 0x0000000000010000,
	BNXT_ULP_HDR_BIT_I_ICMP              = 0x0000000000020000,
	BNXT_ULP_HDR_BIT_O_ECPRI             = 0x0000000000040000,
	BNXT_ULP_HDR_BIT_O_ROE               = 0x0000000000080000,
	BNXT_ULP_HDR_BIT_F1                  = 0x0000000000100000,
	BNXT_ULP_HDR_BIT_F2                  = 0x0000000000200000,
	BNXT_ULP_HDR_BIT_SVIF_IGNORE         = 0x0000000000400000,
	BNXT_ULP_HDR_BIT_O_SRV6              = 0x0000000000800000,
	BNXT_ULP_HDR_BIT_LAST                = 0x0000000001000000
};

enum bnxt_ulp_accept_opc {
	BNXT_ULP_ACCEPT_OPC_ALWAYS = 0,
	BNXT_ULP_ACCEPT_OPC_FLOW_SIG_ID_MATCH = 1,
	BNXT_ULP_ACCEPT_OPC_LAST = 2
};

enum bnxt_ulp_act_type {
	BNXT_ULP_ACT_TYPE_NOT_SUPPORTED = 0,
	BNXT_ULP_ACT_TYPE_SUPPORTED = 1,
	BNXT_ULP_ACT_TYPE_END = 2,
	BNXT_ULP_ACT_TYPE_LAST = 3
};

enum bnxt_ulp_byte_order {
	BNXT_ULP_BYTE_ORDER_BE = 0,
	BNXT_ULP_BYTE_ORDER_LE = 1,
	BNXT_ULP_BYTE_ORDER_LAST = 2
};

enum bnxt_ulp_cf_idx {
	BNXT_ULP_CF_IDX_NOT_USED = 0,
	BNXT_ULP_CF_IDX_MPLS_TAG_NUM = 1,
	BNXT_ULP_CF_IDX_O_VTAG_NUM = 2,
	BNXT_ULP_CF_IDX_O_HAS_VTAG = 3,
	BNXT_ULP_CF_IDX_O_ONE_VTAG = 4,
	BNXT_ULP_CF_IDX_O_TWO_VTAGS = 5,
	BNXT_ULP_CF_IDX_I_VTAG_NUM = 6,
	BNXT_ULP_CF_IDX_I_HAS_VTAG = 7,
	BNXT_ULP_CF_IDX_I_ONE_VTAG = 8,
	BNXT_ULP_CF_IDX_I_TWO_VTAGS = 9,
	BNXT_ULP_CF_IDX_INCOMING_IF = 10,
	BNXT_ULP_CF_IDX_DIRECTION = 11,
	BNXT_ULP_CF_IDX_SVIF_FLAG = 12,
	BNXT_ULP_CF_IDX_O_L3 = 13,
	BNXT_ULP_CF_IDX_I_L3 = 14,
	BNXT_ULP_CF_IDX_O_L4 = 15,
	BNXT_ULP_CF_IDX_I_L4 = 16,
	BNXT_ULP_CF_IDX_O_L4_SRC_PORT = 17,
	BNXT_ULP_CF_IDX_O_L4_DST_PORT = 18,
	BNXT_ULP_CF_IDX_I_L4_SRC_PORT = 19,
	BNXT_ULP_CF_IDX_I_L4_DST_PORT = 20,
	BNXT_ULP_CF_IDX_O_L4_SRC_PORT_MASK = 21,
	BNXT_ULP_CF_IDX_O_L4_DST_PORT_MASK = 22,
	BNXT_ULP_CF_IDX_I_L4_SRC_PORT_MASK = 23,
	BNXT_ULP_CF_IDX_I_L4_DST_PORT_MASK = 24,
	BNXT_ULP_CF_IDX_O_L4_FB_SRC_PORT = 25,
	BNXT_ULP_CF_IDX_O_L4_FB_DST_PORT = 26,
	BNXT_ULP_CF_IDX_I_L4_FB_SRC_PORT = 27,
	BNXT_ULP_CF_IDX_I_L4_FB_DST_PORT = 28,
	BNXT_ULP_CF_IDX_O_L3_FB_PROTO_ID = 29,
	BNXT_ULP_CF_IDX_I_L3_FB_PROTO_ID = 30,
	BNXT_ULP_CF_IDX_O_L3_PROTO_ID = 31,
	BNXT_ULP_CF_IDX_I_L3_PROTO_ID = 32,
	BNXT_ULP_CF_IDX_DEV_PORT_ID = 33,
	BNXT_ULP_CF_IDX_DRV_FUNC_SVIF = 34,
	BNXT_ULP_CF_IDX_DRV_FUNC_SPIF = 35,
	BNXT_ULP_CF_IDX_DRV_FUNC_PARIF = 36,
	BNXT_ULP_CF_IDX_DRV_FUNC_VNIC = 37,
	BNXT_ULP_CF_IDX_DRV_FUNC_PHY_PORT = 38,
	BNXT_ULP_CF_IDX_VF_FUNC_SVIF = 39,
	BNXT_ULP_CF_IDX_VF_FUNC_SPIF = 40,
	BNXT_ULP_CF_IDX_VF_FUNC_PARIF = 41,
	BNXT_ULP_CF_IDX_VF_FUNC_VNIC = 42,
	BNXT_ULP_CF_IDX_PHY_PORT_SVIF = 43,
	BNXT_ULP_CF_IDX_PHY_PORT_SPIF = 44,
	BNXT_ULP_CF_IDX_PHY_PORT_PARIF = 45,
	BNXT_ULP_CF_IDX_PHY_PORT_VPORT = 46,
	BNXT_ULP_CF_IDX_ACT_ENCAP_IPV4_FLAG = 47,
	BNXT_ULP_CF_IDX_ACT_ENCAP_IPV6_FLAG = 48,
	BNXT_ULP_CF_IDX_ACT_DEC_TTL = 49,
	BNXT_ULP_CF_IDX_ACT_T_DEC_TTL = 50,
	BNXT_ULP_CF_IDX_ACT_PORT_IS_SET = 51,
	BNXT_ULP_CF_IDX_ACT_PORT_TYPE = 52,
	BNXT_ULP_CF_IDX_MATCH_PORT_TYPE = 53,
	BNXT_ULP_CF_IDX_MATCH_PORT_IS_VFREP = 54,
	BNXT_ULP_CF_IDX_MATCH_PORT_IS_PF = 55,
	BNXT_ULP_CF_IDX_VF_TO_VF = 56,
	BNXT_ULP_CF_IDX_L3_HDR_CNT = 57,
	BNXT_ULP_CF_IDX_L4_HDR_CNT = 58,
	BNXT_ULP_CF_IDX_VFR_MODE = 59,
	BNXT_ULP_CF_IDX_L3_TUN = 60,
	BNXT_ULP_CF_IDX_L3_TUN_DECAP = 61,
	BNXT_ULP_CF_IDX_FID = 62,
	BNXT_ULP_CF_IDX_HDR_SIG_ID = 63,
	BNXT_ULP_CF_IDX_FLOW_SIG_ID = 64,
	BNXT_ULP_CF_IDX_WC_MATCH = 65,
	BNXT_ULP_CF_IDX_WC_IS_HA_HIGH_REG = 66,
	BNXT_ULP_CF_IDX_TUNNEL_ID = 67,
	BNXT_ULP_CF_IDX_TUN_OFF_DIP_ID = 68,
	BNXT_ULP_CF_IDX_TUN_OFF_DMAC_ID = 69,
	BNXT_ULP_CF_IDX_OO_VLAN_FB_VID = 70,
	BNXT_ULP_CF_IDX_OI_VLAN_FB_VID = 71,
	BNXT_ULP_CF_IDX_IO_VLAN_FB_VID = 72,
	BNXT_ULP_CF_IDX_II_VLAN_FB_VID = 73,
	BNXT_ULP_CF_IDX_SOCKET_DIRECT = 74,
	BNXT_ULP_CF_IDX_SOCKET_DIRECT_VPORT = 75,
	BNXT_ULP_CF_IDX_TUNNEL_SPORT = 76,
	BNXT_ULP_CF_IDX_VF_META_FID = 77,
	BNXT_ULP_CF_IDX_DEV_ACT_PORT_ID = 78,
	BNXT_ULP_CF_IDX_O_VLAN_NO_IGNORE = 79,
	BNXT_ULP_CF_IDX_I_VLAN_NO_IGNORE = 80,
	BNXT_ULP_CF_IDX_HA_SUPPORT_DISABLED = 81,
	BNXT_ULP_CF_IDX_CHAIN_ID_METADATA = 82,
	BNXT_ULP_CF_IDX_SRV6_UPAR_ID = 83,
	BNXT_ULP_CF_IDX_SRV6_T_ID = 84,
	BNXT_ULP_CF_IDX_GENERIC_SIZE = 85,
	BNXT_ULP_CF_IDX_LAST = 86
};

enum bnxt_ulp_cond_list_opc {
	BNXT_ULP_COND_LIST_OPC_TRUE = 0,
	BNXT_ULP_COND_LIST_OPC_FALSE = 1,
	BNXT_ULP_COND_LIST_OPC_OR = 2,
	BNXT_ULP_COND_LIST_OPC_AND = 3,
	BNXT_ULP_COND_LIST_OPC_LAST = 4
};

enum bnxt_ulp_cond_opc {
	BNXT_ULP_COND_OPC_CF_IS_SET = 0,
	BNXT_ULP_COND_OPC_CF_NOT_SET = 1,
	BNXT_ULP_COND_OPC_ACT_BIT_IS_SET = 2,
	BNXT_ULP_COND_OPC_ACT_BIT_NOT_SET = 3,
	BNXT_ULP_COND_OPC_HDR_BIT_IS_SET = 4,
	BNXT_ULP_COND_OPC_HDR_BIT_NOT_SET = 5,
	BNXT_ULP_COND_OPC_FIELD_BIT_IS_SET = 6,
	BNXT_ULP_COND_OPC_FIELD_BIT_NOT_SET = 7,
	BNXT_ULP_COND_OPC_RF_IS_SET = 8,
	BNXT_ULP_COND_OPC_RF_NOT_SET = 9,
	BNXT_ULP_COND_OPC_FLOW_PAT_MATCH = 10,
	BNXT_ULP_COND_OPC_ACT_PAT_MATCH = 11,
	BNXT_ULP_COND_OPC_EXT_MEM_IS_SET = 12,
	BNXT_ULP_COND_OPC_EXT_MEM_NOT_SET = 13,
	BNXT_ULP_COND_OPC_ENC_HDR_BIT_IS_SET = 14,
	BNXT_ULP_COND_OPC_ENC_HDR_BIT_NOT_SET = 15,
	BNXT_ULP_COND_OPC_ACT_PROP_IS_SET = 16,
	BNXT_ULP_COND_OPC_ACT_PROP_NOT_SET = 17,
	BNXT_ULP_COND_OPC_LAST = 18
};

enum bnxt_ulp_critical_resource {
	BNXT_ULP_CRITICAL_RESOURCE_NO = 0,
	BNXT_ULP_CRITICAL_RESOURCE_YES = 1,
	BNXT_ULP_CRITICAL_RESOURCE_LAST = 2
};

enum bnxt_ulp_device_id {
	BNXT_ULP_DEVICE_ID_WH_PLUS = 0,
	BNXT_ULP_DEVICE_ID_THOR = 1,
	BNXT_ULP_DEVICE_ID_STINGRAY = 2,
	BNXT_ULP_DEVICE_ID_STINGRAY2 = 3,
	BNXT_ULP_DEVICE_ID_LAST = 4
};

enum bnxt_ulp_df_param_type {
	BNXT_ULP_DF_PARAM_TYPE_DEV_PORT_ID = 0,
	BNXT_ULP_DF_PARAM_TYPE_LAST = 1
};

enum bnxt_ulp_direction {
	BNXT_ULP_DIRECTION_INGRESS = 0,
	BNXT_ULP_DIRECTION_EGRESS = 1,
	BNXT_ULP_DIRECTION_LAST = 2
};

enum bnxt_ulp_enc_field {
	BNXT_ULP_ENC_FIELD_ETH_DMAC = 0,
	BNXT_ULP_ENC_FIELD_ETH_SMAC = 1,
	BNXT_ULP_ENC_FIELD_ETH_TYPE = 2,
	BNXT_ULP_ENC_FIELD_O_VLAN_TCI = 3,
	BNXT_ULP_ENC_FIELD_O_VLAN_TYPE = 4,
	BNXT_ULP_ENC_FIELD_I_VLAN_TCI = 5,
	BNXT_ULP_ENC_FIELD_I_VLAN_TYPE = 6,
	BNXT_ULP_ENC_FIELD_IPV4_IHL = 7,
	BNXT_ULP_ENC_FIELD_IPV4_TOS = 8,
	BNXT_ULP_ENC_FIELD_IPV4_PKT_ID = 9,
	BNXT_ULP_ENC_FIELD_IPV4_FRAG = 10,
	BNXT_ULP_ENC_FIELD_IPV4_TTL = 11,
	BNXT_ULP_ENC_FIELD_IPV4_PROTO = 12,
	BNXT_ULP_ENC_FIELD_IPV4_SADDR = 13,
	BNXT_ULP_ENC_FIELD_IPV4_DADDR = 14,
	BNXT_ULP_ENC_FIELD_IPV6_VTC_FLOW = 15,
	BNXT_ULP_ENC_FIELD_IPV6_PROTO = 16,
	BNXT_ULP_ENC_FIELD_IPV6_TTL = 17,
	BNXT_ULP_ENC_FIELD_IPV6_SADDR = 18,
	BNXT_ULP_ENC_FIELD_IPV6_DADDR = 19,
	BNXT_ULP_ENC_FIELD_UDP_SPORT = 20,
	BNXT_ULP_ENC_FIELD_UDP_DPORT = 21,
	BNXT_ULP_ENC_FIELD_VXLAN_FLAGS = 22,
	BNXT_ULP_ENC_FIELD_VXLAN_RSVD0 = 23,
	BNXT_ULP_ENC_FIELD_VXLAN_VNI = 24,
	BNXT_ULP_ENC_FIELD_VXLAN_RSVD1 = 25,
	BNXT_ULP_ENC_FIELD_SRV6_NEXT_HDR = 26,
	BNXT_ULP_ENC_FIELD_SRV6_HDR_LEN = 27,
	BNXT_ULP_ENC_FIELD_SRV6_ROUTING_TYPE = 28,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LEFT = 29,
	BNXT_ULP_ENC_FIELD_SRV6_LAST_ENTRY = 30,
	BNXT_ULP_ENC_FIELD_SRV6_FLAGS = 31,
	BNXT_ULP_ENC_FIELD_SRV6_TAG = 32,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST0 = 33,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST1 = 34,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST2 = 35,
	BNXT_ULP_ENC_FIELD_SRV6_SEG_LIST3 = 36,
	BNXT_ULP_ENC_FIELD_GENERIC_SIZE = 37,
	BNXT_ULP_ENC_FIELD_GENERIC_RSVD = 38,
	BNXT_ULP_ENC_FIELD_LAST = 39
};

enum bnxt_ulp_fdb_opc {
	BNXT_ULP_FDB_OPC_PUSH_FID = 0,
	BNXT_ULP_FDB_OPC_PUSH_RID_REGFILE = 1,
	BNXT_ULP_FDB_OPC_ALLOC_RID_REGFILE = 2,
	BNXT_ULP_FDB_OPC_DELETE_RID_REGFILE = 3,
	BNXT_ULP_FDB_OPC_CLEAR_RID_REGFILE = 4,
	BNXT_ULP_FDB_OPC_NOP = 5,
	BNXT_ULP_FDB_OPC_LAST = 6
};

enum bnxt_ulp_fdb_type {
	BNXT_ULP_FDB_TYPE_REGULAR = 0,
	BNXT_ULP_FDB_TYPE_DEFAULT = 1,
	BNXT_ULP_FDB_TYPE_RID = 2,
	BNXT_ULP_FDB_TYPE_LAST = 3
};

enum bnxt_ulp_field_opc {
	BNXT_ULP_FIELD_OPC_SRC1 = 0,
	BNXT_ULP_FIELD_OPC_SRC1_THEN_SRC2_ELSE_SRC3 = 1,
	BNXT_ULP_FIELD_OPC_SRC1_PLUS_SRC2 = 2,
	BNXT_ULP_FIELD_OPC_SRC1_MINUS_SRC2 = 3,
	BNXT_ULP_FIELD_OPC_SRC1_PLUS_SRC2_POST = 4,
	BNXT_ULP_FIELD_OPC_SRC1_MINUS_SRC2_POST = 5,
	BNXT_ULP_FIELD_OPC_SRC1_OR_SRC2 = 6,
	BNXT_ULP_FIELD_OPC_SRC1_OR_SRC2_OR_SRC3 = 7,
	BNXT_ULP_FIELD_OPC_SRC1_AND_SRC2 = 8,
	BNXT_ULP_FIELD_OPC_SRC1_AND_SRC2_OR_SRC3 = 9,
	BNXT_ULP_FIELD_OPC_SKIP = 10,
	BNXT_ULP_FIELD_OPC_LAST = 11
};

enum bnxt_ulp_field_src {
	BNXT_ULP_FIELD_SRC_ZERO = 0,
	BNXT_ULP_FIELD_SRC_ONES = 1,
	BNXT_ULP_FIELD_SRC_CONST = 2,
	BNXT_ULP_FIELD_SRC_CF = 3,
	BNXT_ULP_FIELD_SRC_RF = 4,
	BNXT_ULP_FIELD_SRC_ACT_PROP = 5,
	BNXT_ULP_FIELD_SRC_ACT_PROP_SZ = 6,
	BNXT_ULP_FIELD_SRC_GLB_RF = 7,
	BNXT_ULP_FIELD_SRC_HF = 8,
	BNXT_ULP_FIELD_SRC_SUB_HF = 9,
	BNXT_ULP_FIELD_SRC_HDR_BIT = 10,
	BNXT_ULP_FIELD_SRC_ACT_BIT = 11,
	BNXT_ULP_FIELD_SRC_FIELD_BIT = 12,
	BNXT_ULP_FIELD_SRC_SKIP = 13,
	BNXT_ULP_FIELD_SRC_REJECT = 14,
	BNXT_ULP_FIELD_SRC_PORT_TABLE = 15,
	BNXT_ULP_FIELD_SRC_ENC_HDR_BIT = 16,
	BNXT_ULP_FIELD_SRC_ENC_FIELD = 17,
	BNXT_ULP_FIELD_SRC_LAST = 18
};

enum bnxt_ulp_func_opc {
	BNXT_ULP_FUNC_OPC_NOP = 0,
	BNXT_ULP_FUNC_OPC_EQ = 1,
	BNXT_ULP_FUNC_OPC_NE = 2,
	BNXT_ULP_FUNC_OPC_GT = 3,
	BNXT_ULP_FUNC_OPC_GE = 4,
	BNXT_ULP_FUNC_OPC_LT = 5,
	BNXT_ULP_FUNC_OPC_LE = 6,
	BNXT_ULP_FUNC_OPC_COPY_SRC1_TO_RF = 7,
	BNXT_ULP_FUNC_OPC_RSS_CONFIG = 8,
	BNXT_ULP_FUNC_OPC_GET_PARENT_MAC_ADDR = 9,
	BNXT_ULP_FUNC_OPC_ALLOC_L2_CTX_ID = 10,
	BNXT_ULP_FUNC_OPC_TUNNEL_DST_PORT_ALLOC = 11,
	BNXT_ULP_FUNC_OPC_TUNNEL_DST_PORT_FREE = 12,
	BNXT_ULP_FUNC_OPC_LAST = 13
};

enum bnxt_ulp_func_src {
	BNXT_ULP_FUNC_SRC_REGFILE = 0,
	BNXT_ULP_FUNC_SRC_GLB_REGFILE = 1,
	BNXT_ULP_FUNC_SRC_COMP_FIELD = 2,
	BNXT_ULP_FUNC_SRC_CONST = 3,
	BNXT_ULP_FUNC_SRC_LAST = 4
};

enum bnxt_ulp_generic_tbl_lkup_type {
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_INDEX = 0,
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_HASH = 1,
	BNXT_ULP_GENERIC_TBL_LKUP_TYPE_LAST = 2
};

enum bnxt_ulp_generic_tbl_opc {
	BNXT_ULP_GENERIC_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_GENERIC_TBL_OPC_READ = 1,
	BNXT_ULP_GENERIC_TBL_OPC_WRITE = 2,
	BNXT_ULP_GENERIC_TBL_OPC_LAST = 3
};

enum bnxt_ulp_glb_rf_idx {
	BNXT_ULP_GLB_RF_IDX_NOT_USED = 0,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID = 1,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID_0 = 2,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID_1 = 3,
	BNXT_ULP_GLB_RF_IDX_GLB_PROF_FUNC_ID_2 = 4,
	BNXT_ULP_GLB_RF_IDX_GLB_LB_AREC_PTR = 5,
	BNXT_ULP_GLB_RF_IDX_L2_PROF_FUNC_ID = 6,
	BNXT_ULP_GLB_RF_IDX_GLB_L2_CNTXT_ID_0 = 7,
	BNXT_ULP_GLB_RF_IDX_GLB_L2_CNTXT_ID_1 = 8,
	BNXT_ULP_GLB_RF_IDX_VXLAN_PROF_FUNC_ID = 9,
	BNXT_ULP_GLB_RF_IDX_VF_2_VFR_PROF_FUNC_ID = 10,
	BNXT_ULP_GLB_RF_IDX_ANY_2_VF_PROF_FUNC_ID = 11,
	BNXT_ULP_GLB_RF_IDX_GLB_MODIFY_PTR = 12,
	BNXT_ULP_GLB_RF_IDX_GLB_DROP_AREC_PTR = 13,
	BNXT_ULP_GLB_RF_IDX_ENCAP_MAC_PTR = 14,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_0 = 15,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_1 = 16,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_2 = 17,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_3 = 18,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_4 = 19,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_5 = 20,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_6 = 21,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_7 = 22,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_8 = 23,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_PROFILE_ID_9 = 24,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_0 = 25,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_1 = 26,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_2 = 27,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_3 = 28,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_4 = 29,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_5 = 30,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_6 = 31,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_7 = 32,
	BNXT_ULP_GLB_RF_IDX_GLB_WC_KEY_ID_8 = 33,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_0 = 34,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_1 = 35,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_2 = 36,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_3 = 37,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_4 = 38,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_5 = 39,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_6 = 40,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_7 = 41,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_8 = 42,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_PROFILE_ID_9 = 43,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_0 = 44,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_1 = 45,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_2 = 46,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_3 = 47,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_4 = 48,
	BNXT_ULP_GLB_RF_IDX_GLB_EM_KEY_ID_5 = 49,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_PROF_0 = 50,
	BNXT_ULP_GLB_RF_IDX_GLB_METADATA_PROF_1 = 51,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_0 = 52,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_KEY_ID_1 = 53,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_0 = 54,
	BNXT_ULP_GLB_RF_IDX_GLB_VFR_EM_PROF_ID_1 = 55,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_0 = 56,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_1 = 57,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_2 = 58,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_PROF_FUNC_ID_3 = 59,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_0 = 60,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_1 = 61,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_2 = 62,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_L2_CNTXT_ID_3 = 63,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_PROFILE_ID_0 = 64,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_PROFILE_ID_1 = 65,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_0 = 66,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_1 = 67,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_2 = 68,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_3 = 69,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_4 = 70,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_5 = 71,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_6 = 72,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_7 = 73,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_8 = 74,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_9 = 75,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_PROFILE_ID_10 = 76,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_KEY_ID_0 = 77,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_EM_KEY_ID_1 = 78,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_0 = 79,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_1 = 80,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_2 = 81,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_3 = 82,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_WC_KEY_ID_4 = 83,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_AREC_PTR_0 = 84,
	BNXT_ULP_GLB_RF_IDX_APP_GLB_AREC_PTR_1 = 85,
	BNXT_ULP_GLB_RF_IDX_GRE_PROF_FUNC_ID = 86,
	BNXT_ULP_GLB_RF_IDX_RECYCLE_PROF_FUNC_ID = 87,
	BNXT_ULP_GLB_RF_IDX_GLB_ECPRI_UPAR_ID = 88,
	BNXT_ULP_GLB_RF_IDX_GLB_ECPRI_PROF_FUNC_ID = 89,
	BNXT_ULP_GLB_RF_IDX_LAST = 90
};

enum bnxt_ulp_global_register_tbl_opc {
	BNXT_ULP_GLOBAL_REGISTER_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_GLOBAL_REGISTER_TBL_OPC_WR_REGFILE = 1,
	BNXT_ULP_GLOBAL_REGISTER_TBL_OPC_LAST = 2
};

enum bnxt_ulp_hdr_type {
	BNXT_ULP_HDR_TYPE_NOT_SUPPORTED = 0,
	BNXT_ULP_HDR_TYPE_SUPPORTED = 1,
	BNXT_ULP_HDR_TYPE_END = 2,
	BNXT_ULP_HDR_TYPE_LAST = 3
};

enum bnxt_ulp_if_tbl_opc {
	BNXT_ULP_IF_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_IF_TBL_OPC_WR_COMP_FIELD = 1,
	BNXT_ULP_IF_TBL_OPC_WR_REGFILE = 2,
	BNXT_ULP_IF_TBL_OPC_WR_CONST = 3,
	BNXT_ULP_IF_TBL_OPC_RD_COMP_FIELD = 4,
	BNXT_ULP_IF_TBL_OPC_LAST = 5
};

enum bnxt_ulp_index_tbl_opc {
	BNXT_ULP_INDEX_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_REGFILE = 1,
	BNXT_ULP_INDEX_TBL_OPC_WR_REGFILE = 2,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_REGFILE = 3,
	BNXT_ULP_INDEX_TBL_OPC_RD_REGFILE = 4,
	BNXT_ULP_INDEX_TBL_OPC_ALLOC_WR_GLB_REGFILE = 5,
	BNXT_ULP_INDEX_TBL_OPC_WR_GLB_REGFILE = 6,
	BNXT_ULP_INDEX_TBL_OPC_UPDATE_REGFILE = 7,
	BNXT_ULP_INDEX_TBL_OPC_LAST = 8
};

enum bnxt_ulp_mark_db_opc {
	BNXT_ULP_MARK_DB_OPC_NOP = 0,
	BNXT_ULP_MARK_DB_OPC_PUSH_IF_MARK_ACTION = 1,
	BNXT_ULP_MARK_DB_OPC_PUSH_AND_SET_VFR_FLAG = 2,
	BNXT_ULP_MARK_DB_OPC_LAST = 3
};

enum bnxt_ulp_match_type {
	BNXT_ULP_MATCH_TYPE_EM = 0,
	BNXT_ULP_MATCH_TYPE_WM = 1,
	BNXT_ULP_MATCH_TYPE_LAST = 2
};

enum bnxt_ulp_port_table {
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARENT_MAC = 0,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARENT_VNIC = 1,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_SVIF = 2,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_SPIF = 3,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PARIF = 4,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_VNIC = 5,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_PHY_PORT = 6,
	BNXT_ULP_PORT_TABLE_DRV_FUNC_MAC = 7,
	BNXT_ULP_PORT_TABLE_VF_FUNC_SVIF = 8,
	BNXT_ULP_PORT_TABLE_VF_FUNC_SPIF = 9,
	BNXT_ULP_PORT_TABLE_VF_FUNC_PARIF = 10,
	BNXT_ULP_PORT_TABLE_VF_FUNC_VNIC = 11,
	BNXT_ULP_PORT_TABLE_VF_FUNC_MAC = 12,
	BNXT_ULP_PORT_TABLE_PHY_PORT_SVIF = 13,
	BNXT_ULP_PORT_TABLE_PHY_PORT_SPIF = 14,
	BNXT_ULP_PORT_TABLE_PHY_PORT_PARIF = 15,
	BNXT_ULP_PORT_TABLE_PHY_PORT_VPORT = 16,
	BNXT_ULP_PORT_TABLE_PORT_IS_PF = 17,
	BNXT_ULP_PORT_TABLE_VF_FUNC_METADATA = 18,
	BNXT_ULP_PORT_TABLE_LAST = 19
};

enum bnxt_ulp_pri_opc {
	BNXT_ULP_PRI_OPC_NOT_USED = 0,
	BNXT_ULP_PRI_OPC_CONST = 1,
	BNXT_ULP_PRI_OPC_APP_PRI = 2,
	BNXT_ULP_PRI_OPC_APP_PRI_OR_CONST = 3,
	BNXT_ULP_PRI_OPC_LAST = 4
};

enum bnxt_ulp_ref_cnt_opc {
	BNXT_ULP_REF_CNT_OPC_DEFAULT = 0,
	BNXT_ULP_REF_CNT_OPC_NOP = 1,
	BNXT_ULP_REF_CNT_OPC_DEC = 2,
	BNXT_ULP_REF_CNT_OPC_INC = 3,
	BNXT_ULP_REF_CNT_OPC_LAST = 4
};

enum bnxt_ulp_rf_idx {
	BNXT_ULP_RF_IDX_NOT_USED = 0,
	BNXT_ULP_RF_IDX_L2_CNTXT_ID_0 = 1,
	BNXT_ULP_RF_IDX_L2_CNTXT_ID_1 = 2,
	BNXT_ULP_RF_IDX_PROF_FUNC_ID_0 = 3,
	BNXT_ULP_RF_IDX_PROF_FUNC_ID_1 = 4,
	BNXT_ULP_RF_IDX_EM_PROFILE_ID_0 = 5,
	BNXT_ULP_RF_IDX_EM_PROFILE_ID_1 = 6,
	BNXT_ULP_RF_IDX_WC_PROFILE_ID_0 = 7,
	BNXT_ULP_RF_IDX_WC_PROFILE_ID_1 = 8,
	BNXT_ULP_RF_IDX_MAIN_ACTION_PTR = 9,
	BNXT_ULP_RF_IDX_ACTION_PTR_0 = 10,
	BNXT_ULP_RF_IDX_ENCAP_PTR_0 = 11,
	BNXT_ULP_RF_IDX_ENCAP_PTR_1 = 12,
	BNXT_ULP_RF_IDX_CRITICAL_RESOURCE = 13,
	BNXT_ULP_RF_IDX_FLOW_CNTR_PTR_0 = 14,
	BNXT_ULP_RF_IDX_MAIN_SP_PTR = 15,
	BNXT_ULP_RF_IDX_MODIFY_IPV4_SRC_PTR_0 = 16,
	BNXT_ULP_RF_IDX_MODIFY_IPV4_DST_PTR_0 = 17,
	BNXT_ULP_RF_IDX_ACTION_REC_SIZE = 18,
	BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_0 = 19,
	BNXT_ULP_RF_IDX_L2_CNTXT_TCAM_INDEX_1 = 20,
	BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_0 = 21,
	BNXT_ULP_RF_IDX_PROFILE_TCAM_INDEX_1 = 22,
	BNXT_ULP_RF_IDX_WC_TCAM_INDEX_0 = 23,
	BNXT_ULP_RF_IDX_WC_TCAM_INDEX_1 = 24,
	BNXT_ULP_RF_IDX_SRC_PROPERTY_PTR = 25,
	BNXT_ULP_RF_IDX_GENERIC_TBL_MISS = 26,
	BNXT_ULP_RF_IDX_MIRROR_PTR_0 = 27,
	BNXT_ULP_RF_IDX_MIRROR_ID_0 = 28,
	BNXT_ULP_RF_IDX_HDR_SIG_ID = 29,
	BNXT_ULP_RF_IDX_FLOW_SIG_ID = 30,
	BNXT_ULP_RF_IDX_RID = 31,
	BNXT_ULP_RF_IDX_WC_KEY_ID_0 = 32,
	BNXT_ULP_RF_IDX_EM_KEY_ID_0 = 33,
	BNXT_ULP_RF_IDX_DRV_FUNC_MAC = 34,
	BNXT_ULP_RF_IDX_DRV_FUNC_PARENT_MAC = 35,
	BNXT_ULP_RF_IDX_DEFAULT_AREC_PTR = 36,
	BNXT_ULP_RF_IDX_CC = 37,
	BNXT_ULP_RF_IDX_CF_FLOW_SIG_ID = 38,
	BNXT_ULP_RF_IDX_PHY_PORT = 39,
	BNXT_ULP_RF_IDX_METADATA_PROF = 40,
	BNXT_ULP_RF_IDX_MODIFY_PTR = 41,
	BNXT_ULP_RF_IDX_SOCK_DIR_SVIF = 42,
	BNXT_ULP_RF_IDX_SOCK_DIR_PARIF = 43,
	BNXT_ULP_RF_IDX_SOCK_DIR_ACT_PTR = 44,
	BNXT_ULP_RF_IDX_SOCK_DIR_PARENT_MAC = 45,
	BNXT_ULP_RF_IDX_RSS_VNIC = 46,
	BNXT_ULP_RF_IDX_PORT_IS_PF = 47,
	BNXT_ULP_RF_IDX_METER_PROFILE_PTR_0 = 48,
	BNXT_ULP_RF_IDX_METER_PTR_0 = 49,
	BNXT_ULP_RF_IDX_REF_CNT = 50,
	BNXT_ULP_RF_IDX_RF_0 = 51,
	BNXT_ULP_RF_IDX_RF_1 = 52,
	BNXT_ULP_RF_IDX_RF_2 = 53,
	BNXT_ULP_RF_IDX_RF_3 = 54,
	BNXT_ULP_RF_IDX_RF_4 = 55,
	BNXT_ULP_RF_IDX_RF_5 = 56,
	BNXT_ULP_RF_IDX_RF_6 = 57,
	BNXT_ULP_RF_IDX_RF_7 = 58,
	BNXT_ULP_RF_IDX_VF_FUNC_METADATA = 59,
	BNXT_ULP_RF_IDX_CHAIN_ID_METADATA = 60,
	BNXT_ULP_RF_IDX_LAST = 61
};

enum bnxt_ulp_tcam_tbl_opc {
	BNXT_ULP_TCAM_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_WR_REGFILE = 1,
	BNXT_ULP_TCAM_TBL_OPC_SRCH_ALLOC_WR_REGFILE = 2,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_REGFILE = 3,
	BNXT_ULP_TCAM_TBL_OPC_WR_REGFILE = 4,
	BNXT_ULP_TCAM_TBL_OPC_ALLOC_IDENT = 5,
	BNXT_ULP_TCAM_TBL_OPC_LAST = 6
};

enum bnxt_ulp_template_type {
	BNXT_ULP_TEMPLATE_TYPE_CLASS = 0,
	BNXT_ULP_TEMPLATE_TYPE_ACTION = 1,
	BNXT_ULP_TEMPLATE_TYPE_LAST = 2
};

enum bnxt_ulp_vnic_tbl_opc {
	BNXT_ULP_VNIC_TBL_OPC_NOT_USED = 0,
	BNXT_ULP_VNIC_TBL_OPC_ALLOC_WR_REGFILE = 1,
	BNXT_ULP_VNIC_TBL_OPC_LAST = 2
};

enum bnxt_ulp_app_cap {
	BNXT_ULP_APP_CAP_SHARED_EN = 0x00000001,
	BNXT_ULP_APP_CAP_HOT_UPGRADE_EN = 0x00000002,
	BNXT_ULP_APP_CAP_UNICAST_ONLY = 0x00000004,
	BNXT_ULP_APP_CAP_SOCKET_DIRECT = 0x00000008,
	BNXT_ULP_APP_CAP_IP_TOS_PROTO_SUPPORT = 0x00000010,
	BNXT_ULP_APP_CAP_BC_MC_SUPPORT = 0x00000020,
	BNXT_ULP_APP_CAP_CUST_VXLAN = 0x00000040,
	BNXT_ULP_APP_CAP_HA_DYNAMIC = 0x00000080,
	BNXT_ULP_APP_CAP_SRV6 = 0x00000100
};

enum bnxt_ulp_fdb_resource_flags {
	BNXT_ULP_FDB_RESOURCE_FLAGS_DIR_INGR = 0x00,
	BNXT_ULP_FDB_RESOURCE_FLAGS_DIR_EGR = 0x01
};

enum bnxt_ulp_flow_dir_bitmask {
	BNXT_ULP_FLOW_DIR_BITMASK_ING = 0x0000000000000000,
	BNXT_ULP_FLOW_DIR_BITMASK_EGR = 0x8000000000000000
};

enum bnxt_ulp_resource_func {
	BNXT_ULP_RESOURCE_FUNC_INVALID = 0x00,
	BNXT_ULP_RESOURCE_FUNC_EM_TABLE = 0x20,
	BNXT_ULP_RESOURCE_FUNC_RSVD1 = 0x40,
	BNXT_ULP_RESOURCE_FUNC_RSVD2 = 0x60,
	BNXT_ULP_RESOURCE_FUNC_TCAM_TABLE = 0x80,
	BNXT_ULP_RESOURCE_FUNC_INDEX_TABLE = 0x81,
	BNXT_ULP_RESOURCE_FUNC_GENERIC_TABLE = 0x82,
	BNXT_ULP_RESOURCE_FUNC_IDENTIFIER = 0x83,
	BNXT_ULP_RESOURCE_FUNC_IF_TABLE = 0x84,
	BNXT_ULP_RESOURCE_FUNC_HW_FID = 0x85,
	BNXT_ULP_RESOURCE_FUNC_PARENT_FLOW = 0x86,
	BNXT_ULP_RESOURCE_FUNC_CHILD_FLOW = 0x87,
	BNXT_ULP_RESOURCE_FUNC_CTRL_TABLE = 0x88,
	BNXT_ULP_RESOURCE_FUNC_VNIC_TABLE = 0x89,
	BNXT_ULP_RESOURCE_FUNC_GLOBAL_REGISTER_TABLE = 0x8a
};

enum bnxt_ulp_resource_sub_type {
	BNXT_ULP_RESOURCE_SUB_TYPE_NOT_USED = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_NORMAL = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_VFR_CFA_ACTION = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_INT_COUNT = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_INT_COUNT_ACC = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_INDEX_TABLE_EXT_COUNT = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_CNTXT_TCAM = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PROFILE_TCAM = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SHARED_MIRROR = 2,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_MAC_ADDR_CACHE = 3,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_PORT_TABLE = 4,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_TUNNEL_CACHE = 5,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOURCE_PROPERTY_CACHE = 6,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_VXLAN_ENCAP_REC_CACHE = 7,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOCKET_DIRECT_CACHE = 8,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_VXLAN_ENCAP_IPV6_REC_CACHE = 9,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SOURCE_PROPERTY_IPV6_CACHE = 10,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_OUTER_TUNNEL_CACHE = 11,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SHARED_METER_TBL_CACHE = 12,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_METER_PROFILE_TBL_CACHE = 13,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_GLOBAL_REGISTER_TBL = 14,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_CHAIN_ID_CACHE = 15,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_L2_ENCAP_REC_CACHE = 16,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_SRV6_ENCAP_REC_CACHE = 17,
	BNXT_ULP_RESOURCE_SUB_TYPE_GENERIC_TABLE_RSS_PARAMS = 18,
	BNXT_ULP_RESOURCE_SUB_TYPE_VNIC_TABLE_RSS = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_VNIC_TABLE_QUEUE = 1,
	BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_VXLAN = 0,
	BNXT_ULP_RESOURCE_SUB_TYPE_GLOBAL_REGISTER_CUST_ECPRI = 1
};

enum bnxt_ulp_session_type {
	BNXT_ULP_SESSION_TYPE_DEFAULT = 0x00,
	BNXT_ULP_SESSION_TYPE_SHARED = 0x01,
	BNXT_ULP_SESSION_TYPE_SHARED_WC = 0x02,
	BNXT_ULP_SESSION_TYPE_SHARED_OWC = 0x04,
	BNXT_ULP_SESSION_TYPE_DEFAULT_NON_HA = 0x08,
	BNXT_ULP_SESSION_TYPE_LAST = 0x10
};

enum bnxt_ulp_act_prop_sz {
	BNXT_ULP_ACT_PROP_SZ_ENCAP_TUN_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_SZ = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_TYPE = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L3_TYPE = 4,
	BNXT_ULP_ACT_PROP_SZ_MPLS_POP_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_MPLS_PUSH_NUM = 4,
	BNXT_ULP_ACT_PROP_SZ_PORT_ID = 4,
	BNXT_ULP_ACT_PROP_SZ_VNIC = 4,
	BNXT_ULP_ACT_PROP_SZ_VPORT = 4,
	BNXT_ULP_ACT_PROP_SZ_MARK = 4,
	BNXT_ULP_ACT_PROP_SZ_COUNT = 4,
	BNXT_ULP_ACT_PROP_SZ_METER = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_MAC_SRC = 6,
	BNXT_ULP_ACT_PROP_SZ_SET_MAC_DST = 6,
	BNXT_ULP_ACT_PROP_SZ_PUSH_VLAN = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_VLAN_PCP = 1,
	BNXT_ULP_ACT_PROP_SZ_SET_VLAN_VID = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV4_SRC = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV4_DST = 4,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV6_SRC = 16,
	BNXT_ULP_ACT_PROP_SZ_SET_IPV6_DST = 16,
	BNXT_ULP_ACT_PROP_SZ_SET_TP_SRC = 2,
	BNXT_ULP_ACT_PROP_SZ_SET_TP_DST = 2,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_0 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_1 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_2 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_3 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_4 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_5 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_6 = 4,
	BNXT_ULP_ACT_PROP_SZ_OF_PUSH_MPLS_7 = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L2_DMAC = 6,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_L2_SMAC = 6,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_VTAG = 8,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP = 32,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_IP_SRC = 16,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_UDP = 4,
	BNXT_ULP_ACT_PROP_SZ_ENCAP_TUN = 32,
	BNXT_ULP_ACT_PROP_SZ_JUMP = 4,
	BNXT_ULP_ACT_PROP_SZ_SHARED_HANDLE = 8,
	BNXT_ULP_ACT_PROP_SZ_RSS_TYPES = 8,
	BNXT_ULP_ACT_PROP_SZ_RSS_LEVEL = 4,
	BNXT_ULP_ACT_PROP_SZ_RSS_KEY_LEN = 4,
	BNXT_ULP_ACT_PROP_SZ_RSS_KEY = 40,
	BNXT_ULP_ACT_PROP_SZ_RSS_QUEUE_NUM = 2,
	BNXT_ULP_ACT_PROP_SZ_RSS_QUEUE = 32,
	BNXT_ULP_ACT_PROP_SZ_QUEUE_INDEX = 2,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_ID_UPDATE = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_ID = 4,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CIR = 3,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EIR = 3,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CBS = 2,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EBS = 2,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_RFC2698 = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_PM = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EBND = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CBND = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_EBSM = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CBSM = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_PROF_CF = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_ID = 4,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_ECN_RMP_EN_UPDATE = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_ECN_RMP_EN = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_MTR_VAL_UPDATE = 1,
	BNXT_ULP_ACT_PROP_SZ_METER_INST_MTR_VAL = 1,
	BNXT_ULP_ACT_PROP_SZ_GOTO_CHAINID = 2,
	BNXT_ULP_ACT_PROP_SZ_LAST = 4
};

enum bnxt_ulp_act_prop_idx {
	BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN_SZ = 0,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SZ = 4,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_SZ = 8,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_TYPE = 12,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG_NUM = 16,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L3_TYPE = 20,
	BNXT_ULP_ACT_PROP_IDX_MPLS_POP_NUM = 24,
	BNXT_ULP_ACT_PROP_IDX_MPLS_PUSH_NUM = 28,
	BNXT_ULP_ACT_PROP_IDX_PORT_ID = 32,
	BNXT_ULP_ACT_PROP_IDX_VNIC = 36,
	BNXT_ULP_ACT_PROP_IDX_VPORT = 40,
	BNXT_ULP_ACT_PROP_IDX_MARK = 44,
	BNXT_ULP_ACT_PROP_IDX_COUNT = 48,
	BNXT_ULP_ACT_PROP_IDX_METER = 52,
	BNXT_ULP_ACT_PROP_IDX_SET_MAC_SRC = 56,
	BNXT_ULP_ACT_PROP_IDX_SET_MAC_DST = 62,
	BNXT_ULP_ACT_PROP_IDX_PUSH_VLAN = 68,
	BNXT_ULP_ACT_PROP_IDX_SET_VLAN_PCP = 70,
	BNXT_ULP_ACT_PROP_IDX_SET_VLAN_VID = 71,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV4_SRC = 73,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV4_DST = 77,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV6_SRC = 81,
	BNXT_ULP_ACT_PROP_IDX_SET_IPV6_DST = 97,
	BNXT_ULP_ACT_PROP_IDX_SET_TP_SRC = 113,
	BNXT_ULP_ACT_PROP_IDX_SET_TP_DST = 115,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_0 = 117,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_1 = 121,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_2 = 125,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_3 = 129,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_4 = 133,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_5 = 137,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_6 = 141,
	BNXT_ULP_ACT_PROP_IDX_OF_PUSH_MPLS_7 = 145,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_DMAC = 149,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_L2_SMAC = 155,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_VTAG = 161,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP = 169,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_IP_SRC = 201,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_UDP = 217,
	BNXT_ULP_ACT_PROP_IDX_ENCAP_TUN = 221,
	BNXT_ULP_ACT_PROP_IDX_JUMP = 253,
	BNXT_ULP_ACT_PROP_IDX_SHARED_HANDLE = 257,
	BNXT_ULP_ACT_PROP_IDX_RSS_TYPES = 265,
	BNXT_ULP_ACT_PROP_IDX_RSS_LEVEL = 273,
	BNXT_ULP_ACT_PROP_IDX_RSS_KEY_LEN = 277,
	BNXT_ULP_ACT_PROP_IDX_RSS_KEY = 281,
	BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE_NUM = 321,
	BNXT_ULP_ACT_PROP_IDX_RSS_QUEUE = 323,
	BNXT_ULP_ACT_PROP_IDX_QUEUE_INDEX = 355,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_ID_UPDATE = 357,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_ID = 358,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CIR = 362,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EIR = 365,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBS = 368,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBS = 370,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_RFC2698 = 372,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_PM = 373,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBND = 374,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBND = 375,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_EBSM = 376,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CBSM = 377,
	BNXT_ULP_ACT_PROP_IDX_METER_PROF_CF = 378,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_ID = 379,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_ECN_RMP_EN_UPDATE = 383,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_ECN_RMP_EN = 384,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_MTR_VAL_UPDATE = 385,
	BNXT_ULP_ACT_PROP_IDX_METER_INST_MTR_VAL = 386,
	BNXT_ULP_ACT_PROP_IDX_GOTO_CHAINID = 387,
	BNXT_ULP_ACT_PROP_IDX_LAST = 389
};

enum ulp_wp_sym {
	ULP_WP_SYM_METADATA_OP_NORMAL = 0,
	ULP_WP_SYM_METADATA_OP_L2_HASH = 0,
	ULP_WP_SYM_METADATA_OP_L4_HASH = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_CFA = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_CFA_ROCE = 0,
	ULP_WP_SYM_FWD_OP_BYPASS_LKUP = 0,
	ULP_WP_SYM_FWD_OP_NORMAL_FLOW = 0,
	ULP_WP_SYM_CTXT_OPCODE_BYPASS_CFA = 0,
	ULP_WP_SYM_CTXT_OPCODE_BYPASS_LKUP = 0,
	ULP_WP_SYM_CTXT_OPCODE_META_UPDATE = 0,
	ULP_WP_SYM_CTXT_OPCODE_NORMAL_FLOW = 0,
	ULP_WP_SYM_CTXT_OPCODE_DROP = 0,
	ULP_WP_SYM_PKT_TYPE_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_L2 = 0,
	ULP_WP_SYM_PKT_TYPE_0_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_0_L2 = 0,
	ULP_WP_SYM_PKT_TYPE_1_IGNORE = 0,
	ULP_WP_SYM_PKT_TYPE_1_L2 = 0,
	ULP_WP_SYM_RECYCLE_CNT_IGNORE = 0,
	ULP_WP_SYM_RECYCLE_CNT_ZERO = 0,
	ULP_WP_SYM_RECYCLE_CNT_ONE = 1,
	ULP_WP_SYM_RECYCLE_CNT_TWO = 2,
	ULP_WP_SYM_RECYCLE_CNT_THREE = 3,
	ULP_WP_SYM_AGG_ERROR_IGNORE = 0,
	ULP_WP_SYM_AGG_ERROR_NO = 0,
	ULP_WP_SYM_AGG_ERROR_YES = 1,
	ULP_WP_SYM_RESERVED_IGNORE = 0,
	ULP_WP_SYM_HREC_NEXT_IGNORE = 0,
	ULP_WP_SYM_HREC_NEXT_NO = 0,
	ULP_WP_SYM_HREC_NEXT_YES = 1,
	ULP_WP_SYM_TL2_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL2_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL2_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL2_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL2_HDR_TYPE_DIX = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_IGNORE = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_UC = 0,
	ULP_WP_SYM_TL2_UC_MC_BC_MC = 2,
	ULP_WP_SYM_TL2_UC_MC_BC_BC = 3,
	ULP_WP_SYM_TL2_VTAG_PRESENT_IGNORE = 0,
	ULP_WP_SYM_TL2_VTAG_PRESENT_NO = 0,
	ULP_WP_SYM_TL2_VTAG_PRESENT_YES = 1,
	ULP_WP_SYM_TL2_TWO_VTAGS_IGNORE = 0,
	ULP_WP_SYM_TL2_TWO_VTAGS_NO = 0,
	ULP_WP_SYM_TL2_TWO_VTAGS_YES = 1,
	ULP_WP_SYM_TL3_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL3_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL3_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TL3_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TL3_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_TYPE_IPV4 = 0,
	ULP_WP_SYM_TL3_HDR_TYPE_IPV6 = 1,
	ULP_WP_SYM_TL3_HDR_ISIP_IGNORE = 0,
	ULP_WP_SYM_TL3_HDR_ISIP_NO = 0,
	ULP_WP_SYM_TL3_HDR_ISIP_YES = 1,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_NO = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_SRC_YES = 1,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_IGNORE = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_NO = 0,
	ULP_WP_SYM_TL3_IPV6_CMP_DST_YES = 1,
	ULP_WP_SYM_TL4_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_VALID_NO = 0,
	ULP_WP_SYM_TL4_HDR_VALID_YES = 1,
	ULP_WP_SYM_TL4_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TL4_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_NO = 0,
	ULP_WP_SYM_TL4_HDR_IS_UDP_TCP_YES = 1,
	ULP_WP_SYM_TL4_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TL4_HDR_TYPE_TCP = 0,
	ULP_WP_SYM_TL4_HDR_TYPE_UDP = 1,
	ULP_WP_SYM_TUN_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_VALID_NO = 0,
	ULP_WP_SYM_TUN_HDR_VALID_YES = 1,
	ULP_WP_SYM_TUN_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_ERROR_NO = 0,
	ULP_WP_SYM_TUN_HDR_ERROR_YES = 1,
	ULP_WP_SYM_TUN_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_VXLAN = 0,
	ULP_WP_SYM_TUN_HDR_TYPE_GENEVE = 1,
	ULP_WP_SYM_TUN_HDR_TYPE_NVGRE = 2,
	ULP_WP_SYM_TUN_HDR_TYPE_GRE = 3,
	ULP_WP_SYM_TUN_HDR_TYPE_IPV4 = 4,
	ULP_WP_SYM_TUN_HDR_TYPE_IPV6 = 5,
	ULP_WP_SYM_TUN_HDR_TYPE_PPPOE = 6,
	ULP_WP_SYM_TUN_HDR_TYPE_MPLS = 7,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR1 = 8,
	ULP_WP_SYM_TUN_HDR_TYPE_UPAR2 = 9,
	ULP_WP_SYM_TUN_HDR_TYPE_NONE = 15,
	ULP_WP_SYM_TUN_HDR_FLAGS_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_VALID_NO = 0,
	ULP_WP_SYM_L2_HDR_VALID_YES = 1,
	ULP_WP_SYM_L2_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L2_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L2_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L2_HDR_TYPE_DIX = 0,
	ULP_WP_SYM_L2_HDR_TYPE_LLC_SNAP = 1,
	ULP_WP_SYM_L2_HDR_TYPE_LLC = 2,
	ULP_WP_SYM_L2_UC_MC_BC_IGNORE = 0,
	ULP_WP_SYM_L2_UC_MC_BC_UC = 0,
	ULP_WP_SYM_L2_UC_MC_BC_MC = 2,
	ULP_WP_SYM_L2_UC_MC_BC_BC = 3,
	ULP_WP_SYM_L2_VTAG_PRESENT_IGNORE = 0,
	ULP_WP_SYM_L2_VTAG_PRESENT_NO = 0,
	ULP_WP_SYM_L2_VTAG_PRESENT_YES = 1,
	ULP_WP_SYM_L2_TWO_VTAGS_IGNORE = 0,
	ULP_WP_SYM_L2_TWO_VTAGS_NO = 0,
	ULP_WP_SYM_L2_TWO_VTAGS_YES = 1,
	ULP_WP_SYM_L3_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_VALID_NO = 0,
	ULP_WP_SYM_L3_HDR_VALID_YES = 1,
	ULP_WP_SYM_L3_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L3_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L3_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_TYPE_IPV4 = 0,
	ULP_WP_SYM_L3_HDR_TYPE_IPV6 = 1,
	ULP_WP_SYM_L3_HDR_TYPE_ARP = 2,
	ULP_WP_SYM_L3_HDR_TYPE_PTP = 3,
	ULP_WP_SYM_L3_HDR_TYPE_EAPOL = 4,
	ULP_WP_SYM_L3_HDR_TYPE_ROCE = 5,
	ULP_WP_SYM_L3_HDR_TYPE_FCOE = 6,
	ULP_WP_SYM_L3_HDR_TYPE_UPAR1 = 7,
	ULP_WP_SYM_L3_HDR_TYPE_UPAR2 = 8,
	ULP_WP_SYM_L3_HDR_ISIP_IGNORE = 0,
	ULP_WP_SYM_L3_HDR_ISIP_NO = 0,
	ULP_WP_SYM_L3_HDR_ISIP_YES = 1,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_NO = 0,
	ULP_WP_SYM_L3_IPV6_CMP_SRC_YES = 1,
	ULP_WP_SYM_L3_IPV6_CMP_DST_IGNORE = 0,
	ULP_WP_SYM_L3_IPV6_CMP_DST_NO = 0,
	ULP_WP_SYM_L3_IPV6_CMP_DST_YES = 1,
	ULP_WP_SYM_L4_HDR_VALID_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_VALID_NO = 0,
	ULP_WP_SYM_L4_HDR_VALID_YES = 1,
	ULP_WP_SYM_L4_HDR_ERROR_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_ERROR_NO = 0,
	ULP_WP_SYM_L4_HDR_ERROR_YES = 1,
	ULP_WP_SYM_L4_HDR_TYPE_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_TYPE_TCP = 0,
	ULP_WP_SYM_L4_HDR_TYPE_UDP = 1,
	ULP_WP_SYM_L4_HDR_TYPE_ICMP = 2,
	ULP_WP_SYM_L4_HDR_TYPE_UPAR1 = 3,
	ULP_WP_SYM_L4_HDR_TYPE_UPAR2 = 4,
	ULP_WP_SYM_L4_HDR_TYPE_BTH_V1 = 5,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_NO = 0,
	ULP_WP_SYM_L4_HDR_IS_UDP_TCP_YES = 1,
	ULP_WP_SYM_EM_WM_OPCODE_OP_NORMAL = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_RFS_FAST = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_FAST = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_RFS_ACT = 0,
	ULP_WP_SYM_EM_WM_OPCODE_OP_RECYCLE = 0,
	ULP_WP_SYM_POP_VLAN_NO = 0,
	ULP_WP_SYM_POP_VLAN_YES = 1,
	ULP_WP_SYM_VLAN_DEL_RPT_DISABLED = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_STRIP_OUTER = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_STRIP_BOTH = 0,
	ULP_WP_SYM_VLAN_DEL_RPT_DYN_STRIP = 0,
	ULP_WP_SYM_DECAP_FUNC_NONE = 0,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL2 = 3,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL3 = 8,
	ULP_WP_SYM_DECAP_FUNC_THRU_TL4 = 9,
	ULP_WP_SYM_DECAP_FUNC_THRU_TUN = 10,
	ULP_WP_SYM_DECAP_FUNC_THRU_L2 = 11,
	ULP_WP_SYM_DECAP_FUNC_THRU_L3 = 12,
	ULP_WP_SYM_DECAP_FUNC_THRU_L4 = 13,
	ULP_WP_SYM_ECV_VALID_NO = 0,
	ULP_WP_SYM_ECV_VALID_YES = 1,
	ULP_WP_SYM_ECV_CUSTOM_EN_NO = 0,
	ULP_WP_SYM_ECV_CUSTOM_EN_YES = 1,
	ULP_WP_SYM_ECV_L2_EN_NO = 0,
	ULP_WP_SYM_ECV_L2_EN_YES = 1,
	ULP_WP_SYM_ECV_VTAG_TYPE_NOP = 0,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_ENCAP_PRI = 1,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_IVLAN_PRI = 2,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_1_REMAP_DIFFSERV = 3,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_2_ENCAP_PRI = 4,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_2_REMAP_DIFFSERV = 5,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_ENCAP_PRI = 6,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_REMAP_DIFFSERV = 7,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_0 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_1 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_2 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_3 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_4 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_5 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_6 = 8,
	ULP_WP_SYM_ECV_VTAG_TYPE_ADD_0_PRI_7 = 8,
	ULP_WP_SYM_ECV_L3_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_L3_TYPE_IPV4 = 4,
	ULP_WP_SYM_ECV_L3_TYPE_IPV6 = 5,
	ULP_WP_SYM_ECV_L3_TYPE_MPLS_8847 = 6,
	ULP_WP_SYM_ECV_L3_TYPE_MPLS_8848 = 7,
	ULP_WP_SYM_ECV_L4_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_L4_TYPE_UDP = 4,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_CSUM = 5,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_ENTROPY = 6,
	ULP_WP_SYM_ECV_L4_TYPE_UDP_ENTROPY_CSUM = 7,
	ULP_WP_SYM_ECV_TUN_TYPE_NONE = 0,
	ULP_WP_SYM_ECV_TUN_TYPE_GENERIC = 1,
	ULP_WP_SYM_ECV_TUN_TYPE_VXLAN = 2,
	ULP_WP_SYM_ECV_TUN_TYPE_NGE = 3,
	ULP_WP_SYM_ECV_TUN_TYPE_NVGRE = 4,
	ULP_WP_SYM_ECV_TUN_TYPE_GRE = 5,
	ULP_WP_SYM_EEM_ACT_REC_INT = 1,
	ULP_WP_SYM_EEM_EXT_FLOW_CNTR = 0,
	ULP_WP_SYM_UC_ACT_REC = 0,
	ULP_WP_SYM_MC_ACT_REC = 1,
	ULP_WP_SYM_ACT_REC_DROP_YES = 1,
	ULP_WP_SYM_ACT_REC_DROP_NO = 0,
	ULP_WP_SYM_ACT_REC_POP_VLAN_YES = 1,
	ULP_WP_SYM_ACT_REC_POP_VLAN_NO = 0,
	ULP_WP_SYM_ACT_REC_METER_EN_YES = 1,
	ULP_WP_SYM_ACT_REC_METER_EN_NO = 0,
	ULP_WP_SYM_LOOPBACK_PORT = 4,
	ULP_WP_SYM_LOOPBACK_PARIF = 15,
	ULP_WP_SYM_EXT_EM_MAX_KEY_SIZE = 448,
	ULP_WP_SYM_MATCH_TYPE_EM = 0,
	ULP_WP_SYM_MATCH_TYPE_WM = 1,
	ULP_WP_SYM_IP_PROTO_ICMP = 1,
	ULP_WP_SYM_IP_PROTO_IGMP = 2,
	ULP_WP_SYM_IP_PROTO_IP_IN_IP = 4,
	ULP_WP_SYM_IP_PROTO_TCP = 6,
	ULP_WP_SYM_IP_PROTO_UDP = 17,
	ULP_WP_SYM_VF_FUNC_PARIF = 15,
	ULP_WP_SYM_NO = 0,
	ULP_WP_SYM_YES = 1,
	ULP_WP_SYM_RECYCLE_DST = 0x800,
	ULP_WP_SYM_VF_2_VFR_META_VAL = 0,
	ULP_WP_SYM_VF_2_VF_META_VAL = 0,
	ULP_WP_SYM_VF_2_VFR_META_MASK = 0,
	ULP_WP_SYM_META_PROFILE_0 = 0,
	ULP_WP_SYM_CHAIN_META_VAL = 0,
	ULP_WP_SYM_L2_ECPRI_ETYPE = 0,
	ULP_WP_SYM_L4_ECPRI_ETYPE = 0,
	ULP_WP_SYM_L2_ROE_ETYPE = 0
};

enum ulp_thor_sym {
	ULP_THOR_SYM_METADATA_OP_NORMAL = 0,
	ULP_THOR_SYM_METADATA_OP_L2_HASH = 1,
	ULP_THOR_SYM_METADATA_OP_L4_HASH = 2,
	ULP_THOR_SYM_FWD_OP_BYPASS_CFA = 0,
	ULP_THOR_SYM_FWD_OP_BYPASS_CFA_ROCE = 1,
	ULP_THOR_SYM_FWD_OP_BYPASS_LKUP = 2,
	ULP_THOR_SYM_FWD_OP_NORMAL_FLOW = 3,
	ULP_THOR_SYM_CTXT_OPCODE_BYPASS_CFA = 0,
	ULP_THOR_SYM_CTXT_OPCODE_BYPASS_LKUP = 1,
	ULP_THOR_SYM_CTXT_OPCODE_META_UPDATE = 2,
	ULP_THOR_SYM_CTXT_OPCODE_NORMAL_FLOW = 3,
	ULP_THOR_SYM_CTXT_OPCODE_DROP = 4,
	ULP_THOR_SYM_PKT_TYPE_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_L2 = 0,
	ULP_THOR_SYM_PKT_TYPE_0_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_0_L2 = 0,
	ULP_THOR_SYM_PKT_TYPE_1_IGNORE = 0,
	ULP_THOR_SYM_PKT_TYPE_1_L2 = 0,
	ULP_THOR_SYM_RECYCLE_CNT_IGNORE = 0,
	ULP_THOR_SYM_RECYCLE_CNT_ZERO = 0,
	ULP_THOR_SYM_RECYCLE_CNT_ONE = 1,
	ULP_THOR_SYM_RECYCLE_CNT_TWO = 2,
	ULP_THOR_SYM_RECYCLE_CNT_THREE = 3,
	ULP_THOR_SYM_AGG_ERROR_IGNORE = 0,
	ULP_THOR_SYM_AGG_ERROR_NO = 0,
	ULP_THOR_SYM_AGG_ERROR_YES = 1,
	ULP_THOR_SYM_RESERVED_IGNORE = 0,
	ULP_THOR_SYM_HREC_NEXT_IGNORE = 0,
	ULP_THOR_SYM_HREC_NEXT_NO = 0,
	ULP_THOR_SYM_HREC_NEXT_YES = 1,
	ULP_THOR_SYM_TL2_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL2_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL2_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL2_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL2_HDR_TYPE_DIX = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_IGNORE = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_UC = 0,
	ULP_THOR_SYM_TL2_UC_MC_BC_MC = 2,
	ULP_THOR_SYM_TL2_UC_MC_BC_BC = 3,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_NO = 0,
	ULP_THOR_SYM_TL2_VTAG_PRESENT_YES = 1,
	ULP_THOR_SYM_TL2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR_SYM_TL2_TWO_VTAGS_NO = 0,
	ULP_THOR_SYM_TL2_TWO_VTAGS_YES = 1,
	ULP_THOR_SYM_TL3_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL3_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL3_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TL3_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TL3_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_TYPE_IPV4 = 0,
	ULP_THOR_SYM_TL3_HDR_TYPE_IPV6 = 1,
	ULP_THOR_SYM_TL3_HDR_ISIP_IGNORE = 0,
	ULP_THOR_SYM_TL3_HDR_ISIP_NO = 0,
	ULP_THOR_SYM_TL3_HDR_ISIP_YES = 1,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_NO = 0,
	ULP_THOR_SYM_TL3_IPV6_CMP_DST_YES = 1,
	ULP_THOR_SYM_TL4_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TL4_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TL4_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TL4_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR_SYM_TL4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR_SYM_TL4_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TL4_HDR_TYPE_TCP = 0,
	ULP_THOR_SYM_TL4_HDR_TYPE_UDP = 1,
	ULP_THOR_SYM_TUN_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_VALID_NO = 0,
	ULP_THOR_SYM_TUN_HDR_VALID_YES = 1,
	ULP_THOR_SYM_TUN_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_TUN_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_TUN_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_VXLAN = 0,
	ULP_THOR_SYM_TUN_HDR_TYPE_GENEVE = 1,
	ULP_THOR_SYM_TUN_HDR_TYPE_NVGRE = 2,
	ULP_THOR_SYM_TUN_HDR_TYPE_GRE = 3,
	ULP_THOR_SYM_TUN_HDR_TYPE_IPV4 = 4,
	ULP_THOR_SYM_TUN_HDR_TYPE_IPV6 = 5,
	ULP_THOR_SYM_TUN_HDR_TYPE_PPPOE = 6,
	ULP_THOR_SYM_TUN_HDR_TYPE_MPLS = 7,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR1 = 8,
	ULP_THOR_SYM_TUN_HDR_TYPE_UPAR2 = 9,
	ULP_THOR_SYM_TUN_HDR_TYPE_NONE = 15,
	ULP_THOR_SYM_TUN_HDR_FLAGS_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L2_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L2_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L2_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L2_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L2_HDR_TYPE_DIX = 0,
	ULP_THOR_SYM_L2_HDR_TYPE_LLC_SNAP = 1,
	ULP_THOR_SYM_L2_HDR_TYPE_LLC = 2,
	ULP_THOR_SYM_L2_UC_MC_BC_IGNORE = 0,
	ULP_THOR_SYM_L2_UC_MC_BC_UC = 0,
	ULP_THOR_SYM_L2_UC_MC_BC_MC = 2,
	ULP_THOR_SYM_L2_UC_MC_BC_BC = 3,
	ULP_THOR_SYM_L2_VTAG_PRESENT_IGNORE = 0,
	ULP_THOR_SYM_L2_VTAG_PRESENT_NO = 0,
	ULP_THOR_SYM_L2_VTAG_PRESENT_YES = 1,
	ULP_THOR_SYM_L2_TWO_VTAGS_IGNORE = 0,
	ULP_THOR_SYM_L2_TWO_VTAGS_NO = 0,
	ULP_THOR_SYM_L2_TWO_VTAGS_YES = 1,
	ULP_THOR_SYM_L3_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L3_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L3_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L3_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L3_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_TYPE_IPV4 = 0,
	ULP_THOR_SYM_L3_HDR_TYPE_IPV6 = 1,
	ULP_THOR_SYM_L3_HDR_TYPE_ARP = 2,
	ULP_THOR_SYM_L3_HDR_TYPE_PTP = 3,
	ULP_THOR_SYM_L3_HDR_TYPE_EAPOL = 4,
	ULP_THOR_SYM_L3_HDR_TYPE_ROCE = 5,
	ULP_THOR_SYM_L3_HDR_TYPE_FCOE = 6,
	ULP_THOR_SYM_L3_HDR_TYPE_UPAR1 = 7,
	ULP_THOR_SYM_L3_HDR_TYPE_UPAR2 = 8,
	ULP_THOR_SYM_L3_HDR_ISIP_IGNORE = 0,
	ULP_THOR_SYM_L3_HDR_ISIP_NO = 0,
	ULP_THOR_SYM_L3_HDR_ISIP_YES = 1,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_IGNORE = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_NO = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_SRC_YES = 1,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_IGNORE = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_NO = 0,
	ULP_THOR_SYM_L3_IPV6_CMP_DST_YES = 1,
	ULP_THOR_SYM_L4_HDR_VALID_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_VALID_NO = 0,
	ULP_THOR_SYM_L4_HDR_VALID_YES = 1,
	ULP_THOR_SYM_L4_HDR_ERROR_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_ERROR_NO = 0,
	ULP_THOR_SYM_L4_HDR_ERROR_YES = 1,
	ULP_THOR_SYM_L4_HDR_TYPE_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_TYPE_TCP = 0,
	ULP_THOR_SYM_L4_HDR_TYPE_UDP = 1,
	ULP_THOR_SYM_L4_HDR_TYPE_ICMP = 2,
	ULP_THOR_SYM_L4_HDR_TYPE_UPAR1 = 3,
	ULP_THOR_SYM_L4_HDR_TYPE_UPAR2 = 4,
	ULP_THOR_SYM_L4_HDR_TYPE_BTH_V1 = 5,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_IGNORE = 0,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_NO = 0,
	ULP_THOR_SYM_L4_HDR_IS_UDP_TCP_YES = 1,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_NORMAL = 0,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_RFS_FAST = 1,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_FAST = 2,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_RFS_ACT = 3,
	ULP_THOR_SYM_EM_WM_OPCODE_OP_RECYCLE = 4,
	ULP_THOR_SYM_POP_VLAN_NO = 0,
	ULP_THOR_SYM_POP_VLAN_YES = 1,
	ULP_THOR_SYM_VLAN_DEL_RPT_DISABLED = 0,
	ULP_THOR_SYM_VLAN_DEL_RPT_STRIP_OUTER = 1,
	ULP_THOR_SYM_VLAN_DEL_RPT_STRIP_BOTH = 2,
	ULP_THOR_SYM_VLAN_DEL_RPT_DYN_STRIP = 3,
	ULP_THOR_SYM_DECAP_FUNC_NONE = 0,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL2 = 3,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL3 = 8,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TL4 = 9,
	ULP_THOR_SYM_DECAP_FUNC_THRU_TUN = 10,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L2 = 11,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L3 = 12,
	ULP_THOR_SYM_DECAP_FUNC_THRU_L4 = 13,
	ULP_THOR_SYM_ECV_VALID_NO = 0,
	ULP_THOR_SYM_ECV_VALID_YES = 1,
	ULP_THOR_SYM_ECV_CUSTOM_EN_NO = 0,
	ULP_THOR_SYM_ECV_CUSTOM_EN_YES = 1,
	ULP_THOR_SYM_ECV_L2_EN_NO = 0,
	ULP_THOR_SYM_ECV_L2_EN_YES = 1,
	ULP_THOR_SYM_ECV_VTAG_TYPE_NOP = 0,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_ENCAP_PRI = 1,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_IVLAN_PRI = 2,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_1_REMAP_DIFFSERV = 3,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_2_ENCAP_PRI = 4,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_2_REMAP_DIFFSERV = 5,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_ENCAP_PRI = 6,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_REMAP_DIFFSERV = 7,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_0 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_1 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_2 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_3 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_4 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_5 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_6 = 8,
	ULP_THOR_SYM_ECV_VTAG_TYPE_ADD_0_PRI_7 = 8,
	ULP_THOR_SYM_ECV_L3_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_L3_TYPE_IPV4 = 4,
	ULP_THOR_SYM_ECV_L3_TYPE_IPV6 = 5,
	ULP_THOR_SYM_ECV_L3_TYPE_MPLS_8847 = 6,
	ULP_THOR_SYM_ECV_L3_TYPE_MPLS_8848 = 7,
	ULP_THOR_SYM_ECV_L4_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP = 4,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_CSUM = 5,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_ENTROPY = 6,
	ULP_THOR_SYM_ECV_L4_TYPE_UDP_ENTROPY_CSUM = 7,
	ULP_THOR_SYM_ECV_TUN_TYPE_NONE = 0,
	ULP_THOR_SYM_ECV_TUN_TYPE_GENERIC = 1,
	ULP_THOR_SYM_ECV_TUN_TYPE_VXLAN = 2,
	ULP_THOR_SYM_ECV_TUN_TYPE_NGE = 3,
	ULP_THOR_SYM_ECV_TUN_TYPE_NVGRE = 4,
	ULP_THOR_SYM_ECV_TUN_TYPE_GRE = 5,
	ULP_THOR_SYM_EEM_ACT_REC_INT = 0,
	ULP_THOR_SYM_EEM_EXT_FLOW_CNTR = 0,
	ULP_THOR_SYM_UC_ACT_REC = 0,
	ULP_THOR_SYM_MC_ACT_REC = 1,
	ULP_THOR_SYM_ACT_REC_DROP_YES = 1,
	ULP_THOR_SYM_ACT_REC_DROP_NO = 0,
	ULP_THOR_SYM_ACT_REC_POP_VLAN_YES = 1,
	ULP_THOR_SYM_ACT_REC_POP_VLAN_NO = 0,
	ULP_THOR_SYM_ACT_REC_METER_EN_YES = 1,
	ULP_THOR_SYM_ACT_REC_METER_EN_NO = 0,
	ULP_THOR_SYM_LOOPBACK_PORT = 16,
	ULP_THOR_SYM_LOOPBACK_PARIF = 15,
	ULP_THOR_SYM_EXT_EM_MAX_KEY_SIZE = 0,
	ULP_THOR_SYM_MATCH_TYPE_EM = 0,
	ULP_THOR_SYM_MATCH_TYPE_WM = 1,
	ULP_THOR_SYM_IP_PROTO_ICMP = 1,
	ULP_THOR_SYM_IP_PROTO_IGMP = 2,
	ULP_THOR_SYM_IP_PROTO_IP_IN_IP = 4,
	ULP_THOR_SYM_IP_PROTO_TCP = 6,
	ULP_THOR_SYM_IP_PROTO_UDP = 17,
	ULP_THOR_SYM_VF_FUNC_PARIF = 15,
	ULP_THOR_SYM_NO = 0,
	ULP_THOR_SYM_YES = 1,
	ULP_THOR_SYM_RECYCLE_DST = 1039,
	ULP_THOR_SYM_VF_2_VFR_META_VAL = 8192,
	ULP_THOR_SYM_VF_2_VF_META_VAL = 4096,
	ULP_THOR_SYM_VF_2_VFR_META_MASK = 61440,
	ULP_THOR_SYM_META_PROFILE_0 = 0,
	ULP_THOR_SYM_CHAIN_META_VAL = 12288,
	ULP_THOR_SYM_L2_ECPRI_ETYPE = 44798,
	ULP_THOR_SYM_L4_ECPRI_ETYPE = 2048,
	ULP_THOR_SYM_L2_ROE_ETYPE = 64573
};

enum bnxt_ulp_class_hid {
	BNXT_ULP_CLASS_HID_00b8 = 0x00b8,
	BNXT_ULP_CLASS_HID_0cc2 = 0x0cc2,
	BNXT_ULP_CLASS_HID_10e4 = 0x10e4,
	BNXT_ULP_CLASS_HID_1d0e = 0x1d0e,
	BNXT_ULP_CLASS_HID_0286 = 0x0286,
	BNXT_ULP_CLASS_HID_0e98 = 0x0e98,
	BNXT_ULP_CLASS_HID_1666 = 0x1666,
	BNXT_ULP_CLASS_HID_02de = 0x02de,
	BNXT_ULP_CLASS_HID_81d25 = 0x81d25,
	BNXT_ULP_CLASS_HID_809ad = 0x809ad,
	BNXT_ULP_CLASS_HID_80ae3 = 0x80ae3,
	BNXT_ULP_CLASS_HID_8170d = 0x8170d,
	BNXT_ULP_CLASS_HID_80773 = 0x80773,
	BNXT_ULP_CLASS_HID_8139d = 0x8139d,
	BNXT_ULP_CLASS_HID_814d3 = 0x814d3,
	BNXT_ULP_CLASS_HID_8015b = 0x8015b,
	BNXT_ULP_CLASS_HID_21977 = 0x21977,
	BNXT_ULP_CLASS_HID_205ef = 0x205ef,
	BNXT_ULP_CLASS_HID_20735 = 0x20735,
	BNXT_ULP_CLASS_HID_2134f = 0x2134f,
	BNXT_ULP_CLASS_HID_61beb = 0x61beb,
	BNXT_ULP_CLASS_HID_60863 = 0x60863,
	BNXT_ULP_CLASS_HID_609a9 = 0x609a9,
	BNXT_ULP_CLASS_HID_615c3 = 0x615c3,
	BNXT_ULP_CLASS_HID_00a8 = 0x00a8,
	BNXT_ULP_CLASS_HID_0cd2 = 0x0cd2,
	BNXT_ULP_CLASS_HID_10f4 = 0x10f4,
	BNXT_ULP_CLASS_HID_1d1e = 0x1d1e,
	BNXT_ULP_CLASS_HID_1488 = 0x1488,
	BNXT_ULP_CLASS_HID_0110 = 0x0110,
	BNXT_ULP_CLASS_HID_0532 = 0x0532,
	BNXT_ULP_CLASS_HID_115c = 0x115c,
	BNXT_ULP_CLASS_HID_0ab8 = 0x0ab8,
	BNXT_ULP_CLASS_HID_16a2 = 0x16a2,
	BNXT_ULP_CLASS_HID_1ac4 = 0x1ac4,
	BNXT_ULP_CLASS_HID_074c = 0x074c,
	BNXT_ULP_CLASS_HID_1e98 = 0x1e98,
	BNXT_ULP_CLASS_HID_0ae0 = 0x0ae0,
	BNXT_ULP_CLASS_HID_0f02 = 0x0f02,
	BNXT_ULP_CLASS_HID_1b2c = 0x1b2c,
	BNXT_ULP_CLASS_HID_0296 = 0x0296,
	BNXT_ULP_CLASS_HID_0e88 = 0x0e88,
	BNXT_ULP_CLASS_HID_1676 = 0x1676,
	BNXT_ULP_CLASS_HID_02ce = 0x02ce,
	BNXT_ULP_CLASS_HID_8076e = 0x8076e,
	BNXT_ULP_CLASS_HID_81380 = 0x81380,
	BNXT_ULP_CLASS_HID_81b4e = 0x81b4e,
	BNXT_ULP_CLASS_HID_807c6 = 0x807c6,
	BNXT_ULP_CLASS_HID_404ea = 0x404ea,
	BNXT_ULP_CLASS_HID_4110c = 0x4110c,
	BNXT_ULP_CLASS_HID_418ca = 0x418ca,
	BNXT_ULP_CLASS_HID_40542 = 0x40542,
	BNXT_ULP_CLASS_HID_c09e2 = 0xc09e2,
	BNXT_ULP_CLASS_HID_c1604 = 0xc1604,
	BNXT_ULP_CLASS_HID_c1dc2 = 0xc1dc2,
	BNXT_ULP_CLASS_HID_c0a5a = 0xc0a5a,
	BNXT_ULP_CLASS_HID_0098 = 0x0098,
	BNXT_ULP_CLASS_HID_0ce2 = 0x0ce2,
	BNXT_ULP_CLASS_HID_10c4 = 0x10c4,
	BNXT_ULP_CLASS_HID_1d2e = 0x1d2e,
	BNXT_ULP_CLASS_HID_14b8 = 0x14b8,
	BNXT_ULP_CLASS_HID_0120 = 0x0120,
	BNXT_ULP_CLASS_HID_0502 = 0x0502,
	BNXT_ULP_CLASS_HID_116c = 0x116c,
	BNXT_ULP_CLASS_HID_0a88 = 0x0a88,
	BNXT_ULP_CLASS_HID_1692 = 0x1692,
	BNXT_ULP_CLASS_HID_1af4 = 0x1af4,
	BNXT_ULP_CLASS_HID_077c = 0x077c,
	BNXT_ULP_CLASS_HID_1ea8 = 0x1ea8,
	BNXT_ULP_CLASS_HID_0ad0 = 0x0ad0,
	BNXT_ULP_CLASS_HID_0f32 = 0x0f32,
	BNXT_ULP_CLASS_HID_1b1c = 0x1b1c,
	BNXT_ULP_CLASS_HID_02a6 = 0x02a6,
	BNXT_ULP_CLASS_HID_0eb8 = 0x0eb8,
	BNXT_ULP_CLASS_HID_1646 = 0x1646,
	BNXT_ULP_CLASS_HID_02fe = 0x02fe,
	BNXT_ULP_CLASS_HID_8075e = 0x8075e,
	BNXT_ULP_CLASS_HID_813b0 = 0x813b0,
	BNXT_ULP_CLASS_HID_81b7e = 0x81b7e,
	BNXT_ULP_CLASS_HID_807f6 = 0x807f6,
	BNXT_ULP_CLASS_HID_404da = 0x404da,
	BNXT_ULP_CLASS_HID_4113c = 0x4113c,
	BNXT_ULP_CLASS_HID_418fa = 0x418fa,
	BNXT_ULP_CLASS_HID_40572 = 0x40572,
	BNXT_ULP_CLASS_HID_c09d2 = 0xc09d2,
	BNXT_ULP_CLASS_HID_c1634 = 0xc1634,
	BNXT_ULP_CLASS_HID_c1df2 = 0xc1df2,
	BNXT_ULP_CLASS_HID_c0a6a = 0xc0a6a,
	BNXT_ULP_CLASS_HID_81d35 = 0x81d35,
	BNXT_ULP_CLASS_HID_809bd = 0x809bd,
	BNXT_ULP_CLASS_HID_80af3 = 0x80af3,
	BNXT_ULP_CLASS_HID_8171d = 0x8171d,
	BNXT_ULP_CLASS_HID_80763 = 0x80763,
	BNXT_ULP_CLASS_HID_8138d = 0x8138d,
	BNXT_ULP_CLASS_HID_814c3 = 0x814c3,
	BNXT_ULP_CLASS_HID_8014b = 0x8014b,
	BNXT_ULP_CLASS_HID_c001f = 0xc001f,
	BNXT_ULP_CLASS_HID_c0c39 = 0xc0c39,
	BNXT_ULP_CLASS_HID_c0d7f = 0xc0d7f,
	BNXT_ULP_CLASS_HID_c1999 = 0xc1999,
	BNXT_ULP_CLASS_HID_c09ef = 0xc09ef,
	BNXT_ULP_CLASS_HID_c1609 = 0xc1609,
	BNXT_ULP_CLASS_HID_c174f = 0xc174f,
	BNXT_ULP_CLASS_HID_c03d7 = 0xc03d7,
	BNXT_ULP_CLASS_HID_a1e73 = 0xa1e73,
	BNXT_ULP_CLASS_HID_a0afb = 0xa0afb,
	BNXT_ULP_CLASS_HID_a0c31 = 0xa0c31,
	BNXT_ULP_CLASS_HID_a185b = 0xa185b,
	BNXT_ULP_CLASS_HID_a08a1 = 0xa08a1,
	BNXT_ULP_CLASS_HID_a14cb = 0xa14cb,
	BNXT_ULP_CLASS_HID_a1601 = 0xa1601,
	BNXT_ULP_CLASS_HID_a0289 = 0xa0289,
	BNXT_ULP_CLASS_HID_e015d = 0xe015d,
	BNXT_ULP_CLASS_HID_e0d47 = 0xe0d47,
	BNXT_ULP_CLASS_HID_e0ebd = 0xe0ebd,
	BNXT_ULP_CLASS_HID_e1aa7 = 0xe1aa7,
	BNXT_ULP_CLASS_HID_e0b2d = 0xe0b2d,
	BNXT_ULP_CLASS_HID_e1757 = 0xe1757,
	BNXT_ULP_CLASS_HID_e188d = 0xe188d,
	BNXT_ULP_CLASS_HID_e0515 = 0xe0515,
	BNXT_ULP_CLASS_HID_21967 = 0x21967,
	BNXT_ULP_CLASS_HID_205ff = 0x205ff,
	BNXT_ULP_CLASS_HID_20725 = 0x20725,
	BNXT_ULP_CLASS_HID_2135f = 0x2135f,
	BNXT_ULP_CLASS_HID_61bfb = 0x61bfb,
	BNXT_ULP_CLASS_HID_60873 = 0x60873,
	BNXT_ULP_CLASS_HID_609b9 = 0x609b9,
	BNXT_ULP_CLASS_HID_615d3 = 0x615d3,
	BNXT_ULP_CLASS_HID_30a55 = 0x30a55,
	BNXT_ULP_CLASS_HID_3164f = 0x3164f,
	BNXT_ULP_CLASS_HID_317b5 = 0x317b5,
	BNXT_ULP_CLASS_HID_3040d = 0x3040d,
	BNXT_ULP_CLASS_HID_70ca9 = 0x70ca9,
	BNXT_ULP_CLASS_HID_718c3 = 0x718c3,
	BNXT_ULP_CLASS_HID_71a09 = 0x71a09,
	BNXT_ULP_CLASS_HID_70681 = 0x70681,
	BNXT_ULP_CLASS_HID_2821d = 0x2821d,
	BNXT_ULP_CLASS_HID_28e37 = 0x28e37,
	BNXT_ULP_CLASS_HID_28f7d = 0x28f7d,
	BNXT_ULP_CLASS_HID_29b97 = 0x29b97,
	BNXT_ULP_CLASS_HID_68491 = 0x68491,
	BNXT_ULP_CLASS_HID_6908b = 0x6908b,
	BNXT_ULP_CLASS_HID_691f1 = 0x691f1,
	BNXT_ULP_CLASS_HID_69deb = 0x69deb,
	BNXT_ULP_CLASS_HID_3926d = 0x3926d,
	BNXT_ULP_CLASS_HID_39e87 = 0x39e87,
	BNXT_ULP_CLASS_HID_38023 = 0x38023,
	BNXT_ULP_CLASS_HID_38c45 = 0x38c45,
	BNXT_ULP_CLASS_HID_794e1 = 0x794e1,
	BNXT_ULP_CLASS_HID_78179 = 0x78179,
	BNXT_ULP_CLASS_HID_782a7 = 0x782a7,
	BNXT_ULP_CLASS_HID_78ed9 = 0x78ed9,
	BNXT_ULP_CLASS_HID_81d05 = 0x81d05,
	BNXT_ULP_CLASS_HID_8098d = 0x8098d,
	BNXT_ULP_CLASS_HID_80ac3 = 0x80ac3,
	BNXT_ULP_CLASS_HID_8172d = 0x8172d,
	BNXT_ULP_CLASS_HID_80753 = 0x80753,
	BNXT_ULP_CLASS_HID_813bd = 0x813bd,
	BNXT_ULP_CLASS_HID_814f3 = 0x814f3,
	BNXT_ULP_CLASS_HID_8017b = 0x8017b,
	BNXT_ULP_CLASS_HID_c002f = 0xc002f,
	BNXT_ULP_CLASS_HID_c0c09 = 0xc0c09,
	BNXT_ULP_CLASS_HID_c0d4f = 0xc0d4f,
	BNXT_ULP_CLASS_HID_c19a9 = 0xc19a9,
	BNXT_ULP_CLASS_HID_c09df = 0xc09df,
	BNXT_ULP_CLASS_HID_c1639 = 0xc1639,
	BNXT_ULP_CLASS_HID_c177f = 0xc177f,
	BNXT_ULP_CLASS_HID_c03e7 = 0xc03e7,
	BNXT_ULP_CLASS_HID_a1e43 = 0xa1e43,
	BNXT_ULP_CLASS_HID_a0acb = 0xa0acb,
	BNXT_ULP_CLASS_HID_a0c01 = 0xa0c01,
	BNXT_ULP_CLASS_HID_a186b = 0xa186b,
	BNXT_ULP_CLASS_HID_a0891 = 0xa0891,
	BNXT_ULP_CLASS_HID_a14fb = 0xa14fb,
	BNXT_ULP_CLASS_HID_a1631 = 0xa1631,
	BNXT_ULP_CLASS_HID_a02b9 = 0xa02b9,
	BNXT_ULP_CLASS_HID_e016d = 0xe016d,
	BNXT_ULP_CLASS_HID_e0d77 = 0xe0d77,
	BNXT_ULP_CLASS_HID_e0e8d = 0xe0e8d,
	BNXT_ULP_CLASS_HID_e1a97 = 0xe1a97,
	BNXT_ULP_CLASS_HID_e0b1d = 0xe0b1d,
	BNXT_ULP_CLASS_HID_e1767 = 0xe1767,
	BNXT_ULP_CLASS_HID_e18bd = 0xe18bd,
	BNXT_ULP_CLASS_HID_e0525 = 0xe0525,
	BNXT_ULP_CLASS_HID_21957 = 0x21957,
	BNXT_ULP_CLASS_HID_205cf = 0x205cf,
	BNXT_ULP_CLASS_HID_20715 = 0x20715,
	BNXT_ULP_CLASS_HID_2136f = 0x2136f,
	BNXT_ULP_CLASS_HID_61bcb = 0x61bcb,
	BNXT_ULP_CLASS_HID_60843 = 0x60843,
	BNXT_ULP_CLASS_HID_60989 = 0x60989,
	BNXT_ULP_CLASS_HID_615e3 = 0x615e3,
	BNXT_ULP_CLASS_HID_30a65 = 0x30a65,
	BNXT_ULP_CLASS_HID_3167f = 0x3167f,
	BNXT_ULP_CLASS_HID_31785 = 0x31785,
	BNXT_ULP_CLASS_HID_3043d = 0x3043d,
	BNXT_ULP_CLASS_HID_70c99 = 0x70c99,
	BNXT_ULP_CLASS_HID_718f3 = 0x718f3,
	BNXT_ULP_CLASS_HID_71a39 = 0x71a39,
	BNXT_ULP_CLASS_HID_706b1 = 0x706b1,
	BNXT_ULP_CLASS_HID_2822d = 0x2822d,
	BNXT_ULP_CLASS_HID_28e07 = 0x28e07,
	BNXT_ULP_CLASS_HID_28f4d = 0x28f4d,
	BNXT_ULP_CLASS_HID_29ba7 = 0x29ba7,
	BNXT_ULP_CLASS_HID_684a1 = 0x684a1,
	BNXT_ULP_CLASS_HID_690bb = 0x690bb,
	BNXT_ULP_CLASS_HID_691c1 = 0x691c1,
	BNXT_ULP_CLASS_HID_69ddb = 0x69ddb,
	BNXT_ULP_CLASS_HID_3925d = 0x3925d,
	BNXT_ULP_CLASS_HID_39eb7 = 0x39eb7,
	BNXT_ULP_CLASS_HID_38013 = 0x38013,
	BNXT_ULP_CLASS_HID_38c75 = 0x38c75,
	BNXT_ULP_CLASS_HID_794d1 = 0x794d1,
	BNXT_ULP_CLASS_HID_78149 = 0x78149,
	BNXT_ULP_CLASS_HID_78297 = 0x78297,
	BNXT_ULP_CLASS_HID_78ee9 = 0x78ee9,
	BNXT_ULP_CLASS_HID_0816 = 0x0816,
	BNXT_ULP_CLASS_HID_1852 = 0x1852,
	BNXT_ULP_CLASS_HID_09f4 = 0x09f4,
	BNXT_ULP_CLASS_HID_1dd4 = 0x1dd4,
	BNXT_ULP_CLASS_HID_804f1 = 0x804f1,
	BNXT_ULP_CLASS_HID_81251 = 0x81251,
	BNXT_ULP_CLASS_HID_80ee1 = 0x80ee1,
	BNXT_ULP_CLASS_HID_81c41 = 0x81c41,
	BNXT_ULP_CLASS_HID_2013b = 0x2013b,
	BNXT_ULP_CLASS_HID_20e9b = 0x20e9b,
	BNXT_ULP_CLASS_HID_603bf = 0x603bf,
	BNXT_ULP_CLASS_HID_6111f = 0x6111f,
	BNXT_ULP_CLASS_HID_0806 = 0x0806,
	BNXT_ULP_CLASS_HID_1842 = 0x1842,
	BNXT_ULP_CLASS_HID_1be6 = 0x1be6,
	BNXT_ULP_CLASS_HID_0c80 = 0x0c80,
	BNXT_ULP_CLASS_HID_1216 = 0x1216,
	BNXT_ULP_CLASS_HID_02b0 = 0x02b0,
	BNXT_ULP_CLASS_HID_0654 = 0x0654,
	BNXT_ULP_CLASS_HID_1690 = 0x1690,
	BNXT_ULP_CLASS_HID_09e4 = 0x09e4,
	BNXT_ULP_CLASS_HID_1dc4 = 0x1dc4,
	BNXT_ULP_CLASS_HID_80efc = 0x80efc,
	BNXT_ULP_CLASS_HID_80332 = 0x80332,
	BNXT_ULP_CLASS_HID_40c78 = 0x40c78,
	BNXT_ULP_CLASS_HID_400be = 0x400be,
	BNXT_ULP_CLASS_HID_c1170 = 0xc1170,
	BNXT_ULP_CLASS_HID_c05b6 = 0xc05b6,
	BNXT_ULP_CLASS_HID_0836 = 0x0836,
	BNXT_ULP_CLASS_HID_1872 = 0x1872,
	BNXT_ULP_CLASS_HID_1bd6 = 0x1bd6,
	BNXT_ULP_CLASS_HID_0cb0 = 0x0cb0,
	BNXT_ULP_CLASS_HID_1226 = 0x1226,
	BNXT_ULP_CLASS_HID_0280 = 0x0280,
	BNXT_ULP_CLASS_HID_0664 = 0x0664,
	BNXT_ULP_CLASS_HID_16a0 = 0x16a0,
	BNXT_ULP_CLASS_HID_09d4 = 0x09d4,
	BNXT_ULP_CLASS_HID_1df4 = 0x1df4,
	BNXT_ULP_CLASS_HID_80ecc = 0x80ecc,
	BNXT_ULP_CLASS_HID_80302 = 0x80302,
	BNXT_ULP_CLASS_HID_40c48 = 0x40c48,
	BNXT_ULP_CLASS_HID_4008e = 0x4008e,
	BNXT_ULP_CLASS_HID_c1140 = 0xc1140,
	BNXT_ULP_CLASS_HID_c0586 = 0xc0586,
	BNXT_ULP_CLASS_HID_804e1 = 0x804e1,
	BNXT_ULP_CLASS_HID_81241 = 0x81241,
	BNXT_ULP_CLASS_HID_80ef1 = 0x80ef1,
	BNXT_ULP_CLASS_HID_81c51 = 0x81c51,
	BNXT_ULP_CLASS_HID_c076d = 0xc076d,
	BNXT_ULP_CLASS_HID_c14cd = 0xc14cd,
	BNXT_ULP_CLASS_HID_c117d = 0xc117d,
	BNXT_ULP_CLASS_HID_c1edd = 0xc1edd,
	BNXT_ULP_CLASS_HID_a062f = 0xa062f,
	BNXT_ULP_CLASS_HID_a138f = 0xa138f,
	BNXT_ULP_CLASS_HID_a103f = 0xa103f,
	BNXT_ULP_CLASS_HID_a1d9f = 0xa1d9f,
	BNXT_ULP_CLASS_HID_e08ab = 0xe08ab,
	BNXT_ULP_CLASS_HID_e160b = 0xe160b,
	BNXT_ULP_CLASS_HID_e12bb = 0xe12bb,
	BNXT_ULP_CLASS_HID_e0079 = 0xe0079,
	BNXT_ULP_CLASS_HID_2012b = 0x2012b,
	BNXT_ULP_CLASS_HID_20e8b = 0x20e8b,
	BNXT_ULP_CLASS_HID_603af = 0x603af,
	BNXT_ULP_CLASS_HID_6110f = 0x6110f,
	BNXT_ULP_CLASS_HID_311bb = 0x311bb,
	BNXT_ULP_CLASS_HID_31f1b = 0x31f1b,
	BNXT_ULP_CLASS_HID_7143f = 0x7143f,
	BNXT_ULP_CLASS_HID_701fd = 0x701fd,
	BNXT_ULP_CLASS_HID_28963 = 0x28963,
	BNXT_ULP_CLASS_HID_296c3 = 0x296c3,
	BNXT_ULP_CLASS_HID_68be7 = 0x68be7,
	BNXT_ULP_CLASS_HID_69947 = 0x69947,
	BNXT_ULP_CLASS_HID_399f3 = 0x399f3,
	BNXT_ULP_CLASS_HID_387b1 = 0x387b1,
	BNXT_ULP_CLASS_HID_79c77 = 0x79c77,
	BNXT_ULP_CLASS_HID_78a35 = 0x78a35,
	BNXT_ULP_CLASS_HID_804d1 = 0x804d1,
	BNXT_ULP_CLASS_HID_81271 = 0x81271,
	BNXT_ULP_CLASS_HID_80ec1 = 0x80ec1,
	BNXT_ULP_CLASS_HID_81c61 = 0x81c61,
	BNXT_ULP_CLASS_HID_c075d = 0xc075d,
	BNXT_ULP_CLASS_HID_c14fd = 0xc14fd,
	BNXT_ULP_CLASS_HID_c114d = 0xc114d,
	BNXT_ULP_CLASS_HID_c1eed = 0xc1eed,
	BNXT_ULP_CLASS_HID_a061f = 0xa061f,
	BNXT_ULP_CLASS_HID_a13bf = 0xa13bf,
	BNXT_ULP_CLASS_HID_a100f = 0xa100f,
	BNXT_ULP_CLASS_HID_a1daf = 0xa1daf,
	BNXT_ULP_CLASS_HID_e089b = 0xe089b,
	BNXT_ULP_CLASS_HID_e163b = 0xe163b,
	BNXT_ULP_CLASS_HID_e128b = 0xe128b,
	BNXT_ULP_CLASS_HID_e0049 = 0xe0049,
	BNXT_ULP_CLASS_HID_2011b = 0x2011b,
	BNXT_ULP_CLASS_HID_20ebb = 0x20ebb,
	BNXT_ULP_CLASS_HID_6039f = 0x6039f,
	BNXT_ULP_CLASS_HID_6113f = 0x6113f,
	BNXT_ULP_CLASS_HID_3118b = 0x3118b,
	BNXT_ULP_CLASS_HID_31f2b = 0x31f2b,
	BNXT_ULP_CLASS_HID_7140f = 0x7140f,
	BNXT_ULP_CLASS_HID_701cd = 0x701cd,
	BNXT_ULP_CLASS_HID_28953 = 0x28953,
	BNXT_ULP_CLASS_HID_296f3 = 0x296f3,
	BNXT_ULP_CLASS_HID_68bd7 = 0x68bd7,
	BNXT_ULP_CLASS_HID_69977 = 0x69977,
	BNXT_ULP_CLASS_HID_399c3 = 0x399c3,
	BNXT_ULP_CLASS_HID_38781 = 0x38781,
	BNXT_ULP_CLASS_HID_79c47 = 0x79c47,
	BNXT_ULP_CLASS_HID_78a05 = 0x78a05,
	BNXT_ULP_CLASS_HID_04a4 = 0x04a4,
	BNXT_ULP_CLASS_HID_04a8 = 0x04a8,
	BNXT_ULP_CLASS_HID_04a5 = 0x04a5,
	BNXT_ULP_CLASS_HID_1205 = 0x1205,
	BNXT_ULP_CLASS_HID_04a9 = 0x04a9,
	BNXT_ULP_CLASS_HID_1209 = 0x1209,
	BNXT_ULP_CLASS_HID_04b4 = 0x04b4,
	BNXT_ULP_CLASS_HID_04b8 = 0x04b8,
	BNXT_ULP_CLASS_HID_0484 = 0x0484,
	BNXT_ULP_CLASS_HID_0488 = 0x0488,
	BNXT_ULP_CLASS_HID_04b5 = 0x04b5,
	BNXT_ULP_CLASS_HID_1215 = 0x1215,
	BNXT_ULP_CLASS_HID_04b9 = 0x04b9,
	BNXT_ULP_CLASS_HID_1219 = 0x1219,
	BNXT_ULP_CLASS_HID_0485 = 0x0485,
	BNXT_ULP_CLASS_HID_1225 = 0x1225,
	BNXT_ULP_CLASS_HID_0489 = 0x0489,
	BNXT_ULP_CLASS_HID_1229 = 0x1229,
	BNXT_ULP_CLASS_HID_0226 = 0x0226,
	BNXT_ULP_CLASS_HID_4045a = 0x4045a,
	BNXT_ULP_CLASS_HID_0daa = 0x0daa,
	BNXT_ULP_CLASS_HID_11b0 = 0x11b0,
	BNXT_ULP_CLASS_HID_403f8 = 0x403f8,
	BNXT_ULP_CLASS_HID_4161e = 0x4161e,
	BNXT_ULP_CLASS_HID_40439 = 0x40439,
	BNXT_ULP_CLASS_HID_41405 = 0x41405,
	BNXT_ULP_CLASS_HID_51449 = 0x51449,
	BNXT_ULP_CLASS_HID_50b33 = 0x50b33,
	BNXT_ULP_CLASS_HID_48c01 = 0x48c01,
	BNXT_ULP_CLASS_HID_483eb = 0x483eb,
	BNXT_ULP_CLASS_HID_5833f = 0x5833f,
	BNXT_ULP_CLASS_HID_5937b = 0x5937b,
	BNXT_ULP_CLASS_HID_41875 = 0x41875,
	BNXT_ULP_CLASS_HID_40f5f = 0x40f5f,
	BNXT_ULP_CLASS_HID_50f23 = 0x50f23,
	BNXT_ULP_CLASS_HID_51f6f = 0x51f6f,
	BNXT_ULP_CLASS_HID_4875b = 0x4875b,
	BNXT_ULP_CLASS_HID_49727 = 0x49727,
	BNXT_ULP_CLASS_HID_5976b = 0x5976b,
	BNXT_ULP_CLASS_HID_58655 = 0x58655,
	BNXT_ULP_CLASS_HID_4125f = 0x4125f,
	BNXT_ULP_CLASS_HID_401f9 = 0x401f9,
	BNXT_ULP_CLASS_HID_501cd = 0x501cd,
	BNXT_ULP_CLASS_HID_51149 = 0x51149,
	BNXT_ULP_CLASS_HID_49a67 = 0x49a67,
	BNXT_ULP_CLASS_HID_489c1 = 0x489c1,
	BNXT_ULP_CLASS_HID_58955 = 0x58955,
	BNXT_ULP_CLASS_HID_59951 = 0x59951,
	BNXT_ULP_CLASS_HID_40569 = 0x40569,
	BNXT_ULP_CLASS_HID_41575 = 0x41575,
	BNXT_ULP_CLASS_HID_51579 = 0x51579,
	BNXT_ULP_CLASS_HID_50463 = 0x50463,
	BNXT_ULP_CLASS_HID_48d71 = 0x48d71,
	BNXT_ULP_CLASS_HID_49d7d = 0x49d7d,
	BNXT_ULP_CLASS_HID_59d41 = 0x59d41,
	BNXT_ULP_CLASS_HID_58c6b = 0x58c6b,
	BNXT_ULP_CLASS_HID_10255 = 0x10255,
	BNXT_ULP_CLASS_HID_11675 = 0x11675,
	BNXT_ULP_CLASS_HID_14649 = 0x14649,
	BNXT_ULP_CLASS_HID_15a69 = 0x15a69,
	BNXT_ULP_CLASS_HID_1205b = 0x1205b,
	BNXT_ULP_CLASS_HID_1347b = 0x1347b,
	BNXT_ULP_CLASS_HID_16bbf = 0x16bbf,
	BNXT_ULP_CLASS_HID_1785f = 0x1785f,
	BNXT_ULP_CLASS_HID_11551 = 0x11551,
	BNXT_ULP_CLASS_HID_10897 = 0x10897,
	BNXT_ULP_CLASS_HID_15955 = 0x15955,
	BNXT_ULP_CLASS_HID_14c8b = 0x14c8b,
	BNXT_ULP_CLASS_HID_13b47 = 0x13b47,
	BNXT_ULP_CLASS_HID_12e85 = 0x12e85,
	BNXT_ULP_CLASS_HID_17f5b = 0x17f5b,
	BNXT_ULP_CLASS_HID_17299 = 0x17299,
	BNXT_ULP_CLASS_HID_10fe7 = 0x10fe7,
	BNXT_ULP_CLASS_HID_10325 = 0x10325,
	BNXT_ULP_CLASS_HID_153cb = 0x153cb,
	BNXT_ULP_CLASS_HID_14709 = 0x14709,
	BNXT_ULP_CLASS_HID_12dc5 = 0x12dc5,
	BNXT_ULP_CLASS_HID_1212b = 0x1212b,
	BNXT_ULP_CLASS_HID_171c9 = 0x171c9,
	BNXT_ULP_CLASS_HID_1650f = 0x1650f,
	BNXT_ULP_CLASS_HID_10201 = 0x10201,
	BNXT_ULP_CLASS_HID_116c1 = 0x116c1,
	BNXT_ULP_CLASS_HID_14605 = 0x14605,
	BNXT_ULP_CLASS_HID_15a05 = 0x15a05,
	BNXT_ULP_CLASS_HID_12007 = 0x12007,
	BNXT_ULP_CLASS_HID_13407 = 0x13407,
	BNXT_ULP_CLASS_HID_1640b = 0x1640b,
	BNXT_ULP_CLASS_HID_1780b = 0x1780b,
	BNXT_ULP_CLASS_HID_404b0 = 0x404b0,
	BNXT_ULP_CLASS_HID_4148c = 0x4148c,
	BNXT_ULP_CLASS_HID_514c0 = 0x514c0,
	BNXT_ULP_CLASS_HID_50bba = 0x50bba,
	BNXT_ULP_CLASS_HID_48c88 = 0x48c88,
	BNXT_ULP_CLASS_HID_48362 = 0x48362,
	BNXT_ULP_CLASS_HID_583b6 = 0x583b6,
	BNXT_ULP_CLASS_HID_593f2 = 0x593f2,
	BNXT_ULP_CLASS_HID_41f54 = 0x41f54,
	BNXT_ULP_CLASS_HID_40fce = 0x40fce,
	BNXT_ULP_CLASS_HID_50e02 = 0x50e02,
	BNXT_ULP_CLASS_HID_51e5e = 0x51e5e,
	BNXT_ULP_CLASS_HID_487ca = 0x487ca,
	BNXT_ULP_CLASS_HID_49606 = 0x49606,
	BNXT_ULP_CLASS_HID_5965a = 0x5965a,
	BNXT_ULP_CLASS_HID_58514 = 0x58514,
	BNXT_ULP_CLASS_HID_412c2 = 0x412c2,
	BNXT_ULP_CLASS_HID_401ac = 0x401ac,
	BNXT_ULP_CLASS_HID_501e0 = 0x501e0,
	BNXT_ULP_CLASS_HID_511cc = 0x511cc,
	BNXT_ULP_CLASS_HID_4990a = 0x4990a,
	BNXT_ULP_CLASS_HID_489e4 = 0x489e4,
	BNXT_ULP_CLASS_HID_589c8 = 0x589c8,
	BNXT_ULP_CLASS_HID_59804 = 0x59804,
	BNXT_ULP_CLASS_HID_40404 = 0x40404,
	BNXT_ULP_CLASS_HID_41440 = 0x41440,
	BNXT_ULP_CLASS_HID_51484 = 0x51484,
	BNXT_ULP_CLASS_HID_50b0e = 0x50b0e,
	BNXT_ULP_CLASS_HID_48c4c = 0x48c4c,
	BNXT_ULP_CLASS_HID_48306 = 0x48306,
	BNXT_ULP_CLASS_HID_5830a = 0x5830a,
	BNXT_ULP_CLASS_HID_59346 = 0x59346,
	BNXT_ULP_CLASS_HID_102cc = 0x102cc,
	BNXT_ULP_CLASS_HID_116ec = 0x116ec,
	BNXT_ULP_CLASS_HID_146d0 = 0x146d0,
	BNXT_ULP_CLASS_HID_15af0 = 0x15af0,
	BNXT_ULP_CLASS_HID_120c2 = 0x120c2,
	BNXT_ULP_CLASS_HID_134e2 = 0x134e2,
	BNXT_ULP_CLASS_HID_16b26 = 0x16b26,
	BNXT_ULP_CLASS_HID_178c6 = 0x178c6,
	BNXT_ULP_CLASS_HID_115c6 = 0x115c6,
	BNXT_ULP_CLASS_HID_10804 = 0x10804,
	BNXT_ULP_CLASS_HID_15822 = 0x15822,
	BNXT_ULP_CLASS_HID_14c60 = 0x14c60,
	BNXT_ULP_CLASS_HID_13bd4 = 0x13bd4,
	BNXT_ULP_CLASS_HID_12e12 = 0x12e12,
	BNXT_ULP_CLASS_HID_17e30 = 0x17e30,
	BNXT_ULP_CLASS_HID_17276 = 0x17276,
	BNXT_ULP_CLASS_HID_11f1a = 0x11f1a,
	BNXT_ULP_CLASS_HID_11358 = 0x11358,
	BNXT_ULP_CLASS_HID_14398 = 0x14398,
	BNXT_ULP_CLASS_HID_157b8 = 0x157b8,
	BNXT_ULP_CLASS_HID_13d68 = 0x13d68,
	BNXT_ULP_CLASS_HID_131aa = 0x131aa,
	BNXT_ULP_CLASS_HID_16192 = 0x16192,
	BNXT_ULP_CLASS_HID_175b2 = 0x175b2,
	BNXT_ULP_CLASS_HID_112b2 = 0x112b2,
	BNXT_ULP_CLASS_HID_106f0 = 0x106f0,
	BNXT_ULP_CLASS_HID_15692 = 0x15692,
	BNXT_ULP_CLASS_HID_14ad0 = 0x14ad0,
	BNXT_ULP_CLASS_HID_13080 = 0x13080,
	BNXT_ULP_CLASS_HID_124c2 = 0x124c2,
	BNXT_ULP_CLASS_HID_174e0 = 0x174e0,
	BNXT_ULP_CLASS_HID_16f22 = 0x16f22,
	BNXT_ULP_CLASS_HID_4025b = 0x4025b,
	BNXT_ULP_CLASS_HID_41267 = 0x41267,
	BNXT_ULP_CLASS_HID_5122b = 0x5122b,
	BNXT_ULP_CLASS_HID_50d51 = 0x50d51,
	BNXT_ULP_CLASS_HID_48a63 = 0x48a63,
	BNXT_ULP_CLASS_HID_48589 = 0x48589,
	BNXT_ULP_CLASS_HID_5855d = 0x5855d,
	BNXT_ULP_CLASS_HID_59519 = 0x59519,
	BNXT_ULP_CLASS_HID_41e17 = 0x41e17,
	BNXT_ULP_CLASS_HID_4093d = 0x4093d,
	BNXT_ULP_CLASS_HID_50941 = 0x50941,
	BNXT_ULP_CLASS_HID_5190d = 0x5190d,
	BNXT_ULP_CLASS_HID_48139 = 0x48139,
	BNXT_ULP_CLASS_HID_49145 = 0x49145,
	BNXT_ULP_CLASS_HID_59109 = 0x59109,
	BNXT_ULP_CLASS_HID_58037 = 0x58037,
	BNXT_ULP_CLASS_HID_4143d = 0x4143d,
	BNXT_ULP_CLASS_HID_4079b = 0x4079b,
	BNXT_ULP_CLASS_HID_507af = 0x507af,
	BNXT_ULP_CLASS_HID_5172b = 0x5172b,
	BNXT_ULP_CLASS_HID_49c05 = 0x49c05,
	BNXT_ULP_CLASS_HID_48fa3 = 0x48fa3,
	BNXT_ULP_CLASS_HID_58f37 = 0x58f37,
	BNXT_ULP_CLASS_HID_59f33 = 0x59f33,
	BNXT_ULP_CLASS_HID_4030b = 0x4030b,
	BNXT_ULP_CLASS_HID_41317 = 0x41317,
	BNXT_ULP_CLASS_HID_5131b = 0x5131b,
	BNXT_ULP_CLASS_HID_50201 = 0x50201,
	BNXT_ULP_CLASS_HID_48b13 = 0x48b13,
	BNXT_ULP_CLASS_HID_49b1f = 0x49b1f,
	BNXT_ULP_CLASS_HID_59b23 = 0x59b23,
	BNXT_ULP_CLASS_HID_58a09 = 0x58a09,
	BNXT_ULP_CLASS_HID_419bf = 0x419bf,
	BNXT_ULP_CLASS_HID_40925 = 0x40925,
	BNXT_ULP_CLASS_HID_508e9 = 0x508e9,
	BNXT_ULP_CLASS_HID_518b5 = 0x518b5,
	BNXT_ULP_CLASS_HID_48121 = 0x48121,
	BNXT_ULP_CLASS_HID_490ed = 0x490ed,
	BNXT_ULP_CLASS_HID_590b1 = 0x590b1,
	BNXT_ULP_CLASS_HID_583ff = 0x583ff,
	BNXT_ULP_CLASS_HID_41475 = 0x41475,
	BNXT_ULP_CLASS_HID_40473 = 0x40473,
	BNXT_ULP_CLASS_HID_50427 = 0x50427,
	BNXT_ULP_CLASS_HID_51763 = 0x51763,
	BNXT_ULP_CLASS_HID_49c3d = 0x49c3d,
	BNXT_ULP_CLASS_HID_48c3b = 0x48c3b,
	BNXT_ULP_CLASS_HID_58f6f = 0x58f6f,
	BNXT_ULP_CLASS_HID_59f2b = 0x59f2b,
	BNXT_ULP_CLASS_HID_40333 = 0x40333,
	BNXT_ULP_CLASS_HID_412bf = 0x412bf,
	BNXT_ULP_CLASS_HID_512a3 = 0x512a3,
	BNXT_ULP_CLASS_HID_50229 = 0x50229,
	BNXT_ULP_CLASS_HID_48abb = 0x48abb,
	BNXT_ULP_CLASS_HID_49aa7 = 0x49aa7,
	BNXT_ULP_CLASS_HID_59a2b = 0x59a2b,
	BNXT_ULP_CLASS_HID_595b1 = 0x595b1,
	BNXT_ULP_CLASS_HID_41e2f = 0x41e2f,
	BNXT_ULP_CLASS_HID_40e35 = 0x40e35,
	BNXT_ULP_CLASS_HID_50939 = 0x50939,
	BNXT_ULP_CLASS_HID_51925 = 0x51925,
	BNXT_ULP_CLASS_HID_48631 = 0x48631,
	BNXT_ULP_CLASS_HID_4913d = 0x4913d,
	BNXT_ULP_CLASS_HID_59121 = 0x59121,
	BNXT_ULP_CLASS_HID_5812f = 0x5812f,
	BNXT_ULP_CLASS_HID_41429 = 0x41429,
	BNXT_ULP_CLASS_HID_40747 = 0x40747,
	BNXT_ULP_CLASS_HID_5070b = 0x5070b,
	BNXT_ULP_CLASS_HID_51727 = 0x51727,
	BNXT_ULP_CLASS_HID_49fe1 = 0x49fe1,
	BNXT_ULP_CLASS_HID_48f0f = 0x48f0f,
	BNXT_ULP_CLASS_HID_58f23 = 0x58f23,
	BNXT_ULP_CLASS_HID_59eef = 0x59eef,
	BNXT_ULP_CLASS_HID_40347 = 0x40347,
	BNXT_ULP_CLASS_HID_41303 = 0x41303,
	BNXT_ULP_CLASS_HID_51247 = 0x51247,
	BNXT_ULP_CLASS_HID_5026d = 0x5026d,
	BNXT_ULP_CLASS_HID_48b0f = 0x48b0f,
	BNXT_ULP_CLASS_HID_49a4b = 0x49a4b,
	BNXT_ULP_CLASS_HID_59a0f = 0x59a0f,
	BNXT_ULP_CLASS_HID_58a05 = 0x58a05,
	BNXT_ULP_CLASS_HID_41983 = 0x41983,
	BNXT_ULP_CLASS_HID_40929 = 0x40929,
	BNXT_ULP_CLASS_HID_5092d = 0x5092d,
	BNXT_ULP_CLASS_HID_518a9 = 0x518a9,
	BNXT_ULP_CLASS_HID_48125 = 0x48125,
	BNXT_ULP_CLASS_HID_49121 = 0x49121,
	BNXT_ULP_CLASS_HID_59085 = 0x59085,
	BNXT_ULP_CLASS_HID_58023 = 0x58023,
	BNXT_ULP_CLASS_HID_41509 = 0x41509,
	BNXT_ULP_CLASS_HID_40407 = 0x40407,
	BNXT_ULP_CLASS_HID_5040b = 0x5040b,
	BNXT_ULP_CLASS_HID_51407 = 0x51407,
	BNXT_ULP_CLASS_HID_49d21 = 0x49d21,
	BNXT_ULP_CLASS_HID_48c0f = 0x48c0f,
	BNXT_ULP_CLASS_HID_58c03 = 0x58c03,
	BNXT_ULP_CLASS_HID_59f0f = 0x59f0f,
	BNXT_ULP_CLASS_HID_402ef = 0x402ef,
	BNXT_ULP_CLASS_HID_412ab = 0x412ab,
	BNXT_ULP_CLASS_HID_5126f = 0x5126f,
	BNXT_ULP_CLASS_HID_50de5 = 0x50de5,
	BNXT_ULP_CLASS_HID_48aa7 = 0x48aa7,
	BNXT_ULP_CLASS_HID_485ed = 0x485ed,
	BNXT_ULP_CLASS_HID_585e1 = 0x585e1,
	BNXT_ULP_CLASS_HID_595ad = 0x595ad,
	BNXT_ULP_CLASS_HID_41e6b = 0x41e6b,
	BNXT_ULP_CLASS_HID_40961 = 0x40961,
	BNXT_ULP_CLASS_HID_50925 = 0x50925,
	BNXT_ULP_CLASS_HID_51961 = 0x51961,
	BNXT_ULP_CLASS_HID_4816d = 0x4816d,
	BNXT_ULP_CLASS_HID_49129 = 0x49129,
	BNXT_ULP_CLASS_HID_5916d = 0x5916d,
	BNXT_ULP_CLASS_HID_5806b = 0x5806b,
	BNXT_ULP_CLASS_HID_414a1 = 0x414a1,
	BNXT_ULP_CLASS_HID_4042f = 0x4042f,
	BNXT_ULP_CLASS_HID_507a3 = 0x507a3,
	BNXT_ULP_CLASS_HID_517af = 0x517af,
	BNXT_ULP_CLASS_HID_49c29 = 0x49c29,
	BNXT_ULP_CLASS_HID_48fa7 = 0x48fa7,
	BNXT_ULP_CLASS_HID_58fab = 0x58fab,
	BNXT_ULP_CLASS_HID_59f27 = 0x59f27,
	BNXT_ULP_CLASS_HID_4032f = 0x4032f,
	BNXT_ULP_CLASS_HID_4132b = 0x4132b,
	BNXT_ULP_CLASS_HID_5132f = 0x5132f,
	BNXT_ULP_CLASS_HID_50225 = 0x50225,
	BNXT_ULP_CLASS_HID_48b27 = 0x48b27,
	BNXT_ULP_CLASS_HID_49b23 = 0x49b23,
	BNXT_ULP_CLASS_HID_59b27 = 0x59b27,
	BNXT_ULP_CLASS_HID_58a2d = 0x58a2d,
	BNXT_ULP_CLASS_HID_10437 = 0x10437,
	BNXT_ULP_CLASS_HID_11017 = 0x11017,
	BNXT_ULP_CLASS_HID_1402b = 0x1402b,
	BNXT_ULP_CLASS_HID_15c0b = 0x15c0b,
	BNXT_ULP_CLASS_HID_12639 = 0x12639,
	BNXT_ULP_CLASS_HID_13219 = 0x13219,
	BNXT_ULP_CLASS_HID_16ddd = 0x16ddd,
	BNXT_ULP_CLASS_HID_17e3d = 0x17e3d,
	BNXT_ULP_CLASS_HID_11333 = 0x11333,
	BNXT_ULP_CLASS_HID_10ef5 = 0x10ef5,
	BNXT_ULP_CLASS_HID_15f37 = 0x15f37,
	BNXT_ULP_CLASS_HID_14ae9 = 0x14ae9,
	BNXT_ULP_CLASS_HID_13d25 = 0x13d25,
	BNXT_ULP_CLASS_HID_128e7 = 0x128e7,
	BNXT_ULP_CLASS_HID_17939 = 0x17939,
	BNXT_ULP_CLASS_HID_174fb = 0x174fb,
	BNXT_ULP_CLASS_HID_10985 = 0x10985,
	BNXT_ULP_CLASS_HID_10547 = 0x10547,
	BNXT_ULP_CLASS_HID_155a9 = 0x155a9,
	BNXT_ULP_CLASS_HID_1416b = 0x1416b,
	BNXT_ULP_CLASS_HID_12ba7 = 0x12ba7,
	BNXT_ULP_CLASS_HID_12749 = 0x12749,
	BNXT_ULP_CLASS_HID_177ab = 0x177ab,
	BNXT_ULP_CLASS_HID_1636d = 0x1636d,
	BNXT_ULP_CLASS_HID_10463 = 0x10463,
	BNXT_ULP_CLASS_HID_110a3 = 0x110a3,
	BNXT_ULP_CLASS_HID_14067 = 0x14067,
	BNXT_ULP_CLASS_HID_15c67 = 0x15c67,
	BNXT_ULP_CLASS_HID_12665 = 0x12665,
	BNXT_ULP_CLASS_HID_13265 = 0x13265,
	BNXT_ULP_CLASS_HID_16269 = 0x16269,
	BNXT_ULP_CLASS_HID_17e69 = 0x17e69,
	BNXT_ULP_CLASS_HID_1133d = 0x1133d,
	BNXT_ULP_CLASS_HID_10eff = 0x10eff,
	BNXT_ULP_CLASS_HID_15ed9 = 0x15ed9,
	BNXT_ULP_CLASS_HID_14a9b = 0x14a9b,
	BNXT_ULP_CLASS_HID_13d2f = 0x13d2f,
	BNXT_ULP_CLASS_HID_128e9 = 0x128e9,
	BNXT_ULP_CLASS_HID_178cb = 0x178cb,
	BNXT_ULP_CLASS_HID_1748d = 0x1748d,
	BNXT_ULP_CLASS_HID_109fb = 0x109fb,
	BNXT_ULP_CLASS_HID_105bd = 0x105bd,
	BNXT_ULP_CLASS_HID_155bf = 0x155bf,
	BNXT_ULP_CLASS_HID_14179 = 0x14179,
	BNXT_ULP_CLASS_HID_12bed = 0x12bed,
	BNXT_ULP_CLASS_HID_127af = 0x127af,
	BNXT_ULP_CLASS_HID_177a9 = 0x177a9,
	BNXT_ULP_CLASS_HID_1636b = 0x1636b,
	BNXT_ULP_CLASS_HID_1046d = 0x1046d,
	BNXT_ULP_CLASS_HID_1104d = 0x1104d,
	BNXT_ULP_CLASS_HID_14009 = 0x14009,
	BNXT_ULP_CLASS_HID_15c69 = 0x15c69,
	BNXT_ULP_CLASS_HID_1260f = 0x1260f,
	BNXT_ULP_CLASS_HID_1326f = 0x1326f,
	BNXT_ULP_CLASS_HID_1622b = 0x1622b,
	BNXT_ULP_CLASS_HID_17e0b = 0x17e0b,
	BNXT_ULP_CLASS_HID_11369 = 0x11369,
	BNXT_ULP_CLASS_HID_10f2b = 0x10f2b,
	BNXT_ULP_CLASS_HID_15f6d = 0x15f6d,
	BNXT_ULP_CLASS_HID_14b2f = 0x14b2f,
	BNXT_ULP_CLASS_HID_13d6b = 0x13d6b,
	BNXT_ULP_CLASS_HID_1292d = 0x1292d,
	BNXT_ULP_CLASS_HID_1792f = 0x1792f,
	BNXT_ULP_CLASS_HID_174e9 = 0x174e9,
	BNXT_ULP_CLASS_HID_119e1 = 0x119e1,
	BNXT_ULP_CLASS_HID_115a3 = 0x115a3,
	BNXT_ULP_CLASS_HID_14563 = 0x14563,
	BNXT_ULP_CLASS_HID_15143 = 0x15143,
	BNXT_ULP_CLASS_HID_13b93 = 0x13b93,
	BNXT_ULP_CLASS_HID_13751 = 0x13751,
	BNXT_ULP_CLASS_HID_16769 = 0x16769,
	BNXT_ULP_CLASS_HID_17349 = 0x17349,
	BNXT_ULP_CLASS_HID_114ab = 0x114ab,
	BNXT_ULP_CLASS_HID_10061 = 0x10061,
	BNXT_ULP_CLASS_HID_15063 = 0x15063,
	BNXT_ULP_CLASS_HID_14c21 = 0x14c21,
	BNXT_ULP_CLASS_HID_13671 = 0x13671,
	BNXT_ULP_CLASS_HID_12233 = 0x12233,
	BNXT_ULP_CLASS_HID_17271 = 0x17271,
	BNXT_ULP_CLASS_HID_16e33 = 0x16e33,
	BNXT_ULP_CLASS_HID_102c1 = 0x102c1,
	BNXT_ULP_CLASS_HID_11f21 = 0x11f21,
	BNXT_ULP_CLASS_HID_14ee1 = 0x14ee1,
	BNXT_ULP_CLASS_HID_15ac1 = 0x15ac1,
	BNXT_ULP_CLASS_HID_12cc3 = 0x12cc3,
	BNXT_ULP_CLASS_HID_13923 = 0x13923,
	BNXT_ULP_CLASS_HID_168e3 = 0x168e3,
	BNXT_ULP_CLASS_HID_164a9 = 0x164a9,
	BNXT_ULP_CLASS_HID_11e29 = 0x11e29,
	BNXT_ULP_CLASS_HID_115eb = 0x115eb,
	BNXT_ULP_CLASS_HID_145a3 = 0x145a3,
	BNXT_ULP_CLASS_HID_151a3 = 0x151a3,
	BNXT_ULP_CLASS_HID_1382b = 0x1382b,
	BNXT_ULP_CLASS_HID_137e1 = 0x137e1,
	BNXT_ULP_CLASS_HID_167a1 = 0x167a1,
	BNXT_ULP_CLASS_HID_173a1 = 0x173a1,
	BNXT_ULP_CLASS_HID_11449 = 0x11449,
	BNXT_ULP_CLASS_HID_1000b = 0x1000b,
	BNXT_ULP_CLASS_HID_15069 = 0x15069,
	BNXT_ULP_CLASS_HID_14c2b = 0x14c2b,
	BNXT_ULP_CLASS_HID_1367b = 0x1367b,
	BNXT_ULP_CLASS_HID_12239 = 0x12239,
	BNXT_ULP_CLASS_HID_1721b = 0x1721b,
	BNXT_ULP_CLASS_HID_169d9 = 0x169d9,
	BNXT_ULP_CLASS_HID_1033b = 0x1033b,
	BNXT_ULP_CLASS_HID_11f3b = 0x11f3b,
	BNXT_ULP_CLASS_HID_14f2b = 0x14f2b,
	BNXT_ULP_CLASS_HID_15b2b = 0x15b2b,
	BNXT_ULP_CLASS_HID_12d39 = 0x12d39,
	BNXT_ULP_CLASS_HID_13939 = 0x13939,
	BNXT_ULP_CLASS_HID_168f9 = 0x168f9,
	BNXT_ULP_CLASS_HID_164bb = 0x164bb,
	BNXT_ULP_CLASS_HID_119cb = 0x119cb,
	BNXT_ULP_CLASS_HID_11589 = 0x11589,
	BNXT_ULP_CLASS_HID_14549 = 0x14549,
	BNXT_ULP_CLASS_HID_151a9 = 0x151a9,
	BNXT_ULP_CLASS_HID_13bc9 = 0x13bc9,
	BNXT_ULP_CLASS_HID_1378b = 0x1378b,
	BNXT_ULP_CLASS_HID_1674b = 0x1674b,
	BNXT_ULP_CLASS_HID_173ab = 0x173ab,
	BNXT_ULP_CLASS_HID_114a9 = 0x114a9,
	BNXT_ULP_CLASS_HID_1006b = 0x1006b,
	BNXT_ULP_CLASS_HID_150a9 = 0x150a9,
	BNXT_ULP_CLASS_HID_14c6b = 0x14c6b,
	BNXT_ULP_CLASS_HID_136ab = 0x136ab,
	BNXT_ULP_CLASS_HID_12269 = 0x12269,
	BNXT_ULP_CLASS_HID_172ab = 0x172ab,
	BNXT_ULP_CLASS_HID_16e69 = 0x16e69,
	BNXT_ULP_CLASS_HID_402d2 = 0x402d2,
	BNXT_ULP_CLASS_HID_412ee = 0x412ee,
	BNXT_ULP_CLASS_HID_512a2 = 0x512a2,
	BNXT_ULP_CLASS_HID_50dd8 = 0x50dd8,
	BNXT_ULP_CLASS_HID_48aea = 0x48aea,
	BNXT_ULP_CLASS_HID_48500 = 0x48500,
	BNXT_ULP_CLASS_HID_585d4 = 0x585d4,
	BNXT_ULP_CLASS_HID_59590 = 0x59590,
	BNXT_ULP_CLASS_HID_41936 = 0x41936,
	BNXT_ULP_CLASS_HID_409ac = 0x409ac,
	BNXT_ULP_CLASS_HID_50860 = 0x50860,
	BNXT_ULP_CLASS_HID_5183c = 0x5183c,
	BNXT_ULP_CLASS_HID_481a8 = 0x481a8,
	BNXT_ULP_CLASS_HID_49064 = 0x49064,
	BNXT_ULP_CLASS_HID_59038 = 0x59038,
	BNXT_ULP_CLASS_HID_58376 = 0x58376,
	BNXT_ULP_CLASS_HID_414a0 = 0x414a0,
	BNXT_ULP_CLASS_HID_407ce = 0x407ce,
	BNXT_ULP_CLASS_HID_50782 = 0x50782,
	BNXT_ULP_CLASS_HID_517ae = 0x517ae,
	BNXT_ULP_CLASS_HID_49f68 = 0x49f68,
	BNXT_ULP_CLASS_HID_48f86 = 0x48f86,
	BNXT_ULP_CLASS_HID_58faa = 0x58faa,
	BNXT_ULP_CLASS_HID_59e66 = 0x59e66,
	BNXT_ULP_CLASS_HID_40266 = 0x40266,
	BNXT_ULP_CLASS_HID_41222 = 0x41222,
	BNXT_ULP_CLASS_HID_512e6 = 0x512e6,
	BNXT_ULP_CLASS_HID_50d6c = 0x50d6c,
	BNXT_ULP_CLASS_HID_48a2e = 0x48a2e,
	BNXT_ULP_CLASS_HID_48564 = 0x48564,
	BNXT_ULP_CLASS_HID_58568 = 0x58568,
	BNXT_ULP_CLASS_HID_59524 = 0x59524,
	BNXT_ULP_CLASS_HID_419d8 = 0x419d8,
	BNXT_ULP_CLASS_HID_4087e = 0x4087e,
	BNXT_ULP_CLASS_HID_5080a = 0x5080a,
	BNXT_ULP_CLASS_HID_518ce = 0x518ce,
	BNXT_ULP_CLASS_HID_4807a = 0x4807a,
	BNXT_ULP_CLASS_HID_4900e = 0x4900e,
	BNXT_ULP_CLASS_HID_590ca = 0x590ca,
	BNXT_ULP_CLASS_HID_58378 = 0x58378,
	BNXT_ULP_CLASS_HID_414be = 0x414be,
	BNXT_ULP_CLASS_HID_4073c = 0x4073c,
	BNXT_ULP_CLASS_HID_507e8 = 0x507e8,
	BNXT_ULP_CLASS_HID_517ac = 0x517ac,
	BNXT_ULP_CLASS_HID_49f7e = 0x49f7e,
	BNXT_ULP_CLASS_HID_48fec = 0x48fec,
	BNXT_ULP_CLASS_HID_58fa8 = 0x58fa8,
	BNXT_ULP_CLASS_HID_59e7c = 0x59e7c,
	BNXT_ULP_CLASS_HID_40208 = 0x40208,
	BNXT_ULP_CLASS_HID_412cc = 0x412cc,
	BNXT_ULP_CLASS_HID_51288 = 0x51288,
	BNXT_ULP_CLASS_HID_50d2e = 0x50d2e,
	BNXT_ULP_CLASS_HID_48ac8 = 0x48ac8,
	BNXT_ULP_CLASS_HID_4856e = 0x4856e,
	BNXT_ULP_CLASS_HID_5852a = 0x5852a,
	BNXT_ULP_CLASS_HID_595ce = 0x595ce,
	BNXT_ULP_CLASS_HID_4196c = 0x4196c,
	BNXT_ULP_CLASS_HID_409aa = 0x409aa,
	BNXT_ULP_CLASS_HID_5086e = 0x5086e,
	BNXT_ULP_CLASS_HID_5182a = 0x5182a,
	BNXT_ULP_CLASS_HID_481ae = 0x481ae,
	BNXT_ULP_CLASS_HID_4906a = 0x4906a,
	BNXT_ULP_CLASS_HID_5902e = 0x5902e,
	BNXT_ULP_CLASS_HID_580ac = 0x580ac,
	BNXT_ULP_CLASS_HID_40766 = 0x40766,
	BNXT_ULP_CLASS_HID_41726 = 0x41726,
	BNXT_ULP_CLASS_HID_517f6 = 0x517f6,
	BNXT_ULP_CLASS_HID_5066c = 0x5066c,
	BNXT_ULP_CLASS_HID_48f3e = 0x48f3e,
	BNXT_ULP_CLASS_HID_49ffe = 0x49ffe,
	BNXT_ULP_CLASS_HID_59f8e = 0x59f8e,
	BNXT_ULP_CLASS_HID_58e24 = 0x58e24,
	BNXT_ULP_CLASS_HID_4126e = 0x4126e,
	BNXT_ULP_CLASS_HID_402e4 = 0x402e4,
	BNXT_ULP_CLASS_HID_502b4 = 0x502b4,
	BNXT_ULP_CLASS_HID_51d74 = 0x51d74,
	BNXT_ULP_CLASS_HID_49a26 = 0x49a26,
	BNXT_ULP_CLASS_HID_48abc = 0x48abc,
	BNXT_ULP_CLASS_HID_5956c = 0x5956c,
	BNXT_ULP_CLASS_HID_585ee = 0x585ee,
	BNXT_ULP_CLASS_HID_409e4 = 0x409e4,
	BNXT_ULP_CLASS_HID_419a4 = 0x419a4,
	BNXT_ULP_CLASS_HID_51844 = 0x51844,
	BNXT_ULP_CLASS_HID_508e6 = 0x508e6,
	BNXT_ULP_CLASS_HID_4918c = 0x4918c,
	BNXT_ULP_CLASS_HID_4802e = 0x4802e,
	BNXT_ULP_CLASS_HID_580ee = 0x580ee,
	BNXT_ULP_CLASS_HID_590ae = 0x590ae,
	BNXT_ULP_CLASS_HID_404ae = 0x404ae,
	BNXT_ULP_CLASS_HID_41766 = 0x41766,
	BNXT_ULP_CLASS_HID_5172e = 0x5172e,
	BNXT_ULP_CLASS_HID_507a4 = 0x507a4,
	BNXT_ULP_CLASS_HID_48f66 = 0x48f66,
	BNXT_ULP_CLASS_HID_49f2e = 0x49f2e,
	BNXT_ULP_CLASS_HID_59fe6 = 0x59fe6,
	BNXT_ULP_CLASS_HID_58e6c = 0x58e6c,
	BNXT_ULP_CLASS_HID_4126c = 0x4126c,
	BNXT_ULP_CLASS_HID_4028e = 0x4028e,
	BNXT_ULP_CLASS_HID_50d5e = 0x50d5e,
	BNXT_ULP_CLASS_HID_51d1e = 0x51d1e,
	BNXT_ULP_CLASS_HID_49a2c = 0x49a2c,
	BNXT_ULP_CLASS_HID_4954e = 0x4954e,
	BNXT_ULP_CLASS_HID_5951e = 0x5951e,
	BNXT_ULP_CLASS_HID_5858c = 0x5858c,
	BNXT_ULP_CLASS_HID_409fe = 0x409fe,
	BNXT_ULP_CLASS_HID_419ee = 0x419ee,
	BNXT_ULP_CLASS_HID_519ae = 0x519ae,
	BNXT_ULP_CLASS_HID_508fc = 0x508fc,
	BNXT_ULP_CLASS_HID_491ee = 0x491ee,
	BNXT_ULP_CLASS_HID_4802c = 0x4802c,
	BNXT_ULP_CLASS_HID_580fc = 0x580fc,
	BNXT_ULP_CLASS_HID_590bc = 0x590bc,
	BNXT_ULP_CLASS_HID_4074c = 0x4074c,
	BNXT_ULP_CLASS_HID_4170c = 0x4170c,
	BNXT_ULP_CLASS_HID_5172c = 0x5172c,
	BNXT_ULP_CLASS_HID_5064e = 0x5064e,
	BNXT_ULP_CLASS_HID_48f0c = 0x48f0c,
	BNXT_ULP_CLASS_HID_49fcc = 0x49fcc,
	BNXT_ULP_CLASS_HID_59fec = 0x59fec,
	BNXT_ULP_CLASS_HID_58e0e = 0x58e0e,
	BNXT_ULP_CLASS_HID_413ac = 0x413ac,
	BNXT_ULP_CLASS_HID_402ee = 0x402ee,
	BNXT_ULP_CLASS_HID_502ae = 0x502ae,
	BNXT_ULP_CLASS_HID_512ae = 0x512ae,
	BNXT_ULP_CLASS_HID_49a6c = 0x49a6c,
	BNXT_ULP_CLASS_HID_48aae = 0x48aae,
	BNXT_ULP_CLASS_HID_58aae = 0x58aae,
	BNXT_ULP_CLASS_HID_585ec = 0x585ec,
	BNXT_ULP_CLASS_HID_104ae = 0x104ae,
	BNXT_ULP_CLASS_HID_1108e = 0x1108e,
	BNXT_ULP_CLASS_HID_140b2 = 0x140b2,
	BNXT_ULP_CLASS_HID_15c92 = 0x15c92,
	BNXT_ULP_CLASS_HID_126a0 = 0x126a0,
	BNXT_ULP_CLASS_HID_13280 = 0x13280,
	BNXT_ULP_CLASS_HID_16d44 = 0x16d44,
	BNXT_ULP_CLASS_HID_17ea4 = 0x17ea4,
	BNXT_ULP_CLASS_HID_113a4 = 0x113a4,
	BNXT_ULP_CLASS_HID_10e66 = 0x10e66,
	BNXT_ULP_CLASS_HID_15e40 = 0x15e40,
	BNXT_ULP_CLASS_HID_14a02 = 0x14a02,
	BNXT_ULP_CLASS_HID_13db6 = 0x13db6,
	BNXT_ULP_CLASS_HID_12870 = 0x12870,
	BNXT_ULP_CLASS_HID_17852 = 0x17852,
	BNXT_ULP_CLASS_HID_17414 = 0x17414,
	BNXT_ULP_CLASS_HID_11978 = 0x11978,
	BNXT_ULP_CLASS_HID_1153a = 0x1153a,
	BNXT_ULP_CLASS_HID_145fa = 0x145fa,
	BNXT_ULP_CLASS_HID_151da = 0x151da,
	BNXT_ULP_CLASS_HID_13b0a = 0x13b0a,
	BNXT_ULP_CLASS_HID_137c8 = 0x137c8,
	BNXT_ULP_CLASS_HID_167f0 = 0x167f0,
	BNXT_ULP_CLASS_HID_173d0 = 0x173d0,
	BNXT_ULP_CLASS_HID_114d0 = 0x114d0,
	BNXT_ULP_CLASS_HID_10092 = 0x10092,
	BNXT_ULP_CLASS_HID_150f0 = 0x150f0,
	BNXT_ULP_CLASS_HID_14cb2 = 0x14cb2,
	BNXT_ULP_CLASS_HID_136e2 = 0x136e2,
	BNXT_ULP_CLASS_HID_122a0 = 0x122a0,
	BNXT_ULP_CLASS_HID_17282 = 0x17282,
	BNXT_ULP_CLASS_HID_16940 = 0x16940,
	BNXT_ULP_CLASS_HID_11b90 = 0x11b90,
	BNXT_ULP_CLASS_HID_11654 = 0x11654,
	BNXT_ULP_CLASS_HID_14618 = 0x14618,
	BNXT_ULP_CLASS_HID_15278 = 0x15278,
	BNXT_ULP_CLASS_HID_12404 = 0x12404,
	BNXT_ULP_CLASS_HID_13064 = 0x13064,
	BNXT_ULP_CLASS_HID_16028 = 0x16028,
	BNXT_ULP_CLASS_HID_17c08 = 0x17c08,
	BNXT_ULP_CLASS_HID_11100 = 0x11100,
	BNXT_ULP_CLASS_HID_10dc4 = 0x10dc4,
	BNXT_ULP_CLASS_HID_15d24 = 0x15d24,
	BNXT_ULP_CLASS_HID_149d0 = 0x149d0,
	BNXT_ULP_CLASS_HID_13314 = 0x13314,
	BNXT_ULP_CLASS_HID_12fd4 = 0x12fd4,
	BNXT_ULP_CLASS_HID_17f20 = 0x17f20,
	BNXT_ULP_CLASS_HID_16be0 = 0x16be0,
	BNXT_ULP_CLASS_HID_11cd8 = 0x11cd8,
	BNXT_ULP_CLASS_HID_10880 = 0x10880,
	BNXT_ULP_CLASS_HID_158e0 = 0x158e0,
	BNXT_ULP_CLASS_HID_154a0 = 0x154a0,
	BNXT_ULP_CLASS_HID_13ed0 = 0x13ed0,
	BNXT_ULP_CLASS_HID_12a90 = 0x12a90,
	BNXT_ULP_CLASS_HID_16550 = 0x16550,
	BNXT_ULP_CLASS_HID_176b0 = 0x176b0,
	BNXT_ULP_CLASS_HID_10bb0 = 0x10bb0,
	BNXT_ULP_CLASS_HID_10670 = 0x10670,
	BNXT_ULP_CLASS_HID_15650 = 0x15650,
	BNXT_ULP_CLASS_HID_14210 = 0x14210,
	BNXT_ULP_CLASS_HID_13440 = 0x13440,
	BNXT_ULP_CLASS_HID_12000 = 0x12000,
	BNXT_ULP_CLASS_HID_17060 = 0x17060,
	BNXT_ULP_CLASS_HID_16c20 = 0x16c20,
	BNXT_ULP_CLASS_HID_11511 = 0x11511,
	BNXT_ULP_CLASS_HID_101d3 = 0x101d3,
	BNXT_ULP_CLASS_HID_15135 = 0x15135,
	BNXT_ULP_CLASS_HID_14df7 = 0x14df7,
	BNXT_ULP_CLASS_HID_13723 = 0x13723,
	BNXT_ULP_CLASS_HID_123e5 = 0x123e5,
	BNXT_ULP_CLASS_HID_173c7 = 0x173c7,
	BNXT_ULP_CLASS_HID_16f89 = 0x16f89,
	BNXT_ULP_CLASS_HID_10081 = 0x10081,
	BNXT_ULP_CLASS_HID_11ce1 = 0x11ce1,
	BNXT_ULP_CLASS_HID_14ca5 = 0x14ca5,
	BNXT_ULP_CLASS_HID_15885 = 0x15885,
	BNXT_ULP_CLASS_HID_12293 = 0x12293,
	BNXT_ULP_CLASS_HID_13ef3 = 0x13ef3,
	BNXT_ULP_CLASS_HID_16eb7 = 0x16eb7,
	BNXT_ULP_CLASS_HID_16561 = 0x16561,
	BNXT_ULP_CLASS_HID_10e59 = 0x10e59,
	BNXT_ULP_CLASS_HID_11bb9 = 0x11bb9,
	BNXT_ULP_CLASS_HID_14a61 = 0x14a61,
	BNXT_ULP_CLASS_HID_14623 = 0x14623,
	BNXT_ULP_CLASS_HID_1286b = 0x1286b,
	BNXT_ULP_CLASS_HID_12411 = 0x12411,
	BNXT_ULP_CLASS_HID_17473 = 0x17473,
	BNXT_ULP_CLASS_HID_16031 = 0x16031,
	BNXT_ULP_CLASS_HID_10531 = 0x10531,
	BNXT_ULP_CLASS_HID_11111 = 0x11111,
	BNXT_ULP_CLASS_HID_141d1 = 0x141d1,
	BNXT_ULP_CLASS_HID_15d31 = 0x15d31,
	BNXT_ULP_CLASS_HID_127c3 = 0x127c3,
	BNXT_ULP_CLASS_HID_13323 = 0x13323,
	BNXT_ULP_CLASS_HID_163e3 = 0x163e3,
	BNXT_ULP_CLASS_HID_17fc3 = 0x17fc3,
	BNXT_ULP_CLASS_HID_108f5 = 0x108f5,
	BNXT_ULP_CLASS_HID_104b9 = 0x104b9,
	BNXT_ULP_CLASS_HID_15499 = 0x15499,
	BNXT_ULP_CLASS_HID_1435d = 0x1435d,
	BNXT_ULP_CLASS_HID_12a89 = 0x12a89,
	BNXT_ULP_CLASS_HID_12149 = 0x12149,
	BNXT_ULP_CLASS_HID_176ad = 0x176ad,
	BNXT_ULP_CLASS_HID_16d6d = 0x16d6d,
	BNXT_ULP_CLASS_HID_10665 = 0x10665,
	BNXT_ULP_CLASS_HID_11245 = 0x11245,
	BNXT_ULP_CLASS_HID_14271 = 0x14271,
	BNXT_ULP_CLASS_HID_15e51 = 0x15e51,
	BNXT_ULP_CLASS_HID_12061 = 0x12061,
	BNXT_ULP_CLASS_HID_13c41 = 0x13c41,
	BNXT_ULP_CLASS_HID_16c05 = 0x16c05,
	BNXT_ULP_CLASS_HID_17865 = 0x17865,
	BNXT_ULP_CLASS_HID_10d21 = 0x10d21,
	BNXT_ULP_CLASS_HID_11901 = 0x11901,
	BNXT_ULP_CLASS_HID_149c1 = 0x149c1,
	BNXT_ULP_CLASS_HID_14589 = 0x14589,
	BNXT_ULP_CLASS_HID_12f31 = 0x12f31,
	BNXT_ULP_CLASS_HID_13b11 = 0x13b11,
	BNXT_ULP_CLASS_HID_16bd9 = 0x16bd9,
	BNXT_ULP_CLASS_HID_16799 = 0x16799,
	BNXT_ULP_CLASS_HID_11831 = 0x11831,
	BNXT_ULP_CLASS_HID_114f1 = 0x114f1,
	BNXT_ULP_CLASS_HID_144b1 = 0x144b1,
	BNXT_ULP_CLASS_HID_15091 = 0x15091,
	BNXT_ULP_CLASS_HID_13ac1 = 0x13ac1,
	BNXT_ULP_CLASS_HID_13681 = 0x13681,
	BNXT_ULP_CLASS_HID_166b1 = 0x166b1,
	BNXT_ULP_CLASS_HID_17291 = 0x17291,
	BNXT_ULP_CLASS_HID_4007d = 0x4007d,
	BNXT_ULP_CLASS_HID_41041 = 0x41041,
	BNXT_ULP_CLASS_HID_5100d = 0x5100d,
	BNXT_ULP_CLASS_HID_50f77 = 0x50f77,
	BNXT_ULP_CLASS_HID_48845 = 0x48845,
	BNXT_ULP_CLASS_HID_487af = 0x487af,
	BNXT_ULP_CLASS_HID_5877b = 0x5877b,
	BNXT_ULP_CLASS_HID_5973f = 0x5973f,
	BNXT_ULP_CLASS_HID_41c31 = 0x41c31,
	BNXT_ULP_CLASS_HID_40b1b = 0x40b1b,
	BNXT_ULP_CLASS_HID_50b67 = 0x50b67,
	BNXT_ULP_CLASS_HID_51b2b = 0x51b2b,
	BNXT_ULP_CLASS_HID_4831f = 0x4831f,
	BNXT_ULP_CLASS_HID_49363 = 0x49363,
	BNXT_ULP_CLASS_HID_5932f = 0x5932f,
	BNXT_ULP_CLASS_HID_58211 = 0x58211,
	BNXT_ULP_CLASS_HID_4161b = 0x4161b,
	BNXT_ULP_CLASS_HID_405bd = 0x405bd,
	BNXT_ULP_CLASS_HID_50589 = 0x50589,
	BNXT_ULP_CLASS_HID_5150d = 0x5150d,
	BNXT_ULP_CLASS_HID_49e23 = 0x49e23,
	BNXT_ULP_CLASS_HID_48d85 = 0x48d85,
	BNXT_ULP_CLASS_HID_58d11 = 0x58d11,
	BNXT_ULP_CLASS_HID_59d15 = 0x59d15,
	BNXT_ULP_CLASS_HID_4012d = 0x4012d,
	BNXT_ULP_CLASS_HID_41131 = 0x41131,
	BNXT_ULP_CLASS_HID_5113d = 0x5113d,
	BNXT_ULP_CLASS_HID_50027 = 0x50027,
	BNXT_ULP_CLASS_HID_48935 = 0x48935,
	BNXT_ULP_CLASS_HID_49939 = 0x49939,
	BNXT_ULP_CLASS_HID_59905 = 0x59905,
	BNXT_ULP_CLASS_HID_5882f = 0x5882f,
	BNXT_ULP_CLASS_HID_41b99 = 0x41b99,
	BNXT_ULP_CLASS_HID_40b03 = 0x40b03,
	BNXT_ULP_CLASS_HID_50acf = 0x50acf,
	BNXT_ULP_CLASS_HID_51a93 = 0x51a93,
	BNXT_ULP_CLASS_HID_48307 = 0x48307,
	BNXT_ULP_CLASS_HID_492cb = 0x492cb,
	BNXT_ULP_CLASS_HID_59297 = 0x59297,
	BNXT_ULP_CLASS_HID_581d9 = 0x581d9,
	BNXT_ULP_CLASS_HID_41653 = 0x41653,
	BNXT_ULP_CLASS_HID_40655 = 0x40655,
	BNXT_ULP_CLASS_HID_50601 = 0x50601,
	BNXT_ULP_CLASS_HID_51545 = 0x51545,
	BNXT_ULP_CLASS_HID_49e1b = 0x49e1b,
	BNXT_ULP_CLASS_HID_48e1d = 0x48e1d,
	BNXT_ULP_CLASS_HID_58d49 = 0x58d49,
	BNXT_ULP_CLASS_HID_59d0d = 0x59d0d,
	BNXT_ULP_CLASS_HID_40115 = 0x40115,
	BNXT_ULP_CLASS_HID_41099 = 0x41099,
	BNXT_ULP_CLASS_HID_51085 = 0x51085,
	BNXT_ULP_CLASS_HID_5000f = 0x5000f,
	BNXT_ULP_CLASS_HID_4889d = 0x4889d,
	BNXT_ULP_CLASS_HID_49881 = 0x49881,
	BNXT_ULP_CLASS_HID_5980d = 0x5980d,
	BNXT_ULP_CLASS_HID_59797 = 0x59797,
	BNXT_ULP_CLASS_HID_41c09 = 0x41c09,
	BNXT_ULP_CLASS_HID_40c13 = 0x40c13,
	BNXT_ULP_CLASS_HID_50b1f = 0x50b1f,
	BNXT_ULP_CLASS_HID_51b03 = 0x51b03,
	BNXT_ULP_CLASS_HID_48417 = 0x48417,
	BNXT_ULP_CLASS_HID_4931b = 0x4931b,
	BNXT_ULP_CLASS_HID_59307 = 0x59307,
	BNXT_ULP_CLASS_HID_58309 = 0x58309,
	BNXT_ULP_CLASS_HID_4160f = 0x4160f,
	BNXT_ULP_CLASS_HID_40561 = 0x40561,
	BNXT_ULP_CLASS_HID_5052d = 0x5052d,
	BNXT_ULP_CLASS_HID_51501 = 0x51501,
	BNXT_ULP_CLASS_HID_49dc7 = 0x49dc7,
	BNXT_ULP_CLASS_HID_48d29 = 0x48d29,
	BNXT_ULP_CLASS_HID_58d05 = 0x58d05,
	BNXT_ULP_CLASS_HID_59cc9 = 0x59cc9,
	BNXT_ULP_CLASS_HID_40161 = 0x40161,
	BNXT_ULP_CLASS_HID_41125 = 0x41125,
	BNXT_ULP_CLASS_HID_51061 = 0x51061,
	BNXT_ULP_CLASS_HID_5004b = 0x5004b,
	BNXT_ULP_CLASS_HID_48929 = 0x48929,
	BNXT_ULP_CLASS_HID_4986d = 0x4986d,
	BNXT_ULP_CLASS_HID_59829 = 0x59829,
	BNXT_ULP_CLASS_HID_58823 = 0x58823,
	BNXT_ULP_CLASS_HID_41ba5 = 0x41ba5,
	BNXT_ULP_CLASS_HID_40b0f = 0x40b0f,
	BNXT_ULP_CLASS_HID_50b0b = 0x50b0b,
	BNXT_ULP_CLASS_HID_51a8f = 0x51a8f,
	BNXT_ULP_CLASS_HID_48303 = 0x48303,
	BNXT_ULP_CLASS_HID_49307 = 0x49307,
	BNXT_ULP_CLASS_HID_592a3 = 0x592a3,
	BNXT_ULP_CLASS_HID_58205 = 0x58205,
	BNXT_ULP_CLASS_HID_4172f = 0x4172f,
	BNXT_ULP_CLASS_HID_40621 = 0x40621,
	BNXT_ULP_CLASS_HID_5062d = 0x5062d,
	BNXT_ULP_CLASS_HID_51621 = 0x51621,
	BNXT_ULP_CLASS_HID_49f07 = 0x49f07,
	BNXT_ULP_CLASS_HID_48e29 = 0x48e29,
	BNXT_ULP_CLASS_HID_58e25 = 0x58e25,
	BNXT_ULP_CLASS_HID_59d29 = 0x59d29,
	BNXT_ULP_CLASS_HID_400c9 = 0x400c9,
	BNXT_ULP_CLASS_HID_4108d = 0x4108d,
	BNXT_ULP_CLASS_HID_51049 = 0x51049,
	BNXT_ULP_CLASS_HID_50fc3 = 0x50fc3,
	BNXT_ULP_CLASS_HID_48881 = 0x48881,
	BNXT_ULP_CLASS_HID_487cb = 0x487cb,
	BNXT_ULP_CLASS_HID_587c7 = 0x587c7,
	BNXT_ULP_CLASS_HID_5978b = 0x5978b,
	BNXT_ULP_CLASS_HID_41c4d = 0x41c4d,
	BNXT_ULP_CLASS_HID_40b47 = 0x40b47,
	BNXT_ULP_CLASS_HID_50b03 = 0x50b03,
	BNXT_ULP_CLASS_HID_51b47 = 0x51b47,
	BNXT_ULP_CLASS_HID_4834b = 0x4834b,
	BNXT_ULP_CLASS_HID_4930f = 0x4930f,
	BNXT_ULP_CLASS_HID_5934b = 0x5934b,
	BNXT_ULP_CLASS_HID_5824d = 0x5824d,
	BNXT_ULP_CLASS_HID_41687 = 0x41687,
	BNXT_ULP_CLASS_HID_40609 = 0x40609,
	BNXT_ULP_CLASS_HID_50585 = 0x50585,
	BNXT_ULP_CLASS_HID_51589 = 0x51589,
	BNXT_ULP_CLASS_HID_49e0f = 0x49e0f,
	BNXT_ULP_CLASS_HID_48d81 = 0x48d81,
	BNXT_ULP_CLASS_HID_58d8d = 0x58d8d,
	BNXT_ULP_CLASS_HID_59d01 = 0x59d01,
	BNXT_ULP_CLASS_HID_40109 = 0x40109,
	BNXT_ULP_CLASS_HID_4110d = 0x4110d,
	BNXT_ULP_CLASS_HID_51109 = 0x51109,
	BNXT_ULP_CLASS_HID_50003 = 0x50003,
	BNXT_ULP_CLASS_HID_48901 = 0x48901,
	BNXT_ULP_CLASS_HID_49905 = 0x49905,
	BNXT_ULP_CLASS_HID_59901 = 0x59901,
	BNXT_ULP_CLASS_HID_5880b = 0x5880b,
	BNXT_ULP_CLASS_HID_10619 = 0x10619,
	BNXT_ULP_CLASS_HID_11239 = 0x11239,
	BNXT_ULP_CLASS_HID_14205 = 0x14205,
	BNXT_ULP_CLASS_HID_15e25 = 0x15e25,
	BNXT_ULP_CLASS_HID_12417 = 0x12417,
	BNXT_ULP_CLASS_HID_13037 = 0x13037,
	BNXT_ULP_CLASS_HID_16ff3 = 0x16ff3,
	BNXT_ULP_CLASS_HID_17c13 = 0x17c13,
	BNXT_ULP_CLASS_HID_1111d = 0x1111d,
	BNXT_ULP_CLASS_HID_10cdb = 0x10cdb,
	BNXT_ULP_CLASS_HID_15d19 = 0x15d19,
	BNXT_ULP_CLASS_HID_148c7 = 0x148c7,
	BNXT_ULP_CLASS_HID_13f0b = 0x13f0b,
	BNXT_ULP_CLASS_HID_12ac9 = 0x12ac9,
	BNXT_ULP_CLASS_HID_17b17 = 0x17b17,
	BNXT_ULP_CLASS_HID_176d5 = 0x176d5,
	BNXT_ULP_CLASS_HID_10bab = 0x10bab,
	BNXT_ULP_CLASS_HID_10769 = 0x10769,
	BNXT_ULP_CLASS_HID_15787 = 0x15787,
	BNXT_ULP_CLASS_HID_14345 = 0x14345,
	BNXT_ULP_CLASS_HID_12989 = 0x12989,
	BNXT_ULP_CLASS_HID_12567 = 0x12567,
	BNXT_ULP_CLASS_HID_17585 = 0x17585,
	BNXT_ULP_CLASS_HID_16143 = 0x16143,
	BNXT_ULP_CLASS_HID_1064d = 0x1064d,
	BNXT_ULP_CLASS_HID_1128d = 0x1128d,
	BNXT_ULP_CLASS_HID_14249 = 0x14249,
	BNXT_ULP_CLASS_HID_15e49 = 0x15e49,
	BNXT_ULP_CLASS_HID_1244b = 0x1244b,
	BNXT_ULP_CLASS_HID_1304b = 0x1304b,
	BNXT_ULP_CLASS_HID_16047 = 0x16047,
	BNXT_ULP_CLASS_HID_17c47 = 0x17c47,
	BNXT_ULP_CLASS_HID_11113 = 0x11113,
	BNXT_ULP_CLASS_HID_10cd1 = 0x10cd1,
	BNXT_ULP_CLASS_HID_15cf7 = 0x15cf7,
	BNXT_ULP_CLASS_HID_148b5 = 0x148b5,
	BNXT_ULP_CLASS_HID_13f01 = 0x13f01,
	BNXT_ULP_CLASS_HID_12ac7 = 0x12ac7,
	BNXT_ULP_CLASS_HID_17ae5 = 0x17ae5,
	BNXT_ULP_CLASS_HID_176a3 = 0x176a3,
	BNXT_ULP_CLASS_HID_10bd5 = 0x10bd5,
	BNXT_ULP_CLASS_HID_10793 = 0x10793,
	BNXT_ULP_CLASS_HID_15791 = 0x15791,
	BNXT_ULP_CLASS_HID_14357 = 0x14357,
	BNXT_ULP_CLASS_HID_129c3 = 0x129c3,
	BNXT_ULP_CLASS_HID_12581 = 0x12581,
	BNXT_ULP_CLASS_HID_17587 = 0x17587,
	BNXT_ULP_CLASS_HID_16145 = 0x16145,
	BNXT_ULP_CLASS_HID_10643 = 0x10643,
	BNXT_ULP_CLASS_HID_11263 = 0x11263,
	BNXT_ULP_CLASS_HID_14227 = 0x14227,
	BNXT_ULP_CLASS_HID_15e47 = 0x15e47,
	BNXT_ULP_CLASS_HID_12421 = 0x12421,
	BNXT_ULP_CLASS_HID_13041 = 0x13041,
	BNXT_ULP_CLASS_HID_16005 = 0x16005,
	BNXT_ULP_CLASS_HID_17c25 = 0x17c25,
	BNXT_ULP_CLASS_HID_11147 = 0x11147,
	BNXT_ULP_CLASS_HID_10d05 = 0x10d05,
	BNXT_ULP_CLASS_HID_15d43 = 0x15d43,
	BNXT_ULP_CLASS_HID_14901 = 0x14901,
	BNXT_ULP_CLASS_HID_13f45 = 0x13f45,
	BNXT_ULP_CLASS_HID_12b03 = 0x12b03,
	BNXT_ULP_CLASS_HID_17b01 = 0x17b01,
	BNXT_ULP_CLASS_HID_176c7 = 0x176c7,
	BNXT_ULP_CLASS_HID_11bcf = 0x11bcf,
	BNXT_ULP_CLASS_HID_1178d = 0x1178d,
	BNXT_ULP_CLASS_HID_1474d = 0x1474d,
	BNXT_ULP_CLASS_HID_1536d = 0x1536d,
	BNXT_ULP_CLASS_HID_139bd = 0x139bd,
	BNXT_ULP_CLASS_HID_1357f = 0x1357f,
	BNXT_ULP_CLASS_HID_16547 = 0x16547,
	BNXT_ULP_CLASS_HID_17167 = 0x17167,
	BNXT_ULP_CLASS_HID_11685 = 0x11685,
	BNXT_ULP_CLASS_HID_1024f = 0x1024f,
	BNXT_ULP_CLASS_HID_1524d = 0x1524d,
	BNXT_ULP_CLASS_HID_14e0f = 0x14e0f,
	BNXT_ULP_CLASS_HID_1345f = 0x1345f,
	BNXT_ULP_CLASS_HID_1201d = 0x1201d,
	BNXT_ULP_CLASS_HID_1705f = 0x1705f,
	BNXT_ULP_CLASS_HID_16c1d = 0x16c1d,
	BNXT_ULP_CLASS_HID_100ef = 0x100ef,
	BNXT_ULP_CLASS_HID_11d0f = 0x11d0f,
	BNXT_ULP_CLASS_HID_14ccf = 0x14ccf,
	BNXT_ULP_CLASS_HID_158ef = 0x158ef,
	BNXT_ULP_CLASS_HID_12eed = 0x12eed,
	BNXT_ULP_CLASS_HID_13b0d = 0x13b0d,
	BNXT_ULP_CLASS_HID_16acd = 0x16acd,
	BNXT_ULP_CLASS_HID_16687 = 0x16687,
	BNXT_ULP_CLASS_HID_11c07 = 0x11c07,
	BNXT_ULP_CLASS_HID_117c5 = 0x117c5,
	BNXT_ULP_CLASS_HID_1478d = 0x1478d,
	BNXT_ULP_CLASS_HID_1538d = 0x1538d,
	BNXT_ULP_CLASS_HID_13a05 = 0x13a05,
	BNXT_ULP_CLASS_HID_135cf = 0x135cf,
	BNXT_ULP_CLASS_HID_1658f = 0x1658f,
	BNXT_ULP_CLASS_HID_1718f = 0x1718f,
	BNXT_ULP_CLASS_HID_11667 = 0x11667,
	BNXT_ULP_CLASS_HID_10225 = 0x10225,
	BNXT_ULP_CLASS_HID_15247 = 0x15247,
	BNXT_ULP_CLASS_HID_14e05 = 0x14e05,
	BNXT_ULP_CLASS_HID_13455 = 0x13455,
	BNXT_ULP_CLASS_HID_12017 = 0x12017,
	BNXT_ULP_CLASS_HID_17035 = 0x17035,
	BNXT_ULP_CLASS_HID_16bf7 = 0x16bf7,
	BNXT_ULP_CLASS_HID_10115 = 0x10115,
	BNXT_ULP_CLASS_HID_11d15 = 0x11d15,
	BNXT_ULP_CLASS_HID_14d05 = 0x14d05,
	BNXT_ULP_CLASS_HID_15905 = 0x15905,
	BNXT_ULP_CLASS_HID_12f17 = 0x12f17,
	BNXT_ULP_CLASS_HID_13b17 = 0x13b17,
	BNXT_ULP_CLASS_HID_16ad7 = 0x16ad7,
	BNXT_ULP_CLASS_HID_16695 = 0x16695,
	BNXT_ULP_CLASS_HID_11be5 = 0x11be5,
	BNXT_ULP_CLASS_HID_117a7 = 0x117a7,
	BNXT_ULP_CLASS_HID_14767 = 0x14767,
	BNXT_ULP_CLASS_HID_15387 = 0x15387,
	BNXT_ULP_CLASS_HID_139e7 = 0x139e7,
	BNXT_ULP_CLASS_HID_135a5 = 0x135a5,
	BNXT_ULP_CLASS_HID_16565 = 0x16565,
	BNXT_ULP_CLASS_HID_17185 = 0x17185,
	BNXT_ULP_CLASS_HID_11687 = 0x11687,
	BNXT_ULP_CLASS_HID_10245 = 0x10245,
	BNXT_ULP_CLASS_HID_15287 = 0x15287,
	BNXT_ULP_CLASS_HID_14e45 = 0x14e45,
	BNXT_ULP_CLASS_HID_13485 = 0x13485,
	BNXT_ULP_CLASS_HID_12047 = 0x12047,
	BNXT_ULP_CLASS_HID_17085 = 0x17085,
	BNXT_ULP_CLASS_HID_16c47 = 0x16c47,
	BNXT_ULP_CLASS_HID_400f4 = 0x400f4,
	BNXT_ULP_CLASS_HID_410c8 = 0x410c8,
	BNXT_ULP_CLASS_HID_51084 = 0x51084,
	BNXT_ULP_CLASS_HID_50ffe = 0x50ffe,
	BNXT_ULP_CLASS_HID_488cc = 0x488cc,
	BNXT_ULP_CLASS_HID_48726 = 0x48726,
	BNXT_ULP_CLASS_HID_587f2 = 0x587f2,
	BNXT_ULP_CLASS_HID_597b6 = 0x597b6,
	BNXT_ULP_CLASS_HID_41b10 = 0x41b10,
	BNXT_ULP_CLASS_HID_40b8a = 0x40b8a,
	BNXT_ULP_CLASS_HID_50a46 = 0x50a46,
	BNXT_ULP_CLASS_HID_51a1a = 0x51a1a,
	BNXT_ULP_CLASS_HID_4838e = 0x4838e,
	BNXT_ULP_CLASS_HID_49242 = 0x49242,
	BNXT_ULP_CLASS_HID_5921e = 0x5921e,
	BNXT_ULP_CLASS_HID_58150 = 0x58150,
	BNXT_ULP_CLASS_HID_41686 = 0x41686,
	BNXT_ULP_CLASS_HID_405e8 = 0x405e8,
	BNXT_ULP_CLASS_HID_505a4 = 0x505a4,
	BNXT_ULP_CLASS_HID_51588 = 0x51588,
	BNXT_ULP_CLASS_HID_49d4e = 0x49d4e,
	BNXT_ULP_CLASS_HID_48da0 = 0x48da0,
	BNXT_ULP_CLASS_HID_58d8c = 0x58d8c,
	BNXT_ULP_CLASS_HID_59c40 = 0x59c40,
	BNXT_ULP_CLASS_HID_40040 = 0x40040,
	BNXT_ULP_CLASS_HID_41004 = 0x41004,
	BNXT_ULP_CLASS_HID_510c0 = 0x510c0,
	BNXT_ULP_CLASS_HID_50f4a = 0x50f4a,
	BNXT_ULP_CLASS_HID_48808 = 0x48808,
	BNXT_ULP_CLASS_HID_48742 = 0x48742,
	BNXT_ULP_CLASS_HID_5874e = 0x5874e,
	BNXT_ULP_CLASS_HID_59702 = 0x59702,
	BNXT_ULP_CLASS_HID_41bfe = 0x41bfe,
	BNXT_ULP_CLASS_HID_40a58 = 0x40a58,
	BNXT_ULP_CLASS_HID_50a2c = 0x50a2c,
	BNXT_ULP_CLASS_HID_51ae8 = 0x51ae8,
	BNXT_ULP_CLASS_HID_4825c = 0x4825c,
	BNXT_ULP_CLASS_HID_49228 = 0x49228,
	BNXT_ULP_CLASS_HID_592ec = 0x592ec,
	BNXT_ULP_CLASS_HID_5815e = 0x5815e,
	BNXT_ULP_CLASS_HID_41698 = 0x41698,
	BNXT_ULP_CLASS_HID_4051a = 0x4051a,
	BNXT_ULP_CLASS_HID_505ce = 0x505ce,
	BNXT_ULP_CLASS_HID_5158a = 0x5158a,
	BNXT_ULP_CLASS_HID_49d58 = 0x49d58,
	BNXT_ULP_CLASS_HID_48dca = 0x48dca,
	BNXT_ULP_CLASS_HID_58d8e = 0x58d8e,
	BNXT_ULP_CLASS_HID_59c5a = 0x59c5a,
	BNXT_ULP_CLASS_HID_4002e = 0x4002e,
	BNXT_ULP_CLASS_HID_410ea = 0x410ea,
	BNXT_ULP_CLASS_HID_510ae = 0x510ae,
	BNXT_ULP_CLASS_HID_50f08 = 0x50f08,
	BNXT_ULP_CLASS_HID_488ee = 0x488ee,
	BNXT_ULP_CLASS_HID_48748 = 0x48748,
	BNXT_ULP_CLASS_HID_5870c = 0x5870c,
	BNXT_ULP_CLASS_HID_597e8 = 0x597e8,
	BNXT_ULP_CLASS_HID_41b4a = 0x41b4a,
	BNXT_ULP_CLASS_HID_40b8c = 0x40b8c,
	BNXT_ULP_CLASS_HID_50a48 = 0x50a48,
	BNXT_ULP_CLASS_HID_51a0c = 0x51a0c,
	BNXT_ULP_CLASS_HID_48388 = 0x48388,
	BNXT_ULP_CLASS_HID_4924c = 0x4924c,
	BNXT_ULP_CLASS_HID_59208 = 0x59208,
	BNXT_ULP_CLASS_HID_5828a = 0x5828a,
	BNXT_ULP_CLASS_HID_40540 = 0x40540,
	BNXT_ULP_CLASS_HID_41500 = 0x41500,
	BNXT_ULP_CLASS_HID_515d0 = 0x515d0,
	BNXT_ULP_CLASS_HID_5044a = 0x5044a,
	BNXT_ULP_CLASS_HID_48d18 = 0x48d18,
	BNXT_ULP_CLASS_HID_49dd8 = 0x49dd8,
	BNXT_ULP_CLASS_HID_59da8 = 0x59da8,
	BNXT_ULP_CLASS_HID_58c02 = 0x58c02,
	BNXT_ULP_CLASS_HID_41048 = 0x41048,
	BNXT_ULP_CLASS_HID_400c2 = 0x400c2,
	BNXT_ULP_CLASS_HID_50092 = 0x50092,
	BNXT_ULP_CLASS_HID_51f52 = 0x51f52,
	BNXT_ULP_CLASS_HID_49800 = 0x49800,
	BNXT_ULP_CLASS_HID_4889a = 0x4889a,
	BNXT_ULP_CLASS_HID_5974a = 0x5974a,
	BNXT_ULP_CLASS_HID_587c8 = 0x587c8,
	BNXT_ULP_CLASS_HID_40bc2 = 0x40bc2,
	BNXT_ULP_CLASS_HID_41b82 = 0x41b82,
	BNXT_ULP_CLASS_HID_51a62 = 0x51a62,
	BNXT_ULP_CLASS_HID_50ac0 = 0x50ac0,
	BNXT_ULP_CLASS_HID_493aa = 0x493aa,
	BNXT_ULP_CLASS_HID_48208 = 0x48208,
	BNXT_ULP_CLASS_HID_582c8 = 0x582c8,
	BNXT_ULP_CLASS_HID_59288 = 0x59288,
	BNXT_ULP_CLASS_HID_40688 = 0x40688,
	BNXT_ULP_CLASS_HID_41540 = 0x41540,
	BNXT_ULP_CLASS_HID_51508 = 0x51508,
	BNXT_ULP_CLASS_HID_50582 = 0x50582,
	BNXT_ULP_CLASS_HID_48d40 = 0x48d40,
	BNXT_ULP_CLASS_HID_49d08 = 0x49d08,
	BNXT_ULP_CLASS_HID_59dc0 = 0x59dc0,
	BNXT_ULP_CLASS_HID_58c4a = 0x58c4a,
	BNXT_ULP_CLASS_HID_4104a = 0x4104a,
	BNXT_ULP_CLASS_HID_400a8 = 0x400a8,
	BNXT_ULP_CLASS_HID_50f78 = 0x50f78,
	BNXT_ULP_CLASS_HID_51f38 = 0x51f38,
	BNXT_ULP_CLASS_HID_4980a = 0x4980a,
	BNXT_ULP_CLASS_HID_49768 = 0x49768,
	BNXT_ULP_CLASS_HID_59738 = 0x59738,
	BNXT_ULP_CLASS_HID_587aa = 0x587aa,
	BNXT_ULP_CLASS_HID_40bd8 = 0x40bd8,
	BNXT_ULP_CLASS_HID_41bc8 = 0x41bc8,
	BNXT_ULP_CLASS_HID_51b88 = 0x51b88,
	BNXT_ULP_CLASS_HID_50ada = 0x50ada,
	BNXT_ULP_CLASS_HID_493c8 = 0x493c8,
	BNXT_ULP_CLASS_HID_4820a = 0x4820a,
	BNXT_ULP_CLASS_HID_582da = 0x582da,
	BNXT_ULP_CLASS_HID_5929a = 0x5929a,
	BNXT_ULP_CLASS_HID_4056a = 0x4056a,
	BNXT_ULP_CLASS_HID_4152a = 0x4152a,
	BNXT_ULP_CLASS_HID_5150a = 0x5150a,
	BNXT_ULP_CLASS_HID_50468 = 0x50468,
	BNXT_ULP_CLASS_HID_48d2a = 0x48d2a,
	BNXT_ULP_CLASS_HID_49dea = 0x49dea,
	BNXT_ULP_CLASS_HID_59dca = 0x59dca,
	BNXT_ULP_CLASS_HID_58c28 = 0x58c28,
	BNXT_ULP_CLASS_HID_4118a = 0x4118a,
	BNXT_ULP_CLASS_HID_400c8 = 0x400c8,
	BNXT_ULP_CLASS_HID_50088 = 0x50088,
	BNXT_ULP_CLASS_HID_51088 = 0x51088,
	BNXT_ULP_CLASS_HID_4984a = 0x4984a,
	BNXT_ULP_CLASS_HID_48888 = 0x48888,
	BNXT_ULP_CLASS_HID_58888 = 0x58888,
	BNXT_ULP_CLASS_HID_587ca = 0x587ca,
	BNXT_ULP_CLASS_HID_10690 = 0x10690,
	BNXT_ULP_CLASS_HID_112b0 = 0x112b0,
	BNXT_ULP_CLASS_HID_1428c = 0x1428c,
	BNXT_ULP_CLASS_HID_15eac = 0x15eac,
	BNXT_ULP_CLASS_HID_1249e = 0x1249e,
	BNXT_ULP_CLASS_HID_130be = 0x130be,
	BNXT_ULP_CLASS_HID_16f7a = 0x16f7a,
	BNXT_ULP_CLASS_HID_17c9a = 0x17c9a,
	BNXT_ULP_CLASS_HID_1119a = 0x1119a,
	BNXT_ULP_CLASS_HID_10c58 = 0x10c58,
	BNXT_ULP_CLASS_HID_15c7e = 0x15c7e,
	BNXT_ULP_CLASS_HID_1483c = 0x1483c,
	BNXT_ULP_CLASS_HID_13f88 = 0x13f88,
	BNXT_ULP_CLASS_HID_12a4e = 0x12a4e,
	BNXT_ULP_CLASS_HID_17a6c = 0x17a6c,
	BNXT_ULP_CLASS_HID_1762a = 0x1762a,
	BNXT_ULP_CLASS_HID_11b46 = 0x11b46,
	BNXT_ULP_CLASS_HID_11704 = 0x11704,
	BNXT_ULP_CLASS_HID_147c4 = 0x147c4,
	BNXT_ULP_CLASS_HID_153e4 = 0x153e4,
	BNXT_ULP_CLASS_HID_13934 = 0x13934,
	BNXT_ULP_CLASS_HID_135f6 = 0x135f6,
	BNXT_ULP_CLASS_HID_165ce = 0x165ce,
	BNXT_ULP_CLASS_HID_171ee = 0x171ee,
	BNXT_ULP_CLASS_HID_116ee = 0x116ee,
	BNXT_ULP_CLASS_HID_102ac = 0x102ac,
	BNXT_ULP_CLASS_HID_152ce = 0x152ce,
	BNXT_ULP_CLASS_HID_14e8c = 0x14e8c,
	BNXT_ULP_CLASS_HID_134dc = 0x134dc,
	BNXT_ULP_CLASS_HID_1209e = 0x1209e,
	BNXT_ULP_CLASS_HID_170bc = 0x170bc,
	BNXT_ULP_CLASS_HID_16b7e = 0x16b7e,
	BNXT_ULP_CLASS_HID_119ae = 0x119ae,
	BNXT_ULP_CLASS_HID_1146a = 0x1146a,
	BNXT_ULP_CLASS_HID_14426 = 0x14426,
	BNXT_ULP_CLASS_HID_15046 = 0x15046,
	BNXT_ULP_CLASS_HID_1263a = 0x1263a,
	BNXT_ULP_CLASS_HID_1325a = 0x1325a,
	BNXT_ULP_CLASS_HID_16216 = 0x16216,
	BNXT_ULP_CLASS_HID_17e36 = 0x17e36,
	BNXT_ULP_CLASS_HID_1133e = 0x1133e,
	BNXT_ULP_CLASS_HID_10ffa = 0x10ffa,
	BNXT_ULP_CLASS_HID_15f1a = 0x15f1a,
	BNXT_ULP_CLASS_HID_14bee = 0x14bee,
	BNXT_ULP_CLASS_HID_1312a = 0x1312a,
	BNXT_ULP_CLASS_HID_12dea = 0x12dea,
	BNXT_ULP_CLASS_HID_17d1e = 0x17d1e,
	BNXT_ULP_CLASS_HID_169de = 0x169de,
	BNXT_ULP_CLASS_HID_11ee6 = 0x11ee6,
	BNXT_ULP_CLASS_HID_10abe = 0x10abe,
	BNXT_ULP_CLASS_HID_15ade = 0x15ade,
	BNXT_ULP_CLASS_HID_1569e = 0x1569e,
	BNXT_ULP_CLASS_HID_13cee = 0x13cee,
	BNXT_ULP_CLASS_HID_128ae = 0x128ae,
	BNXT_ULP_CLASS_HID_1676e = 0x1676e,
	BNXT_ULP_CLASS_HID_1748e = 0x1748e,
	BNXT_ULP_CLASS_HID_1098e = 0x1098e,
	BNXT_ULP_CLASS_HID_1044e = 0x1044e,
	BNXT_ULP_CLASS_HID_1546e = 0x1546e,
	BNXT_ULP_CLASS_HID_1402e = 0x1402e,
	BNXT_ULP_CLASS_HID_1367e = 0x1367e,
	BNXT_ULP_CLASS_HID_1223e = 0x1223e,
	BNXT_ULP_CLASS_HID_1725e = 0x1725e,
	BNXT_ULP_CLASS_HID_16e1e = 0x16e1e,
	BNXT_ULP_CLASS_HID_1172f = 0x1172f,
	BNXT_ULP_CLASS_HID_103ed = 0x103ed,
	BNXT_ULP_CLASS_HID_1530b = 0x1530b,
	BNXT_ULP_CLASS_HID_14fc9 = 0x14fc9,
	BNXT_ULP_CLASS_HID_1351d = 0x1351d,
	BNXT_ULP_CLASS_HID_121db = 0x121db,
	BNXT_ULP_CLASS_HID_171f9 = 0x171f9,
	BNXT_ULP_CLASS_HID_16db7 = 0x16db7,
	BNXT_ULP_CLASS_HID_102bf = 0x102bf,
	BNXT_ULP_CLASS_HID_11edf = 0x11edf,
	BNXT_ULP_CLASS_HID_14e9b = 0x14e9b,
	BNXT_ULP_CLASS_HID_15abb = 0x15abb,
	BNXT_ULP_CLASS_HID_120ad = 0x120ad,
	BNXT_ULP_CLASS_HID_13ccd = 0x13ccd,
	BNXT_ULP_CLASS_HID_16c89 = 0x16c89,
	BNXT_ULP_CLASS_HID_1675f = 0x1675f,
	BNXT_ULP_CLASS_HID_10c67 = 0x10c67,
	BNXT_ULP_CLASS_HID_11987 = 0x11987,
	BNXT_ULP_CLASS_HID_1485f = 0x1485f,
	BNXT_ULP_CLASS_HID_1441d = 0x1441d,
	BNXT_ULP_CLASS_HID_12a55 = 0x12a55,
	BNXT_ULP_CLASS_HID_1262f = 0x1262f,
	BNXT_ULP_CLASS_HID_1764d = 0x1764d,
	BNXT_ULP_CLASS_HID_1620f = 0x1620f,
	BNXT_ULP_CLASS_HID_1070f = 0x1070f,
	BNXT_ULP_CLASS_HID_1132f = 0x1132f,
	BNXT_ULP_CLASS_HID_143ef = 0x143ef,
	BNXT_ULP_CLASS_HID_15f0f = 0x15f0f,
	BNXT_ULP_CLASS_HID_125fd = 0x125fd,
	BNXT_ULP_CLASS_HID_1311d = 0x1311d,
	BNXT_ULP_CLASS_HID_161dd = 0x161dd,
	BNXT_ULP_CLASS_HID_17dfd = 0x17dfd,
	BNXT_ULP_CLASS_HID_10acb = 0x10acb,
	BNXT_ULP_CLASS_HID_10687 = 0x10687,
	BNXT_ULP_CLASS_HID_156a7 = 0x156a7,
	BNXT_ULP_CLASS_HID_14163 = 0x14163,
	BNXT_ULP_CLASS_HID_128b7 = 0x128b7,
	BNXT_ULP_CLASS_HID_12377 = 0x12377,
	BNXT_ULP_CLASS_HID_17493 = 0x17493,
	BNXT_ULP_CLASS_HID_16f53 = 0x16f53,
	BNXT_ULP_CLASS_HID_1045b = 0x1045b,
	BNXT_ULP_CLASS_HID_1107b = 0x1107b,
	BNXT_ULP_CLASS_HID_1404f = 0x1404f,
	BNXT_ULP_CLASS_HID_15c6f = 0x15c6f,
	BNXT_ULP_CLASS_HID_1225f = 0x1225f,
	BNXT_ULP_CLASS_HID_13e7f = 0x13e7f,
	BNXT_ULP_CLASS_HID_16e3b = 0x16e3b,
	BNXT_ULP_CLASS_HID_17a5b = 0x17a5b,
	BNXT_ULP_CLASS_HID_10f1f = 0x10f1f,
	BNXT_ULP_CLASS_HID_11b3f = 0x11b3f,
	BNXT_ULP_CLASS_HID_14bff = 0x14bff,
	BNXT_ULP_CLASS_HID_147b7 = 0x147b7,
	BNXT_ULP_CLASS_HID_12d0f = 0x12d0f,
	BNXT_ULP_CLASS_HID_1392f = 0x1392f,
	BNXT_ULP_CLASS_HID_169e7 = 0x169e7,
	BNXT_ULP_CLASS_HID_165a7 = 0x165a7,
	BNXT_ULP_CLASS_HID_11a0f = 0x11a0f,
	BNXT_ULP_CLASS_HID_116cf = 0x116cf,
	BNXT_ULP_CLASS_HID_1468f = 0x1468f,
	BNXT_ULP_CLASS_HID_152af = 0x152af,
	BNXT_ULP_CLASS_HID_138ff = 0x138ff,
	BNXT_ULP_CLASS_HID_134bf = 0x134bf,
	BNXT_ULP_CLASS_HID_1648f = 0x1648f,
	BNXT_ULP_CLASS_HID_170af = 0x170af,
	BNXT_ULP_CLASS_HID_40c38 = 0x40c38,
	BNXT_ULP_CLASS_HID_41c04 = 0x41c04,
	BNXT_ULP_CLASS_HID_51c48 = 0x51c48,
	BNXT_ULP_CLASS_HID_50332 = 0x50332,
	BNXT_ULP_CLASS_HID_48400 = 0x48400,
	BNXT_ULP_CLASS_HID_48bea = 0x48bea,
	BNXT_ULP_CLASS_HID_58b3e = 0x58b3e,
	BNXT_ULP_CLASS_HID_59b7a = 0x59b7a,
	BNXT_ULP_CLASS_HID_417dc = 0x417dc,
	BNXT_ULP_CLASS_HID_40746 = 0x40746,
	BNXT_ULP_CLASS_HID_5068a = 0x5068a,
	BNXT_ULP_CLASS_HID_516d6 = 0x516d6,
	BNXT_ULP_CLASS_HID_48f42 = 0x48f42,
	BNXT_ULP_CLASS_HID_49e8e = 0x49e8e,
	BNXT_ULP_CLASS_HID_59ed2 = 0x59ed2,
	BNXT_ULP_CLASS_HID_58d9c = 0x58d9c,
	BNXT_ULP_CLASS_HID_41a4a = 0x41a4a,
	BNXT_ULP_CLASS_HID_40924 = 0x40924,
	BNXT_ULP_CLASS_HID_50968 = 0x50968,
	BNXT_ULP_CLASS_HID_51944 = 0x51944,
	BNXT_ULP_CLASS_HID_49182 = 0x49182,
	BNXT_ULP_CLASS_HID_4816c = 0x4816c,
	BNXT_ULP_CLASS_HID_58140 = 0x58140,
	BNXT_ULP_CLASS_HID_5908c = 0x5908c,
	BNXT_ULP_CLASS_HID_40c8c = 0x40c8c,
	BNXT_ULP_CLASS_HID_41cc8 = 0x41cc8,
	BNXT_ULP_CLASS_HID_51c0c = 0x51c0c,
	BNXT_ULP_CLASS_HID_50386 = 0x50386,
	BNXT_ULP_CLASS_HID_484c4 = 0x484c4,
	BNXT_ULP_CLASS_HID_48b8e = 0x48b8e,
	BNXT_ULP_CLASS_HID_58b82 = 0x58b82,
	BNXT_ULP_CLASS_HID_59bce = 0x59bce,
	BNXT_ULP_CLASS_HID_10a54 = 0x10a54,
	BNXT_ULP_CLASS_HID_11e74 = 0x11e74,
	BNXT_ULP_CLASS_HID_14e48 = 0x14e48,
	BNXT_ULP_CLASS_HID_15268 = 0x15268,
	BNXT_ULP_CLASS_HID_1285a = 0x1285a,
	BNXT_ULP_CLASS_HID_13c7a = 0x13c7a,
	BNXT_ULP_CLASS_HID_163be = 0x163be,
	BNXT_ULP_CLASS_HID_1705e = 0x1705e,
	BNXT_ULP_CLASS_HID_11d5e = 0x11d5e,
	BNXT_ULP_CLASS_HID_1009c = 0x1009c,
	BNXT_ULP_CLASS_HID_150ba = 0x150ba,
	BNXT_ULP_CLASS_HID_144f8 = 0x144f8,
	BNXT_ULP_CLASS_HID_1334c = 0x1334c,
	BNXT_ULP_CLASS_HID_1268a = 0x1268a,
	BNXT_ULP_CLASS_HID_176a8 = 0x176a8,
	BNXT_ULP_CLASS_HID_17aee = 0x17aee,
	BNXT_ULP_CLASS_HID_11782 = 0x11782,
	BNXT_ULP_CLASS_HID_11bc0 = 0x11bc0,
	BNXT_ULP_CLASS_HID_14b00 = 0x14b00,
	BNXT_ULP_CLASS_HID_15f20 = 0x15f20,
	BNXT_ULP_CLASS_HID_135f0 = 0x135f0,
	BNXT_ULP_CLASS_HID_13932 = 0x13932,
	BNXT_ULP_CLASS_HID_1690a = 0x1690a,
	BNXT_ULP_CLASS_HID_17d2a = 0x17d2a,
	BNXT_ULP_CLASS_HID_11a2a = 0x11a2a,
	BNXT_ULP_CLASS_HID_10e68 = 0x10e68,
	BNXT_ULP_CLASS_HID_15e0a = 0x15e0a,
	BNXT_ULP_CLASS_HID_14248 = 0x14248,
	BNXT_ULP_CLASS_HID_13818 = 0x13818,
	BNXT_ULP_CLASS_HID_12c5a = 0x12c5a,
	BNXT_ULP_CLASS_HID_17c78 = 0x17c78,
	BNXT_ULP_CLASS_HID_167ba = 0x167ba,
	BNXT_ULP_CLASS_HID_1f91 = 0x1f91,
	BNXT_ULP_CLASS_HID_0763 = 0x0763,
	BNXT_ULP_CLASS_HID_0f7b = 0x0f7b,
	BNXT_ULP_CLASS_HID_16af = 0x16af,
	BNXT_ULP_CLASS_HID_1daf = 0x1daf,
	BNXT_ULP_CLASS_HID_0539 = 0x0539,
	BNXT_ULP_CLASS_HID_01ed = 0x01ed,
	BNXT_ULP_CLASS_HID_097f = 0x097f,
	BNXT_ULP_CLASS_HID_81ab8 = 0x81ab8,
	BNXT_ULP_CLASS_HID_8020e = 0x8020e,
	BNXT_ULP_CLASS_HID_815d8 = 0x815d8,
	BNXT_ULP_CLASS_HID_81cae = 0x81cae,
	BNXT_ULP_CLASS_HID_810a8 = 0x810a8,
	BNXT_ULP_CLASS_HID_8183e = 0x8183e,
	BNXT_ULP_CLASS_HID_8036a = 0x8036a,
	BNXT_ULP_CLASS_HID_80af8 = 0x80af8,
	BNXT_ULP_CLASS_HID_206fe = 0x206fe,
	BNXT_ULP_CLASS_HID_20e4c = 0x20e4c,
	BNXT_ULP_CLASS_HID_2111e = 0x2111e,
	BNXT_ULP_CLASS_HID_218ec = 0x218ec,
	BNXT_ULP_CLASS_HID_60472 = 0x60472,
	BNXT_ULP_CLASS_HID_603c0 = 0x603c0,
	BNXT_ULP_CLASS_HID_61692 = 0x61692,
	BNXT_ULP_CLASS_HID_61e60 = 0x61e60,
	BNXT_ULP_CLASS_HID_1f81 = 0x1f81,
	BNXT_ULP_CLASS_HID_0773 = 0x0773,
	BNXT_ULP_CLASS_HID_0f6b = 0x0f6b,
	BNXT_ULP_CLASS_HID_16bf = 0x16bf,
	BNXT_ULP_CLASS_HID_03cf = 0x03cf,
	BNXT_ULP_CLASS_HID_0ab1 = 0x0ab1,
	BNXT_ULP_CLASS_HID_130b = 0x130b,
	BNXT_ULP_CLASS_HID_1afd = 0x1afd,
	BNXT_ULP_CLASS_HID_1591 = 0x1591,
	BNXT_ULP_CLASS_HID_1d03 = 0x1d03,
	BNXT_ULP_CLASS_HID_057b = 0x057b,
	BNXT_ULP_CLASS_HID_0ced = 0x0ced,
	BNXT_ULP_CLASS_HID_19df = 0x19df,
	BNXT_ULP_CLASS_HID_0141 = 0x0141,
	BNXT_ULP_CLASS_HID_08b9 = 0x08b9,
	BNXT_ULP_CLASS_HID_108d = 0x108d,
	BNXT_ULP_CLASS_HID_1dbf = 0x1dbf,
	BNXT_ULP_CLASS_HID_0529 = 0x0529,
	BNXT_ULP_CLASS_HID_01fd = 0x01fd,
	BNXT_ULP_CLASS_HID_096f = 0x096f,
	BNXT_ULP_CLASS_HID_810b7 = 0x810b7,
	BNXT_ULP_CLASS_HID_81821 = 0x81821,
	BNXT_ULP_CLASS_HID_804f5 = 0x804f5,
	BNXT_ULP_CLASS_HID_80c67 = 0x80c67,
	BNXT_ULP_CLASS_HID_41333 = 0x41333,
	BNXT_ULP_CLASS_HID_41aad = 0x41aad,
	BNXT_ULP_CLASS_HID_40771 = 0x40771,
	BNXT_ULP_CLASS_HID_40ee3 = 0x40ee3,
	BNXT_ULP_CLASS_HID_c16cb = 0xc16cb,
	BNXT_ULP_CLASS_HID_c1da5 = 0xc1da5,
	BNXT_ULP_CLASS_HID_c1a09 = 0xc1a09,
	BNXT_ULP_CLASS_HID_c01fb = 0xc01fb,
	BNXT_ULP_CLASS_HID_1ff1 = 0x1ff1,
	BNXT_ULP_CLASS_HID_0703 = 0x0703,
	BNXT_ULP_CLASS_HID_0f1b = 0x0f1b,
	BNXT_ULP_CLASS_HID_16cf = 0x16cf,
	BNXT_ULP_CLASS_HID_03bf = 0x03bf,
	BNXT_ULP_CLASS_HID_0ac1 = 0x0ac1,
	BNXT_ULP_CLASS_HID_137b = 0x137b,
	BNXT_ULP_CLASS_HID_1a8d = 0x1a8d,
	BNXT_ULP_CLASS_HID_15e1 = 0x15e1,
	BNXT_ULP_CLASS_HID_1d73 = 0x1d73,
	BNXT_ULP_CLASS_HID_050b = 0x050b,
	BNXT_ULP_CLASS_HID_0c9d = 0x0c9d,
	BNXT_ULP_CLASS_HID_19af = 0x19af,
	BNXT_ULP_CLASS_HID_0131 = 0x0131,
	BNXT_ULP_CLASS_HID_08c9 = 0x08c9,
	BNXT_ULP_CLASS_HID_10fd = 0x10fd,
	BNXT_ULP_CLASS_HID_1dcf = 0x1dcf,
	BNXT_ULP_CLASS_HID_0559 = 0x0559,
	BNXT_ULP_CLASS_HID_018d = 0x018d,
	BNXT_ULP_CLASS_HID_091f = 0x091f,
	BNXT_ULP_CLASS_HID_810c7 = 0x810c7,
	BNXT_ULP_CLASS_HID_81851 = 0x81851,
	BNXT_ULP_CLASS_HID_80485 = 0x80485,
	BNXT_ULP_CLASS_HID_80c17 = 0x80c17,
	BNXT_ULP_CLASS_HID_41343 = 0x41343,
	BNXT_ULP_CLASS_HID_41add = 0x41add,
	BNXT_ULP_CLASS_HID_40701 = 0x40701,
	BNXT_ULP_CLASS_HID_40e93 = 0x40e93,
	BNXT_ULP_CLASS_HID_c16bb = 0xc16bb,
	BNXT_ULP_CLASS_HID_c1dd5 = 0xc1dd5,
	BNXT_ULP_CLASS_HID_c1a79 = 0xc1a79,
	BNXT_ULP_CLASS_HID_c018b = 0xc018b,
	BNXT_ULP_CLASS_HID_81aa8 = 0x81aa8,
	BNXT_ULP_CLASS_HID_8021e = 0x8021e,
	BNXT_ULP_CLASS_HID_815c8 = 0x815c8,
	BNXT_ULP_CLASS_HID_81cbe = 0x81cbe,
	BNXT_ULP_CLASS_HID_810b8 = 0x810b8,
	BNXT_ULP_CLASS_HID_8182e = 0x8182e,
	BNXT_ULP_CLASS_HID_8037a = 0x8037a,
	BNXT_ULP_CLASS_HID_80ae8 = 0x80ae8,
	BNXT_ULP_CLASS_HID_c1834 = 0xc1834,
	BNXT_ULP_CLASS_HID_c079a = 0xc079a,
	BNXT_ULP_CLASS_HID_c0af6 = 0xc0af6,
	BNXT_ULP_CLASS_HID_c123a = 0xc123a,
	BNXT_ULP_CLASS_HID_c16c4 = 0xc16c4,
	BNXT_ULP_CLASS_HID_c1daa = 0xc1daa,
	BNXT_ULP_CLASS_HID_c0086 = 0xc0086,
	BNXT_ULP_CLASS_HID_c0874 = 0xc0874,
	BNXT_ULP_CLASS_HID_a19ea = 0xa19ea,
	BNXT_ULP_CLASS_HID_a0158 = 0xa0158,
	BNXT_ULP_CLASS_HID_a0bb4 = 0xa0bb4,
	BNXT_ULP_CLASS_HID_a13f8 = 0xa13f8,
	BNXT_ULP_CLASS_HID_a17fa = 0xa17fa,
	BNXT_ULP_CLASS_HID_a1f68 = 0xa1f68,
	BNXT_ULP_CLASS_HID_a0244 = 0xa0244,
	BNXT_ULP_CLASS_HID_a092a = 0xa092a,
	BNXT_ULP_CLASS_HID_e1f76 = 0xe1f76,
	BNXT_ULP_CLASS_HID_e06e4 = 0xe06e4,
	BNXT_ULP_CLASS_HID_e0930 = 0xe0930,
	BNXT_ULP_CLASS_HID_e1104 = 0xe1104,
	BNXT_ULP_CLASS_HID_e1506 = 0xe1506,
	BNXT_ULP_CLASS_HID_e1cf4 = 0xe1cf4,
	BNXT_ULP_CLASS_HID_e07c0 = 0xe07c0,
	BNXT_ULP_CLASS_HID_e0eb6 = 0xe0eb6,
	BNXT_ULP_CLASS_HID_206ee = 0x206ee,
	BNXT_ULP_CLASS_HID_20e5c = 0x20e5c,
	BNXT_ULP_CLASS_HID_2110e = 0x2110e,
	BNXT_ULP_CLASS_HID_218fc = 0x218fc,
	BNXT_ULP_CLASS_HID_60462 = 0x60462,
	BNXT_ULP_CLASS_HID_603d0 = 0x603d0,
	BNXT_ULP_CLASS_HID_61682 = 0x61682,
	BNXT_ULP_CLASS_HID_61e70 = 0x61e70,
	BNXT_ULP_CLASS_HID_3167e = 0x3167e,
	BNXT_ULP_CLASS_HID_31dec = 0x31dec,
	BNXT_ULP_CLASS_HID_30030 = 0x30030,
	BNXT_ULP_CLASS_HID_30fae = 0x30fae,
	BNXT_ULP_CLASS_HID_70b14 = 0x70b14,
	BNXT_ULP_CLASS_HID_71360 = 0x71360,
	BNXT_ULP_CLASS_HID_705b4 = 0x705b4,
	BNXT_ULP_CLASS_HID_70d22 = 0x70d22,
	BNXT_ULP_CLASS_HID_29e26 = 0x29e26,
	BNXT_ULP_CLASS_HID_28594 = 0x28594,
	BNXT_ULP_CLASS_HID_288f8 = 0x288f8,
	BNXT_ULP_CLASS_HID_29034 = 0x29034,
	BNXT_ULP_CLASS_HID_693ba = 0x693ba,
	BNXT_ULP_CLASS_HID_69b28 = 0x69b28,
	BNXT_ULP_CLASS_HID_68e7c = 0x68e7c,
	BNXT_ULP_CLASS_HID_69648 = 0x69648,
	BNXT_ULP_CLASS_HID_38de8 = 0x38de8,
	BNXT_ULP_CLASS_HID_39524 = 0x39524,
	BNXT_ULP_CLASS_HID_39808 = 0x39808,
	BNXT_ULP_CLASS_HID_387e6 = 0x387e6,
	BNXT_ULP_CLASS_HID_7836c = 0x7836c,
	BNXT_ULP_CLASS_HID_78ada = 0x78ada,
	BNXT_ULP_CLASS_HID_79d8c = 0x79d8c,
	BNXT_ULP_CLASS_HID_7857a = 0x7857a,
	BNXT_ULP_CLASS_HID_81ad8 = 0x81ad8,
	BNXT_ULP_CLASS_HID_8026e = 0x8026e,
	BNXT_ULP_CLASS_HID_815b8 = 0x815b8,
	BNXT_ULP_CLASS_HID_81cce = 0x81cce,
	BNXT_ULP_CLASS_HID_810c8 = 0x810c8,
	BNXT_ULP_CLASS_HID_8185e = 0x8185e,
	BNXT_ULP_CLASS_HID_8030a = 0x8030a,
	BNXT_ULP_CLASS_HID_80a98 = 0x80a98,
	BNXT_ULP_CLASS_HID_c1844 = 0xc1844,
	BNXT_ULP_CLASS_HID_c07ea = 0xc07ea,
	BNXT_ULP_CLASS_HID_c0a86 = 0xc0a86,
	BNXT_ULP_CLASS_HID_c124a = 0xc124a,
	BNXT_ULP_CLASS_HID_c16b4 = 0xc16b4,
	BNXT_ULP_CLASS_HID_c1dda = 0xc1dda,
	BNXT_ULP_CLASS_HID_c00f6 = 0xc00f6,
	BNXT_ULP_CLASS_HID_c0804 = 0xc0804,
	BNXT_ULP_CLASS_HID_a199a = 0xa199a,
	BNXT_ULP_CLASS_HID_a0128 = 0xa0128,
	BNXT_ULP_CLASS_HID_a0bc4 = 0xa0bc4,
	BNXT_ULP_CLASS_HID_a1388 = 0xa1388,
	BNXT_ULP_CLASS_HID_a178a = 0xa178a,
	BNXT_ULP_CLASS_HID_a1f18 = 0xa1f18,
	BNXT_ULP_CLASS_HID_a0234 = 0xa0234,
	BNXT_ULP_CLASS_HID_a095a = 0xa095a,
	BNXT_ULP_CLASS_HID_e1f06 = 0xe1f06,
	BNXT_ULP_CLASS_HID_e0694 = 0xe0694,
	BNXT_ULP_CLASS_HID_e0940 = 0xe0940,
	BNXT_ULP_CLASS_HID_e1174 = 0xe1174,
	BNXT_ULP_CLASS_HID_e1576 = 0xe1576,
	BNXT_ULP_CLASS_HID_e1c84 = 0xe1c84,
	BNXT_ULP_CLASS_HID_e07b0 = 0xe07b0,
	BNXT_ULP_CLASS_HID_e0ec6 = 0xe0ec6,
	BNXT_ULP_CLASS_HID_2069e = 0x2069e,
	BNXT_ULP_CLASS_HID_20e2c = 0x20e2c,
	BNXT_ULP_CLASS_HID_2117e = 0x2117e,
	BNXT_ULP_CLASS_HID_2188c = 0x2188c,
	BNXT_ULP_CLASS_HID_60412 = 0x60412,
	BNXT_ULP_CLASS_HID_603a0 = 0x603a0,
	BNXT_ULP_CLASS_HID_616f2 = 0x616f2,
	BNXT_ULP_CLASS_HID_61e00 = 0x61e00,
	BNXT_ULP_CLASS_HID_3160e = 0x3160e,
	BNXT_ULP_CLASS_HID_31d9c = 0x31d9c,
	BNXT_ULP_CLASS_HID_30040 = 0x30040,
	BNXT_ULP_CLASS_HID_30fde = 0x30fde,
	BNXT_ULP_CLASS_HID_70b64 = 0x70b64,
	BNXT_ULP_CLASS_HID_71310 = 0x71310,
	BNXT_ULP_CLASS_HID_705c4 = 0x705c4,
	BNXT_ULP_CLASS_HID_70d52 = 0x70d52,
	BNXT_ULP_CLASS_HID_29e56 = 0x29e56,
	BNXT_ULP_CLASS_HID_285e4 = 0x285e4,
	BNXT_ULP_CLASS_HID_28888 = 0x28888,
	BNXT_ULP_CLASS_HID_29044 = 0x29044,
	BNXT_ULP_CLASS_HID_693ca = 0x693ca,
	BNXT_ULP_CLASS_HID_69b58 = 0x69b58,
	BNXT_ULP_CLASS_HID_68e0c = 0x68e0c,
	BNXT_ULP_CLASS_HID_69638 = 0x69638,
	BNXT_ULP_CLASS_HID_38d98 = 0x38d98,
	BNXT_ULP_CLASS_HID_39554 = 0x39554,
	BNXT_ULP_CLASS_HID_39878 = 0x39878,
	BNXT_ULP_CLASS_HID_38796 = 0x38796,
	BNXT_ULP_CLASS_HID_7831c = 0x7831c,
	BNXT_ULP_CLASS_HID_78aaa = 0x78aaa,
	BNXT_ULP_CLASS_HID_79dfc = 0x79dfc,
	BNXT_ULP_CLASS_HID_7850a = 0x7850a,
	BNXT_ULP_CLASS_HID_03b7 = 0x03b7,
	BNXT_ULP_CLASS_HID_13f3 = 0x13f3,
	BNXT_ULP_CLASS_HID_0255 = 0x0255,
	BNXT_ULP_CLASS_HID_1675 = 0x1675,
	BNXT_ULP_CLASS_HID_80f52 = 0x80f52,
	BNXT_ULP_CLASS_HID_819f2 = 0x819f2,
	BNXT_ULP_CLASS_HID_80542 = 0x80542,
	BNXT_ULP_CLASS_HID_817e2 = 0x817e2,
	BNXT_ULP_CLASS_HID_20a98 = 0x20a98,
	BNXT_ULP_CLASS_HID_20538 = 0x20538,
	BNXT_ULP_CLASS_HID_6081c = 0x6081c,
	BNXT_ULP_CLASS_HID_61abc = 0x61abc,
	BNXT_ULP_CLASS_HID_03a7 = 0x03a7,
	BNXT_ULP_CLASS_HID_13e3 = 0x13e3,
	BNXT_ULP_CLASS_HID_1047 = 0x1047,
	BNXT_ULP_CLASS_HID_0721 = 0x0721,
	BNXT_ULP_CLASS_HID_19b7 = 0x19b7,
	BNXT_ULP_CLASS_HID_0911 = 0x0911,
	BNXT_ULP_CLASS_HID_0df5 = 0x0df5,
	BNXT_ULP_CLASS_HID_1d31 = 0x1d31,
	BNXT_ULP_CLASS_HID_0245 = 0x0245,
	BNXT_ULP_CLASS_HID_1665 = 0x1665,
	BNXT_ULP_CLASS_HID_8055d = 0x8055d,
	BNXT_ULP_CLASS_HID_80893 = 0x80893,
	BNXT_ULP_CLASS_HID_407d9 = 0x407d9,
	BNXT_ULP_CLASS_HID_40b1f = 0x40b1f,
	BNXT_ULP_CLASS_HID_c1ad1 = 0xc1ad1,
	BNXT_ULP_CLASS_HID_c0e17 = 0xc0e17,
	BNXT_ULP_CLASS_HID_03d7 = 0x03d7,
	BNXT_ULP_CLASS_HID_1393 = 0x1393,
	BNXT_ULP_CLASS_HID_1037 = 0x1037,
	BNXT_ULP_CLASS_HID_0751 = 0x0751,
	BNXT_ULP_CLASS_HID_19c7 = 0x19c7,
	BNXT_ULP_CLASS_HID_0961 = 0x0961,
	BNXT_ULP_CLASS_HID_0d85 = 0x0d85,
	BNXT_ULP_CLASS_HID_1d41 = 0x1d41,
	BNXT_ULP_CLASS_HID_0235 = 0x0235,
	BNXT_ULP_CLASS_HID_1615 = 0x1615,
	BNXT_ULP_CLASS_HID_8052d = 0x8052d,
	BNXT_ULP_CLASS_HID_808e3 = 0x808e3,
	BNXT_ULP_CLASS_HID_407a9 = 0x407a9,
	BNXT_ULP_CLASS_HID_40b6f = 0x40b6f,
	BNXT_ULP_CLASS_HID_c1aa1 = 0xc1aa1,
	BNXT_ULP_CLASS_HID_c0e67 = 0xc0e67,
	BNXT_ULP_CLASS_HID_80f42 = 0x80f42,
	BNXT_ULP_CLASS_HID_819e2 = 0x819e2,
	BNXT_ULP_CLASS_HID_80552 = 0x80552,
	BNXT_ULP_CLASS_HID_817f2 = 0x817f2,
	BNXT_ULP_CLASS_HID_c0cce = 0xc0cce,
	BNXT_ULP_CLASS_HID_c1f6e = 0xc1f6e,
	BNXT_ULP_CLASS_HID_c1ade = 0xc1ade,
	BNXT_ULP_CLASS_HID_c157e = 0xc157e,
	BNXT_ULP_CLASS_HID_a0d8c = 0xa0d8c,
	BNXT_ULP_CLASS_HID_a182c = 0xa182c,
	BNXT_ULP_CLASS_HID_a1b9c = 0xa1b9c,
	BNXT_ULP_CLASS_HID_a163c = 0xa163c,
	BNXT_ULP_CLASS_HID_e0308 = 0xe0308,
	BNXT_ULP_CLASS_HID_e1da8 = 0xe1da8,
	BNXT_ULP_CLASS_HID_e1918 = 0xe1918,
	BNXT_ULP_CLASS_HID_e0bda = 0xe0bda,
	BNXT_ULP_CLASS_HID_20a88 = 0x20a88,
	BNXT_ULP_CLASS_HID_20528 = 0x20528,
	BNXT_ULP_CLASS_HID_6080c = 0x6080c,
	BNXT_ULP_CLASS_HID_61aac = 0x61aac,
	BNXT_ULP_CLASS_HID_31a18 = 0x31a18,
	BNXT_ULP_CLASS_HID_314b8 = 0x314b8,
	BNXT_ULP_CLASS_HID_71f9c = 0x71f9c,
	BNXT_ULP_CLASS_HID_70a5e = 0x70a5e,
	BNXT_ULP_CLASS_HID_282c0 = 0x282c0,
	BNXT_ULP_CLASS_HID_29d60 = 0x29d60,
	BNXT_ULP_CLASS_HID_68044 = 0x68044,
	BNXT_ULP_CLASS_HID_692e4 = 0x692e4,
	BNXT_ULP_CLASS_HID_39250 = 0x39250,
	BNXT_ULP_CLASS_HID_38c12 = 0x38c12,
	BNXT_ULP_CLASS_HID_797d4 = 0x797d4,
	BNXT_ULP_CLASS_HID_78196 = 0x78196,
	BNXT_ULP_CLASS_HID_80f32 = 0x80f32,
	BNXT_ULP_CLASS_HID_81992 = 0x81992,
	BNXT_ULP_CLASS_HID_80522 = 0x80522,
	BNXT_ULP_CLASS_HID_81782 = 0x81782,
	BNXT_ULP_CLASS_HID_c0cbe = 0xc0cbe,
	BNXT_ULP_CLASS_HID_c1f1e = 0xc1f1e,
	BNXT_ULP_CLASS_HID_c1aae = 0xc1aae,
	BNXT_ULP_CLASS_HID_c150e = 0xc150e,
	BNXT_ULP_CLASS_HID_a0dfc = 0xa0dfc,
	BNXT_ULP_CLASS_HID_a185c = 0xa185c,
	BNXT_ULP_CLASS_HID_a1bec = 0xa1bec,
	BNXT_ULP_CLASS_HID_a164c = 0xa164c,
	BNXT_ULP_CLASS_HID_e0378 = 0xe0378,
	BNXT_ULP_CLASS_HID_e1dd8 = 0xe1dd8,
	BNXT_ULP_CLASS_HID_e1968 = 0xe1968,
	BNXT_ULP_CLASS_HID_e0baa = 0xe0baa,
	BNXT_ULP_CLASS_HID_20af8 = 0x20af8,
	BNXT_ULP_CLASS_HID_20558 = 0x20558,
	BNXT_ULP_CLASS_HID_6087c = 0x6087c,
	BNXT_ULP_CLASS_HID_61adc = 0x61adc,
	BNXT_ULP_CLASS_HID_31a68 = 0x31a68,
	BNXT_ULP_CLASS_HID_314c8 = 0x314c8,
	BNXT_ULP_CLASS_HID_71fec = 0x71fec,
	BNXT_ULP_CLASS_HID_70a2e = 0x70a2e,
	BNXT_ULP_CLASS_HID_282b0 = 0x282b0,
	BNXT_ULP_CLASS_HID_29d10 = 0x29d10,
	BNXT_ULP_CLASS_HID_68034 = 0x68034,
	BNXT_ULP_CLASS_HID_69294 = 0x69294,
	BNXT_ULP_CLASS_HID_39220 = 0x39220,
	BNXT_ULP_CLASS_HID_38c62 = 0x38c62,
	BNXT_ULP_CLASS_HID_797a4 = 0x797a4,
	BNXT_ULP_CLASS_HID_781e6 = 0x781e6,
	BNXT_ULP_CLASS_HID_0f05 = 0x0f05,
	BNXT_ULP_CLASS_HID_0f09 = 0x0f09,
	BNXT_ULP_CLASS_HID_0f06 = 0x0f06,
	BNXT_ULP_CLASS_HID_19a6 = 0x19a6,
	BNXT_ULP_CLASS_HID_0f0a = 0x0f0a,
	BNXT_ULP_CLASS_HID_19aa = 0x19aa,
	BNXT_ULP_CLASS_HID_0f15 = 0x0f15,
	BNXT_ULP_CLASS_HID_0f19 = 0x0f19,
	BNXT_ULP_CLASS_HID_0f65 = 0x0f65,
	BNXT_ULP_CLASS_HID_0f69 = 0x0f69,
	BNXT_ULP_CLASS_HID_0f16 = 0x0f16,
	BNXT_ULP_CLASS_HID_19b6 = 0x19b6,
	BNXT_ULP_CLASS_HID_0f1a = 0x0f1a,
	BNXT_ULP_CLASS_HID_19ba = 0x19ba,
	BNXT_ULP_CLASS_HID_0f66 = 0x0f66,
	BNXT_ULP_CLASS_HID_19c6 = 0x19c6,
	BNXT_ULP_CLASS_HID_0f6a = 0x0f6a,
	BNXT_ULP_CLASS_HID_19ca = 0x19ca
};

enum bnxt_ulp_act_hid {
	BNXT_ULP_ACT_HID_0000 = 0x0000,
	BNXT_ULP_ACT_HID_0008 = 0x0008,
	BNXT_ULP_ACT_HID_2000 = 0x2000,
	BNXT_ULP_ACT_HID_1988 = 0x1988,
	BNXT_ULP_ACT_HID_0080 = 0x0080,
	BNXT_ULP_ACT_HID_3988 = 0x3988,
	BNXT_ULP_ACT_HID_1a08 = 0x1a08,
	BNXT_ULP_ACT_HID_0010 = 0x0010,
	BNXT_ULP_ACT_HID_0040 = 0x0040,
	BNXT_ULP_ACT_HID_0050 = 0x0050,
	BNXT_ULP_ACT_HID_0018 = 0x0018,
	BNXT_ULP_ACT_HID_2010 = 0x2010,
	BNXT_ULP_ACT_HID_1998 = 0x1998,
	BNXT_ULP_ACT_HID_0090 = 0x0090,
	BNXT_ULP_ACT_HID_3998 = 0x3998,
	BNXT_ULP_ACT_HID_1a18 = 0x1a18,
	BNXT_ULP_ACT_HID_32ea = 0x32ea,
	BNXT_ULP_ACT_HID_32f2 = 0x32f2,
	BNXT_ULP_ACT_HID_52ea = 0x52ea,
	BNXT_ULP_ACT_HID_4c72 = 0x4c72,
	BNXT_ULP_ACT_HID_336a = 0x336a,
	BNXT_ULP_ACT_HID_6c72 = 0x6c72,
	BNXT_ULP_ACT_HID_4cf2 = 0x4cf2,
	BNXT_ULP_ACT_HID_32fa = 0x32fa,
	BNXT_ULP_ACT_HID_3302 = 0x3302,
	BNXT_ULP_ACT_HID_52fa = 0x52fa,
	BNXT_ULP_ACT_HID_4c82 = 0x4c82,
	BNXT_ULP_ACT_HID_337a = 0x337a,
	BNXT_ULP_ACT_HID_6c82 = 0x6c82,
	BNXT_ULP_ACT_HID_4d02 = 0x4d02,
	BNXT_ULP_ACT_HID_0808 = 0x0808,
	BNXT_ULP_ACT_HID_1008 = 0x1008,
	BNXT_ULP_ACT_HID_1808 = 0x1808,
	BNXT_ULP_ACT_HID_0818 = 0x0818,
	BNXT_ULP_ACT_HID_1018 = 0x1018,
	BNXT_ULP_ACT_HID_1818 = 0x1818,
	BNXT_ULP_ACT_HID_0880 = 0x0880,
	BNXT_ULP_ACT_HID_1080 = 0x1080,
	BNXT_ULP_ACT_HID_1880 = 0x1880,
	BNXT_ULP_ACT_HID_0890 = 0x0890,
	BNXT_ULP_ACT_HID_1090 = 0x1090,
	BNXT_ULP_ACT_HID_1890 = 0x1890,
	BNXT_ULP_ACT_HID_3af2 = 0x3af2,
	BNXT_ULP_ACT_HID_42f2 = 0x42f2,
	BNXT_ULP_ACT_HID_4af2 = 0x4af2,
	BNXT_ULP_ACT_HID_3b02 = 0x3b02,
	BNXT_ULP_ACT_HID_4302 = 0x4302,
	BNXT_ULP_ACT_HID_4b02 = 0x4b02,
	BNXT_ULP_ACT_HID_3b6a = 0x3b6a,
	BNXT_ULP_ACT_HID_436a = 0x436a,
	BNXT_ULP_ACT_HID_4b6a = 0x4b6a,
	BNXT_ULP_ACT_HID_3b7a = 0x3b7a,
	BNXT_ULP_ACT_HID_437a = 0x437a,
	BNXT_ULP_ACT_HID_4b7a = 0x4b7a,
	BNXT_ULP_ACT_HID_640d = 0x640d,
	BNXT_ULP_ACT_HID_641d = 0x641d,
	BNXT_ULP_ACT_HID_071a = 0x071a,
	BNXT_ULP_ACT_HID_0800 = 0x0800,
	BNXT_ULP_ACT_HID_1000 = 0x1000,
	BNXT_ULP_ACT_HID_1800 = 0x1800,
	BNXT_ULP_ACT_HID_0810 = 0x0810,
	BNXT_ULP_ACT_HID_1010 = 0x1010,
	BNXT_ULP_ACT_HID_1810 = 0x1810,
	BNXT_ULP_ACT_HID_1110 = 0x1110,
	BNXT_ULP_ACT_HID_4420 = 0x4420,
	BNXT_ULP_ACT_HID_2220 = 0x2220,
	BNXT_ULP_ACT_HID_0c84 = 0x0c84,
	BNXT_ULP_ACT_HID_3f94 = 0x3f94,
	BNXT_ULP_ACT_HID_3330 = 0x3330,
	BNXT_ULP_ACT_HID_50a4 = 0x50a4,
	BNXT_ULP_ACT_HID_1910 = 0x1910,
	BNXT_ULP_ACT_HID_4c20 = 0x4c20,
	BNXT_ULP_ACT_HID_2a20 = 0x2a20,
	BNXT_ULP_ACT_HID_1484 = 0x1484,
	BNXT_ULP_ACT_HID_4794 = 0x4794,
	BNXT_ULP_ACT_HID_3b30 = 0x3b30,
	BNXT_ULP_ACT_HID_58a4 = 0x58a4,
	BNXT_ULP_ACT_HID_2110 = 0x2110,
	BNXT_ULP_ACT_HID_5420 = 0x5420,
	BNXT_ULP_ACT_HID_3220 = 0x3220,
	BNXT_ULP_ACT_HID_1c84 = 0x1c84,
	BNXT_ULP_ACT_HID_4f94 = 0x4f94,
	BNXT_ULP_ACT_HID_4330 = 0x4330,
	BNXT_ULP_ACT_HID_60a4 = 0x60a4,
	BNXT_ULP_ACT_HID_2910 = 0x2910,
	BNXT_ULP_ACT_HID_5c20 = 0x5c20,
	BNXT_ULP_ACT_HID_3a20 = 0x3a20,
	BNXT_ULP_ACT_HID_2484 = 0x2484,
	BNXT_ULP_ACT_HID_5794 = 0x5794,
	BNXT_ULP_ACT_HID_4b30 = 0x4b30,
	BNXT_ULP_ACT_HID_68a4 = 0x68a4,
	BNXT_ULP_ACT_HID_1120 = 0x1120,
	BNXT_ULP_ACT_HID_4430 = 0x4430,
	BNXT_ULP_ACT_HID_2230 = 0x2230,
	BNXT_ULP_ACT_HID_0c94 = 0x0c94,
	BNXT_ULP_ACT_HID_3fa4 = 0x3fa4,
	BNXT_ULP_ACT_HID_3340 = 0x3340,
	BNXT_ULP_ACT_HID_50b4 = 0x50b4,
	BNXT_ULP_ACT_HID_1920 = 0x1920,
	BNXT_ULP_ACT_HID_4c30 = 0x4c30,
	BNXT_ULP_ACT_HID_2a30 = 0x2a30,
	BNXT_ULP_ACT_HID_1494 = 0x1494,
	BNXT_ULP_ACT_HID_47a4 = 0x47a4,
	BNXT_ULP_ACT_HID_3b40 = 0x3b40,
	BNXT_ULP_ACT_HID_58b4 = 0x58b4,
	BNXT_ULP_ACT_HID_2120 = 0x2120,
	BNXT_ULP_ACT_HID_5430 = 0x5430,
	BNXT_ULP_ACT_HID_3230 = 0x3230,
	BNXT_ULP_ACT_HID_1c94 = 0x1c94,
	BNXT_ULP_ACT_HID_4fa4 = 0x4fa4,
	BNXT_ULP_ACT_HID_4340 = 0x4340,
	BNXT_ULP_ACT_HID_60b4 = 0x60b4,
	BNXT_ULP_ACT_HID_2920 = 0x2920,
	BNXT_ULP_ACT_HID_5c30 = 0x5c30,
	BNXT_ULP_ACT_HID_3a30 = 0x3a30,
	BNXT_ULP_ACT_HID_2494 = 0x2494,
	BNXT_ULP_ACT_HID_57a4 = 0x57a4,
	BNXT_ULP_ACT_HID_4b40 = 0x4b40,
	BNXT_ULP_ACT_HID_68b4 = 0x68b4,
	BNXT_ULP_ACT_HID_2a98 = 0x2a98,
	BNXT_ULP_ACT_HID_5da8 = 0x5da8,
	BNXT_ULP_ACT_HID_3ba8 = 0x3ba8,
	BNXT_ULP_ACT_HID_260c = 0x260c,
	BNXT_ULP_ACT_HID_591c = 0x591c,
	BNXT_ULP_ACT_HID_6a2c = 0x6a2c,
	BNXT_ULP_ACT_HID_2aa8 = 0x2aa8,
	BNXT_ULP_ACT_HID_5db8 = 0x5db8,
	BNXT_ULP_ACT_HID_3bb8 = 0x3bb8,
	BNXT_ULP_ACT_HID_261c = 0x261c,
	BNXT_ULP_ACT_HID_592c = 0x592c,
	BNXT_ULP_ACT_HID_6a3c = 0x6a3c,
	BNXT_ULP_ACT_HID_3298 = 0x3298,
	BNXT_ULP_ACT_HID_65a8 = 0x65a8,
	BNXT_ULP_ACT_HID_43a8 = 0x43a8,
	BNXT_ULP_ACT_HID_2e0c = 0x2e0c,
	BNXT_ULP_ACT_HID_611c = 0x611c,
	BNXT_ULP_ACT_HID_722c = 0x722c,
	BNXT_ULP_ACT_HID_32a8 = 0x32a8,
	BNXT_ULP_ACT_HID_65b8 = 0x65b8,
	BNXT_ULP_ACT_HID_43b8 = 0x43b8,
	BNXT_ULP_ACT_HID_2e1c = 0x2e1c,
	BNXT_ULP_ACT_HID_612c = 0x612c,
	BNXT_ULP_ACT_HID_723c = 0x723c,
	BNXT_ULP_ACT_HID_3a98 = 0x3a98,
	BNXT_ULP_ACT_HID_6da8 = 0x6da8,
	BNXT_ULP_ACT_HID_4ba8 = 0x4ba8,
	BNXT_ULP_ACT_HID_360c = 0x360c,
	BNXT_ULP_ACT_HID_691c = 0x691c,
	BNXT_ULP_ACT_HID_7a2c = 0x7a2c,
	BNXT_ULP_ACT_HID_3aa8 = 0x3aa8,
	BNXT_ULP_ACT_HID_6db8 = 0x6db8,
	BNXT_ULP_ACT_HID_4bb8 = 0x4bb8,
	BNXT_ULP_ACT_HID_361c = 0x361c,
	BNXT_ULP_ACT_HID_692c = 0x692c,
	BNXT_ULP_ACT_HID_7a3c = 0x7a3c,
	BNXT_ULP_ACT_HID_4298 = 0x4298,
	BNXT_ULP_ACT_HID_75a8 = 0x75a8,
	BNXT_ULP_ACT_HID_53a8 = 0x53a8,
	BNXT_ULP_ACT_HID_3e0c = 0x3e0c,
	BNXT_ULP_ACT_HID_711c = 0x711c,
	BNXT_ULP_ACT_HID_0670 = 0x0670,
	BNXT_ULP_ACT_HID_42a8 = 0x42a8,
	BNXT_ULP_ACT_HID_75b8 = 0x75b8,
	BNXT_ULP_ACT_HID_53b8 = 0x53b8,
	BNXT_ULP_ACT_HID_3e1c = 0x3e1c,
	BNXT_ULP_ACT_HID_712c = 0x712c,
	BNXT_ULP_ACT_HID_0680 = 0x0680,
	BNXT_ULP_ACT_HID_3aea = 0x3aea,
	BNXT_ULP_ACT_HID_42ea = 0x42ea,
	BNXT_ULP_ACT_HID_4aea = 0x4aea,
	BNXT_ULP_ACT_HID_3afa = 0x3afa,
	BNXT_ULP_ACT_HID_42fa = 0x42fa,
	BNXT_ULP_ACT_HID_4afa = 0x4afa,
	BNXT_ULP_ACT_HID_43fa = 0x43fa,
	BNXT_ULP_ACT_HID_770a = 0x770a,
	BNXT_ULP_ACT_HID_550a = 0x550a,
	BNXT_ULP_ACT_HID_3f6e = 0x3f6e,
	BNXT_ULP_ACT_HID_727e = 0x727e,
	BNXT_ULP_ACT_HID_661a = 0x661a,
	BNXT_ULP_ACT_HID_07d2 = 0x07d2,
	BNXT_ULP_ACT_HID_4bfa = 0x4bfa,
	BNXT_ULP_ACT_HID_034e = 0x034e,
	BNXT_ULP_ACT_HID_5d0a = 0x5d0a,
	BNXT_ULP_ACT_HID_476e = 0x476e,
	BNXT_ULP_ACT_HID_7a7e = 0x7a7e,
	BNXT_ULP_ACT_HID_6e1a = 0x6e1a,
	BNXT_ULP_ACT_HID_0fd2 = 0x0fd2,
	BNXT_ULP_ACT_HID_53fa = 0x53fa,
	BNXT_ULP_ACT_HID_0b4e = 0x0b4e,
	BNXT_ULP_ACT_HID_650a = 0x650a,
	BNXT_ULP_ACT_HID_4f6e = 0x4f6e,
	BNXT_ULP_ACT_HID_06c2 = 0x06c2,
	BNXT_ULP_ACT_HID_761a = 0x761a,
	BNXT_ULP_ACT_HID_17d2 = 0x17d2,
	BNXT_ULP_ACT_HID_5bfa = 0x5bfa,
	BNXT_ULP_ACT_HID_134e = 0x134e,
	BNXT_ULP_ACT_HID_6d0a = 0x6d0a,
	BNXT_ULP_ACT_HID_576e = 0x576e,
	BNXT_ULP_ACT_HID_0ec2 = 0x0ec2,
	BNXT_ULP_ACT_HID_025e = 0x025e,
	BNXT_ULP_ACT_HID_1fd2 = 0x1fd2,
	BNXT_ULP_ACT_HID_440a = 0x440a,
	BNXT_ULP_ACT_HID_771a = 0x771a,
	BNXT_ULP_ACT_HID_551a = 0x551a,
	BNXT_ULP_ACT_HID_3f7e = 0x3f7e,
	BNXT_ULP_ACT_HID_728e = 0x728e,
	BNXT_ULP_ACT_HID_662a = 0x662a,
	BNXT_ULP_ACT_HID_07e2 = 0x07e2,
	BNXT_ULP_ACT_HID_4c0a = 0x4c0a,
	BNXT_ULP_ACT_HID_035e = 0x035e,
	BNXT_ULP_ACT_HID_5d1a = 0x5d1a,
	BNXT_ULP_ACT_HID_477e = 0x477e,
	BNXT_ULP_ACT_HID_7a8e = 0x7a8e,
	BNXT_ULP_ACT_HID_6e2a = 0x6e2a,
	BNXT_ULP_ACT_HID_0fe2 = 0x0fe2,
	BNXT_ULP_ACT_HID_540a = 0x540a,
	BNXT_ULP_ACT_HID_0b5e = 0x0b5e,
	BNXT_ULP_ACT_HID_651a = 0x651a,
	BNXT_ULP_ACT_HID_4f7e = 0x4f7e,
	BNXT_ULP_ACT_HID_06d2 = 0x06d2,
	BNXT_ULP_ACT_HID_762a = 0x762a,
	BNXT_ULP_ACT_HID_17e2 = 0x17e2,
	BNXT_ULP_ACT_HID_5c0a = 0x5c0a,
	BNXT_ULP_ACT_HID_135e = 0x135e,
	BNXT_ULP_ACT_HID_6d1a = 0x6d1a,
	BNXT_ULP_ACT_HID_577e = 0x577e,
	BNXT_ULP_ACT_HID_0ed2 = 0x0ed2,
	BNXT_ULP_ACT_HID_026e = 0x026e,
	BNXT_ULP_ACT_HID_1fe2 = 0x1fe2,
	BNXT_ULP_ACT_HID_5d82 = 0x5d82,
	BNXT_ULP_ACT_HID_14d6 = 0x14d6,
	BNXT_ULP_ACT_HID_6e92 = 0x6e92,
	BNXT_ULP_ACT_HID_58f6 = 0x58f6,
	BNXT_ULP_ACT_HID_104a = 0x104a,
	BNXT_ULP_ACT_HID_215a = 0x215a,
	BNXT_ULP_ACT_HID_5d92 = 0x5d92,
	BNXT_ULP_ACT_HID_14e6 = 0x14e6,
	BNXT_ULP_ACT_HID_6ea2 = 0x6ea2,
	BNXT_ULP_ACT_HID_5906 = 0x5906,
	BNXT_ULP_ACT_HID_105a = 0x105a,
	BNXT_ULP_ACT_HID_216a = 0x216a,
	BNXT_ULP_ACT_HID_6582 = 0x6582,
	BNXT_ULP_ACT_HID_1cd6 = 0x1cd6,
	BNXT_ULP_ACT_HID_7692 = 0x7692,
	BNXT_ULP_ACT_HID_60f6 = 0x60f6,
	BNXT_ULP_ACT_HID_184a = 0x184a,
	BNXT_ULP_ACT_HID_295a = 0x295a,
	BNXT_ULP_ACT_HID_6592 = 0x6592,
	BNXT_ULP_ACT_HID_1ce6 = 0x1ce6,
	BNXT_ULP_ACT_HID_76a2 = 0x76a2,
	BNXT_ULP_ACT_HID_6106 = 0x6106,
	BNXT_ULP_ACT_HID_185a = 0x185a,
	BNXT_ULP_ACT_HID_296a = 0x296a,
	BNXT_ULP_ACT_HID_6d82 = 0x6d82,
	BNXT_ULP_ACT_HID_24d6 = 0x24d6,
	BNXT_ULP_ACT_HID_02d6 = 0x02d6,
	BNXT_ULP_ACT_HID_68f6 = 0x68f6,
	BNXT_ULP_ACT_HID_204a = 0x204a,
	BNXT_ULP_ACT_HID_315a = 0x315a,
	BNXT_ULP_ACT_HID_6d92 = 0x6d92,
	BNXT_ULP_ACT_HID_24e6 = 0x24e6,
	BNXT_ULP_ACT_HID_02e6 = 0x02e6,
	BNXT_ULP_ACT_HID_6906 = 0x6906,
	BNXT_ULP_ACT_HID_205a = 0x205a,
	BNXT_ULP_ACT_HID_316a = 0x316a,
	BNXT_ULP_ACT_HID_7582 = 0x7582,
	BNXT_ULP_ACT_HID_2cd6 = 0x2cd6,
	BNXT_ULP_ACT_HID_0ad6 = 0x0ad6,
	BNXT_ULP_ACT_HID_70f6 = 0x70f6,
	BNXT_ULP_ACT_HID_284a = 0x284a,
	BNXT_ULP_ACT_HID_395a = 0x395a,
	BNXT_ULP_ACT_HID_7592 = 0x7592,
	BNXT_ULP_ACT_HID_2ce6 = 0x2ce6,
	BNXT_ULP_ACT_HID_0ae6 = 0x0ae6,
	BNXT_ULP_ACT_HID_7106 = 0x7106,
	BNXT_ULP_ACT_HID_285a = 0x285a,
	BNXT_ULP_ACT_HID_396a = 0x396a,
	BNXT_ULP_ACT_HID_0020 = 0x0020,
	BNXT_ULP_ACT_HID_0030 = 0x0030,
	BNXT_ULP_ACT_HID_65d4 = 0x65d4,
	BNXT_ULP_ACT_HID_65e4 = 0x65e4,
	BNXT_ULP_ACT_HID_330a = 0x330a,
	BNXT_ULP_ACT_HID_331a = 0x331a,
	BNXT_ULP_ACT_HID_1cfe = 0x1cfe,
	BNXT_ULP_ACT_HID_1d0e = 0x1d0e,
	BNXT_ULP_ACT_HID_1474 = 0x1474,
	BNXT_ULP_ACT_HID_4838 = 0x4838,
	BNXT_ULP_ACT_HID_6458 = 0x6458,
	BNXT_ULP_ACT_HID_1c68 = 0x1c68,
	BNXT_ULP_ACT_HID_6c34 = 0x6c34,
	BNXT_ULP_ACT_HID_5d08 = 0x5d08,
	BNXT_ULP_ACT_HID_5d10 = 0x5d10,
	BNXT_ULP_ACT_HID_5d20 = 0x5d20,
	BNXT_ULP_ACT_HID_2e18 = 0x2e18,
	BNXT_ULP_ACT_HID_29d4 = 0x29d4,
	BNXT_ULP_ACT_HID_7690 = 0x7690,
	BNXT_ULP_ACT_HID_47a0 = 0x47a0,
	BNXT_ULP_ACT_HID_435c = 0x435c,
	BNXT_ULP_ACT_HID_5d18 = 0x5d18,
	BNXT_ULP_ACT_HID_2e28 = 0x2e28,
	BNXT_ULP_ACT_HID_29e4 = 0x29e4,
	BNXT_ULP_ACT_HID_76a0 = 0x76a0,
	BNXT_ULP_ACT_HID_47b0 = 0x47b0,
	BNXT_ULP_ACT_HID_436c = 0x436c,
	BNXT_ULP_ACT_HID_1436 = 0x1436,
	BNXT_ULP_ACT_HID_143e = 0x143e,
	BNXT_ULP_ACT_HID_144e = 0x144e,
	BNXT_ULP_ACT_HID_6102 = 0x6102,
	BNXT_ULP_ACT_HID_5cbe = 0x5cbe,
	BNXT_ULP_ACT_HID_2dbe = 0x2dbe,
	BNXT_ULP_ACT_HID_7a8a = 0x7a8a,
	BNXT_ULP_ACT_HID_7646 = 0x7646,
	BNXT_ULP_ACT_HID_1446 = 0x1446,
	BNXT_ULP_ACT_HID_6112 = 0x6112,
	BNXT_ULP_ACT_HID_5cce = 0x5cce,
	BNXT_ULP_ACT_HID_2dce = 0x2dce,
	BNXT_ULP_ACT_HID_7a9a = 0x7a9a,
	BNXT_ULP_ACT_HID_7656 = 0x7656,
	BNXT_ULP_ACT_HID_6508 = 0x6508,
	BNXT_ULP_ACT_HID_6d08 = 0x6d08,
	BNXT_ULP_ACT_HID_7508 = 0x7508,
	BNXT_ULP_ACT_HID_6518 = 0x6518,
	BNXT_ULP_ACT_HID_6d18 = 0x6d18,
	BNXT_ULP_ACT_HID_7518 = 0x7518,
	BNXT_ULP_ACT_HID_6e18 = 0x6e18,
	BNXT_ULP_ACT_HID_256c = 0x256c,
	BNXT_ULP_ACT_HID_036c = 0x036c,
	BNXT_ULP_ACT_HID_698c = 0x698c,
	BNXT_ULP_ACT_HID_20e0 = 0x20e0,
	BNXT_ULP_ACT_HID_31f0 = 0x31f0,
	BNXT_ULP_ACT_HID_7618 = 0x7618,
	BNXT_ULP_ACT_HID_2d6c = 0x2d6c,
	BNXT_ULP_ACT_HID_0b6c = 0x0b6c,
	BNXT_ULP_ACT_HID_718c = 0x718c,
	BNXT_ULP_ACT_HID_28e0 = 0x28e0,
	BNXT_ULP_ACT_HID_39f0 = 0x39f0,
	BNXT_ULP_ACT_HID_025c = 0x025c,
	BNXT_ULP_ACT_HID_356c = 0x356c,
	BNXT_ULP_ACT_HID_136c = 0x136c,
	BNXT_ULP_ACT_HID_798c = 0x798c,
	BNXT_ULP_ACT_HID_30e0 = 0x30e0,
	BNXT_ULP_ACT_HID_41f0 = 0x41f0,
	BNXT_ULP_ACT_HID_0a5c = 0x0a5c,
	BNXT_ULP_ACT_HID_3d6c = 0x3d6c,
	BNXT_ULP_ACT_HID_1b6c = 0x1b6c,
	BNXT_ULP_ACT_HID_05d0 = 0x05d0,
	BNXT_ULP_ACT_HID_38e0 = 0x38e0,
	BNXT_ULP_ACT_HID_49f0 = 0x49f0,
	BNXT_ULP_ACT_HID_6e28 = 0x6e28,
	BNXT_ULP_ACT_HID_257c = 0x257c,
	BNXT_ULP_ACT_HID_037c = 0x037c,
	BNXT_ULP_ACT_HID_699c = 0x699c,
	BNXT_ULP_ACT_HID_20f0 = 0x20f0,
	BNXT_ULP_ACT_HID_3200 = 0x3200,
	BNXT_ULP_ACT_HID_7628 = 0x7628,
	BNXT_ULP_ACT_HID_2d7c = 0x2d7c,
	BNXT_ULP_ACT_HID_0b7c = 0x0b7c,
	BNXT_ULP_ACT_HID_719c = 0x719c,
	BNXT_ULP_ACT_HID_28f0 = 0x28f0,
	BNXT_ULP_ACT_HID_3a00 = 0x3a00,
	BNXT_ULP_ACT_HID_026c = 0x026c,
	BNXT_ULP_ACT_HID_357c = 0x357c,
	BNXT_ULP_ACT_HID_137c = 0x137c,
	BNXT_ULP_ACT_HID_799c = 0x799c,
	BNXT_ULP_ACT_HID_30f0 = 0x30f0,
	BNXT_ULP_ACT_HID_4200 = 0x4200,
	BNXT_ULP_ACT_HID_0a6c = 0x0a6c,
	BNXT_ULP_ACT_HID_3d7c = 0x3d7c,
	BNXT_ULP_ACT_HID_1b7c = 0x1b7c,
	BNXT_ULP_ACT_HID_05e0 = 0x05e0,
	BNXT_ULP_ACT_HID_38f0 = 0x38f0,
	BNXT_ULP_ACT_HID_4a00 = 0x4a00,
	BNXT_ULP_ACT_HID_0be4 = 0x0be4,
	BNXT_ULP_ACT_HID_3ef4 = 0x3ef4,
	BNXT_ULP_ACT_HID_1cf4 = 0x1cf4,
	BNXT_ULP_ACT_HID_0758 = 0x0758,
	BNXT_ULP_ACT_HID_3a68 = 0x3a68,
	BNXT_ULP_ACT_HID_4b78 = 0x4b78,
	BNXT_ULP_ACT_HID_0bf4 = 0x0bf4,
	BNXT_ULP_ACT_HID_3f04 = 0x3f04,
	BNXT_ULP_ACT_HID_1d04 = 0x1d04,
	BNXT_ULP_ACT_HID_0768 = 0x0768,
	BNXT_ULP_ACT_HID_3a78 = 0x3a78,
	BNXT_ULP_ACT_HID_4b88 = 0x4b88,
	BNXT_ULP_ACT_HID_46f4 = 0x46f4,
	BNXT_ULP_ACT_HID_24f4 = 0x24f4,
	BNXT_ULP_ACT_HID_0f58 = 0x0f58,
	BNXT_ULP_ACT_HID_13e4 = 0x13e4,
	BNXT_ULP_ACT_HID_4268 = 0x4268,
	BNXT_ULP_ACT_HID_5378 = 0x5378,
	BNXT_ULP_ACT_HID_13f4 = 0x13f4,
	BNXT_ULP_ACT_HID_4704 = 0x4704,
	BNXT_ULP_ACT_HID_2504 = 0x2504,
	BNXT_ULP_ACT_HID_0f68 = 0x0f68,
	BNXT_ULP_ACT_HID_4278 = 0x4278,
	BNXT_ULP_ACT_HID_5388 = 0x5388,
	BNXT_ULP_ACT_HID_1be4 = 0x1be4,
	BNXT_ULP_ACT_HID_4ef4 = 0x4ef4,
	BNXT_ULP_ACT_HID_2cf4 = 0x2cf4,
	BNXT_ULP_ACT_HID_1758 = 0x1758,
	BNXT_ULP_ACT_HID_4a68 = 0x4a68,
	BNXT_ULP_ACT_HID_5b78 = 0x5b78,
	BNXT_ULP_ACT_HID_1bf4 = 0x1bf4,
	BNXT_ULP_ACT_HID_4f04 = 0x4f04,
	BNXT_ULP_ACT_HID_2d04 = 0x2d04,
	BNXT_ULP_ACT_HID_1768 = 0x1768,
	BNXT_ULP_ACT_HID_4a78 = 0x4a78,
	BNXT_ULP_ACT_HID_5b88 = 0x5b88,
	BNXT_ULP_ACT_HID_23e4 = 0x23e4,
	BNXT_ULP_ACT_HID_56f4 = 0x56f4,
	BNXT_ULP_ACT_HID_34f4 = 0x34f4,
	BNXT_ULP_ACT_HID_1f58 = 0x1f58,
	BNXT_ULP_ACT_HID_5268 = 0x5268,
	BNXT_ULP_ACT_HID_6378 = 0x6378,
	BNXT_ULP_ACT_HID_23f4 = 0x23f4,
	BNXT_ULP_ACT_HID_5704 = 0x5704,
	BNXT_ULP_ACT_HID_3504 = 0x3504,
	BNXT_ULP_ACT_HID_1f68 = 0x1f68,
	BNXT_ULP_ACT_HID_5278 = 0x5278,
	BNXT_ULP_ACT_HID_6388 = 0x6388,
	BNXT_ULP_ACT_HID_1c36 = 0x1c36,
	BNXT_ULP_ACT_HID_2436 = 0x2436,
	BNXT_ULP_ACT_HID_2c36 = 0x2c36,
	BNXT_ULP_ACT_HID_1c46 = 0x1c46,
	BNXT_ULP_ACT_HID_2446 = 0x2446,
	BNXT_ULP_ACT_HID_2c46 = 0x2c46,
	BNXT_ULP_ACT_HID_2546 = 0x2546,
	BNXT_ULP_ACT_HID_5856 = 0x5856,
	BNXT_ULP_ACT_HID_3656 = 0x3656,
	BNXT_ULP_ACT_HID_20ba = 0x20ba,
	BNXT_ULP_ACT_HID_53ca = 0x53ca,
	BNXT_ULP_ACT_HID_64da = 0x64da,
	BNXT_ULP_ACT_HID_2d46 = 0x2d46,
	BNXT_ULP_ACT_HID_6056 = 0x6056,
	BNXT_ULP_ACT_HID_3e56 = 0x3e56,
	BNXT_ULP_ACT_HID_28ba = 0x28ba,
	BNXT_ULP_ACT_HID_5bca = 0x5bca,
	BNXT_ULP_ACT_HID_6cda = 0x6cda,
	BNXT_ULP_ACT_HID_3546 = 0x3546,
	BNXT_ULP_ACT_HID_6856 = 0x6856,
	BNXT_ULP_ACT_HID_4656 = 0x4656,
	BNXT_ULP_ACT_HID_30ba = 0x30ba,
	BNXT_ULP_ACT_HID_63ca = 0x63ca,
	BNXT_ULP_ACT_HID_74da = 0x74da,
	BNXT_ULP_ACT_HID_3d46 = 0x3d46,
	BNXT_ULP_ACT_HID_7056 = 0x7056,
	BNXT_ULP_ACT_HID_4e56 = 0x4e56,
	BNXT_ULP_ACT_HID_38ba = 0x38ba,
	BNXT_ULP_ACT_HID_6bca = 0x6bca,
	BNXT_ULP_ACT_HID_011e = 0x011e,
	BNXT_ULP_ACT_HID_2556 = 0x2556,
	BNXT_ULP_ACT_HID_5866 = 0x5866,
	BNXT_ULP_ACT_HID_3666 = 0x3666,
	BNXT_ULP_ACT_HID_20ca = 0x20ca,
	BNXT_ULP_ACT_HID_53da = 0x53da,
	BNXT_ULP_ACT_HID_64ea = 0x64ea,
	BNXT_ULP_ACT_HID_2d56 = 0x2d56,
	BNXT_ULP_ACT_HID_6066 = 0x6066,
	BNXT_ULP_ACT_HID_3e66 = 0x3e66,
	BNXT_ULP_ACT_HID_28ca = 0x28ca,
	BNXT_ULP_ACT_HID_5bda = 0x5bda,
	BNXT_ULP_ACT_HID_6cea = 0x6cea,
	BNXT_ULP_ACT_HID_3556 = 0x3556,
	BNXT_ULP_ACT_HID_6866 = 0x6866,
	BNXT_ULP_ACT_HID_4666 = 0x4666,
	BNXT_ULP_ACT_HID_30ca = 0x30ca,
	BNXT_ULP_ACT_HID_63da = 0x63da,
	BNXT_ULP_ACT_HID_74ea = 0x74ea,
	BNXT_ULP_ACT_HID_3d56 = 0x3d56,
	BNXT_ULP_ACT_HID_7066 = 0x7066,
	BNXT_ULP_ACT_HID_4e66 = 0x4e66,
	BNXT_ULP_ACT_HID_38ca = 0x38ca,
	BNXT_ULP_ACT_HID_6bda = 0x6bda,
	BNXT_ULP_ACT_HID_012e = 0x012e,
	BNXT_ULP_ACT_HID_3ece = 0x3ece,
	BNXT_ULP_ACT_HID_71de = 0x71de,
	BNXT_ULP_ACT_HID_4fde = 0x4fde,
	BNXT_ULP_ACT_HID_3a42 = 0x3a42,
	BNXT_ULP_ACT_HID_6d52 = 0x6d52,
	BNXT_ULP_ACT_HID_02a6 = 0x02a6,
	BNXT_ULP_ACT_HID_3ede = 0x3ede,
	BNXT_ULP_ACT_HID_71ee = 0x71ee,
	BNXT_ULP_ACT_HID_4fee = 0x4fee,
	BNXT_ULP_ACT_HID_3a52 = 0x3a52,
	BNXT_ULP_ACT_HID_6d62 = 0x6d62,
	BNXT_ULP_ACT_HID_02b6 = 0x02b6,
	BNXT_ULP_ACT_HID_79de = 0x79de,
	BNXT_ULP_ACT_HID_57de = 0x57de,
	BNXT_ULP_ACT_HID_4242 = 0x4242,
	BNXT_ULP_ACT_HID_46ce = 0x46ce,
	BNXT_ULP_ACT_HID_7552 = 0x7552,
	BNXT_ULP_ACT_HID_0aa6 = 0x0aa6,
	BNXT_ULP_ACT_HID_46de = 0x46de,
	BNXT_ULP_ACT_HID_79ee = 0x79ee,
	BNXT_ULP_ACT_HID_57ee = 0x57ee,
	BNXT_ULP_ACT_HID_4252 = 0x4252,
	BNXT_ULP_ACT_HID_7562 = 0x7562,
	BNXT_ULP_ACT_HID_0ab6 = 0x0ab6,
	BNXT_ULP_ACT_HID_4ece = 0x4ece,
	BNXT_ULP_ACT_HID_0622 = 0x0622,
	BNXT_ULP_ACT_HID_5fde = 0x5fde,
	BNXT_ULP_ACT_HID_4a42 = 0x4a42,
	BNXT_ULP_ACT_HID_0196 = 0x0196,
	BNXT_ULP_ACT_HID_12a6 = 0x12a6,
	BNXT_ULP_ACT_HID_4ede = 0x4ede,
	BNXT_ULP_ACT_HID_0632 = 0x0632,
	BNXT_ULP_ACT_HID_5fee = 0x5fee,
	BNXT_ULP_ACT_HID_4a52 = 0x4a52,
	BNXT_ULP_ACT_HID_01a6 = 0x01a6,
	BNXT_ULP_ACT_HID_12b6 = 0x12b6,
	BNXT_ULP_ACT_HID_56ce = 0x56ce,
	BNXT_ULP_ACT_HID_0e22 = 0x0e22,
	BNXT_ULP_ACT_HID_67de = 0x67de,
	BNXT_ULP_ACT_HID_5242 = 0x5242,
	BNXT_ULP_ACT_HID_0996 = 0x0996,
	BNXT_ULP_ACT_HID_1aa6 = 0x1aa6,
	BNXT_ULP_ACT_HID_56de = 0x56de,
	BNXT_ULP_ACT_HID_0e32 = 0x0e32,
	BNXT_ULP_ACT_HID_67ee = 0x67ee,
	BNXT_ULP_ACT_HID_5252 = 0x5252,
	BNXT_ULP_ACT_HID_09a6 = 0x09a6,
	BNXT_ULP_ACT_HID_1ab6 = 0x1ab6,
	BNXT_ULP_ACT_HID_31d0 = 0x31d0,
	BNXT_ULP_ACT_HID_31e0 = 0x31e0,
	BNXT_ULP_ACT_HID_39d0 = 0x39d0,
	BNXT_ULP_ACT_HID_39e0 = 0x39e0,
	BNXT_ULP_ACT_HID_41d0 = 0x41d0,
	BNXT_ULP_ACT_HID_41e0 = 0x41e0,
	BNXT_ULP_ACT_HID_49d0 = 0x49d0,
	BNXT_ULP_ACT_HID_49e0 = 0x49e0,
	BNXT_ULP_ACT_HID_64ba = 0x64ba,
	BNXT_ULP_ACT_HID_64ca = 0x64ca,
	BNXT_ULP_ACT_HID_6cba = 0x6cba,
	BNXT_ULP_ACT_HID_6cca = 0x6cca,
	BNXT_ULP_ACT_HID_74ba = 0x74ba,
	BNXT_ULP_ACT_HID_74ca = 0x74ca,
	BNXT_ULP_ACT_HID_00fe = 0x00fe,
	BNXT_ULP_ACT_HID_010e = 0x010e,
	BNXT_ULP_ACT_HID_331c = 0x331c,
	BNXT_ULP_ACT_HID_332c = 0x332c,
	BNXT_ULP_ACT_HID_6706 = 0x6706,
	BNXT_ULP_ACT_HID_6716 = 0x6716,
	BNXT_ULP_ACT_HID_1b6d = 0x1b6d,
	BNXT_ULP_ACT_HID_1b7d = 0x1b7d,
	BNXT_ULP_ACT_HID_641a = 0x641a
};

enum bnxt_ulp_df_tpl {
	BNXT_ULP_DF_TPL_DEFAULT_UPLINK_PORT = 4,
	BNXT_ULP_DF_TPL_DEFAULT_VFR = 5
};

#endif
