/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.ctxmenu.ChildlessTreeListItem;
import com.paterva.maltego.util.ui.ctxmenu.PagedTreeListItem;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.openide.util.NbPreferences;

class RootPagedTreeListItem
extends PagedTreeListItem {
    private static final Logger LOG = Logger.getLogger(RootPagedTreeListItem.class.getName());
    private static final String PREF_CTX_BRANCH = "maltego.ctxmenu.branch";
    private final LinkedList<String> _branch = new LinkedList();
    private final LinkedList<String> _persistedBranch = new LinkedList();
    private final Map<String, String> _branchDisplayNames = new HashMap<String, String>();
    private List<TreeListItem> _children;

    public RootPagedTreeListItem(TreeListItem treeListRoot) {
        super(treeListRoot);
        this.loadBranch();
    }

    @Override
    public void removeNotify() {
        this.setChildren(null);
        super.removeNotify();
    }

    public LinkedList<String> getBranch() {
        this.getChildren();
        return this._branch;
    }

    public String getBranchDisplayName(String branchName) {
        return this._branchDisplayNames.get(branchName);
    }

    public List<TreeListItem> getSuperChildren() {
        return super.getChildren();
    }

    @Override
    public List<TreeListItem> getChildren() {
        if (this._children == null) {
            List<TreeListItem> children = super.getChildren();
            int depth = 0;
            for (String itemName : this._branch) {
                boolean found = false;
                for (TreeListItem child : children) {
                    if (!itemName.equals(child.getName())) continue;
                    this._branchDisplayNames.put(itemName, child.getDisplayName());
                    List<TreeListItem> itemChildren = child.getChildren();
                    if (itemChildren.isEmpty()) continue;
                    children = itemChildren;
                    found = true;
                    break;
                }
                if (!found) break;
                ++depth;
            }
            while (this._branch.size() > depth) {
                this._branch.removeLast();
            }
            children = this.makeChildless(children);
            this.setChildren(children);
        }
        return this._children;
    }

    public List<TreeListItem> makeChildless(List<TreeListItem> items) {
        ArrayList<TreeListItem> childlessItems = new ArrayList<TreeListItem>();
        int listIndex = 1;
        for (TreeListItem item : items) {
            childlessItems.add(new ChildlessTreeListItem(item, listIndex));
            ++listIndex;
        }
        return childlessItems;
    }

    @Override
    public List<TreeListItem> getAsList() {
        ArrayList<TreeListItem> list = new ArrayList<TreeListItem>();
        list.add(this);
        list.addAll(this.getChildren());
        return list;
    }

    public void onClicked(TreeListItem item, MouseEvent e) {
        boolean leftClicked;
        if (e.getID() != 502) {
            return;
        }
        boolean bl = leftClicked = e.getButton() == 1;
        if (leftClicked) {
            this.doForward(item);
        } else {
            this.doBack();
        }
    }

    public void doForward(TreeListItem item) {
        if (item != null) {
            Action action = item.getDefaultAction();
            if (action != null) {
                WindowPopupManager.getInstance().close();
                action.actionPerformed(null);
            } else {
                String section = item.getName();
                if (this._persistedBranch.size() == this._branch.size() && item.isRemeberPage()) {
                    this._persistedBranch.add(section);
                }
                this._branch.add(section);
                this._branchDisplayNames.put(section, item.getDisplayName());
                if (!"Search Results".equals(item.getName())) {
                    this.saveBranch();
                }
                this.setChildren(null);
                this.fireItemsReplaced(true);
            }
        }
    }

    public void doBackCompletely() {
        this.doBack(this._branch.size());
    }

    public void doBack(int count) {
        boolean changed = false;
        for (int i = 0; i < count; ++i) {
            if (this._branch.isEmpty()) continue;
            this._branch.removeLast();
            if (this._persistedBranch.size() > this._branch.size()) {
                this._persistedBranch.clear();
                this._persistedBranch.addAll(this._branch);
            }
            changed = true;
        }
        if (changed) {
            this.saveBranch();
            this.setChildren(null);
            this.fireItemsReplaced(false);
        }
    }

    public void doBack() {
        this.doBack(1);
    }

    private void fireItemsReplaced(Boolean slideLeft) {
        this.firePropertyChange("itemsReplaced", null, slideLeft == null ? null : new TreeListItemEvent(this, slideLeft));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        boolean added = "childAdded".equals(propName);
        boolean removed = "childRemoved".equals(propName);
        if (added || removed) {
            int depthBefore = this._branch.size();
            List<TreeListItem> oldChildren = this.getChildren();
            this.setChildren(null);
            List<TreeListItem> newChildren = this.getChildren();
            int depthAfter = this._branch.size();
            if (depthBefore != depthAfter) {
                this.fireItemsReplaced(null);
            } else if (oldChildren.size() != newChildren.size()) {
                TreeListItem item;
                TreeListItemEvent event = (TreeListItemEvent)evt.getNewValue();
                int childIndex = event.getChildIndex();
                if (added) {
                    if (childIndex >= newChildren.size()) {
                        this.fireItemsReplaced(null);
                        return;
                    }
                    item = newChildren.get(childIndex);
                } else {
                    if (childIndex >= oldChildren.size()) {
                        this.fireItemsReplaced(null);
                        return;
                    }
                    item = oldChildren.get(childIndex);
                }
                TreeListItemEvent treeListItemEvent = new TreeListItemEvent(item, childIndex, childIndex + 1);
                this.firePropertyChange(evt.getPropertyName(), null, treeListItemEvent);
            }
        }
    }

    private void loadBranch() {
        Preferences prefs = this.getPrefs();
        String str = prefs.get(PREF_CTX_BRANCH, "");
        List branch = StringUtilities.listFromString((String)str);
        this._persistedBranch.clear();
        for (String section : branch) {
            if (StringUtilities.isNullOrEmpty((String)section)) continue;
            this._persistedBranch.add(section);
        }
        this._branch.clear();
        this._branch.addAll(this._persistedBranch);
    }

    private void saveBranch() {
        Preferences prefs = this.getPrefs();
        String str = StringUtilities.listToString(this._persistedBranch);
        prefs.put(PREF_CTX_BRANCH, str);
    }

    protected Preferences getPrefs() {
        return NbPreferences.forModule(this.getClass());
    }

    private void setChildren(List<TreeListItem> children) {
        LOG.log(Level.FINE, "Old children: {0}", this._children);
        if (this._children != null) {
            for (TreeListItem item : this._children) {
                item.removeNotify();
            }
        }
        this._children = children;
        LOG.log(Level.FINE, "New children: {0}", this._children);
        if (this._children != null) {
            for (TreeListItem item : this._children) {
                item.addNotify();
            }
        }
    }
}

