/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.components;

import com.paterva.maltego.util.ui.fonts.FontUtils;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIDefaults;
import javax.swing.event.HyperlinkEvent;
import org.openide.awt.HtmlBrowser;

public class HeadingTextAndIcon
extends JPanel {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final Color textareaBackground = LAF.getColor("wizard-banner-textarea-bg");
    private final Color textareaForeground = LAF.getColor("wizard-banner-textarea-fg");
    private final Color bg = LAF.getColor("3-main-dark-color");
    private final CardLayout _textContainerLayout = new CardLayout(0, 0);
    private final JPanel _textContainer = new JPanel(this._textContainerLayout);
    private static final String PLAIN_CARD = "plain";
    private final JTextArea _headingTextArea = new JTextArea();
    private static final String HTML_CARD = "html";
    private final JEditorPane _headingEditorPane = new JEditorPane();
    private final JPanel _iconPanel = new JPanel();
    private final JLabel _iconLabel = new JLabel();
    private final GridBagConstraints _textGridBagConstraints = new GridBagConstraints();
    private final GridBagConstraints _iconGridBagConstraints = new GridBagConstraints();
    private final GridBagLayout _gridBagLayout = new GridBagLayout();

    public HeadingTextAndIcon() {
        this.setLayout(this._gridBagLayout);
        this.setBackground(this.bg);
        this._headingTextArea.setEditable(false);
        this._headingTextArea.setBackground(this.textareaBackground);
        this._headingTextArea.setColumns(20);
        this._headingTextArea.setFont(FontUtils.defaultScaled(2.0f));
        this._headingTextArea.setForeground(this.textareaForeground);
        this._headingTextArea.setLineWrap(true);
        this._headingTextArea.setWrapStyleWord(true);
        this._headingTextArea.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 0));
        this._headingTextArea.setFocusable(false);
        this._headingTextArea.setMinimumSize(new Dimension(70, 63));
        this._headingEditorPane.setEditable(false);
        this._headingEditorPane.setBackground(this.textareaBackground);
        this._headingEditorPane.setForeground(this.textareaForeground);
        this._headingEditorPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 0));
        this._headingEditorPane.setFocusable(false);
        this._headingEditorPane.setMinimumSize(new Dimension(70, 63));
        this._headingEditorPane.setContentType("text/html");
        this._headingEditorPane.addHyperlinkListener(event -> {
            if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(event.getURL());
            }
        });
        this._textContainer.setBackground(this.textareaBackground);
        this._textContainer.add((Component)this._headingTextArea, PLAIN_CARD);
        this._textContainer.add((Component)this._headingEditorPane, HTML_CARD);
        this._textGridBagConstraints.gridx = 0;
        this._textGridBagConstraints.gridy = 0;
        this._textGridBagConstraints.gridheight = 0;
        this._textGridBagConstraints.gridwidth = 3;
        this._textGridBagConstraints.fill = 1;
        this._textGridBagConstraints.weightx = 1.0;
        this._textGridBagConstraints.weighty = 1.0;
        this._textGridBagConstraints.anchor = 18;
        this._textGridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.add((Component)this._textContainer, this._textGridBagConstraints);
        this._textContainerLayout.show(this._textContainer, PLAIN_CARD);
        this._iconPanel.setBackground(this.textareaBackground);
        this._iconPanel.setMaximumSize(new Dimension(63, 63));
        this._iconPanel.setMinimumSize(new Dimension(63, 63));
        this._iconPanel.setPreferredSize(new Dimension(63, 63));
        this._iconPanel.setLayout(new BorderLayout());
        this._iconGridBagConstraints.gridx = 3;
        this._iconGridBagConstraints.gridy = 0;
        this._iconGridBagConstraints.gridheight = 0;
        this._iconGridBagConstraints.fill = 3;
        this._iconGridBagConstraints.anchor = 18;
        this._iconGridBagConstraints.insets = new Insets(6, 0, 12, 6);
        this.add((Component)this._iconPanel, this._iconGridBagConstraints);
        this._iconLabel.setBackground(this.textareaBackground);
        this._iconLabel.setHorizontalAlignment(0);
        this._iconLabel.setVerticalAlignment(0);
        this._iconPanel.add(this._iconLabel);
    }

    public void setText(String text) {
        this._headingTextArea.setText(text);
        this._textContainerLayout.show(this._textContainer, PLAIN_CARD);
    }

    public void setHTMLText(String text) {
        Color color = this._headingEditorPane.getForeground();
        String fontColor = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        this._headingEditorPane.setText("<html><body style='font-family: Arial, Helvetica, sans-serif; color: " + fontColor + "; font-size:" + FontUtils.defaultScaled(-1.0f).getSize() + "px'>" + text + "</body></html>");
        this._textContainerLayout.show(this._textContainer, HTML_CARD);
    }

    public void setTextTooltip(String text) {
        this._headingTextArea.setToolTipText(text);
        this._headingEditorPane.setToolTipText(text);
    }

    public Color getTextBackground() {
        return this._headingTextArea.getBackground();
    }

    public void addIcon(Object object) {
        if (object instanceof Component) {
            this._iconPanel.add((Component)object);
        } else if (object instanceof ImageIcon) {
            this._iconLabel.setIcon((ImageIcon)object);
        } else if (object instanceof Image) {
            this._iconLabel.setIcon(new ImageIcon((Image)object));
        }
    }

    public void setInsets(Insets insets) {
        Insets iconInsets;
        Insets textInsets;
        int top = insets.top;
        int left = insets.left;
        int bottom = insets.bottom;
        int right = insets.right;
        this._textGridBagConstraints.insets = textInsets = new Insets(top, left, bottom, 0);
        this._gridBagLayout.setConstraints(this._textContainer, this._textGridBagConstraints);
        this._iconGridBagConstraints.insets = iconInsets = new Insets(top, 0, bottom, right);
        this._gridBagLayout.setConstraints(this._iconPanel, this._iconGridBagConstraints);
        this.revalidate();
        this.repaint();
    }
}

