from PySide6.QtWidgets import QVBoxLayout, QLineEdit

PLACEHOLDER_TEXTS = {
    "nmap": "Enter flags (e.g., -p 80 192.168.0.1)",
    "bettercap": "Enter flags (e.g., --proxy)",
    "sqlmap": "Enter flags (e.g., -u 'http://example.com')",
    "netexec": "Enter flags (e.g., --help)",
    "evil-winrm": "Enter flags (e.g., --help)",
    "wpscan": "Enter flags (e.g., --help)",
    "katana": "Enter flags (e.g., --help)",
    "subfinder": "Enter flags (e.g., --help)",
}

class FlagsSection:
    SUPPORTED_TOOLS = {"nmap", "bettercap", "sqlmap", "netexec", "evil-winrm", "wpscan", "katana", "subfinder"}

    def __init__(self, parent):
        self.parent = parent
        self.tool = parent.tool

    @staticmethod
    def get_placeholder_text(tool_name: str) -> str:
        """
        Returns the placeholder text for the given tool name.
        """
        return PLACEHOLDER_TEXTS.get(tool_name, "Enter flags for the tool")

    def create_flags_section(self) -> QVBoxLayout:
        """
        Creates the flags input section for the tool card.
        """
        layout = QVBoxLayout()
        tool_name = self.tool["name"].lower()
        if tool_name in self.SUPPORTED_TOOLS:
            flags_input = QLineEdit(self.parent)
            flags_input.setPlaceholderText(self.get_placeholder_text(tool_name))
            layout.addWidget(flags_input)
            self.parent.flags_input = flags_input
        return layout

