"""
Colour constants for Rocket themes.

This module defines colour palettes for several themes,
including the Default one, Hack The Box, Greenlight and Sunset.
Each theme has a set of colours for different GUI elements,
such as backgrounds, borders and buttons.
"""

# COLOR PALETTE
WHITE = "#FFFFFF"
BLACK = "#000000"

# Default Theme
BG_WIDGET_DEFAULT = "#08091A"
BG_ITEM_DEFAULT = "#293963"
BORDER_ITEM_DEFAULT = "#2E3B4A"
BG_BUTTON_DEFAULT = "#E48E41"
BORDER_BUTTON_DEFAULT = "#4C6065"
BG_ITEM_SELECTED_DEFAULT = "#CC7728"

# Hack The Box Theme
BG_WIDGET_HACKTHEBOX = "#0C121E"
BG_ITEM_HACKTHEBOX = "#222836"
BORDER_ITEM_HACKTHEBOX = "#2E3B4A"
BG_BUTTON_HACKTHEBOX = "#63D201"
BORDER_BUTTON_HACKTHEBOX = "#222836"
BG_ITEM_SELECTED_HACKTHEBOX = "#63D201"

# Greenlight Theme
BG_WIDGET_GREENLIGHT = "#F0F0F0"
BG_ITEM_GREENLIGHT = "#FFFFFF"
BORDER_ITEM_GREENLIGHT = "#CCCCCC"
BG_BUTTON_GREENLIGHT = "#4CAF50"
BORDER_BUTTON_GREENLIGHT = "#388E3C"
BG_ITEM_SELECTED_GREENLIGHT = "#B3E5FC"

# Sunset Theme
BG_WIDGET_SUNSET = "#303030"
BG_ITEM_SUNSET = "#424242"
BORDER_ITEM_SUNSET = "#616161"
BG_BUTTON_SUNSET = "#FF5722"
BORDER_BUTTON_SUNSET = "#BF360C"
BG_ITEM_SELECTED_SUNSET = "#FFAB91"

# Theme palette mapping for easier theme management
THEME_PALETTES = {
    "default": {
        "widget": BG_WIDGET_DEFAULT,
        "item": BG_ITEM_DEFAULT,
        "border_item": BORDER_ITEM_DEFAULT,
        "button": BG_BUTTON_DEFAULT,
        "border_button": BORDER_BUTTON_DEFAULT,
        "item_selected": BG_ITEM_SELECTED_DEFAULT,
    },
    "hackthebox": {
        "widget": BG_WIDGET_HACKTHEBOX,
        "item": BG_ITEM_HACKTHEBOX,
        "border_item": BORDER_ITEM_HACKTHEBOX,
        "button": BG_BUTTON_HACKTHEBOX,
        "border_button": BORDER_BUTTON_HACKTHEBOX,
        "item_selected": BG_ITEM_SELECTED_HACKTHEBOX,
    },
    "greenlight": {
        "widget": BG_WIDGET_GREENLIGHT,
        "item": BG_ITEM_GREENLIGHT,
        "border_item": BORDER_ITEM_GREENLIGHT,
        "button": BG_BUTTON_GREENLIGHT,
        "border_button": BORDER_BUTTON_GREENLIGHT,
        "item_selected": BG_ITEM_SELECTED_GREENLIGHT,
    },
    "sunset": {
        "widget": BG_WIDGET_SUNSET,
        "item": BG_ITEM_SUNSET,
        "border_item": BORDER_ITEM_SUNSET,
        "button": BG_BUTTON_SUNSET,
        "border_button": BORDER_BUTTON_SUNSET,
        "item_selected": BG_ITEM_SELECTED_SUNSET,
    }
}
