% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-tweet.R
\name{post_tweet}
\alias{post_tweet}
\alias{post_status}
\title{Posts status update to user's Twitter account}
\usage{
post_tweet(
  status = "my first rtweet #rstats",
  media = NULL,
  token = NULL,
  in_reply_to_status_id = NULL,
  destroy_id = NULL,
  retweet_id = NULL,
  auto_populate_reply_metadata = FALSE,
  media_alt_text = NULL,
  lat = NULL,
  long = NULL,
  display_coordinates = FALSE
)
}
\arguments{
\item{status}{Character, tweet status. Must be 280 characters or less.}

\item{media}{Length 1 character vector with a file path to video media \strong{OR}
up-to length 4 character vector with file paths to static images to be included in tweet.
\strong{The caller is responsible for managing this.}}

\item{token}{Use this to override authentication for
a single API call. In many cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{in_reply_to_status_id}{Status ID of tweet to which you'd like to reply.
Note: in line with the Twitter API, this parameter is ignored unless the
author of the tweet this parameter references is mentioned within the
status text.}

\item{destroy_id}{To delete a status, supply the single status ID here. If a
character string is supplied, overriding the default (NULL), then a destroy
request is made (and the status text and media attachments) are irrelevant.}

\item{retweet_id}{To retweet a status, supply the single status ID here. If a
character string is supplied, overriding the default (NULL), then a retweet
request is made (and the status text and media attachments) are irrelevant.}

\item{auto_populate_reply_metadata}{If set to TRUE and used with
in_reply_to_status_id, leading @mentions will be looked up from the
original Tweet, and added to the new Tweet from there. Defaults to FALSE.}

\item{media_alt_text}{attach additional \href{https://en.wikipedia.org/wiki/Alt_attribute}{alt text}
metadata to the \code{media} you are uploading. Should be same length as
\code{media} (i.e. as many alt text entries as there are \code{media} entries). See
\href{https://developer.twitter.com/en/docs/twitter-api/v1/media/upload-media/api-reference/post-media-metadata-create}{the official API documentation}
for more information.}

\item{lat}{A numeric value representing the latitude of the location the
tweet refers to. Range should be between -90 and 90 (north). Note that you
should enable the "Precise location" option in your account via \emph{Settings
and privacy > Privacy and Safety > Location}. See
\href{https://help.twitter.com/en/safety-and-security/x-location-services-for-mobile}{the official Help Center section}.}

\item{long}{A numeric value representing the longitude of the location the
tweet refers to. Range should be between -180 and 180 (west). See
\code{lat} parameter.}

\item{display_coordinates}{Put a pin on the exact coordinates a tweet has
been sent from. Value should be TRUE or FALSE. This parameter would apply
only if you have provided a valid \code{lat/long} pair of valid values.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\references{
Tweet: \url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/post-statuses-update}
Retweet: \url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/post-and-engage/api-reference/post-statuses-retweet-id}
Media: \url{https://developer.twitter.com/en/docs/twitter-api/v1/media/upload-media/api-reference/post-media-metadata-create}
Alt-text: \url{https://developer.twitter.com/en/docs/twitter-api/v1/media/upload-media/api-reference/post-media-metadata-create}
}
\seealso{
\code{\link[=tweet_post]{tweet_post()}}, \code{\link{rtweet-deprecated}}

Other post: 
\code{\link{post_favorite}()},
\code{\link{post_follow}()},
\code{\link{post_friendship}()}
}
\concept{post}
