<?php

declare(strict_types=1);

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Tests\CarbonImmutable;

use Carbon\CarbonImmutable as Carbon;
use Carbon\CarbonInterface;
use Tests\AbstractTestCase;

class WeekTest extends AbstractTestCase
{
    public const SAMPLE = [
        '1990-12-20' => [
            1990,
            1990,
            51,
            51,
            52,
            52,
        ],
        '1990-12-21' => [
            1990,
            1990,
            51,
            51,
            52,
            52,
        ],
        '1990-12-22' => [
            1990,
            1990,
            51,
            51,
            52,
            52,
        ],
        '1990-12-23' => [
            1990,
            1990,
            52,
            51,
            52,
            52,
        ],
        '1990-12-24' => [
            1990,
            1990,
            52,
            52,
            52,
            52,
        ],
        '1990-12-25' => [
            1990,
            1990,
            52,
            52,
            52,
            52,
        ],
        '1990-12-26' => [
            1990,
            1990,
            52,
            52,
            52,
            52,
        ],
        '1990-12-27' => [
            1990,
            1990,
            52,
            52,
            52,
            52,
        ],
        '1990-12-28' => [
            1990,
            1990,
            52,
            52,
            52,
            52,
        ],
        '1990-12-29' => [
            1990,
            1990,
            52,
            52,
            52,
            52,
        ],
        '1990-12-30' => [
            1991,
            1990,
            1,
            52,
            52,
            52,
        ],
        '1990-12-31' => [
            1991,
            1991,
            1,
            1,
            52,
            52,
        ],
        '1991-01-01' => [
            1991,
            1991,
            1,
            1,
            52,
            52,
        ],
        '1991-01-02' => [
            1991,
            1991,
            1,
            1,
            52,
            52,
        ],
        '1991-01-03' => [
            1991,
            1991,
            1,
            1,
            52,
            52,
        ],
        '1991-01-04' => [
            1991,
            1991,
            1,
            1,
            52,
            52,
        ],
        '1991-01-05' => [
            1991,
            1991,
            1,
            1,
            52,
            52,
        ],
        '1991-01-06' => [
            1991,
            1991,
            2,
            1,
            52,
            52,
        ],
        '1991-01-07' => [
            1991,
            1991,
            2,
            2,
            52,
            52,
        ],
        '1991-01-08' => [
            1991,
            1991,
            2,
            2,
            52,
            52,
        ],
        '1991-01-09' => [
            1991,
            1991,
            2,
            2,
            52,
            52,
        ],
        '1991-01-10' => [
            1991,
            1991,
            2,
            2,
            52,
            52,
        ],
        '1991-12-20' => [
            1991,
            1991,
            51,
            51,
            52,
            52,
        ],
        '1991-12-21' => [
            1991,
            1991,
            51,
            51,
            52,
            52,
        ],
        '1991-12-22' => [
            1991,
            1991,
            52,
            51,
            52,
            52,
        ],
        '1991-12-23' => [
            1991,
            1991,
            52,
            52,
            52,
            52,
        ],
        '1991-12-24' => [
            1991,
            1991,
            52,
            52,
            52,
            52,
        ],
        '1991-12-25' => [
            1991,
            1991,
            52,
            52,
            52,
            52,
        ],
        '1991-12-26' => [
            1991,
            1991,
            52,
            52,
            52,
            52,
        ],
        '1991-12-27' => [
            1991,
            1991,
            52,
            52,
            52,
            52,
        ],
        '1991-12-28' => [
            1991,
            1991,
            52,
            52,
            52,
            52,
        ],
        '1991-12-29' => [
            1992,
            1991,
            1,
            52,
            52,
            52,
        ],
        '1991-12-30' => [
            1992,
            1992,
            1,
            1,
            52,
            52,
        ],
        '1991-12-31' => [
            1992,
            1992,
            1,
            1,
            52,
            52,
        ],
        '1992-01-01' => [
            1992,
            1992,
            1,
            1,
            52,
            53,
        ],
        '1992-01-02' => [
            1992,
            1992,
            1,
            1,
            52,
            53,
        ],
        '1992-01-03' => [
            1992,
            1992,
            1,
            1,
            52,
            53,
        ],
        '1992-01-04' => [
            1992,
            1992,
            1,
            1,
            52,
            53,
        ],
        '1992-01-05' => [
            1992,
            1992,
            2,
            1,
            52,
            53,
        ],
        '1992-01-06' => [
            1992,
            1992,
            2,
            2,
            52,
            53,
        ],
        '1992-01-07' => [
            1992,
            1992,
            2,
            2,
            52,
            53,
        ],
        '1992-01-08' => [
            1992,
            1992,
            2,
            2,
            52,
            53,
        ],
        '1992-01-09' => [
            1992,
            1992,
            2,
            2,
            52,
            53,
        ],
        '1992-01-10' => [
            1992,
            1992,
            2,
            2,
            52,
            53,
        ],
        '1992-12-20' => [
            1992,
            1992,
            52,
            51,
            52,
            53,
        ],
        '1992-12-21' => [
            1992,
            1992,
            52,
            52,
            52,
            53,
        ],
        '1992-12-22' => [
            1992,
            1992,
            52,
            52,
            52,
            53,
        ],
        '1992-12-23' => [
            1992,
            1992,
            52,
            52,
            52,
            53,
        ],
        '1992-12-24' => [
            1992,
            1992,
            52,
            52,
            52,
            53,
        ],
        '1992-12-25' => [
            1992,
            1992,
            52,
            52,
            52,
            53,
        ],
        '1992-12-26' => [
            1992,
            1992,
            52,
            52,
            52,
            53,
        ],
        '1992-12-27' => [
            1993,
            1992,
            1,
            52,
            52,
            53,
        ],
        '1992-12-28' => [
            1993,
            1992,
            1,
            53,
            52,
            53,
        ],
        '1992-12-29' => [
            1993,
            1992,
            1,
            53,
            52,
            53,
        ],
        '1992-12-30' => [
            1993,
            1992,
            1,
            53,
            52,
            53,
        ],
        '1992-12-31' => [
            1993,
            1992,
            1,
            53,
            52,
            53,
        ],
        '1993-01-01' => [
            1993,
            1992,
            1,
            53,
            52,
            52,
        ],
        '1993-01-02' => [
            1993,
            1992,
            1,
            53,
            52,
            52,
        ],
        '1993-01-03' => [
            1993,
            1992,
            2,
            53,
            52,
            52,
        ],
        '1993-01-04' => [
            1993,
            1993,
            2,
            1,
            52,
            52,
        ],
        '1993-01-05' => [
            1993,
            1993,
            2,
            1,
            52,
            52,
        ],
        '1993-01-06' => [
            1993,
            1993,
            2,
            1,
            52,
            52,
        ],
        '1993-01-07' => [
            1993,
            1993,
            2,
            1,
            52,
            52,
        ],
        '1993-01-08' => [
            1993,
            1993,
            2,
            1,
            52,
            52,
        ],
        '1993-01-09' => [
            1993,
            1993,
            2,
            1,
            52,
            52,
        ],
        '1993-01-10' => [
            1993,
            1993,
            3,
            1,
            52,
            52,
        ],
        '1993-12-20' => [
            1993,
            1993,
            52,
            51,
            52,
            52,
        ],
        '1993-12-21' => [
            1993,
            1993,
            52,
            51,
            52,
            52,
        ],
        '1993-12-22' => [
            1993,
            1993,
            52,
            51,
            52,
            52,
        ],
        '1993-12-23' => [
            1993,
            1993,
            52,
            51,
            52,
            52,
        ],
        '1993-12-24' => [
            1993,
            1993,
            52,
            51,
            52,
            52,
        ],
        '1993-12-25' => [
            1993,
            1993,
            52,
            51,
            52,
            52,
        ],
        '1993-12-26' => [
            1994,
            1993,
            1,
            51,
            52,
            52,
        ],
        '1993-12-27' => [
            1994,
            1993,
            1,
            52,
            52,
            52,
        ],
        '1993-12-28' => [
            1994,
            1993,
            1,
            52,
            52,
            52,
        ],
        '1993-12-29' => [
            1994,
            1993,
            1,
            52,
            52,
            52,
        ],
        '1993-12-30' => [
            1994,
            1993,
            1,
            52,
            52,
            52,
        ],
        '1993-12-31' => [
            1994,
            1993,
            1,
            52,
            52,
            52,
        ],
        '1994-01-01' => [
            1994,
            1993,
            1,
            52,
            53,
            52,
        ],
        '1994-01-02' => [
            1994,
            1993,
            2,
            52,
            53,
            52,
        ],
        '1994-01-03' => [
            1994,
            1994,
            2,
            1,
            53,
            52,
        ],
        '1994-01-04' => [
            1994,
            1994,
            2,
            1,
            53,
            52,
        ],
        '1994-01-05' => [
            1994,
            1994,
            2,
            1,
            53,
            52,
        ],
        '1994-01-06' => [
            1994,
            1994,
            2,
            1,
            53,
            52,
        ],
        '1994-01-07' => [
            1994,
            1994,
            2,
            1,
            53,
            52,
        ],
        '1994-01-08' => [
            1994,
            1994,
            2,
            1,
            53,
            52,
        ],
        '1994-01-09' => [
            1994,
            1994,
            3,
            1,
            53,
            52,
        ],
        '1994-01-10' => [
            1994,
            1994,
            3,
            2,
            53,
            52,
        ],
        '1994-12-20' => [
            1994,
            1994,
            52,
            51,
            53,
            52,
        ],
        '1994-12-21' => [
            1994,
            1994,
            52,
            51,
            53,
            52,
        ],
        '1994-12-22' => [
            1994,
            1994,
            52,
            51,
            53,
            52,
        ],
        '1994-12-23' => [
            1994,
            1994,
            52,
            51,
            53,
            52,
        ],
        '1994-12-24' => [
            1994,
            1994,
            52,
            51,
            53,
            52,
        ],
        '1994-12-25' => [
            1994,
            1994,
            53,
            51,
            53,
            52,
        ],
        '1994-12-26' => [
            1994,
            1994,
            53,
            52,
            53,
            52,
        ],
        '1994-12-27' => [
            1994,
            1994,
            53,
            52,
            53,
            52,
        ],
        '1994-12-28' => [
            1994,
            1994,
            53,
            52,
            53,
            52,
        ],
        '1994-12-29' => [
            1994,
            1994,
            53,
            52,
            53,
            52,
        ],
        '1994-12-30' => [
            1994,
            1994,
            53,
            52,
            53,
            52,
        ],
        '1994-12-31' => [
            1994,
            1994,
            53,
            52,
            53,
            52,
        ],
        '1995-01-01' => [
            1995,
            1994,
            1,
            52,
            52,
            52,
        ],
        '1995-01-02' => [
            1995,
            1995,
            1,
            1,
            52,
            52,
        ],
        '1995-01-03' => [
            1995,
            1995,
            1,
            1,
            52,
            52,
        ],
        '1995-01-04' => [
            1995,
            1995,
            1,
            1,
            52,
            52,
        ],
        '1995-01-05' => [
            1995,
            1995,
            1,
            1,
            52,
            52,
        ],
        '1995-01-06' => [
            1995,
            1995,
            1,
            1,
            52,
            52,
        ],
        '1995-01-07' => [
            1995,
            1995,
            1,
            1,
            52,
            52,
        ],
        '1995-01-08' => [
            1995,
            1995,
            2,
            1,
            52,
            52,
        ],
        '1995-01-09' => [
            1995,
            1995,
            2,
            2,
            52,
            52,
        ],
        '1995-01-10' => [
            1995,
            1995,
            2,
            2,
            52,
            52,
        ],
        '1995-12-20' => [
            1995,
            1995,
            51,
            51,
            52,
            52,
        ],
        '1995-12-21' => [
            1995,
            1995,
            51,
            51,
            52,
            52,
        ],
        '1995-12-22' => [
            1995,
            1995,
            51,
            51,
            52,
            52,
        ],
        '1995-12-23' => [
            1995,
            1995,
            51,
            51,
            52,
            52,
        ],
        '1995-12-24' => [
            1995,
            1995,
            52,
            51,
            52,
            52,
        ],
        '1995-12-25' => [
            1995,
            1995,
            52,
            52,
            52,
            52,
        ],
        '1995-12-26' => [
            1995,
            1995,
            52,
            52,
            52,
            52,
        ],
        '1995-12-27' => [
            1995,
            1995,
            52,
            52,
            52,
            52,
        ],
        '1995-12-28' => [
            1995,
            1995,
            52,
            52,
            52,
            52,
        ],
        '1995-12-29' => [
            1995,
            1995,
            52,
            52,
            52,
            52,
        ],
        '1995-12-30' => [
            1995,
            1995,
            52,
            52,
            52,
            52,
        ],
        '1995-12-31' => [
            1996,
            1995,
            1,
            52,
            52,
            52,
        ],
        '1996-01-01' => [
            1996,
            1996,
            1,
            1,
            52,
            52,
        ],
        '1996-01-02' => [
            1996,
            1996,
            1,
            1,
            52,
            52,
        ],
        '1996-01-03' => [
            1996,
            1996,
            1,
            1,
            52,
            52,
        ],
        '1996-01-04' => [
            1996,
            1996,
            1,
            1,
            52,
            52,
        ],
        '1996-01-05' => [
            1996,
            1996,
            1,
            1,
            52,
            52,
        ],
        '1996-01-06' => [
            1996,
            1996,
            1,
            1,
            52,
            52,
        ],
        '1996-01-07' => [
            1996,
            1996,
            2,
            1,
            52,
            52,
        ],
        '1996-01-08' => [
            1996,
            1996,
            2,
            2,
            52,
            52,
        ],
        '1996-01-09' => [
            1996,
            1996,
            2,
            2,
            52,
            52,
        ],
        '1996-01-10' => [
            1996,
            1996,
            2,
            2,
            52,
            52,
        ],
        '1996-12-20' => [
            1996,
            1996,
            51,
            51,
            52,
            52,
        ],
        '1996-12-21' => [
            1996,
            1996,
            51,
            51,
            52,
            52,
        ],
        '1996-12-22' => [
            1996,
            1996,
            52,
            51,
            52,
            52,
        ],
        '1996-12-23' => [
            1996,
            1996,
            52,
            52,
            52,
            52,
        ],
        '1996-12-24' => [
            1996,
            1996,
            52,
            52,
            52,
            52,
        ],
        '1996-12-25' => [
            1996,
            1996,
            52,
            52,
            52,
            52,
        ],
        '1996-12-26' => [
            1996,
            1996,
            52,
            52,
            52,
            52,
        ],
        '1996-12-27' => [
            1996,
            1996,
            52,
            52,
            52,
            52,
        ],
        '1996-12-28' => [
            1996,
            1996,
            52,
            52,
            52,
            52,
        ],
        '1996-12-29' => [
            1997,
            1996,
            1,
            52,
            52,
            52,
        ],
        '1996-12-30' => [
            1997,
            1997,
            1,
            1,
            52,
            52,
        ],
        '1996-12-31' => [
            1997,
            1997,
            1,
            1,
            52,
            52,
        ],
        '1997-01-01' => [
            1997,
            1997,
            1,
            1,
            52,
            52,
        ],
        '1997-01-02' => [
            1997,
            1997,
            1,
            1,
            52,
            52,
        ],
        '1997-01-03' => [
            1997,
            1997,
            1,
            1,
            52,
            52,
        ],
        '1997-01-04' => [
            1997,
            1997,
            1,
            1,
            52,
            52,
        ],
        '1997-01-05' => [
            1997,
            1997,
            2,
            1,
            52,
            52,
        ],
        '1997-01-06' => [
            1997,
            1997,
            2,
            2,
            52,
            52,
        ],
        '1997-01-07' => [
            1997,
            1997,
            2,
            2,
            52,
            52,
        ],
        '1997-01-08' => [
            1997,
            1997,
            2,
            2,
            52,
            52,
        ],
        '1997-01-09' => [
            1997,
            1997,
            2,
            2,
            52,
            52,
        ],
        '1997-01-10' => [
            1997,
            1997,
            2,
            2,
            52,
            52,
        ],
        '1997-12-20' => [
            1997,
            1997,
            51,
            51,
            52,
            52,
        ],
        '1997-12-21' => [
            1997,
            1997,
            52,
            51,
            52,
            52,
        ],
        '1997-12-22' => [
            1997,
            1997,
            52,
            52,
            52,
            52,
        ],
        '1997-12-23' => [
            1997,
            1997,
            52,
            52,
            52,
            52,
        ],
        '1997-12-24' => [
            1997,
            1997,
            52,
            52,
            52,
            52,
        ],
        '1997-12-25' => [
            1997,
            1997,
            52,
            52,
            52,
            52,
        ],
        '1997-12-26' => [
            1997,
            1997,
            52,
            52,
            52,
            52,
        ],
        '1997-12-27' => [
            1997,
            1997,
            52,
            52,
            52,
            52,
        ],
        '1997-12-28' => [
            1998,
            1997,
            1,
            52,
            52,
            52,
        ],
        '1997-12-29' => [
            1998,
            1998,
            1,
            1,
            52,
            52,
        ],
        '1997-12-30' => [
            1998,
            1998,
            1,
            1,
            52,
            52,
        ],
        '1997-12-31' => [
            1998,
            1998,
            1,
            1,
            52,
            52,
        ],
        '1998-01-01' => [
            1998,
            1998,
            1,
            1,
            52,
            53,
        ],
        '1998-01-02' => [
            1998,
            1998,
            1,
            1,
            52,
            53,
        ],
        '1998-01-03' => [
            1998,
            1998,
            1,
            1,
            52,
            53,
        ],
        '1998-01-04' => [
            1998,
            1998,
            2,
            1,
            52,
            53,
        ],
        '1998-01-05' => [
            1998,
            1998,
            2,
            2,
            52,
            53,
        ],
        '1998-01-06' => [
            1998,
            1998,
            2,
            2,
            52,
            53,
        ],
        '1998-01-07' => [
            1998,
            1998,
            2,
            2,
            52,
            53,
        ],
        '1998-01-08' => [
            1998,
            1998,
            2,
            2,
            52,
            53,
        ],
        '1998-01-09' => [
            1998,
            1998,
            2,
            2,
            52,
            53,
        ],
        '1998-01-10' => [
            1998,
            1998,
            2,
            2,
            52,
            53,
        ],
        '1998-12-20' => [
            1998,
            1998,
            52,
            51,
            52,
            53,
        ],
        '1998-12-21' => [
            1998,
            1998,
            52,
            52,
            52,
            53,
        ],
        '1998-12-22' => [
            1998,
            1998,
            52,
            52,
            52,
            53,
        ],
        '1998-12-23' => [
            1998,
            1998,
            52,
            52,
            52,
            53,
        ],
        '1998-12-24' => [
            1998,
            1998,
            52,
            52,
            52,
            53,
        ],
        '1998-12-25' => [
            1998,
            1998,
            52,
            52,
            52,
            53,
        ],
        '1998-12-26' => [
            1998,
            1998,
            52,
            52,
            52,
            53,
        ],
        '1998-12-27' => [
            1999,
            1998,
            1,
            52,
            52,
            53,
        ],
        '1998-12-28' => [
            1999,
            1998,
            1,
            53,
            52,
            53,
        ],
        '1998-12-29' => [
            1999,
            1998,
            1,
            53,
            52,
            53,
        ],
        '1998-12-30' => [
            1999,
            1998,
            1,
            53,
            52,
            53,
        ],
        '1998-12-31' => [
            1999,
            1998,
            1,
            53,
            52,
            53,
        ],
        '1999-01-01' => [
            1999,
            1998,
            1,
            53,
            52,
            52,
        ],
        '1999-01-02' => [
            1999,
            1998,
            1,
            53,
            52,
            52,
        ],
        '1999-01-03' => [
            1999,
            1998,
            2,
            53,
            52,
            52,
        ],
        '1999-01-04' => [
            1999,
            1999,
            2,
            1,
            52,
            52,
        ],
        '1999-01-05' => [
            1999,
            1999,
            2,
            1,
            52,
            52,
        ],
        '1999-01-06' => [
            1999,
            1999,
            2,
            1,
            52,
            52,
        ],
        '1999-01-07' => [
            1999,
            1999,
            2,
            1,
            52,
            52,
        ],
        '1999-01-08' => [
            1999,
            1999,
            2,
            1,
            52,
            52,
        ],
        '1999-01-09' => [
            1999,
            1999,
            2,
            1,
            52,
            52,
        ],
        '1999-01-10' => [
            1999,
            1999,
            3,
            1,
            52,
            52,
        ],
        '1999-12-20' => [
            1999,
            1999,
            52,
            51,
            52,
            52,
        ],
        '1999-12-21' => [
            1999,
            1999,
            52,
            51,
            52,
            52,
        ],
        '1999-12-22' => [
            1999,
            1999,
            52,
            51,
            52,
            52,
        ],
        '1999-12-23' => [
            1999,
            1999,
            52,
            51,
            52,
            52,
        ],
        '1999-12-24' => [
            1999,
            1999,
            52,
            51,
            52,
            52,
        ],
        '1999-12-25' => [
            1999,
            1999,
            52,
            51,
            52,
            52,
        ],
        '1999-12-26' => [
            2000,
            1999,
            1,
            51,
            52,
            52,
        ],
        '1999-12-27' => [
            2000,
            1999,
            1,
            52,
            52,
            52,
        ],
        '1999-12-28' => [
            2000,
            1999,
            1,
            52,
            52,
            52,
        ],
        '1999-12-29' => [
            2000,
            1999,
            1,
            52,
            52,
            52,
        ],
        '1999-12-30' => [
            2000,
            1999,
            1,
            52,
            52,
            52,
        ],
        '1999-12-31' => [
            2000,
            1999,
            1,
            52,
            52,
            52,
        ],
        '2000-01-01' => [
            2000,
            1999,
            1,
            52,
            53,
            52,
        ],
        '2000-01-02' => [
            2000,
            1999,
            2,
            52,
            53,
            52,
        ],
        '2000-01-03' => [
            2000,
            2000,
            2,
            1,
            53,
            52,
        ],
        '2000-01-04' => [
            2000,
            2000,
            2,
            1,
            53,
            52,
        ],
        '2000-01-05' => [
            2000,
            2000,
            2,
            1,
            53,
            52,
        ],
        '2000-01-06' => [
            2000,
            2000,
            2,
            1,
            53,
            52,
        ],
        '2000-01-07' => [
            2000,
            2000,
            2,
            1,
            53,
            52,
        ],
        '2000-01-08' => [
            2000,
            2000,
            2,
            1,
            53,
            52,
        ],
        '2000-01-09' => [
            2000,
            2000,
            3,
            1,
            53,
            52,
        ],
        '2000-01-10' => [
            2000,
            2000,
            3,
            2,
            53,
            52,
        ],
        '2000-12-20' => [
            2000,
            2000,
            52,
            51,
            53,
            52,
        ],
        '2000-12-21' => [
            2000,
            2000,
            52,
            51,
            53,
            52,
        ],
        '2000-12-22' => [
            2000,
            2000,
            52,
            51,
            53,
            52,
        ],
        '2000-12-23' => [
            2000,
            2000,
            52,
            51,
            53,
            52,
        ],
        '2000-12-24' => [
            2000,
            2000,
            53,
            51,
            53,
            52,
        ],
        '2000-12-25' => [
            2000,
            2000,
            53,
            52,
            53,
            52,
        ],
        '2000-12-26' => [
            2000,
            2000,
            53,
            52,
            53,
            52,
        ],
        '2000-12-27' => [
            2000,
            2000,
            53,
            52,
            53,
            52,
        ],
        '2000-12-28' => [
            2000,
            2000,
            53,
            52,
            53,
            52,
        ],
        '2000-12-29' => [
            2000,
            2000,
            53,
            52,
            53,
            52,
        ],
        '2000-12-30' => [
            2000,
            2000,
            53,
            52,
            53,
            52,
        ],
        '2000-12-31' => [
            2001,
            2000,
            1,
            52,
            53,
            52,
        ],
        '2001-01-01' => [
            2001,
            2001,
            1,
            1,
            52,
            52,
        ],
        '2001-01-02' => [
            2001,
            2001,
            1,
            1,
            52,
            52,
        ],
        '2001-01-03' => [
            2001,
            2001,
            1,
            1,
            52,
            52,
        ],
        '2001-01-04' => [
            2001,
            2001,
            1,
            1,
            52,
            52,
        ],
        '2001-01-05' => [
            2001,
            2001,
            1,
            1,
            52,
            52,
        ],
        '2001-01-06' => [
            2001,
            2001,
            1,
            1,
            52,
            52,
        ],
        '2001-01-07' => [
            2001,
            2001,
            2,
            1,
            52,
            52,
        ],
        '2001-01-08' => [
            2001,
            2001,
            2,
            2,
            52,
            52,
        ],
        '2001-01-09' => [
            2001,
            2001,
            2,
            2,
            52,
            52,
        ],
        '2001-01-10' => [
            2001,
            2001,
            2,
            2,
            52,
            52,
        ],
        '2001-12-20' => [
            2001,
            2001,
            51,
            51,
            52,
            52,
        ],
        '2001-12-21' => [
            2001,
            2001,
            51,
            51,
            52,
            52,
        ],
        '2001-12-22' => [
            2001,
            2001,
            51,
            51,
            52,
            52,
        ],
        '2001-12-23' => [
            2001,
            2001,
            52,
            51,
            52,
            52,
        ],
        '2001-12-24' => [
            2001,
            2001,
            52,
            52,
            52,
            52,
        ],
        '2001-12-25' => [
            2001,
            2001,
            52,
            52,
            52,
            52,
        ],
        '2001-12-26' => [
            2001,
            2001,
            52,
            52,
            52,
            52,
        ],
        '2001-12-27' => [
            2001,
            2001,
            52,
            52,
            52,
            52,
        ],
        '2001-12-28' => [
            2001,
            2001,
            52,
            52,
            52,
            52,
        ],
        '2001-12-29' => [
            2001,
            2001,
            52,
            52,
            52,
            52,
        ],
        '2001-12-30' => [
            2002,
            2001,
            1,
            52,
            52,
            52,
        ],
        '2001-12-31' => [
            2002,
            2002,
            1,
            1,
            52,
            52,
        ],
        '2002-01-01' => [
            2002,
            2002,
            1,
            1,
            52,
            52,
        ],
        '2002-01-02' => [
            2002,
            2002,
            1,
            1,
            52,
            52,
        ],
        '2002-01-03' => [
            2002,
            2002,
            1,
            1,
            52,
            52,
        ],
        '2002-01-04' => [
            2002,
            2002,
            1,
            1,
            52,
            52,
        ],
        '2002-01-05' => [
            2002,
            2002,
            1,
            1,
            52,
            52,
        ],
        '2002-01-06' => [
            2002,
            2002,
            2,
            1,
            52,
            52,
        ],
        '2002-01-07' => [
            2002,
            2002,
            2,
            2,
            52,
            52,
        ],
        '2002-01-08' => [
            2002,
            2002,
            2,
            2,
            52,
            52,
        ],
        '2002-01-09' => [
            2002,
            2002,
            2,
            2,
            52,
            52,
        ],
        '2002-01-10' => [
            2002,
            2002,
            2,
            2,
            52,
            52,
        ],
        '2002-12-20' => [
            2002,
            2002,
            51,
            51,
            52,
            52,
        ],
        '2002-12-21' => [
            2002,
            2002,
            51,
            51,
            52,
            52,
        ],
        '2002-12-22' => [
            2002,
            2002,
            52,
            51,
            52,
            52,
        ],
        '2002-12-23' => [
            2002,
            2002,
            52,
            52,
            52,
            52,
        ],
        '2002-12-24' => [
            2002,
            2002,
            52,
            52,
            52,
            52,
        ],
        '2002-12-25' => [
            2002,
            2002,
            52,
            52,
            52,
            52,
        ],
        '2002-12-26' => [
            2002,
            2002,
            52,
            52,
            52,
            52,
        ],
        '2002-12-27' => [
            2002,
            2002,
            52,
            52,
            52,
            52,
        ],
        '2002-12-28' => [
            2002,
            2002,
            52,
            52,
            52,
            52,
        ],
        '2002-12-29' => [
            2003,
            2002,
            1,
            52,
            52,
            52,
        ],
        '2002-12-30' => [
            2003,
            2003,
            1,
            1,
            52,
            52,
        ],
        '2002-12-31' => [
            2003,
            2003,
            1,
            1,
            52,
            52,
        ],
        '2003-01-01' => [
            2003,
            2003,
            1,
            1,
            52,
            52,
        ],
        '2003-01-02' => [
            2003,
            2003,
            1,
            1,
            52,
            52,
        ],
        '2003-01-03' => [
            2003,
            2003,
            1,
            1,
            52,
            52,
        ],
        '2003-01-04' => [
            2003,
            2003,
            1,
            1,
            52,
            52,
        ],
        '2003-01-05' => [
            2003,
            2003,
            2,
            1,
            52,
            52,
        ],
        '2003-01-06' => [
            2003,
            2003,
            2,
            2,
            52,
            52,
        ],
        '2003-01-07' => [
            2003,
            2003,
            2,
            2,
            52,
            52,
        ],
        '2003-01-08' => [
            2003,
            2003,
            2,
            2,
            52,
            52,
        ],
        '2003-01-09' => [
            2003,
            2003,
            2,
            2,
            52,
            52,
        ],
        '2003-01-10' => [
            2003,
            2003,
            2,
            2,
            52,
            52,
        ],
        '2003-12-20' => [
            2003,
            2003,
            51,
            51,
            52,
            52,
        ],
        '2003-12-21' => [
            2003,
            2003,
            52,
            51,
            52,
            52,
        ],
        '2003-12-22' => [
            2003,
            2003,
            52,
            52,
            52,
            52,
        ],
        '2003-12-23' => [
            2003,
            2003,
            52,
            52,
            52,
            52,
        ],
        '2003-12-24' => [
            2003,
            2003,
            52,
            52,
            52,
            52,
        ],
        '2003-12-25' => [
            2003,
            2003,
            52,
            52,
            52,
            52,
        ],
        '2003-12-26' => [
            2003,
            2003,
            52,
            52,
            52,
            52,
        ],
        '2003-12-27' => [
            2003,
            2003,
            52,
            52,
            52,
            52,
        ],
        '2003-12-28' => [
            2004,
            2003,
            1,
            52,
            52,
            52,
        ],
        '2003-12-29' => [
            2004,
            2004,
            1,
            1,
            52,
            52,
        ],
        '2003-12-30' => [
            2004,
            2004,
            1,
            1,
            52,
            52,
        ],
        '2003-12-31' => [
            2004,
            2004,
            1,
            1,
            52,
            52,
        ],
        '2004-01-01' => [
            2004,
            2004,
            1,
            1,
            52,
            53,
        ],
        '2004-01-02' => [
            2004,
            2004,
            1,
            1,
            52,
            53,
        ],
        '2004-01-03' => [
            2004,
            2004,
            1,
            1,
            52,
            53,
        ],
        '2004-01-04' => [
            2004,
            2004,
            2,
            1,
            52,
            53,
        ],
        '2004-01-05' => [
            2004,
            2004,
            2,
            2,
            52,
            53,
        ],
        '2004-01-06' => [
            2004,
            2004,
            2,
            2,
            52,
            53,
        ],
        '2004-01-07' => [
            2004,
            2004,
            2,
            2,
            52,
            53,
        ],
        '2004-01-08' => [
            2004,
            2004,
            2,
            2,
            52,
            53,
        ],
        '2004-01-09' => [
            2004,
            2004,
            2,
            2,
            52,
            53,
        ],
        '2004-01-10' => [
            2004,
            2004,
            2,
            2,
            52,
            53,
        ],
        '2004-12-20' => [
            2004,
            2004,
            52,
            52,
            52,
            53,
        ],
        '2004-12-21' => [
            2004,
            2004,
            52,
            52,
            52,
            53,
        ],
        '2004-12-22' => [
            2004,
            2004,
            52,
            52,
            52,
            53,
        ],
        '2004-12-23' => [
            2004,
            2004,
            52,
            52,
            52,
            53,
        ],
        '2004-12-24' => [
            2004,
            2004,
            52,
            52,
            52,
            53,
        ],
        '2004-12-25' => [
            2004,
            2004,
            52,
            52,
            52,
            53,
        ],
        '2004-12-26' => [
            2005,
            2004,
            1,
            52,
            52,
            53,
        ],
        '2004-12-27' => [
            2005,
            2004,
            1,
            53,
            52,
            53,
        ],
        '2004-12-28' => [
            2005,
            2004,
            1,
            53,
            52,
            53,
        ],
        '2004-12-29' => [
            2005,
            2004,
            1,
            53,
            52,
            53,
        ],
        '2004-12-30' => [
            2005,
            2004,
            1,
            53,
            52,
            53,
        ],
        '2004-12-31' => [
            2005,
            2004,
            1,
            53,
            52,
            53,
        ],
        '2005-01-01' => [
            2005,
            2004,
            1,
            53,
            53,
            52,
        ],
        '2005-01-02' => [
            2005,
            2004,
            2,
            53,
            53,
            52,
        ],
        '2005-01-03' => [
            2005,
            2005,
            2,
            1,
            53,
            52,
        ],
        '2005-01-04' => [
            2005,
            2005,
            2,
            1,
            53,
            52,
        ],
        '2005-01-05' => [
            2005,
            2005,
            2,
            1,
            53,
            52,
        ],
        '2005-01-06' => [
            2005,
            2005,
            2,
            1,
            53,
            52,
        ],
        '2005-01-07' => [
            2005,
            2005,
            2,
            1,
            53,
            52,
        ],
        '2005-01-08' => [
            2005,
            2005,
            2,
            1,
            53,
            52,
        ],
        '2005-01-09' => [
            2005,
            2005,
            3,
            1,
            53,
            52,
        ],
        '2005-01-10' => [
            2005,
            2005,
            3,
            2,
            53,
            52,
        ],
        '2005-12-20' => [
            2005,
            2005,
            52,
            51,
            53,
            52,
        ],
        '2005-12-21' => [
            2005,
            2005,
            52,
            51,
            53,
            52,
        ],
        '2005-12-22' => [
            2005,
            2005,
            52,
            51,
            53,
            52,
        ],
        '2005-12-23' => [
            2005,
            2005,
            52,
            51,
            53,
            52,
        ],
        '2005-12-24' => [
            2005,
            2005,
            52,
            51,
            53,
            52,
        ],
        '2005-12-25' => [
            2005,
            2005,
            53,
            51,
            53,
            52,
        ],
        '2005-12-26' => [
            2005,
            2005,
            53,
            52,
            53,
            52,
        ],
        '2005-12-27' => [
            2005,
            2005,
            53,
            52,
            53,
            52,
        ],
        '2005-12-28' => [
            2005,
            2005,
            53,
            52,
            53,
            52,
        ],
        '2005-12-29' => [
            2005,
            2005,
            53,
            52,
            53,
            52,
        ],
        '2005-12-30' => [
            2005,
            2005,
            53,
            52,
            53,
            52,
        ],
        '2005-12-31' => [
            2005,
            2005,
            53,
            52,
            53,
            52,
        ],
        '2006-01-01' => [
            2006,
            2005,
            1,
            52,
            52,
            52,
        ],
        '2006-01-02' => [
            2006,
            2006,
            1,
            1,
            52,
            52,
        ],
        '2006-01-03' => [
            2006,
            2006,
            1,
            1,
            52,
            52,
        ],
        '2006-01-04' => [
            2006,
            2006,
            1,
            1,
            52,
            52,
        ],
        '2006-01-05' => [
            2006,
            2006,
            1,
            1,
            52,
            52,
        ],
        '2006-01-06' => [
            2006,
            2006,
            1,
            1,
            52,
            52,
        ],
        '2006-01-07' => [
            2006,
            2006,
            1,
            1,
            52,
            52,
        ],
        '2006-01-08' => [
            2006,
            2006,
            2,
            1,
            52,
            52,
        ],
        '2006-01-09' => [
            2006,
            2006,
            2,
            2,
            52,
            52,
        ],
        '2006-01-10' => [
            2006,
            2006,
            2,
            2,
            52,
            52,
        ],
        '2006-12-20' => [
            2006,
            2006,
            51,
            51,
            52,
            52,
        ],
        '2006-12-21' => [
            2006,
            2006,
            51,
            51,
            52,
            52,
        ],
        '2006-12-22' => [
            2006,
            2006,
            51,
            51,
            52,
            52,
        ],
        '2006-12-23' => [
            2006,
            2006,
            51,
            51,
            52,
            52,
        ],
        '2006-12-24' => [
            2006,
            2006,
            52,
            51,
            52,
            52,
        ],
        '2006-12-25' => [
            2006,
            2006,
            52,
            52,
            52,
            52,
        ],
        '2006-12-26' => [
            2006,
            2006,
            52,
            52,
            52,
            52,
        ],
        '2006-12-27' => [
            2006,
            2006,
            52,
            52,
            52,
            52,
        ],
        '2006-12-28' => [
            2006,
            2006,
            52,
            52,
            52,
            52,
        ],
        '2006-12-29' => [
            2006,
            2006,
            52,
            52,
            52,
            52,
        ],
        '2006-12-30' => [
            2006,
            2006,
            52,
            52,
            52,
            52,
        ],
        '2006-12-31' => [
            2007,
            2006,
            1,
            52,
            52,
            52,
        ],
        '2007-01-01' => [
            2007,
            2007,
            1,
            1,
            52,
            52,
        ],
        '2007-01-02' => [
            2007,
            2007,
            1,
            1,
            52,
            52,
        ],
        '2007-01-03' => [
            2007,
            2007,
            1,
            1,
            52,
            52,
        ],
        '2007-01-04' => [
            2007,
            2007,
            1,
            1,
            52,
            52,
        ],
        '2007-01-05' => [
            2007,
            2007,
            1,
            1,
            52,
            52,
        ],
        '2007-01-06' => [
            2007,
            2007,
            1,
            1,
            52,
            52,
        ],
        '2007-01-07' => [
            2007,
            2007,
            2,
            1,
            52,
            52,
        ],
        '2007-01-08' => [
            2007,
            2007,
            2,
            2,
            52,
            52,
        ],
        '2007-01-09' => [
            2007,
            2007,
            2,
            2,
            52,
            52,
        ],
        '2007-01-10' => [
            2007,
            2007,
            2,
            2,
            52,
            52,
        ],
        '2007-12-20' => [
            2007,
            2007,
            51,
            51,
            52,
            52,
        ],
        '2007-12-21' => [
            2007,
            2007,
            51,
            51,
            52,
            52,
        ],
        '2007-12-22' => [
            2007,
            2007,
            51,
            51,
            52,
            52,
        ],
        '2007-12-23' => [
            2007,
            2007,
            52,
            51,
            52,
            52,
        ],
        '2007-12-24' => [
            2007,
            2007,
            52,
            52,
            52,
            52,
        ],
        '2007-12-25' => [
            2007,
            2007,
            52,
            52,
            52,
            52,
        ],
        '2007-12-26' => [
            2007,
            2007,
            52,
            52,
            52,
            52,
        ],
        '2007-12-27' => [
            2007,
            2007,
            52,
            52,
            52,
            52,
        ],
        '2007-12-28' => [
            2007,
            2007,
            52,
            52,
            52,
            52,
        ],
        '2007-12-29' => [
            2007,
            2007,
            52,
            52,
            52,
            52,
        ],
        '2007-12-30' => [
            2008,
            2007,
            1,
            52,
            52,
            52,
        ],
        '2007-12-31' => [
            2008,
            2008,
            1,
            1,
            52,
            52,
        ],
        '2008-01-01' => [
            2008,
            2008,
            1,
            1,
            52,
            52,
        ],
        '2008-01-02' => [
            2008,
            2008,
            1,
            1,
            52,
            52,
        ],
        '2008-01-03' => [
            2008,
            2008,
            1,
            1,
            52,
            52,
        ],
        '2008-01-04' => [
            2008,
            2008,
            1,
            1,
            52,
            52,
        ],
        '2008-01-05' => [
            2008,
            2008,
            1,
            1,
            52,
            52,
        ],
        '2008-01-06' => [
            2008,
            2008,
            2,
            1,
            52,
            52,
        ],
        '2008-01-07' => [
            2008,
            2008,
            2,
            2,
            52,
            52,
        ],
        '2008-01-08' => [
            2008,
            2008,
            2,
            2,
            52,
            52,
        ],
        '2008-01-09' => [
            2008,
            2008,
            2,
            2,
            52,
            52,
        ],
        '2008-01-10' => [
            2008,
            2008,
            2,
            2,
            52,
            52,
        ],
        '2008-12-20' => [
            2008,
            2008,
            51,
            51,
            52,
            52,
        ],
        '2008-12-21' => [
            2008,
            2008,
            52,
            51,
            52,
            52,
        ],
        '2008-12-22' => [
            2008,
            2008,
            52,
            52,
            52,
            52,
        ],
        '2008-12-23' => [
            2008,
            2008,
            52,
            52,
            52,
            52,
        ],
        '2008-12-24' => [
            2008,
            2008,
            52,
            52,
            52,
            52,
        ],
        '2008-12-25' => [
            2008,
            2008,
            52,
            52,
            52,
            52,
        ],
        '2008-12-26' => [
            2008,
            2008,
            52,
            52,
            52,
            52,
        ],
        '2008-12-27' => [
            2008,
            2008,
            52,
            52,
            52,
            52,
        ],
        '2008-12-28' => [
            2009,
            2008,
            1,
            52,
            52,
            52,
        ],
        '2008-12-29' => [
            2009,
            2009,
            1,
            1,
            52,
            52,
        ],
        '2008-12-30' => [
            2009,
            2009,
            1,
            1,
            52,
            52,
        ],
        '2008-12-31' => [
            2009,
            2009,
            1,
            1,
            52,
            52,
        ],
        '2009-01-01' => [
            2009,
            2009,
            1,
            1,
            52,
            53,
        ],
        '2009-01-02' => [
            2009,
            2009,
            1,
            1,
            52,
            53,
        ],
        '2009-01-03' => [
            2009,
            2009,
            1,
            1,
            52,
            53,
        ],
        '2009-01-04' => [
            2009,
            2009,
            2,
            1,
            52,
            53,
        ],
        '2009-01-05' => [
            2009,
            2009,
            2,
            2,
            52,
            53,
        ],
        '2009-01-06' => [
            2009,
            2009,
            2,
            2,
            52,
            53,
        ],
        '2009-01-07' => [
            2009,
            2009,
            2,
            2,
            52,
            53,
        ],
        '2009-01-08' => [
            2009,
            2009,
            2,
            2,
            52,
            53,
        ],
        '2009-01-09' => [
            2009,
            2009,
            2,
            2,
            52,
            53,
        ],
        '2009-01-10' => [
            2009,
            2009,
            2,
            2,
            52,
            53,
        ],
        '2009-12-20' => [
            2009,
            2009,
            52,
            51,
            52,
            53,
        ],
        '2009-12-21' => [
            2009,
            2009,
            52,
            52,
            52,
            53,
        ],
        '2009-12-22' => [
            2009,
            2009,
            52,
            52,
            52,
            53,
        ],
        '2009-12-23' => [
            2009,
            2009,
            52,
            52,
            52,
            53,
        ],
        '2009-12-24' => [
            2009,
            2009,
            52,
            52,
            52,
            53,
        ],
        '2009-12-25' => [
            2009,
            2009,
            52,
            52,
            52,
            53,
        ],
        '2009-12-26' => [
            2009,
            2009,
            52,
            52,
            52,
            53,
        ],
        '2009-12-27' => [
            2010,
            2009,
            1,
            52,
            52,
            53,
        ],
        '2009-12-28' => [
            2010,
            2009,
            1,
            53,
            52,
            53,
        ],
        '2009-12-29' => [
            2010,
            2009,
            1,
            53,
            52,
            53,
        ],
        '2009-12-30' => [
            2010,
            2009,
            1,
            53,
            52,
            53,
        ],
        '2009-12-31' => [
            2010,
            2009,
            1,
            53,
            52,
            53,
        ],
        '2010-01-01' => [
            2010,
            2009,
            1,
            53,
            52,
            52,
        ],
        '2010-01-02' => [
            2010,
            2009,
            1,
            53,
            52,
            52,
        ],
        '2010-01-03' => [
            2010,
            2009,
            2,
            53,
            52,
            52,
        ],
        '2010-01-04' => [
            2010,
            2010,
            2,
            1,
            52,
            52,
        ],
        '2010-01-05' => [
            2010,
            2010,
            2,
            1,
            52,
            52,
        ],
        '2010-01-06' => [
            2010,
            2010,
            2,
            1,
            52,
            52,
        ],
        '2010-01-07' => [
            2010,
            2010,
            2,
            1,
            52,
            52,
        ],
        '2010-01-08' => [
            2010,
            2010,
            2,
            1,
            52,
            52,
        ],
        '2010-01-09' => [
            2010,
            2010,
            2,
            1,
            52,
            52,
        ],
        '2010-01-10' => [
            2010,
            2010,
            3,
            1,
            52,
            52,
        ],
        '2010-12-20' => [
            2010,
            2010,
            52,
            51,
            52,
            52,
        ],
        '2010-12-21' => [
            2010,
            2010,
            52,
            51,
            52,
            52,
        ],
        '2010-12-22' => [
            2010,
            2010,
            52,
            51,
            52,
            52,
        ],
        '2010-12-23' => [
            2010,
            2010,
            52,
            51,
            52,
            52,
        ],
        '2010-12-24' => [
            2010,
            2010,
            52,
            51,
            52,
            52,
        ],
        '2010-12-25' => [
            2010,
            2010,
            52,
            51,
            52,
            52,
        ],
        '2010-12-26' => [
            2011,
            2010,
            1,
            51,
            52,
            52,
        ],
        '2010-12-27' => [
            2011,
            2010,
            1,
            52,
            52,
            52,
        ],
        '2010-12-28' => [
            2011,
            2010,
            1,
            52,
            52,
            52,
        ],
        '2010-12-29' => [
            2011,
            2010,
            1,
            52,
            52,
            52,
        ],
        '2010-12-30' => [
            2011,
            2010,
            1,
            52,
            52,
            52,
        ],
        '2010-12-31' => [
            2011,
            2010,
            1,
            52,
            52,
            52,
        ],
        '2011-01-01' => [
            2011,
            2010,
            1,
            52,
            53,
            52,
        ],
        '2011-01-02' => [
            2011,
            2010,
            2,
            52,
            53,
            52,
        ],
        '2011-01-03' => [
            2011,
            2011,
            2,
            1,
            53,
            52,
        ],
        '2011-01-04' => [
            2011,
            2011,
            2,
            1,
            53,
            52,
        ],
        '2011-01-05' => [
            2011,
            2011,
            2,
            1,
            53,
            52,
        ],
        '2011-01-06' => [
            2011,
            2011,
            2,
            1,
            53,
            52,
        ],
        '2011-01-07' => [
            2011,
            2011,
            2,
            1,
            53,
            52,
        ],
        '2011-01-08' => [
            2011,
            2011,
            2,
            1,
            53,
            52,
        ],
        '2011-01-09' => [
            2011,
            2011,
            3,
            1,
            53,
            52,
        ],
        '2011-01-10' => [
            2011,
            2011,
            3,
            2,
            53,
            52,
        ],
        '2011-12-20' => [
            2011,
            2011,
            52,
            51,
            53,
            52,
        ],
        '2011-12-21' => [
            2011,
            2011,
            52,
            51,
            53,
            52,
        ],
        '2011-12-22' => [
            2011,
            2011,
            52,
            51,
            53,
            52,
        ],
        '2011-12-23' => [
            2011,
            2011,
            52,
            51,
            53,
            52,
        ],
        '2011-12-24' => [
            2011,
            2011,
            52,
            51,
            53,
            52,
        ],
        '2011-12-25' => [
            2011,
            2011,
            53,
            51,
            53,
            52,
        ],
        '2011-12-26' => [
            2011,
            2011,
            53,
            52,
            53,
            52,
        ],
        '2011-12-27' => [
            2011,
            2011,
            53,
            52,
            53,
            52,
        ],
        '2011-12-28' => [
            2011,
            2011,
            53,
            52,
            53,
            52,
        ],
        '2011-12-29' => [
            2011,
            2011,
            53,
            52,
            53,
            52,
        ],
        '2011-12-30' => [
            2011,
            2011,
            53,
            52,
            53,
            52,
        ],
        '2011-12-31' => [
            2011,
            2011,
            53,
            52,
            53,
            52,
        ],
        '2012-01-01' => [
            2012,
            2011,
            1,
            52,
            52,
            52,
        ],
        '2012-01-02' => [
            2012,
            2012,
            1,
            1,
            52,
            52,
        ],
        '2012-01-03' => [
            2012,
            2012,
            1,
            1,
            52,
            52,
        ],
        '2012-01-04' => [
            2012,
            2012,
            1,
            1,
            52,
            52,
        ],
        '2012-01-05' => [
            2012,
            2012,
            1,
            1,
            52,
            52,
        ],
        '2012-01-06' => [
            2012,
            2012,
            1,
            1,
            52,
            52,
        ],
        '2012-01-07' => [
            2012,
            2012,
            1,
            1,
            52,
            52,
        ],
        '2012-01-08' => [
            2012,
            2012,
            2,
            1,
            52,
            52,
        ],
        '2012-01-09' => [
            2012,
            2012,
            2,
            2,
            52,
            52,
        ],
        '2012-01-10' => [
            2012,
            2012,
            2,
            2,
            52,
            52,
        ],
        '2012-12-20' => [
            2012,
            2012,
            51,
            51,
            52,
            52,
        ],
        '2012-12-21' => [
            2012,
            2012,
            51,
            51,
            52,
            52,
        ],
        '2012-12-22' => [
            2012,
            2012,
            51,
            51,
            52,
            52,
        ],
        '2012-12-23' => [
            2012,
            2012,
            52,
            51,
            52,
            52,
        ],
        '2012-12-24' => [
            2012,
            2012,
            52,
            52,
            52,
            52,
        ],
        '2012-12-25' => [
            2012,
            2012,
            52,
            52,
            52,
            52,
        ],
        '2012-12-26' => [
            2012,
            2012,
            52,
            52,
            52,
            52,
        ],
        '2012-12-27' => [
            2012,
            2012,
            52,
            52,
            52,
            52,
        ],
        '2012-12-28' => [
            2012,
            2012,
            52,
            52,
            52,
            52,
        ],
        '2012-12-29' => [
            2012,
            2012,
            52,
            52,
            52,
            52,
        ],
        '2012-12-30' => [
            2013,
            2012,
            1,
            52,
            52,
            52,
        ],
        '2012-12-31' => [
            2013,
            2013,
            1,
            1,
            52,
            52,
        ],
        '2013-01-01' => [
            2013,
            2013,
            1,
            1,
            52,
            52,
        ],
        '2013-01-02' => [
            2013,
            2013,
            1,
            1,
            52,
            52,
        ],
        '2013-01-03' => [
            2013,
            2013,
            1,
            1,
            52,
            52,
        ],
        '2013-01-04' => [
            2013,
            2013,
            1,
            1,
            52,
            52,
        ],
        '2013-01-05' => [
            2013,
            2013,
            1,
            1,
            52,
            52,
        ],
        '2013-01-06' => [
            2013,
            2013,
            2,
            1,
            52,
            52,
        ],
        '2013-01-07' => [
            2013,
            2013,
            2,
            2,
            52,
            52,
        ],
        '2013-01-08' => [
            2013,
            2013,
            2,
            2,
            52,
            52,
        ],
        '2013-01-09' => [
            2013,
            2013,
            2,
            2,
            52,
            52,
        ],
        '2013-01-10' => [
            2013,
            2013,
            2,
            2,
            52,
            52,
        ],
        '2013-12-20' => [
            2013,
            2013,
            51,
            51,
            52,
            52,
        ],
        '2013-12-21' => [
            2013,
            2013,
            51,
            51,
            52,
            52,
        ],
        '2013-12-22' => [
            2013,
            2013,
            52,
            51,
            52,
            52,
        ],
        '2013-12-23' => [
            2013,
            2013,
            52,
            52,
            52,
            52,
        ],
        '2013-12-24' => [
            2013,
            2013,
            52,
            52,
            52,
            52,
        ],
        '2013-12-25' => [
            2013,
            2013,
            52,
            52,
            52,
            52,
        ],
        '2013-12-26' => [
            2013,
            2013,
            52,
            52,
            52,
            52,
        ],
        '2013-12-27' => [
            2013,
            2013,
            52,
            52,
            52,
            52,
        ],
        '2013-12-28' => [
            2013,
            2013,
            52,
            52,
            52,
            52,
        ],
        '2013-12-29' => [
            2014,
            2013,
            1,
            52,
            52,
            52,
        ],
        '2013-12-30' => [
            2014,
            2014,
            1,
            1,
            52,
            52,
        ],
        '2013-12-31' => [
            2014,
            2014,
            1,
            1,
            52,
            52,
        ],
        '2014-01-01' => [
            2014,
            2014,
            1,
            1,
            52,
            52,
        ],
        '2014-01-02' => [
            2014,
            2014,
            1,
            1,
            52,
            52,
        ],
        '2014-01-03' => [
            2014,
            2014,
            1,
            1,
            52,
            52,
        ],
        '2014-01-04' => [
            2014,
            2014,
            1,
            1,
            52,
            52,
        ],
        '2014-01-05' => [
            2014,
            2014,
            2,
            1,
            52,
            52,
        ],
        '2014-01-06' => [
            2014,
            2014,
            2,
            2,
            52,
            52,
        ],
        '2014-01-07' => [
            2014,
            2014,
            2,
            2,
            52,
            52,
        ],
        '2014-01-08' => [
            2014,
            2014,
            2,
            2,
            52,
            52,
        ],
        '2014-01-09' => [
            2014,
            2014,
            2,
            2,
            52,
            52,
        ],
        '2014-01-10' => [
            2014,
            2014,
            2,
            2,
            52,
            52,
        ],
        '2014-12-20' => [
            2014,
            2014,
            51,
            51,
            52,
            52,
        ],
        '2014-12-21' => [
            2014,
            2014,
            52,
            51,
            52,
            52,
        ],
        '2014-12-22' => [
            2014,
            2014,
            52,
            52,
            52,
            52,
        ],
        '2014-12-23' => [
            2014,
            2014,
            52,
            52,
            52,
            52,
        ],
        '2014-12-24' => [
            2014,
            2014,
            52,
            52,
            52,
            52,
        ],
        '2014-12-25' => [
            2014,
            2014,
            52,
            52,
            52,
            52,
        ],
        '2014-12-26' => [
            2014,
            2014,
            52,
            52,
            52,
            52,
        ],
        '2014-12-27' => [
            2014,
            2014,
            52,
            52,
            52,
            52,
        ],
        '2014-12-28' => [
            2015,
            2014,
            1,
            52,
            52,
            52,
        ],
        '2014-12-29' => [
            2015,
            2015,
            1,
            1,
            52,
            52,
        ],
        '2014-12-30' => [
            2015,
            2015,
            1,
            1,
            52,
            52,
        ],
        '2014-12-31' => [
            2015,
            2015,
            1,
            1,
            52,
            52,
        ],
        '2015-01-01' => [
            2015,
            2015,
            1,
            1,
            52,
            53,
        ],
        '2015-01-02' => [
            2015,
            2015,
            1,
            1,
            52,
            53,
        ],
        '2015-01-03' => [
            2015,
            2015,
            1,
            1,
            52,
            53,
        ],
        '2015-01-04' => [
            2015,
            2015,
            2,
            1,
            52,
            53,
        ],
        '2015-01-05' => [
            2015,
            2015,
            2,
            2,
            52,
            53,
        ],
        '2015-01-06' => [
            2015,
            2015,
            2,
            2,
            52,
            53,
        ],
        '2015-01-07' => [
            2015,
            2015,
            2,
            2,
            52,
            53,
        ],
        '2015-01-08' => [
            2015,
            2015,
            2,
            2,
            52,
            53,
        ],
        '2015-01-09' => [
            2015,
            2015,
            2,
            2,
            52,
            53,
        ],
        '2015-01-10' => [
            2015,
            2015,
            2,
            2,
            52,
            53,
        ],
        '2015-12-20' => [
            2015,
            2015,
            52,
            51,
            52,
            53,
        ],
        '2015-12-21' => [
            2015,
            2015,
            52,
            52,
            52,
            53,
        ],
        '2015-12-22' => [
            2015,
            2015,
            52,
            52,
            52,
            53,
        ],
        '2015-12-23' => [
            2015,
            2015,
            52,
            52,
            52,
            53,
        ],
        '2015-12-24' => [
            2015,
            2015,
            52,
            52,
            52,
            53,
        ],
        '2015-12-25' => [
            2015,
            2015,
            52,
            52,
            52,
            53,
        ],
        '2015-12-26' => [
            2015,
            2015,
            52,
            52,
            52,
            53,
        ],
        '2015-12-27' => [
            2016,
            2015,
            1,
            52,
            52,
            53,
        ],
        '2015-12-28' => [
            2016,
            2015,
            1,
            53,
            52,
            53,
        ],
        '2015-12-29' => [
            2016,
            2015,
            1,
            53,
            52,
            53,
        ],
        '2015-12-30' => [
            2016,
            2015,
            1,
            53,
            52,
            53,
        ],
        '2015-12-31' => [
            2016,
            2015,
            1,
            53,
            52,
            53,
        ],
        '2016-01-01' => [
            2016,
            2015,
            1,
            53,
            53,
            52,
        ],
        '2016-01-02' => [
            2016,
            2015,
            1,
            53,
            53,
            52,
        ],
        '2016-01-03' => [
            2016,
            2015,
            2,
            53,
            53,
            52,
        ],
        '2016-01-04' => [
            2016,
            2016,
            2,
            1,
            53,
            52,
        ],
        '2016-01-05' => [
            2016,
            2016,
            2,
            1,
            53,
            52,
        ],
        '2016-01-06' => [
            2016,
            2016,
            2,
            1,
            53,
            52,
        ],
        '2016-01-07' => [
            2016,
            2016,
            2,
            1,
            53,
            52,
        ],
        '2016-01-08' => [
            2016,
            2016,
            2,
            1,
            53,
            52,
        ],
        '2016-01-09' => [
            2016,
            2016,
            2,
            1,
            53,
            52,
        ],
        '2016-01-10' => [
            2016,
            2016,
            3,
            1,
            53,
            52,
        ],
        '2016-12-20' => [
            2016,
            2016,
            52,
            51,
            53,
            52,
        ],
        '2016-12-21' => [
            2016,
            2016,
            52,
            51,
            53,
            52,
        ],
        '2016-12-22' => [
            2016,
            2016,
            52,
            51,
            53,
            52,
        ],
        '2016-12-23' => [
            2016,
            2016,
            52,
            51,
            53,
            52,
        ],
        '2016-12-24' => [
            2016,
            2016,
            52,
            51,
            53,
            52,
        ],
        '2016-12-25' => [
            2016,
            2016,
            53,
            51,
            53,
            52,
        ],
        '2016-12-26' => [
            2016,
            2016,
            53,
            52,
            53,
            52,
        ],
        '2016-12-27' => [
            2016,
            2016,
            53,
            52,
            53,
            52,
        ],
        '2016-12-28' => [
            2016,
            2016,
            53,
            52,
            53,
            52,
        ],
        '2016-12-29' => [
            2016,
            2016,
            53,
            52,
            53,
            52,
        ],
        '2016-12-30' => [
            2016,
            2016,
            53,
            52,
            53,
            52,
        ],
        '2016-12-31' => [
            2016,
            2016,
            53,
            52,
            53,
            52,
        ],
        '2017-01-01' => [
            2017,
            2016,
            1,
            52,
            52,
            52,
        ],
        '2017-01-02' => [
            2017,
            2017,
            1,
            1,
            52,
            52,
        ],
        '2017-01-03' => [
            2017,
            2017,
            1,
            1,
            52,
            52,
        ],
        '2017-01-04' => [
            2017,
            2017,
            1,
            1,
            52,
            52,
        ],
        '2017-01-05' => [
            2017,
            2017,
            1,
            1,
            52,
            52,
        ],
        '2017-01-06' => [
            2017,
            2017,
            1,
            1,
            52,
            52,
        ],
        '2017-01-07' => [
            2017,
            2017,
            1,
            1,
            52,
            52,
        ],
        '2017-01-08' => [
            2017,
            2017,
            2,
            1,
            52,
            52,
        ],
        '2017-01-09' => [
            2017,
            2017,
            2,
            2,
            52,
            52,
        ],
        '2017-01-10' => [
            2017,
            2017,
            2,
            2,
            52,
            52,
        ],
        '2017-12-20' => [
            2017,
            2017,
            51,
            51,
            52,
            52,
        ],
        '2017-12-21' => [
            2017,
            2017,
            51,
            51,
            52,
            52,
        ],
        '2017-12-22' => [
            2017,
            2017,
            51,
            51,
            52,
            52,
        ],
        '2017-12-23' => [
            2017,
            2017,
            51,
            51,
            52,
            52,
        ],
        '2017-12-24' => [
            2017,
            2017,
            52,
            51,
            52,
            52,
        ],
        '2017-12-25' => [
            2017,
            2017,
            52,
            52,
            52,
            52,
        ],
        '2017-12-26' => [
            2017,
            2017,
            52,
            52,
            52,
            52,
        ],
        '2017-12-27' => [
            2017,
            2017,
            52,
            52,
            52,
            52,
        ],
        '2017-12-28' => [
            2017,
            2017,
            52,
            52,
            52,
            52,
        ],
        '2017-12-29' => [
            2017,
            2017,
            52,
            52,
            52,
            52,
        ],
        '2017-12-30' => [
            2017,
            2017,
            52,
            52,
            52,
            52,
        ],
        '2017-12-31' => [
            2018,
            2017,
            1,
            52,
            52,
            52,
        ],
        '2018-01-01' => [
            2018,
            2018,
            1,
            1,
            52,
            52,
        ],
        '2018-01-02' => [
            2018,
            2018,
            1,
            1,
            52,
            52,
        ],
        '2018-01-03' => [
            2018,
            2018,
            1,
            1,
            52,
            52,
        ],
        '2018-01-04' => [
            2018,
            2018,
            1,
            1,
            52,
            52,
        ],
        '2018-01-05' => [
            2018,
            2018,
            1,
            1,
            52,
            52,
        ],
        '2018-01-06' => [
            2018,
            2018,
            1,
            1,
            52,
            52,
        ],
        '2018-01-07' => [
            2018,
            2018,
            2,
            1,
            52,
            52,
        ],
        '2018-01-08' => [
            2018,
            2018,
            2,
            2,
            52,
            52,
        ],
        '2018-01-09' => [
            2018,
            2018,
            2,
            2,
            52,
            52,
        ],
        '2018-01-10' => [
            2018,
            2018,
            2,
            2,
            52,
            52,
        ],
        '2018-12-20' => [
            2018,
            2018,
            51,
            51,
            52,
            52,
        ],
        '2018-12-21' => [
            2018,
            2018,
            51,
            51,
            52,
            52,
        ],
        '2018-12-22' => [
            2018,
            2018,
            51,
            51,
            52,
            52,
        ],
        '2018-12-23' => [
            2018,
            2018,
            52,
            51,
            52,
            52,
        ],
        '2018-12-24' => [
            2018,
            2018,
            52,
            52,
            52,
            52,
        ],
        '2018-12-25' => [
            2018,
            2018,
            52,
            52,
            52,
            52,
        ],
        '2018-12-26' => [
            2018,
            2018,
            52,
            52,
            52,
            52,
        ],
        '2018-12-27' => [
            2018,
            2018,
            52,
            52,
            52,
            52,
        ],
        '2018-12-28' => [
            2018,
            2018,
            52,
            52,
            52,
            52,
        ],
        '2018-12-29' => [
            2018,
            2018,
            52,
            52,
            52,
            52,
        ],
        '2018-12-30' => [
            2019,
            2018,
            1,
            52,
            52,
            52,
        ],
        '2018-12-31' => [
            2019,
            2019,
            1,
            1,
            52,
            52,
        ],
        '2019-01-01' => [
            2019,
            2019,
            1,
            1,
            52,
            52,
        ],
        '2019-01-02' => [
            2019,
            2019,
            1,
            1,
            52,
            52,
        ],
        '2019-01-03' => [
            2019,
            2019,
            1,
            1,
            52,
            52,
        ],
        '2019-01-04' => [
            2019,
            2019,
            1,
            1,
            52,
            52,
        ],
        '2019-01-05' => [
            2019,
            2019,
            1,
            1,
            52,
            52,
        ],
        '2019-01-06' => [
            2019,
            2019,
            2,
            1,
            52,
            52,
        ],
        '2019-01-07' => [
            2019,
            2019,
            2,
            2,
            52,
            52,
        ],
        '2019-01-08' => [
            2019,
            2019,
            2,
            2,
            52,
            52,
        ],
        '2019-01-09' => [
            2019,
            2019,
            2,
            2,
            52,
            52,
        ],
        '2019-01-10' => [
            2019,
            2019,
            2,
            2,
            52,
            52,
        ],
        '2019-12-20' => [
            2019,
            2019,
            51,
            51,
            52,
            52,
        ],
        '2019-12-21' => [
            2019,
            2019,
            51,
            51,
            52,
            52,
        ],
        '2019-12-22' => [
            2019,
            2019,
            52,
            51,
            52,
            52,
        ],
        '2019-12-23' => [
            2019,
            2019,
            52,
            52,
            52,
            52,
        ],
        '2019-12-24' => [
            2019,
            2019,
            52,
            52,
            52,
            52,
        ],
        '2019-12-25' => [
            2019,
            2019,
            52,
            52,
            52,
            52,
        ],
        '2019-12-26' => [
            2019,
            2019,
            52,
            52,
            52,
            52,
        ],
        '2019-12-27' => [
            2019,
            2019,
            52,
            52,
            52,
            52,
        ],
        '2019-12-28' => [
            2019,
            2019,
            52,
            52,
            52,
            52,
        ],
        '2019-12-29' => [
            2020,
            2019,
            1,
            52,
            52,
            52,
        ],
        '2019-12-30' => [
            2020,
            2020,
            1,
            1,
            52,
            52,
        ],
        '2019-12-31' => [
            2020,
            2020,
            1,
            1,
            52,
            52,
        ],
        '2020-01-01' => [
            2020,
            2020,
            1,
            1,
            52,
            53,
        ],
        '2020-01-02' => [
            2020,
            2020,
            1,
            1,
            52,
            53,
        ],
        '2020-01-03' => [
            2020,
            2020,
            1,
            1,
            52,
            53,
        ],
        '2020-01-04' => [
            2020,
            2020,
            1,
            1,
            52,
            53,
        ],
        '2020-01-05' => [
            2020,
            2020,
            2,
            1,
            52,
            53,
        ],
        '2020-01-06' => [
            2020,
            2020,
            2,
            2,
            52,
            53,
        ],
        '2020-01-07' => [
            2020,
            2020,
            2,
            2,
            52,
            53,
        ],
        '2020-01-08' => [
            2020,
            2020,
            2,
            2,
            52,
            53,
        ],
        '2020-01-09' => [
            2020,
            2020,
            2,
            2,
            52,
            53,
        ],
        '2020-01-10' => [
            2020,
            2020,
            2,
            2,
            52,
            53,
        ],
    ];

    public function testWeekUtils()
    {
        foreach (static::SAMPLE as $date => [$weekYear, $isoWeekYear, $week, $isoWeek, $weeksInYear, $isoWeeksInYear]) {
            $carbon = Carbon::parse("$date 00:00:00");

            $this->assertSame($weekYear, $carbon->weekYear(), "Carbon::parse(\"$date 00:00:00\")->weekYear() should return $weekYear");
            $this->assertSame($isoWeekYear, $carbon->isoWeekYear(), "Carbon::parse(\"$date 00:00:00\")->isoWeekYear() should return $isoWeekYear");
            $this->assertSame($week, $carbon->week(), "Carbon::parse(\"$date 00:00:00\")->week() should return $week");
            $this->assertSame($isoWeek, $carbon->isoWeek(), "Carbon::parse(\"$date 00:00:00\")->isoWeek() should return $isoWeek");
            $this->assertSame($weeksInYear, $carbon->weeksInYear(), "Carbon::parse(\"$date 00:00:00\")->weeksInYear() should return $isoWeek");
            $this->assertSame($isoWeeksInYear, $carbon->isoWeeksInYear(), "Carbon::parse(\"$date 00:00:00\")->isoWeeksInYear() should return $isoWeeksInYear");
        }
    }

    public function testSetters()
    {
        $d = Carbon::parse('2018-01-01');
        $this->assertSame(52, $d->weeksInYear);
        $this->assertSame(52, $d->isoWeeksInYear);

        $d2 = $d->week(3);

        $this->assertNotSame($d, $d2);
        $this->assertSame('2018-01-15', $d2->format('Y-m-d'));

        $d2 = $d2->week(34);

        $this->assertSame('2018-08-20', $d2->format('Y-m-d'));

        $d2 = $d2->week(0);

        $this->assertSame('2017-12-25', $d2->format('Y-m-d'));

        $d = Carbon::parse('2018-01-01');
        $d = $d->week(-1);

        $this->assertSame('2017-12-18', $d->format('Y-m-d'));

        $d = Carbon::parse('2018-01-01');
        $d = $d->week(-5);

        $this->assertSame('2017-11-20', $d->format('Y-m-d'));

        $d = Carbon::parse('2018-01-01');
        $d = $d->week(-55);

        $this->assertSame('2016-12-05', $d->format('Y-m-d'));

        $d = Carbon::parse('2017-01-01');
        $d = $d->week(34);

        $this->assertSame('2017-08-20', $d->format('Y-m-d'));

        $d = Carbon::parse('2017-01-01');
        $d = $d->isoWeek(34);

        $this->assertSame('2016-08-28', $d->format('Y-m-d'));

        $d = Carbon::parse('2017-01-01');
        $d = $d->weekYear(2015);

        $this->assertSame('2014-12-28', $d->format('Y-m-d'));

        $d = Carbon::parse('2012-12-31');
        $d = $d->weekYear(2013);

        $this->assertSame('2012-12-31', $d->format('Y-m-d'));

        $d = Carbon::parse('2012-12-30');
        $d = $d->weekYear(2014);

        $this->assertSame('2013-12-29', $d->format('Y-m-d'));

        $d = Carbon::parse('2015-12-31');
        $d = $d->weekYear(2013);

        $this->assertSame('2013-01-03', $d->format('Y-m-d'));

        $d = Carbon::parse('2017-01-01');
        $d = $d->isoWeekYear(2015);

        $this->assertSame('2015-12-27', $d->format('Y-m-d'));

        $d = $d->dayOfYear(300);

        $this->assertSame('2015-10-27', $d->format('Y-m-d'));

        $d = Carbon::parse('2017-01-01')->locale('fr');
        $d = $d->weekYear(2015);

        $this->assertSame('2015-12-27', $d->format('Y-m-d'));

        $d = Carbon::parse('2017-01-01')->locale('sr');
        $d = $d->weekYear(2017);

        $this->assertSame('2017-01-01', $d->format('Y-m-d'));

        $d = Carbon::parse('2017-01-01')->locale('fr');
        $d = $d->weekYear(2012);

        $this->assertSame('2012-12-30', $d->format('Y-m-d'));

        $d = Carbon::parse('2018-01-01');
        $d = $d->setISODate(2019, 4, 5);
        $this->assertSame('2019-01-25', $d->format('Y-m-d'));
    }

    public function testWeekday()
    {
        $d = Carbon::parse('2018-08-08');
        $this->assertSame(CarbonInterface::WEDNESDAY, $d->weekday());
        $this->assertSame(CarbonInterface::WEDNESDAY, $d->isoWeekday());
        $date = $d->weekday(CarbonInterface::SUNDAY);
        $this->assertSame('08-05', $date->format('m-d'));
        $this->assertSame(CarbonInterface::SUNDAY, $date->weekday());
        $this->assertSame(7, $date->isoWeekday());
        $date = $d->isoWeekday(7);
        $this->assertSame('08-12', $date->format('m-d'));
        $this->assertSame(CarbonInterface::SUNDAY, $date->weekday());
        $this->assertSame(7, $date->isoWeekday());
        $date = $d->weekday(CarbonInterface::MONDAY);
        $this->assertSame('08-06', $date->format('m-d'));
        $this->assertSame(CarbonInterface::MONDAY, $date->weekday());
        $this->assertSame(CarbonInterface::MONDAY, $date->isoWeekday());
        $date = $d->isoWeekday(CarbonInterface::MONDAY);
        $this->assertSame('08-06', $date->format('m-d'));
        $this->assertSame(CarbonInterface::MONDAY, $date->weekday());
        $this->assertSame(CarbonInterface::MONDAY, $date->isoWeekday());
    }

    /**
     * @dataProvider getDaysFromStartOfWeekDataProvider
     */
    public function testGetDaysFromStartOfWeek(string $locale, string $date, int $daysCount)
    {
        $this->assertSame(
            $daysCount,
            Carbon::parse($date)->locale($locale)->getDaysFromStartOfWeek()
        );
    }

    public function getDaysFromStartOfWeekDataProvider(): array
    {
        return [
            'Monday en_US' => ['en_US', '2022-11-21', 1],
            'Monday late en_US' => ['en_US', '2022-11-21 23:59', 1],
            'Tuesday en_US' => ['en_US', '2022-11-22 00:01', 2],
            'Thursday en_US' => ['en_US', '2022-11-24', 4],
            'Saturday en_US' => ['en_US', '2022-11-26 23:59:59.999999', 6],
            'Sunday en_US' => ['en_US', '2022-11-27 00:00:00', 0],
            'Monday fr_FR' => ['fr_FR', '2022-11-21', 0],
            'Monday late fr_FR' => ['fr_FR', '2022-11-21 23:59', 0],
            'Tuesday fr_FR' => ['fr_FR', '2022-11-22 00:01', 1],
            'Thursday fr_FR' => ['fr_FR', '2022-11-24', 3],
            'Saturday fr_FR' => ['fr_FR', '2022-11-26 23:59:59.999999', 5],
            'Sunday fr_FR' => ['fr_FR', '2022-11-27 00:00:00', 6],
            'Monday ku' => ['ku', '2022-11-21', 2],
            'Monday late ku' => ['ku', '2022-11-21 23:59', 2],
            'Tuesday ku' => ['ku', '2022-11-22 00:01', 3],
            'Thursday ku' => ['ku', '2022-11-24', 5],
            'Saturday ku' => ['ku', '2022-11-26 23:59:59.999999', 0],
            'Sunday ku' => ['ku', '2022-11-27 00:00:00', 1],
        ];
    }

    /**
     * @dataProvider getDaysFromStartOfWeekDataProviderExplicit
     */
    public function testGetDaysFromStartOfWeekExplicit(int $start, string $date, int $daysCount)
    {
        static $locales = [null, 'pt_BR', 'de_CH', 'ar_MA'];
        $carbon = Carbon::parse($date);
        $locale = $locales[array_rand($locales)];

        if ($locale) {
            $carbon = $carbon->locale($locale);
        }

        $this->assertSame($daysCount, $carbon->getDaysFromStartOfWeek($start));
    }

    public function getDaysFromStartOfWeekDataProviderExplicit(): array
    {
        return [
            'Monday 0' => [0, '2022-11-21', 1],
            'Monday late 0' => [0, '2022-11-21 23:59', 1],
            'Tuesday 0' => [0, '2022-11-22 00:01', 2],
            'Thursday 0' => [0, '2022-11-24', 4],
            'Saturday 0' => [0, '2022-11-26 23:59:59.999999', 6],
            'Sunday 0' => [0, '2022-11-27 00:00:00', 0],
            'Monday 1' => [1, '2022-11-21', 0],
            'Monday late 1' => [1, '2022-11-21 23:59', 0],
            'Tuesday 1' => [1, '2022-11-22 00:01', 1],
            'Thursday 1' => [1, '2022-11-24', 3],
            'Saturday 1' => [1, '2022-11-26 23:59:59.999999', 5],
            'Sunday 1' => [1, '2022-11-27 00:00:00', 6],
            'Monday 6' => [6, '2022-11-21', 2],
            'Monday late 6' => [6, '2022-11-21 23:59', 2],
            'Tuesday 6' => [6, '2022-11-22 00:01', 3],
            'Thursday 6' => [6, '2022-11-24', 5],
            'Saturday 6' => [6, '2022-11-26 23:59:59.999999', 0],
            'Sunday 6' => [6, '2022-11-27 00:00:00', 1],
        ];
    }

    public function testSetDaysFromStartOfWeek()
    {
        $this->assertSame(
            '2022-11-29 23:59:59.999999',
            Carbon::parse('2022-11-26 23:59:59.999999')
                ->locale('ar_MA')
                ->setDaysFromStartOfWeek(3)
                ->format('Y-m-d H:i:s.u')
        );
        $this->assertSame(
            '2022-11-24 12:34:56.123456',
            Carbon::parse('2022-11-24 12:34:56.123456')
                ->locale('fr_FR')
                ->setDaysFromStartOfWeek(3)
                ->format('Y-m-d H:i:s.u')
        );
        $this->assertSame(
            '2022-11-23 12:34:56.123456',
            Carbon::parse('2022-11-24 12:34:56.123456')
                ->locale('en_US')
                ->setDaysFromStartOfWeek(3)
                ->format('Y-m-d H:i:s.u')
        );
        $this->assertSame(
            '2022-11-27 12:34:56.123456',
            Carbon::parse('2022-11-24 12:34:56.123456')
                ->locale('en_US')
                ->setDaysFromStartOfWeek(3, 4)
                ->format('Y-m-d H:i:s.u')
        );
    }
}
