; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx700 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx803 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX9-NODL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx906 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX9-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1011 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX10-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1012 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX10-DL %s

; add(mul(S0.x, S1.y),
;     add (mul (S0.y, S1.y), S3)) -> v_dot2_{I|U}32_{I|U}16(S1, S2, S3)

define amdgpu_kernel void @udot2(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v1, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, s3
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot2_u32_u16 v0, v3, v2, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot2_u32_u16 v1, v2, v1, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                 <2 x i16> addrspace(1)* %src2,
                                 i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul nuw i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul nuw i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Support this pattern
;      add(S3,
;          add (mul (S0.y, S1.y), mul (S0.y, S1.y))) -> v_dot2_{I|U}32_{I|U}16(S1, S2, S3)
define amdgpu_kernel void @udot2_MulMul(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_MulMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    v_mul_u32_u24_e32 v0, v0, v2
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v1, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, s5, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_MulMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mul_u32_u24_sdwa v1, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_MulMul:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, v3, s0
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_MulMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, v3, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_MulMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, v0, s2
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                        <2 x i16> addrspace(1)* %src2,
                                        i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul nuw i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul nuw i32 %conv4, %conv3
  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %mul1
  %add6 = add i32 %add, %s3
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @idot2(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: idot2:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v3, v0, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v0, v0, v2, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v3, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot2:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v0, v0, v3, s2
; GFX8-NEXT:    v_mad_i32_i24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot2:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot2:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot2_i32_i16 v0, v3, v2, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot2:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot2_i32_i16 v1, v2, v1, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                 <2 x i16> addrspace(1)* %src2,
                                 i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = sext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = sext i16 %s2.elt1 to i32
  %mul1 = mul nuw i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = sext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = sext i16 %s2.elt2 to i32
  %mul2 = mul nuw i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @idot2_MixedTypedMul(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: idot2_MixedTypedMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v1, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot2_MixedTypedMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, s2
; GFX8-NEXT:    v_mad_i32_i24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot2_MixedTypedMul:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot2_MixedTypedMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot2_MixedTypedMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v0, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, s2, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                               <2 x i16> addrspace(1)* %src2,
                                               i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = sext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = sext i16 %s2.elt1 to i32
  %mul1 = mul nuw i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul nuw i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot2_alt_AddOperands(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_alt_AddOperands:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v1, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_alt_AddOperands:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, s3
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_alt_AddOperands:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, s0, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, s0, v2
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v1, v2, v1, s0
; GFX9-NODL-NEXT:    v_mad_u32_u24 v1, v4, v3, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_alt_AddOperands:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot2_u32_u16 v0, v3, v2, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_alt_AddOperands:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot2_u32_u16 v1, v2, v1, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                 <2 x i16> addrspace(1)* %src2,
                                                 i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul nuw i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul nuw i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %s3, %mul2
  %add6 = add i32 %mul1, %add
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @idot2_MixedExt(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: idot2_MixedExt:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff, v0
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v0, v0, v2, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v3, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot2_MixedExt:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v0, v0, v3, s2
; GFX8-NEXT:    v_mad_i32_i24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot2_MixedExt:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v3, v2, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot2_MixedExt:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v3, v2, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot2_MixedExt:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v0, v2, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, s2, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                          <2 x i16> addrspace(1)* %src2,
                                          i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = sext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul nuw i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = sext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = sext i16 %s2.elt2 to i32
  %mul2 = mul nuw i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @notudot2_SameVec(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: notudot2_SameVec:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v0, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: notudot2_SameVec:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v2, v[2:3]
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v1, s2
; GFX8-NEXT:    v_mad_u32_u24 v2, v0, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: notudot2_SameVec:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v2, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, s0, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: notudot2_SameVec:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v2, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v1, v2, s0, v1
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: notudot2_SameVec:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v0, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, s2, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                            <2 x i16> addrspace(1)* %src2,
                                            i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot2_v4i16(<4 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_v4i16:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX7-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, s4, v0
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_v4i16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    flat_load_dword v1, v[2:3]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s2, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v1, v0, s3
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_v4i16:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_v4i16:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot2_u32_u16 v0, v3, v2, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_v4i16:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot2_u32_u16 v1, v2, v1, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                       <4 x i16> addrspace(1)* %src2,
                                       i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i16>, <4 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i16>, <4 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <4 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <4 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <4 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <4 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot2_v4i16_Hi(<4 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_v4i16_Hi:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64 offset:4
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, s4, v0
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_v4i16_Hi:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s4, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, s6, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s2, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v2, s3
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_v4i16_Hi:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5] offset:4
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7] offset:4
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_v4i16_Hi:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5] offset:4
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7] offset:4
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot2_u32_u16 v0, v3, v2, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_v4i16_Hi:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5] offset:4
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7] offset:4
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot2_u32_u16 v1, v2, v1, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                          <4 x i16> addrspace(1)* %src2,
                                          i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i16>, <4 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i16>, <4 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <4 x i16> %vec1, i64 2
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <4 x i16> %vec2, i64 2
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <4 x i16> %vec1, i64 3
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <4 x i16> %vec2, i64 3
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @notudot2_v4i16_Even(<4 x i16> addrspace(1)* %src1,
; GFX7-LABEL: notudot2_v4i16_Even:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX7-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GFX7-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    v_and_b32_e32 v3, s4, v3
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v3, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: notudot2_v4i16_Even:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s2, v3
; GFX8-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v3, v1, s3
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: notudot2_v4i16_Even:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dwordx2 v[0:1], v4, s[4:5]
; GFX9-NODL-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v0, v1, s0, v0
; GFX9-NODL-NEXT:    global_store_dword v4, v0, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: notudot2_v4i16_Even:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dwordx2 v[0:1], v4, s[4:5]
; GFX9-DL-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v0, v1, s0, v0
; GFX9-DL-NEXT:    global_store_dword v4, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: notudot2_v4i16_Even:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dwordx2 v[0:1], v4, s[4:5]
; GFX10-DL-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, s2, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                               <4 x i16> addrspace(1)* %src2,
                                               i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i16>, <4 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i16>, <4 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <4 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <4 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <4 x i16> %vec1, i64 2
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <4 x i16> %vec2, i64 2
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @notudot2_v4i16_Middle(<4 x i16> addrspace(1)* %src1,
; GFX7-LABEL: notudot2_v4i16_Middle:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX7-NEXT:    s_mov_b64 s[6:7], s[10:11]
; GFX7-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v3, s4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v3, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: notudot2_v4i16_Middle:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, s2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v3, v1, s3
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: notudot2_v4i16_Middle:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dwordx2 v[0:1], v4, s[4:5]
; GFX9-NODL-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v0, v1, s0, v0
; GFX9-NODL-NEXT:    global_store_dword v4, v0, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: notudot2_v4i16_Middle:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dwordx2 v[0:1], v4, s[4:5]
; GFX9-DL-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v0, v1, s0, v0
; GFX9-DL-NEXT:    global_store_dword v4, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: notudot2_v4i16_Middle:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dwordx2 v[0:1], v4, s[4:5]
; GFX10-DL-NEXT:    global_load_dwordx2 v[2:3], v4, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, s2, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                 <4 x i16> addrspace(1)* %src2,
                                                 i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i16>, <4 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i16>, <4 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i16>, <4 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <4 x i16> %vec1, i64 1
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <4 x i16> %vec2, i64 1
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <4 x i16> %vec1, i64 2
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <4 x i16> %vec2, i64 2
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @notudot2_DiffIndex(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: notudot2_DiffIndex:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v1, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v2, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: notudot2_DiffIndex:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-NEXT:    v_and_b32_e32 v0, s2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, s3
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: notudot2_DiffIndex:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: notudot2_DiffIndex:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: notudot2_DiffIndex:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v0, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, s2, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                              <2 x i16> addrspace(1)* %src2,
                                              i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 1
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 0
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot2_MultipleUses_add1(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_MultipleUses_add1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v1, s5
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_MultipleUses_add1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, s3
; GFX8-NEXT:    v_mad_u32_u24 v1, v2, v1, v0
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_MultipleUses_add1:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v1, v2, v1, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, v3, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_MultipleUses_add1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_u32_u24 v1, v2, v1, s0
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, v3, v1
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_MultipleUses_add1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_u32_u24 v0, v3, v0, s2
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, v1, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                   <2 x i16> addrspace(1)* %src2,
                                                   i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add1 = add i32 %mul2, %s3
  %add2 = add i32 %add1, %mul1

  %res = add i32 %add2, %add1
  store i32 %res, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @idot2_MultipleUses_add1(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: idot2_MultipleUses_add1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v3, v0, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v0, v0, v2, s4
; GFX7-NEXT:    v_mad_i32_i24 v1, v3, v1, v0
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot2_MultipleUses_add1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v0, v0, v3, s2
; GFX8-NEXT:    v_mad_i32_i24 v1, v2, v1, v0
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot2_MultipleUses_add1:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX9-NODL-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_i32_i24 v1, v2, v1, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, v3, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot2_MultipleUses_add1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX9-DL-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_i32_i24 v1, v2, v1, s0
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, v3, v1
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot2_MultipleUses_add1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_ashrrev_i32_e32 v0, 16, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_ashrrev_i32_e32 v3, 16, v2
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_i32_i24 v0, v3, v0, s2
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, v1, v0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                   <2 x i16> addrspace(1)* %src2,
                                                   i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = sext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = sext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = sext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = sext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add1 = add i32 %mul2, %s3
  %add2 = add i32 %add1, %mul1

  %res = add i32 %add2, %add1
  store i32 %res, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot2_MultipleUses_mul1(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_MultipleUses_mul1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v4, v0, v2, s4
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v1, v4
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_MultipleUses_mul1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v4, v2, v1, s3
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, v4
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_MultipleUses_mul1:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, s0, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, s0, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_e32 v2, v4, v3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v3, v4, v3, s1
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, v3, v2
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_MultipleUses_mul1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_mov_b32 s0, 0xffff
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s1, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_and_b32_e32 v3, s0, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_and_b32_e32 v4, s0, v2
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v2, v4, v3
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_u32_u24 v3, v4, v3, s1
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, v3, v2
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_MultipleUses_mul1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_mov_b32 s3, 0xffff
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v0, s3, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_and_b32_e32 v3, s3, v2
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v2, v3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_u32_u24 v0, v3, v0, s2
; GFX10-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, v0, v2
; GFX10-DL-NEXT:    global_store_dword v3, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                   <2 x i16> addrspace(1)* %src2,
                                                   i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add0 = add i32 %mul1, %s3

  %add1 = add i32 %mul2, %add0
  %add2 = add i32 %add1, %mul1

  store i32 %add2, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @idot2_MultipleUses_mul1(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: idot2_MultipleUses_mul1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v3, v0, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v4, v3, v1, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v0, v2, v4
; GFX7-NEXT:    v_mad_i32_i24 v0, v3, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot2_MultipleUses_mul1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v4, v2, v1, s2
; GFX8-NEXT:    v_mad_i32_i24 v0, v0, v3, v4
; GFX8-NEXT:    v_mad_i32_i24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot2_MultipleUses_mul1:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_bfe_i32 v3, v1, 0, 16
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_bfe_i32 v4, v2, 0, 16
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NODL-NEXT:    v_mul_i32_i24_e32 v2, v4, v3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_i32_i24 v3, v4, v3, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, v3, v2
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot2_MultipleUses_mul1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_bfe_i32 v3, v1, 0, 16
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_bfe_i32 v4, v2, 0, 16
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v2, v4, v3
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_i32_i24 v3, v4, v3, s0
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, v3, v2
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot2_MultipleUses_mul1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_bfe_i32 v0, v1, 0, 16
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_bfe_i32 v3, v2, 0, 16
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-DL-NEXT:    v_mul_i32_i24_e32 v2, v3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_i32_i24 v0, v3, v0, s2
; GFX10-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-DL-NEXT:    v_add3_u32 v0, v1, v0, v2
; GFX10-DL-NEXT:    global_store_dword v3, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                   <2 x i16> addrspace(1)* %src2,
                                                   i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = sext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = sext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = sext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = sext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add0 = add i32 %mul1, %s3

  %add1 = add i32 %mul2, %add0
  %add2 = add i32 %add1, %mul1

  store i32 %add2, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot2_MultipleUses_mul2(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_MultipleUses_mul2:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v4, v3, v1, s4
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v1, v4
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_MultipleUses_mul2:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s2, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, s2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, s2, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v4, v0, v3, s3
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, v4
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_MultipleUses_mul2:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_e32 v4, v2, v1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v1, v2, v1, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v4, v1, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_MultipleUses_mul2:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v4, v2, v1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_u32_u24 v1, v2, v1, s0
; GFX9-DL-NEXT:    v_add3_u32 v1, v4, v1, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_MultipleUses_mul2:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v2, v3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_u32_u24 v0, v3, v0, s2
; GFX10-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-DL-NEXT:    v_add3_u32 v0, v2, v0, v1
; GFX10-DL-NEXT:    global_store_dword v3, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                   <2 x i16> addrspace(1)* %src2,
                                                   i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = zext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = zext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = zext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = zext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add0 = add i32 %mul2, %s3

  %add1 = add i32 %mul2, %add0
  %add2 = add i32 %add1, %mul1

  store i32 %add2, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @idot2_MultipleUses_mul2(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: idot2_MultipleUses_mul2:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v3, v0, 0, 16
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v4, v0, v2, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v0, v2, v4
; GFX7-NEXT:    v_mad_i32_i24 v0, v3, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot2_MultipleUses_mul2:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 16
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v4, v0, v3, s2
; GFX8-NEXT:    v_mad_i32_i24 v0, v0, v3, v4
; GFX8-NEXT:    v_mad_i32_i24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot2_MultipleUses_mul2:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-NODL-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX9-NODL-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX9-NODL-NEXT:    v_mul_i32_i24_e32 v4, v2, v1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_i32_i24 v1, v2, v1, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v4, v1, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot2_MultipleUses_mul2:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX9-DL-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX9-DL-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v4, v2, v1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_i32_i24 v1, v2, v1, s0
; GFX9-DL-NEXT:    v_add3_u32 v1, v4, v1, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot2_MultipleUses_mul2:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_ashrrev_i32_e32 v0, 16, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_ashrrev_i32_e32 v3, 16, v2
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:WORD_0
; GFX10-DL-NEXT:    v_mul_i32_i24_e32 v2, v3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_i32_i24 v0, v3, v0, s2
; GFX10-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-DL-NEXT:    v_add3_u32 v0, v2, v0, v1
; GFX10-DL-NEXT:    global_store_dword v3, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                   <2 x i16> addrspace(1)* %src2,
                                                   i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i16> %vec1, i64 0
  %conv = sext i16 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i16> %vec2, i64 0
  %conv2 = sext i16 %s2.elt1 to i32
  %mul1 = mul i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i16> %vec1, i64 1
  %conv3 = sext i16 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i16> %vec2, i64 1
  %conv4 = sext i16 %s2.elt2 to i32
  %mul2 = mul i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add0 = add i32 %mul2, %s3

  %add1 = add i32 %mul2, %add0
  %add2 = add i32 %add1, %mul1

  store i32 %add2, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot2_acc16(<2 x i16> addrspace(1)* %src1,
; GFX7-LABEL: udot2_acc16:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v4, off, s[0:3], 0
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v3, v4
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_acc16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_ushort v6, v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v1, v1, v5, v6
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v1
; GFX8-NEXT:    flat_store_short v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_acc16:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NODL-NEXT:    global_load_ushort v5, v1, s[2:3]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v0, v0, v4, v5
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v0, v2, v3, v0
; GFX9-NODL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_acc16:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ushort v5, v1, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v0, v4, v5
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v2, v3, v0
; GFX9-DL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_acc16:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    global_load_ushort v4, v1, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v0, v0, v5, v4
; GFX10-DL-NEXT:    v_mad_u16 v0, v2, v3, v0
; GFX10-DL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                       <2 x i16> addrspace(1)* %src2,
                                       i16 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src1, i32 %idx
  %v1 = load <2 x i16>, <2 x i16> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i16>, <2 x i16> addrspace(1)* %src2, i32 %idx
  %v2 = load <2 x i16>, <2 x i16> addrspace(1)* %gep2

  %v1e1 = extractelement <2 x i16> %v1, i64 0
  %v2e1 = extractelement <2 x i16> %v2, i64 0
  %mul1 = mul i16 %v1e1, %v2e1

  %v1e2 = extractelement <2 x i16> %v1, i64 1
  %v2e2 = extractelement <2 x i16> %v2, i64 1
  %mul2 = mul i16 %v1e2, %v2e2

  %s2 = load i16, i16 addrspace(1)* %dst, align 2
  %add1 = add i16 %mul2, %s2
  %add2 = add i16 %add1, %mul1
  store i16 %add2, i16 addrspace(1)* %dst, align 2
  ret void
}

define amdgpu_kernel void @notsdot2_sext8(<2 x i8> addrspace(1)* %src1,
; GFX7-LABEL: notsdot2_sext8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_ushort v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_ushort v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX7-NEXT:    v_bfe_i32 v2, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v3, v0, 0, 8
; GFX7-NEXT:    v_bfe_i32 v0, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v0, v0, v2, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v3, v1, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: notsdot2_sext8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 1, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_ushort v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_ushort v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 8
; GFX8-NEXT:    v_lshrrev_b16_e32 v3, 8, v3
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 8
; GFX8-NEXT:    v_lshrrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v0, v0, v3, s2
; GFX8-NEXT:    v_mad_i32_i24 v2, v2, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: notsdot2_sext8:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_ushort v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_lshrrev_b16_e32 v1, 8, v1
; GFX9-NODL-NEXT:    v_lshrrev_b16_e32 v2, 8, v2
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: notsdot2_sext8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_ushort v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-DL-NEXT:    v_lshrrev_b16_e32 v1, 8, v1
; GFX9-DL-NEXT:    v_lshrrev_b16_e32 v2, 8, v2
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v1, v1, s0, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: notsdot2_sext8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_ushort v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_ushort v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b16 v0, 8, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_lshrrev_b16 v3, 8, v2
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v2), sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v0, sext(v3), sext(v0) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, s2, v1
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                          <2 x i8> addrspace(1)* %src2,
                                          i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <2 x i8>, <2 x i8> addrspace(1)* %src1, i32 %idx
  %vec1 = load <2 x i8>, <2 x i8> addrspace(1)* %gep1
  %gep2 = getelementptr <2 x i8>, <2 x i8> addrspace(1)* %src2, i32 %idx
  %vec2 = load <2 x i8>, <2 x i8> addrspace(1)* %gep2

  %s1.elt1 = extractelement <2 x i8> %vec1, i64 0
  %conv = sext i8 %s1.elt1 to i32
  %s2.elt1 = extractelement <2 x i8> %vec2, i64 0
  %conv2 = sext i8 %s2.elt1 to i32
  %mul1 = mul nuw i32 %conv2, %conv

  %s1.elt2 = extractelement <2 x i8> %vec1, i64 1
  %conv3 = sext i8 %s1.elt2 to i32
  %s2.elt2 = extractelement <2 x i8> %vec2, i64 1
  %conv4 = sext i8 %s2.elt2 to i32
  %mul2 = mul nuw i32 %conv4, %conv3

  %s3 = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul2, %s3
  %add6 = add i32 %add, %mul1
  store i32 %add6, i32 addrspace(1)* %dst, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
