{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFilename: String;
    procedure SetFilename(const Value: String);
    function GetBlendColor: TVector3;
    procedure SetBlendColor(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdFilename: TSFString;
    { Internal wrapper for property @code(Filename). This wrapper API may change, we advise to access simpler @code(Filename) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFilename: TSFString read FFdFilename;
    {  }
    property Filename: String read GetFilename write SetFilename;

    strict private FFdImage: TSFImage;
    { Internal wrapper for property @code(Image). This wrapper API may change, we advise to access simpler @code(Image) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdImage: TSFImage read FFdImage;

    strict private FFdWrapS: TSFEnum;
    { Internal wrapper for property @code(WrapS). This wrapper API may change, we advise to access simpler @code(WrapS) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWrapS: TSFEnum read FFdWrapS;

    strict private FFdWrapT: TSFEnum;
    { Internal wrapper for property @code(WrapT). This wrapper API may change, we advise to access simpler @code(WrapT) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdWrapT: TSFEnum read FFdWrapT;

    strict private FFdModel: TSFEnum;
    { Internal wrapper for property @code(Model). This wrapper API may change, we advise to access simpler @code(Model) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdModel: TSFEnum read FFdModel;

    strict private FFdBlendColor: TSFVec3f;
    { Internal wrapper for property @code(BlendColor). This wrapper API may change, we advise to access simpler @code(BlendColor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBlendColor: TSFVec3f read FFdBlendColor;
    { Ignored. Unknown extension to VRML 1.0 spec, found on models in http://www-vrl.umich.edu/sel_prj/EECS498/ . }
    property BlendColor: TVector3 read GetBlendColor write SetBlendColor;

{$endif read_interface}

{$ifdef read_implementation}

{ TTexture2Node_1 ----------------------------------------------- }

function TTexture2Node_1.GetFilename: String;
begin
  Result := FdFilename.Value;
end;

procedure TTexture2Node_1.SetFilename(const Value: String);
begin
  FdFilename.Send(Value);
end;

function TTexture2Node_1.GetBlendColor: TVector3;
begin
  Result := FdBlendColor.Value;
end;

procedure TTexture2Node_1.SetBlendColor(const Value: TVector3);
begin
  FdBlendColor.Send(Value);
end;

class function TTexture2Node_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TTexture2Node_1.ClassX3DType: String;
begin
  Result := 'Texture2';
end;

procedure TTexture2Node_1.CreateNode;
begin
  inherited;

  FFdFilename := TSFString.Create(Self, True, 'filename', '');
   FdFilename.ChangeAlways := chTextureImage;
  AddField(FFdFilename);

  FFdImage := TSFImage.Create(Self, True, 'image', nil);
   FdImage.ChangeAlways := chTextureImage;
  AddField(FFdImage);

  FFdWrapS := TSFEnum.Create(Self, True, 'wrapS', @WrapNames1, Ord(High(WrapNames1)) + 1, TEXWRAP_REPEAT);
   FdWrapS.ChangeAlways := chTexturePropertiesNode;
  AddField(FFdWrapS);

  FFdWrapT := TSFEnum.Create(Self, True, 'wrapT', @WrapNames1, Ord(High(WrapNames1)) + 1, TEXWRAP_REPEAT);
   FdWrapT.ChangeAlways := chTexturePropertiesNode;
  AddField(FFdWrapT);

  FFdModel := TSFEnum.Create(Self, True, 'model', @TextureModelNames1, Ord(High(TextureModelNames1)) + 1, 0);
   FdModel.ChangeAlways := chTexturePropertiesNode;
  AddField(FFdModel);

  FFdBlendColor := TSFVec3f.Create(Self, True, 'blendColor', Vector3(0, 0, 0));
   FdBlendColor.ChangeAlways := chTexturePropertiesNode;
  AddField(FFdBlendColor);
end;

{$endif read_implementation}
