{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventSet_destination: TMFVec2fEvent;
    {  }
    public property EventSet_destination: TMFVec2fEvent read FEventSet_destination;

    strict private FEventSet_value: TMFVec2fEvent;
    {  }
    public property EventSet_value: TMFVec2fEvent read FEventSet_value;

    strict private FEventValue_changed: TMFVec2fEvent;
    {  }
    public property EventValue_changed: TMFVec2fEvent read FEventValue_changed;

    strict private FFdInitialDestination: TMFVec2f;
    { Internal wrapper for property @code(InitialDestination). This wrapper API may change, we advise to access simpler @code(InitialDestination) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialDestination: TMFVec2f read FFdInitialDestination;
    {  }
    procedure SetInitialDestination(const Value: array of TVector2); overload;
    {  }
    procedure SetInitialDestination(const Value: TVector2List); overload;

    strict private FFdInitialValue: TMFVec2f;
    { Internal wrapper for property @code(InitialValue). This wrapper API may change, we advise to access simpler @code(InitialValue) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInitialValue: TMFVec2f read FFdInitialValue;
    {  }
    procedure SetInitialValue(const Value: array of TVector2); overload;
    {  }
    procedure SetInitialValue(const Value: TVector2List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TTexCoordDamper2DNode ----------------------------------------------- }

procedure TTexCoordDamper2DNode.SetInitialDestination(const Value: array of TVector2);
begin
  FdInitialDestination.Send(Value);
end;

procedure TTexCoordDamper2DNode.SetInitialDestination(const Value: TVector2List);
begin
  FdInitialDestination.Send(Value);
end;

procedure TTexCoordDamper2DNode.SetInitialValue(const Value: array of TVector2);
begin
  FdInitialValue.Send(Value);
end;

procedure TTexCoordDamper2DNode.SetInitialValue(const Value: TVector2List);
begin
  FdInitialValue.Send(Value);
end;

class function TTexCoordDamper2DNode.ClassX3DType: String;
begin
  Result := 'TexCoordDamper2D';
end;

procedure TTexCoordDamper2DNode.CreateNode;
begin
  inherited;

  FEventSet_destination := TMFVec2fEvent.Create(Self, 'set_destination', true);
  AddEvent(FEventSet_destination);

  FEventSet_value := TMFVec2fEvent.Create(Self, 'set_value', true);
  AddEvent(FEventSet_value);

  FEventValue_changed := TMFVec2fEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdInitialDestination := TMFVec2f.Create(Self, False, 'initialDestination', []);
   FdInitialDestination.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialDestination);

  FFdInitialValue := TMFVec2f.Create(Self, False, 'initialValue', []);
   FdInitialValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInitialValue);
end;

{$endif read_implementation}
