# Contributing

[![Chinese version](./assets/chinese.svg)](./contributing-zh.md)

:tada: First off, thanks for taking the time to contribute! :tada:

The following is a set of guidelines for contributing to BIThesis.

These are mostly guidelines, not rules. Use your best judgment,
and feel free to propose changes to this document in a pull request.

## Guidance

**[I don't want to read this whole thing, I just have a small question!!!](#join-our-slack-channel)**

|                 | For Users                        | For Developers                                 |
| --------------- | -------------------------------- | ---------------------------------------------- |
| Have a Question | [Slack](#join-our-slack-channel) | [Slack](#join-our-slack-channel)               |
| Bug Report      | [Slack](#join-our-slack-channel) | [Github - Issues](#bug-report-on-github)       |
| Feature Request | [Slack](#join-our-slack-channel) | [Slack](#join-our-slack-channel)               |
| Pull Request    |                                  | [Github - Pull Request](#pull-request-process) |

## Join Our Slack Channel

We provide an [official Slack channel][slack channel invitation]
with **a bunch of active maintainers** and **a friendly community**
to give helpful advice **if you have any questions**.

[![Join on Slack](/assets/slack.svg)](https://join.slack.com/t/bithesis/shared_invite/zt-epmzkyk0-fJRsUS36AlwMNB2AI_Q~Vw)

- use `#community` channel to **report a bug**, **feature request** and **asking for help**.
- use `#random` channel to have **unrelated discussion**:laughing:!
- use `#announcement` channel if you don't want to miss the **updated news and features**!

> note: there is no detailed rules about how to ask question, just provide enough information and
rethink before write.

## Bug Report on Github

If you can locate the bug or provide more detailed information, you may
_[report an issue here][issue reporting link]_.

## Pull Request Process

Pull Request are welcomed!

The following steps will help you finish a pull request.

1. Fork this repo.
2. `git clone` your forked repo.
3. Make changes until the bug is fixed.
4. Commit your changes.
5. Create a pull request with related information.
6. Keep in touch with further discussion and refine.

For more information, refer to the
_[Github Help](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests)_.

[slack channel invitation]: https://join.slack.com/t/bithesis/shared_invite/zt-epmzkyk0-fJRsUS36AlwMNB2AI_Q~Vw
[issue reporting link]: https://github.com/BITNP/BIThesis/issues/new
