note
	description: "Generate public keys"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2012-12-21 01:10:02 +0000 (Fri, 21 Dec 2012) $"
	revision: "$Revision: 96472 $"

class
	KG_CD_KEY_GENERATOR

inherit
	KG_CONSTANTS

create
	make

feature {NONE} -- Initialization

	make (l_product, l_version: STRING)
			-- Initialize encoder
		require
			non_void_product_name: l_product /= Void
			valid_product_name: not l_product.is_empty
			non_void_version: l_version /= Void
			valid_version: not l_version.is_empty and then l_version.is_double
		do
			product := l_product
			version := l_version
		ensure
			product_set: product = l_product
			version_set: version = l_version
		end

feature -- Access

	product: STRING
			-- Product for which key is generated

	version: STRING
			-- Product version for which key is generated

	cd_key: STRING
			-- Newly generated cd key
			-- 34532-35325-76256-79245-23249-34562
		local
			rand: RANDOM
			r17, r911, l_c1217, r1818, l_c1922, l_c2326, r2729, l_c3030: STRING
			seed_file: PLAIN_TEXT_FILE
			seed: INTEGER
		do
			create seed_file.make_with_name (Seed_file_name)
			if seed_file.exists then
				seed_file.open_read
				seed_file.read_integer
				seed := seed_file.last_integer
				seed_file.close
			else
				seed := (create {C_DATE}).millisecond_now
			end
			create rand.set_seed (seed)
			create Result.make (30)
			create r17.make (7)
			create r911.make (3)
			create r1818.make (1)
			create r2729.make (3)
			r17.append (rand.i_th (2).out.substring (1, 2))
			if r17.count = 1 then
				r17.append ("5")
			end
			l_c3030 := c3030 (r17)
			r17.append (rand.i_th (3).out.substring (1, 5))
			if r17.count = 3 then
				r17.append ("3223")
			elseif r17.count = 4 then
				r17.append ("276")
			elseif r17.count = 5 then
				r17.append ("51")
			elseif r17.count = 6 then
				r17.append ("3")
			end
			Result.append (r17)
			l_c1922 := c1922 (r17, l_c3030)
			l_c2326 := c2326 (l_c1922, r17, l_c3030)
			r911.append (rand.i_th (4).out.substring (1, 3))
			if r911.count = 1 then
				r911.append ("62")
			elseif r911.count = 2 then
				r911.append ("2")
			end
			l_c1217 := c1217 (r911, l_c2326, l_c3030)
			r1818.append_character (rand.i_th (6).out.item (1))
			r2729.append (rand.i_th (7).out.substring (1, 3))
			if r2729.count = 1 then
				r2729.append ("20")
			elseif r2729.count = 2 then
				r2729.append ("9")
			end
			Result.append (c88 (r2729, l_c3030))
			Result.append (r911)
			Result.append (l_c1217)
			Result.append (r1818)
			Result.append (l_c1922)
			Result.append (l_c2326)
			Result.append (r2729)
			Result.append (l_c3030)

			Result := Result.substring (1, 5) + Key_separator + Result.substring (6, 10) + Key_separator +
						Result.substring (11, 15) + Key_separator + Result.substring (16, 20) + Key_separator +
						Result.substring (21, 25) + Key_separator + Result.substring (26, 30)

			create seed_file.make_open_write (Seed_file_name)
			seed_file.put_integer (rand.i_th (7))
			seed_file.close
		end

feature -- Status Report

	is_valid_cd_key (key: READABLE_STRING_GENERAL): BOOLEAN
			-- Is `key' a valid cd key?
		require
			non_void_key: key /= Void
			valid_count: key.count = Cd_key_length
			key_valid: key.is_valid_as_string_8
			numeric_key: key.substring (1, 5).is_integer and key.substring (7, 11).is_integer and
							key.substring (13, 17).is_integer and key.substring (19, 23).is_integer and
							key.substring (25, 29).is_integer and key.substring (31, 35).is_integer
		local
			s: STRING
			l_c1922, l_c3030, l_c2326, l_c1217: STRING
		do
			create s.make (key.count)
			s.append_string_general (key)
			s.prune_all ('-')
			l_c3030 := c3030 (s.substring (1, 2))
			Result := l_c3030.is_equal (s.substring (30, 30))
			if Result then
				Result := c88 (s.substring (27, 29), l_c3030).is_equal (s.item (8).out)
				if Result then
					l_c1922 := c1922 (s.substring (1, 7), l_c3030)
					Result := l_c1922.is_equal (s.substring (19, 22))
					if Result then
						l_c2326 := c2326 (l_c1922, s.substring (1, 7), l_c3030)
						Result := l_c2326.is_equal (s.substring (23, 26))
						if Result then
							l_c1217 := c1217 (s.substring (9, 11), l_c2326, l_c3030)
							Result := l_c1217.is_equal (s.substring (12, 17))
						end
					end
				end
			end
		end

feature {NONE} -- Implementation

	c88 (r2729, l_c3030: STRING): STRING
			-- Component c88
		require
			non_void_r2729: r2729 /= Void
			valid_r2729: r2729.count = 3
			non_void_c3030: l_c3030 /= Void
			valid_c3030: l_c3030.count = 1
		local
			s: STRING
		do
			s := (r2729.item (2).out.to_integer * l_c3030.to_integer).out
			if s.count > 1 then
				Result := s.item (2).out
			else
				Result := "3"
			end
		ensure
			non_void_c88: Result /= Void
			valid_c88: Result.count = 1
		end

	c1217 (r911, l_c2326, l_c3030: STRING): STRING
			-- Component c1217
		require
			non_void_r911: r911 /= Void
			valid_r911: r911.count = 3
			non_void_c2326: l_c2326 /= Void
			valid_c2326: l_c2326.count = 4
			non_void_c3030: l_c3030 /= Void
			valid_c3030: l_c3030.count = 1
		local
			l_val: INTEGER
			l_vers: STRING
		do
			l_vers := version.twin
			l_vers.replace_substring_all (".", "")
			l_val := l_vers.to_integer
			if l_val < 10 then
				l_val := l_val * 100
			elseif l_val < 100 then
				l_val := l_val * 10
			else
				check
					l_val_less_than_1000: l_val < 1000
				end
			end
			if l_c2326.substring (2, 3).is_equal ("00") then
				Result := (l_c3030.to_integer + l_c2326.to_integer * r911.to_integer // 42 + l_val).out
			else
				Result := (l_c3030.to_integer + l_c2326.to_integer * r911.to_integer + version.hash_code // l_c2326.substring (2, 3).to_integer + l_val).out
			end
			if Result.count = 1 then
				Result.append ("12179")
			elseif Result.count = 2 then
				Result.append ("2342")
			elseif Result.count = 3 then
				Result.append ("626")
			elseif Result.count = 4 then
				Result.append ("23")
			elseif Result.count = 5 then
				Result.append ("5")
			elseif Result.count > 6 then
				Result.keep_head (6)
			end
		ensure
			non_void_c1217: Result /= Void
			valid_c1217: Result.count = 6
		end

	c1922 (r17, l_c3030: STRING): STRING
			-- Component c1922
		require
			non_void_r17: r17 /= Void
			valid_r17: r17.count = 7
			non_void_c3030: l_c3030 /= Void
			valid_c3030: l_c3030.count = 1
		do
			Result := (r17.item (2).out.to_integer + l_c3030.item (1).out.to_integer *
					r17.item (3).out.to_integer - r17.item (1).out.to_integer * r17.item (2).out.to_integer).abs.out
			if Result.count = 1 then
				Result.append ("192")
			elseif Result.count = 2 then
				Result.append ("19")
			elseif Result.count = 3 then
				Result.append ("1")
			elseif Result.count > 4 then
				Result.keep_tail (4)
			end
		ensure
			non_void_c1922: Result /= Void
			valid_c1922: Result.count = 4
		end

	c2326 (l_c1922, r17, l_c3030: STRING): STRING
			-- Component c2326
		require
			non_void_c1922: l_c1922 /= Void
			valid_c1922: l_c1922.count = 4
			non_void_r17: r17 /= Void
			valid_r17: r17.count = 7
			non_void_c3030: l_c3030 /= Void
			valid_c3030: l_c3030.count = 1
		do
			Result := (l_c1922.to_integer * r17.to_integer + l_c3030.to_integer + product.hash_code - l_c1922.substring (1, 2).to_integer).abs.out
			if Result.count = 1 then
				Result.append ("525")
			elseif Result.count = 2 then
				Result.append ("23")
			elseif Result.count = 3 then
				Result.append ("4")
			elseif Result.count > 4 then
				Result.keep_tail (4)
			end
		ensure
			non_void_c2326: Result /= Void
			valid_c2326: Result.count = 4
		end

	c3030 (r12: STRING): STRING
			-- Component c3030
		require
			non_void_r12: r12 /= Void
			valid_r12: r12.count = 2
		do
			Result := (r12.item (1).out.to_integer * r12.item (2).out.to_integer).out.item (1).out
		ensure
			non_void_c3030: Result /= Void
			valid_c3030: Result.count = 1
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_CD_KEY_GENERATOR
