/*
 * Code for class GDK_X11
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "gd14.h"
#include <ev_gtk.h>
#include "eif_misc.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F14_214
static void inline_F14_214 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11
	return gdk_x11_display_error_trap_push ((GdkDisplay *)arg1);
#endif
	;
}
#define INLINE_F14_214
#endif
#ifndef INLINE_F14_216
static EIF_POINTER inline_F14_216 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
		/* Declarations */
	GC gc;									/* handle of newly created GC.  */
	unsigned long valuemask = 0;			/* which values in 'values' to  */
	Window win =  gdk_x11_window_get_xid ((GdkWindow *)arg1);
	Display* display = GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
		/* Define properties/values for the GC.  */
	XGCValues values;						/* initial values for the GC.   */
	unsigned int line_width = 1;			/* line width for the GC.       */
	int line_style = LineSolid;				/* style for lines drawing and  */
	int cap_style = CapButt;				/* style of the line's edje and */
	int join_style = JoinBevel;				/* joined lines.		*/
	values.function = GXcopy;               /* src */
	values.subwindow_mode = ClipByChildren; /* GCSubwindowMode */
	values.line_width = line_width;
	values.fill_style = FillSolid;
	values.arc_mode = ArcPieSlice;
	values.graphics_exposures = False;
	valuemask = GCFunction | GCFillStyle | GCArcMode | GCSubwindowMode | GCGraphicsExposures;
		/* Create the GC object */
	gc = XCreateGC(display, win, valuemask, &values);
	if (gc < 0) {
		fprintf(stderr, "XCreateGC: \n");
	}
	return gc;
#endif
	;
}
#define INLINE_F14_216
#endif
#ifndef INLINE_F14_220
static EIF_POINTER inline_F14_220 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
#endif
	;
}
#define INLINE_F14_220
#endif
#ifndef INLINE_F14_235
static EIF_INTEGER_32 inline_F14_235 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineSolid;
#endif
	;
}
#define INLINE_F14_235
#endif
#ifndef INLINE_F14_236
static EIF_INTEGER_32 inline_F14_236 (void)
{
	#ifdef GDK_WINDOWING_X11
return CapButt;
#endif
	;
}
#define INLINE_F14_236
#endif
#ifndef INLINE_F14_237
static EIF_INTEGER_32 inline_F14_237 (void)
{
	#ifdef GDK_WINDOWING_X11
return JoinBevel;
#endif
	;
}
#define INLINE_F14_237
#endif
#ifndef INLINE_F14_224
static void inline_F14_224 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
				XSetLineAttributes((Display*) arg1, (GC) arg2, 
					(unsigned int) arg3,
      				(int) arg4, (int) arg5, (int) arg6);
				#endif
	;
}
#define INLINE_F14_224
#endif
#ifndef INLINE_F14_225
static void inline_F14_225 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XSetDashes ((Display*) arg1, (GC) arg2, (int) arg3, (char*) arg4, (int) arg5);
#endif
	;
}
#define INLINE_F14_225
#endif
#ifndef INLINE_F14_234
static EIF_INTEGER_32 inline_F14_234 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineOnOffDash;
#endif
	;
}
#define INLINE_F14_234
#endif
#ifndef INLINE_F14_221
static EIF_POINTER inline_F14_221 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) gdk_x11_window_get_xid ((GdkWindow *) arg1);
#endif
	;
}
#define INLINE_F14_221
#endif
#ifndef INLINE_F14_222
static void inline_F14_222 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFunction((Display*) arg1, (GC) arg2, (int) arg3);
#endif
	;
}
#define INLINE_F14_222
#endif
#ifndef INLINE_F14_223
static void inline_F14_223 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetSubwindowMode((Display *)arg1, (GC)arg2, (int)arg3);
#endif
	;
}
#define INLINE_F14_223
#endif
#ifndef INLINE_F14_226
static void inline_F14_226 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFillStyle((Display*)arg1, (GC) arg2, (int)arg3);	
#endif
	;
}
#define INLINE_F14_226
#endif
#ifndef INLINE_F14_228
static void inline_F14_228 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	XFlush((Display*) arg1);
#endif
	;
}
#define INLINE_F14_228
#endif
#ifndef INLINE_F14_229
static EIF_INTEGER_32 inline_F14_229 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillSolid;
#endif
	;
}
#define INLINE_F14_229
#endif
#ifndef INLINE_F14_230
static EIF_INTEGER_32 inline_F14_230 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillTiled;
#endif
	;
}
#define INLINE_F14_230
#endif
#ifndef INLINE_F14_239
static EIF_INTEGER_32 inline_F14_239 (void)
{
	#ifdef GDK_WINDOWING_X11 
return IncludeInferiors;
#endif
	;
}
#define INLINE_F14_239
#endif
#ifndef INLINE_F14_242
static void inline_F14_242 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
/* */
Colormap cmap =  DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1) );
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
/* */
XAllocColor((Display*) arg1, cmap, &color);
XSetBackground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F14_242
#endif
#ifndef INLINE_F14_243
static void inline_F14_243 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
Colormap cmap = DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1));
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
XAllocColor((Display*) arg1, cmap, &color);
XSetForeground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F14_243
#endif
#ifndef INLINE_F14_245
static EIF_INTEGER_32 inline_F14_245 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXand;
#endif
	;
}
#define INLINE_F14_245
#endif
#ifndef INLINE_F14_247
static EIF_INTEGER_32 inline_F14_247 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXcopy;
#endif
	;
}
#define INLINE_F14_247
#endif
#ifndef INLINE_F14_250
static EIF_INTEGER_32 inline_F14_250 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXxor;
#endif
	;
}
#define INLINE_F14_250
#endif
#ifndef INLINE_F14_251
static EIF_INTEGER_32 inline_F14_251 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXor;
#endif
	;
}
#define INLINE_F14_251
#endif
#ifndef INLINE_F14_254
static EIF_INTEGER_32 inline_F14_254 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXinvert;
#endif
	;
}
#define INLINE_F14_254
#endif
#ifndef INLINE_F14_260
static void inline_F14_260 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	#ifdef GDK_WINDOWING_X11 
	Window win = (Window) arg1;
	/*
	 * TODO check Gdkgc-x11 _gdk_x11_gc_flush implementation 
	 * that's used before
	 * for example gdk_x11_draw_segments the usage of
	 * GDK_GC_GET_XGC (gc),
	 * https://github.com/coapp-packages/gtk/blob/master/gdk/x11/gdkdrawable-x11.c
	 */
						
	XDrawLine((Display*) arg2, win, arg3, arg4, arg5, arg6, arg7);
	
#endif
	;
}
#define INLINE_F14_260
#endif
#ifndef INLINE_F14_261
static void inline_F14_261 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XDrawPoint ((Display*) arg2, (Drawable) arg1, arg3, arg4, arg5);
#endif
	;
}
#define INLINE_F14_261
#endif
#ifndef INLINE_F14_262
static void inline_F14_262 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;

						if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);
					else
					    XDrawArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);	
	
				#endif
	;
}
#define INLINE_F14_262
#endif
#ifndef INLINE_F14_263
static void inline_F14_263 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;
					   
					   	if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);
					else
					    XDrawRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);

				#endif
	;
}
#define INLINE_F14_263
#endif
#ifndef INLINE_F14_264
static void inline_F14_264 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					gint i;
					XPoint *tmp_points = g_new (XPoint, arg5);

					for (i=0; i<arg5; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg4)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg4)[i].y;
				    }
				    					
					XDrawLines ((Display*) arg2, win, arg3, tmp_points, arg5, CoordModeOrigin);
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F14_264
#endif
#ifndef INLINE_F14_265
static void inline_F14_265 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					XPoint *tmp_points;
 					gint tmp_npoints, i;


					if (!(arg4) &&
				      ( ((GdkPoint *)arg5)[0].x != ((GdkPoint *)arg5)[arg6-1].x || ((GdkPoint *)arg5)[0].y != ((GdkPoint *)arg5)[arg6-1].y))
				    {
				      tmp_npoints = arg6 + 1;
				      tmp_points = g_new (XPoint, tmp_npoints);
				      tmp_points[arg6].x = ((GdkPoint *)arg5)[0].x;
				      tmp_points[arg6].y = ((GdkPoint *)arg5)[0].y;
				    }
				  	else
				    {
				      tmp_npoints = arg6;
				      tmp_points = g_new (XPoint, tmp_npoints);
				    }

				  	for (i=0; i<arg6; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg5)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg5)[i].y;
				    }


				    if (arg4)
						XFillPolygon ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, Complex, CoordModeOrigin);					
					else	
						XDrawLines ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, CoordModeOrigin);
						
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F14_265
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {GDK_X11}.gdk_x11_display_error_trap_push */
void F14_214 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	
	
	inline_F14_214 ((EIF_POINTER) arg1);
}

/* {GDK_X11}.create_gc */
EIF_POINTER F14_216 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	Result = inline_F14_216 ((EIF_POINTER) arg1);
	return Result;
}

/* {GDK_X11}.set_line_attributes_to_solid_style */
void F14_217 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	EIF_POINTER tp1;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	
	
	RTGC;
	tp1 = inline_F14_220(arg1);
	ti4_1 = inline_F14_235();
	ti4_2 = inline_F14_236();
	ti4_3 = inline_F14_237();
	inline_F14_224(tp1, arg2, arg3, ti4_1, ti4_2, ti4_3);
}

/* {GDK_X11}.set_line_attributes_to_dashed_style */
void F14_218 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	EIF_INTEGER_16 loc2 = (EIF_INTEGER_16) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_16 ti2_1;
	
	
	RTGC;
	loc1 = inline_F14_220(arg1);
	ti2_1 = eif_bit_shift_left(((EIF_INTEGER_16) 3L),((EIF_INTEGER_32) 8L));
	loc2 = eif_bit_or(((EIF_INTEGER_16) 3L),ti2_1);
	inline_F14_225(loc1, arg2, ((EIF_INTEGER_32) 0L), (EIF_INTEGER_16 *) &(loc2), ((EIF_INTEGER_32) 2L));
	ti4_1 = inline_F14_234();
	ti4_2 = inline_F14_236();
	ti4_3 = inline_F14_237();
	inline_F14_224(loc1, arg2, arg3, ti4_1, ti4_2, ti4_3);
}

/* {GDK_X11}.x_display */
EIF_POINTER F14_220 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	Result = inline_F14_220 ((EIF_POINTER) arg1);
	return Result;
}

/* {GDK_X11}.x_window */
EIF_POINTER F14_221 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	Result = inline_F14_221 ((EIF_POINTER) arg1);
	return Result;
}

/* {GDK_X11}.x_set_function */
void F14_222 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	
	
	inline_F14_222 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
}

/* {GDK_X11}.x_set_subwindow_mode */
void F14_223 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	
	
	inline_F14_223 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
}

/* {GDK_X11}.x_set_line_attributes */
void F14_224 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	
	
	inline_F14_224 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6);
}

/* {GDK_X11}.x_set_dashes */
void F14_225 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	
	
	inline_F14_225 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
}

/* {GDK_X11}.x_set_fill_style */
void F14_226 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	
	
	inline_F14_226 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
}

/* {GDK_X11}.x_flush */
void F14_228 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	
	
	inline_F14_228 ((EIF_POINTER) arg1);
}

/* {GDK_X11}.x_fill_solid */
EIF_INTEGER_32 F14_229 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_229 ();
	return Result;
}

/* {GDK_X11}.x_fill_tiled */
EIF_INTEGER_32 F14_230 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_230 ();
	return Result;
}

/* {GDK_X11}.x_style_line_on_off_dash */
EIF_INTEGER_32 F14_234 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_234 ();
	return Result;
}

/* {GDK_X11}.x_style_line_solid */
EIF_INTEGER_32 F14_235 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_235 ();
	return Result;
}

/* {GDK_X11}.x_style_cap_butt */
EIF_INTEGER_32 F14_236 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_236 ();
	return Result;
}

/* {GDK_X11}.x_style_join_bevel */
EIF_INTEGER_32 F14_237 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_237 ();
	return Result;
}

/* {GDK_X11}.x_subwindow_mode_include_inferiors */
EIF_INTEGER_32 F14_239 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_239 ();
	return Result;
}

/* {GDK_X11}.set_drawable_background */
void F14_240 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	
	
	RTGC;
	loc1 = inline_F14_220(arg1);
	inline_F14_242(loc1, arg2, arg3, arg4, arg5);
}

/* {GDK_X11}.set_drawable_foreground */
void F14_241 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	
	
	RTGC;
	loc1 = inline_F14_220(arg1);
	inline_F14_243(loc1, arg2, arg3, arg4, arg5);
}

/* {GDK_X11}.x_set_background */
void F14_242 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	
	
	inline_F14_242 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
}

/* {GDK_X11}.x_set_foreground */
void F14_243 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	
	
	inline_F14_243 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
}

/* {GDK_X11}.x_function_gxand */
EIF_INTEGER_32 F14_245 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_245 ();
	return Result;
}

/* {GDK_X11}.x_function_gxcopy */
EIF_INTEGER_32 F14_247 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_247 ();
	return Result;
}

/* {GDK_X11}.x_function_gxxor */
EIF_INTEGER_32 F14_250 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_250 ();
	return Result;
}

/* {GDK_X11}.x_function_gxor */
EIF_INTEGER_32 F14_251 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_251 ();
	return Result;
}

/* {GDK_X11}.x_function_gxinvert */
EIF_INTEGER_32 F14_254 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F14_254 ();
	return Result;
}

/* {GDK_X11}.draw_line */
void F14_260 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	GTCX
	
	
	inline_F14_260 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7);
}

/* {GDK_X11}.draw_point */
void F14_261 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	
	
	inline_F14_261 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
}

/* {GDK_X11}.draw_arc */
void F14_262 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	GTCX
	
	
	inline_F14_262 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8, (EIF_INTEGER_32) arg9, (EIF_INTEGER_32) arg10);
}

/* {GDK_X11}.draw_rectangle */
void F14_263 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	GTCX
	
	
	inline_F14_263 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8);
}

/* {GDK_X11}.draw_lines */
void F14_264 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	
	
	inline_F14_264 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
}

/* {GDK_X11}.draw_polygon */
void F14_265 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	
	
	inline_F14_265 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_POINTER) arg5, (EIF_INTEGER_32) arg6);
}

void EIF_Minit14 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
