/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.xquery.XQException;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.SingleByteCharsetConverter;

public class XQuerySerializationWriter
extends Writer {
    private final SingleByteCharsetConverter converter;
    private final OutputStream out;

    public XQuerySerializationWriter(OutputStream out, Properties properties) throws XQException {
        if (properties == null) {
            throw new RuntimeException("Properties can not be null.");
        }
        String encoding = properties.getProperty("encoding", "UTF-8");
        this.out = out;
        try {
            this.converter = SingleByteCharsetConverter.getInstance(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XQExceptionImpl("Unsupported Character encoding \"" + encoding + "\".", "XQJCE202", e);
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.out.write(this.converter.toBytes(cbuf));
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(this.converter.toBytes(cbuf, off, len));
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write(this.converter.toByte((char)c));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

