/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.query.NumericRange;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IntPos;
import org.basex.query.expr.Range;
import org.basex.query.expr.Single;
import org.basex.query.expr.index.RangeAccess;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public final class CmpR
extends Single {
    private static final double MAX_INTEGER = 9.007199254740992E15;
    final double min;
    final double max;
    private boolean single;

    private CmpR(Expr expr, double min, double max, InputInfo info) {
        super(info, expr, Types.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    static Expr get(CompileContext cc, InputInfo info, Expr expr, double min, double max) throws QueryException {
        return min > max ? Bln.FALSE : (min == Double.NEGATIVE_INFINITY && max == Double.POSITIVE_INFINITY ? cc.function(Function.EXISTS, info, expr) : new CmpR(expr, min, max, info).optimize(cc));
    }

    static Expr get(CompileContext cc, CmpG cmp) throws QueryException {
        ANum num;
        double mx;
        double mn;
        Expr expr1 = cmp.exprs[0];
        Expr expr2 = cmp.exprs[1];
        if (cmp.has(Flag.NDT)) {
            return cmp;
        }
        Type type1 = expr1.seqType().type;
        boolean int1 = type1.instanceOf(AtomType.INTEGER);
        if (!(type1.isUntyped() || type1.oneOf(AtomType.FLOAT, AtomType.DOUBLE) || int1)) {
            return cmp;
        }
        if (expr2 instanceof RangeSeq) {
            RangeSeq rs = (RangeSeq)expr2;
            mn = rs.min();
            mx = rs.max();
        } else if (!(!(expr2 instanceof ANum) || (num = (ANum)expr2) instanceof Dec && int1)) {
            mx = mn = num.dbl();
        } else {
            return cmp;
        }
        if (int1 && (Math.abs(mn) >= 9.007199254740992E15 || Math.abs(mx) >= 9.007199254740992E15)) {
            return cmp;
        }
        switch (cmp.op) {
            case GE: {
                mx = Double.POSITIVE_INFINITY;
                break;
            }
            case GT: {
                mn = Math.nextUp(mn);
                mx = Double.POSITIVE_INFINITY;
                break;
            }
            case LE: {
                mn = Double.NEGATIVE_INFINITY;
                break;
            }
            case LT: {
                mn = Double.NEGATIVE_INFINITY;
                mx = Math.nextDown(mx);
                break;
            }
            default: {
                return cmp;
            }
        }
        return CmpR.get(cc, cmp.info, expr1, mn, mx);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        SeqType st = this.expr.seqType();
        boolean bl = this.single = st.zeroOrOne() && !st.mayBeArray();
        if (Function.POSITION.is(this.expr)) {
            long mn = Math.max((long)Math.ceil(this.min), 1L);
            long mx = (long)Math.floor(this.max);
            return cc.replaceWith(this, IntPos.get(mn, mx, this.info));
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Item item;
        if (this.single) {
            Item item2 = this.expr.item(qc, this.info);
            return !item2.isEmpty() && this.inRange(item2);
        }
        if (this.expr instanceof Range || this.expr instanceof RangeSeq) {
            Value value = this.expr.value(qc);
            long size = value.size();
            if (size == 0L) {
                return false;
            }
            if (size == 1L) {
                return this.inRange((Item)value);
            }
            RangeSeq rs = (RangeSeq)value;
            return (double)rs.max() >= this.min && (double)rs.min() <= this.max;
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.inRange(item)) continue;
            return true;
        }
        return false;
    }

    private boolean inRange(Item item) throws QueryException {
        double value = item.dbl(this.info);
        return value >= this.min && value <= this.max;
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) throws QueryException {
        Double newMin = null;
        Double newMax = null;
        if (ex instanceof CmpR) {
            CmpR cmp = (CmpR)ex;
            newMin = cmp.min;
            newMax = cmp.max;
        } else if (ex instanceof CmpG) {
            Expr expr;
            CmpG cmp = (CmpG)ex;
            if (cmp.op == CmpG.OpG.EQ && (expr = ex.arg(1)) instanceof ANum) {
                ANum num = (ANum)expr;
                newMax = newMin = Double.valueOf(num.dbl());
            }
        }
        if (newMin == null || !this.expr.equals(ex.arg(0)) || or && (this.max < newMin || this.min > newMax)) {
            return null;
        }
        newMin = or ? Math.min(this.min, newMin) : Math.max(this.min, newMin);
        newMax = or ? Math.max(this.max, newMax) : Math.min(this.max, newMax);
        return CmpR.get(cc, this.info, this.expr, newMin, newMax);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        int mxl;
        Data data = ii.db.data();
        if (data == null ? !ii.enforce() : data.inMemory()) {
            return false;
        }
        IndexType type = ii.type(this.expr, null);
        if (type == null) {
            return false;
        }
        Stats key = this.key(ii, type);
        if (key == null) {
            return false;
        }
        NumericRange nr = new NumericRange(type, Math.max(this.min, key.min), Math.min(this.max, key.max));
        if (nr.min() > nr.max() || nr.max() < key.min || nr.min() > key.max) {
            ii.costs = IndexCosts.get(0);
            return true;
        }
        ii.costs = IndexInfo.costs(data, nr);
        if (ii.costs == null) {
            return false;
        }
        int mnl = this.min >= 0.0 && (double)((long)this.min) == this.min ? Token.token(this.min).length : -1;
        int n = mxl = this.max >= 0.0 && (double)((long)this.max) == this.max ? Token.token(this.max).length : -1;
        if (mnl == -1 || mnl != mxl) {
            return false;
        }
        if (Token.token((int)nr.min()).length != Token.token((int)nr.max()).length) {
            return false;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(91).add(this.min).add(44).add(this.max).add(93);
        ii.create(new RangeAccess(this.info, nr, ii.db), true, Util.info("apply % index for %", "range", tb), this.info);
        return true;
    }

    private Stats key(IndexInfo ii, IndexType type) {
        NameTest test;
        Data data;
        block7: {
            NameTest nt;
            block9: {
                block8: {
                    Step step;
                    Expr expr;
                    data = ii.db.data();
                    if (!(data != null && data.meta.uptodate && data.nspaces.isEmpty() && (expr = this.expr) instanceof AxisPath)) {
                        return null;
                    }
                    AxisPath path = (AxisPath)expr;
                    test = ii.test;
                    if (test != null) break block7;
                    int st = path.steps.length - 1;
                    if (type == IndexType.TEXT) {
                        step = st == 0 ? ii.step : path.step(st - 1);
                    } else {
                        step = path.step(st);
                        if (step.axis != Axis.ATTRIBUTE || step.exprs.length > 0) {
                            return null;
                        }
                    }
                    Test test2 = step.test;
                    if (!(test2 instanceof NameTest)) break block8;
                    nt = (NameTest)test2;
                    if (nt.local != null) break block9;
                }
                return null;
            }
            test = nt;
        }
        Names names = type == IndexType.TEXT ? data.elemNames : data.attrNames;
        Stats stats = names.stats(names.index(test.qname.local()));
        return stats != null && StatsType.isNumeric(stats.type) ? stats : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        CmpR cmp = new CmpR(this.expr.copy(cc, vm), this.min, this.max, this.info);
        cmp.single = this.single;
        return this.copyType(cmp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CmpR)) return false;
        CmpR cmp = (CmpR)obj;
        if (this.min != cmp.min) return false;
        if (this.max != cmp.max) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "range comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max, "single", this.single), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        if (this.min == this.max) {
            qs.token(this.expr).token("=").token(this.min);
        } else {
            if (this.min != Double.NEGATIVE_INFINITY) {
                qs.token(this.expr).token(">=").token(this.min);
            }
            if (this.min != Double.NEGATIVE_INFINITY && this.max != Double.POSITIVE_INFINITY) {
                qs.token("and");
            }
            if (this.max != Double.POSITIVE_INFINITY) {
                qs.token(this.expr).token("<=").token(this.max);
            }
        }
    }
}

