/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.io.out.PrintOutput;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.util.Strings;
import org.basex.util.list.IntList;
import org.xml.sax.InputSource;

public final class BinaryPut
extends ACreate {
    public BinaryPut(String path) {
        this(path, (String)null);
    }

    public BinaryPut(String path, String input) {
        super(Perm.WRITE, true, path == null ? "" : path, input);
    }

    @Override
    protected boolean run() {
        Data data;
        boolean create = this.context.user().has(Perm.CREATE);
        Object path = MetaData.normPath(this.args[0]);
        if (path == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        if (this.in == null) {
            IO io = IO.get(this.args[1]);
            if (!io.exists() || io.isDir()) {
                return this.error(Text.RES_NOT_FOUND_X, create ? io : this.args[1]);
            }
            this.in = io.inputSource();
            if ((((String)path).isEmpty() || Strings.endsWith((String)path, '/')) && !(io instanceof IOContent)) {
                path = (String)path + io.name();
            }
        }
        if ((data = this.context.data()).inMemory()) {
            return this.error(Text.NO_MAINMEM, new Object[0]);
        }
        if (((String)path).isEmpty()) {
            return this.error(Text.PATH_INVALID_X, create ? path : this.args[0]);
        }
        IOFile bin = data.meta.file((String)path, ResourceType.BINARY);
        String pth = path;
        return this.update(data, () -> this.put(data, bin, pth));
    }

    private boolean put(Data data, IOFile bin, String path) throws IOException {
        IntList docs = data.resources.docs(path);
        if (this.options.get(MainOptions.REPLACE).booleanValue() || docs.isEmpty() && !bin.exists()) {
            AtomicUpdateCache auc = new AtomicUpdateCache(data);
            for (int pre : docs.toArray()) {
                auc.addDelete(pre);
            }
            auc.execute(false);
            BinaryPut.put(this.in, bin);
        }
        return this.info(Text.QUERY_EXECUTED_X_X, "", this.jc().performance);
    }

    public static void put(InputSource in, IOFile file) throws IOException {
        block17: {
            if (file.isDir()) {
                file.delete();
            }
            file.parent().md();
            try (PrintOutput po = new PrintOutput(file);){
                Reader r = in.getCharacterStream();
                InputStream is = in.getByteStream();
                String id = in.getSystemId();
                if (r != null) {
                    int c;
                    while ((c = r.read()) != -1) {
                        po.print(c);
                    }
                    break block17;
                }
                if (is != null) {
                    int b;
                    while ((b = is.read()) != -1) {
                        po.write(b);
                    }
                    break block17;
                }
                if (id == null) break block17;
                try (BufferInput bi = BufferInput.get(IO.get(id));){
                    int b;
                    while ((b = bi.read()) != -1) {
                        po.write(b);
                    }
                }
            }
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.BINARY) + " " + String.valueOf((Object)Commands.CmdBinary.PUT)).arg("TO", 0).add(1);
    }
}

