/** @file

Copyright (c) 2024, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#include <MemInfoHob.h>

///
/// The ChipsetInit Info structure provides the information of ME ChipsetInit CRC and BIOS ChipsetInit CRC.
///
typedef struct {
  UINT8             Revision;         ///< Chipset Init Info Revision
  UINT8             Rsvd[3];          ///< Reserved
  UINT16            MeChipInitCrc;    ///< 16 bit CRC value of MeChipInit Table
  UINT16            BiosChipInitCrc;  ///< 16 bit CRC value of PchChipInit Table
} CHIPSET_INIT_INFO;


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - Platform Reserved Memory Size
  The minimum platform memory size required to pass control into DXE
**/
  UINT64                      PlatformMemorySize;

/** Offset 0x0048 - SPD Data Length
  Length of SPD Data
  0x100:256 Bytes, 0x200:512 Bytes, 0x400:1024 Bytes
**/
  UINT16                      MemorySpdDataLen;

/** Offset 0x004A - Enable above 4GB MMIO resource support
  DEPRECATED. Enable/disable above 4GB MMIO resource support
  $EN_DIS
**/
  UINT8                       EnableAbove4GBMmio;

/** Offset 0x004B - Ibecc Ec Dis
  This option enables or disables the Ibecc Control register Ec Dis field. Default
  0 = Enabled.
  $EN_DIS
**/
  UINT8                       IbeccEcDis;

/** Offset 0x004C - Memory SPD Pointer Controller 0 Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr000;

/** Offset 0x0050 - Memory SPD Pointer Controller 0 Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr001;

/** Offset 0x0054 - Memory SPD Pointer Controller 0 Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr010;

/** Offset 0x0058 - Memory SPD Pointer Controller 0 Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr011;

/** Offset 0x005C - Memory SPD Pointer Controller 0 Channel 2 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr020;

/** Offset 0x0060 - Memory SPD Pointer Controller 0 Channel 2 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr021;

/** Offset 0x0064 - Memory SPD Pointer Controller 0 Channel 3 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr030;

/** Offset 0x0068 - Memory SPD Pointer Controller 0 Channel 3 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr031;

/** Offset 0x006C - Memory SPD Pointer Controller 1 Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr100;

/** Offset 0x0070 - Memory SPD Pointer Controller 1 Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr101;

/** Offset 0x0074 - Memory SPD Pointer Controller 1 Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr110;

/** Offset 0x0078 - Memory SPD Pointer Controller 1 Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr111;

/** Offset 0x007C - Memory SPD Pointer Controller 1 Channel 2 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr120;

/** Offset 0x0080 - Memory SPD Pointer Controller 1 Channel 2 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr121;

/** Offset 0x0084 - Memory SPD Pointer Controller 1 Channel 3 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr130;

/** Offset 0x0088 - Memory SPD Pointer Controller 1 Channel 3 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr131;

/** Offset 0x008C - RcompResistor settings
  Indicates  RcompResistor settings: Board-dependent
**/
  UINT16                      RcompResistor;

/** Offset 0x008E - RcompTarget settings
  RcompTarget settings: board-dependent
**/
  UINT16                      RcompTarget[5];

/** Offset 0x0098 - Dqs Map CPU to DRAM MC 0 CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch0[2];

/** Offset 0x009A - Dqs Map CPU to DRAM MC 0 CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch1[2];

/** Offset 0x009C - Dqs Map CPU to DRAM MC 0 CH 2
  Set Dqs mapping relationship between CPU and DRAM, Channel 2: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch2[2];

/** Offset 0x009E - Dqs Map CPU to DRAM MC 0 CH 3
  Set Dqs mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc0Ch3[2];

/** Offset 0x00A0 - Dqs Map CPU to DRAM MC 1 CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch0[2];

/** Offset 0x00A2 - Dqs Map CPU to DRAM MC 1 CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch1[2];

/** Offset 0x00A4 - Dqs Map CPU to DRAM MC 1 CH 2
  Set Dqs mapping relationship between CPU and DRAM, Channel 2: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch2[2];

/** Offset 0x00A6 - Dqs Map CPU to DRAM MC 1 CH 3
  Set Dqs mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqsMapCpu2DramMc1Ch3[2];

/** Offset 0x00A8 - Dq Map CPU to DRAM MC 0 CH 0
  Set Dq mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqMapCpu2DramMc0Ch0[16];

/** Offset 0x00B8 - Dq Map CPU to DRAM MC 0 CH 1
  Set Dq mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqMapCpu2DramMc0Ch1[16];

/** Offset 0x00C8 - Dq Map CPU to DRAM MC 0 CH 2
  Set Dq mapping relationship between CPU and DRAM, Channel 2: board-dependent
**/
  UINT8                       DqMapCpu2DramMc0Ch2[16];

/** Offset 0x00D8 - Dq Map CPU to DRAM MC 0 CH 3
  Set Dq mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqMapCpu2DramMc0Ch3[16];

/** Offset 0x00E8 - Dq Map CPU to DRAM MC 1 CH 0
  Set Dq mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch0[16];

/** Offset 0x00F8 - Dq Map CPU to DRAM MC 1 CH 1
  Set Dq mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch1[16];

/** Offset 0x0108 - Dq Map CPU to DRAM MC 1 CH 2
  Set Dq mapping relationship between CPU and DRAM, Channel 2: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch2[16];

/** Offset 0x0118 - Dq Map CPU to DRAM MC 1 CH 3
  Set Dq mapping relationship between CPU and DRAM, Channel 3: board-dependent
**/
  UINT8                       DqMapCpu2DramMc1Ch3[16];

/** Offset 0x0128 - Dqs Pins Interleaved Setting
  Indicates DqPinsInterleaved setting: board-dependent
  $EN_DIS
**/
  UINT8                       DqPinsInterleaved;

/** Offset 0x0129 - Smram Mask
  The SMM Regions AB-SEG and/or H-SEG reserved
  0: Neither, 1:AB-SEG, 2:H-SEG, 3: Both
**/
  UINT8                       SmramMask;

/** Offset 0x012A - MRC Fast Boot
  Enables/Disable the MRC fast path thru the MRC
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x012B - Rank Margin Tool per Task
  This option enables the user to execute Rank Margin Tool per major training step
  in the MRC.
  $EN_DIS
**/
  UINT8                       RmtPerTask;

/** Offset 0x012C - Training Trace
  This option enables the trained state tracing feature in MRC.  This feature will
  print out the key training parameters state across major training steps.
  $EN_DIS
**/
  UINT8                       TrainTrace;

/** Offset 0x012D - RxVrefTempCoeff
  Default = 6. Range from 0-255
**/
  UINT8                       RxVrefTempCoeff;

/** Offset 0x012E - CaParityPatternRotation
  Default = 0 (Auto). 1 for High stress pattern rotation, 2 for no rotation.
**/
  UINT8                       CaParityPatternRotation;

/** Offset 0x012F - WCK Offset
  This option enables the WCK Offset WA for Hynix32 with freq >= 5600.
  $EN_DIS
**/
  UINT8                       WckOffsetWa;

/** Offset 0x0130 - Tseg Size
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
  0x0400000:4MB, 0x01000000:16MB
**/
  UINT32                      TsegSize;

/** Offset 0x0134 - MMIO Size
  Size of MMIO space reserved for devices. 0(Default)=Auto, non-Zero=size in MB
**/
  UINT16                      MmioSize;

/** Offset 0x0136 - Probeless Trace
  Probeless Trace: 0=Disabled, 1=Enable. Enabling Probeless Trace will reserve 128MB.
  This also requires IED to be enabled.
  $EN_DIS
**/
  UINT8                       ProbelessTrace;

/** Offset 0x0137 - Enable SMBus
  Enable/disable SMBus controller.
  $EN_DIS
**/
  UINT8                       SmbusEnable;

/** Offset 0x0138 - Spd Address Tabl
  Specify SPD Address table for CH0D0/CH0D1/CH1D0&CH1D1. MemorySpdPtr will be used
  if SPD Address is 00
**/
  UINT8                       SpdAddressTable[16];

/** Offset 0x0148 - Platform Debug Consent
  Enabled Trace active: TraceHub is enabled and trace is active, blocks s0ix.\n
  \n
  Enabled Trace ready: TraceHub is enabled and allowed S0ix.\n
  \n
  Enabled Trace power off: TraceHub is powergated, provide setting close to functional
  low power state\n
  \n
  Manual: user needs to configure Advanced Debug Settings manually, aimed at advanced users
  0:Disabled, 2:Enabled Trace Active, 4:Enabled Trace Ready, 6:Enable Trace Power-Off, 7:Manual
**/
  UINT8                       PlatformDebugOption;

/** Offset 0x0149 - DCI Enable
  Determine if to enable DCI debug from host
  $EN_DIS
**/
  UINT8                       DciEn;

/** Offset 0x014A - DCI Clock Enable
  Enable/Disable DCI clock in lowest power state
  $EN_DIS
**/
  UINT8                       DciClkEnable;

/** Offset 0x014B - DCI DbC Mode
  Disabled: Clear both USB2/3DBCEN; USB2: set USB2DBCEN; USB3: set USB3DBCEN; Both:
  Set both USB2/3DBCEN; No Change: Comply with HW value
  0:Disabled, 1:USB2 DbC, 2:USB3 DbC, 3:Both, 4:No Change
**/
  UINT8                       DciDbcMode;

/** Offset 0x014C - USB3 Type-C UFP2DFP Kernel/Platform Debug Support
  This BIOS option enables kernel and platform debug for USB3 interface over a UFP
  Type-C receptacle, select 'No Change' will do nothing to UFP2DFP setting.
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DciUsb3TypecUfpDbg;

/** Offset 0x014D - SOC Trace Hub Mode
  Enable/Disable SOC TraceHub
  $EN_DIS
**/
  UINT8                       SocTraceHubMode;

/** Offset 0x014E - SOC Trace Hub Memory Region 0 buffer Size
  Select size of memory region 0 buffer. Memory allocated by BIOS only applies to
  ITH tool running on the host. For ITH tool running on the target, choose None/OS,
  memory shall be allocated by tool. User should be cautious to choose the amount
  of memory. If chosen size is larger than half of system memory, setup will automatically
  rollback to default value.
  0x00:1MB, 0x03:8MB, 0x06:64MB, 0x07:128MB, 0x08:256MB, 0x09:512MB, 0x0A:1GB, 0x0B:2GB,
  0x0C:4GB, 0x0D:8GB, 0x0E:0MB
**/
  UINT16                      SocTraceHubMemReg0Size;

/** Offset 0x0150 - SOC Trace Hub Memory Region 1 buffer Size
  Select size of memory region 1 buffer. Memory allocated by BIOS only applies to
  ITH tool running on the host. For ITH tool running on the target, choose None/OS,
  memory shall be allocated by tool. User should be cautious to choose the amount
  of memory. If chosen size is larger than half of system memory, setup will automatically
  rollback to default value.
  0x00:1MB, 0x03:8MB, 0x06:64MB, 0x07:128MB, 0x08:256MB, 0x09:512MB, 0x0A:1GB, 0x0B:2GB,
  0x0C:4GB, 0x0D:8GB, 0x0E:0MB
**/
  UINT16                      SocTraceHubMemReg1Size;

/** Offset 0x0152 - Keep Early Trace
  Trace is activated by default. When enable, keep early trace data and keep tracing,
  may block s0ix.\n
  When disabled will abandon trace data and stop tracing which allows enter s0ix\n
  \n
  noted:enable this option will not enable TraceHub; When probe is connected, keep
  early trace will then be configured by tool, this option will not take effect.
  $EN_DIS
**/
  UINT8                       KeepEarlyTrace;

/** Offset 0x0153 - PCH Trace Hub Mode
  Enable/Disable PCH TraceHub
  $EN_DIS
**/
  UINT8                       PchTraceHubMode;

/** Offset 0x0154 - PCH Trace Hub Memory Region 0 buffer Size
  Select size of memory region 0 buffer. Memory allocated by BIOS only applies to
  ITH tool running on the host. For ITH tool running on the target, choose None/OS,
  memory shall be allocated by tool. User should be cautious to choose the amount
  of memory. If chosen size is larger than half of system memory, setup will automatically
  rollback to default value.
  0x00:1MB, 0x03:8MB, 0x06:64MB, 0x07:128MB, 0x08:256MB, 0x09:512MB, 0x0A:1GB, 0x0B:2GB,
  0x0C:4GB, 0x0D:8GB, 0x0E:0MB
**/
  UINT16                      PchTraceHubMemReg0Size;

/** Offset 0x0156 - PCH Trace Hub Memory Region 1 buffer Size
  Select size of memory region 1 buffer. Memory allocated by BIOS only applies to
  ITH tool running on the host. For ITH tool running on the target, choose None/OS,
  memory shall be allocated by tool. User should be cautious to choose the amount
  of memory. If chosen size is larger than half of system memory, setup will automatically
  rollback to default value.
  0x00:1MB, 0x03:8MB, 0x06:64MB, 0x07:128MB, 0x08:256MB, 0x09:512MB, 0x0A:1GB, 0x0B:2GB,
  0x0C:4GB, 0x0D:8GB, 0x0E:0MB
**/
  UINT16                      PchTraceHubMemReg1Size;

/** Offset 0x0158 - IOE Debug Enable
  Enable/Disable IOE Debug. When enabled, IOE D2D Dfx link will keep up and clock
  is enabled
  $EN_DIS
**/
  UINT8                       IoeDebugEn;

/** Offset 0x0159 - Pmode Clock Enable
  Enable/Disable PMODE clock. When enabled, Pmode clock will toggle for XDP use
  $EN_DIS
**/
  UINT8                       PmodeClkEn;

/** Offset 0x015A - AET Trace Hub Mode Select
  Select AET to Trace Hub destination.
  0:SOC Trace Hub, 1:PCH Trace Hub
**/
  UINT8                       AetTraceHubMode;

/** Offset 0x015B - BIOS trace destination
  Select BIOS trace destination.
  0:SOC Trace Hub, 1:PCH Trace Hub
**/
  UINT8                       BiosTraceSinkMode;

/** Offset 0x015C - HD Audio DMIC Link Clock Select
  Determines DMIC<N> Clock Source. 0: Both, 1: ClkA, 2: ClkB
  0: Both, 1: ClkA, 2: ClkB
**/
  UINT8                       PchHdaAudioLinkDmicClockSelect[2];

/** Offset 0x015E - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOut;

/** Offset 0x015F - State of DMA_CONTROL_GUARANTEE bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       DmaControlGuarantee;

/** Offset 0x0160 - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddress[9];

/** Offset 0x0184 - Disable VT-d
  0=Enable/FALSE(VT-d enabled), 1=Disable/TRUE (VT-d disabled)
  $EN_DIS
**/
  UINT8                       VtdDisable;

/** Offset 0x0185 - Vtd Programming for Igd
  1=Enable/TRUE (Igd VT-d Bar programming enabled), 0=Disable/FLASE (Igd VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIgdEnable;

/** Offset 0x0186 - Vtd Programming for Iop
  1=Enable/TRUE (Iop VT-d Bar programming enabled), 0=Disable/FLASE (Iop VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIopEnable;

/** Offset 0x0187 - Internal Graphics Pre-allocated Memory
  Size of memory preallocated for internal graphics.
  0x00:0MB, 0x01:32MB, 0x02:64MB, 0x03:96MB, 0x04:128MB, 0xF0:4MB, 0xF1:8MB, 0xF2:12MB,
  0xF3:16MB, 0xF4:20MB, 0xF5:24MB, 0xF6:28MB, 0xF7:32MB, 0xF8:36MB, 0xF9:40MB, 0xFA:44MB,
  0xFB:48MB, 0xFC:52MB, 0xFD:56MB, 0xFE:60MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x0188 - Internal Graphics
  Enable/disable internal graphics.
  $EN_DIS
**/
  UINT8                       InternalGfx;

/** Offset 0x0189 - Oem T12 Dealy Override
  Oem T12 Dealy Override. 0(Default)=Disable  1=Enable
  $EN_DIS
**/
  UINT8                       OemT12DelayOverride;

/** Offset 0x018A - Board Type
  MrcBoardType, Options are 0=Mobile/Mobile Halo, 1=Desktop/DT Halo, 5=ULT/ULX/Mobile
  Halo, 7=UP Server
  0:Mobile/Mobile Halo, 1:Desktop/DT Halo, 5:ULT/ULX/Mobile Halo, 7:UP Server
**/
  UINT8                       UserBd;

/** Offset 0x018B - MRC Retraining on RTC Power Loss
  Specifies whether MRC memory training will occur when RTC power loss is detected.
  Options are 0=Memory will be re-trained if RTC power loss is detected. 1=Memory
  will not be re-trained when RTC power loss is detected. (Typically used on board
  designs without a dedicated RTC battery)
  0:Disabled, 1:Enabled
**/
  UINT8                       DisableMrcRetrainingOnRtcPowerLoss;

/** Offset 0x018C - DDR Frequency Limit
  Maximum Memory Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867,
  2133, 2400, 2667, 2933 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 2667:2667, 2933:2933, 0:Auto
**/
  UINT16                      DdrFreqLimit;

/** Offset 0x018E - SAGV
  System Agent dynamic frequency support.
  0:Disabled, 1:Enabled
**/
  UINT8                       SaGv;

/** Offset 0x018F - SAGV WP Mask
  System Agent dynamic frequency workpoints that memory will be training at the enabled
  frequencies.
  0x3:Points0_1, 0x7:Points0_1_2, 0xF:AllPoints0_1_2_3
**/
  UINT8                       SaGvWpMask;

/** Offset 0x0190 - Memory Test on Warm Boot
  Run Base Memory Test on Warm Boot
  0:Disable, 1:Enable
**/
  UINT8                       MemTestOnWarmBoot;

/** Offset 0x0191 - DDR Speed Control
  DDR Frequency and Gear control for all SAGV points.
  0:Auto, 1:Manual
**/
  UINT8                       DdrSpeedControl;

/** Offset 0x0192 - Controller 0 Channel 0 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 0
  $EN_DIS
**/
  UINT8                       DisableMc0Ch0;

/** Offset 0x0193 - Controller 0 Channel 1 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 1
  $EN_DIS
**/
  UINT8                       DisableMc0Ch1;

/** Offset 0x0194 - Controller 0 Channel 2 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 2
  $EN_DIS
**/
  UINT8                       DisableMc0Ch2;

/** Offset 0x0195 - Controller 0 Channel 3 DIMM Control
  Enable / Disable DIMMs on Controller 0 Channel 3
  $EN_DIS
**/
  UINT8                       DisableMc0Ch3;

/** Offset 0x0196 - Controller 1 Channel 0 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 0
  $EN_DIS
**/
  UINT8                       DisableMc1Ch0;

/** Offset 0x0197 - Controller 1 Channel 1 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 1
  $EN_DIS
**/
  UINT8                       DisableMc1Ch1;

/** Offset 0x0198 - Controller 1 Channel 2 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 2
  $EN_DIS
**/
  UINT8                       DisableMc1Ch2;

/** Offset 0x0199 - Controller 1 Channel 3 DIMM Control
  Enable / Disable DIMMs on Controller 1 Channel 3
  $EN_DIS
**/
  UINT8                       DisableMc1Ch3;

/** Offset 0x019A - Scrambler Support
  This option enables data scrambling in memory.
  $EN_DIS
**/
  UINT8                       ScramblerSupport;

/** Offset 0x019B - SPD Profile Selected
  Select DIMM timing profile. Options are 0:Default SPD Profile, 1:Custom Profile,
  2:XMP Profile 1, 3:XMP Profile 2, 4:XMP Profile 3, 5:XMP User Profile 4, 6:XMP
  User Profile 5
  0:Default SPD Profile, 1:Custom Profile, 2:XMP Profile 1, 3:XMP Profile 2, 4:XMP
  Profile 3, 5:XMP User Profile 4, 6:XMP User Profile 5
**/
  UINT8                       SpdProfileSelected;

/** Offset 0x019C - Dynamic Memory Boost
  0(Default): Disable, 1: Enable. When enabled, MRC will train the Default SPD Profile,
  and also the profile selected by SpdProfileSelected, to allow automatic switching
  during runtime. Only valid if SpdProfileSelected is an XMP Profile, otherwise ignored.
  $EN_DIS
**/
  UINT8                       DynamicMemoryBoost;

/** Offset 0x019D - Realtime Memory Frequency
  0(Default): Disabled, 1: Enabled. Ignored unless SpdProfileSelected is XMP Profile
  1. If enabled, MRC will train the Default SPD Profile, and also XMP Profile 1,
  to allow manually triggered switching between frequencies at runtime.
  $EN_DIS
**/
  UINT8                       RealtimeMemoryFrequency;

/** Offset 0x019E - OC Safe Mode
  Bitmap: Ignored unless SpdProfileSelected is an XMP Profile. Bit 0: Use safe tCL,
  Bit 1: Limit tWR, tRTP, tCCD_L, tCCD_L_WR, tCL to of freq 6400 when programming
  Dimm MR if DIMM doesn't support new spec.
  $EN_DIS
**/
  UINT8                       OCSafeMode;

/** Offset 0x019F - tRRSG Delta
  Delay between Read-to-Read commands in the same Bank Group. 0 - Auto. Signed TAT
  delta is (Value - 128). Input value range of [0..255] will give a TAT delta range
  of [-127..127]
**/
  UINT8                       tRRSG;

/** Offset 0x01A0 - tRRDG Delta
  Delay between Read-to-Read commands in different Bank Group. 0 - Auto. Signed TAT
  delta is (Value - 128). Input value range of [0..255] will give a TAT delta range
  of [-127..127]
**/
  UINT8                       tRRDG;

/** Offset 0x01A1 - tRRDR Delta
  Delay between Read-to-Read commands in different Ranks. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tRRDR;

/** Offset 0x01A2 - tRRDD Delta
  Delay between Read-to-Read commands in different DIMMs. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tRRDD;

/** Offset 0x01A3 - tWRSG Delta
  Delay between Write-to-Read commands in the same Bank Group. 0 - Auto. Signed TAT
  delta is (Value - 128). Input value range of [0..255] will give a TAT delta range
  of [-127..127]
**/
  UINT8                       tWRSG;

/** Offset 0x01A4 - tWRDG Delta
  Delay between Write-to-Read commands in different Bank Group. 0 - Auto. Signed TAT
  delta is (Value - 128). Input value range of [0..255] will give a TAT delta range
  of [-127..127]
**/
  UINT8                       tWRDG;

/** Offset 0x01A5 - tWRDR Delta
  Delay between Write-to-Read commands in different Ranks. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tWRDR;

/** Offset 0x01A6 - tWRDD Delta
  Delay between Write-to-Read commands in different DIMMs. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tWRDD;

/** Offset 0x01A7 - tWWSG Delta
  Delay between Write-to-Write commands in the same Bank Group. 0 - Auto. Signed TAT
  delta is (Value - 128). Input value range of [0..255] will give a TAT delta range
  of [-127..127]
**/
  UINT8                       tWWSG;

/** Offset 0x01A8 - tWWDG Delta
  Delay between Write-to-Write commands in different Bank Group. 0 - Auto. Signed
  TAT delta is (Value - 128). Input value range of [0..255] will give a TAT delta
  range of [-127..127]
**/
  UINT8                       tWWDG;

/** Offset 0x01A9 - tWWDR Delta
  Delay between Write-to-Write commands in different Ranks. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tWWDR;

/** Offset 0x01AA - tWWDD Delta
  Delay between Write-to-Write commands in different DIMMs. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tWWDD;

/** Offset 0x01AB - tRWSG Delta
  Delay between Read-to-Write commands in the same Bank Group. 0 - Auto. Signed TAT
  delta is (Value - 128). Input value range of [0..255] will give a TAT delta range
  of [-127..127]
**/
  UINT8                       tRWSG;

/** Offset 0x01AC - tRWDG Delta
  Delay between Read-to-Write commands in different Bank Group. 0 - Auto. Signed TAT
  delta is (Value - 128). Input value range of [0..255] will give a TAT delta range
  of [-127..127]
**/
  UINT8                       tRWDG;

/** Offset 0x01AD - tRWDR Delta
  Delay between Read-to-Write commands in different Ranks. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tRWDR;

/** Offset 0x01AE - tRWDD Delta
  Delay between Read-to-Write commands in different DIMMs. 0 - Auto. Signed TAT delta
  is (Value - 128). Input value range of [0..255] will give a TAT delta range of
  [-127..127]
**/
  UINT8                       tRWDD;

/** Offset 0x01AF
**/
  UINT8                       Rsvd031[1];

/** Offset 0x01B0 - tREFI32
  Refresh Interval, 0: AUTO, max: 131071. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT32                      tREFI32;

/** Offset 0x01B4 - Vddq Voltage Override for NMOS
  # is multiple of 1mV where 0 means Auto.
**/
  UINT16                      VddqNmosVoltageOverride;

/** Offset 0x01B6 - Config BitMask to limit max freq at 3200
  BitMask where BIT0: 1R1R_8GB, BIT1: 1R1R_12GB, BIT2: 1R1R_16GB, BIT3: 1R1R_24GB,
  BIT4: 1R1R_8GB_12GB, BIT5: 1R1R_8GB_16GB, BIT6: 1R1R_8GB_24GB, BIT7: 1R1R_12GB_16GB,
  BIT8: 1R1R_12GB_24GB, BIT9: 1R1R_16GB_24GB, BIT10: 2R2R_32GB, BIT11: 2R2R_48GB,
  BIT12: 2R2R_32GB_48GB
**/
  UINT16                      FreqLimit3200Mask;

/** Offset 0x01B8 - Config BitMask to limit max freq at 3600
  BitMask where BIT0: 1R1R_8GB, BIT1: 1R1R_12GB, BIT2: 1R1R_16GB, BIT3: 1R1R_24GB,
  BIT4: 1R1R_8GB_12GB, BIT5: 1R1R_8GB_16GB, BIT6: 1R1R_8GB_24GB, BIT7: 1R1R_12GB_16GB,
  BIT8: 1R1R_12GB_24GB, BIT9: 1R1R_16GB_24GB, BIT10: 2R2R_32GB, BIT11: 2R2R_48GB,
  BIT12: 2R2R_32GB_48GB
**/
  UINT16                      FreqLimit3600Mask;

/** Offset 0x01BA - Config BitMask to limit max freq at 4000
  BitMask where BIT0: 1R1R_8GB, BIT1: 1R1R_12GB, BIT2: 1R1R_16GB, BIT3: 1R1R_24GB,
  BIT4: 1R1R_8GB_12GB, BIT5: 1R1R_8GB_16GB, BIT6: 1R1R_8GB_24GB, BIT7: 1R1R_12GB_16GB,
  BIT8: 1R1R_12GB_24GB, BIT9: 1R1R_16GB_24GB, BIT10: 2R2R_32GB, BIT11: 2R2R_48GB,
  BIT12: 2R2R_32GB_48GB
**/
  UINT16                      FreqLimit4000Mask;

/** Offset 0x01BC - Config BitMask to limit max freq at 4400
  BitMask where BIT0: 1R1R_8GB, BIT1: 1R1R_12GB, BIT2: 1R1R_16GB, BIT3: 1R1R_24GB,
  BIT4: 1R1R_8GB_12GB, BIT5: 1R1R_8GB_16GB, BIT6: 1R1R_8GB_24GB, BIT7: 1R1R_12GB_16GB,
  BIT8: 1R1R_12GB_24GB, BIT9: 1R1R_16GB_24GB, BIT10: 2R2R_32GB, BIT11: 2R2R_48GB,
  BIT12: 2R2R_32GB_48GB
**/
  UINT16                      FreqLimit4400Mask;

/** Offset 0x01BE - Config BitMask to limit max freq at 4800
  BitMask where BIT0: 1R1R_8GB, BIT1: 1R1R_12GB, BIT2: 1R1R_16GB, BIT3: 1R1R_24GB,
  BIT4: 1R1R_8GB_12GB, BIT5: 1R1R_8GB_16GB, BIT6: 1R1R_8GB_24GB, BIT7: 1R1R_12GB_16GB,
  BIT8: 1R1R_12GB_24GB, BIT9: 1R1R_16GB_24GB, BIT10: 2R2R_32GB, BIT11: 2R2R_48GB,
  BIT12: 2R2R_32GB_48GB
**/
  UINT16                      FreqLimit4800Mask;

/** Offset 0x01C0 - Config BitMask to limit max freq at 5200
  BitMask where BIT0: 1R1R_8GB, BIT1: 1R1R_12GB, BIT2: 1R1R_16GB, BIT3: 1R1R_24GB,
  BIT4: 1R1R_8GB_12GB, BIT5: 1R1R_8GB_16GB, BIT6: 1R1R_8GB_24GB, BIT7: 1R1R_12GB_16GB,
  BIT8: 1R1R_12GB_24GB, BIT9: 1R1R_16GB_24GB, BIT10: 2R2R_32GB, BIT11: 2R2R_48GB,
  BIT12: 2R2R_32GB_48GB
**/
  UINT16                      FreqLimit5200Mask;

/** Offset 0x01C2 - Config BitMask to limit max freq at 5600
  BitMask where BIT0: 1R1R_8GB, BIT1: 1R1R_12GB, BIT2: 1R1R_16GB, BIT3: 1R1R_24GB,
  BIT4: 1R1R_8GB_12GB, BIT5: 1R1R_8GB_16GB, BIT6: 1R1R_8GB_24GB, BIT7: 1R1R_12GB_16GB,
  BIT8: 1R1R_12GB_24GB, BIT9: 1R1R_16GB_24GB, BIT10: 2R2R_32GB, BIT11: 2R2R_48GB,
  BIT12: 2R2R_32GB_48GB
**/
  UINT16                      FreqLimit5600Mask;

/** Offset 0x01C4 - 2DPC Enhanced Frequency Limit
  Enable/Disable Enhanced FreqLimit for 2DPC
  $EN_DIS
**/
  UINT8                       FreqLimitMaskEn;

/** Offset 0x01C5 - LP5x DRAM glitch workaround
  TA#814867 DRAM vendor-specific workaround, will increase boot time.
  $EN_DIS
**/
  UINT8                       lp5GlitchWAEnable;

/** Offset 0x01C6 - Initial DDR5 TxVref Override
  Override for initial DDR5 TxVref value , 0 = Auto (default), valid range from 350
  to 975, in increments of 5
**/
  UINT16                      TxVrefOverride;

/** Offset 0x01C8
**/
  UINT8                       Rsvd036[56];

/** Offset 0x0200 - Vdd2Mv
  VDD2 in MilliVolts. <b>0=Platform Default (no override), 1200=1.2V, 1350=1.35V etc.
  0:Default, 1200:1.20 Volts, 1350:1.35 Volts ...
**/
  UINT16                      Vdd2Mv;

/** Offset 0x0202 - Memory Reference Clock
  100MHz, 133MHz.
  0:133MHz, 1:100MHz
**/
  UINT8                       RefClk;

/** Offset 0x0203
**/
  UINT8                       Rsvd032[1];

/** Offset 0x0204 - Safe Loading Bios Enable State
  0: Disabled(Default), 1: Enabled. If enabled, Memory diagnostic will perform for
  TSEG Region.
  $EN_DIS
**/
  UINT8                       SafeLoadingBiosEnableState;

/** Offset 0x0205 - Ppr Recovery Status Enable
  0: Disabled(Default), 1: Enabled.  If enabled, PPR Recovery flow will get Trigger.
  $EN_DIS
**/
  UINT8                       PprRecoveryStatusEnable;

/** Offset 0x0206 - Tseg Memory Test Status
   If enabled, PPR Recovery flow will get Trigger
  0: PASS, 1: FAIL(Default)
**/
  UINT8                       TsegMemoryTestStatus;

/** Offset 0x0207 - Mrc Ppr Status
   Get Mrc PPR Status after PPR Recovery flow will get Trigger
  0: PASS, 1: FAIL(Default)
**/
  UINT8                       MrcPprStatus;

/** Offset 0x0208 - Tseg Retry Count
  Tseg Retry count will increase based on TSEG Region Fail count
  0: Default, 1:3
**/
  UINT8                       RetryCount;

/** Offset 0x0209
**/
  UINT8                       Rsvd035[3];

/** Offset 0x020C - Memory Vdd Voltage
  DRAM voltage (Vdd) (supply voltage for input buffers and core logic of the DRAM
  chips) in millivolts. <b>0=Platform Default (no override)</b>, 1200=1.2V, 1350=1.35V etc.
  0:Default, 1200:1.20 Volts, 1250:1.25 Volts, 1300:1.30 Volts, 1350:1.35 Volts, 1400:1.40
  Volts, 1450:1.45 Volts, 1500:1.50 Volts, 1550:1.55 Volts, 1600:1.60 Volts, 1650:1.65 Volts
**/
  UINT16                      VddVoltage;

/** Offset 0x020E - Memory VDDQ Voltage
  DRAM voltage (Vddq) (supply voltage for DQ/DQS of the DRAM chips) in millivolts
  from 0 - default to 1435mv.
**/
  UINT16                      VddqVoltage;

/** Offset 0x0210 - Memory VPP Voltage
  DRAM voltage (Vpp) (supply voltage for VPP of the DRAM chips) in millivolts from
  0 - default to 2135mv.
**/
  UINT16                      VppVoltage;

/** Offset 0x0212 - Memory Ratio
  Automatic or the frequency will equal ratio times reference clock. Set to Auto to
  recalculate memory timings listed below.
  0:Auto, 4:4, 5:5, 6:6, 7:7, 8:8, 9:9, 10:10, 11:11, 12:12, 13:13, 14:14, 15:15
**/
  UINT16                      Ratio;

/** Offset 0x0214 - tCL
  CAS Latency, 0: AUTO, max: 255. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tCL;

/** Offset 0x0215 - tCWL
  Min CAS Write Latency Delay Time, 0: AUTO, max: 255. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tCWL;

/** Offset 0x0216 - tFAW
  Min Four Activate Window Delay Time, 0: AUTO, max: 65535. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tFAW;

/** Offset 0x0218 - tRAS
  RAS Active Time, 0: AUTO, max: 65535. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRAS;

/** Offset 0x021A - tRCD/tRP
  RAS to CAS delay time and Row Precharge delay time, 0: AUTO, max: 255. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRCDtRP;

/** Offset 0x021B
**/
  UINT8                       Rsvd040[1];

/** Offset 0x021C - tREFI
  Obsolete, use tREFI32 instead. Refresh Interval, 0: AUTO, max: 65535. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT16                      tREFI;

/** Offset 0x021E - tRFC
  Min Refresh Recovery Delay Time, 0: AUTO, max: 65535. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRFC;

/** Offset 0x0220 - tRRD
  Min Row Active to Row Active Delay Time, 0: AUTO, max: 255. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tRRD;

/** Offset 0x0221 - tRTP
  Min Internal Read to Precharge Command Delay Time, 0: AUTO, max: 255. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRTP;

/** Offset 0x0222 - tWR
  Min Write Recovery Time, 0: AUTO, legal values: 5, 6, 7, 8, 10, 12, 14, 16, 18,
  20, 24, 30, 34, 40. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
  0:Auto, 5:5, 6:6, 7:7, 8:8, 10:10, 12:12, 14:14, 16:16, 18:18, 20:20, 24:24, 30:30,
  34:34, 40:40
**/
  UINT8                       tWR;

/** Offset 0x0223 - tWTR
  Min Internal Write to Read Command Delay Time, 0: AUTO, max: 255. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tWTR;

/** Offset 0x0224 - tRFCpb
  Min Internal per bank refresh recovery delay time, 0: AUTO, max: 0xFFFF. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT16                      tRFCpb;

/** Offset 0x0226 - tRFC2
  Min Internal refresh recovery delay time, 0: AUTO, max: 0xFFFF. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRFC2;

/** Offset 0x0228 - tRFC4
  Min Internal refresh recovery delay time, 0: AUTO, max: 0xFFFF. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRFC4;

/** Offset 0x022A - tRRD_L
  Min Internal row active to row active delay time for same bank groups, 0: AUTO,
  max: 80. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRRD_L;

/** Offset 0x022B - tRRD_S
  Min Internal row active to row active delay time for different bank groups, 0: AUTO,
  max: 80. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRRD_S;

/** Offset 0x022C - tWTR_L
  Min Internal write to read command delay time for same bank groups, 0: AUTO, max:
  127. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tWTR_L;

/** Offset 0x022D - tCCD_L
  Min Internal CAS-to-CAS delay for same bank group, 0: AUTO, max: 80. Only used if
  FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tCCD_L;

/** Offset 0x022E - tCCD_L_WR
  Min Internal Write-to-Write delay for same bank group, 0: AUTO, max: 150. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tCCD_L_WR;

/** Offset 0x022F - tWTR_S
  Min Internal write to read command delay time for different bank groups, 0: AUTO,
  max: 50. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tWTR_S;

/** Offset 0x0230 - NMode
  System command rate, range 0-2, 0 means auto, 1 = 1N, 2 = 2N
**/
  UINT8                       NModeSupport;

/** Offset 0x0231 - Enable Intel HD Audio (Azalia)
  0: Disable, 1: Enable (Default) Azalia controller
  $EN_DIS
**/
  UINT8                       PchHdaEnable;

/** Offset 0x0232 - Enable PCH ISH Controller
  0: Disable, 1: Enable (Default) ISH Controller
  $EN_DIS
**/
  UINT8                       PchIshEnable;

/** Offset 0x0233 - Dimm DFE Tap1 Step Size Setting
  Dimm DFE Tap1 setting: Memory-dependent, positive value will be converted to minus
  values by *-1 automatically
**/
  UINT8                       DFETap1StepSize;

/** Offset 0x0234 - Dimm DFE Tap2 Step Size Setting
  Dimm DFE Tap2 setting: Memory-dependent, positive value will be converted to minus
  values by *-1 automatically
**/
  UINT8                       DFETap2StepSize;

/** Offset 0x0235
**/
  UINT8                       Rsvd041[5];

/** Offset 0x023A - SAGV Gear Ratio
  Gear Selection for SAGV points. 0 - Auto, 2-Gear 2, 4-Gear 4
**/
  UINT8                       SaGvGear[4];

/** Offset 0x023E - SAGV Frequency
  SAGV Frequency per point in Mhz. 0 for Auto and a ratio of 133/100MHz: 1333/1300.
**/
  UINT16                      SaGvFreq[4];

/** Offset 0x0246 - SAGV Disabled Gear Ratio
  Gear Selection for SAGV Disabled. 0 - Auto, 2-Gear 2, 2-Gear 4
**/
  UINT8                       GearRatio;

/** Offset 0x0247 - LPDDR ODT RttWr
  Initial RttWr for LP4/5 in Ohms. 0x0 - Auto
**/
  UINT8                       LpddrRttWr;

/** Offset 0x0248 - LPDDR ODT RttCa
  Initial RttCa for LP4/5 in Ohms. 0x0 - Auto
**/
  UINT8                       LpddrRttCa;

/** Offset 0x0249 - Dimm Odt settings
  Dimm Odt settings of 2 DIMMs of a channel: Memory-dependent, 0: AUTO, max: 0xFFFF
  meaning disabling
**/
  UINT8                       DimmOdt[44];

/** Offset 0x0275 - Dimm DFE Tap1 settings Deprecated
  Dimm DFE Tap1 settings: Memory-dependent, positive values will be converted to minus
  values by *-1 automatically
**/
  UINT8                       DFETap1[8];

/** Offset 0x027D - Dimm DFE Tap2 settings Deprecated
  Dimm DFE Tap2 settings: Memory-dependent, positive values will be converted to minus
  values by *-1 automatically
**/
  UINT8                       DFETap2[8];

/** Offset 0x0285 - CsVrefLow
  DDR5 Cs Sweep Low Vref Value, 0: AUTO, max: 125.
**/
  UINT8                       CsVrefLow;

/** Offset 0x0286 - CsVrefHigh
  DDR5 Cs Sweep High Vref Value, 0: AUTO, max: 125.
**/
  UINT8                       CsVrefHigh;

/** Offset 0x0287 - CaVrefLow
  DDR5 Ca Sweep Low Vref Value, 0: AUTO, max: 125.
**/
  UINT8                       CaVrefLow;

/** Offset 0x0288 - CaVrefHigh
  DDR5 Ca Sweep High Vref Value, 0: AUTO, max: 125.
**/
  UINT8                       CaVrefHigh;

/** Offset 0x0289
**/
  UINT8                       Rsvd050[1];

/** Offset 0x028A - RxVrefOffset
  DDR5 RxVref Offset Value, 0: AUTO, max: 1600.
**/
  UINT16                      RxVrefOffset;

/** Offset 0x028C - MMIO size adjustment for AUTO mode
  Positive number means increasing MMIO size, Negative value means decreasing MMIO
  size: 0 (Default)=no change to AUTO mode MMIO size
**/
  UINT16                      MmioSizeAdjustment;

/** Offset 0x028E - Selection of the primary display device
  0=iGFX, 3(Default)=AUTO, 4=Hybrid Graphics
  0:iGFX, 3:AUTO, 4:Hybrid Graphics
**/
  UINT8                       PrimaryDisplay;

/** Offset 0x028F
**/
  UINT8                       Rsvd060[1];

/** Offset 0x0290 - Temporary MMIO address for GMADR
  Obsolete field now and it has been extended to 64 bit address, used LMemBar
**/
  UINT32                      GmAdr;

/** Offset 0x0294 - Temporary MMIO address for GTTMMADR
  The reference code will use this as Temporary MMIO address space to access GTTMMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GttMmAdr
  to (GttMmAdr + 2MB MMIO + 6MB Reserved + GttSize). Default is (GmAdr - (2MB MMIO
  + 6MB Reserved + GttSize)) to (GmAdr - 0x1) (Where GttSize = 8MB)
**/
  UINT32                      GttMmAdr;

/** Offset 0x0298 - Enable/Disable MRC TXT dependency
  When enabled MRC execution will wait for TXT initialization to be done first. Disabled(0x0)(Default):
  MRC will not wait for TXT initialization, Enabled(0x1): MRC will wait for TXT initialization
  $EN_DIS
**/
  UINT8                       TxtImplemented;

/** Offset 0x0299 - Enable/Disable SA OcSupport
  Enable: Enable SA OcSupport, Disable(Default): Disable SA OcSupport
  $EN_DIS
**/
  UINT8                       SaOcSupport;

/** Offset 0x029A - GT slice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtVoltageMode;

/** Offset 0x029B - Maximum GTs turbo ratio override
  0(Default)=Minimal/Auto, 60=Maximum
**/
  UINT8                       GtMaxOcRatio;

/** Offset 0x029C - The voltage offset applied to GT slice
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      GtVoltageOffset;

/** Offset 0x029E - The GT slice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtVoltageOverride;

/** Offset 0x02A0 - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtAdaptiveVoltage;

/** Offset 0x02A2 - voltage offset applied to the SA
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      SaVoltageOffset;

/** Offset 0x02A4 - PCIe root port Function number for Hybrid Graphics dGPU
  Root port Index number to indicate which PCIe root port has dGPU
**/
  UINT8                       RootPortIndex;

/** Offset 0x02A5 - Realtime Memory Timing
  0(Default): Disabled, 1: Enabled. When enabled, it will allow the system to perform
  realtime memory timing changes after MRC_DONE.
  0: Disabled, 1: Enabled
**/
  UINT8                       RealtimeMemoryTiming;

/** Offset 0x02A6
**/
  UINT8                       Rsvd065;

/** Offset 0x02A7 - Enable/Disable SA IPU
  Enable(Default): Enable SA IPU, Disable: Disable SA IPU
  $EN_DIS
**/
  UINT8                       SaIpuEnable;

/** Offset 0x02A8 - IMGU CLKOUT Configuration
  The configuration of IMGU CLKOUT, 0: Disable;<b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       ImguClkOutEn[6];

/** Offset 0x02AE - Program GPIOs for LFP on DDI port-A device
  0=Disabled,1(Default)=eDP, 2=MIPI DSI
  0:Disabled, 1:eDP, 2:MIPI DSI
**/
  UINT8                       DdiPortAConfig;

/** Offset 0x02AF - Program GPIOs for LFP on DDI port-B device
  0(Default)=Disabled,1=eDP, 2=MIPI DSI
  0:Disabled, 1:eDP, 2:MIPI DSI
**/
  UINT8                       DdiPortBConfig;

/** Offset 0x02B0 - Enable or disable HPD of DDI port A
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortAHpd;

/** Offset 0x02B1 - Enable or disable HPD of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBHpd;

/** Offset 0x02B2 - Enable or disable HPD of DDI port C
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCHpd;

/** Offset 0x02B3 - Enable or disable HPD of DDI port 1
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPort1Hpd;

/** Offset 0x02B4 - Enable or disable HPD of DDI port 2
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort2Hpd;

/** Offset 0x02B5 - Enable or disable HPD of DDI port 3
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort3Hpd;

/** Offset 0x02B6 - Enable or disable HPD of DDI port 4
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort4Hpd;

/** Offset 0x02B7 - Enable or disable DDC of DDI port A
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortADdc;

/** Offset 0x02B8 - Enable or disable DDC of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBDdc;

/** Offset 0x02B9 - Enable or disable DDC of DDI port C
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCDdc;

/** Offset 0x02BA - Enable DDC setting of DDI Port 1
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort1Ddc;

/** Offset 0x02BB - Enable DDC setting of DDI Port 2
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort2Ddc;

/** Offset 0x02BC - Enable DDC setting of DDI Port 3
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort3Ddc;

/** Offset 0x02BD - Enable DDC setting of DDI Port 4
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort4Ddc;

/** Offset 0x02BE - GPIO PIN MUX to choose between GPP_SA and GPP_SD Group.
  Default will be 0 for each Display PIN Mux which is GPP_SA Group. (0 = SA GROUP,
  1 = SD GROUP). BIT0 - EDP VDDEN, BIT1 - EDP BKLTEN,  BIT2 - EDP BKLTCTRL, BIT3
  - DDI-A, BIT4 - DDI-1/HPD1, BIT5 - DDI-2/HPD2, BIT6 - DDI-3/HPD3, BIT7 - DDI-4/HPD4
**/
  UINT8                       DisplayGpioPinMux;

/** Offset 0x02BF - FrameBuffer via DSM or LMem, when FrameBuffer is pointing to DSM region this option should be enabled
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       ConfigureDsmMtrr;

/** Offset 0x02C0
**/
  UINT8                       Rsvd070[8];

/** Offset 0x02C8 - Temporary MMIO address for GMADR
  The reference code will use this as Temporary MMIO address space to access GMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GmAdr to
  (GmAdr + 256MB). Default is (PciExpressBaseAddress - 256MB) to (PciExpressBaseAddress - 0x1)
**/
  UINT64                      LMemBar;

/** Offset 0x02D0 - Per-core HT Disable
  Defines the per-core HT disable mask where: 1 - Disable selected logical core HT,
  0 - is ignored. Input is in HEX and each bit maps to a logical core. Ex. A value
  of '1F' would disable HT for cores 4,3,2,1 and 0. Default is 0, all cores have
  HT enabled. Range is 0 - 0x7F for max 8 cores. You can only disable up to MAX_CORE_COUNT - 1.
**/
  UINT16                      PerCoreHtDisable;

/** Offset 0x02D2 - SA/Uncore voltage mode
  SA/Uncore voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       SaVoltageMode;

/** Offset 0x02D3
**/
  UINT8                       Rsvd080[1];

/** Offset 0x02D4 - SA/Uncore Voltage Override
  The SA/Uncore voltage override applicable when SA/Uncore voltage mode is in Override
  mode. Valid Range 0 to 2000
**/
  UINT16                      SaVoltageOverride;

/** Offset 0x02D6 - SA/Uncore Adaptive voltage
  Adaptive voltage applicable when SA/Uncore voltage mode is in Adaptive mode. Valid
  Range 0 to 2000
**/
  UINT16                      SaAdaptiveVoltage;

/** Offset 0x02D8 - Thermal Velocity Boost Ratio clipping
  0: Disabled, 1(Default): Enabled. This service controls Core frequency reduction
  caused by high package temperatures for processors that implement the Intel Thermal
  Velocity Boost (TVB) feature
  $EN_DIS
**/
  UINT8                       TvbRatioClipping;

/** Offset 0x02D9 - Thermal Velocity Boost voltage optimization
  0: Disabled, 1: Enabled(Default). This service controls thermal based voltage optimizations
  for processors that implement the Intel Thermal Velocity Boost (TVB) feature.
  $EN_DIS
**/
  UINT8                       TvbVoltageOptimization;

/** Offset 0x02DA - PCIE Resizable BAR Support
  Enable/Disable PCIE Resizable BAR Support.0: Disable; 1: Enable; 2: Auto(Default).
  $EN_DIS
**/
  UINT8                       PcieResizableBarSupport;

/** Offset 0x02DB - PCH DMI Gen3 Root port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 4 is default for each lane
**/
  UINT8                       PchDmiGen4RootPortPreset[8];

/** Offset 0x02E3 - SaPreMemProductionRsvd
  Reserved for SA Pre-Mem Production
  $EN_DIS
**/
  UINT8                       SaPreMemProductionRsvd[36];

/** Offset 0x0307 - DMI Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       DmiMaxLinkSpeed;

/** Offset 0x0308 - PCH DMI Equalization Phase 2
  DMI Equalization Phase 2. (0x0): Disable phase 2, (0x1): Enable phase 2, (0x2)(Default):
  AUTO - Use the current default method
  0:Disable phase2, 1:Enable phase2, 2:Auto
**/
  UINT8                       PchDmiGen3EqPh2Enable;

/** Offset 0x0309 - PCH DMI Gen3 Equalization Phase3
  DMI Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       PchDmiGen3EqPh3Method;

/** Offset 0x030A - Enable/Disable DMI GEN3 Static EQ Phase1 programming
  Program DMI Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiGen3ProgramStaticEq;

/** Offset 0x030B - PCH DMI Gen3 Root port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 4 is default for each lane
**/
  UINT8                       PchDmiGen3RootPortPreset[8];

/** Offset 0x0313 - PCH DMI Gen3 End port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       PchDmiGen3EndPointPreset[8];

/** Offset 0x031B - PCH DMI Gen3 End port Hint values per lane
  Used for programming DMI Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       PchDmiGen3EndPointHint[8];

/** Offset 0x0323 - DMI ASPM Configuration:{Combo
  Set ASPM Configuration
  0:Disabled, 1:L0s, 2:L1, 3:L1L0s
**/
  UINT8                       DmiAspm;

/** Offset 0x0324 - PCH DMI ASPM Configuration:{Combo
  Set ASPM Configuration
  0:Disabled, 1:L0s, 2:L1, 3:L1L0s
**/
  UINT8                       PchDmiAspm;

/** Offset 0x0325 - Enable/Disable DMI GEN3 Hardware Eq
  Enable/Disable DMI GEN3 Hardware Eq. Disabled(0x0): Disable Hardware Eq, Enabled(0x1)(Default):
  Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiHweq;

/** Offset 0x0326 - Enable/Disable DMI GEN3 Phase 23 Bypass
  DMIGEN3 Phase 23 Bypass. Disabled(0x0)(Default): Disable Phase 23 Bypass, Enabled(0x1):
  Enable  Phase 23 Bypass
  $EN_DIS
**/
  UINT8                       Gen3EqPhase23Bypass;

/** Offset 0x0327 - Enable/Disable DMI GEN3 Phase 3 Bypass
  DMIGEN3 Phase 3 Bypass. Disabled(0x0)(Default): Disable Phase 3 Bypass, Enabled(0x1):
  Enable  Phase 3 Bypass
  $EN_DIS
**/
  UINT8                       Gen3EqPhase3Bypass;

/** Offset 0x0328 - Enable/Disable DMI Gen3 EQ Local Transmitter Coefficient Override Enable
  Program Gen3 EQ Local Transmitter Coefficient Override. Disabled(0x0): Disable Local
  Transmitter Coefficient Override, Enabled(0x1)(Default): Enable  Local Transmitter
  Coefficient Override
  $EN_DIS
**/
  UINT8                       Gen3LtcoEnable;

/** Offset 0x0329 - Enable/Disable DMI Gen3 EQ Remote Transmitter Coefficient/Preset Override Enable
  Program Remote Transmitter Coefficient/Preset Override. Disabled(0x0)(Default):
  Disable Remote Transmitter Coefficient/Preset Override, Enabled(0x1): Enable  Remote
  Transmitter Coefficient/Preset Override
  $EN_DIS
**/
  UINT8                       Gen3RtcoRtpoEnable;

/** Offset 0x032A - DMI Gen3 Transmitter Pre-Cursor Coefficient
  Used for programming DMI Gen3 Transmitter Pre-Cursor Coefficient . Range: 0-10,
  2 is default for each lane
**/
  UINT8                       DmiGen3Ltcpre[8];

/** Offset 0x0332 - DMI Gen3 Transmitter Post-Cursor Coefficient
  Used for programming Transmitter Post-Cursor Coefficient. Range: 0-9, 2 is default
  for each lane
**/
  UINT8                       DmiGen3Ltcpo[8];

/** Offset 0x033A - Enable/Disable DMI Gen3 EQ Local Transmitter Coefficient Override Enable
  Program Gen3 EQ Local Transmitter Coefficient Override. Disabled(0x0): Disable Local
  Transmitter Coefficient Override, Enabled(0x1)(Default): Enable  Local Transmitter
  Coefficient Override
  $EN_DIS
**/
  UINT8                       PchDmiGen3LtcoEnable;

/** Offset 0x033B - Enable/Disable DMI Gen3 EQ Remote Transmitter Coefficient/Preset Override Enable
  Program Remote Transmitter Coefficient/Preset Override. Disabled(0x0)(Default):
  Disable Remote Transmitter Coefficient/Preset Override, Enabled(0x1): Enable  Remote
  Transmitter Coefficient/Preset Override
  $EN_DIS
**/
  UINT8                       PchDmiGen3RtcoRtpoEnable;

/** Offset 0x033C - PCH DMI Gen3 Transmitter Pre-Cursor Coefficient
  Used for programming DMI Gen3 Transmitter Pre-Cursor Coefficient . Range: 0-10,
  2 is default for each lane
**/
  UINT8                       PchDmiGen3Ltcpre[8];

/** Offset 0x0344 - PCH DMI Gen3 Transmitter Post-Cursor Coefficient
  Used for programming Transmitter Post-Cursor Coefficient. Range: 0-9, 2 is default
  for each lane
**/
  UINT8                       PchDmiGen3Ltcpo[8];

/** Offset 0x034C - PCIE Hw Eq Gen3 CoeffList Cm
  DMI_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       DmiHwEqGen3CoeffListCm[8];

/** Offset 0x0354 - PCIE Hw Eq Gen3 CoeffList Cp
  DMI_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       DmiHwEqGen3CoeffListCp[8];

/** Offset 0x035C - Enable/Disable DMI GEN3 DmiGen3DsPresetEnable
  Enable/Disable DMI GEN3 DmiGen3DsPreset. Auto(0x0)(Default): DmiGen3DsPresetEnable,
  Manual(0x1): Enable DmiGen3DsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen3DsPresetEnable;

/** Offset 0x035D - DMI Gen3 Root port preset Rx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 1 is default
  for each lane
**/
  UINT8                       DmiGen3DsPortRxPreset[8];

/** Offset 0x0365 - DMI Gen3 Root port preset Tx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen3DsPortTxPreset[8];

/** Offset 0x036D - Enable/Disable DMI GEN3 DmiGen3UsPresetEnable
  Enable/Disable DMI GEN3 DmiGen3UsPreset. Auto(0x0)(Default): DmiGen3UsPresetEnable,
  Manual(0x1): Enable DmiGen3UsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen3UsPresetEnable;

/** Offset 0x036E - DMI Gen3 Root port preset Rx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen3UsPortRxPreset[8];

/** Offset 0x0376 - DMI Gen3 Root port preset Tx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 1 is default
  for each lane
**/
  UINT8                       DmiGen3UsPortTxPreset[8];

/** Offset 0x037E - DMI Hw Eq Gen4 CoeffList Cm
  DMI_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       DmiHwEqGen4CoeffListCm[8];

/** Offset 0x0386 - DMI Hw Eq Gen4 CoeffList Cp
  DMI_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       DmiHwEqGen4CoeffListCp[8];

/** Offset 0x038E - Enable/Disable DMI GEN4 Phase 23 Bypass
  DMI GEN4 Phase 23 Bypass. Disabled(0x0)(Default): Disable Phase 23 Bypass, Enabled(0x1):
  Enable  Phase 23 Bypass
  $EN_DIS
**/
  UINT8                       Gen4EqPhase23Bypass;

/** Offset 0x038F - Enable/Disable DMI GEN4 Phase 3 Bypass
  DMI GEN3 Phase 4 Bypass. Disabled(0x0)(Default): Disable Phase 3 Bypass, Enabled(0x1):
  Enable  Phase 3 Bypass
  $EN_DIS
**/
  UINT8                       Gen4EqPhase3Bypass;

/** Offset 0x0390 - Enable/Disable DMI GEN4 DmiGen4DsPresetEnable
  Enable/Disable DMI GEN4 DmiGen4DsPreset. Auto(0x0)(Default): DmiGen4DsPresetEnable,
  Manual(0x1): Enable DmiGen4DsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen4DsPresetEnable;

/** Offset 0x0391 - DMI Gen4 Root port preset Tx values per lane
  Used for programming DMI Gen4 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen4DsPortTxPreset[8];

/** Offset 0x0399 - Enable/Disable DMI Gen4 EQ Remote Transmitter Coefficient/Preset Override Enable
  Program Remote Transmitter Coefficient/Preset Override. Disabled(0x0)(Default):
  Disable Remote Transmitter Coefficient/Preset Override, Enabled(0x1): Enable  Remote
  Transmitter Coefficient/Preset Override
  $EN_DIS
**/
  UINT8                       Gen4RtcoRtpoEnable;

/** Offset 0x039A - Enable/Disable DMI Gen4 EQ Local Transmitter Coefficient Override Enable
  Program Gen3 EQ Local Transmitter Coefficient Override. Disabled(0x0)(Default):
  Disable Local Transmitter Coefficient Override, Enabled(0x1): Enable  Local Transmitter
  Coefficient Override
  $EN_DIS
**/
  UINT8                       Gen4LtcoEnable;

/** Offset 0x039B - DMI Gen4 Transmitter Pre-Cursor Coefficient
  Used for programming DMI Gen4 Transmitter Pre-Cursor Coefficient . Range: 0-10,
  0 is default for each lane
**/
  UINT8                       DmiGen4Ltcpre[8];

/** Offset 0x03A3 - DMI Gen4 Transmitter Post-Cursor Coefficient
  Used for programming DMI Gen4 Transmitter Post-Cursor Coefficient. Range: 0-9, 8
  is default for each lane
**/
  UINT8                       DmiGen4Ltcpo[8];

/** Offset 0x03AB - Enable/Disable DMI GEN4 DmiGen4UsPresetEnable
  Enable/Disable DMI GEN4 DmiGen4UsPreset. Auto(0x0)(Default): DmiGen4UsPresetEnable,
  Manual(0x1): Enable DmiGen4UsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen4UsPresetEnable;

/** Offset 0x03AC - DMI Gen4 Root port preset Tx values per lane
  Used for programming DMI Gen4 preset values per lane. Range: 0-10, 1 is default
  for each lane
**/
  UINT8                       DmiGen4UsPortTxPreset[8];

/** Offset 0x03B4 - DMI ASPM L1 exit Latency
  Range: 0-7, 4 is default L1 exit Latency
**/
  UINT8                       DmiAspmL1ExitLatency;

/** Offset 0x03B5 - Enable/Disable PCH DMI Gen4 EQ Remote Transmitter Coefficient/Preset Override Enable
  Program Remote Transmitter Coefficient/Preset Override. Disabled(0x0)(Default):
  Disable Remote Transmitter Coefficient/Preset Override, Enabled(0x1): Enable  Remote
  Transmitter Coefficient/Preset Override
  $EN_DIS
**/
  UINT8                       PchDmiGen4RtcoRtpoEnable;

/** Offset 0x03B6 - Enable/Disable PCH DMI Gen4 EQ Local Transmitter Coefficient Override Enable
  Program Gen3 EQ Local Transmitter Coefficient Override. Disabled(0x0)(Default):
  Disable Local Transmitter Coefficient Override, Enabled(0x1): Enable  Local Transmitter
  Coefficient Override
  $EN_DIS
**/
  UINT8                       PchDmiGen4LtcoEnable;

/** Offset 0x03B7 - PCH DMI Gen4 Transmitter Post-Cursor Coefficient
  Used for programming DMI Gen4 Transmitter Post-Cursor Coefficient. Range: 0-9, 8
  is default for each lane
**/
  UINT8                       PchDmiGen4Ltcpo[8];

/** Offset 0x03BF - PCH DMI ASPM L1 exit Latency
  Range: 0-7, 4 is default L1 exit Latency
**/
  UINT8                       PchDmiAspmL1ExitLatency;

/** Offset 0x03C0 - PCH DMI Gen4 Transmitter Pre-Cursor Coefficient
  Used for programming DMI Gen4 Transmitter Pre-Cursor Coefficient . Range: 0-10,
  0 is default for each lane
**/
  UINT8                       PchDmiGen4Ltcpre[8];

/** Offset 0x03C8 - L1SS State Control Policy
  Choose the L1SS State Control Policy, <b>Default = 0 </b>
  0: Auto, 1: L1.2
**/
  UINT8                       DmiL1ssEnable;

/** Offset 0x03C9
**/
  UINT8                       Rsvd085[7];

/** Offset 0x03D0 - Temporary address for NvmeHcPeiMmioBase
  The reference code will use this as Temporary address space
**/
  UINT32                      NvmeHcPeiMmioBase;

/** Offset 0x03D4 - Temporary address for NvmeHcPeiMmioLimit
  The reference code will use this as Temporary address space
**/
  UINT32                      NvmeHcPeiMmioLimit;

/** Offset 0x03D8 - Temporary address for AhciPeiMmioBase
  The reference code will use this as Temporary address space
**/
  UINT32                      AhciPeiMmioBase;

/** Offset 0x03DC - Temporary address for AhciPeiMmioLimit
  The reference code will use this as Temporary address space
**/
  UINT32                      AhciPeiMmioLimit;

/** Offset 0x03E0 - Temporary address for EcExtraIoBase
  The reference code will use this as Temporary address space
**/
  UINT16                      EcExtraIoBase;

/** Offset 0x03E2 - Temporary address for SioBaseAddress
  The reference code will use this as Temporary address space
**/
  UINT16                      SioBaseAddress;

/** Offset 0x03E4 - Temporary address for ApicLocalAddress
  The reference code will use this as Temporary address space
**/
  UINT32                      ApicLocalAddress;

/** Offset 0x03E8 - Temporary CfgBar address for VMD
  The reference code will use this as Temporary address space
**/
  UINT32                      VmdCfgBarBar;

/** Offset 0x03EC - Temporary MemBar1 address for VMD
  The reference code will use this as Temporary address space
**/
  UINT32                      VmdMemBar1Bar;

/** Offset 0x03F0 - Temporary MemBar2 address for VMD
  The reference code will use this as Temporary address space
**/
  UINT32                      VmdMemBar2Bar;

/** Offset 0x03F4 - BIST on Reset
  Enable/Disable BIST (Built-In Self Test) on reset. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       BistOnReset;

/** Offset 0x03F5 - Skip Stop PBET Timer Enable/Disable
  Skip Stop PBET Timer; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       SkipStopPbet;

/** Offset 0x03F6 - Over clocking support
  Over clocking support; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       OcSupport;

/** Offset 0x03F7 - Over clocking Lock
  Lock Overclocking. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       OcLock;

/** Offset 0x03F8 - Maximum Core Turbo Ratio Override
  Maximum core turbo ratio override allows to increase CPU core frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b> Range: 0-85 if CoreRatioExtensionMode
  is disabled. 0-120 if CoreRatioExtensionMode is enabled.
**/
  UINT8                       CoreMaxOcRatio;

/** Offset 0x03F9 - Core voltage mode
  Core voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       CoreVoltageMode;

/** Offset 0x03FA - Maximum clr turbo ratio override
  Maximum clr turbo ratio override allows to increase CPU clr frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-85
**/
  UINT8                       RingMaxOcRatio;

/** Offset 0x03FB - Hyper Threading Enable/Disable
  Enable or Disable Hyper-Threading Technology. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       HyperThreading;

/** Offset 0x03FC - Enable or Disable CPU Ratio Override
  Enable/Disable CPU Flex Ratio Programming; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CpuRatioOverride;

/** Offset 0x03FD - CPU ratio value
  This value must be between Max Efficiency Ratio (LFM) and Maximum non-turbo ratio
  set by Hardware (HFM). Valid Range 0 to 63.
**/
  UINT8                       CpuRatio;

/** Offset 0x03FE - Boot max frequency
  Enable Boot Maximum Frequency in CPU strap. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       BootMaxFrequency;

/** Offset 0x03FF - Number of active big cores
  Number of P-cores to enable in each processor package. Note: Number of P-Cores and
  E-Cores are looked at together. When both are {0,0
  0:Disable all big cores, 1:1, 2:2, 3:3, 0xFF:Active all big cores
**/
  UINT8                       ActiveCoreCount;

/** Offset 0x0400 - Processor Early Power On Configuration FCLK setting
  FCLK frequency can take values of 400MHz, 800MHz and 1GHz. <b>0: 800 MHz (ULT/ULX)</b>.
  <b>1: 1 GHz (DT/Halo)</b>. Not supported on ULT/ULX.- 2: 400 MHz. - 3: Reserved
  0:800 MHz, 1: 1 GHz, 2: 400 MHz, 3: Reserved
**/
  UINT8                       FClkFrequency;

/** Offset 0x0401 - Enable or Disable VMX
  Enable or Disable VMX, When enabled, a VMM can utilize the additional hardware capabilities
  provided by Vanderpool Technology. 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       VmxEnable;

/** Offset 0x0402 - AVX2 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx2RatioOffset;

/** Offset 0x0403 - AVX3 Ratio Offset
  DEPRECATED. 0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease
  AVX ratio vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx3RatioOffset;

/** Offset 0x0404 - BCLK Adaptive Voltage Enable
  When enabled, the CPU V/F curves are aware of BCLK frequency when calculated. </b>0:
  Disable;<b> 1: Enable
  $EN_DIS
**/
  UINT8                       BclkAdaptiveVoltage;

/** Offset 0x0405
**/
  UINT8                       Rsvd090[1];

/** Offset 0x0406 - core voltage override
  The core voltage override which is applied to the entire range of cpu core frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageOverride;

/** Offset 0x0408 - Core Turbo Adaptive Voltage
  Adaptive voltage applied to the cpu core when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      CoreAdaptiveVoltage;

/** Offset 0x040A - Core Turbo voltage Offset
  The voltage offset applied to the core while operating in turbo mode.Valid Range 0 to 1000
**/
  UINT16                      CoreVoltageOffset;

/** Offset 0x040C - Core PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       CorePllVoltageOffset;

/** Offset 0x040D - Ring Downbin
  Ring Downbin enable/disable. When enabled, CPU will ensure the ring ratio is always
  lower than the core ratio.0: Disable; <b>1: Enable.</b>
  $EN_DIS
**/
  UINT8                       RingDownBin;

/** Offset 0x040E - Ring voltage mode
  Ring voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       RingVoltageMode;

/** Offset 0x040F - TjMax Offset
  TjMax offset.Specified value here is clipped by pCode (125 - TjMax Offset) to support
  TjMax in the range of 62 to 115 deg Celsius. Valid Range 10 - 63
**/
  UINT8                       TjMaxOffset;

/** Offset 0x0410 - Ring voltage override
  The ring voltage override which is applied to the entire range of cpu ring frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageOverride;

/** Offset 0x0412 - Ring Turbo Adaptive Voltage
  Adaptive voltage applied to the cpu ring when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      RingAdaptiveVoltage;

/** Offset 0x0414 - Ring Turbo voltage Offset
  The voltage offset applied to the ring while operating in turbo mode. Valid Range 0 to 1000
**/
  UINT16                      RingVoltageOffset;

/** Offset 0x0416 - Enable or Disable TME
  Configure Total Memory Encryption (TME) to protect DRAM data from physical attacks.
  <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TmeEnable;

/** Offset 0x0417 - Enable CPU CrashLog
  Enable or Disable CPU CrashLog; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       CpuCrashLogEnable;

/** Offset 0x0418 - CPU Run Control
  Enable, Disable or Do not configure CPU Run Control; 0: Disable; 1: Enable ; <b>2:
  No Change</b>
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x0419 - CPU Run Control Lock
  Lock or Unlock CPU Run Control; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DebugInterfaceLockEnable;

/** Offset 0x041A - DFD Enable
  Enable or Disable DFD. <b>0: Disable</b>, 1:Enable
  $EN_DIS
**/
  UINT8                       DfdEnable;

/** Offset 0x041B
**/
  UINT8                       Rsvd100[1];

/** Offset 0x041C - Per-Atom-Cluster VF Offset
  Array used to specifies the selected Atom Core Cluster Offset Voltage. This voltage
  is specified in millivolts.
**/
  UINT16                      PerAtomClusterVoltageOffset[8];

/** Offset 0x042C - Per-Atom-Cluster VF Offset Prefix
  Sets the PerAtomCLusterVoltageOffset value as positive or negative for the selected
  Core; <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       PerAtomClusterVoltageOffsetPrefix[8];

/** Offset 0x0434 - Per-Atom-Cluster Voltage Mode
  Array used to specifies the selected Atom Core ClusterVoltage Mode.
**/
  UINT8                       PerAtomClusterVoltageMode[8];

/** Offset 0x043C - Per-Atom-Cluster Voltage Override
  Array used to specifies the selected Atom Core Cluster Voltage Override.
**/
  UINT16                      PerAtomClusterVoltageOverride[8];

/** Offset 0x044C - Per-Atom-Cluster Adaptive Voltage
  Array used to specifies the selected Atom Core Cluster Adaptive Voltage.
**/
  UINT16                      PerAtomClusterAdaptiveVoltage[8];

/** Offset 0x045C - Number of active small cores
  Number of E-cores to enable in each processor package. Note: Number of P-Cores and
  E-Cores are looked at together. When both are {0,0
  0:Disable all small cores, 1:1, 2:2, 3:3, 0xFF:Active all small cores
**/
  UINT8                       ActiveSmallCoreCount;

/** Offset 0x045D - Core VF Point Offset Mode
  Selects Core Voltage & Frequency Offset mode between Legacy and Selection modes.
  In Legacy Mode, setting a global offset for the entire VF curve. In Selection Mode,
  setting a selected VF point; <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       CoreVfPointOffsetMode;

/** Offset 0x045E - Core VF Point Offset
  Array used to specifies the Core Voltage Offset applied to the each selected VF
  Point. This voltage is specified in millivolts.
**/
  UINT16                      CoreVfPointOffset[15];

/** Offset 0x047C - Core VF Point Offset Prefix
  Sets the CoreVfPointOffset value as positive or negative for corresponding core
  VF Point; <b>0: Positive </b>; 1: Negative.
  0:Positive, 1:Negative
**/
  UINT8                       CoreVfPointOffsetPrefix[15];

/** Offset 0x048B - Core VF Point Ratio
  Array for the each selected Core VF Point to display the ration.
**/
  UINT8                       CoreVfPointRatio[15];

/** Offset 0x049A - Core VF Point Count
  Number of supported Core Voltage & Frequency Point Offset
**/
  UINT8                       CoreVfPointCount;

/** Offset 0x049B - Core VF Configuration Scope
  Alows both all-core VF curve or per-core VF curve configuration; <b>0: All-core</b>;
  1: Per-core.
  0:All-core, 1:Per-core
**/
  UINT8                       CoreVfConfigScope;

/** Offset 0x049C - Per-core VF Offset
  Array used to specifies the selected Core Offset Voltage. This voltage is specified
  in millivolts.
**/
  UINT16                      PerCoreVoltageOffset[8];

/** Offset 0x04AC - Per-core VF Offset Prefix
  Sets the PerCoreVoltageOffset value as positive or negative for the selected Core;
  <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       PerCoreVoltageOffsetPrefix[8];

/** Offset 0x04B4 - Per Core Max Ratio override
  Enable or disable Per Core PState OC supported by writing OCMB 0x1D to program new
  favored core ratio to each Core. <b>0: Disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       PerCoreRatioOverride;

/** Offset 0x04B5 - Per-core Voltage Mode
  Array used to specifies the selected Core Voltage Mode.
**/
  UINT8                       PerCoreVoltageMode[8];

/** Offset 0x04BD
**/
  UINT8                       Rsvd110[1];

/** Offset 0x04BE - Per-core Voltage Override
  Array used to specifies the selected Core Voltage Override.
**/
  UINT16                      PerCoreVoltageOverride[8];

/** Offset 0x04CE - Per-core Adaptive Voltage
  Array used to specifies the selected Core Adaptive Voltage.
**/
  UINT16                      PerCoreAdaptiveVoltage[8];

/** Offset 0x04DE - Per Core Current Max Ratio
  Array for the Per Core Max Ratio
**/
  UINT8                       PerCoreRatio[8];

/** Offset 0x04E6 - OC TVB
  Enable/Disable for OC TVB parameter programming using OCMB 0x24/0x25. <b>0:Disable
  </b>; 1:Enable.
  $EN_DIS
**/
  UINT8                       OcTvb;

/** Offset 0x04E7 - Pcore TVB Temperature Threshold 0
  Pcore TVB Temp (in degrees C) - Temperature Threshold 0. Running ABOVE this temperature
  will clip delta Down Bins for Threshold 0 from the resolved OC Ratio, when TVB
  ratio clipping is enabled. Default is 70.
**/
  UINT8                       PcoreTvbTempThreshold0;

/** Offset 0x04E8 - Pcore TVB Temperature Threshold 1
  Pcore TVB Temp (in degrees C) - Temperature Threshold 1. Running ABOVE this temperature
  will clip delta Down Bins for Threshold 1 from the resolved OC Ratio, when TVB
  ratio clipping is enabled. Default is 100.
**/
  UINT8                       PcoreTvbTempThreshold1;

/** Offset 0x04E9 - Ecore TVB Temperature Threshold 0
  Ecore TVB Temp (in degrees C) - Temperature Threshold 0. Running ABOVE this temperature
  will clip delta Down Bins for Threshold 0 from the resolved OC Ratio, when TVB
  ratio clipping is enabled. Default is 70.
**/
  UINT8                       EcoreTvbTempThreshold0;

/** Offset 0x04EA - Ecore TVB Temperature Threshold 1
  Ecore TVB Temp (in degrees C) - Temperature Threshold 1. Running ABOVE this temperature
  will clip delta Down Bins for Threshold 1 from the resolved OC Ratio, when TVB
  ratio clipping is enabled. Default is 100.
**/
  UINT8                       EcoreTvbTempThreshold1;

/** Offset 0x04EB - OC TVB Configuration Limit Selection
  Select one of the two OC TVB Configuration limits, between Per CCP Module or Per
  P-core Group. <b>0: Per CCP Module</b>; 1: Per P-core Group.
  0:Per CCP Module, 1:Per P-core Group
**/
  UINT8                       TvbConfigLimitSelect;

/** Offset 0x04EC - Per Pcore Ratio Down Bin Above T0
  Array for the Per Pcore Down Bins (delta) for Temperature Threshold 0. When running
  above Temperature Threshold 0, the ratio will be clipped by MAX_RATIO[n]-This value,
  when TVB ratio clipping is enabled. Default is 1.
**/
  UINT8                       PerPcoreRatioDownBinAboveT0[8];

/** Offset 0x04F4 - Per Pcore Ratio Down Bin Above T1
  Array for the Per Pcore Down Bins (delta) for Temperature Threshold 1. When running
  above Temperature Threshold 1, the ratio will be clipped by MAX_RATIO[n]-This value,
  when TVB ratio clipping is enabled. Default is 2.
**/
  UINT8                       PerPcoreRatioDownBinAboveT1[8];

/** Offset 0x04FC - Per Pcore Group Ratio Down Bin Above T0
  Array for the Per Pcore Group Down Bins (delta) for Temperature Threshold 0. When
  running above Temperature Threshold 0, the ratio will be clipped by MAX_RATIO[n]-This
  value, when TVB ratio clipping is enabled. Default is 1.
**/
  UINT8                       PerPcoreGrRatioDownBinAboveT0[8];

/** Offset 0x0504 - Per Pcore Group Ratio Down Bin Above T1
  Array for the Per Pcore Group Down Bins (delta) for Temperature Threshold 1. When
  running above Temperature Threshold 1, the ratio will be clipped by MAX_RATIO[n]-This
  value, when TVB ratio clipping is enabled. Default is 2.
**/
  UINT8                       PerPcoreGrRatioDownBinAboveT1[8];

/** Offset 0x050C - Per Ecore CCP Ratio Down Bin Above T0
  Array for the Per Ecore CCP Down Bins (delta) for Temperature Threshold 0. When
  running above Temperature Threshold 0, the ratio will be clipped by MAX_RATIO[n]-This
  value, when TVB ratio clipping is enabled. Default is 0.
**/
  UINT8                       PerEcoreCcpRatioDownBinAboveT0[8];

/** Offset 0x0514 - Per Ecore CCP Ratio Down Bin Above T1
  Array for the Per Ecore Group Down Bins (delta) for Temperature Threshold 1. When
  running above Temperature Threshold 1, the ratio will be clipped by MAX_RATIO[n]-This
  value, when TVB ratio clipping is enabled. Default is 0.
**/
  UINT8                       PerEcoreCcpRatioDownBinAboveT1[8];

/** Offset 0x051C - Margin Limit Check
  Margin Limit Check. Choose level of margin check
  0:Disable, 1:L1, 2:L2, 3:Both
**/
  UINT8                       MarginLimitCheck;

/** Offset 0x051D
**/
  UINT8                       Rsvd120[3];

/** Offset 0x0520 - Margin Limit L2
  % of L1 check for margin limit check
**/
  UINT16                      MarginLimitL2;

/** Offset 0x0522 - Atom Cluster Max Ratio
  Array for Atom Cluster Max Ratio, 4 ATOM cores are in the same Cluster and their
  max core ratio will be aligned.
**/
  UINT8                       AtomClusterRatio[8];

/** Offset 0x052A - Core Ratio Extension Mode
  Enable or disable Core Ratio above 85 Extension Mode by writing BIOS MB 0x37 to
  enable FULL_RANGE_MULTIPLIER_UNLOCK_EN. <b>0: Disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       CoreRatioExtensionMode;

/** Offset 0x052B - Pvd Ratio Threshold for SOC/CPU die
  Array of Pvd Ratio Threshold for SOC/CPU die is the threshold value for input ratio
  (P0 to Pn) to select the multiplier so that the output is within the DCO frequency
  range. As per the die selected, this threshold is applied to SA and MC/CMI PLL
  for SOC die and SA, Ring and Atom PLL for CPU die. Range 0-63. When the threshold
  is 0, static PVD ratio is selected based on the PVD Mode for SOC. <b>0: Default</b>.
**/
  UINT8                       PvdRatioThreshold[2];

/** Offset 0x052D - Pvd Mode SOC/CPU die
  Array of PVD Mode. Value from 0 to 3 for SOC/CPU. 0x0 = div-1 (VCO = Output clock),
  0x1 = div-2 (VCO = 2x Output clock), 0x2 = div-4 (VCO = 4x Output clock), 0x3 =
  div-8 (VCO = 8x Output clock).
**/
  UINT8                       PvdMode[2];

/** Offset 0x052F - FLL Overclock Mode
  Select FLL Mode Value from 0 to 3. 0x0 = no overclocking, 0x1 = ratio overclocking
  with nominal (0.5-1x) reference clock frequency, 0x2 = BCLK overclocking with elevated
  (1-3x) reference clock frequency, 0x3 = BCLK overclocking with extreme elevated
  (3-5x) reference clock frequency and ratio limited to 63.
**/
  UINT8                       FllOverclockMode;

/** Offset 0x0530 - Number of Soc-North Atom cores
  Number of SOC-North E-cores to enable in SOC North. 0: Disable all Soc-North Atom
  cores; 1: 1; 2: 2; <b>0xFF: Active all Soc-North Atom cores</b>
  0:Disable all Soc-North Atom cores, 1:1, 2:2, 0xFF:Active all cores
**/
  UINT8                       ActiveSocNorthAtomCoreCount;

/** Offset 0x0531 - Ring VF Point Offset Mode
  Selects Ring Voltage & Frequency Offset mode between Legacy and Selection modes.
  In Legacy Mode, setting a global offset for the entire VF curve. In Selection Mode,
  setting a selected VF point; <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       RingVfPointOffsetMode;

/** Offset 0x0532 - Ring VF Point Offset
  Array used to specifies the Ring Voltage Offset applied to the each selected VF
  Point. This voltage is specified in millivolts.
**/
  UINT16                      RingVfPointOffset[15];

/** Offset 0x0550 - Ring VF Point Offset Prefix
  Sets the RingVfPointOffset value as positive or negative for corresponding core
  VF Point; <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       RingVfPointOffsetPrefix[15];

/** Offset 0x055F - Ring VF Point Ratio
  Array for the each selected Ring VF Point to display the ration.
**/
  UINT8                       RingVfPointRatio[15];

/** Offset 0x056E - Ring VF Point Count
  Number of supported Ring Voltage & Frequency Point Offset
**/
  UINT8                       RingVfPointCount;

/** Offset 0x056F - Compute Die SSC enable
  Enable/Dsiable Compute-Die SSC Configuration. 0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       ComputeDieSscEnable;

/** Offset 0x0570 - Soc Die SSC enable
  Enable/Dsiable Soc-Die SSC Configuration. 0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       SocDieSscEnable;

/** Offset 0x0571 - GPIO Override
  Gpio Override Level - FSP will not configure any GPIOs and rely on GPIO setings
  before moved to FSP. Available configurations 0: Disable; 1: Level 1 - Skips GPIO
  configuration in PEI/FSPM/FSPT phase;2: Level 2 - Reserved for use
**/
  UINT8                       GpioOverride;

/** Offset 0x0572
**/
  UINT8                       Rsvd130[10];

/** Offset 0x057C - CPU BCLK OC Frequency
  CPU BCLK OC Frequency in KHz units. 98000000Hz = 98MHz <b>0 - Auto</b>. Range is
  40Mhz-1000Mhz.
**/
  UINT32                      CpuBclkOcFrequency;

/** Offset 0x0580 - SOC BCLK OC Frequency
  SOC BCLK OC Frequency in KHz units. 98000000Hz = 98MHz <b>0 - Auto</b>. Range is
  40Mhz-1000Mhz.
**/
  UINT32                      SocBclkOcFrequency;

/** Offset 0x0584 - Enable CPU CrashLog GPRs dump
  Enable or Disable CPU CrashLog GPRs dump; <b>0: Disable</b>; 1: Enable; 2: Only
  disable Smm GPRs dump
  0:Disabled, 1:Enabled, 2:Only Smm GPRs Disabled
**/
  UINT8                       CrashLogGprs;

/** Offset 0x0585
**/
  UINT8                       Rsvd140[11];

/** Offset 0x0590 - Bitmask of disable cores
  Core mask is a bitwise indication of which core should be disabled. <b>0x00=Default</b>;
  Bit 0 - core 0, bit 7 - core 7.
**/
  UINT64                      DisablePerCoreMask;

/** Offset 0x0598 - Support IA Unlimited ICCMAX
  Support IA Unlimited ICCMAX up to maximum value 512A; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       IaIccUnlimitedMode;

/** Offset 0x0599
**/
  UINT8                       Rsvd150[1];

/** Offset 0x059A - IA ICCMAX
  IA ICCMAX value is represented in 1/4 A increments. A value of 400 = 100A. <b>0
  (HW default)</b>. Range is 4-2047.
**/
  UINT16                      IaIccMax;

/** Offset 0x059C - Support GT Unlimited ICCMAX
  Support GT Unlimited ICCMAX up to maximum value 512A; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       GtIccUnlimitedMode;

/** Offset 0x059D
**/
  UINT8                       Rsvd160[1];

/** Offset 0x059E - GT ICCMAX
  GT ICCMAX value is represented in 1/4 A increments. A value of 400 = 100A. <b>0
  (HW default)</b>. Range is 4-2047.
**/
  UINT16                      GtIccMax;

/** Offset 0x05A0 - Support SA Unlimited ICCMAX
  Support SA Unlimited ICCMAX up to maximum value 512A; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       SaIccUnlimitedMode;

/** Offset 0x05A1
**/
  UINT8                       Rsvd161[1];

/** Offset 0x05A2 - SA ICCMAX
  SA ICCMAX value is represented in 1/4 A increments. A value of 400 = 100A. <b>0
  (HW default)</b>. Range is 4-2047.
**/
  UINT16                      SaIccMax;

/** Offset 0x05A4 - Memory Subsystem VF Point Offset
  Array used to specifies the Memory Subsystem Voltage Offset applied to the each
  selected VF Point. This voltage is specified in millivolts.
**/
  UINT16                      MemSSVfPointOffset[15];

/** Offset 0x05C2 - Memory Subsystem VF Point Offset Prefix
  Sets the MemSSVfPointOffset value as positive or negative for corresponding core
  VF Point; <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       MemSSVfPointOffsetPrefix[15];

/** Offset 0x05D1 - Memory Subsystem VF Point Ratio
  Array for the each selected Memory Subsystem VF Point to display the ration.
**/
  UINT8                       MemSSVfPointRatio[15];

/** Offset 0x05E0 - Memory Subsystem VF Point Count
  Number of supported Memory Subsystem Voltage & Frequency Point Offset
**/
  UINT8                       MemSSVfPointCount;

/** Offset 0x05E1 - VCCSA Boot Voltage
  <b> Default: 0: Nominal </b> 1: High Voltage(up to 1.2/1.3V) to support the voltage
  needed for VCCSA boot voltage.
  0: Nominal , 1: High Voltage(up to 1.2/1.3V)
**/
  UINT8                       VccsaBootVoltageSel;

/** Offset 0x05E2 - CPU D2D ratio setting
  0(Default)=No setting, 15=Minimal, 40=Maximum
**/
  UINT8                       CpuD2dRatio;

/** Offset 0x05E3 - CPU Bandgap Reference Mode
  <b> Default: 0: Normal </b> 1: Bandgap Bypassed) to support CPU Bandgap Reference Mode.
  0: Normal , 1: Bandgap Bypassed
**/
  UINT8                       CpuBandgapRefMode;

/** Offset 0x05E4 - VCCIA Boot Voltage
  <b> Default: 0: Nominal </b> 1: High Voltage to support the voltage higher than
  1.65v (max 2.01v))
  0: Nominal , 1: High Voltage
**/
  UINT8                       VcciaBootVoltageSel;

/** Offset 0x05E5 - Granular Ratio Override
  Enable or disable OC Granular Ratio Override. <b>0: Disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       GranularRatioOverride;

/** Offset 0x05E6 - Granularity Bins Override for Core
  Array used to specifies the selected Core Granularity Bins.
**/
  UINT8                       PerCoreGranularityBins[8];

/** Offset 0x05EE - Granularity Bins Override for AtomCluster
  Array used to specifies the selected AtomCluster Granularity Bins.
**/
  UINT8                       PerAtomClusterGranularityBins[8];

/** Offset 0x05F6 - Sa PLL Frequency
  Configure Sa PLL Frequency. <b>0: 2400MHz </b>, 1: 1600MHz
  0: 2400MHz, 1: 1600MHz
**/
  UINT8                       SaPllFreqOverride;

/** Offset 0x05F7 - TSC HW Fixup disable
  TSC HW Fixup disable during TSC copy from PMA to APIC. <b>0: Enable</b>; 1: Disable
  0:Enable, 1:Disable
**/
  UINT8                       TscDisableHwFixup;

/** Offset 0x05F8 - Process Vmax Limit
  Setting this bit will allow user to set any voltage. Note: Disabling the voltage
  limit checks may cause permanent damage to processor. <b>1: Enable</b>; 0: Disable
  1:Enable, 0:Disable
**/
  UINT8                       ProcessVmaxLimit;

/** Offset 0x05F9 - P-Core Power Density Throttle
  This control allow user to disable P-core Power Density Throttling for overclocking.
  <b>1: Enable</b>; 0: Disable
  1:Enable, 0:Disable
**/
  UINT8                       PcorePowerDensityThrottle;

/** Offset 0x05FA - Request Core Min Ratio
  0(Default)=No Request
**/
  UINT8                       CoreMinRatio;

/** Offset 0x05FB - ReservedCpuPreMem
  Reserved for Cpu Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedCpuPreMem[24];

/** Offset 0x0613 - Acoustic Noise Mitigation feature
  Enabling this option will help mitigate acoustic noise on certain SKUs when the
  CPU is in deeper C state. <b>0: Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       AcousticNoiseMitigation;

/** Offset 0x0614 - Platform Psys slope correction
  PSYS Slope defined in 1/100 increments. <b>0 - Auto</b> Specified in 1/100 increment
  values. Range is 0-200. 125 = 1.25
**/
  UINT8                       PsysSlope;

/** Offset 0x0615
**/
  UINT8                       Rsvd170[1];

/** Offset 0x0616 - Platform Power Pmax
  PSYS PMax power, defined in 1/8 Watt increments. <b>0 - Auto</b> Specified in 1/8
  Watt increments. Range 0-1024 Watts(0-8191). Value of 800 = 100W
**/
  UINT16                      PsysPmax;

/** Offset 0x0618 - Thermal Design Current current limit
  TDC Current Limit, defined in 1/8A increments. Range 0-32767. For a TDC Current
  Limit of 125A, enter 1000. 0 = 0 Amps. <b>0: Auto</b>. [0] for IA, [1] for GT,
  [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      TdcCurrentLimit[6];

/** Offset 0x0624 - AcLoadline
  AC Loadline defined in 1/100 mOhms. A value of 100 = 1.00 mOhm, and 1255 = 12.55
  mOhm. Range is 0-6249 (0-62.49 mOhms). 0 = AUTO/HW default. [0] for IA, [1] for
  GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      AcLoadline[6];

/** Offset 0x0630 - DcLoadline
  DC Loadline defined in 1/100 mOhms. A value of 100 = 1.00 mOhm, and 1255 = 12.55
  mOhm. Range is 0-6249 (0-62.49 mOhms). 0 = AUTO/HW default. [0] for IA, [1] for
  GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      DcLoadline[6];

/** Offset 0x063C - Power State 1 Threshold current
  PS Current Threshold1, defined in 1/4 A increments. A value of 400 = 100A. Range
  0-512, which translates to 0-128A. 0 = AUTO. [0] for IA, [1] for GT, [2] for SA,
  [3] through [5] are Reserved.
**/
  UINT16                      Psi1Threshold[6];

/** Offset 0x0648 - Power State 2 Threshold current
  PS Current Threshold2, defined in 1/4 A increments. A value of 400 = 100A. Range
  0-512, which translates to 0-128A. 0 = AUTO. [0] for IA, [1] for GT, [2] for SA,
  [3] through [5] are Reserved.
**/
  UINT16                      Psi2Threshold[6];

/** Offset 0x0654 - Power State 3 Threshold current
  PS Current Threshold3, defined in 1/4 A increments. A value of 400 = 100A. Range
  0-512, which translates to 0-128A. 0 = AUTO. [0] for IA, [1] for GT, [2] for SA,
  [3] through [5] are Reserved.
**/
  UINT16                      Psi3Threshold[6];

/** Offset 0x0660 - Power State 3 enable/disable
  PS3 Enable/Disable. 0 - Disabled, 1 - Enabled. [0] for IA, [1] for GT, [2] for SA,
  [3] through [5] are Reserved.
**/
  UINT8                       Psi3Enable[6];

/** Offset 0x0666 - Power State 4 enable/disable
  PS4 Enable/Disable. 0 - Disabled, 1 - Enabled. [0] for IA, [1] for GT, [2] for SA,
  [3] through [5] are Reserved.
**/
  UINT8                       Psi4Enable[6];

/** Offset 0x066C - Imon slope correction
  IMON Slope defined in 1/100 increments. Range is 0-200. For a 1.25 slope, enter
  125. <b>0: Auto</b>. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      ImonSlope[6];

/** Offset 0x0678 - Imon offset correction
  IMON Offset is an 32-bit signed value (2's complement). Units 1/1000, Range is [-128000,
  127999]. For an offset of 25.348, enter 25348. <b>0: Auto</b>. [0] for IA, [1]
  for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT32                      ImonOffset[6];

/** Offset 0x0690 - Enable/Disable BIOS configuration of VR
  VR Config Enable. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
  <b>0: Disable</b>; 1: Enable.
**/
  UINT8                       VrConfigEnable[6];

/** Offset 0x0696 - Thermal Design Current enable/disable
  Thermal Design Current enable/disable; <b>0: Disable</b>; 1: Enable. [0] for IA,
  [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT8                       TdcEnable[6];

/** Offset 0x069C - Thermal Design Current time window
  TDC Time Window, value in seconds. Range from 1s to 448s, 0 = Auto/HW default. <b>0:
  Auto</b>. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT32                      TdcTimeWindow[6];

/** Offset 0x06B4 - Thermal Design Current Lock
  Thermal Design Current Lock; <b>0: Disable</b>; 1: Enable. For all VR Indexes
**/
  UINT8                       TdcLock[6];

/** Offset 0x06BA - DLVR RFI Frequency
  DLVR RFI Frequency in MHz. <b>0x055A: 1370 MHz</b>.
**/
  UINT16                      DlvrRfiFrequency;

/** Offset 0x06BC - DLVR RFI Spread Spectrum Percentage
  DLVR SSC in percentage with multiple of 0.25%. 0 = 0%, 31 = 7.75%. <b>0x06: 1.5%</b>;
  u3.2 value from 0% - 7.75%.
**/
  UINT8                       DlvrSpreadSpectrumPercentage;

/** Offset 0x06BD - DLVR RFI Enable
  Enable/Disable DLVR RFI frequency hopping. 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DlvrRfiEnable;

/** Offset 0x06BE - Pre Wake Randomization time
  Set the maximum Pre Wake randomization time in micro ticks. This is for acoustic
  noise mitigation Dynamic Perodicity Alteration (DPA) tuning. Range 0-255 <b>0</b>.
**/
  UINT8                       PreWake;

/** Offset 0x06BF - Ramp Up Randomization time
  Set the maximum Ramp Up randomization time in micro ticks. This is for acoustic
  noise mitigation Dynamic Perodicity Alteration (DPA) tuning. Range 0-255 <b>0</b>.
**/
  UINT8                       RampUp;

/** Offset 0x06C0 - Ramp Down Randomization time
  Set the maximum Ramp Down randomization time in micro ticks. This is for acoustic
  noise mitigation Dynamic Perodicity Alteration (DPA) tuning. Range 0-255 <b>0</b>.
**/
  UINT8                       RampDown;

/** Offset 0x06C1 - Available power delivery segments
  This field is required to be non-zero on Desktop platforms. Used to communicate
  the power delivery design capability of the board. This value is an enum of the
  available power delivery segments that are defined in the Platform Design Guide.
  <b>0: Disable.</b>.
**/
  UINT8                       VrPowerDeliveryDesign;

/** Offset 0x06C2 - VR Voltage Limit
  Voltage Limit (VMAX). This value represents the Maximum instantaneous voltage allowed
  at any given time. Range is 0 - 7999mV. [0] for IA, [1] for GT, [2] for SA, [3]
  through [5] are Reserved.
**/
  UINT16                      VrVoltageLimit[6];

/** Offset 0x06CE - Enable/Disable PS1 to PS0 Dynamic Cutoff
  PS1 to PS0 Dynamic Cutoff Enable/Disable. <b>0: Disable</b>; 1: Enable. [0] for
  IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT8                       PS1toPS0DynamicCutoffEnable[6];

/** Offset 0x06D4 - PS1 to PS0 Dynamic Cutoff M Coef
  PS1 to PS0 Dynamic Cutoff M Coef, This number is in M*100 units. For 12.50, enter
  1250. Range: 0-4096. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      PS1toPS0MCoef[6];

/** Offset 0x06E0 - PS1 to PS0 Dynamic Cutoff C Coef
  PS1 to PS0 Dynamic Cutoff C Coef, This number is in C*100 units. For 12.50, enter
  1250. If your value bigger than 2047, it will minus 4096. For -12.50, enter 2846,
  range:0-4096. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      PS1toPS0CCoef[6];

/** Offset 0x06EC - Enable/Disable PS2 to PS1 Dynamic Cutoff
  PS2 to PS1 Dynamic Cutoff Enable/Disable. <b>0: Disable</b>; 1: Enable. [0] for
  IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT8                       PS2toPS1DynamicCutoffEnable[6];

/** Offset 0x06F2 - PS2 to PS1 Dynamic Cutoff M Coef
  PS2 to PS1 Dynamic Cutoff M Coef, This number is in M*100 units. For 12.50, enter
  1250, range:0-4096. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      PS2toPS1MCoef[6];

/** Offset 0x06FE - PS2 to PS1 Dynamic Cutoff C Coef
  PS2 to PS1 Dynamic Cutoff C Coef, This number is in C*100 units. For 12.50, enter
  1250. If your value bigger than 2047, it will minus 4096. For -12.50, enter 2846,
  range:0-4096. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      PS2toPS1CCoef[6];

/** Offset 0x070A - VCCIN Demotion
  DEPRECATED. En/Dis VCCIN Demotion. 0: Disable, <b>1: Enable with default threshold</b>,
  2: Enable with user configured threshold. [0] for IA, [1] for GT, [2] for SA, [3]
  through [5] are Reserved.
**/
  UINT8                       VccInDemotionEnable[6];

/** Offset 0x0710 - VCCIN Demotion Quiescent Power in mW
  DEPRECATED. User configured platform quiescent threshold in milli-watt when VCC
  Demotion is enabled. Range is 0-255mW. [0] for IA, [1] for GT, [2] for SA, [3]
  through [5] are Reserved.
**/
  UINT8                       VccInDemotionQuiescentPowerInMw[6];

/** Offset 0x0716
**/
  UINT8                       Rsvd190[2];

/** Offset 0x0718 - VCCIN Demotion Capacitance in uF
  DEPRECATED. User configured VR's quiescent power threshold in micro-farad when VCC
  Demotion is enabled. Range: 0-2000uF. [0] for IA, [1] for GT, [2] for SA, [3] through
  [5] are Reserved.
**/
  UINT32                      VccInDemotionCapacitanceInUf[6];

/** Offset 0x0730 - Platform Psys offset correction
  PSYS Offset defined in 1/1000 increments. <b>0 - Auto</b> This is an 32-bit signed
  value (2's complement). Units 1/1000, Range is [-128000, 127999]. For an offset
  of 25.348, enter 25348.
**/
  UINT32                      PsysOffset;

/** Offset 0x0734 - Disable Fast Slew Rate for Deep Package C States for VR domains
  This option needs to be configured to reduce acoustic noise during deeper C states.
  False: Don't disable Fast ramp during deeper C states; True: Disable Fast ramp
  during deeper C state. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are
  Reserved. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisable[6];

/** Offset 0x073A - Slew Rate configuration for Deep Package C States for VR domains
  Set VR IA/GT/SA Slow Slew Rate for Deep Package C State ramp time; Slow slew rate
  equals to Fast divided by number, the number is 2, 4, 8, 16 to slow down the slew
  rate to help minimize acoustic noise; divide by 16 is disabled for GT/SA. <b>0:
  Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16; 0xFF: Ignore the configuration
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16, 0xFF: Ignore the configuration
**/
  UINT8                       SlowSlewRate[6];

/** Offset 0x0740 - Icc Max limit
  Voltage Regulator Current Limit (Icc Max). This value represents the Maximum instantaneous
  current allowed at any given time. The value is represented in 1/4 A increments.
  A value of 400 = 100A. 0 means AUTO. IA and GT, range 0-2047. SA range 0-1023.
  [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      IccMax[6];

/** Offset 0x074C - VR Fast Vmode Offset
  Voltage Regulator Fast Vmode Offset. This value represents the ICC Max Offset(dV/dT)
  to be configured if Fast Vmode is enabled. The value is represented in 1 mV increments.
  0 = Use processor default setting. Highly recommend to keep at the default setting.
  IA, GT and SA, range 0-255. [0] for IA, [1] for GT, [2] for SA, [3] through [5]
  are Reserved.
**/
  UINT8                       FastVmodeOffset[6];

/** Offset 0x0752 - SVID Stabiliation Delay
  Configure SVID Stabiliation Delay being used for the FVM feature when it is enabled.
  Note that this delay applies to all SVID domains equally (no unique values possible
  for IA/GT/SA).The value is represented in 1 us increments. IA, GT and SA, range 0-255.
**/
  UINT8                       SvidStabilizationDelay;

/** Offset 0x0753 - VCC Demotion Shutdown Threshold in msec
  User configured time threshold in msec. Range is 0-255 msec. [0] for IA, [1] for
  GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT8                       VccDemotionShutdownThreshold[6];

/** Offset 0x0759
**/
  UINT8                       Rsvd200[1];

/** Offset 0x075A - VR Fast Vmode ICC Limit support
  Voltage Regulator Fast Vmode ICC Limit. A value of 400 = 100A. A value of 0 corresponds
  to feature disabled (no reactive protection). This value represents the current
  threshold where the VR would initiate reactive protection if Fast Vmode is enabled.
  The value is represented in 1/4 A increments. Range 0-2040. [0] for IA, [1] for
  GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT16                      IccLimit[6];

/** Offset 0x0766 - Enable/Disable VR FastVmode. The VR will initiate reactive protection if Fast Vmode is enabled.
  Enable/Disable VR FastVmode; 0: Disable; <b>1: Enable</b>. For all VR by domain
  0: Disable, 1: Enable
**/
  UINT8                       EnableFastVmode[6];

/** Offset 0x076C - Enable CEP
  Enable/Disable CEP (Current Excursion Protection) Support. 0: Disable; <b>1: Enable</b>.
  [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
  $EN_DIS
**/
  UINT8                       CepEnable[6];

/** Offset 0x0772 - Enable SIRP
  Enable/Disable SIRP (SoC Iccmax Reactive Protection) Support. <b>0: Disable</b>;
  1: Enable. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
  $EN_DIS
**/
  UINT8                       SirpEnable[6];

/** Offset 0x0778 - Enable IRMS
  Enable/Disable IRMS for VR domains - Current root mean square. <b>0: Disable</b>;
  1: Enable. [0] for IA, [1] for GT, [2] for SA, [3] through [5] are Reserved.
**/
  UINT8                       Irms[6];

/** Offset 0x077E - UnderVolt Protection
  When UnderVolt Protection is enabled, user will be not be able to program under
  voltage in OS runtime. 0: Disabled; <b>1: Enabled</b>
  $EN_DIS
**/
  UINT8                       UnderVoltProtection;

/** Offset 0x077F - Vsys Critical
  PCODE MMIO Mailbox: Vsys Critical. <b>0: Disable</b>; 1: Enable Range is 0-255.
**/
  UINT8                       EnableVsysCritical;

/** Offset 0x0780 - Vsys Full Scale
  Vsys Full Scale, Range is 0-255000mV
**/
  UINT32                      VsysFullScale;

/** Offset 0x0784 - Vsys Critical Threshold
  Vsys Critical Threshold, Range is 0-255000mV
**/
  UINT32                      VsysCriticalThreshold;

/** Offset 0x0788 - Psys Full Scale
  Vsys Full Scale, Range is 0-255000mV
**/
  UINT32                      PsysFullScale;

/** Offset 0x078C - Psys Critical Threshold
  Vsys Critical Threshold, Range is 0-255000mV
**/
  UINT32                      PsysCriticalThreshold;

/** Offset 0x0790 - Assertion Deglitch Mantissa
  Assertion Deglitch Mantissa, Range is 0-255
**/
  UINT8                       VsysAssertionDeglitchMantissa;

/** Offset 0x0791 - Assertion Deglitch Exponent
  Assertion Deglitch Exponent, Range is 0-255
**/
  UINT8                       VsysAssertionDeglitchExponent;

/** Offset 0x0792 - De assertion Deglitch Mantissa
  De assertion Deglitch Mantissa, Range is 0-255
**/
  UINT8                       VsysDeassertionDeglitchMantissa;

/** Offset 0x0793 - De assertion Deglitch Exponent
  De assertion Deglitch Exponent, Range is 0-255
**/
  UINT8                       VsysDeassertionDeglitchExponent;

/** Offset 0x0794 - Per Core Max OC Ratio
  Array for the Per Core Max OC Ratio
**/
  UINT8                       PerCoreMaxRatio[8];

/** Offset 0x079C - Per Atom Cluster Max OC Ratio
  Array for the Per Atom Cluster Max OC Ratio
**/
  UINT8                       PerAtomClusterMaxRatio[8];

/** Offset 0x07A4 - OC Max Voltage limits
  OC Max Voltage limits
**/
  UINT16                      MaxVoltageLimit[8];

/** Offset 0x07B4 - Core PLL Current Reference Tuning Offset
  Core PLL Current Reference Tuning Offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       CorePllCurrentRefTuningOffset;

/** Offset 0x07B5 - Ring PLL Current Reference Tuning Offset
  Ring PLL Current Reference Tuning Offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       RingPllCurrentRefTuningOffset;

/** Offset 0x07B6 - IaAtom PLL Current Reference Tuning Offset
  IaAtom PLL Current Reference Tuning Offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       IaAtomPllCurrentRefTuningOffset;

/** Offset 0x07B7 - Per Core Disable Configuration
  This configuration can be used only when OC is enabled,user can either use legacy
  num of cores option or the OC specific per core disable configuration. <b>0: Disable</b>, 1: Enable
**/
  UINT8                       PerCoreDisableConfiguration;

/** Offset 0x07B8
**/
  UINT8                       CpuFspmUpdRsvd[76];

/** Offset 0x0804 - BiosGuard
  Enable/Disable. 0: Disable, Enable/Disable BIOS Guard feature, 1: enable
  $EN_DIS
**/
  UINT8                       BiosGuard;

/** Offset 0x0805
**/
  UINT8                       BiosGuardToolsInterface;

/** Offset 0x0806 - Txt
  Enables utilization of additional hardware capabilities provided by Intel (R) Trusted
  Execution Technology. Changes require a full power cycle to take effect. <b>0:
  Disable</b>, 1: Enable
  $EN_DIS
**/
  UINT8                       Txt;

/** Offset 0x0807
**/
  UINT8                       Rsvd210[1];

/** Offset 0x0808 - PrmrrSize
  Enable/Disable. 0: Disable, define default value of PrmrrSize , 1: enable
**/
  UINT32                      PrmrrSize;

/** Offset 0x080C - SinitMemorySize
  Enable/Disable. 0: Disable, define default value of SinitMemorySize , 1: enable
**/
  UINT32                      SinitMemorySize;

/** Offset 0x0810
**/
  UINT8                       Rsvd220[8];

/** Offset 0x0818 - TxtDprMemoryBase
  Enable/Disable. 0: Disable, define default value of TxtDprMemoryBase , 1: enable
**/
  UINT64                      TxtDprMemoryBase;

/** Offset 0x0820 - TxtHeapMemorySize
  Enable/Disable. 0: Disable, define default value of TxtHeapMemorySize , 1: enable
**/
  UINT32                      TxtHeapMemorySize;

/** Offset 0x0824 - TxtDprMemorySize
  Reserve DPR memory size (0-255) MB. 0: Disable, define default value of TxtDprMemorySize
  , 1: enable
**/
  UINT32                      TxtDprMemorySize;

/** Offset 0x0828 - BiosAcmBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      BiosAcmBase;

/** Offset 0x082C - BiosAcmSize
  Enable/Disable. 0: Disable, define default value of BiosAcmSize , 1: enable
**/
  UINT32                      BiosAcmSize;

/** Offset 0x0830 - ApStartupBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      ApStartupBase;

/** Offset 0x0834 - TgaSize
  Enable/Disable. 0: Disable, define default value of TgaSize , 1: enable
**/
  UINT32                      TgaSize;

/** Offset 0x0838 - TxtLcpPdBase
  Enable/Disable. 0: Disable, define default value of TxtLcpPdBase , 1: enable
**/
  UINT64                      TxtLcpPdBase;

/** Offset 0x0840 - TxtLcpPdSize
  Enable/Disable. 0: Disable, define default value of TxtLcpPdSize , 1: enable
**/
  UINT64                      TxtLcpPdSize;

/** Offset 0x0848 - IsTPMPresence
  IsTPMPresence default values
**/
  UINT8                       IsTPMPresence;

/** Offset 0x0849 - ReservedSecurityPreMem
  Reserved for Security Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedSecurityPreMem[32];

/** Offset 0x0869 - Enable PCH HSIO PCIE Rx Set Ctle
  Enable PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtleEnable[28];

/** Offset 0x0885 - PCH HSIO PCIE Rx Set Ctle Value
  PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtle[28];

/** Offset 0x08A1 - Enble PCH HSIO PCIE TX Gen 1 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmpEnable[28];

/** Offset 0x08BD - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmp[28];

/** Offset 0x08D9 - Enable PCH HSIO PCIE TX Gen 2 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmpEnable[28];

/** Offset 0x08F5 - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmp[28];

/** Offset 0x0911 - Enable PCH HSIO PCIE TX Gen 3 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmpEnable[28];

/** Offset 0x092D - PCH HSIO PCIE Gen 3 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 3 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmp[28];

/** Offset 0x0949 - Enable PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DeEmphEnable[28];

/** Offset 0x0965 - PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment value
  PCH PCIe Gen 1 TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen1DeEmph[28];

/** Offset 0x0981 - Enable PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5Enable[28];

/** Offset 0x099D - PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5[28];

/** Offset 0x09B9 - Enable PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0Enable[28];

/** Offset 0x09D5 - PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0[28];

/** Offset 0x09F1 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMagEnable[8];

/** Offset 0x09F9 - PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMag[8];

/** Offset 0x0A01 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMagEnable[8];

/** Offset 0x0A09 - PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMag[8];

/** Offset 0x0A11 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMagEnable[8];

/** Offset 0x0A19 - PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMag[8];

/** Offset 0x0A21 - Enable PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmpEnable[8];

/** Offset 0x0A29 - PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmp[8];

/** Offset 0x0A31 - Enable PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmpEnable[8];

/** Offset 0x0A39 - PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmp[8];

/** Offset 0x0A41 - Enable PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmpEnable[8];

/** Offset 0x0A49 - PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmp[8];

/** Offset 0x0A51 - Enable PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DeEmphEnable[8];

/** Offset 0x0A59 - PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen1DeEmph[8];

/** Offset 0x0A61 - Enable PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DeEmphEnable[8];

/** Offset 0x0A69 - PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen2DeEmph[8];

/** Offset 0x0A71 - Enable PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DeEmphEnable[8];

/** Offset 0x0A79 - PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen3DeEmph[8];

/** Offset 0x0A81 - PCH LPC Enhance the port 8xh decoding
  Original LPC only decodes one byte of port 80h.
  $EN_DIS
**/
  UINT8                       PchLpcEnhancePort8xhDecoding;

/** Offset 0x0A82 - PCH Port80 Route
  Control where the Port 80h cycles are sent, 0: LPC; 1: PCI.
  $EN_DIS
**/
  UINT8                       PchPort80Route;

/** Offset 0x0A83 - Enable SMBus ARP support
  Enable SMBus ARP support.
  $EN_DIS
**/
  UINT8                       SmbusArpEnable;

/** Offset 0x0A84 - Number of RsvdSmbusAddressTable.
  The number of elements in the RsvdSmbusAddressTable.
**/
  UINT8                       PchNumRsvdSmbusAddresses;

/** Offset 0x0A85
**/
  UINT8                       Rsvd230[1];

/** Offset 0x0A86 - SMBUS Base Address
  SMBUS Base Address (IO space).
**/
  UINT16                      PchSmbusIoBase;

/** Offset 0x0A88 - Enable SMBus Alert Pin
  Enable SMBus Alert Pin.
  $EN_DIS
**/
  UINT8                       PchSmbAlertEnable;

/** Offset 0x0A89 - Usage type for SOC/IOE ClkSrc
  0-23: PCIe rootport, 0x70:LAN, 0x80: unspecified but in use (free running), 0xFF: not used
**/
  UINT8                       PcieClkSrcUsage[16];

/** Offset 0x0A99 - Usage type for PCH ClkSrc
  0-23: PCIe rootport, 0x70:LAN, 0x80: unspecified but in use (free running), 0xFF: not used
**/
  UINT8                       PchPcieClkSrcUsage[16];

/** Offset 0x0AA9 - SOC/IOE ClkReq-to-ClkSrc mapping
  Number of ClkReq signal assigned to ClkSrc
**/
  UINT8                       PcieClkSrcClkReq[16];

/** Offset 0x0AB9 - PCH ClkReq-to-ClkSrc mapping
  Number of ClkReq signal assigned to ClkSrc
**/
  UINT8                       PchPcieClkSrcClkReq[16];

/** Offset 0x0AC9
**/
  UINT8                       Rsvd240[1];

/** Offset 0x0ACA - PCH additional MMIO reserved
  Additional MMIO reserved for PCH usage (i.e dTBT) in MB
**/
  UINT16                      PchAdditionalMmioRsvd;

/** Offset 0x0ACC - Clk Req GPIO Pin
  Select Clk Req Pin. Refer to GPIO_*_MUXING_SRC_CLKREQ_x* for possible values.
**/
  UINT32                      PcieClkReqGpioMux[8];

/** Offset 0x0AEC - Point of RsvdSmbusAddressTable
  Array of addresses reserved for non-ARP-capable SMBus devices.
**/
  UINT32                      RsvdSmbusAddressTablePtr;

/** Offset 0x0AF0 - Enable PCH PCIE RP Mask
  Enable/disable PCH PCIE Root Ports. 0: disable, 1: enable. One bit for each port,
  bit0 for port1, bit1 for port2, and so on.
**/
  UINT32                      PchPcieRpEnableMask;

/** Offset 0x0AF4 - Enable SOC/IOE PCIE RP Mask
  Enable/disable SOC/IOE PCIE Root Ports. 0: disable, 1: enable. One bit for each
  port, bit0 for port1, bit1 for port2, and so on.
**/
  UINT16                      PcieRpEnableMask;

/** Offset 0x0AF6 - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
  0: VC0, 1: VC1
**/
  UINT8                       PchHdaVcType;

/** Offset 0x0AF7 - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x0AF8 - Enable HD Audio Link
  Enable/disable HD Audio Link. Muxed with SSP0/SSP1/SNDW1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkHdaEnable;

/** Offset 0x0AF9 - Enable HDA SDI lanes
  Enable/disable HDA SDI lanes.
**/
  UINT8                       PchHdaSdiEnable[2];

/** Offset 0x0AFB - HDA Power/Clock Gating (PGD/CGD)
  Enable/Disable HD Audio Power and Clock Gating(POR: Enable). 0: PLATFORM_POR, 1:
  FORCE_ENABLE, 2: FORCE_DISABLE.
  0: POR, 1: Force Enable, 2: Force Disable
**/
  UINT8                       PchHdaTestPowerClockGating;

/** Offset 0x0AFC - Enable HD Audio DMIC_N Link
  Enable/disable HD Audio DMIC1 link. Muxed with SNDW3.
**/
  UINT8                       PchHdaAudioLinkDmicEnable[2];

/** Offset 0x0AFE - Discrete BT Offload Enabled
  Enable/disable Discrete BT Offload.
**/
  UINT8                       HdaDiscBtOffEnabled;

/** Offset 0x0AFF - PCH additional IO reserved
  Additional IO reserved for PCH usage in KB
**/
  UINT8                       PchAdditionalIoRsvd;

/** Offset 0x0B00 - DMIC<N> ClkA Pin Muxing (N - DMIC number)
  Determines DMIC<N> ClkA Pin muxing. See  GPIO_*_MUXING_DMIC<N>_CLKA_*
**/
  UINT32                      PchHdaAudioLinkDmicClkAPinMux[2];

/** Offset 0x0B08 - DMIC<N> ClkB Pin Muxing
  Determines DMIC<N> ClkA Pin muxing. See GPIO_*_MUXING_DMIC<N>_CLKB_*
**/
  UINT32                      PchHdaAudioLinkDmicClkBPinMux[2];

/** Offset 0x0B10 - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x0B11 - Discrete BT Offload Ssp Link
  Select SSP link instance for Discrete BT Offload. Note that this SSP instance must
  also be enabled.
**/
  UINT8                       HdaDiscBtOffSspLink;

/** Offset 0x0B12 - SoC additional MMIO reserved
  Additional MMIO reserved for SoC usage (i.e TBT) in MB
**/
  UINT16                      SocAdditionalMmioRsvd;

/** Offset 0x0B14 - DMIC<N> Data Pin Muxing
  Determines DMIC<N> Data Pin muxing. See GPIO_*_MUXING_DMIC<N>_DATA_*
**/
  UINT32                      PchHdaAudioLinkDmicDataPinMux[2];

/** Offset 0x0B1C - Enable HD Audio SSP0 Link
  Enable/disable HD Audio SSP_N/I2S link. Muxed with HDA. N-number 0-5
**/
  UINT8                       PchHdaAudioLinkSspEnable[6];

/** Offset 0x0B22 - Enable HD Audio SoundWire#N Link
  Enable/disable HD Audio SNDW#N link. Muxed with HDA.
**/
  UINT8                       PchHdaAudioLinkSndwEnable[4];

/** Offset 0x0B26 - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
  4: 96MHz, 3: 48MHz
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x0B27 - Sndw0 Multiline enablement
  SoundWire Link 0 Multiline enablement. Default is DISABLE. 0: DISABLE, 1: Two lines
  enabled, 2: Three lines enabled, 3: Four Lines enabled.
  $EN_DIS
**/
  UINT8                       PchHdAudioSndwMultilaneEnable;

/** Offset 0x0B28 - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 2: 4T, 3: 8T, 4: 16T
  0: 2T, 2: 4T, 3: 8T, 4: 16T
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x0B29 - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x0B2A
**/
  UINT8                       Rsvd260[1];

/** Offset 0x0B2B - SoC additional IO reserved
  Additional IO reserved for SoC usage in KB
**/
  UINT8                       SocAdditionalIoRsvd;

/** Offset 0x0B2C - Audio Sub System IDs
  Set default Audio Sub System IDs. If its set to 0 then value from Strap is used.
**/
  UINT32                      PchHdaSubSystemIds;

/** Offset 0x0B30 - CNVi DDR RFI Mitigation
  Enable/Disable DDR RFI Mitigation. Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviDdrRfim;

/** Offset 0x0B31 - Extended BIOS Support
  Enable/Disable Extended BIOS Region Support. Default is DISABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       ExtendedBiosDecodeRange;

/** Offset 0x0B32 - Extented BIOS Direct Read Decode enable
  Enable/Disable access to bigger than 16MB BIOS Region through Direct Memory Reads.
  0: disabled (default), 1: enabled
  $EN_DIS
**/
  UINT8                       PchSpiExtendedBiosDecodeRangeEnable;

/** Offset 0x0B33
**/
  UINT8                       Rsvd270[1];

/** Offset 0x0B34 - Extended BIOS Direct Read Decode Range base
  Bits of 31:16 of a memory address that'll be a base for Extended BIOS Direct Read Decode.
**/
  UINT32                      PchSpiExtendedBiosDecodeRangeBase;

/** Offset 0x0B38 - Extended BIOS Direct Read Decode Range limit
  Bits of 31:16 of a memory address that'll be a limit for Extended BIOS Direct Read Decode.
**/
  UINT32                      PchSpiExtendedBiosDecodeRangeLimit;

/** Offset 0x0B3C - Debug Interfaces
  Debug Interfaces. BIT0-RAM, BIT1-UART, BIT3-USB3, BIT4-Serial IO, BIT5-TraceHub,
  BIT2 - Not used.
**/
  UINT8                       PcdDebugInterfaceFlags;

/** Offset 0x0B3D - Serial Io Uart Debug Controller Number
  Select SerialIo Uart Controller for debug.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       SerialIoUartDebugControllerNumber;

/** Offset 0x0B3E - Serial Io Uart Debug Auto Flow
  Enables UART hardware flow control, CTS and RTS lines.
  $EN_DIS
**/
  UINT8                       SerialIoUartDebugAutoFlow;

/** Offset 0x0B3F
**/
  UINT8                       Rsvd280[1];

/** Offset 0x0B40 - Serial Io Uart Debug BaudRate
  Set default BaudRate Supported from 0 - default to 6000000. Recommended values 9600,
  19200, 57600, 115200, 460800, 921600, 1500000, 1843200, 3000000, 3686400, 6000000
**/
  UINT32                      SerialIoUartDebugBaudRate;

/** Offset 0x0B44 - Serial Io Uart Debug Parity
  Set default Parity.
  0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartDebugParity;

/** Offset 0x0B45 - Serial Io Uart Debug Stop Bits
  Set default stop bits.
  0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3: TwoStopBits
**/
  UINT8                       SerialIoUartDebugStopBits;

/** Offset 0x0B46 - Serial Io Uart Debug Data Bits
  Set default word length. 0: Default, 5,6,7,8
  5:5BITS, 6:6BITS, 7:7BITS, 8:8BITS
**/
  UINT8                       SerialIoUartDebugDataBits;

/** Offset 0x0B47 - SerialIo Uart PowerGating
  Select SerialIo Uart Powergating mode
  0:Disabled, 1:Enabled, 2:Auto
**/
  UINT8                       SerialIoUartPowerGating;

/** Offset 0x0B48 - Serial Io Uart Debug Mmio Base
  Select SerialIo Uart default MMIO resource in SEC/PEI phase when PcdSerialIoUartMode
  = SerialIoUartPci.
**/
  UINT32                      SerialIoUartDebugMmioBase;

/** Offset 0x0B4C - ISA Serial Base selection
  Select ISA Serial Base address. Default is 0x3F8.
  0:0x3F8, 1:0x2F8
**/
  UINT8                       PcdIsaSerialUartBase;

/** Offset 0x0B4D - CPU SA PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       CpuSaPllVoltageOffset;

/** Offset 0x0B4E - Ring PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       RingPllVoltageOffset;

/** Offset 0x0B4F - System Agent PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       SaPllVoltageOffset;

/** Offset 0x0B50 - IA Atom PLL voltage offset
  IA Atom PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       IaAtomPllVoltageOffset;

/** Offset 0x0B51 - Memory Controller PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-15
**/
  UINT8                       McPllVoltageOffset;

/** Offset 0x0B52 - TCSS Thunderbolt PCIE Root Port 0 Enable
  Set TCSS Thunderbolt PCIE Root Port 0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie0En;

/** Offset 0x0B53 - TCSS Thunderbolt PCIE Root Port 1 Enable
  Set TCSS Thunderbolt PCIE Root Port 1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie1En;

/** Offset 0x0B54 - TCSS Thunderbolt PCIE Root Port 2 Enable
  Set TCSS Thunderbolt PCIE Root Port 2. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie2En;

/** Offset 0x0B55 - TCSS Thunderbolt PCIE Root Port 3 Enable
  Set TCSS Thunderbolt PCIE Root Port 3. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie3En;

/** Offset 0x0B56 - TCSS USB HOST (xHCI) Enable
  Set TCSS XHCI. 0:Disabled  1:Enabled - Must be enabled if xDCI is enabled below
  $EN_DIS
**/
  UINT8                       TcssXhciEn;

/** Offset 0x0B57 - TCSS USB DEVICE (xDCI) Enable
  Set TCSS XDCI. 0:Disabled  1:Enabled - xHCI must be enabled if xDCI is enabled
  $EN_DIS
**/
  UINT8                       TcssXdciEn;

/** Offset 0x0B58 - TCSS DMA0 Enable
  Set TCSS DMA0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma0En;

/** Offset 0x0B59 - TCSS DMA1 Enable
  Set TCSS DMA1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma1En;

/** Offset 0x0B5A - PcdSerialDebugBaudRate
  Baud Rate for Serial Debug Messages. 3:9600, 4:19200, 6:56700, 7:115200.
  3:9600, 4:19200, 6:56700, 7:115200
**/
  UINT8                       PcdSerialDebugBaudRate;

/** Offset 0x0B5B - HobBufferSize
  Size to set HOB Buffer. 0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value(assuming 63KB
  total HOB size).
  0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value
**/
  UINT8                       HobBufferSize;

/** Offset 0x0B5C - Early Command Training
  Enables/Disable Early Command Training
  $EN_DIS
**/
  UINT8                       ECT;

/** Offset 0x0B5D - SenseAmp Offset Training
  Enables/Disable SenseAmp Offset Training
  $EN_DIS
**/
  UINT8                       SOT;

/** Offset 0x0B5E - Early ReadMPR Timing Centering 2D
  Enables/Disable Early ReadMPR Timing Centering 2D
  $EN_DIS
**/
  UINT8                       ERDMPRTC2D;

/** Offset 0x0B5F - Read MPR Training
  Enables/Disable Read MPR Training
  $EN_DIS
**/
  UINT8                       RDMPRT;

/** Offset 0x0B60 - Receive Enable Training
  Enables/Disable Receive Enable Training
  $EN_DIS
**/
  UINT8                       RCVET;

/** Offset 0x0B61 - Jedec Write Leveling
  Enables/Disable Jedec Write Leveling
  $EN_DIS
**/
  UINT8                       JWRL;

/** Offset 0x0B62 - Early Write Time Centering 2D
  Enables/Disable Early Write Time Centering 2D
  $EN_DIS
**/
  UINT8                       EWRTC2D;

/** Offset 0x0B63 - Early Read Time Centering 2D
  Enables/Disable Early Read Time Centering 2D
  $EN_DIS
**/
  UINT8                       ERDTC2D;

/** Offset 0x0B64 - Unmatched Write Time Centering 1D
  Enable/Disable {Unmatched Write Time Centering 1D
  $EN_DIS
**/
  UINT8                       UNMATCHEDWRTC1D;

/** Offset 0x0B65 - Write Timing Centering 1D
  Enables/Disable Write Timing Centering 1D
  $EN_DIS
**/
  UINT8                       WRTC1D;

/** Offset 0x0B66 - Write Voltage Centering 1D
  Enables/Disable Write Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       WRVC1D;

/** Offset 0x0B67 - Read Timing Centering 1D
  Enables/Disable Read Timing Centering 1D
  $EN_DIS
**/
  UINT8                       RDTC1D;

/** Offset 0x0B68 - Read Voltage Centering 1D
  Enable/Disable Read Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       RDVC1D;

/** Offset 0x0B69 - DDR5 ODT Timing Config
  Enable/Disable DDR5 ODT TIMING CONFIG
  $EN_DIS
**/
  UINT8                       DDR5ODTTIMING;

/** Offset 0x0B6A - View Pin Calibration
  Enables/Disable View Pin Calibration
  $EN_DIS
**/
  UINT8                       VIEWPINCAL;

/** Offset 0x0B6B - Read DQS ODT Training
  Enables/Disable Read DQS ODT Training
  $EN_DIS
**/
  UINT8                       RDDQSODTT;

/** Offset 0x0B6C
**/
  UINT8                       Rsvd290[6];

/** Offset 0x0B72 - Read DQ ODT Training
  Enables/Disable Read DQ ODT Training
  $EN_DIS
**/
  UINT8                       RDDQODTT;

/** Offset 0x0B73 - Read Equalization Training
  Enables/Disable Read Equalization Training
  $EN_DIS
**/
  UINT8                       RDEQT;

/** Offset 0x0B74 - Read CTLE Training
  Enables/Disable Read CTLE Training
  $EN_DIS
**/
  UINT8                       RDCTLET;

/** Offset 0x0B75 - Hard Post Package Repair
  Enables/Disable Hard Post Package Repair
  $EN_DIS
**/
  UINT8                       PPR;

/** Offset 0x0B76 - Write Timing Centering 2D
  Enables/Disable Write Timing Centering 2D
  $EN_DIS
**/
  UINT8                       WRTC2D;

/** Offset 0x0B77 - Read Timing Centering 2D
  Enables/Disable Read Timing Centering 2D
  $EN_DIS
**/
  UINT8                       RDTC2D;

/** Offset 0x0B78 - Write Voltage Centering 2D
  Enables/Disable Write Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       WRVC2D;

/** Offset 0x0B79 - Read Voltage Centering 2D
  Enables/Disable Read Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       RDVC2D;

/** Offset 0x0B7A - RxVref Per-Bit Training
  Enable/Disable RxVref Per-Bit Training
  $EN_DIS
**/
  UINT8                       RXVREFPERBIT;

/** Offset 0x0B7B - Command Voltage Centering
  Enables/Disable Command Voltage Centering
  $EN_DIS
**/
  UINT8                       CMDVC;

/** Offset 0x0B7C - Late Command Training
  Enables/Disable Late Command Training
  $EN_DIS
**/
  UINT8                       LCT;

/** Offset 0x0B7D - Turn Around Timing Training
  Enables/Disable Turn Around Timing Training
  $EN_DIS
**/
  UINT8                       TAT;

/** Offset 0x0B7E - Rank Margin Tool
  Enable/disable Rank Margin Tool
  $EN_DIS
**/
  UINT8                       RMT;

/** Offset 0x0B7F - LVR Auto Trim
  Enable/disable LVR Auto Trim
  $EN_DIS
**/
  UINT8                       LVRAUTOTRIM;

/** Offset 0x0B80 - DIMM SPD Alias Test
  Enables/Disable DIMM SPD Alias Test
  $EN_DIS
**/
  UINT8                       ALIASCHK;

/** Offset 0x0B81 - Retrain Margin Check
  Enables/Disable Retrain Margin Check
  $EN_DIS
**/
  UINT8                       RMC;

/** Offset 0x0B82 - Row Hammering Prevention
  Enables/Disable Row Hammering Prevention
  $EN_DIS
**/
  UINT8                       ROWHAMMER;

/** Offset 0x0B83 - Dimm ODT Training
  Enables/Disable Dimm ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTT;

/** Offset 0x0B84 - DIMM RON Training
  Enables/Disable DIMM RON Training
  $EN_DIS
**/
  UINT8                       DIMMRONT;

/** Offset 0x0B85 - TxDqTCO Comp Training
  Enable/Disable TxDqTCO Comp Training
  $EN_DIS
**/
  UINT8                       TXTCO;

/** Offset 0x0B86 - ClkTCO Comp Training
  Enable/Disable ClkTCO Comp Training
  $EN_DIS
**/
  UINT8                       CLKTCO;

/** Offset 0x0B87 - CMD Slew Rate Training
  Enable/Disable CMD Slew Rate Training
  $EN_DIS
**/
  UINT8                       CMDSR;

/** Offset 0x0B88 - CMD Drive Strength
  Enable/Disable CMD Drive Strength
  $EN_DIS
**/
  UINT8                       CMDDS;

/** Offset 0x0B89 - CMD Tx Equalization
  Enable/Disable CMD Tx Equalization
  $EN_DIS
**/
  UINT8                       CMDTXEQ;

/** Offset 0x0B8A - DIMM CA ODT Training
  Enable/Disable DIMM CA ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTCA;

/** Offset 0x0B8B - Write DQ/DQS Retraining
  Enable/Disable Write DQ/DQS Retraining
  $EN_DIS
**/
  UINT8                       WRTRETRAIN;

/** Offset 0x0B8C - Power Saving Meter Update
  Enable/Disable Power Saving Meter Update
  $EN_DIS
**/
  UINT8                       PWRMETER;

/** Offset 0x0B8D - Pre-Training Comp Calibration
  Enable/Disable Pre-Training Comp Calibration
  $EN_DIS
**/
  UINT8                       DDRPRECOMP;

/** Offset 0x0B8E - Read Vref Decap Training
  Enable/Disable Read Vref Decap Training
  $EN_DIS
**/
  UINT8                       RDVREFDC;

/** Offset 0x0B8F - Vddq Training
  Enable/Disable Vddq Training
  $EN_DIS
**/
  UINT8                       VDDQT;

/** Offset 0x0B90 - Rank Margin Tool Per Bit
  Enable/Disable Rank Margin Tool Per Bit
  $EN_DIS
**/
  UINT8                       RMTBIT;

/** Offset 0x0B91 - DQ/DQS Swizzle Training
  Enable/Disable DQ/DQS Swizzle Training
  $EN_DIS
**/
  UINT8                       DQDQSSWZ;

/** Offset 0x0B92 - Ref PI Calibration
  Enable/Disable Ref PI Calibration
  $EN_DIS
**/
  UINT8                       REFPI;

/** Offset 0x0B93 - Rx SAL Calibration
  Enable/Disable Rx SAL Calibration
  0:Disable, 1:Enable
**/
  UINT8                       RXSALCAL;

/** Offset 0x0B94 - VccClk FF Offset Correction
  Enable/Disable VccClk FF Offset Correction
  0:Disable, 1:Enable
**/
  UINT8                       VCCCLKFF;

/** Offset 0x0B95 - Duty Cycle Correction Training
  Enable/Disable Duty Cycle Correction Training
  $EN_DIS
**/
  UINT8                       DCC;

/** Offset 0x0B96 - Duty Cycle Correction Downstream Training
  Enable/Disable Duty Cycle Correction Downstream - PI Serializer/LUT
  $EN_DIS
**/
  UINT8                       DCCDOWNSTREAM;

/** Offset 0x0B97 - Duty Cycle Correction QCLK Calibration
  Enable/Disable Duty Cycle Correction QCLK Calbration
  $EN_DIS
**/
  UINT8                       DCCQCLK;

/** Offset 0x0B98 - Duty Cycle Correction Rise/Fall Training
  Enable/Disable Duty Cycle Correction Rise/Fall Training
  $EN_DIS
**/
  UINT8                       DCCRISEFALL;

/** Offset 0x0B99 - Functional Duty Cycle Correction for DDR5 DQS
  Enable/Disable Functional Duty Cycle Correction for DDR5 DQS
  0:Disable, 1:Enable
**/
  UINT8                       FUNCDCCDQS;

/** Offset 0x0B9A - Functional Duty Cycle Correction for DDR5 CLK
  Enable/Disable Functional Duty Cycle Correction for DDR5 CLK
  0:Disable, 1:Enable
**/
  UINT8                       FUNCDCCCLK;

/** Offset 0x0B9B
**/
  UINT8                       FUNCDCCWCK;

/** Offset 0x0B9C - Functional Duty Cycle Correction for Data DQ
  Enable/Disable Functional Duty Cycle Correction for Data DQ
  0:Disable, 1:Enable
**/
  UINT8                       FUNCDCCDQ;

/** Offset 0x0B9D - Data PI Linearity Calibration
  Enable/Disable {ata PI Linearity Calibration
  $EN_DIS
**/
  UINT8                       DATAPILIN;

/** Offset 0x0B9E - Ddr5 Rx Cross-Talk Cancellation
  Enable/Disable Ddr5 Rx Cross-Talk Cancellation
  $EN_DIS
**/
  UINT8                       DDR5XTALK;

/** Offset 0x0B9F - Duty Cycle Correction for LP5 DCA
  Enable/Disable Duty Cycle Correction for LP5 DCA
  $EN_DIS
**/
  UINT8                       DCCLP5WCKDCA;

/** Offset 0x0BA0 - Unmatched Rx Calibration
  Enable/Disable Rx Unmatched Calibration
  $EN_DIS
**/
  UINT8                       RXUNMATCHEDCAL;

/** Offset 0x0BA1 - Write Rank-to-Rank Training
  Enable/Disable Write Rank-to-Rank Training
  $EN_DIS
**/
  UINT8                       TXRK2RK;

/** Offset 0x0BA2 - Read Rank-to-Rank Training
  Enable/Disable Read Rank-to-Rank Training
  $EN_DIS
**/
  UINT8                       RXRK2RK;

/** Offset 0x0BA3 - Compensation Optimization
  Enable/Disable Compensation Optimization
  $EN_DIS
**/
  UINT8                       OPTIMIZECOMP;

/** Offset 0x0BA4 - DIMM DFE Training
  Enable/Disable DIMM DFE Training
  $EN_DIS
**/
  UINT8                       WRTDIMMDFE;

/** Offset 0x0BA5 - Write Drive Strength
  Enables/Disable Write Drive Strength
  $EN_DIS
**/
  UINT8                       WRTDS;

/** Offset 0x0BA6 - Write Equalization
  Enables/Disable Write Equalization
  $EN_DIS
**/
  UINT8                       WRTEQ;

/** Offset 0x0BA7 - ECC Support
  Enables/Disable ECC Support
  $EN_DIS
**/
  UINT8                       EccSupport;

/** Offset 0x0BA8 - Ibecc
  In-Band ECC Support
  $EN_DIS
**/
  UINT8                       Ibecc;

/** Offset 0x0BA9 - IbeccParity
  In-Band ECC Parity Control
  $EN_DIS
**/
  UINT8                       IbeccParity;

/** Offset 0x0BAA - IbeccOperationMode
  In-Band ECC Operation Mode
  0:Protect base on address range, 1: Non-protected, 2: All protected
**/
  UINT8                       IbeccOperationMode;

/** Offset 0x0BAB - IbeccProtectedRegionEnable
  In-Band ECC Protected Region Enable
  $EN_DIS
**/
  UINT8                       IbeccProtectedRegionEnable[8];

/** Offset 0x0BB3 - WckTCO Comp Training
  Enable/Disable WckTCO Comp Training
  $EN_DIS
**/
  UINT8                       WCKTCO;

/** Offset 0x0BB4 - IbeccProtectedRegionBases
  IBECC Protected Region Bases per IBECC instance
**/
  UINT16                      IbeccProtectedRegionBase[8];

/** Offset 0x0BC4 - IbeccProtectedRegionMasks
  IBECC Protected Region Masks
**/
  UINT16                      IbeccProtectedRegionMask[8];

/** Offset 0x0BD4 - IbeccProtectedRegionOverallBases
  IBECC Protected Region Bases based on enabled IBECC instance
**/
  UINT16                      IbeccProtectedRegionOverallBase[8];

/** Offset 0x0BE4 - IbeccEccInjControl
  IBECC Error Injection Control
  0: No Error Injection, 1:Inject Correctable Error Address match, 3:Inject Correctable
  Error on insertion counter, 5: Inject Uncorrectable Error Address match, 7:Inject
  Uncorrectable Error on insertion counter
**/
  UINT8                       IbeccEccInjControl;

/** Offset 0x0BE5
**/
  UINT8                       UnusedUpdSpace0[3];

/** Offset 0x0BE8 - IbeccEccInjAddrBase
  Address to match against for ECC error injection. Example: 1 = 32MB, 2 = 64MB
**/
  UINT32                      IbeccEccInjAddrBase;

/** Offset 0x0BEC - IbeccEccInjAddrMask
  Mask to match against for ECC error injection
**/
  UINT32                      IbeccEccInjAddrMask;

/** Offset 0x0BF0 - IbeccEccInjCount
  Number of memory transactions between ECC error injection
**/
  UINT8                       IbeccEccInjCount;

/** Offset 0x0BF1 - Memory Remap
  Enables/Disable Memory Remap
  $EN_DIS
**/
  UINT8                       RemapEnable;

/** Offset 0x0BF2 - Rank Interleave support
  Enables/Disable Rank Interleave support. NOTE: RI and HORI can not be enabled at
  the same time.
  $EN_DIS
**/
  UINT8                       RankInterleave;

/** Offset 0x0BF3 - Enhanced Interleave support
  Enables/Disable Enhanced Interleave support
  $EN_DIS
**/
  UINT8                       EnhancedInterleave;

/** Offset 0x0BF4 - Ch Hash Support
  Enable/Disable Channel Hash Support. NOTE: ONLY if Memory interleaved Mode
  $EN_DIS
**/
  UINT8                       ChHashEnable;

/** Offset 0x0BF5 - Extern Therm Status
  Enables/Disable Extern Therm Status
  $EN_DIS
**/
  UINT8                       EnableExtts;

/** Offset 0x0BF6 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDn;

/** Offset 0x0BF7 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDnLpddr;

/** Offset 0x0BF8 - SelfRefresh Enable
  Enables/Disable SelfRefresh Enable
  $EN_DIS
**/
  UINT8                       SrefCfgEna;

/** Offset 0x0BF9 - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeatLpddr;

/** Offset 0x0BFA - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeat;

/** Offset 0x0BFB - Row Hammer Select
  Row Hammer Select
  0:Disable, 1:RFM, 2:pTRR
**/
  UINT8                       RhSelect;

/** Offset 0x0BFC - Exit On Failure (MRC)
  Enables/Disable Exit On Failure (MRC)
  $EN_DIS
**/
  UINT8                       ExitOnFailure;

/** Offset 0x0BFD - DCC Single Rank Tracking
  Force DCC to track single rank only
  $EN_DIS
**/
  UINT8                       DccSingleRankTrack;

/** Offset 0x0BFE - DDR5 supports MR7 WICA 0.5 tCK offset
  DDR5 DRAM Device supports MR7 WICA 0.5 tCK offset, <b>0:False</b>, 1:True
  0:False, 1:True
**/
  UINT8                       IsDdr5MR7WicaSupported;

/** Offset 0x0BFF - Write0 feature
  Enables/Disable Write0 feature
  $EN_DIS
**/
  UINT8                       Write0;

/** Offset 0x0C00 - Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       DdpSharedClock;

/** Offset 0x0C01 - Select if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  ESelect if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedZq;

/** Offset 0x0C02 - Ch Hash Interleaved Bit
  Select the BIT to be used for Channel Interleaved mode. NOTE: BIT7 will interlave
  the channels at a 2 cacheline granularity, BIT8 at 4 and BIT9 at 8. Default is BIT8
  0:BIT6, 1:BIT7, 2:BIT8, 3:BIT9, 4:BIT10, 5:BIT11, 6:BIT12, 7:BIT13
**/
  UINT8                       ChHashInterleaveBit;

/** Offset 0x0C03
**/
  UINT8                       UnusedUpdSpace1;

/** Offset 0x0C04 - Ch Hash Mask
  Set the BIT(s) to be included in the XOR function. NOTE BIT mask corresponds to
  BITS [19:6] Default is 0x30CC
**/
  UINT16                      ChHashMask;

/** Offset 0x0C06
**/
  UINT8                       UnusedUpdSpace2[2];

/** Offset 0x0C08 - Base reference clock value
  Base reference clock value, in Hertz(Default is 125Hz)
  100000000:100Hz, 125000000:125Hz, 167000000:167Hz, 250000000:250Hz
**/
  UINT32                      BClkFrequency;

/** Offset 0x0C0C - EPG DIMM Idd3N
  Active standby current (Idd3N) in milliamps from datasheet. Must be calculated on
  a per DIMM basis. Default is 26
**/
  UINT16                      Idd3n;

/** Offset 0x0C0E - EPG DIMM Idd3P
  Active power-down current (Idd3P) in milliamps from datasheet. Must be calculated
  on a per DIMM basis. Default is 11
**/
  UINT16                      Idd3p;

/** Offset 0x0C10 - CMD Normalization
  Enable/Disable CMD Normalization
  $EN_DIS
**/
  UINT8                       CMDNORM;

/** Offset 0x0C11 - Early DQ Write Drive Strength and Equalization Training
  Enable/Disable Early DQ Write Drive Strength and Equalization Training
  $EN_DIS
**/
  UINT8                       EWRDSEQ;

/** Offset 0x0C12 - Idle Energy Mc0Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch0Dimm0;

/** Offset 0x0C13 - Idle Energy Mc0Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch0Dimm1;

/** Offset 0x0C14 - Idle Energy Mc0Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch1Dimm0;

/** Offset 0x0C15 - Idle Energy Mc0Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch1Dimm1;

/** Offset 0x0C16 - Idle Energy Mc1Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch0Dimm0;

/** Offset 0x0C17 - Idle Energy Mc1Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch0Dimm1;

/** Offset 0x0C18 - Idle Energy Mc1Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch1Dimm0;

/** Offset 0x0C19 - Idle Energy Mc1Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch1Dimm1;

/** Offset 0x0C1A - PowerDown Energy Mc0Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch0Dimm0;

/** Offset 0x0C1B - PowerDown Energy Mc0Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch0Dimm1;

/** Offset 0x0C1C - PowerDown Energy Mc0Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch1Dimm0;

/** Offset 0x0C1D - PowerDown Energy Mc0Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch1Dimm1;

/** Offset 0x0C1E - PowerDown Energy Mc1Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch0Dimm0;

/** Offset 0x0C1F - PowerDown Energy Mc1Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch0Dimm1;

/** Offset 0x0C20 - PowerDown Energy Mc1Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch1Dimm0;

/** Offset 0x0C21 - PowerDown Energy Mc1Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch1Dimm1;

/** Offset 0x0C22 - Activate Energy Mc0Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch0Dimm0;

/** Offset 0x0C23 - Activate Energy Mc0Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch0Dimm1;

/** Offset 0x0C24 - Activate Energy Mc0Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch1Dimm0;

/** Offset 0x0C25 - Activate Energy Mc0Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch1Dimm1;

/** Offset 0x0C26 - Activate Energy Mc1Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch0Dimm0;

/** Offset 0x0C27 - Activate Energy Mc1Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch0Dimm1;

/** Offset 0x0C28 - Activate Energy Mc1Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch1Dimm0;

/** Offset 0x0C29 - Activate Energy Mc1Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch1Dimm1;

/** Offset 0x0C2A - Read Energy Mc0Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch0Dimm0;

/** Offset 0x0C2B - Read Energy Mc0Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch0Dimm1;

/** Offset 0x0C2C - Read Energy Mc0Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch1Dimm0;

/** Offset 0x0C2D - Read Energy Mc0Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch1Dimm1;

/** Offset 0x0C2E - Read Energy Mc1Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch0Dimm0;

/** Offset 0x0C2F - Read Energy Mc1Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch0Dimm1;

/** Offset 0x0C30 - Read Energy Mc1Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch1Dimm0;

/** Offset 0x0C31 - Read Energy Mc1Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch1Dimm1;

/** Offset 0x0C32 - Write Energy Mc0Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch0Dimm0;

/** Offset 0x0C33 - Write Energy Mc0Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch0Dimm1;

/** Offset 0x0C34 - Write Energy Mc0Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch1Dimm0;

/** Offset 0x0C35 - Write Energy Mc0Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch1Dimm1;

/** Offset 0x0C36 - Write Energy Mc1Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch0Dimm0;

/** Offset 0x0C37 - Write Energy Mc1Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch0Dimm1;

/** Offset 0x0C38 - Write Energy Mc1Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch1Dimm0;

/** Offset 0x0C39 - Write Energy Mc1Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch1Dimm1;

/** Offset 0x0C3A - Throttler CKEMin Timer
  Timer value for CKEMin, range[255;0]. Req'd min of SC_ROUND_T + BYTE_LENGTH (4).
  Dfault is 0x00
**/
  UINT8                       ThrtCkeMinTmr;

/** Offset 0x0C3B - Allow Opp Ref Below Write Threhold
  Allow opportunistic refreshes while we don't exit power down.
  $EN_DIS
**/
  UINT8                       AllowOppRefBelowWriteThrehold;

/** Offset 0x0C3C - Write Threshold
  Number of writes that can be accumulated while CKE is low before CKE is asserted.
**/
  UINT8                       WriteThreshold;

/** Offset 0x0C3D - Rapl Power Floor Ch0
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh0;

/** Offset 0x0C3E - Rapl Power Floor Ch1
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh1;

/** Offset 0x0C3F - Command Rate Support
  CMD Rate and Limit Support Option. NOTE: ONLY supported in 1N Mode, Default is 3 CMDs
  0:Disable, 5:2 CMDS, 7:3 CMDS, 9:4 CMDS, 11:5 CMDS, 13:6 CMDS, 15:7 CMDS
**/
  UINT8                       EnCmdRate;

/** Offset 0x0C40 - MC_REFRESH_RATE
  Type of Refresh Rate used to prevent Row Hammer. Default is NORMAL Refresh
  0:NORMAL Refresh, 1:1x Refresh, 2:2x Refresh, 3:4x Refresh
**/
  UINT8                       McRefreshRate;

/** Offset 0x0C41 - Energy Performance Gain
  Enable/disable Energy Performance Gain. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       EpgEnable;

/** Offset 0x0C42 - RH pTRR LFSR0 Mask
  Row Hammer pTRR LFSR0 Mask, 1/2^(value)
**/
  UINT8                       Lfsr0Mask;

/** Offset 0x0C43 - User Manual Threshold
  Disabled: Predefined threshold will be used.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserThresholdEnable;

/** Offset 0x0C44 - User Manual Budget
  Disabled: Configuration of memories will defined the Budget value.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserBudgetEnable;

/** Offset 0x0C45 - Opportunistic Self Refresh
  Enable\Disable Opportunistic Self Refresh.
  0:Disabled, 1:Enabled
**/
  UINT8                       OpportunisticSref;

/** Offset 0x0C46 - Power Down Mode
  This option controls command bus tristating during idle periods
  0x0:No Power Down, 0x1:APD, 0x6:PPD DLL OFF, 0xFF:Auto
**/
  UINT8                       PowerDownMode;

/** Offset 0x0C47 - Pwr Down Idle Timer
  The minimum value should = to the worst case Roundtrip delay + Burst_Length. 0 means
  AUTO: 64 for ULX/ULT, 128 for DT/Halo
**/
  UINT8                       PwdwnIdleCounter;

/** Offset 0x0C48 - Page Close Idle Timeout
  This option controls Page Close Idle Timeout
  0:Enabled, 1:Disabled
**/
  UINT8                       DisPgCloseIdleTimeout;

/** Offset 0x0C49 - Bitmask of ranks that have CA bus terminated
  Offset 225 LPDDR4: Bitmask of ranks that have CA bus terminated. <b>0x01=Default,
  Rank0 is terminating and Rank1 is non-terminating</b>
**/
  UINT8                       CmdRanksTerminated;

/** Offset 0x0C4A - PcdSerialDebugLevel
  Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       PcdSerialDebugLevel;

/** Offset 0x0C4B - MRC Safe Mode Override
  SafeModeOverride[0] Enable DdrSafeMode override, SafeModeOverride[1] Enable McSafeMode
  override, SafeModeOverride[2] Enable MrcSafeMode override, SafeModeOverride[3]
  Enable Training Algorithm (TrainingEnables) safe mode override, SafeModeOverride[4]
  Enable SaGv safe mode override
**/
  UINT8                       SafeModeOverride;

/** Offset 0x0C4C - MRC Safe Mode Support
  MrcSafeMode[0]: Safe Frequency, MrcSafeMode[1]: Safe Gear, SafeMode[2]: Safe VCC
  IOG/CLK, SafeMode[3]: Safe VCC DDQ
**/
  UINT8                       MrcSafeMode;

/** Offset 0x0C4D - Retrain On Working Channel
  Enables/Disable Retrain On Working Channel feature
  $EN_DIS
**/
  UINT8                       RetrainToWorkingChannel;

/** Offset 0x0C4E - DDR Phy Safe Mode Support
  DdrSafeMode[0]: Basic PM Features, DdrSafeMode[1]: Spine Gating, DdrSafeMode[2]:
  Advanced DCC, DdrSafeMode[3]: R2R Training, DdrSafeMode[4]: Transformer Mode, DdrSafeMode[5]:
  PLL Operation, DdrSafeMode[6]: Safe ODT/SenseAmp Timing, DdrSafeMode[7]: Vtt Termination,
  DdrSafeMode[8]: Periodic Comp
**/
  UINT16                      DdrSafeMode;

/** Offset 0x0C50 - Mc Safe Mode Support
  McSafeMode[0]: Clk Gate / BGF, McSafeMode[1]: CKE Pdwn, McSafeMode[2]: Tristate,
  McSafeMode[3]: PHY Power States / Clock Spine, McSafeMode[4]: Same Rank TA, McSafeMode[5]:
  Different Rank TA, McSafeMode[6]: MR4_Period / ZQCAL_Period McSafeMode[7]: LP5
  Wck Mode, SafeMode[8]: Self Refresh, McSafeMode[9]: WR/RD Retraining, McSafeMode[10]:
  Power Saving
**/
  UINT16                      McSafeMode;

/** Offset 0x0C52 - Board Stack Up
  0: Typical, 1: Frequency Limited
**/
  UINT8                       BoardStackUp;

/** Offset 0x0C53 - Ask MRC to clear memory content
  Ask MRC to clear memory content <b>0: Do not Clear Memory;</b> 1: Clear Memory.
  $EN_DIS
**/
  UINT8                       CleanMemory;

/** Offset 0x0C54 - TCSS USB Port Enable
  Bitmap for per port enabling
**/
  UINT8                       UsbTcPortEnPreMem;

/** Offset 0x0C55 - Power Down Mode
  This option controls command bus tristating during idle periods
  0x0:Enable, 0x1:Disable, 0x2:Auto
**/
  UINT8                       PwDownMode;

/** Offset 0x0C56 - Post Code Output Port
  This option configures Post Code Output Port
**/
  UINT16                      PostCodeOutputPort;

/** Offset 0x0C58 - Enable/Disable I2cPostcode
  Enable (Default): Postcode via I2C, Disable: Postcode via Port80
  $EN_DIS
**/
  UINT8                       I2cPostCodeEnable;

/** Offset 0x0C59 - RMTLoopCount
  Specifies the Loop Count to be used during Rank Margin Tool Testing. 0 - AUTO
**/
  UINT8                       RMTLoopCount;

/** Offset 0x0C5A - Enable/Disable SA CRID
  Enable: SA CRID, Disable (Default): SA CRID
  $EN_DIS
**/
  UINT8                       CridEnable;

/** Offset 0x0C5B
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x0C5C - Pwr Down Idle Timer
  Default 0 = AUTO. Range is 30 to 2000(in us)
**/
  UINT16                      PwDownIdleTimer;

/** Offset 0x0C5E
**/
  UINT8                       UnusedUpdSpace4[2];

/** Offset 0x0C60 - BCLK RFI Frequency
  Bclk RFI Frequency for each SAGV point in Hz units. 98000000Hz = 98MHz <b>0 - No
  RFI Tuning</b>. Range is 98Mhz-100Mhz.
**/
  UINT32                      BclkRfiFreq[4];

/** Offset 0x0C70 - Size of PCIe IMR.
  Size of PCIe IMR in megabytes
**/
  UINT16                      PcieImrSize;

/** Offset 0x0C72 - Enable PCIe IMR
  0: Disable(AUTO), 1: Enable
  $EN_DIS
**/
  UINT8                       PcieImrEnabled;

/** Offset 0x0C73 - Enable PCIe IMR
  1: PCH PCIE, 2: SA PCIE. If PCIeImrEnabled is TRUE then this will use to select
  the Root port location from PCH PCIe or SA PCIe
  $EN_DIS
**/
  UINT8                       PcieImrRpLocation;

/** Offset 0x0C74 - Root port number for IMR.
  Root port number for IMR.If PCieImrRpLocation is PCH PCIe then select root port
  from 0 to 23 and if it is SA PCIe then select root port from 0 to 3
**/
  UINT8                       PcieImrRpSelection;

/** Offset 0x0C75 - SerialDebugMrcLevel
  MRC Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       SerialDebugMrcLevel;

/** Offset 0x0C76 - DdrOneDpc
  DDR 1DPC performance feature for 2R DIMMs. Can be enabled on DIMM0 or DIMM1 only,
  or on both (default)
  0: Disabled, 1: Enabled on DIMM0 only, 2: Enabled on DIMM1 only, 3: Enabled
**/
  UINT8                       DdrOneDpc;

/** Offset 0x0C77 - Override Driver Type
  Override Driver Type. 0=Auto, 1=CMOS, 2=NMOS
**/
  UINT8                       OverrideDriverType;

/** Offset 0x0C78 - Lp5 Bypass Vddq Limits
  Bypass Lp5 Vccddq Fuse limits. Advised to keep disabled
**/
  UINT8                       Lp5BypassVddqLimits;

/** Offset 0x0C79
**/
  UINT8                       Rsvd320[1];

/** Offset 0x0C7A - Vddq Voltage Override for CMOS
  # is multiple of 1mV where 0 means Auto.
**/
  UINT16                      VddqVoltageOverride;

/** Offset 0x0C7C - VccIog Voltage Override
  # is multiple of 1mV where 0 means Auto.
**/
  UINT16                      VccIogVoltageOverride;

/** Offset 0x0C7E - VccClk Voltage Override
  # is multiple of 1mV where 0 means Auto.
**/
  UINT16                      VccClkVoltageOverride;

/** Offset 0x0C80 - Extended Bank Hashing
  Eanble/Disable ExtendedBankHashing
  $EN_DIS
**/
  UINT8                       ExtendedBankHashing;

/** Offset 0x0C81 - RH pTRR LFSR1 Mask
  Row Hammer pTRR LFSR1 Mask, 1/2^(value)
**/
  UINT8                       Lfsr1Mask;

/** Offset 0x0C82 - Refresh Watermarks
  Refresh Watermarks: 0-Low, 1-High (default)
  0:Set Refresh Watermarks to Low, 1:Set Refresh Watermarks to High (Default)
**/
  UINT8                       RefreshWm;

/** Offset 0x0C83 - Command Pins Mapping
  BitMask where bits [3:0] are Controller 0 Channel [3:0] and bits [7:4] are Controller
  1 Channel [3:0]. 0 = CCC pin mapping is Ascending, 1 = CCC pin mapping is Descending.
**/
  UINT8                       Lp5CccConfig;

/** Offset 0x0C84 - Command Pins Mirrored
  BitMask where bits [3:0] are Controller 0 Channel [3:0] and bits [7:4] are Controller
  1 Channel [3:0]. 0 = No Command Mirror and 1 = Command Mirror.
**/
  UINT8                       CmdMirror;

/** Offset 0x0C85 - Skip override boot mode When Fw Update.
  When set to TRUE and boot mode is BOOT_ON_FLASH_UPDATE, skip setting boot mode to
  BOOT_WITH_FULL_CONFIGURATION in PEI memory init.
  $EN_DIS
**/
  UINT8                       SiSkipOverrideBootModeWhenFwUpdate;

/** Offset 0x0C86 - Opportunistic Self Refresh IdleTimer
  Default 0 = AUTO. Range is 500 to 10000(in us)
**/
  UINT16                      OppSrefIdleTmr;

/** Offset 0x0C88 - LowerBasicMemTestSize
  Reduce BasicMemoryTest size WA: 0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       LowerBasicMemTestSize;

/** Offset 0x0C89 - Board Topology
  0: Daisy, 1: Tee
**/
  UINT8                       BoardTopology;

/** Offset 0x0C8A - RxDqsDelayTempCoeff
  Default = 4. Range from 0-255
**/
  UINT8                       RxDqsDelayTempCoeff;

/** Offset 0x0C8B
**/
  UINT8                       MrcFspmUpdRsvd[15];

/** Offset 0x0C9A - PPR Test Type
  Select memory tests used in Post Package Repair flow. This option is only valid
  if PPR=1, otherwise ignored. Bit 0: WCMATS8 test, Bit 1: Data Retention test, Bit
  2: X March test, Bit 3: X March G test, Bit 4: Y March Short test, Bit 5: Y March
  Long test. Default=0x3, WCMATS8 and data retention
**/
  UINT8                       PprTestType;

/** Offset 0x0C9B - PreMemRsvd
  Reserved for Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedFspmUpd[2];

/** Offset 0x0C9D - Skip external display device scanning
  Enable: Do not scan for external display device, Disable (Default): Scan external
  display devices
  $EN_DIS
**/
  UINT8                       SkipExtGfxScan;

/** Offset 0x0C9E - Generate BIOS Data ACPI Table
  Enable: Generate BDAT for MRC RMT or SA PCIe data. Disable (Default): Do not generate it
  $EN_DIS
**/
  UINT8                       BdatEnable;

/** Offset 0x0C9F - Lock PCU Thermal Management registers
  Lock PCU Thermal Management registers. Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       LockPTMregs;

/** Offset 0x0CA0 - Panel Power Enable
  Control for enabling/disabling VDD force bit (Required only for early enabling of
  eDP panel). 0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       PanelPowerEnable;

/** Offset 0x0CA1 - BdatTestType
  Indicates the type of Memory Training data to populate into the BDAT ACPI table.
  0:RMT per Rank, 1:RMT per Bit, 2:Margin2D
**/
  UINT8                       BdatTestType;

/** Offset 0x0CA2
**/
  UINT8                       Rsvd330[2];

/** Offset 0x0CA4 - PMR Size
  Size of PMR memory buffer. 0x400000 for normal boot and 0x200000 for S3 boot
**/
  UINT32                      DmaBufferSize;

/** Offset 0x0CA8 - The policy for VTd driver behavior
  BIT0: Enable IOMMU during boot, BIT1: Enable IOMMU when transfer control to OS
**/
  UINT8                       PreBootDmaMask;

/** Offset 0x0CA9
**/
  UINT8                       Rsvd340[1];

/** Offset 0x0CAA - Delta T12 Power Cycle Delay required in ms
  Select the value for delay required. 0= No delay, 0xFFFF(Default) = Auto calculate
  T12 Delay to max 500ms
  0 : No Delay, 0xFFFF : Auto Calulate T12 Delay
**/
  UINT16                      DeltaT12PowerCycleDelay;

/** Offset 0x0CAC - HgSubSystemId
  Hybrid Graphics SubSystemId
**/
  UINT16                      HgSubSystemId;

/** Offset 0x0CAE - Platform LID Status for LFP Displays.
  LFP Display Lid Status (LID_STATUS enum): 0 (Default): LidClosed, 1: LidOpen.
  0: LidClosed, 1: LidOpen
**/
  UINT8                       LidStatus;

/** Offset 0x0CAF - Control VGA Initialition sequence
  Initialise VGA Init, Set BIT0 - 0 (No VGA Support), BIT0 = 1 (VGA Supported) BIT1
  = 1 (VGA Exit)
  0x0: NO VGA Init, 0x1: VGA Init, 0x3: VGA Init and VGA Exit
**/
  UINT8                       VgaInitControl;

/** Offset 0x0CB0 - Graphics Configuration Ptr
  Points to VBT
**/
  UINT32                      VbtPtr;

/** Offset 0x0CB4 - Intel Graphics VBT (Video BIOS Table) Size
  Size of Graphics VBT Image
**/
  UINT32                      VbtSize;

/** Offset 0x0CB8 - VGA Training Message Pointer
  Points to VGA Message Array
**/
  UINT32                      VgaMessage;

/** Offset 0x0CBC - SaPreMemTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SaPreMemTestRsvd[75];

/** Offset 0x0D07 - PPR Run Once
  When Eanble, PPR will run only once and then is disabled at next training cycle
  $EN_DIS
**/
  UINT8                       PprRunOnce;

/** Offset 0x0D08 - PPR Run During Fastboot
  When Eanble, PPR will run during fastboot
  $EN_DIS
**/
  UINT8                       PprRunAtFastboot;

/** Offset 0x0D09 - PPR Repair Type
  PPR Repair Type: 0:Do not Repair (Default), 1:Soft Repair, 2:Hard Repair
  0:Do not Repair (Default), 1:Soft Repair, 2:Hard Repair
**/
  UINT8                       PprRepairType;

/** Offset 0x0D0A - PPR Error Injection
  When Eanble, PPR will inject bad rows during testing
  $EN_DIS
**/
  UINT8                       PprErrorInjection;

/** Offset 0x0D0B - PPR ForceRepair
  When Eanble, PPR will force repair some rows many times (90)
  $EN_DIS
**/
  UINT8                       PprForceRepair;

/** Offset 0x0D0C - PPR Repair Controller
  PPR repair controller: User chooses to force repair specifc address
**/
  UINT8                       PprRepairController;

/** Offset 0x0D0D - PPR Repair Channel
  PPR repair Channel: User chooses to force repair specifc address
**/
  UINT8                       PprRepairChannel;

/** Offset 0x0D0E - PPR Repair Dimm
  PPR repair Dimm: User chooses to force repair specifc address
**/
  UINT8                       PprRepairDimm;

/** Offset 0x0D0F - PPR Repair Rank
  PPR repair Rank: User chooses to force repair specifc address
**/
  UINT8                       PprRepairRank;

/** Offset 0x0D10 - PPR Repair Row
  PPR repair Row: User chooses to force repair specifc address
**/
  UINT32                      PprRepairRow;

/** Offset 0x0D14 - PPR Repair Physical Address Low
  PPR repair Physical Address Low: User chooses to force repair specifc address
**/
  UINT32                      PprRepairPhysicalAddrLow;

/** Offset 0x0D18 - PPR Repair Physical Address High
  PPR repair Physical Address High: User chooses to force repair specifc address
**/
  UINT32                      PprRepairPhysicalAddrHigh;

/** Offset 0x0D1C - PPR Repair BankGroup
  PPR repair BankGroup: User chooses to force repair specifc address
**/
  UINT8                       PprRepairBankGroup;

/** Offset 0x0D1D - PPR Repair Bank
  PPR repair Bank: User chooses to force repair specifc address
**/
  UINT8                       PprRepairBank;

/** Offset 0x0D1E - DIMM CA ODT Split Training
  Enable/Disable DIMM CA ODT Split Training
  $EN_DIS
**/
  UINT8                       DIMMODTCASPLIT;

/** Offset 0x0D1F - CMD Drive Strength Split
  Enable/Disable CMD Drive Strength Split
  $EN_DIS
**/
  UINT8                       CMDDSSPLIT;

/** Offset 0x0D20 - CMD Slew Rate Split Training
  Enable/Disable CMD Slew Rate Split Training
  $EN_DIS
**/
  UINT8                       CMDSRSPLIT;

/** Offset 0x0D21
**/
  UINT8                       SaFspmUpdRsvd[23];

/** Offset 0x0D38 - TotalFlashSize
  Enable/Disable. 0: Disable, define default value of TotalFlashSize , 1: enable
**/
  UINT16                      TotalFlashSize;

/** Offset 0x0D3A - BiosSize
  The size of the BIOS region of the IFWI. Used if FspmUpd->FspmConfig.BiosGuard !=
  0. If BiosGuard is enabled, MRC will increase the size of the DPR (DMA Protected
  Range) so that a BIOS Update Script can be stored in the DPR.
**/
  UINT16                      BiosSize;

/** Offset 0x0D3C - SecurityTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SecurityTestRsvd[12];

/** Offset 0x0D48
**/
  UINT8                       SecFspmUpdRsvd[16];

/** Offset 0x0D58 - Smbus dynamic power gating
  Disable or Enable Smbus dynamic power gating.
  $EN_DIS
**/
  UINT8                       SmbusDynamicPowerGating;

/** Offset 0x0D59 - Disable and Lock Watch Dog Register
  Set 1 to clear WDT status, then disable and lock WDT registers.
  $EN_DIS
**/
  UINT8                       WdtDisableAndLock;

/** Offset 0x0D5A - SoC BCLK PLL configuration
  Configure SoC BCLK PLL state
  $EN_DIS
**/
  UINT8                       SocBclkPllOn;

/** Offset 0x0D5B - CPU BCLK PLL configuration
  Configure CPU BCLK PLL state
  $EN_DIS
**/
  UINT8                       CpuBclkPllOn;

/** Offset 0x0D5C - SMBUS SPD Write Disable
  Set/Clear Smbus SPD Write Disable. 0: leave SPD Write Disable bit; 1: set SPD Write
  Disable bit. For security recommendations, SPD write disable bit must be set.
  $EN_DIS
**/
  UINT8                       SmbusSpdWriteDisable;

/** Offset 0x0D5D - Dmi Tran Co Over En
  Enable/Disable Lane Transmitter Coefficient.
**/
  UINT8                       PchDmiTranCoOverEn[8];

/** Offset 0x0D65 - Dmi Tran Co Over Post Cur
  Lane Transmitter Post-Cursor Coefficient Override.
**/
  UINT8                       PchDmiTranCoOverPostCur[8];

/** Offset 0x0D6D - Dmi Tran Co Over Pre Cur
  Lane Transmitter Pre-Cursor Coefficient Override.
**/
  UINT8                       PchDmiTranCoOverPreCur[8];

/** Offset 0x0D75 - Dmi Up Port Tran Preset
  Upstream Port Lane Transmitter Preset.
**/
  UINT8                       PchDmiUpPortTranPreset[8];

/** Offset 0x0D7D - Dmi UpPort Tran Preset En
  0: POR setting, 1: force enable, 2: force disable.
**/
  UINT8                       PchDmiUpPortTranPresetEn;

/** Offset 0x0D7E - Dmi Rtlepceb
  DMI Remote Transmit Link Equalization Preset/Coefficient Evaluation Bypass (RTLEPCEB).
**/
  UINT8                       PchDmiRtlepceb;

/** Offset 0x0D7F - HECI Timeouts
  0: Disable, 1: Enable (Default) timeout check for HECI
  $EN_DIS
**/
  UINT8                       HeciTimeouts;

/** Offset 0x0D80 - Force ME DID Init Status
  Test, 0: disable, 1: Success, 2: No Memory in Channels, 3: Memory Init Error, Set
  ME DID init stat value
  $EN_DIS
**/
  UINT8                       DidInitStat;

/** Offset 0x0D81 - CPU Replaced Polling Disable
  Test, 0: disable, 1: enable, Setting this option disables CPU replacement polling loop
  $EN_DIS
**/
  UINT8                       DisableCpuReplacedPolling;

/** Offset 0x0D82 - Check HECI message before send
  Test, 0: disable, 1: enable, Enable/Disable message check.
  $EN_DIS
**/
  UINT8                       DisableMessageCheck;

/** Offset 0x0D83 - Skip MBP HOB
  Test, 0: disable, 1: enable, Enable/Disable sending MBP message and creating MBP Hob.
  $EN_DIS
**/
  UINT8                       SkipMbpHob;

/** Offset 0x0D84 - HECI2 Interface Communication
  Test, 0: disable, 1: enable, Adds or Removes HECI2 Device from PCI space.
  $EN_DIS
**/
  UINT8                       HeciCommunication2;

/** Offset 0x0D85 - Enable KT device
  Test, 0: POR, 1: enable, 2: disable, Enable or Disable KT device.
  $EN_DIS
**/
  UINT8                       KtDeviceEnable;

/** Offset 0x0D86 - Skip CPU replacement check
  Test, 0: disable, 1: enable, Setting this option to skip CPU replacement check
  $EN_DIS
**/
  UINT8                       SkipCpuReplacementCheck;

/** Offset 0x0D87
**/
  UINT8                       PchMeFspmUpdRsvd[100];

/** Offset 0x0DEB - Avx2 Voltage Guardband Scaling Factor
  AVX2 Voltage Guardband Scale factor applied to AVX2 workloads. Range is 0-200 in
  1/100 units, where a value of 125 would apply a 1.25 scale factor.
**/
  UINT8                       Avx2VoltageScaleFactor;

/** Offset 0x0DEC - Avx512 Voltage Guardband Scaling Factor
  DEPRECATED. AVX512 Voltage Guardband Scale factor applied to AVX512 workloads. Range
  is 0-200 in 1/100 units, where a value of 125 would apply a 1.25 scale factor.
**/
  UINT8                       Avx512VoltageScaleFactor;

/** Offset 0x0DED - Serial Io Uart Debug Mode
  Select SerialIo Uart Controller mode
  0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       SerialIoUartDebugMode;

/** Offset 0x0DEE
**/
  UINT16                      Rsvd391;

/** Offset 0x0DF0 - SerialIoUartDebugRxPinMux - FSPM
  Select RX pin muxing for SerialIo UART used for debug
**/
  UINT32                      SerialIoUartDebugRxPinMux;

/** Offset 0x0DF4 - SerialIoUartDebugTxPinMux - FSPM
  Select TX pin muxing for SerialIo UART used for debug
**/
  UINT32                      SerialIoUartDebugTxPinMux;

/** Offset 0x0DF8 - SerialIoUartDebugRtsPinMux - FSPM
  Select SerialIo Uart used for debug Rts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RTS*
  for possible values.
**/
  UINT32                      SerialIoUartDebugRtsPinMux;

/** Offset 0x0DFC - SerialIoUartDebugCtsPinMux - FSPM
  Select SerialIo Uart used for debug Cts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_CTS*
  for possible values.
**/
  UINT32                      SerialIoUartDebugCtsPinMux;

/** Offset 0x0E00 - Serial Io Uart Debug Pci Base
  Specify PciCfgBase address. Allows for SerialIO UART functionality outside Bus 0
**/
  UINT32                      SerialIoUartDebugPciCfgBase;

/** Offset 0x0E04 - Memory Subsystem voltage mode
  Memory Subsystem voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       MemSSVoltageMode;

/** Offset 0x0E05
**/
  UINT8                       Rsvd390;

/** Offset 0x0E06 - Memory Subsystem Adaptive Voltage
  Adaptive voltage applied to the memory when the cpu is operating in adaptive mode.
  Valid Range 0 to 2000
**/
  UINT16                      MemSSAdaptiveVoltage;

/** Offset 0x0E08 - Memory Subsystem voltage override
  The Memory Subsystem voltage override which is applied to the entire range of memory
  frequencies. Valid Range 0 to 2000
**/
  UINT16                      MemSSVoltageOverride;

/** Offset 0x0E0A - Memory Subsystem VF Point Offset Mode
  Selects Memory Subsystem Voltage & Frequency Offset mode between Legacy and Selection
  modes. In Legacy Mode, setting a global offset for the entire VF curve. In Selection
  Mode, setting a selected VF point; <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       MemSSVfPointOffsetMode;

/** Offset 0x0E0B - Maximum Memory Subsystem turbo ratio override
  Maximum Memory Subsystem turbo ratio override allows to increase memory frequency
  beyond the fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-85
**/
  UINT8                       MemSSMaxOcRatio;

/** Offset 0x0E0C - Memory Subsystem Turbo voltage Offset
  The voltage offset applied to the memory while operating in turbo mode. Valid Range 0 to 1000
**/
  UINT16                      MemSSVoltageOffset;

/** Offset 0x0E0E - Select Core(s) and RING DLVR Mode
  Select Core(s) and RING DLVR Mode). <b>0: Regulation Mode</b>; 1: Power Gate Mode
  0:Regulation Mode, 1:Power Gate Mode
**/
  UINT8                       CpuDlvrMode;

/** Offset 0x0E0F - Maximum clr turbo ratio override
  Maximum clr turbo ratio override allows to increase CPU clr frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-85
**/
  UINT8                       NguMaxOcRatio;

/** Offset 0x0E10 - NGU voltage mode
  NGU voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       NguVoltageMode;

/** Offset 0x0E11 - NGU Ratio
  Sets the Ratio for NGU when SAGV is enabled, using SAVG B2P Mailbox cmd 0x22 and
  subcommand 0x1. When this value is zero, dynamic mode is selected and NGU ratio
  can be modified using OCMB cmd 0x11. When valid ratio value is set, static mode
  is selected with the fixed ratio specified by this value.. <b>0: Hardware defaults.</b>
  Range: 0-85
**/
  UINT8                       NguRatio;

/** Offset 0x0E12 - NGU voltage override
  The NGU voltage override which is applied to the entire range of cpu NGU frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      NguVoltageOverride;

/** Offset 0x0E14 - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      NguAdaptiveVoltage;

/** Offset 0x0E16 - NGU Turbo voltage Offset
  The voltage offset applied to the NGU while operating in turbo mode. Valid Range 0 to 1000
**/
  UINT16                      NguVoltageOffset;

/** Offset 0x0E18 - NGU VF Point Offset Mode
  Selects NGU Voltage & Frequency Offset mode between Legacy and Selection modes.
  In Legacy Mode, setting a global offset for the entire VF curve. In Selection Mode,
  setting a selected VF point; <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       NguVfPointOffsetMode;

/** Offset 0x0E19
**/
  UINT8                       Rsvd410[1];

/** Offset 0x0E1A - NGU VF Point Offset
  Array used to specifies the NGU Voltage Offset applied to the each selected VF Point.
  This voltage is specified in millivolts.
**/
  UINT16                      NguVfPointOffset[15];

/** Offset 0x0E38 - NGU VF Point Offset Prefix
  Sets the NguVfPointOffset value as positive or negative for corresponding core VF
  Point; <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       NguVfPointOffsetPrefix[15];

/** Offset 0x0E47 - NGU VF Point Ratio
  Array for the each selected NGU VF Point to display the ration.
**/
  UINT8                       NguVfPointRatio[15];

/** Offset 0x0E56 - NGU VF Point Count
  Number of supported NGU Voltage & Frequency Point Offset
**/
  UINT8                       NguVfPointCount;

/** Offset 0x0E57
**/
  UINT8                       Rsvd420[11];

/** Offset 0x0E62 - GT VF Point Offset Mode
  Selects GT Voltage & Frequency Offset mode between Legacy and Selection modes. In
  Legacy Mode, setting a global offset for the entire VF curve. In Selection Mode,
  setting a selected VF point; <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       GtVfPointOffsetMode;

/** Offset 0x0E63
**/
  UINT8                       Rsvd430[1];

/** Offset 0x0E64 - GT VF Point Offset
  Array used to specifies the GT Voltage Offset applied to the each selected VF Point.
  This voltage is specified in millivolts.
**/
  UINT16                      GtVfPointOffset[15];

/** Offset 0x0E82 - GT VF Point Offset Prefix
  Sets the GtVfPointOffset value as positive or negative for corresponding core VF
  Point; <b>0: Positive </b>; 1: Negative.
**/
  UINT8                       GtVfPointOffsetPrefix[15];

/** Offset 0x0E91 - GT VF Point Ratio
  Array for the each selected GT VF Point to display the ration.
**/
  UINT8                       GtVfPointRatio[15];

/** Offset 0x0EA0 - GT VF Point Count
  Number of supported GT Voltage & Frequency Point Offset
**/
  UINT8                       GtVfPointCount;

/** Offset 0x0EA1 - Time Measure
  Time Measure: 0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       MrcTimeMeasure;

/** Offset 0x0EA2 - Must use static SPD data from VPD
  Must use static SPD data from VPD and Spd Address is correct: Each bit maps to one dimm
**/
  UINT16                      MrcMustStaticSpdData;

/** Offset 0x0EA4
**/
  UINT8                       UnusedUpdSpace5[4];

/** Offset 0x0EA8 - TME Exclude Base Address
  TME Exclude Base Address.
**/
  UINT64                      TmeExcludeBase;

/** Offset 0x0EB0 - TME Exclude Size Value
  TME Exclude Size Value.
**/
  UINT64                      TmeExcludeSize;

/** Offset 0x0EB8 - Generate New TME Key
  Enable: Generate New TME Key, Disable(Default): TME key determine by type of reset
  $EN_DIS
**/
  UINT8                       GenerateNewTmeKey;

/** Offset 0x0EB9 - CkdAddress Tabl
  Specify CKD Address table for CH0D0/CH0D1/CH1D0&CH1D1
**/
  UINT8                       CkdAddressTable[16];

/** Offset 0x0EC9
**/
  UINT8                       ReservedFspmUpd2[7];
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x0ED0
**/
  UINT8                       Rsvd500[6];

/** Offset 0x0ED6
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
