/** @file

  @copyright
  Copyright (c) 2019, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#include <MemInfoHob.h>

///
/// The ChipsetInit Info structure provides the information of ME ChipsetInit CRC and BIOS ChipsetInit CRC.
///
typedef struct {
  UINT8             Revision;
  UINT8             Rsvd[3];
  UINT16            MeChipInitCrc;
  UINT16            BiosChipInitCrc;
} SI_CHIPSET_INIT_INFO;


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - Platform Reserved Memory Size
  The minimum platform memory size required to pass control into DXE
**/
  UINT64                      PlatformMemorySize;

/** Offset 0x0048 - Memory SPD Pointer Channel 0 Dimm 0
  Pointer to SPD data in Memory
**/
  UINT32                      MemorySpdPtr00;

/** Offset 0x004C - Memory SPD Pointer Channel 0 Dimm 1
  Pointer to SPD data in Memory
**/
  UINT32                      MemorySpdPtr01;

/** Offset 0x0050 - Memory SPD Pointer Channel 1 Dimm 0
  Pointer to SPD data in Memory
**/
  UINT32                      MemorySpdPtr10;

/** Offset 0x0054 - Memory SPD Pointer Channel 1 Dimm 1
  Pointer to SPD data in Memory
**/
  UINT32                      MemorySpdPtr11;

/** Offset 0x0058 - SPD Data Length
  Length of SPD Data
  0x100:256 Bytes, 0x200:512 Bytes
**/
  UINT16                      MemorySpdDataLen;

/** Offset 0x005A - Dq Byte Map CH0
  Dq byte mapping between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqByteMapCh0[12];

/** Offset 0x0066 - Dq Byte Map CH1
  Dq byte mapping between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqByteMapCh1[12];

/** Offset 0x0072 - Dqs Map CPU to DRAM CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh0[8];

/** Offset 0x007A - Dqs Map CPU to DRAM CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh1[8];

/** Offset 0x0082 - RcompResister settings
  Indicates  RcompReister settings: Board-dependent
**/
  UINT16                      RcompResistor[3];

/** Offset 0x0088 - RcompTarget settings
  RcompTarget settings: board-dependent
**/
  UINT16                      RcompTarget[5];

/** Offset 0x0092 - Dqs Pins Interleaved Setting
  Indicates DqPinsInterleaved setting: board-dependent
  $EN_DIS
**/
  UINT8                       DqPinsInterleaved;

/** Offset 0x0093 - VREF_CA
  CA Vref routing: board-dependent
  0:VREF_CA goes to both CH_A and CH_B, 1: VREF_CA to CH_A and VREF_DQ_A to CH_B,
  2:VREF_CA to CH_A and VREF_DQ_B to CH_B
**/
  UINT8                       CaVrefConfig;

/** Offset 0x0094 - Smram Mask
  The SMM Regions AB-SEG and/or H-SEG reserved
  0: Neither, 1:AB-SEG, 2:H-SEG, 3: Both
**/
  UINT8                       SmramMask;

/** Offset 0x0095 - MRC Fast Boot
  Enables/Disable the MRC fast path thru the MRC
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x0096
**/
  UINT8                       UnusedUpdSpace0[2];

/** Offset 0x0098 - Intel Enhanced Debug
  Intel Enhanced Debug (IED): 0=Disabled, 0x400000=Enabled and 4MB SMRAM occupied
  0 : Disable, 0x400000 : Enable
**/
  UINT32                      IedSize;

/** Offset 0x009C - Tseg Size
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
  0x0400000:4MB, 0x01000000:16MB
**/
  UINT32                      TsegSize;

/** Offset 0x00A0 - MMIO Size
  Size of MMIO space reserved for devices. 0(Default)=Auto, non-Zero=size in MB
**/
  UINT16                      MmioSize;

/** Offset 0x00A2 - Probeless Trace
  Probeless Trace: 0=Disabled, 1=Enable. Enabling Probeless Trace will reserve 128MB.
  This also requires IED to be enabled.
  $EN_DIS
**/
  UINT8                       ProbelessTrace;

/** Offset 0x00A3
**/
  UINT8                       UnusedUpdSpace1[2];

/** Offset 0x00A5 - Enable SMBus
  Enable/disable SMBus controller.
  $EN_DIS
**/
  UINT8                       SmbusEnable;

/** Offset 0x00A6 - Enable Trace Hub
  Enable/disable Trace Hub function.
  $EN_DIS
**/
  UINT8                       EnableTraceHub;

/** Offset 0x00A7 - DpSscMarginEnable
  Enable/Disable. 0: Disable, Use default DisplayPort SSC modulation range 0.5% down
  spread, 1: Enable DisplayPort SSC range reduction. Note this should only be used
  on systems that exceeds allowed SSC modulation range as defined in VESA's spec
  $EN_DIS
**/
  UINT8                       DpSscMarginEnable;

/** Offset 0x00A8
**/
  UINT8                       UnusedUpdSpace2[59];

/** Offset 0x00E3 - Internal Graphics Pre-allocated Memory
  Size of memory preallocated for internal graphics.
  0x00:0 MB, 0x01:32 MB, 0x02:64 MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x00E4 - Internal Graphics
  Enable/disable internal graphics.
  $EN_DIS
**/
  UINT8                       InternalGfx;

/** Offset 0x00E5 - Aperture Size
  Select the Aperture Size.
  0:128 MB, 1:256 MB, 2:512 MB
**/
  UINT8                       ApertureSize;

/** Offset 0x00E6 - SA GV
  System Agent dynamic frequency support and when enabled memory will be training
  at two different frequencies. Only effects ULX/ULT CPUs. 0=Disabled, 1=FixedLow,
  2=FixedHigh, and 3=Enabled.
  0:Disabled, 1:FixedLow, 2:FixedHigh, 3:Enabled
**/
  UINT8                       SaGv;

/** Offset 0x00E7 - Rank Margin Tool
  Enable/disable Rank Margin Tool.
  $EN_DIS
**/
  UINT8                       RMT;

/** Offset 0x00E8 - DDR Frequency Limit
  Maximum Memory Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867,
  2133, 2400 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 0:Auto
**/
  UINT16                      DdrFreqLimit;

/** Offset 0x00EA - Board Type
  MrcBoardType, Options are 0=Mobile/Mobile Halo, 1=Desktop/DT Halo, 5=ULT/ULX/Mobile
  Halo, 7=UP Server
  0:Mobile/Mobile Halo, 1:Desktop/DT Halo, 5:ULT/ULX/Mobile Halo, 7:UP Server
**/
  UINT8                       UserBd;

/** Offset 0x00EB
**/
  UINT8                       UnusedUpdSpace3[105];

/** Offset 0x0154 - MMA Test Content Pointer
  Pointer to MMA Test Content in Memory
**/
  UINT32                      MmaTestContentPtr;

/** Offset 0x0158 - MMA Test Content Size
  Size of MMA Test Content in Memory
**/
  UINT32                      MmaTestContentSize;

/** Offset 0x015C - MMA Test Config Pointer
  Pointer to MMA Test Config in Memory
**/
  UINT32                      MmaTestConfigPtr;

/** Offset 0x0160 - MMA Test Config Size
  Size of MMA Test Config in Memory
**/
  UINT32                      MmaTestConfigSize;

/** Offset 0x0164
**/
  UINT8                       UnusedUpdSpace4[19];

/** Offset 0x0177 - SPD Profile Selected
  Select DIMM timing profile. Options are 0=Default profile, 1=Custom profile, 2=XMP
  Profile 1, 3=XMP Profile 2
  0:Default profile, 1:Custom profile, 2:XMP profile 1, 3:XMP profile 2
**/
  UINT8                       SpdProfileSelected;

/** Offset 0x0178 - Memory Voltage
  Memory Voltage Override (Vddq). Default = no override
  0:Default, 1100:1.10 Volts, 1150:1.15 Volts, 1200:1.20 Volts, 1250:1.25 Volts, 1300:1.30
  Volts, 1350:1.35 Volts, 1400:1.40 Volts, 1450:1.45 Volts, 1500:1.50 Volts, 1550:1.55
  Volts, 1600:1.60 Volts, 1650:1.65 Volts
**/
  UINT16                      VddVoltage;

/** Offset 0x017A - Memory Reference Clock
  Automatic, 100MHz, 133MHz.
  0:Auto, 1:133MHz, 2:100MHz
**/
  UINT8                       RefClk;

/** Offset 0x017B - Memory Ratio
  Automatic or the frequency will equal ratio times reference clock. Set to Auto to
  recalculate memory timings listed below.
  0:Auto, 4:4, 5:5, 6:6, 7:7, 8:8, 9:9, 10:10, 11:11, 12:12, 13:13, 14:14, 15:15
**/
  UINT8                       Ratio;

/** Offset 0x017C - QCLK Odd Ratio
  Adds 133 or 100 MHz to QCLK frequency, depending on RefClk
  $EN_DIS
**/
  UINT8                       OddRatioMode;

/** Offset 0x017D - tCL
  CAS Latency, 0: AUTO, max: 31
**/
  UINT8                       tCL;

/** Offset 0x017E - tFAW
  Min Four Activate Window Delay Time, 0: AUTO, max: 63
**/
  UINT16                      tFAW;

/** Offset 0x0180 - tRAS
  RAS Active Time, 0: AUTO, max: 64
**/
  UINT16                      tRAS;

/** Offset 0x0182 - tCWL
  Min CAS Write Latency Delay Time, 0: AUTO, max: 20
**/
  UINT8                       tCWL;

/** Offset 0x0183 - tRCD/tRP
  RAS to CAS delay time and Row Precharge delay time, 0: AUTO, max: 63
**/
  UINT8                       tRCDtRP;

/** Offset 0x0184 - tREFI
  Refresh Interval, 0: AUTO, max: 65535
**/
  UINT16                      tREFI;

/** Offset 0x0186 - tRFC
  Min Refresh Recovery Delay Time, 0: AUTO, max: 1023
**/
  UINT16                      tRFC;

/** Offset 0x0188 - tRRD
  Min Row Active to Row Active Delay Time, 0: AUTO, max: 15
**/
  UINT8                       tRRD;

/** Offset 0x0189 - tRTP
  Min Internal Read to Precharge Command Delay Time, 0: AUTO, max: 15. DDR4 legal
  values: 5, 6, 7, 8, 9, 10, 12
**/
  UINT8                       tRTP;

/** Offset 0x018A - tWR
  Min Write Recovery Time, 0: AUTO, legal values: 5, 6, 7, 8, 10, 12, 14, 16, 18, 20, 24
  0:Auto, 5:5, 6:6, 7:7, 8:8, 10:10, 12:12, 14:14, 16:16, 18:18, 20:20, 24:24
**/
  UINT8                       tWR;

/** Offset 0x018B - tWTR
  Min Internal Write to Read Command Delay Time, 0: AUTO, max: 28
**/
  UINT8                       tWTR;

/** Offset 0x018C - NMode
  System command rate, range 0-2, 0 means auto, 1 = 1N, 2 = 2N
**/
  UINT8                       NModeSupport;

/** Offset 0x018D - DllBwEn[0]
  DllBwEn[0], for 1067 (0..7)
**/
  UINT8                       DllBwEn0;

/** Offset 0x018E - DllBwEn[1]
  DllBwEn[1], for 1333 (0..7)
**/
  UINT8                       DllBwEn1;

/** Offset 0x018F - DllBwEn[2]
  DllBwEn[2], for 1600 (0..7)
**/
  UINT8                       DllBwEn2;

/** Offset 0x0190 - DllBwEn[3]
  DllBwEn[3], for 1867 and up (0..7)
**/
  UINT8                       DllBwEn3;

/** Offset 0x0191 - Command Tristate Support
  Enable/Disable Command Tristate; <b>0: Enable</b>; 1: Disable.
  $EN_DIS
**/
  UINT8                       CmdTriStateDis;

/** Offset 0x0192
**/
  UINT8                       UnusedUpdSpace5[14];

/** Offset 0x01A0 - HECI1 BAR address
  BAR address of HECI1
**/
  UINT32                      Heci1BarAddress;

/** Offset 0x01A4 - HECI2 BAR address
  BAR address of HECI2
**/
  UINT32                      Heci2BarAddress;

/** Offset 0x01A8 - HECI3 BAR address
  BAR address of HECI3
**/
  UINT32                      Heci3BarAddress;

/** Offset 0x01AC - HECI Timeouts
  Enable/Disable. 0: Disable, disable timeout check for HECI, 1: enable
  $EN_DIS
**/
  UINT8                       HeciTimeouts;

/** Offset 0x01AD
**/
  UINT8                       UnusedUpdSpace6[115];

/** Offset 0x0220 - SG dGPU Power Delay
  SG dGPU delay interval after power enabling: 0=Minimal, 1000=Maximum, default is
  300=300 microseconds
**/
  UINT16                      SgDelayAfterPwrEn;

/** Offset 0x0222 - SG dGPU Reset Delay
  SG dGPU delay interval for Reset complete: 0=Minimal, 1000=Maximum, default is 100=100
  microseconds
**/
  UINT16                      SgDelayAfterHoldReset;

/** Offset 0x0224 - MMIO size adjustment for AUTO mode
  Positive number means increasing MMIO size, Negative value means decreasing MMIO
  size: 0 (Default)=no change to AUTO mode MMIO size
**/
  UINT16                      MmioSizeAdjustment;

/** Offset 0x0226 - Enable/Disable DMI GEN3 Static EQ Phase1 programming
  Program DMI Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiGen3ProgramStaticEq;

/** Offset 0x0227 - Enable/Disable PEG 0
  Disabled(0x0): Disable PEG Port, Enabled(0x1): Enable PEG Port (If Silicon SKU permits
  it), Auto(0x2)(Default): If an endpoint is present, enable the PEG Port, Disable otherwise
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       Peg0Enable;

/** Offset 0x0228 - Enable/Disable PEG 1
  Disabled(0x0): Disable PEG Port, Enabled(0x1): Enable PEG Port (If Silicon SKU permits
  it), Auto(0x2)(Default): If an endpoint is present, enable the PEG Port, Disable otherwise
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       Peg1Enable;

/** Offset 0x0229 - Enable/Disable PEG 2
  Disabled(0x0): Disable PEG Port, Enabled(0x1): Enable PEG Port (If Silicon SKU permits
  it), Auto(0x2)(Default): If an endpoint is present, enable the PEG Port, Disable otherwise
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       Peg2Enable;

/** Offset 0x022A - PEG 0 Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       Peg0MaxLinkSpeed;

/** Offset 0x022B - PEG 1 Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       Peg1MaxLinkSpeed;

/** Offset 0x022C - PEG 2 Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       Peg2MaxLinkSpeed;

/** Offset 0x022D - PEG 0 Max Link Width
  Auto (Default)(0x0): Maximum possible link width, (0x1): Limit Link to x1, (0x2):
  Limit Link to x2, (0x3):Limit Link to x4, (0x4): Limit Link to x8
  0:Auto, 1:x1, 2:x2, 3:x4, 4:x8
**/
  UINT8                       Peg0MaxLinkWidth;

/** Offset 0x022E - PEG 1 Max Link Width
  Auto (Default)(0x0): Maximum possible link width, (0x1): Limit Link to x1, (0x2):
  Limit Link to x2, (0x3):Limit Link to x4
  0:Auto, 1:x1, 2:x2, 3:x4
**/
  UINT8                       Peg1MaxLinkWidth;

/** Offset 0x022F - PEG 2 Max Link Width
  Auto (Default)(0x0): Maximum possible link width, (0x1): Limit Link to x1, (0x2):
  Limit Link to x2
  0:Auto, 1:x1, 2:x2
**/
  UINT8                       Peg2MaxLinkWidth;

/** Offset 0x0230 - Power down unused lanes on PEG 0
  (0x0): Do not power down any lane, (0x1): Bios will power down unused lanes based
  on the max possible link width
  0:No power saving, 1:Auto
**/
  UINT8                       Peg0PowerDownUnusedLanes;

/** Offset 0x0231 - Power down unused lanes on PEG 1
  (0x0): Do not power down any lane, (0x1): Bios will power down unused lanes based
  on the max possible link width
  0:No power saving, 1:Auto
**/
  UINT8                       Peg1PowerDownUnusedLanes;

/** Offset 0x0232 - Power down unused lanes on PEG 2
  (0x0): Do not power down any lane, (0x1): Bios will power down unused lanes based
  on the max possible link width
  0:No power saving, 1:Auto
**/
  UINT8                       Peg2PowerDownUnusedLanes;

/** Offset 0x0233 - PCIe ASPM programming will happen in relation to the Oprom
  Select when PCIe ASPM programming will happen in relation to the Oprom. Before(0x0)(Default):
  Do PCIe ASPM programming before Oprom, After(0x1): Do PCIe ASPM programming after
  Oprom, requires an SMI handler to save/restore ASPM settings during S3 resume
  0:Before, 1:After
**/
  UINT8                       InitPcieAspmAfterOprom;

/** Offset 0x0234 - PCIe Disable Spread Spectrum Clocking
  PCIe Disable Spread Spectrum Clocking. Normal Operation(0x0)(Default) - SSC enabled,
  Disable SSC(0X1) - Disable SSC per platform design or for compliance testing
  0:Normal Operation, 1:Disable SSC
**/
  UINT8                       PegDisableSpreadSpectrumClocking;

/** Offset 0x0235 - DMI Gen3 Root port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 4 is default for each lane
**/
  UINT8                       DmiGen3RootPortPreset[4];

/** Offset 0x0239 - DMI Gen3 End port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       DmiGen3EndPointPreset[4];

/** Offset 0x023D - DMI Gen3 End port Hint values per lane
  Used for programming DMI Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       DmiGen3EndPointHint[4];

/** Offset 0x0241 - DMI Gen3 RxCTLEp per-Bundle control
  Range: 0-15, 3 is default for each bundle, must be specified based upon platform design
**/
  UINT8                       DmiGen3RxCtlePeaking[2];

/** Offset 0x0243 - DeEmphasis control for DMI
  DeEmphasis control for DMI. 0=-6dB, 1(Default)=-3.5 dB
  0: -6dB, 1: -3.5dB
**/
  UINT8                       DmiDeEmphasis;

/** Offset 0x0244 - PEG Gen3 RxCTLEp per-Bundle control
  Range: 0-15, 12 is default for each bundle, must be specified based upon platform design
**/
  UINT8                       PegGen3RxCtlePeaking[8];

/** Offset 0x024C - Memory data pointer for saved preset search results
  The reference code will store the Gen3 Preset Search results in the SaDataHob's
  PegData structure (SA_PEG_DATA) and platform code can save/restore this data to
  skip preset search in the following boots. Range: 0-0xFFFFFFFF, default is 0
**/
  UINT32                      PegDataPtr;

/** Offset 0x0250 - PEG PERST# GPIO information
  The reference code will use the information in this structure in order to reset
  PCIe Gen3 devices during equalization, if necessary
**/
  UINT8                       PegGpioData[16];

/** Offset 0x0260
**/
  UINT8                       UnusedUpdSpace7[1];

/** Offset 0x0261 - PCIe Hot Plug Enable/Disable per port
  0(Default): Disable, 1: Enable
**/
  UINT8                       PegRootPortHPE[3];

/** Offset 0x0264 - Temporary MMIO address for GTTMMADR
  The reference code will use the information in this structure in order to reset
  PCIe Gen3 devices during equalization, if necessary
**/
  UINT32                      GttMmAdr;

/** Offset 0x0268 - Selection of iGFX GTT Memory size
  1=2MB, 2=4MB, 3=8MB, Default is 3
  1:2MB, 2:4MB, 3:8MB
**/
  UINT16                      GttSize;

/** Offset 0x026A - Selection of the primary display device
  0=iGFX, 1=PEG, 2=PCIe Graphics on PCH, 3(Default)=AUTO, 4=Switchable Graphics
  0:iGFX, 1:PEG, 2:PCIe Graphics on PCH, 3:AUTO, 4:Switchable Graphics
**/
  UINT8                       PrimaryDisplay;

/** Offset 0x026B - Switchable Graphics GPIO information for PEG 0
  Switchable Graphics GPIO information for PEG 0, for Reset, power and wake GPIOs
**/
  UINT8                       SaRtd3Pcie0Gpio[24];

/** Offset 0x0283 - Switchable Graphics GPIO information for PEG 1
  Switchable Graphics GPIO information for PEG 1, for Reset, power and wake GPIOs
**/
  UINT8                       SaRtd3Pcie1Gpio[24];

/** Offset 0x029B - Switchable Graphics GPIO information for PEG 2
  Switchable Graphics GPIO information for PEG 2, for Reset, power and wake GPIOs
**/
  UINT8                       SaRtd3Pcie2Gpio[24];

/** Offset 0x02B3 - PEG root port Device number for Switchable Graphics dGPU
  Device number to indicate which PEG root port has dGPU
**/
  UINT8                       RootPortDev;

/** Offset 0x02B4 - PEG root port Function number for Switchable Graphics dGPU
  Function number to indicate which PEG root port has dGPU
**/
  UINT8                       RootPortFun;

/** Offset 0x02B5 - Enable/Disable MRC TXT dependency
  When enabled MRC execution will wait for TXT initialization to be done first. Disabled(0x0)(Default):
  MRC will not wait for TXT initialization, Enabled(0x1): MRC will wait for TXT initialization
  $EN_DIS
**/
  UINT8                       TxtImplemented;

/** Offset 0x02B6 - Enable/Disable SA OcSupport
  Enable: Enable SA OcSupport, Disable(Default): Disable SA OcSupport
  $EN_DIS
**/
  UINT8                       SaOcSupport;

/** Offset 0x02B7 - GT slice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtsVoltageMode;

/** Offset 0x02B8 - GT unslice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtusVoltageMode;

/** Offset 0x02B9 - Maximum GTs turbo ratio override
  0(Default)=Minimal/Auto, 60=Maximum
**/
  UINT8                       GtsMaxOcRatio;

/** Offset 0x02BA - The voltage offset applied to GT slice
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      GtsVoltageOffset;

/** Offset 0x02BC - The GT slice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtsVoltageOverride;

/** Offset 0x02BE - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtsExtraTurboVoltage;

/** Offset 0x02C0 - voltage offset applied to GT unslice
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtusVoltageOffset;

/** Offset 0x02C2 - GT unslice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtusVoltageOverride;

/** Offset 0x02C4 - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtusExtraTurboVoltage;

/** Offset 0x02C6 - voltage offset applied to the SA
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      SaVoltageOffset;

/** Offset 0x02C8 - EDRAM ratio override
  EdramRatio is deprecated on Kabylake
**/
  UINT8                       EdramRatio;

/** Offset 0x02C9 - Maximum GTus turbo ratio override
  0(Default)=Minimal, 60=Maximum
**/
  UINT8                       GtusMaxOcRatio;

/** Offset 0x02CA - BIST on Reset
  Enable or Disable BIST on Reset; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       BistOnReset;

/** Offset 0x02CB - Skip Stop PBET Timer Enable/Disable
  Skip Stop PBET Timer; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       SkipStopPbet;

/** Offset 0x02CC - C6DRAM power gating feature
  This feature is not supported. BIOS is required to disable. <b>0: Disable</b>
  $EN_DIS
**/
  UINT8                       EnableC6Dram;

/** Offset 0x02CD - Over clocking support
  Over clocking support; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       OcSupport;

/** Offset 0x02CE - Over clocking Lock
  Over clocking Lock Enable/Disable; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       OcLock;

/** Offset 0x02CF - Maximum Core Turbo Ratio Override
  Maximum core turbo ratio override allows to increase CPU core frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b> Range: 0-255
**/
  UINT8                       CoreMaxOcRatio;

/** Offset 0x02D0 - Core voltage mode
  Core voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       CoreVoltageMode;

/** Offset 0x02D1 - Minimum clr turbo ratio override
  Minimum clr turbo ratio override. <b>0: Hardware defaults.</b> Range: 0-255
**/
  UINT8                       RingMinOcRatio;

/** Offset 0x02D2 - Maximum clr turbo ratio override
  Maximum clr turbo ratio override allows to increase CPU clr frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-255
**/
  UINT8                       RingMaxOcRatio;

/** Offset 0x02D3 - Hyper Threading Enable/Disable
  Enable or Disable Hyper Threading; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       HyperThreading;

/** Offset 0x02D4 - Enable or Disable CPU Ratio Override
  Enable or Disable CPU Ratio Override; <b>0: Disable</b>; 1: Enable. @note If disabled,
  BIOS will use the default max non-turbo ratio, and will not use any flex ratio setting.
  $EN_DIS
**/
  UINT8                       CpuRatioOverride;

/** Offset 0x02D5 - CPU ratio value
  CPU ratio value. Valid Range 0 to 63
**/
  UINT8                       CpuRatio;

/** Offset 0x02D6 - Boot frequency
  Sets the boot frequency starting from reset vector.- 0: Maximum battery performance.-
  <b>1: Maximum non-turbo performance</b>.- 2: Turbo performance. @note If Turbo
  is selected BIOS will start in max non-turbo mode and switch to Turbo mode.
  0:0, 1:1, 2:2
**/
  UINT8                       BootFrequency;

/** Offset 0x02D7 - Number of active cores
  Number of active cores(Depends on Number of cores). <b>0: All</b>;<b>1: 1 </b>;<b>2:
  2 </b>;<b>3: 3 </b>
  0:All, 1:1, 2:2, 3:3
**/
  UINT8                       ActiveCoreCount;

/** Offset 0x02D8 - Processor Early Power On Configuration FCLK setting
  <b>0: 800 MHz (ULT/ULX)</b>. <b>1: 1 GHz (DT/Halo)</b>. Not supported on ULT/ULX.-
  2: 400 MHz. - 3: Reserved
  0:800 MHz, 1: 1 GHz, 2: 400 MHz, 3: Reserved
**/
  UINT8                       FClkFrequency;

/** Offset 0x02D9 - Power JTAG in C10 and deeper power states
  Power JTAG in C10 and deeper power states; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       JtagC10PowerGateDisable;

/** Offset 0x02DA - Enable or Disable VMX
  Enable or Disable VMX; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       VmxEnable;

/** Offset 0x02DB - AVX2 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx2RatioOffset;

/** Offset 0x02DC - core voltage override
  The core voltage override which is applied to the entire range of cpu core frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageOverride;

/** Offset 0x02DE - Core Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu core when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageAdaptive;

/** Offset 0x02E0 - Core Turbo voltage Offset
  The voltage offset applied to the core while operating in turbo mode.Valid Range 0 to 1000
**/
  UINT16                      CoreVoltageOffset;

/** Offset 0x02E2 - Core PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       CorePllVoltageOffset;

/** Offset 0x02E3 - Ring Downbin
  Ring Downbin enable/disable. When enabled, CPU will ensure the ring ratio is always
  lower than the core ratio. 0: Disable; <b>1: Enable.</b>
  $EN_DIS
**/
  UINT8                       RingDownBin;

/** Offset 0x02E4 - BCLK Adaptive Voltage Enable
  When enabled, the CPU V/F curves are aware of BCLK frequency when calculated. </b>0:
  Disable;<b> 1: Enable
  $EN_DIS
**/
  UINT8                       BclkAdaptiveVoltage;

/** Offset 0x02E5 - BiosGuard
  Enable/Disable. 0: Disable, Enable/Disable BIOS Guard feature, 1: enable
  $EN_DIS
**/
  UINT8                       BiosGuard;

/** Offset 0x02E6 - EnableSgx
  Enable/Disable. 0: Disable, Enable/Disable SGX feature, 1: enable
  $EN_DIS
**/
  UINT8                       EnableSgx;

/** Offset 0x02E7 - Txt
  Enable/Disable. 0: Disable, Enable/Disable Txt feature, 1: enable
  $EN_DIS
**/
  UINT8                       Txt;

/** Offset 0x02E8 - PrmrrSize
  Enable/Disable. 0: Disable, define default value of PrmrrSize , 1: enable
**/
  UINT32                      PrmrrSize;

/** Offset 0x02EC - SinitMemorySize
  Enable/Disable. 0: Disable, define default value of SinitMemorySize , 1: enable
**/
  UINT32                      SinitMemorySize;

/** Offset 0x02F0 - TxtDprMemoryBase
  Enable/Disable. 0: Disable, define default value of TxtDprMemoryBase , 1: enable
**/
  UINT64                      TxtDprMemoryBase;

/** Offset 0x02F8 - TxtDprMemorySize
  Enable/Disable. 0: Disable, define default value of TxtDprMemorySize , 1: enable
**/
  UINT32                      TxtDprMemorySize;

/** Offset 0x02FC - TxtHeapMemorySize
  Enable/Disable. 0: Disable, define default value of TxtHeapMemorySize , 1: enable
**/
  UINT32                      TxtHeapMemorySize;

/** Offset 0x0300 - FlashWearOutProtection
  Enable/Disable. 0: Disable, Enable/Disable FlashWearOutProtection feature, 1: enable
  $EN_DIS
**/
  UINT8                       FlashWearOutProtection;

/** Offset 0x0301 - Thermal Velocity Boost Ratio clipping
  0(Default): Disabled, 1: Enabled. This service controls Core frequency reduction
  caused by high package temperatures for processors that implement the Intel Thermal
  Velocity Boost (TVB) feature
  0: Disabled, 1: Enabled
**/
  UINT8                       TvbRatioClipping;

/** Offset 0x0302 - Thermal Velocity Boost voltage optimization
  0: Disabled, 1: Enabled(Default). This service controls thermal based voltage optimizations
  for processors that implement the Intel Thermal Velocity Boost (TVB) feature.
  0: Disabled, 1: Enabled
**/
  UINT8                       TvbVoltageOptimization;

/** Offset 0x0303 - ReservedSecurityPreMem
  Reserved for Security Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedSecurityPreMem[7];

/** Offset 0x030A - PCH HPET Enabled
  Enable/disable PCH HPET.
  $EN_DIS
**/
  UINT8                       PchHpetEnable;

/** Offset 0x030B - PCH HPET BDF valid
  Whether the BDF value is valid. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchHpetBdfValid;

/** Offset 0x030C - The HPET Base Address
  The HPET base address. Default is 0xFED00000.
**/
  UINT32                      PchHpetBase;

/** Offset 0x0310 - PCH HPET Bus Number
  Bus Number HPETn used as Requestor / Completer ID. Default is 0xF0.
**/
  UINT8                       PchHpetBusNumber;

/** Offset 0x0311 - PCH HPET Device Number
  Device Number HPETn used as Requestor / Completer ID. Default is 0x1F.
**/
  UINT8                       PchHpetDeviceNumber;

/** Offset 0x0312 - PCH HPET Function Number
  Function Number HPETn used as Requestor / Completer ID. Default is 0x00.
**/
  UINT8                       PchHpetFunctionNumber;

/** Offset 0x0313 - Enable PCH HSIO PCIE Rx Set Ctle
  Enable PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtleEnable[24];

/** Offset 0x032B - PCH HSIO PCIE Rx Set Ctle Value
  PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtle[24];

/** Offset 0x0343 - Enble PCH HSIO PCIE TX Gen 1 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmpEnable[24];

/** Offset 0x035B - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmp[24];

/** Offset 0x0373 - Enable PCH HSIO PCIE TX Gen 2 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmpEnable[24];

/** Offset 0x038B - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmp[24];

/** Offset 0x03A3 - Enable PCH HSIO PCIE TX Gen 3 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmpEnable[24];

/** Offset 0x03BB - PCH HSIO PCIE Gen 3 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 3 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmp[24];

/** Offset 0x03D3 - Enable PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DeEmphEnable[24];

/** Offset 0x03EB - PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment value
  PCH PCIe Gen 1 TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen1DeEmph[24];

/** Offset 0x0403 - Enable PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5Enable[24];

/** Offset 0x041B - PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5[24];

/** Offset 0x0433 - Enable PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0Enable[24];

/** Offset 0x044B - PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0[24];

/** Offset 0x0463 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMagEnable[8];

/** Offset 0x046B - PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMag[8];

/** Offset 0x0473 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMagEnable[8];

/** Offset 0x047B - PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMag[8];

/** Offset 0x0483 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMagEnable[8];

/** Offset 0x048B - PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMag[8];

/** Offset 0x0493 - Enable PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmpEnable[8];

/** Offset 0x049B - PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmp[8];

/** Offset 0x04A3 - Enable PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmpEnable[8];

/** Offset 0x04AB - PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmp[8];

/** Offset 0x04B3 - Enable PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmpEnable[8];

/** Offset 0x04BB - PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmp[8];

/** Offset 0x04C3 - Enable PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DeEmphEnable[8];

/** Offset 0x04CB - PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen1DeEmph[8];

/** Offset 0x04D3 - Enable PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DeEmphEnable[8];

/** Offset 0x04DB - PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen2DeEmph[8];

/** Offset 0x04E3 - Enable PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DeEmphEnable[8];

/** Offset 0x04EB - PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen3DeEmph[8];

/** Offset 0x04F3 - PCH LPC Enhance the port 8xh decoding
  Original LPC only decodes one byte of port 80h.
  $EN_DIS
**/
  UINT8                       PchLpcEnhancePort8xhDecoding;

/** Offset 0x04F4 - PCH Acpi Base
  Power management I/O base address. Default is 0x1800.
**/
  UINT16                      PchAcpiBase;

/** Offset 0x04F6 - PCH Port80 Route
  Control where the Port 80h cycles are sent, 0: LPC; 1: PCI.
  $EN_DIS
**/
  UINT8                       PchPort80Route;

/** Offset 0x04F7 - Enable SMBus ARP support
  Enable SMBus ARP support.
  $EN_DIS
**/
  UINT8                       SmbusArpEnable;

/** Offset 0x04F8 - SMBUS Base Address
  SMBUS Base Address (IO space).
**/
  UINT16                      PchSmbusIoBase;

/** Offset 0x04FA - Number of RsvdSmbusAddressTable.
  The number of elements in the RsvdSmbusAddressTable.
**/
  UINT8                       PchNumRsvdSmbusAddresses;

/** Offset 0x04FB
**/
  UINT8                       UnusedUpdSpace8;

/** Offset 0x04FC - Point of RsvdSmbusAddressTable
  Array of addresses reserved for non-ARP-capable SMBus devices.
**/
  UINT32                      RsvdSmbusAddressTablePtr;

/** Offset 0x0500 - Trace Hub Memory Region 0
  Trace Hub Memory Region 0.
**/
  UINT32                      TraceHubMemReg0Size;

/** Offset 0x0504 - Trace Hub Memory Region 1
  Trace Hub Memory Region 1.
**/
  UINT32                      TraceHubMemReg1Size;

/** Offset 0x0508 - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpEnableMask;

/** Offset 0x050C - Debug Interfaces
  Debug Interfaces. BIT0-RAM, BIT1-UART, BIT3-USB3, BIT4-Serial IO, BIT5-TraceHub,
  BIT2 - Not used.
**/
  UINT8                       PcdDebugInterfaceFlags;

/** Offset 0x050D - SerialIo Uart Number Selection
  Select SerialIo Uart Controller for debug.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       PcdSerialIoUartNumber;

/** Offset 0x050E - ISA Serial Base selection
  Select ISA Serial Base address. Default is 0x3F8.
  0:0x3F8, 1:0x2F8
**/
  UINT8                       PcdIsaSerialUartBase;

/** Offset 0x050F - PCH Pm Pcie Pll Ssc
  Specifies the Pcie Pll Spread Spectrum Percentage. The default is 0xFF: AUTO - No
  BIOS override.
**/
  UINT8                       PchPmPciePllSsc;

/** Offset 0x0510 - Enable or Disable Peci C10 Reset command
  Enable or Disable Peci C10 Reset command; 0: Disable; <b>1: Enable.</b>
  $EN_DIS
**/
  UINT8                       PeciC10Reset;

/** Offset 0x0511 - Enable or Disable Peci Sx Reset command
  Enable or Disable Peci Sx Reset command; <b>0: Disable;</b> 1: Enable.
  $EN_DIS
**/
  UINT8                       PeciSxReset;

/** Offset 0x0512 - PcdSerialDebugBaudRate
  Baud Rate for Serial Debug Messages. 3:9600, 4:19200, 6:56700, 7:115200.
  3:9600, 4:19200, 6:56700, 7:115200
**/
  UINT8                       PcdSerialDebugBaudRate;

/** Offset 0x0513 - PcdSerialDebugLevel
  Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       PcdSerialDebugLevel;

/** Offset 0x0514 - Enable or Disable EV Loader
  Enable or Disable EV Loader; <b>0: Disable;</b> 1: Enable.
  $EN_DIS
**/
  UINT8                       EvLoader;

/** Offset 0x0515 - GT PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
  0x0:0xFF
**/
  UINT8                       GtPllVoltageOffset;

/** Offset 0x0516 - Ring PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
  0x0:0xFF
**/
  UINT8                       RingPllVoltageOffset;

/** Offset 0x0517 - System Agent PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
  0x0:0xFF
**/
  UINT8                       SaPllVoltageOffset;

/** Offset 0x0518 - Memory Controller PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
  0x0:0xFF
**/
  UINT8                       McPllVoltageOffset;

/** Offset 0x0519 - Realtime Memory Timing
  0(Default): Disabled, 1: Enabled. When enabled, it will allow the system to perform
  realtime memory timing changes after MRC_DONE.
  0: Disabled, 1: Enabled
**/
  UINT8                       RealtimeMemoryTiming;

/** Offset 0x051A - AVX3 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx3RatioOffset;

/** Offset 0x051B - Ask MRC to clear memory content
  Ask MRC to clear memory content <b>0: Do not Clear Memory;</b> 1: Clear Memory.
  $EN_DIS
**/
  UINT8                       CleanMemory;

/** Offset 0x051C - TjMax Offset
  TjMax offset. Specified value here is clipped by pCode (125 - TjMax Offset) to support
  TjMax in the range of 62 to 115 deg Celsius. Valid Range 0 - 63
**/
  UINT8                       TjMaxOffset;

/** Offset 0x051D
**/
  UINT8                       ReservedFspmUpd[3];
} FSP_M_CONFIG;

/** Fsp M Test Configuration
**/
typedef struct {

/** Offset 0x0520
**/
  UINT32                      Signature;

/** Offset 0x0524 - Skip external display device scanning
  Enable: Do not scan for external display device, Disable (Default): Scan external
  display devices
  $EN_DIS
**/
  UINT8                       SkipExtGfxScan;

/** Offset 0x0525 - Generate BIOS Data ACPI Table
  Enable: Generate BDAT for MRC RMT or SA PCIe data. Disable (Default): Do not generate it
  $EN_DIS
**/
  UINT8                       BdatEnable;

/** Offset 0x0526 - Detect External Graphics device for LegacyOpROM
  Detect and report if external graphics device only support LegacyOpROM or not (to
  support CSM auto-enable). Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       ScanExtGfxForLegacyOpRom;

/** Offset 0x0527 - Lock PCU Thermal Management registers
  Lock PCU Thermal Management registers. Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       LockPTMregs;

/** Offset 0x0528 - Enable/Disable DmiVc1
  Enable/Disable DmiVc1. Enable = 1, Disable (Default) = 0
  $EN_DIS
**/
  UINT8                       DmiVc1;

/** Offset 0x0529 - Enable/Disable DmiVcm
  Enable/Disable DmiVcm. Enable (Default) = 1, Disable = 0
  $EN_DIS
**/
  UINT8                       DmiVcm;

/** Offset 0x052A - DMI Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       DmiMaxLinkSpeed;

/** Offset 0x052B - DMI Equalization Phase 2
  DMI Equalization Phase 2. (0x0): Disable phase 2, (0x1): Enable phase 2, (0x2)(Default):
  AUTO - Use the current default method
  0:Disable phase2, 1:Enable phase2, 2:Auto
**/
  UINT8                       DmiGen3EqPh2Enable;

/** Offset 0x052C - DMI Gen3 Equalization Phase3
  DMI Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       DmiGen3EqPh3Method;

/** Offset 0x052D - Phase2 EQ enable on the PEG 0:1:0.
  Phase2 EQ enable on the PEG 0:1:0. Disabled(0x0): Disable phase 2, Enabled(0x1):
  Enable phase 2, Auto(0x2)(Default): Use the current default method
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Peg0Gen3EqPh2Enable;

/** Offset 0x052E - Phase2 EQ enable on the PEG 0:1:1.
  Phase2 EQ enable on the PEG 0:1:0. Disabled(0x0): Disable phase 2, Enabled(0x1):
  Enable phase 2, Auto(0x2)(Default): Use the current default method
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Peg1Gen3EqPh2Enable;

/** Offset 0x052F - Phase2 EQ enable on the PEG 0:1:2.
  Phase2 EQ enable on the PEG 0:1:0. Disabled(0x0): Disable phase 2, Enabled(0x1):
  Enable phase 2, Auto(0x2)(Default): Use the current default method
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Peg2Gen3EqPh2Enable;

/** Offset 0x0530 - Phase3 EQ method on the PEG 0:1:0.
  PEG Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       Peg0Gen3EqPh3Method;

/** Offset 0x0531 - Phase3 EQ method on the PEG 0:1:1.
  PEG Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       Peg1Gen3EqPh3Method;

/** Offset 0x0532 - Phase3 EQ method on the PEG 0:1:2.
  PEG Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       Peg2Gen3EqPh3Method;

/** Offset 0x0533 - Enable/Disable PEG GEN3 Static EQ Phase1 programming
  Program PEG Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       PegGen3ProgramStaticEq;

/** Offset 0x0534 - PEG Gen3 SwEq Always Attempt
  Gen3 Software Equalization will be executed every boot. Disabled(0x0)(Default):
  Reuse EQ settings saved/restored from NVRAM whenever possible, Enabled(0x1): Re-test
  and generate new EQ values every boot, not recommended
  0:Disable, 1:Enable
**/
  UINT8                       Gen3SwEqAlwaysAttempt;

/** Offset 0x0535 - Select number of TxEq presets to test in the PCIe/DMI SwEq
  Select number of TxEq presets to test in the PCIe/DMI SwEq. P7,P3,P5(0x0): Test
  Presets 7, 3, and 5, P0-P9(0x1): Test Presets 0-9, Auto(0x2)(Default): Use the
  current default method (Default)Auto will test Presets 7, 3, and 5.  It is possible
  for this default to change over time;using Auto will ensure Reference Code always
  uses the latest default settings
  0:P7 P3 P5, 1:P0 to P9, 2:Auto
**/
  UINT8                       Gen3SwEqNumberOfPresets;

/** Offset 0x0536 - Enable use of the Voltage Offset and Centering Test in the PCIe SwEq
  Enable use of the Voltage Offset and Centering Test in the PCIe Software Equalization
  Algorithm. Disabled(0x0): Disable VOC Test, Enabled(0x1): Enable VOC Test, Auto(0x2)(Default):
  Use the current default
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Gen3SwEqEnableVocTest;

/** Offset 0x0537 - PPCIe Rx Compliance Testing Mode
  Disabled(0x0)(Default): Normal Operation - Disable PCIe Rx Compliance testing, Enabled(0x1):
  PCIe Rx Compliance Test Mode - PEG controller is in Rx Compliance Testing Mode;
  it should only be set when doing PCIe compliance testing
  $EN_DIS
**/
  UINT8                       PegRxCemTestingMode;

/** Offset 0x0538 - PCIe Rx Compliance Loopback Lane  When PegRxCemTestingMode is Enabled
  the specificied Lane (0 - 15) will be  used for RxCEMLoopback.  Default is Lane 0
**/
  UINT8                       PegRxCemLoopbackLane;

/** Offset 0x0539 - Generate PCIe BDAT Margin Table
  Set this policy to enable the generation and addition of PCIe margin data to the
  BDAT table. Disabled(0x0)(Default): Normal Operation - Disable PCIe BDAT margin
  data generation, Enable(0x1): Generate PCIe BDAT margin data
  $EN_DIS
**/
  UINT8                       PegGenerateBdatMarginTable;

/** Offset 0x053A
**/
  UINT8                       UnusedUpdSpace9[6];

/** Offset 0x0540 - PCIe Non-Protocol Awareness for Rx Compliance Testing
  Set this policy to enable the generation and addition of PCIe margin data to the
  BDAT table. Disabled(0x0)(Default): Normal Operation - Disable non-protocol awareness,
  Enable(0x1): Non-Protocol Awareness Enabled - Enable non-protocol awareness for
  compliance testing
  $EN_DIS
**/
  UINT8                       PegRxCemNonProtocolAwareness;

/** Offset 0x0541 - PCIe Override RxCTLE
  Disable(0x0)(Default): Normal Operation - RxCTLE adaptive behavior enabled, Enable(0x1):
  Override RxCTLE - Disable RxCTLE adaptive behavior to keep the configured RxCTLE
  peak values unmodified
  $EN_DIS
**/
  UINT8                       PegGen3RxCtleOverride;

/** Offset 0x0542 - Rsvd
  Disable(0x0)(Default): Normal Operation - RxCTLE adaptive behavior enabled, Enable(0x1):
  Override RxCTLE - Disable RxCTLE adaptive behavior to keep the configured RxCTLE
  peak values unmodified
  $EN_DIS
**/
  UINT8                       PegGen3Rsvd;

/** Offset 0x0543 - Panel Power Enable
  Control for enabling/disabling VDD force bit (Required only for early enabling of
  eDP panel). 0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       PanelPowerEnable;

/** Offset 0x0544 - PEG Gen3 Root port preset values per lane
  Used for programming PEG Gen3 preset values per lane. Range: 0-9, 8 is default for each lane
**/
  UINT8                       PegGen3RootPortPreset[16];

/** Offset 0x0554 - PEG Gen3 End port preset values per lane
  Used for programming PEG Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       PegGen3EndPointPreset[16];

/** Offset 0x0564 - PEG Gen3 End port Hint values per lane
  Used for programming PEG Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       PegGen3EndPointHint[16];

/** Offset 0x0574 - Jitter Dwell Time for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 1000. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqJitterDwellTime;

/** Offset 0x0576 - Jitter Error Target for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 1. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqJitterErrorTarget;

/** Offset 0x0578 - VOC Dwell Time for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 10000. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqVocDwellTime;

/** Offset 0x057A - VOC Error Target for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 2. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqVocErrorTarget;

/** Offset 0x057C - SaPreMemTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SaPreMemTestRsvd[4];

/** Offset 0x0580 - BiosAcmBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT64                      BiosAcmBase;

/** Offset 0x0588 - BiosAcmSize
  Enable/Disable. 0: Disable, define default value of BiosAcmSize , 1: enable
**/
  UINT32                      BiosAcmSize;

/** Offset 0x058C - TgaSize
  Enable/Disable. 0: Disable, define default value of TgaSize , 1: enable
**/
  UINT32                      TgaSize;

/** Offset 0x0590 - TxtLcpPdBase
  Enable/Disable. 0: Disable, define default value of TxtLcpPdBase , 1: enable
**/
  UINT64                      TxtLcpPdBase;

/** Offset 0x0598 - TxtLcpPdSize
  Enable/Disable. 0: Disable, define default value of TxtLcpPdSize , 1: enable
**/
  UINT64                      TxtLcpPdSize;

/** Offset 0x05A0 - TotalFlashSize
  Enable/Disable. 0: Disable, define default value of TotalFlashSize , 1: enable
**/
  UINT16                      TotalFlashSize;

/** Offset 0x05A2 - BiosSize
  Enable/Disable. 0: Disable, define default value of BiosSize , 1: enable
**/
  UINT16                      BiosSize;

/** Offset 0x05A4 - PCH Dci Enable
  Enable/disable PCH Dci.
  $EN_DIS
**/
  UINT8                       PchDciEn;

/** Offset 0x05A5 - PCH Dci Auto Detect
  Deprecated
  $EN_DIS
**/
  UINT8                       PchDciAutoDetect;

/** Offset 0x05A6 - Smbus dynamic power gating
  Disable or Enable Smbus dynamic power gating.
  $EN_DIS
**/
  UINT8                       SmbusDynamicPowerGating;

/** Offset 0x05A7 - Disable and Lock Watch Dog Register
  Set 1 to clear WDT status, then disable and lock WDT registers.
  $EN_DIS
**/
  UINT8                       WdtDisableAndLock;

/** Offset 0x05A8 - SMBUS SPD Write Disable
  Set/Clear Smbus SPD Write Disable. 0: leave SPD Write Disable bit; 1: set SPD Write
  Disable bit. For security recommendations, SPD write disable bit must be set.
  $EN_DIS
**/
  UINT8                       SmbusSpdWriteDisable;

/** Offset 0x05A9 - ChipsetInit HECI message
  Enable/Disable. 0: Disable, 1: enable, Enable or disable ChipsetInit HECI message.
  If disabled, it prevents from sending ChipsetInit HECI message.
  $EN_DIS
**/
  UINT8                       ChipsetInitMessage;

/** Offset 0x05AA - Bypass ChipsetInit sync reset.
  0: disable, 1: enable, Set Enable to bypass the reset after ChipsetInit HECI message.
  $EN_DIS
**/
  UINT8                       BypassPhySyncReset;

/** Offset 0x05AB - Force ME DID Init Status
  Test, 0: disable, 1: Success, 2: No Memory in Channels, 3: Memory Init Error, 4:
  Memory not preserved across reset, Set ME DID init stat value
  $EN_DIS
**/
  UINT8                       DidInitStat;

/** Offset 0x05AC - CPU Replaced Polling Disable
  Test, 0: disable, 1: enable, Setting this option disables CPU replacement polling loop
  $EN_DIS
**/
  UINT8                       DisableCpuReplacedPolling;

/** Offset 0x05AD - ME DID Message
  Test, 0: disable, 1: enable, Enable/Disable ME DID Message (disable will prevent
  the DID message from being sent)
  $EN_DIS
**/
  UINT8                       SendDidMsg;

/** Offset 0x05AE - Retry mechanism for HECI APIs
  Test, 0: disable, 1: enable, Enable/Disable HECI retry.
  $EN_DIS
**/
  UINT8                       DisableHeciRetry;

/** Offset 0x05AF - Check HECI message before send
  Test, 0: disable, 1: enable, Enable/Disable message check.
  $EN_DIS
**/
  UINT8                       DisableMessageCheck;

/** Offset 0x05B0 - Skip MBP HOB
  Test, 0: disable, 1: enable, Enable/Disable MOB HOB.
  $EN_DIS
**/
  UINT8                       SkipMbpHob;

/** Offset 0x05B1 - HECI2 Interface Communication
  Test, 0: disable, 1: enable, Adds or Removes HECI2 Device from PCI space.
  $EN_DIS
**/
  UINT8                       HeciCommunication2;

/** Offset 0x05B2 - Enable KT device
  Test, 0: disable, 1: enable, Enable or Disable KT device.
  $EN_DIS
**/
  UINT8                       KtDeviceEnable;

/** Offset 0x05B3 - Enable IDEr
  Test, 0: disable, 1: enable, Enable or Disable IDEr.
  $EN_DIS
**/
  UINT8                       IderDeviceEnable;

/** Offset 0x05B4
**/
  UINT8                       ReservedFspmTestUpd[12];
} FSP_M_TEST_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x0520
**/
  FSP_M_TEST_CONFIG           FspmTestConfig;

/** Offset 0x05C0
**/
  UINT8                       UnusedUpdSpace10[134];

/** Offset 0x0646
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
