% Libreboot 20241206, 8th revision released! ThinkPad T480 backlight keys fixed, Pico 2 serprog support, other fixes
% Leah Rowe
% 6 January 2025

Today's Libreboot 20241206 revision, which is the 8th revision in the Libreboot
20241206 stable release series. The changelog on this page is written, relative
to Libreboot 20241206 revision 7 which was released on 18 December 2024.
The *original* Libreboot 20241206 release came out on 6 December 2024.

Open source BIOS/UEFI firmware
------------------------------

<img tabindex=1 class="r" src="https://av.libreboot.org/t480/t480.jpg" /><span class="f"><img src="https://av.libreboot.org/t480/t480.jpg" /></span>

Libreboot is a free/open source BIOS/UEFI replacement on x86 and ARM, providing
boot firmware that initialises the hardware in your computer, to then load an
operating system (e.g. Linux/BSD). It is specifically
a *[coreboot distribution](../docs/maintain/)*,
in the same way that Debian is a Linux distribution. It provides an automated
build system to produce coreboot ROM images with a variety of payloads such as
GRUB or SeaBIOS, with regular well-tested releases to make coreboot as easy
to use as possible for non-technical users. From a project management perspective,
this works in *exactly* the same way as a Linux distro, providing a source-based
package manager (called lbmk) which patches sources and compiles coreboot images.
It makes use of [coreboot](https://www.coreboot.org/) for hardware initialisation,
and then a payload such as [SeaBIOS](https://www.seabios.org/SeaBIOS)
or [GRUB](https://www.gnu.org/software/grub/) to boot your operating
system; on ARM(chromebooks), we provide *U-Boot* (as a coreboot payload).

We also provide an experimental U-Boot setup on x86, as a coreboot payload for
providing a minimal UEFI implementation.

### Regarding revision 8

Normally, revisions would only be documented on
the [Libreboot 20241206 revisions page](libreboot20241206.Revisions.md), but
there are over *100* changes since the 7th revision, making the 8th revision
almost a full new release, so it was decided that this revision would have its
own dedicated release page.

Many of these changes are early changes of *Libreboot Build System Audit 7*,
because an ongoing audit (the 7th audit) is in progress. The previous build
system audit was [Libreboot Build System Audit 6](audit6.md); these early
changes are the least invasive ones planned, so they are suitable for a stable
release. Much of the build system will have been re-designed, upon completion
of the 7th audit.

You will find the tar archives (including sources and ROM images) for this
release, in the *same* directory under `stable/20241206/` on release mirrors.
The old archives (from rev6) were replaced entirely; rev7 was never released.

### Regarding revision 7

The only meaningful addition in *revision 7* was the feature whereby T480/T480s
ThunderBolt firmware can be separately downloaded, for external flashing instead
of using Lenovo's Windows-only updater program, for those users who wish/need to
update their ThunderBolt controller firmware.

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../docs/install/ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](../docs/install/ivy_has_common.md).**

Summarised list of changes
------------------------

### Board support

RP2530 devices now supported in `pico-serprog`, e.g. Raspberry Pi Pico 2.

We previously only supported the RP2040 devices, e.g. original Pi Pico. We
now support both RP2040 and RP2530. Images are provided in the same tarball.

The documentation has been updated, to reflect this improvement. Libreboot also
now imports `picotool` which is now used to compile the UF2 binaries for
installation, when building them from `pico-sdk`.

### Revision updates

In descending order from latest changes to earliest changes:

* Bumped SeaBIOS to revision 1602647f1 (7 November 2024). This brings in a
  single change from upstream, that prevents the boot menu from being hidden
  when `boot-menu-wait` is negative.
* Bumped GRUB to revision 6811f6f09 (26 November 2024). This brings in several
  important fixes from upstream, most notably TPM2 key support, though we
  don't yet actually enable it in the code as it's unused on all machines.
  Minor fixes have been observed, e.g. graphical glitches fixed under certain
  edge cases.
* Bumped flashprog to revision eb2c041 (14 Nov 2024). This brings in several
  important fixes from upstream.

### Feature changes

In descending order from latest changes to earliest changes:

* `vendor.sh`: Randomised MAC addresses are used by default now, even
  if the user doesn't specify `setmac`. The `setmac keep` command will skip
  setting a MAC address, and `setmac restore` shall insert the default one.
* `vendor.sh`: The `inject` command can now modify MAC addresses inside tar
  archives, whereas it could previously only do so for single-image insertion;
  the latter was removed, leaving only tarball-based injection in place. This
  can also be used, even on boards that don't need vendor files; on those boards,
  vendorfiles still aren't inserted, because again, they are not needed!
* `util/nvmutil`: Show the same byte order, in the same grouping and
  display format, as `hexdump -C`, so that the output is more intuitive when
  the user runs e.g. `./nvm gbe.bin dump`
* `./mk inject` commands are much safer now: tarballs are modified directly,
  without leaving extracted images behind. This means that there is no longer
  any ambiguity about which image to flash. Images are now padded with a
  single byte when scrubbed, and prefixed with DONOTFLASH in the file name.
  Single-image insertion has been removed, such that insertion is now
  tarball-only. In general, the error handling is much stricter, and user
  messages more verbose, to make the script more intuitive and much safer,
  to vastly reduce the number of accidental mistakes that brick the user's
  machine.
* `lib.sh`: Support `reinstall` on Fedora dnf. Use it by running
  the `./mk dependencies fedora re` command.
* `lib.sh`: Support `--reinstall` on Debian apt-get, when running
  the `./mk dependencies debian` command. You can
  use: `./mk dependencies debian --reinstall`
* `vendor.sh`: Intel FSP is no longer directly provided in release images, on
  boards that use it. Instead, images now exclude it and it is to be inserted
  with the `./mk inject` commands. This is to mitigate technicalities of
  Intel's licensing, despite the fact that the FSP is otherwise freely
  redistributable, because coreboot technically modifies it by splitting the
  modules and modifying pointers inside the FSP-M module for raminit.
* `rom.sh`: Support setting `payload_grubsea="y"` on a board's `target.cfg`
  file when compiling, so that GRUB is the primary payload. This is not enabled
  on any boards, nor will it be, on release images, but the user can do it
  themselves when compiling from source.

### Configuration changes

In descending order from the latest changes to the earliest changes:

* Disabled HyperThreading by default, on ThinkPad T480/T480s and OptiPlex 3050
  Micro, to mitigate speculative execution attacks like spectre/meltdown. Users
  can turn it back on and build from source, if they wish, for a roughly 15
  percent performance boost under highly multi-threaded workloads.

### Bug fixes

Several fixes were made to prevent build errors on the latest Debian Sid
and Arch Linux, as of 6 January 2025. Fedora 41 was also tested, fixing
various issues.

The following bug fixes have been merged (in descending order from the latest
changes to the earliest changes):

* ThinkPad T480/T480s: Power LEDs are now reset to the state they were in during
  coldboot, whereas previously they would not have been so, upon warm reboot.
  This patch is courtesy Mate Kukri.
* ThinkPad T480/T480s: Fixed the backlight control keys (Fn key combination).
  Brightness could already be set, but not with the Fn keys, only with software
  e.g. `xbacklight`. Now it functions the way users expect, and demand. This
  fix is courtesy Mate Kukri.
* `lib.sh`: Python versions are detected using Python's own built-in tuple,
  instead of relying on the `--version` argument, because the tuple is more
  consistent across various distros, whereas some distros might modify the
  output of `--version` to include their own branding, which could have messed
  up the way our build system was using `awk`.
* `lib.sh`: Properly set up `python` in the `PATH` directorier, by creating
  a temporary link to the correct Python version, where detected. Python 3
  is the only python on most distros now, but we still occasionally encounter
  setups where the user has `python` as v2.x and has `python3` in PATH for
  Python v3.x; in this latter scenario, the build system corrects for it so
  that `python` is temporarily v3.x while images are being compiled. Several
  parts of the build system do use Python quite heavily, and it is *always*
  Python 3.
* `vendor.sh`: Generally more robust checking of whether vendor files are
  needed, and better handling of the event in which they are not; fewer errant
  error conditions, that should otherwise not be error conditions, where they
  would have previously been so.
* `vendor.sh`: Prevent double-nuke and double-inject. This is done by checking
  whether the hash file is present, because it's removed post-injection now,
  on the newly re-written inject command since 20241206 revision 8.
* `vendor.sh`: Don't error out if `vcfg` is not set. Later checks make it
  skip instead, as is proper. The previous behaviour caused an error under
  certain edge cases, when attempting to inject on boards that don't need
  vendor files.
* `submodule/grub`: Use codeberg as the primary mirror, instead of the GNU
  mirror, because the GNU mirror is often slow. This is done specifically
  for the `gnulib` GRUB submodule.
* `util/nvmutil`: Describe what the program does, in help output. The lack
  of such info is considered a bug, because lack of documentation is a bug.
* `util/nvmutil`: Proper `PREFIX` and `DESTDIR` handling in the Makefile.
  The default prefix is now `/usr/local`, as is correct and righteous; it
  was previously `/usr`. All variables are now properly honoured,
  namely: `DESTDIR`, `PREFIX`, `INSTALL`, `CC` and `CFLAGS` - the user can
  now set custom variables, when compiling.
* Fixed several errors produced by `shellcheck` on the build system.
* HP EliteBook 820 G2: Fixed vendorfile insertion so that checksums now
  verify properly. The board is no longer `release="n"`, so now images for it
  are provided, whereas the board was previously source-only on Libreboot.
* Added `libuuid-devel` to Fedora dependencies.
* T480 / T480s / 3050 Micro: Force power-off after power failure, when
  power is restored. Previously, under such an event, plugging in a charger
  or power supply would then always cause the machine to turn on, with no
  ability to change this. This would happen if the battery ran out on a T480,
  for example.
* flashprog: Disable `-Werror` on builds, to prevent over-zealous compilers
  from yielding errors on mere warnings. This is a preventative bug fix,
  because no errors had yet been observed.
* Debian dependencies: Replaced `liblz4-tool` with `liblz4-dev`, for
  Debian Trixie/Sid. The same config still works for Debian Bookworm.
* `u-boot`: Imported a fix from upstream, that prevents a build error when
  compiling with Swig 4.3.0, because the calling convention changed on one
  of the functions that U-Boot's build system uses. Specifically,
  the `SWIG_AppendOutput` is used now. The way this fix works means that there
  are no behaviour changes, when compiling on an older machine with,
  say, Swig 4.1.0 as used in Debian Bookworm, which is what Libreboot currently
  uses on this day, when compiling releases. We still want the build system
  to work on newer distros.
* Use `command -v` instead of `which`, where the latter was previously used
  in a few places on the build system. The `command -v` command is standard,
  whereas `which` isn't. This is to
  mitigate [which hunts](https://lwn.net/Articles/874049/).
* Added double quotes on several variables in the build system, to prevent
  globbing.
* Removed auto-confirm options on distro dependencies scripts. This is to
  prevent buggy distros from messing up the user's packages, because now it
  will show a confirmation dialog when the package manager sees a conflict;
  previously, the build system just said yes to everything, which reduced the
  amount of user interaction. The idea is to annoy the user, rather than
  break their machine, and this is only a mild annoyance.
* `trees`: Hack the `PATH` environmental variable to link GCC and GNAT, matching
  them so that both versions are the same. This mitigates an issue on Debian
  Trixie/Sid as of January 2025, whereby `gcc` is `gcc-14` while `gnat`
  is `gnat-13` and also installs `gcc-13`; if this ids what the user has, GCC
  is set to GCC 13 in `PATH`. The user can install `gnat-14` if they wish,
  and the GNAT version is auto-matched in `PATH` instead, matching GCC. This
  is only done when compiling the coreboot crossgcc toolchain, because GNAT
  is required there and must match the GCC version.
* Disabled TPM2 on ThinkPad T480/T480s, to speed up the boot time on SeaBIOS,
  because SeaBIOS's TPM driver is buggy and constantly times out on this
  board, when the TPM is enabled. This causes the boot speeds to now be almost
  instantaneous.
* `dependencies/debian`: Changed `python3-distutils`
  to `python3-distutils-extra`, so that dependencies can be installed on
  Debian Trixie/Sid; the same config still works on Debian Bookworm.
* Added SPDX headers to various configuration files.
* `git.sh`: Re-initialise the `livepull` variable per-project and per-tree,
  so that previous runs of it do not unpredictably affect the next, when
  cloning upstream Git repositories.
* `vendor.sh`: Fixed a bug whereby the `lock` file was not deleted under
  certain circumstances, when vendor files were not needed on a given board.
  The consequence of this bug was that the user would have to manually delete
  the lock file, to prevent error.
* `lib.sh`: Safer exit when running `./mk dependencies` (don't rely on the
  exit statuses of chained commands being zero).

### General code cleanup

In descending order from the latest changes to the earliest changes:

* `util/nvmutil`: Make the GbE checksum of `0xBABA` a define, for clarity.
* `lib.sh`: cleaned up a few if statements
* `util/nvmutil`: Tidied up several `pledge` calls on OpenBSD (code quality
  improvement).
* Remove unused deguard patch, which was only used on the old version prior
  to Mate Kukri's re-write.
* Removed geteltorito and mtools from distro dependencies, because it's not
  currently used by anything.

Git log
------

This log is relative to Libreboot 20241206 *revision 7*:

```
* 7d26f0a9c21 Libreboot 20241206, 8th revision 
* d4cc94d6b44 rom.sh: don't run mkpicotool on dry builds 
* de6d2f556f1 pico-sdk: Import picotool as a dependency 
* 4210ee68ea2 lib.sh: Much safer python version check 
* 8c7ba6131cc coreboot/next uprev: Fix T480 backlight keys 
* 411fb697dfc set up python in PATH, ensuring that it is python3 
* e8336bcc3ca vendor.sh: Proper semantics on prefix file names 
* 63f45782638 vendor.sh: Confirm if need_files=n 
* 13b06ae130f vendor.sh: Allow restoring the default GbE file 
* ab8feff92e0 vendor.sh: set random MAC address *by default* 
* 0ceaa01d45d vendor.sh: add clarification to nogbe warning 
* 4d5caf1dcfc vendor.sh: check that the vcfg file exists 
* fc4ee88e167 vendor.sh: error out if nuking failed 
* 8819a93d89b add line break, part 3 
* 8ce1a00f517 add line break, part 2 
* bc2c14e76a8 add line break 
* c762850311a vendor.sh: prevent double-nuke 
* 68299ad05ca vendor.sh: much more verbose errors/confirmation 
* b8e6d12f3d9 add libx86 to arch dependencies 
* cf8ad497b4e vendor.sh: Remove unnecessary return 
* c858099b359 vendor.sh: Download utils even if vcfg unset 
* ce16856a242 vendor.sh: Allow setmac if vendorfiles not needed 
* 4b51787d078 add less to arch dependencies 
* 8bd028ec153 lib.sh: Set python after dependencies 
* 44b6df7c24c update my copyright years on modified scripts 
* 818f3d630c2 vendor.sh: Don't error if vcfg is unset 
* 432a1a5bca7 lib.sh: Fix unescaped quotes in chkvars() 
* a73b0fd910a Revert "fix more unescaped quotes in eval" 
* ec6bcc1fba5 fix more unescaped quotes in eval 
* 5284f20b981 fix ./mk dependencies build issue 
* d825f9a9683 rom.sh: Remove errant GRUB modules check 
* 4149f3dc81a submodule/grub: use codeberg for 1st gnulib mirror 
* 0305975e705 util/nvmutil: Update AUTHORS and COPYING files 
* 20b192e13bd util/nvmutil: Describe nvmutil in help output 
* d1ca21628cb util/nvmutil: Remove the correct binary on uninstall 
* e63fe256dfc util/spkmodem-recv: More correct Makefile 
* efd50ee548b util/nvmutil: Honour the INSTALL variable 
* 8008838abbc util/nvmutil: Don't clean when doing uninstall 
* 982f257f58a util/nvmutil: Proper DESTDIR/PREFIX handling 
* 3f85ae5f853 util/nvmutil: Set CC and CFLAGS only if unset 
* 2c7b9fb9412 util/nvmutil: Capitalise BABA 
* 57f9906f6d1 util/nvmutil: Add uninstall to Makefile 
* 4defe2c6085 util/nvmutil: Add distclean to Makefile 
* 033e4cd9d50 util/nvmutil: Make the GbE checksum a define 
* 874317c4e59 util/nvmutil: nicer hexdump display 
* a338e585eed util/nvmutil: show the correct hexdump order 
* b032e483ef1 lib.sh mktarball: cleaner if statement 
* 0cf58c22734 fix lbmk shellcheck errors 
* 8276560cc99 lib.sh and rom.sh: update my header 
* 08e86d2218c vendor.sh inject: reset err upon return 
* 41275d699ca vendor.sh: MUCH, MUCH, MUCH safer ./mk inject 
* ed7293494e3 util/nvmutil: Obey the 79-character per line limit 
* 637b5e36fd2 util/nvmutil: Tidy up copyright header 
* cd28db883e2 vendor.sh: fix comment 
* 57971ceb227 util/nvmutil: Fix another straggler 
* 15b37b2a1ab util/nvmutil: Tidy up pledge calls 
* e8799310db2 hp820g2: fix vendorfile inject and set release=y 
* f9ab082ec19 fedora41/dependencies: add libuuid-devel 
* 661591f9f0b add uuid-devel to fedora41 dependencies 
* 1a46c047386 support ./mk dependencies fedora reinstall 
* d58d63569f1 fix missing semicolon in grub nvme patch 
* 95ea3293df5 bump seabios to rev 1602647f1 (7 November 2024) 
* 6d7e6c361b3 Bump GRUB revision to 6811f6f09 (26 November 2024) 
* 09a01477df6 t480/3050micro: force power off post power failure 
* d344cd95eac flashprog: Disable -Werror 
* dc95e912bfe bump flashprog to revision eb2c041 (14 Nov 2024) 
* 27c8c1c16ba replace liblz4-tool with lz4 and liblz4-dev 
* d3a732a64db lib.sh dependencies: support --reinstall argument 
* 466ada423dd move xbmkpath to XBMK_CACHE/ 
* b0a23840327 Revert "Remove legacy update/vendor commands" 
* 3d7dd4aa9fe Fix U-Boot build issue with Swig 4.3.0 
* 0c810747469 use command -v instead of which 
* 6c7e3ce2d6e trees: remove unnecessary subshell 
* ad137eae89d trees: only symlink host gcc/gnat to build xgcc 
* cfb6de94c33 trees: correction on check_gnu_path 
* ec2f0716662 trees: match gcc/gnat versions both ways 
* f64b5996279 Merge path.sh into script/trees 
* 295463d281e path.sh: Further cleanup 
* 5b24e0a5a96 path.sh: More thorough gcc/gnat version check 
* 7849a075886 path.sh: minor cleanup 
* 17168a87dbf path.sh: remove unnecessary shebang 
* e565df94fd7 Fix globbing issue in lbmk 
* c80cc0a00b6 remove auto-confirm on distro dependencies 
* 01fc65a0a9d Mitigate Debian Trixie/Sid GCC/GNAT version mismatch 
* 424b0c7103b t480/3050micro: disable hyperthreading 
* 603105f3b4e t480/t480s: Disable TPM2 to mitigate SeaBIOS lag 
* 754bd1e6ca3 rom.sh: Name pico directory serprog_pico 
* db22308eba5 add 2024 to Riku's copyright header on rom.sh 
*   4fa5f696db8 Merge pull request 'rp2530' (#258) from Riku_V/lbmk:rp2530 into master 
|\  
| * a5e0360992d pico-sdk: update to 2.1.0 
| * e2f8cc7f3ee pico-serprog: enable building for multiple pico chips 
|/  
* ccc2b4d589f add spdx headers to dependencies configs 
* a3969701e6b dependencies/debian: fix debian sid 
* 8f370cb60d9 add spdx headers to various config files 
* d591ea4c5dc git.sh: don't initialise livepull globally 
* b5da9feba3b vendor.sh: Print useful message on ./mk inject 
* 12c6259cb2f vendor.sh: Handle FSP insertion post-release 
* 78132051462 Remove legacy update/vendor commands 
* 07037561bd6 lbmk: remove use of deprecated ./vendor command 
* 5d1f1823067 vendor.sh: Safer exit when vendorfiles not needed 
* a18175a5df9 data/deguard: Remove unused patch 
* ee8f53b96ff lib.sh: Safer exit from ./mk dependencies 
* a8b35c88cf1 remove geteltorito and mtools from lbmk 
* 1dd32ea5487 rom.sh: support grub-first setups 
```

This is roughly 100 changes.

Older revisions
--------------

Please review the
original [Libreboot 20241206 announcement](libreboot20241206.md), and
the [Libreboot 20241206 revisions page](libreboot20241206.Revisions.md).

Formalised release schedule
---------------

UPDATE: the text of this section was removed on 17 January 2025.

Please read the following new article instead:

[Formalised Libreboot 2025 release schedule](schedule.md)
