---
title: Прошивка ThinkPad X200 вперше
x-toc-enable: true
...

<div class="specs">
<center>
<img tabindex=1 alt="ThinkPad X200" class="p" src="https://av.libreboot.org/x200/disassembly/0019.jpg" /><span class="f"><img src="https://av.libreboot.org/x200/disassembly/0019.jpg" /></span>
</center>

| ***Характеристики***       |                                                |
|----------------------------|------------------------------------------------|
| **Виробник**               | Lenovo                                         |
| **Назва**                  | ThinkPad X200/X200S/X200 Tablet                |
| **Випущено**               | Липень/Вересень 2009 року                      |
| **Чіпсет**                 | Intel Cantiga GM45                             |
| **ЦП**                     | Intel Core 2 Duo (сімейство Penryn)            |
| **Графіка**                | Intel GMA X4500MHD                             |
| **Дісплей**                | 1280x800/1440x900 TFT                          |
| **Пам'ять**                | 1,2,3 or 4GB (оновлюється до 8GB, неофіційно)  |
| **Архітектура**            | x86\_64                                         |
| **EC**                     | Пропрієтарний                                  |
| **Оригінальна прошивка**   | LenovoBIOS                                     |
| **Intel ME/AMD PSP**       | Наявний. Можна повністю вимкнути.              |
| **Флеш-чіп**               | SOIC-8/SOIC-16/WSON-8 4MiB/8MiB (Оновлюється 
                                                                    до 16MБ)  |
```
W+: Працює без бінарних компонентів; 
N: Не працює; 
W*: Працює з бінарними компонентами; 
U: Не перевірялось; 
P+: Частково працює; 
P*: Частково працює з бінарними компонентами
```

| ***Функції***  |                                       |
|----------------|---------------------------------------|
| **Внутрішня прошивка з оригінальною прошивкою**   | N  |
| **Дісплей**                                       | W+ |
| **Аудіо**                                         | W+ |
| **Ініціалізація ПДД**                             | W+ |
| **Зовнішній вивід**                               | W+ |
| **Яскравість дісплею**                            | P+ |

| ***Корисні навантаження***  |           |
|-----------------------------|-----------|
| **GRUB**                | Працює    |
| **SeaBIOS**                 | Працює    |
| **SeaBIOS з GRUB**      | Працює    |
</div>

Вступ
-----

Вважається що всі ноутбуки X200 сумісні. X200S та X200
Tablet також працюватимуть, [залежно від конфігурації](#x200s).

Можливо, можна розмістити материнську плату X200 у шасі X201, хоча це
наразі не перевірено проектом libreboot. Те ж саме може стосуватися
X200S та X201S; знову ж таки, це неперевірено. *Швидше за все, це правда.*

Є два можливих розміра флеш-чіпа для X200: 4MБ (32 Мбіт) або
8МБ (64 Мбіт). Це можна визначити за типом флеш-чіпа під
упором для рук: 4МБ це SOIC-8, 8МБ це SOIC-16.

*Ноутбуки X200 постачаються з ME (та іноді AMT додатково)
перед перепрошивкою libreboot. libreboot вимикає та видаляє його за допомогою
модифікованого дескриптора: дивіться [../install/ich9utils.md](../install/ich9utils.md)*
(містить примітки та інструкції)

Інструкції з перепрошивки можна знайти за адресою
[../install/\#flashprog](../install/#flashprog)

**NOTE: Libreboot standardises on [flashprog](https://flashprog.org/wiki/Flashprog)
now, as of 27 January 2024, which is a fork of flashrom.
The reason why was explained, in
the [Libreboot 20240225 release](../../news/libreboot20240225.md#flashprog-now-used-instead-of-flashrom)**

Оновлення EC {#ecupdate}
------------------------

Рекомендується оновити мікропрограму EC до останньої версії.
[Прошивка EC](../../faq.md#ec-embedded-controller-firmware) є окремою від
libreboot, тому ми її фактично не надаємо, але якщо у вас все ще є
Lenovo BIOS, ви можете просто запустити утиліту оновлення BIOS Lenovo, яка
оновить як BIOS, так і версію EC. Дивіться:

-   [../install/#flashprog](../install/#flashprog)
-   <http://www.thinkwiki.org/wiki/BIOS_update_without_optical_disk>
-   [Оновлення BIOS X200, X200s, X200i](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-laptops/thinkpad-x200/downloads/ds015007)
-   [Оновлення BIOS X200t](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-tablet-laptops/thinkpad-x200-tablet/downloads/ds018814)

ПРИМІТКА: це можна зробити, лише якщо ви використовуєте Lenovo BIOS. Як
оновити мікропрограму EC, користуючись libreboot, невідомо. libreboot
тільки замінює прошивку BIOS, не EC.

Оновлена мікропрограма EC має декілька переваг, напр. краще поводження
з акумулятором.

Відкликання батареї {#batteryrecall}
------------------------------------

[21 квітня 2015 року, Lenovo розширила відкликання акумуляторів Lenovo, які були встановлені в деяких моделях Thinkpad, зокрема X200 та X200S.](https://pcsupport.lenovo.com/cr/en/solutions/hf004122) 
Щоб дізнатися, чи вас це стосується, використовуйте [цей інструмент Lenovo.](https://lenovobattery2014.orderz.com/) 
Lenovo радить власникам відкликаних моделей "вимкнути систему, вийняти батарею, 
та живити ThinkPad лише шляхом підключення адаптера змінного струму та шнура живлення." 
Після перевірки батареї, Lenovo безкоштовно замінить відкликані батареї. 
Інструкції щодо заміни батареї для X200/X200s [можна знайти на цій сторінці.](https://pcsupport.lenovo.com/cr/en/parts/pd003507/)

### Список сумісності LCD {#lcd_supported_list}

Список РК-панелей (там перераховані панелі X200):
<http://www.thinkwiki.org/wiki/TFT_display>

Відомо, що всі РК-панелі для X200, X200S та X200 Tablet працюють.

### AFFS/IPS панелі {#ips}

#### X200

Адаптовано з
<https://github.com/bibanon/Coreboot-ThinkPads/wiki/ThinkPad-X200>

Подивіться у Вікіпедії різницю між панелями TN та IPS. IPS мають
набагато кращий колір/контраст, ніж звичайний TN, і зазвичай мають
хороші кути огляду.

Це, здається, з X200 tablet. Вам потрібно знайти таку
без скляного захисту сенсорного екрана (проте її можна зняти).
На ньому також не повинно бути дигітайзера (знову ж таки, можна
просто видалити дигітайзер).

-   BOE-Hydis HV121WX4-120, HV121WX4-110 або HV121WX4-100 - дешево,
    може бути тяжко знайти

-   Samsung LTN121AP02-001 - звичайно знайти, недорого

*Якщо ваш X200 має панель зі світлодіодним підсвічуванням, вам також потрібно придбати
інвертор і кабель, сумісний з панелями CCFL.
Щоб дізнатися, який у вас тип панелі, перегляньте
[\#led\_howtotell](#led_howtotell). Якщо вам потрібен інвертор/кабель, ось
номери деталей: 44C9909 для кабелю CCFL LVDS із підключенням bluetooth і камери,
та 42W8009 або 42W8010 для інвертора.*

Існують глянцеві та матові варіанти. Матовий означає антивідблиск,,
чого ви і хочете (на думку авторів).

Зверніться до HMM (посібник з обслуговування обладнання), щоб дізнатися, як
замінити екран.

Джерела:

-   [Форуми ThinkPad - матова панель AFFS на
    X200](http://forum.thinkpads.com/viewtopic.php?f=2&t=84941)
-   [Форуми ThinkPad - Частини для мода X200 AFFS
    Mod](http://forum.thinkpads.com/viewtopic.php?p=660662#p660662)
-   [ThinkWiki.de - X200 Displayumbau](http://thinkwiki.de/X200_Displayumbau)

#### X200S

<http://forum.thinkpads.com/viewtopic.php?p=618928#p618928> пояснює, що
екрани/блоки X200S тонші. Вам потрібно замінити всю кришку на одну від
звичайного X200/X201.

### Як визначити, чи у нього LED, чи CCFL? {#led_howtotell}

Деякі X200 мають підсвічування CCFL, а деякі - світлодіодне підсвічування на РК-панелі.
Це також означає, що інвертори відрізнятимуться, тому ви повинні бути обережними,
коли замінюєте панель та/або інвертор. (інвертор CCFL має
високу напругу і зруйнює світлодіодну панель із підсвічуванням).

CCFL містять меркурій. На X200 з CCFL підсвіткою (якщо його не було замінено на світлодіодне з правильним
інвертором. Зверніться до свого постачальника!) буде написано
наступне: *"Цей продукт містить літій-іонну батарею, літієву батарею та лампу,
яка містить ртуть; утилізуйте відповідно до місцевих, державних або федеральних
законів"* (на тому, що має світлодіодне підсвічування, буде написано щось інше).

Installation notes
------------------

[External flashing](spi.md) required, if running Lenovo BIOS.

Цей посібник призначений для тих, хто бажає libreboot на своєму ThinkPad X200,
поки у нього все ще є оригінальний Lenovo BIOS в наявності. Цього керівництва також можна
дотримуватися (адаптувати), якщо ви перетворили ваш X200 на цеглину, щоб знати, як його відновити.

Якщо у вас виконується оригінальна мікропрограма Lenovo, вам потрібно буде зняти
клавіатуру та підставку для рук, щоб мати доступ до мікросхеми флеш-пам'яті, яка знаходиться прямо
під підставкою для рук. Потім ви підключите зовнішній програматор SPI, щоб
повторно прошити мікросхему зовні, коли вона вимкнена та акумулятор висунуто.

ПРИМІТКА: Цей посібник стосується лише звичайного X200. Для перепрошивки X200S та X200 Tablet,
будь-ласка прочитайте інші посібники, доступні на libreboot.org.

Розмір флеш-чіпа
----------------

Виконайте цю команду на x200, щоб дізнатися модель флеш-чіпа та його розмір:

    flashprog -p internal

MAC адреса
----------

Зверніться до [mac\_address.md](mac_address.md).

### Процедура

Цей розділ стосується X200. Цей не стосується X200S або X200
Tablet (для цих систем потрібно повністю видалити материнську плату,
оскільки мікросхема флеш-пам'яті знаходиться з іншого боку плати).

Викрутіть ці гвинти:\
![](https://av.libreboot.org/x200/disassembly/0003.jpg)

Обережно притисніть клавіатуру до екрана, потім підніміть її та за бажанням
від'єднайте від плати:\
![](https://av.libreboot.org/x200/disassembly/0004.jpg)
![](https://av.libreboot.org/x200/disassembly/0005.jpg)

Від'єднайте кабель пристрою для зчитування відбитків пальців, а потім потягніть упор для рук,
піднявши його ліву та праву сторону:\
![](https://av.libreboot.org/x200/disassembly/0006.1.jpg)
![](https://av.libreboot.org/x200/disassembly/0006.jpg)

Тут показано розташування мікросхеми флеш-пам'яті, для обох SOIC-8 та SOIC-16:\
![](https://av.libreboot.org/x200/x200_soic16.jpg)
![](https://av.libreboot.org/x200/x200_soic8.jpg)

Підніміть стрічку, яка закриває частину флеш-пам'яті, а потім
приєднайте затискач:\
![](https://av.libreboot.org/x200/disassembly/0008.jpg)

Тепер ви повинні бути готові до встановлення libreboot.

Зверніться до [інструкцій програмування SPI](spi.md).

Закінчивши, знову зберіть систему. Якщо вона не завантажується, спробуйте інші
модулі оперативної пам'яті, тому що raminit дуже ненадійний на цій платформі (в coreboot).

Пам'ять
-------

У машинах DDR3 з Cantiga (GM45/GS45/PM45), північний міст потребує стіків,
які працюватимуть як PC3-8500 (швидші стіки PC3/PC3L можуть працювати як PC3-8500).
Пари, що не збігаються, можуть не працювати. Один модуль (тобто один із слотів
буде порожнім) наразі працюватиме лише в слоті 0.

ПРИМІТКА: згідно зі звітами користувачів, у деяких випадках невідповідні пари ( 1+2 ГБ) можуть
працювати в деяких випадках.

Переконайтесь, що оперативна пам'ять, яку ви купуєте, має конфігурацію 2Rx8, купуючи стіки по 4 ГБ
(Іншими словами: максимально 2 ГБ на ранг, 2 ранга на картку).

На цьому фото встановлено 8 ГБ оперативної пам'яті (2x4ГБ):

![](https://av.libreboot.org/x200/disassembly/0018.jpg)

### Завантажуйтесь!

Ви маєте побачити щось подібне цьому:

![](https://av.libreboot.org/x200/disassembly/0019.jpg)

Тепер [встановлюйте Linux](../linux/).

### Користувачі X200S та X200 Tablet: трюк GPIO33 не спрацює.

sgsit дізнався про контакт під назвою GPIO33, який можна заземлити,
щоб вимкнути захист прошивки за допомогою дескриптора та зупинити ME від
запуску (який сам по собі перешкоджає спробам прошивки). Теорія була
доведена правильною; однак на практиці це все одно марно.

Подивіться трохи вище 7 у TP37 (це GPIO33):

![](https://av.libreboot.org/x200/gpio33_location.jpg)

Це замовчуванням ми побачимо це в lenovobios, під час спроби flashprog -p
internal -w rom.rom:

    FREG0: Warning: Flash Descriptor region (0x00000000-0x00000fff) is read-only.
    FREG2: Warning: Management Engine region (0x00001000-0x005f5fff) is locked.

Коли GPIO33 було заземлено під час завантаження, це вимкнуло захист флеш-пам'яті,
встановлений дескриптором, і зупинило запуск ME. Результат змінився
на:

    The Flash Descriptor Override Strap-Pin is set. Restrictions implied by
    the Master Section of the flash descriptor are NOT in effect. Please note
    that Protected Range (PR) restrictions still apply.

Частина, виділена жирним шрифтом, - це те, що нас дістало. Це все ж спостерігалось:

    PR0: Warning: 0x007e0000-0x01ffffff is read-only.
    PR4: Warning: 0x005f8000-0x005fffff is locked.

Насправді ці засоби захисту можна відключити. Lenovobios робить це,
під час оновлення BIOS (пропрієтарного). Одним із можливих способів вирішити цю проблему
було б відлагодити утиліту оновлення BIOS від Lenovo, для віднаходження,
як вона вимикає ці засоби захисту. Додаткові дослідження доступні
тут:
<http://www.coreboot.org/Board:lenovo/x200/internal_flashing_research>

Звичайно, ймовірно, що Lenovo BIOS перевіряє якийсь біт в пам'яті,
який говорить йому не вимикати перепрошивку, а потім він не встановлює регістри PRx. Принцип
роботи програми оновлення BIOS Lenovo полягає в тому, що вона спочатку виконується в Windows,
а потім відбувається перезавантаження, ініціюючи перепрошивку під час раннього завантаження. Ймовірно,
це встановлює щось у пам'яті та завантажує ROM, плюс програму корисного навантаження,
яка виконує перепрошивання; тоді Lenovo BIOS, ймовірно, бачить це та запускає це замість
встановлення PRx і переходу до нормального завантаження. Теоретично можливо, що ми
зможемо дізнатися, як це працює, налагодивши утиліту оновлення BIOS Lenovo (у
Windows), а потім відтворивши її дії за допомогою якогось інструменту для Linux,
а потім завантаживши двійковий файл flashprog в пам'ять та ROM для прошивки (для BIOS
регіона). Ви б зробили це з заземленням GPIO33, і програма корисного навантаження
фактично прошиє весь чіп, лише звичайним образом libreboot.

Це можливо. Ймовірно, це єдиний спосіб роботи програми оновлення BIOS Lenovo.
Отже, якщо ми дізнаємося, як саме це зробити, тоді ви можете просто підключити кілька
контактів pogo для заземлення GPIO33, потім завантажитися, запустити програмне забезпечення
(яке потрібно було б написати), яке виконує вищезазначене.

У зв'язку з цим у libreboot є утиліта, яка може допомогти
розслідувати це:
[ich9utils.md#demefactory](ich9utils.md#demefactory)
