---
title: HP EliteBook 8470p
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](ivy_has_common.md).**

<div class="specs">
<center>
<img tabindex=1 alt="HP EliteBook 8470p" class="p" src="https://av.libreboot.org/hp8470p/hp8470p.jpg" /><span class="f"><img src="https://av.libreboot.org/hp8470p/hp8470p.jpg" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | HP                                             |
| **Name**                   | EliteBook 8470p                                |
| **Variants**               | EliteBook 8470p                                |
| **Released**               | 2012                                           |
| **Chipset**                | Intel QM77                                     |
| **CPU**                    | Intel Ivy Bridge                               |
| **Graphics**               | Intel HD Graphics 4000(supported in Libreboot) or
                               AMD Radeon HD 7570M(unsupported in Libreboot)  | 
| **Display**                | 14" 1366x768 or 1600x900 TFT                   |
| **Memory**                 | Two slots, max 8GB/slot (2x1GB), DDR3/sodimm   |
| **Architecture**           | x86_64                                         |
| **EC**                     | SMSC KBC1126, proprietary (in main boot flash) |
| **Original boot firmware** | HP UEFI firmware                               |
| **Intel ME/AMD PSP**       | Present. Can be disabled with me_cleaner.      |
| **Flash chip**             | SOIC-16 16MiB (128Mbit)                        |


```
W+: Works without vendor firmware; 
N: Doesn't work; 
W*: Works with vendor firmware; 
U: Untested; 
P+: Partially works; 
P*: Partially works with vendor firmware
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | N  |
| **Display (if Intel GPU)**                        | W+ |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |
| **External output**                               | W+ |
| **Display brightness**                            | W+ | 

| ***Payloads supported***  |           |
|---------------------------|-----------|
| **GRUB**                  | Works     |
| **SeaBIOS**               | Works     |
| **SeaBIOS with GRUB**     | Works     |
</div>
Introduction
============

**Unavailable in Libreboot 20230625 or earlier. You must [compile from
source](../build/), or use at least Libreboot 20231021.**

Official information about the laptop can be found here:
<https://support.hp.com/gb-en/document/c03374369>

This is a beastly 14" Ivy Bridge platform from HP.
**NOTE: Until otherwise stated, only the Intel GPU variant is supported in
Libreboot.**

Build ROM image from source
---------------------------

The build target, when building from source, is thus:

	./mk -b coreboot hp8470pintel_16mb

Installation
============

Insert binary files
-------------------

If you're using a release ROM, please ensure that you've inserted extra firmware
required refer to the [guide](../install/ivy_has_common.md) for that. (failure
to adhere to this advice will result in a bricked machine)

Set MAC address
---------------

This platform uses an Intel Flash Descriptor, and defines an Intel GbE NVM
region. As such, release/build ROMs will contain the same MAC address. To
change the MAC address, please read [nvmutil documentation](../install/nvmutil.md).

Flash a ROM image (software)
-----------------

If you're already running Libreboot, and you don't have flash protection
turned on, [internal flashing](../install/) is possible.

Flash a ROM image (hardware)
-----------------

**REMOVE all power sources like battery, charger and so on, before doing this.
This is to prevent short circuiting and power surges while flashing.**

For general information, please refer to [25xx NOR flash
instructions](../install/spi.md).

At this present time, disassembly instructions are unavailable from the
Libreboot project, but you can search for HP's own hardware maintenance manual
or look at videos online showing disassembly.

The flash is near the RAM, top side. (sorry, I forgot to take photos when
testing this, but they can be added here at a later date)
