/*
 * Copyright (c) 2024, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MTK_SIP_DEF_H
#define MTK_SIP_DEF_H

/* Define SiP SMC ID here */
#define MTK_SIP_SMC_FROM_NS_EL1_TABLE(_func) \
	_func(MTK_SIP_KERNEL_TIME_SYNC, 0x202) \
	_func(MTK_SIP_KERNEL_DFD, 0x205) \
	_func(MTK_SIP_KERNEL_MSDC, 0x273) \
	_func(MTK_SIP_KERNEL_UFS_CONTROL, 0x276) \
	_func(MTK_SIP_VCORE_CONTROL, 0x506) \
	_func(MTK_SIP_MTK_LPM_CONTROL, 0x507) \
	_func(MTK_SIP_EMIDBG_CONTROL, 0x50B) \
	_func(MTK_SIP_IOMMU_CONTROL, 0x514) \
	_func(MTK_SIP_AUDIO_CONTROL, 0x517) \
	_func(MTK_SIP_APUSYS_CONTROL, 0x51E) \
	_func(MTK_SIP_DP_CONTROL, 0x523) \
	_func(MTK_SIP_KERNEL_GIC_OP, 0x526) \
	_func(MTK_SIP_KERNEL_VCP_CONTROL, 0x52C) \
	_func(MTK_SIP_KERNEL_SLBC_CONTROL, 0x53E)

#define MTK_SIP_SMC_FROM_S_EL1_TABLE(_func) \
	_func(MTK_SIP_TEE_MPU_PERM_SET, 0x031) \
	_func(MTK_SIP_TEE_EMI_MPU_CONTROL, 0x048) \
	_func(MTK_SIP_TEE_SMMU_CONTROL, 0x04D)

#define MTK_SIP_SMC_FROM_BL33_TABLE(_func) \
	_func(MTK_SIP_KERNEL_BOOT, 0x115) \
	_func(MTK_SIP_BL_UFS_CONTROL, 0x40D) \
	_func(MTK_SIP_BL_LPM_CONTROL, 0x410) \
	_func(MTK_SIP_BL_EMIMPU_CONTROL, 0x415)

#endif /* MTK_SIP_DEF_H */
