% Canoeboot 25.04 "Corny Calamity" released!
% Leah Rowe
% 30 April 2025

Today's Canoeboot 25.04 revision is a *testing release*, whereas the previous
stable release was Canoeboot 20241207. The codename for this release
is *Corny Calamity*. This is the first release to have a codename, and it is
using YY.MM format for the version number for the first time. Older releases
used YYYYMMDD as release dates.

Canoeboot's release schedule is in sync with that of
the [Libreboot 25.04 release](https://libreboot.org/news/libreboot2504.md),
re-using the same version numbers and version codenames and this release shares
the same codename, *Corny Calamity*.

New schedule and version numbers
-------------------------------

This change in version release scheme was previously reported in the news
post announcing Canoeboot's new [formal release schedule](schedule.md). As per
that article, the next stable release will be Canoeboot 25.06, in June 2025.

Regarding the changelog
--------------------

A lot has happened since Canoeboot 20241207, released in December 2024. Although
several revisions were made to that release in recent months, *this* new
release changelog is relative to the *original* December 2024 release, so some
of these changes were also included in 20241207 revision releases.

There *is* a Canoeboot 20250107, but it is based on the revision releases
of Libreboot 20241206, and the Libreboot 25.04 changelog is based on
Libreboot 20241206. To keep things simple, therefore, this changelog is
relative to Canoeboot 20241207.

Open source BIOS/UEFI firmware
----------------------------

<img tabindex=1 class="r" src="https://av.vimuser.org/x200-uboot.jpg" /><span class="f"><img src="https://av.vimuser.org/x200-uboot.jpg" /></span>

Canoeboot is a free/open source BIOS/UEFI replacement on x86 and ARM, providing
boot firmware that initialises the hardware in your computer, to then load an
operating system (e.g. Linux/BSD). It is specifically
a *[coreboot distribution](../docs/maintain/)*,
in the same way that Debian is a Linux distribution. It provides an automated
build system to produce coreboot ROM images with a variety of payloads such as
GRUB or SeaBIOS, with regular well-tested releases to make coreboot as easy
to use as possible for non-technical users. From a project management perspective,
this works in *exactly* the same way as a Linux distro, providing a source-based
package manager (called cbmk) which patches sources and compiles coreboot images.
It makes use of [coreboot](https://www.coreboot.org/) for hardware initialisation,
and then a payload such as [SeaBIOS](https://www.seabios.org/SeaBIOS)
or [GRUB](https://www.gnu.org/software/grub/) to boot your operating
system; on ARM(chromebooks) and certain x86 mainboards, we provide *U-Boot* (as
a coreboot payload), which provides a lightweight UEFI implementation..

Summarised list of changes
-------------------------

### Board support

The following boards have been added since the Canoeboot 20241207 release:

* Acer Q45T-AM support added (similar to G43T-AM3 mainboard)

G43T-AM3 and Q45T-AM were also changed to a descriptor-based setup, with
full GbE region and correct 4MB ROM size, so for example ethernet should
work fine now.

### Revision updates

In descending order from latest changes to earliest changes:

* Bump SeaBIOS to to rev 9029a010, 4 March 2025
* Updated Untitled to newer LBSSG repository.
* Bump flashprog to rev e060018 (1 March 2025)
* Bump U-Boot on ARM64 boards to U-Boot v2025.04. Patching courtesy of
  Alper Nebi Yasak.
* Merged coreboot/next with coreboot/default
* Bump coreboot/next to rev c247f62749b as of 20 April 2025
* Bump coreboot/default to rev c247f62749b as of 20 April 2025
* Bump GRUB to rev a4da71daf (20 April 2025)
* Bump flashprog to revision eb2c041 (14 Nov 2024).

The GRUB revision includes a number of critical CVE fixes, and regression
fixes, that were also included in Canoeboot 20241207 rev11.

The NASM version was updated to version 2.16.03 on coreboot/fam15h, to prevent
build errors, instead of fixing the old NASM 2.14.02. Tested on Debian Sid
Experimental, with GCC15-based toolchain, and on Fedora 42.

PICO support: Reverted to the old pico serprog/sdk repositories used
in Canoeboot 20240612. This is temporary, because pico2 support is currently
broken, so this release only has pico1 support, when dealing with Rpi Pico
devices. Upstream pico-serprog works fine on pico2, so this will be fixed
in and re-updated again in a future revision release. The pico2 update images
were retroactively removed from the 20241207 release on rsync.

A patch from upstream was backported to the old pico-sdk version, so that it
builds correctly on newer GCC15 (tested on Debian Sid with "Experimental"
packages enabled).

### Licensing

* Added SPDX license headers to almost every configuration file in cbmk.

### Security

These can be considered bug fixes, but these are special fixes that are of
massive concern to users.

* Merged *73* critical CVE fixes into the GNU GRUB source code, from upstream.
* Stricter use of pledge and unveil in the nvmutil source code.
* Fix globbing issues in cbmk by double-quoting variables everywhere, and
  generally making sure that certain characters are escaped properly when
  necessary. To reduce the chance of bad commands being run by mistake or
  intentionally.
* Removed auto-confirm on `./mk dependencies` commands, to mitigate the risk
  of a buggy package manager on the user's distro possibly removing many
  packages. Now the user must confirm their choice, e.g. when a conflict
  occurs, instead of the package manager already deciding for the user.

### Feature changes

In descending order from latest changes to earliest changes:

* `init.sh`: More verbose error info, on non-zero exits.
* `util/nvmutil`: Within each 4KB part, only handle 4KB, even if the block
  size is bigger. This means using less memory, and modification of anything
  past 4KB is not required.
* `util/nvmutil`: Support 16KB and 128KB GbE files, in addition to the
  usual 8KB files. The size is based on the block size of the flash you use.
* Added non-root USB3 hub support to GRUB on the xHCI implementation, courtesy
  of a patch from Nitrokey.
* GRUB: Scan LUKS inside *every* LVM, to support the uncommon use case where
  LUKS is inside LVM, instead of LVM inside LUKS. It is theoretically possible,
  even if ill advised.
* GRUB: Scan *every* LVM device, where available, as a fallback at boot time
  when all else fails.
* Allow restoring the default MAC address on `./mk inject` commands, by using
  the `setmac restore` arguments.
* Randomise the MAC address by default, where applicable, when running
  the `./mk inject` commands, because lots of users previously flashed without
  changing it, so lots of users had generic MAC addresses.
  The `setmac keep` argument prevents this from happening, where desired.
* `util/nvmutil`: Add uninstall command to the Makefile
* `util/nvmutil`: Add distclean command to the Makefile
* `util/nvmutil`: Nicer hexdump display, similar to `hexdump -C`.
* Support a `re` argument in `./mk dependencies` Fedora commands, for
  re-installation of packages as desired.
* Support `--reinstall` in the `./mk dependencies debian` command, when the
  user wants to re-install dependencies.
* Put temporary `PATH` directory in the normal `XBMK_CACHE` directory, and
  clear it whenever a new parent instance of the build system is executed.
  This is used for the GCC/GNAT matched symlinks, for example, or the python
  symlink created at startup.
* Pico 2 support briefly added, but was a bit buggy for now, so it's removed
  in this release, and was retroactively removed in rsync for the
  Canoeboot 20241207 release; this will be re-added in a future release.
* Added GRUB-first payload setups as an option, but not enabled by default.
  The user can add `payload_grubsea="y"` in the `target.cfg` file for a given
  mainboard.
* Insert GRUB backgrounds in CBFS instead of GRUB memdisk, which makes
  GRUB background images easier to replace.

### Configuration changes

In descending order from the latest changes to the earliest changes:

* Added `gnutls-devel` to Fedora 41 dependencies.
* Added `libx86` to Arch dependencies, needed for the `int` utility.
* Added `less` to Arch dependencies, because it's needed for certain commands
  e.g. git commands.
* GRUB: Use the codeberg mirror first, to mitigate GNU mirrors often being
  slow or rate limited, e.g. for gnulib downloads.
* fedora41/dependencies: add libuuid-devel
* Added `uuid-devel` to fedora41 dependencies
* flashprog: Disable `-Werror` to prevent minor warnings being treated as errors.

### Bug fixes

The following bug fixes have been merged (in descending order from the latest
changes to the earliest changes):

* coreboot (all trees): Added patch fixing GMP build errors on modern
  GCC15 hostcc.
* coreboot (all trees): Fixed building of crossgcc with newer GCC15. Patches
  courtesy of Alper Nebi Yasak.
* coreboot (all trees): Added a patch to fix building coreboot utils with
  newer GCC15.
* dependencies/debian: Fixed the libusb package name for newer Debian releases,
  courtesy of Alper Nebi Yasak.
* SeaBIOS: Fixed `malloc_fn` function pointers in the `romfile` patch, courtesy
  of Alper Nebi Yasak. Fix build errors on GCC 15.
* `include/lib.sh`: Force use of System Python e.g. `/usr/bin/python`, when
  a python venv is detected. This prevents the build system from hanging.
* coreboot `g43t_am3`: Fixed the `data.vbt` path.
* Alper Nebi Yasak fixed the Python 2/3 detection in some edge cases when
  the `python` command is python2.
* `include/lib.sh` (later `init.sh`): Do root check *first*, right after
  the dependencies check, whereas it previously did the python check before
  checking for root user.
* cbmk: Don't use TMPDIR directly, use another variable containing its value,
  and make sure it doesn't get changed wrongly. This reduces the possibility
  of accidentally leaving old tmp files laying around.
* `include/lib.sh`: `tar` commands now return an exit with error, if a fault
  occurs, whereas it didn't before, due to piped output. This is done
  using the `x_` wrapper on tar commands, to provide error exits.
* `mk`: function `check_project_hashes` now returns an error, if the sha512sum
  command fails. It previously didn't, due to piped outputs. It's now mitigated
  by using `x_` on piped commands, for error exits.
* Forking of cbmk parent instance to child instance isno longer handled by
  variables. It's been simplified, to only be based on whether TMPDIR is set,
  and it's generally more robust now in this release. The old code sometimes
  broke under certain edge cases.
* cbmk: Initialise `PATH` to a standard string if not set, on the parent
  instance of cbmk.
* cbmk: Use `pwd` instead of the `PWD` variable, resetting the latter safely
  as cbmk runs. This prevents cbmk from changing directory to an erroneous
  system path, if `PWD` wasn't properly set for some reason. This is a
  preventative bug fix, because no actual issue ever occured in practise.
* Much safer Python version check at cbmk startup, using data structures that
  are provided universally by all Python implementations, instead of
  relying on the output of `--version`.
* Set up Python in `PATH` when cbmk starts, to ensure that it is always
  version 3. This is checked at startup.
* `util/nvmutil`: Honour the `INSTALL` variable, if set by the user, otherwise
  it is set to `install` by default.
* `util/nvmutil`: Don't do `clean` when running `uninstall`.
* `util/nvmutil`: Proper DESTDIR/PREFIX handling, whereas it was not handled
  properly at all before.
* `util/nvmutil`: Only set CC/CFLAGS if unset, and use sensible defaults.
* Fixed various shellcheck errors in cbmk.
* Debian dependencies: replace liblz4-tool with lz4 and liblz4-dev. The latter
  is also available in Debian Trixie and Sid, at this time, in addition to
  Debian Bookworm, so it works on all of them.
* U-Boot (x86): Fixed a bug since Swig 4.3.0 changed the syntax for its
  language-specific AppendOut functions. A patch from upstream was backported,
  and the patch is also compatible with older versions of Swig.
* In cbmk scripts, use `command -v` instead of `which`, to find the locations
  of certain binaries. This is a bug fix, since `which` is non-standard and
  so could break on some setups.
* Crossgcc: when building it for coreboot, fix mismatching GCC/GNAT versions
  so that they match, if multiple versions are present. This was done because
  Debain Trixie initially had GCC 14 and GNAT 13, whereas we need GNAT to build
  the Intel video init code on  many mainboards.
* `dependencies/debian`: Fix the `python3-distutils` package, renamed it
  to `python3-distutils-extra`, which works on bookworm *and* newer, but the
  former did not.
* `git.sh`: don't initialise the `livepull` variable globally, reset it per
  target instead, to prevent some repositories from being wrongly re-cloned.
* Safer exit when running the `./mk dependencies` commands, so that cbmk is
  more likely to exit, because it was theoretically possible that it might
  not under certain edge cases.
* Add tarballs and gpg signatures to `.gitignore`

### General code cleanup

A large audit has been conducted, removing a lot of dead code in the build
system and improving the code quality considerably. Not all of such cleanup
changes are listed, because otherwise it'd overwhelm the changelog, and many
of the changes alone are quite pedantic, but together make a big change. You
can consult the Git log if you're more interested.

In descending order from the latest changes to the earliest changes:

* `init.sh`: Generally modularised it, moving separate tasks into separate
  functions, rathher than having it be one big monolith.
* `init.sh`: Several variables were moved out of this file and elsewwhere in
  cbmk.
* Moved the `singletree` function to `git.sh` instead of `lib.sh`
* Moved the `cbfs` function from `lib.sh` to `rom.sh`.
* `include/lib.sh`: Use a more top-down function order, more clear, and it was
  split into an extra file `init.sh` that does the most basic cbmk initialisation
  at startup, whereas what remains in `lib.sh` really are generic library
  functions used throughout cbmk.
* `include/git.sh`: Removed unused crossgcc linking feature, because we don't
  use it anymore (coreboot trees have their own crossgcc and never link to
  another these days). Canoeboot used to have many more coreboot trees, some
  of which re-used crossgcc from another tree. Similarly, the accompanying
  variable `tree_depend` is no longer handled. The `xtree` variable is still
  handled, because projects like U-Boot use that to configure crossgcc.
* include/git.sh`: Removed many redundant functions, merging several of them.
* Simplified many file checks in cbmk, by using the `e` function.
* Removed a bunch of useless `eval` commands in general, throughout cbmk,
  making the code much cleaner.
* cbmk: the `x_` function is now used much more aggressively, for error
  handling, simplifying error handling in cbmk overall.
* `mk` main script: Merged the `trees` script with it, so now it's all one
  script. The `mk` script is now the only executable script in cbmk.
* `mk` (main script): The `roms` command is removed (legacy / obsolete).
* The version/versiondate files are now dotfiles, to hide during operation.
* `include/lib.sh`: Hardcoded projectname/projectsite variables, instead
  of storing them in a file.
* `trees` script: Unified handling of flags (same string used in error output),
  to ensure that error(usage) messages always match.
* `trees` script (later merged into `mk`): Removed a lot of old bloat.
* `util/nvmutil`: Make the checksum word position a define. Generally cleaned
  up a lot of code to make it clearer for the reader. Added more verbose
  messages to the user, confirming things such as how much was read or written
  on the user's file system. Various miscallaneous bug fixes (edge cases that
  were unlikely to ever be triggered).
* `util/nvmutil`: More efficient use of memory when handling files.
* `util/nvmutil`: Much cleaner handling of user input.
* `util/nvmutil: More granular MAC address parsing errors, easy for debugging.
* `util/nvmutil`: Make the Gbe Checksum a define, for readibility.
* `util/nvmutil`: Obey the 79-character-per-line limit, as per cbmk coding
  style.
* `util/nvmutil`: Tidied up several pledge calls
* Removed use of several unnecessary subshells and `eval` statements in cbmk.
* `trees`: Later, the GCC/GNAT matching feature was rewritten to work both ways,
  where an older GCC was matched to GNAT and vice versa, whereas it previously
  only went one way. `gcc` and `gnat` are manipulated in `PATH` to ensure that
  the user has a consistent version of both.
* `path.sh` later merged into the `trees` script (which later merged
  into the main `mk` script). This `path.sh` is what contained the first
  implementation of the GNAT/GCC version matching feature.
* `path.sh`: Remove unnecessary shebang, and the same on other `include/`
  scripts. NOTE: `path.sh` was later merged into `lib.sh`, which then became
  split into `init.sh` in later changes (see above).
* Removed legacy build system commands e.g. `./build` and `./update`; now
  only the newer `./mk` commands are supported. This and the change below was
  briefly reverted, for the 20241207 revisions, but then re-introduced in
  preparation for this Canoeboot 25.04 release.

Git log
-------

This log is relative to Canoeboot 20241207:

```
* 9f53444f71 bring coreboot revs in sync with libreboot 25.04 
* 96c8dfa883 remove unused coreboot tree 
* d66cfa5644 add pico-sdk backport patch fixing gcc 14.x 
* b262db3b87 serprog: Remove pico2 support for the time being 
* 15efc268a1 seabios: bump to rev 9029a010, 4 March 2025 
* 973053479b update untitled 
* 2c97b272b8 coreboot413: add alper's fix to cbfstool for gcc15 
* bbe401f5f9 flashprog: bump to rev e060018 (1 March 2025) 
* 64385b0dd1 lib.sh: Provide printf for mktarball 
* 8a5603f98c seabios: Fix malloc_fn function pointer in romfile patch 
* 892b02a215 dependencies/debian: Fix libusb package name 
* db162c3662 init.sh: fix yet another double quote for dotfiles 
* 41dad0d2c2 u-boot: gru: Disable INIT_SP_RELATIVE 
* db79c0171e u-boot: arm64: Expand our modified defconfigs to full configs 
* f34dd5cf38 u-boot: arm64: Merge our modifications into new defconfigs 
* 99ade886e0 u-boot: arm64: Add new upstream defconfigs 
* a710f63df3 u-boot: arm64: Rebase to v2025.04 
* c3ae4a917d u-boot: arm64: Save our modifications to the upstream defconfigs 
* a576fa4570 u-boot: arm64: Turn configs into defconfigs 
* 34d134f2f2 init.sh: don't use eval to read version files 
* b63612871d init.sh: use backslash for dotfiles in eval 
* 7722e2f0d0 mk: Don't run mkhelpers if mode is set 
* d85ec327c3 mk: condense main() again 
* 4ff7cd3d77 init.sh: make git name/email error more useful 
* ec287ca69e init.sh: move git name/mail check to xbmk_git_init 
* f89e5ad87a init.sh: tidy up the git name/email check 
* 76d99b8cae mk: make main() more readable 
* f3caaf394e mk: move git check to init.sh xbmk_set_version 
* f30892e92f init.sh: tidy up xbmk_init() 
* cbf486789d mk: move git_init to init.sh 
* 2c39a2bc7b init.sh: minor cleanup 
* d6d8ee1d4b init.sh: clean up setvars 
* ef78f88117 init.sh setvars: make err a printf for eval 
* 3221ca7742 init.sh: merge xbmk_child_init with xbmk_init 
* 723e979c8c init.sh: split xbmk_child_init into functions 
* 0d86ef50ac init.sh: move parent fork to new function 
* 68d5660cca init.sh: Provide more complete error info 
* 6ebb11cf9c lib.sh: move _ua to the xbmkget function 
* 2c8570c07a move variables out of init.sh to others 
* 75f6b1cc1e lib.sh: rename vendor_checksum 
* 5a294b183e lib.sh: move singletree() to git.sh 
* 7943fab580 lib.sh: move cbfs() to rom.sh 
* a16d9f35a2 re-split include/init.sh to lib.sh 
* 6d54f46148 rename include/lib.sh to init.sh 
* cf961e00b7 lib.sh: introduce more top-down function order 
* 7dbd02fcd0 mk/git.sh: remove tree_depend variable 
* 7c6039a086 git.sh: remove unused xgcc linking feature 
* 2c419396d3 mk: remove unused variables (ser/xp) 
* f6d81c4751 mk: simplify main() 
* cc1b025df2 lib.sh: use realpath to get sys python on venv 
* e281ad8659 lib.sh: Force use of System Python to prevent hang 
* 88799b8db6 lib.sh: further condense the python check 
* 03ff6f38b9 lib.sh: further simplify the python check 
* 4d4ab8ce59 lib.sh: condense the python check 
* 87edc96778 lib.sh: simplify mk() 
* 63e07a44df lib.sh: simplify cbfs() 
* e18af2022a lib.sh: simplify the python check 
* f899a3225d mk: remove mkhelp() and use x_() instead 
* 6bd6f14a19 mk: simplify handling of trees() 
* 46e6169495 lib.sh: add missing copyright year 
* 7786ea4250 mk: don't print confirmation of git pkg.cfg 
* d9908ca648 lib.sh: Fix python3 detection when 'python' is python2 
* 8affdc0bcb Update the GRUB revisions 
* b665d09442 Revert "git.sh: minor cleanup" 
* ec25425e55 lib.sh: perform root check even earlier 
* dbf40653b2 lib.sh: tidy up opening logic (put it together) 
* 46fb5786e0 lib.sh: do root check before python check 
* 0fa1265106 git.sh: minor cleanup 
* c8c5a0e017 lib.sh: simplify mktarball() 
* 76e7c35ae2 mk: tidy up check_gnu_path() 
* 2fccddb9d0 mk: simplify check_project_hashes() 
* b399252309 lib.sh: fix missing s/TMPDIR/xbmktmp 
* 72c83cdaeb cbmk: don't handle TMPDIR directly 
* 86a96b22a5 rom.sh: minor cleanup 
* 374baddbcb inject.sh: yet even more code cleanup 
* e644717077 inject.sh: even more cleanup 
* ec24bc4915 inject.sh: minor cleanup 
* 5469f483fc git.sh: remove unnecessary comment 
* 991a98caec git.sh: remove link_crossgcc() 
* 1915c84376 git.sh: remove move_repo() 
* 515c1782ad git.sh: remove prep_submodule() 
* 519d93691f git.sh: make git_prep command clearer 
* ca0aab3bfe simplify a few file checks 
* 85b1996afa rom.sh: remove unnecessary check 
* c3910fbc5f cbmk: minor cleanup 
* 6fc23805cb lib.sh mktarball: stricter tar error handling 
* 58a17c8d15 mk check_project_hashes: handle error on sha512sum 
* d65d93b300 Revert "lib.sh: use eval for the command in x_" 
* 0aace67a54 lib.sh: fix bad eval writing version/versiondate 
* 7c98661271 lib.sh: use eval for the command in x_ 
* e63c14677f mk: use eval to run mkhelp commands 
* f4e5879534 mk: tidy up the switch/case block in main() 
* 85373b9b91 mk: tidier error handling 
* d0b95ffe6e lib.sh: tidy up the error handling 
* caaaf46540 rom.sh: tidy up error handling 
* 7bd9fb9a7b git.sh: clean up fetch_project() 
* 4d15c476b6 mk: Remove unnecessary argument checks on trees() 
* 94a8fa816f inject.sh: properly call err_ in fail_inject 
* ca6a3c8958 remove xbmk_parent, handle forking in lib.sh 
* f3c757c2d2 lib.sh: define x_ right after err_ 
* 2b9881639f mk: minor cleanup 
* 3b2718bd9d lib.sh: minor cleanup 
* 8999d30b96 rom.sh: minor cleanup 
* 32242cc03b inject.sh: tidy up check_release() 
* f439230604 inject.sh: tidy up xbmk_inject() 
* bbc28e73f8 inject.sh: tidy up readcfg() 
* cdcdadf097 inject.sh: tidy up patch_release_roms() 
* ff35a6a300 inject.sh: tidy up modify_mac_addresses() 
* 67c8338acf script/trees: merge with mk and delete script/ 
* d4dba9140c mk: remove the legacy "roms" command 
* 4cb9db2ba2 lib.sh: write version/versiondate to dotfiles 
* f0dcaca4ee lib.sh: hardcode projectname/projectsite 
* ba5487aa34 remove update symlink 
* 062e057e87 move build to mk 
* 02785da1af trees: unify the execution of mkhelper commands 
* 6405f92bd4 trees: tidy up configure_project() 
* 019b885cd8 build: make coreboot building an else in "roms" 
* f2f4aaefb7 trees: don't build dependencies if dry=":" 
* e5fefd8074 trees: unified handling of flags 
* 6696e69f01 trees: simplified handling of badhash/do_make 
* 28ef540e74 trees: don't set mode on ./mk -b 
* dd60b2ee84 trees: don't set mod on ./mk -d 
* c429fc8e3f trees: don't initialise mode to "all" 
* c5dacebe44 trees: clean up some comments 
* 8d27e6c786 inject.sh: simplified readkconfig() 
* ca5618628b inject.sh: replace xbmkpath with xbmkpwd 
* 9130750ebb lib.sh: double-quote pwd to prevent globbing 
* 12e600bf5c cbmk: unified PWD handling (work directory) 
* 891a7d8e63 lib.sh: initialise PATH if it's unset 
* 18689092d3 move XBMKPATH to include/lib.sh 
* dcc7f10ec7 cbmk: use pwd util, not PWD environmental variable 
* 6e6b54cc24 clean up a few semicolons in the build system 
* 7b7642dc90 trees: err if first argument is not a flag 
* c2ddb7cc1f trees: err if no argument given 
* aa306663c3 trees: set dry=":" on ./mk -f 
* e246c22953 trees: clean up initialisation of the dry variable 
* 0ee7f48c8c trees: initialise mode to "all", not "" 
* 1211636df2 trees: don't abuse the mode variable on -f 
* ec14ff58da trees: Add missing flag to error output 
* d7063fc20d cbmk: minor code formatting cleanup 
* 2c05e7e6ba grub/xhci: Remove unused patch 
* 112c756a70 util/nvmutil: remove excessive comments 
* b74a7f0cc6 Bump GRUB revision to add 73 security patches 
* bce7fceb56 Update pico-serprog revision 
* dca11e70ed util/nvmutil: Fix bad error messages on R/W 
* 1b9073b39b util/nvmutil: hardened pledge on help output 
* b52fc1fe66 deps/arch: genisoimage belongs to cdrtools 
* 3a3b935b8b util/nvmutil: only set mac_updated at the end 
* 438ebb1647 util/nvmutil: Fix bad comparison 
* a70ab825b9 util/nvmutil: allow ./nvm gbe MAC 
* 471ce4fbdc util/nvmutil: move "e" to swap() 
* db9f7cf588 util/nvmutil: Only read up to 4KB on larger gbe 
* 71f6b631e3 inject.sh: Don't show gbe filename on inject 
* d96d370754 util/nvmutil: fix minor mistake (line break) 
* 698b9ff63b util/nvmutil: do setmac if only filename given 
* a0d7c564fb util/nvmutil: don't say write not needed if errno 
* a5549b43f8 util/nvmutil: print dump *after* modification 
* 5540713d16 util/nvmutil: verbosely print the written MAC 
* bbdd985bea util/nvmutil: minor cleanup in cmd_dump 
* 7849f23f81 util/nvmutil: show nvm words written on writeGbe 
* 38bb650f12 util/nvmutil: clean up readonly check on writeGbe 
* ae5772e8f7 util/nvmutil: Remove useless gbeFileChanged var 
* 43e583d0b9 util/nvmutil: reset errno if any MAC updated 
* 4ea5484e02 util/nvmutil: reset errno when writing a MAC 
* 67ac52df84 util/nvmutil: show total number of bytes read 
* 97beb4305b util/nvmutil: rename tbw/bw to tnw/nw 
* 3c6198a780 util/nvmutil: err if bytes read lower than nf 
* 508509e4e5 util/nvmutil: err if fewer bytes written 
* 5c9edb8ffe util/nvmutil: Show bytes written in writeGbe 
* b44c311db7 util/nvmutil swap(): ensure that no overflow occurs 
* dcfde2e318 util/nvmutil: make swap() a bit clearer 
* 06f30b9543 util/nvmutil: make 0x3f checksum position a define 
* cac598f79e util/nvmutil: make 128 (nvm area) a define 
* d176b56c58 util/nvmutil swap(): Only handle the nvm area 
* 47d7283462 util/nvmutil: move write checks to writeGbe 
* b01995d167 util/nvmutil: make cmd_swap its own function again 
* 3dc1fedbe8 util/nvmutil: minor cleanup 
* e2be86695a util/nvmutil: allocate less memory for setchecksum 
* 741ef57efc util/nvmutil: Further reduce memory usage 
* af6d6d6d59 util/nvmutil: Remove unnecessary buf16 variable 
* 16d760d738 util/nvmutil: Only allocate needed memory for file 
* 6c2a8010e2 util/nvmutil: Remove unnecessary buffer 
* 252e2bdb71 util/nvmutil: Show specific error for bad cmd argc 
* 59942196a5 util/nvmutil: cleaner argument handling 
* 21400784de util/nvmutil: extreme pledge/unveil hardening 
* 8f99e386a4 util/nvmutil: more minor cleanup 
* 11eb4df755 util/nvmutil: more granular MAC parsing errors 
* dc376cca14 util/nvmutil: more cleanup 
* e6f4d11c5e remove errant comment in nvmutil 
* 90f2c22826 util/nvmutil: support 16kb and 128kb gbe files 
* fef744d68e util/nvmutil: Prevent unveil allowing dir access 
* d68d0a8d75 typo: nvme should say nvm in nvmutil.c 
* fe55e33254 util/nvmutil: General code cleanup 
* 232f6b8610 grub/xhci: Add xHCI non-root-hub fixes from Nitrokey 
* a6c9ebd11f add gnults-devel to fedora 41 dependencies 
* 1a3c74a974 grub.cfg: scan luks *inside lvm* 
* d74e906652 grub.cfg: Scan *every* LVM device 
* 302d116c28 snip 
* 3730a63edd Canoeboot 20250107 release 
* a223a0db89 update u-boot/grub/seabios version displays 
* 23db77a030 inject.sh: MAC address changer (not vendorfiles) 
* 514f61d6ba pico-sdk: Remove old, unnecessary patch 
* 465b18eff3 remove errant symlink 
* ec7e8d3a8f Bump coreboot/next to 2f1e4e5e85, 31 December 2024 
* 8829539531 rom.sh: don't run mkpicotool on dry builds 
* 62d655b8dd pico-sdk: Import picotool as a dependency 
* adf1a2e1a4 lib.sh: Much safer python version check 
* 1b1dae36d2 set up python in PATH, ensuring that it is python3 
* ac6b7c9e3a add libx86 to arch dependencies 
* 24aa70869e add less to arch dependencies 
* d731b07aa7 lib.sh: Set python after dependencies 
* d57303e080 update my copyright years on modified scripts 
* bf5979f0b2 lib.sh: Fix unescaped quotes in chkvars() 
* 9baf6a72a7 Revert "fix more unescaped quotes in eval" 
* c1dd3da298 fix more unescaped quotes in eval 
* caa18bdcb3 fix ./mk dependencies build issue 
* 43ab374ec7 rom.sh: Remove errant GRUB modules check 
* 2916aee7ab submodule/grub: use codeberg for 1st gnulib mirror 
* 8e30ea27ef util/nvmutil: Update AUTHORS and COPYING files 
* 376b1301f5 util/nvmutil: Describe nvmutil in help output 
* da32fe1928 util/nvmutil: Remove the correct binary on uninstall 
* 54809f06bf util/spkmodem-recv: More correct Makefile 
* ac6f3884ad util/nvmutil: Honour the INSTALL variable 
* e993212146 util/nvmutil: Don't clean when doing uninstall 
* 21c87a6fbf util/nvmutil: Proper DESTDIR/PREFIX handling 
* 5ed1114443 util/nvmutil: Set CC and CFLAGS only if unset 
* 1e494f4530 util/nvmutil: Capitalise BABA 
* ba71891687 util/nvmutil: Add uninstall to Makefile 
* 1310c9a58c util/nvmutil: Add distclean to Makefile 
* faa78f53c2 util/nvmutil: Make the GbE checksum a define 
* 227c396ca2 util/nvmutil: nicer hexdump display 
* 07e8b9f35e util/nvmutil: show the correct hexdump order 
* 76d87782a8 lib.sh mktarball: cleaner if statement 
* 3d1fea0977 fix lbmk shellcheck errors 
* 4862f6a348 lib.sh and rom.sh: update my header 
* 8bdfd31498 rom.sh: handle tarballs in mkcoreboottar 
* 13194ec94a util/nvmutil: Obey the 79-character per line limit 
* ce0fdf183d util/nvmutil: Tidy up copyright header 
* f3feac0728 util/nvmutil: Fix another straggler 
* 145ff612c1 util/nvmutil: Tidy up pledge calls 
* 4a83659885 compile rmodtool alongside cbfstool 
* a22f272dfe fedora41/dependencies: add libuuid-devel 
* de26e984df add uuid-devel to fedora41 dependencies 
* 4ce13dab7a support ./mk dependencies fedora reinstall 
* 9d60470a97 fix missing semicolon in grub nvme patch 
* 2d860d6f66 bump seabios to rev 1602647f1 (7 November 2024) 
* 5d82a911b9 Bump GRUB revision to 6811f6f09 (26 November 2024) 
* b75d32be72 flashprog: Disable -Werror 
* 22206cadeb bump flashprog to revision eb2c041 (14 Nov 2024) 
* 1ebdb20d97 replace liblz4-tool with lz4 and liblz4-dev 
* 012f530656 lib.sh dependencies: support --reinstall argument 
* 33206cae60 move xbmkpath to XBMK_CACHE/ 
* 4a4f7abf0e Revert "Remove legacy update/vendor commands" 
* 71bccad345 Fix U-Boot build issue with Swig 4.3.0 
* 2608bea771 use command -v instead of which 
* 3dc3a557db trees: remove unnecessary subshell 
* dbf8bef5ff trees: only symlink host gcc/gnat to build xgcc 
* cd93e1b615 trees: correction on check_gnu_path 
* 57fafb0b73 trees: match gcc/gnat versions both ways 
* f167d4aeb9 Merge path.sh into script/trees 
* 444154c002 path.sh: Further cleanup 
* c25ea91783 path.sh: More thorough gcc/gnat version check 
* 12221b2828 path.sh: minor cleanup 
* 02b1a45c6b path.sh: remove unnecessary shebang 
* 5a5a7c37f5 Fix globbing issue in cbmk 
* 69c5f8911d remove auto-confirm on distro dependencies 
* 7ee6ec0ce9 Mitigate Debian Trixie/Sid GCC/GNAT version mismatch 
* f1d9ecc468 rom.sh: Name pico directory serprog_pico 
* bb6c31aa16 add 2024 to Riku's copyright header on rom.sh 
* 3d738af507 pico-sdk: update to 2.1.0 
* fa6ed8816e pico-serprog: enable building for multiple pico chips 
* 31a0ea3537 add spdx headers to various config files 
* dd6f914186 git.sh: don't initialise livepull globally 
* 417accd9e0 lib.sh: Support copying files locally 
* 7b8bda9977 lib.sh: Safer exit from ./mk dependencies 
* 63eb43ec39 dependencies/void: add missing escape character 
* daefe4f895 rom.sh: support grub-first setups 
* 73920cb0a1 rom.sh: insert grub background in cbfs not memdisk 
* 5ebeb65cbf add tarballs and signatures to gitignore 
* 5053354644 fix another very stupid mistake 
* df509aac63 fix the stupidest bug ever 
```

This is nearl 300 changes since the 20241207 release!
