---
title: Часті питання
x-toc-enable: true
...

Також відомо як Відповіді на часті питання

Важливі питання
---------------

### Як скомпілювати Canoeboot з джерельного коду

Зверніться до [інструкцій зі збірки cbmk](docs/build/).

### Як працює система збірки?

Зверніться до [посібника з обслуговування cbmk](docs/maintain/).

### Не використовуйте CH341A!

Цей програматор SPI пошкодить ваш чіп і материнську плату, до якої він
підключений.

Прочитайте примітки щодо CH341A на [docs/install/spi.md](docs/install/spi.md), щоб
вивчити більше.

### Flashprog скаржиться на доступ DEVMEM

Якщо запущено `flashprog -p internal` для програмної перепрошивки та
ви отримуєте помилку, пов'язану з доступом до /dev/mem, вам слід перезавантажити систему з
параметром ядра `iomem=relaxed` перед виконанням flashprog, або використовуйте ядро,
для якого не ввімкнено `CONFIG_STRICT_DEVMEM` та `CONFIG_IO_STRICT_DEVMEM`.

Приклад виводу flashprog з обома `CONFIG_STRICT_DEVMEM` та `CONFIG_IO_STRICT_DEVMEM` ввімкненими:
```
flashprog v0.9.9-r1955 on GNU/Linux 4.11.9-1-ARCH (x86_64)
flashprog is free software, get the source code at https://flashprog.org

Calibrating delay loop... OK.
Error accessing high tables, 0x100000 bytes at 0x000000007fb5d000
/dev/mem mmap failed: Operation not permitted
Failed getting access to coreboot high tables.
Error accessing DMI Table, 0x1000 bytes at 0x000000007fb27000
/dev/mem mmap failed: Operation not permitted
```

### Підсвічування в лівій частині екрана стає темнішим

Ми не знаємо, як визначити правильне значення ШІМ для використання в
coreboot, тому ми просто використовуємо стандартне в coreboot, який має
цю проблему на деяких CCFL панелях, але не LED панелях.

Ви можете вирішити цю проблему у своєму дистрибутиві, дотримуючись приміток на
[документація: контроль підсвічуванням](../docs/misc/#finetune-backlight-control-on-intel-gpus).

### Ethernet не працює на моєму X200/T400/X60/T60, коли я його підключаю 

Це спостерігалося в деяких системах, які використовують network-manager. Таке буває
як в оригінальному BIOS, так і в Canoeboot. Це примха в
обладнанні. У системах debian обхідним шляхом є перезапуск сервіса
мережі, коли ви підключаєте кабель ethernet:

	sudo service network-manager restart

На systemd ви можете спробувати:

	sudo systemctl restart network-manager

(назва служби може відрізнятися для вас, залежно від вашої
конфігурації)

### Мій KCMA-D8 або KGPE-D16 не завантажується з встановленим модулем PIKE2008

Завантаження Option ROM з модуля PIKE2008 на ASUS KCMA-D8
або KGPE-D16 викликає зависання системи під час завантаження. Можна використовувати
це в корисному навантаженні (якщо ви використовуєте корисне навантаження ядра linux, таке як linuxboot),
або завантажитись (з SeaGRUB та/або SeaBIOS) зі звичайного SATA, а потім використовувати
це в GNU/Linux. Ядро GNU/Linux здатне використовувати PIKE2008
модуль без завантаження Option ROM.

### Як зберегти журнали паніки ядра на ноутбуках Thinkpad?

Найпростіший спосіб зробити це за допомогою netconsole ядра
і відтворення паніки. Netconsole вимагає двох машин, тієї, що є
панічною (джерело) і той, яка отримуватиме журнали збоїв (ціль). Джерело
має бути підключеним кабелем ethernet, а ціль також бути доступною
під час паніки. Щоб налаштувати цю систему, виконайте
наступні команди як root на джерелі (`джерело#`) і звичайний користувач
на цілі (`ціль$`):

1.  Запустіть сервер слухача на цільовій машині (netcat працює добре):

	`ціль$ nc -u -l -p 6666`

2.  Монтуйте configfs (тільки один раз на завантаження, ви можете перевірити, чи він уже змонтований
    з `mount | grep /sys/kernel/config`. Це не поверне результат,
    якщо це не так).

	`джерело# modprobe configfs`

	`джерело# mkdir -p /sys/kernel/config`

	`джерело# mount none -t configfs /sys/kernel/config`

3.  знайдіть назву інтерфейсу ethernet джерела, вона має мати форму `enp*` або
    `eth*`, дивіться вивід `ip address` або `ifconfig`.

	`джерело# iface="enp0s29f8u1"` змініть це

    Заповніть адресу IPv4 цільової машини тут:

	`джерело# tgtip="192.168.1.2"` змініть це


4.  Створіть ціль журналювання netconsole на вихідній машині:

	`джерело# modprobe netconsole`

	`джерело# cd /sys/kernel/config/netconsole`

 	`джерело# mkdir target1; cd target1`

	`джерело# srcip=$(ip -4 addr show dev "$iface" | grep -Eo '[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+')`

	`джерело# echo "$srcip" > local_ip`

	`джерело# echo "$tgtip" > remote_ip`

	`джерело# echo "$iface" > dev_name`

	`джерело# arping -I "$iface" "$tgtip" -f | grep -o '..:..:..:..:..:..' > remote_mac`

	`джерело# echo 1 > enabled`

5.  Змініть рівень журналу консолі на налагодження:

	`джерело# dmesg -n debug`

6.  Перевірте, чи працює журнал, наприклад, вставленням або вийманням USB-
    пристроїв на джерелі. 
    Має з'явитись кілька рядків в терміналі, у якому ви запустили netcat (nc), на цільовому хості.

7.  Спробуйте відтворити паніку ядра.

Апаратна сумісність
-------------------

### Які системи сумісні з Canoeboot?

Будь-яку систему можна легко додати, тому *сумісність* посилається до будь-якої
інтегрованої до системи побудови `cbmk` плати, яку Canoeboot використовує.

The [installation page](docs/install/) lists compatible machines.

### Пастки свободи з сучасним обладнанням Intel {#intel}

Coreboot номінально є вільним програмним забезпеченням, але для більшості x86
цілей, які він підтримує, потрібні двійкові блоби, як на Intel, так і на AMD.

#### Intel Management Engine (ME) {#intelme}

ПРИМІТКА: Інформація нижче трохи застаріла. Зараз Intel ME не
працює на співпроцесорі ARC, а працює на архітектурі модифікованого процесора Intel 486,
з прошивкою ME, написаною для x86 на основі операційної системи Minix.
Однак загальна філософія дизайну та функціонування в основному є тою
самою.

На *більшості* сучасних платформ Intel, які мають Intel ME, зараз можливо відключити
Intel ME після BringUp. Дивіться:

<https://github.com/corna/me_cleaner>\

На всіх ноутбуках GM45+ICH9M, які мають Intel ME (крім того, це означає настільні комп'ютери
X4X+ICH10), прошивка ME не потрібна у завантажувальній флеш-пам'яті. Або використовується
модифікований дескриптор, який вимикає ME та видаляє регіон для нього
в завантажувальній флеш-пам'яті, або використовується налаштування без дескрипторів. Проте всі сучасні
платформи Intel в іншому випадку вимагають наявності образа Intel ME в основній завантажувальній
флеш-пам'яті.

Тепер до основної теми:

Представлений в червні 2006 року в сімействі чіпсетів Intel 965 Express контролерів-
концентраторів (графіки та) пам'яті, або (G)MCH, і сімейство контролерів ICH8 I/O,
Intel Management Engine (ME) є окремим
обчислювальним середовищем, фізично розташованим в чіпі (G)MCH. У третьому кварталі 2009 року,
перше покоління процесорів Intel Core i3/i5/i7 (Nehalem) і п'ята серія
сімейства чіпсетів концентраторів-контролерів платформи, або PCH, принесли
більш тісно інтегрований ME (зараз версії 6.0) всередині чіпа PCH,
який сам по собі замінив ICH. Таким чином, ME ***присутній на всіх настільних,
мобільних (ноутбуки) та серверних системах з середини 2006 року***.

ME складається з ядра процесора ARC (замінено іншими ядрами процесора
в наступних поколіннях ME), кеша коду та даних, таймера
і безпечної внутрішньої шини, до якої підключаються додаткові пристрої,
включаючи механізм криптографії, внутрішні ROM та RAM, контролери
пам'яті та ***механізм прямого доступу до пам'яті (DMA)*** для доступу до
пам'яті операційної системи хоста, також щоб зарезервувати регіон
захищеної зовнішньої пам'яті для доповнення обмеженої внутрішньої оперативної пам'яті ME.
ME також має ***доступ до мережі*** з власною MAC-адресою через
контролер Intel Gigabit Ethernet. Його програма завантаження, збережена на внутрішній
ROM, завантажує "маніфест" прошивки з чіпа флеш-пам'яті SPI ПК.
Цей маніфест ***підписано надійним криптографічним ключем***,
який відрізняється між версіями мікропрограми ME. Якщо маніфест
не підписано певним ключем Intel, завантажувальна ROM не завантажиться і не
виконається прошивка, і ядро процесора ME буде зупинено.

Прошивка ME стиснена та складається з модулів, перелічених в
маніфесті, разом із безпечними криптографічними хешами їх змісту.
Одним модулем є ядро операційної системи, яке базується на
***пропрієтарному ядрі операційної системи реального часу (RTOS)***, під назвою
"ThreadX". Розробник, Express Logic, продає ліцензії і джерельний
код для ThreadX. Клієнтам, таким як Intel, заборонено розголошувати
або виконувати субліцензіювання джерельного кода ThreadX. Іншим модулем є
Dynamic Application Loader (DAL), який складається з ***віртуальної машини Java***
та набора передвстановлених класів Java для криптографії, безпечного зберігання і
так далі. Модуль DAL може завантажувати та виконувати додаткові модулі ME з
HDD або SSD ПК. Прошивка ME також містить ряд нативних
модулів додатків у своєму просторі флеш-пам'яті, включаючи Intel
Active Management Technology (AMT), реалізації Trusted
Platform Module (TPM), Intel Boot Guard, аудіо та відео DRM
системи.

Програма Active Management Technology (AMT), частина бренда Intel
"vPro", є веб-сервером і програмним кодом, що дозволяє віддаленим
користувачам вмикать, вимикать, дивиться інформацію та тощо
керувати ПК. Це може ***використовуватись дистанційно, навіть коли ПК
вимкнено*** (через Wake-on-Lan). Трафік зашифровано з використанням бібліотек SSL/TLS,
але пам'ятайте, що всі основні реалізації SSL/TLS мали дуже
оприлюднені вразливості. Сама програма AMT має ***[відомі
вразливості](https://uk.wikipedia.org/wiki/Active_Management_Technology#Проблеми_безпеки)***,
які використовувалися для розробки руткітів і кейлоггерів, а також таємного
отримання зашифрованого доступа до функцій керування ПК.
Пам'ятайте, що ME має повний доступ до оперативної пам'яті ПК. Це означає, що
зловмисник, який використовує будь-яку з цих вразливостей, може отримати доступ до
всього на ПК: усі відкриті файли, усі працюючи
програми, усі натиснуті клавіши, тощо.

[Intel Boot Guard](https://mjg59.dreamwidth.org/33981.md) є застосунком ME,
представленим у другому кварталі 2013 року з мікропрограмою ME, версії 9.0 на четвертому
поколінні процесорів Intel Core i3/i5/i7 (Haswell). Це дозволяє виробникам комплектного обладнання для ПК
згенерувати асиметричну криптографічну пару ключів, встановити публічний ключ
в ЦП і запобігти ЦП від запуску завантажувальної мікропрограми, яка не підписана
з їх приватним ключем. Це означає, що ***coreboot та Canoeboot
неможливо перенести*** на такі ПК, без приватного ключа підпису
OEM. Зверніть увагу, що системи, зібрані з придбаних окремо материнської плати
та ЦП залишаються незмінними, оскільки постачальник материнської
плати (на якій зберігається завантажувальна прошивка) не може вплинути на
публічний ключ, що зберігається в ЦП.

Прошивка ME версій 4.0 та пізніше (Intel серії 4 та пізніші чіпсети)
включає програму ME для ***аудіо та відео
[DRM](https://defectivebydesign.org/what_is_drm_digital_restrictions_management)***
під назвою "Захищений аудіо-відеошлях" (PAVP). ME отримує від операційної системи хоста
зашифрований медіа-потік і зашифрований ключ,
розшифровує ключ і надсилає розшифрований ключ до
GPU, яка потім розшифровує медіа. PAVP також використовується іншим ME
застосунком, щоб намалювати розкладку PIN-код аутентифікації прямо на екрані.
У цьому випадку програма PAVP безпосередньо керує графікою, що
з'являється на екрані ПК, таким чином, що хостова ОС не може виявити. Версія прошивки ME
7.0 на PCH з процесорами Intel Core i3/i5/i7
(Sandy Bridge) 2-го покоління замінює PAVP подібним застосунком DRM під назвою
"Intel Insider". Як і програма AMT, ці програми DRM,
які самі по собі дефектні за задумом, демонструють всемогутність можливості
ME: це обладнання та його пропрієтарна мікропрограма можуть отримати доступ і контролювати
все, що є в оперативній пам'яті і навіть ***все, що
відображається***.

Intel Management Engine із власною мікропрограмою мають завершений
доступ до і контроль над ПК: він може вмикати або вимикати ПК,
читати всі відкриті файли, перевіряти всі запущені програми, відстежувати всі натиснуті
клавіши та рухи миші і навіть записувати або відображати зображення на
екрані. І він має мережевий інтерфейс, який явно незахищений,
що може дозволити зловмиснику в мережі ін'єктувати руткіти, які
повністю компрометують ПК і повідомляють зловмиснику про всю
активність, яка відбувається на ПК. Це загроза свободі, безпеці та
приватності, яка не може бути проігнорована.

До версії 6.0 (тобто в системах 2008/2009 і раніше),
ME можна вимкнути, встановивши пару значень у флеш-пам'яті SPI.
Прошивку ME потім можна повністю видалити з простору флеш-
пам'яті. Проект Canoeboot [робить це](docs/install/ich9utils.md) на
системах Intel серії 4, які він підтримує, наприклад [ThinkPad
X200](../docs/install/x200.uk.md) та [ThinkPad
T400](../docs/install/t400.md). Прошивка ME версії 6.0 та
пізніше, яка є на всіх системах з процесорами Intel Core i3/i5/i7
PCH, включає мікропрограму "ME Ignition", яка виконує деяку апаратну
ініціалізацію та контроль живленням. Якщо завантажувальний ROM ME не знаходить
в флеш-пам'яті SPI маніфест прошивки ME з дійсним підписом Intel,
весь ПК буде вимкнено через 30 хвилин.

Завдяки перевірці підпису, розробка вільної заміни
для ME в принципі неможлива. Єдина сутність, здатна замінити
прошивку ME - Intel. Як зазначалось раніше, мікропрограма ME містить
пропрієтарний код, ліцензованим третіми сторонами, тому Intel не змогла би
випустити джерельний код, навіть якщо вони би цього хотіли. І навіть якщо вони розробили би повністю
нову прошивку ME без стороннього пропрієтарного коду і
випустили би джерельний код, завантажувальна ROM ME відхиляла би змінену
прошивку, яка не підписана Intel. Таким чином, прошивка ME є і
безнадійно пропрієтарною, і "тивоізованою".

**Підсумовуючи, Intel Management Engine і його програми є
лазівкою з повним доступом до та контролем над рештою ПК.
ME є загрозою свободі, безпеці та конфіденційності, і проект Canoeboot
наполегливо рекомендує повністю уникати цього. З останніх версій
його не можна видалити, це означає уникати всіх останніх поколінь обладнання
Intel.**

У *вищому* параграфі йдеться про використання *повної* прошивки Intel ME,
що містить мережевий код і в особливості *Active Management
Technology* (AMT).

Більше інформації про Management Engine може бути знайдено на різноманітних веб-
сайтах, включаючи [me.bios.io](http://me.bios.io/Main_Page),
[unhuffme](http://io.netgarage.org/me/), [coreboot
wiki](http://www.coreboot.org/Intel_Management_Engine), та
[Wikipedia](https://uk.wikipedia.org/wiki/Intel_Active_Management_Technology).
Книга ***[Platform Embedded Security Technology
Revealed (Розкрито вбудовану технологію безпеки платформи)](https://www.apress.com/9781430265719)*** чудово описує в
значних подробицях архітектуру апаратного забезпечення ME та прикладні модулі мікропрограми.

#### Firmware Support Package (FSP) {#fsp}

У всіх останніх системах Intel, підтримка coreboot обертається навколо
інтеграції блоба (для кожної системи) під назвою *FSP* (Firmware Support Package, пакет підтримки
мікропрограми), який обробляє всю ініціалізацію обладнання, включаючи
пам'ять та ініціалізацію ЦП. Зворотня розробка та заміна цього
блоба майже неможлива через те, наскільки він складний. Навіть для найбільш
кваліфікованого розробника, на заміну знадобяться роки. Intel розповсюджує
цей блоб серед розробників прошивки, без джерела.

Оскільки FSP відповідає за ранню ініціалізацію обладнання, це означає,
що він також підтримує SMM (System Management Mode, режим системного керування). Це особливий
режим, який працює нижче рівня операційної системи. **Це можливо, що руткіти
можуть бути реалізовані там, які можуть виконувати ряд
атак на користувача (список нескінченний). Будь-яка система Intel, яка
має пропрієтарний блоб FSP взагалі не може бути довіреною.** Фактично, декілька
руткітів SMM було продемонстровано в природі (використайте пошукову систему,
щоб знайти їх).

#### Оновлення мікрокода ЦП {#microcode}

Мікрокод налаштовує логічні вентилі у вашому ЦП, щоб реалізувати архітектуру
набору інструкцій. Ваш ЦП уже містить їх, але він також надає спосіб оновлення
мікрокоду під час завантаження, виправляючи помилки та значно підвищуючи
загальну надійність вашої системи.

У цьому цікавому відео розповідається про те, як група людей
провела зворотню розробку мікрокода на процесорах AMD:

<https://yewtu.be/watch?v=W3FbTMqYi4U>

Репозиторій git для цього проекту тут:

<https://github.com/RUB-SysSec/Microcode>

І відео, і репозиторій дають деяку додаткову інформацію про мікрокод
ЦП. Те, як це працює на AMD, буде дуже схожим на Intel.

### Підводні камені свободи, які слід враховувати на апаратному забезпеченні AMD {#amd}

AMD має більш-менш ту саму проблему, що й Intel, коли справа
стосується свободи програмного забезпечення.

#### AMD Platform Security Processor (PSP) 

По суті, це власна версія [Intel Management
Engine](#intelme) від AMD. Він має ті самі базові проблеми безпеки та свободи,
хоча реалізація кардинально відрізняється.

Процесор безпеки платформи (Platform Security Processor, PSP) вбудовано в процесори AMD,
[архітектура](https://en.wikipedia.org/wiki/List_of_AMD_CPU_microarchitectures) яких пізня родини 16h (Puma), Zen 17h або пізніше (а також у
графічні процесори AMD GCN 5-го покоління (Vega) або пізніше). На процесорах PSP
контролює запуск основного ядра x86. Прошивка PSP має криптографічний підпис
надійним ключем, подібно до Intel ME. Якщо вбудована прошивка PSP
відсутня або ключ підпису AMD відсутній, ядра x86 не
будуть відпущені з перезавантаження, що призведе до непрацездатності системи.

PSP - це ядро ARM із технологією TrustZone, вбудоване в головний
процесор. Таким чином, він має можливість приховувати власний програмний код,
скидати оперативну пам'ять і будь-які дані, які він міг взяти та зберегти з
менш привілейованої системної оперативної пам'яті x86 (ключі шифрування ядра, дані входу,
історія перегляду, натискання клавіш, хто знає!). Що ще гірше,
PSP теоретично має доступ до всього простору системної пам'яті (AMD
або не буде, або не зможе заперечити це, і це, здається, потрібно,
щоб "функції" DRM могли працювати належним чином), що означає, що він має
принаймні доступ на основі MMIO до мережевих контролерів та будь-яких інших
периферійних пристроїв PCI/PCIe, встановлених у системі.

Теоретично будь-який зловмисник, який має доступ до ключа підпису AMD міг
би встановити стійке зловмисне програмне забезпечення, яке не можливо було би викорінити
без обладнання для зовнішньої прошивки та завідомо справного образу PSP. Крім того,
у мікропрограмному забезпеченні AMD у минулому було продемонстровано численні вразливості системи безпеки,
і є всі підстави припускати, що одна або декілька вразливостей нульового дня
ховаються в мікропрограмному забезпеченні PSP. Враховуючи надзвичайний рівень
привілеїв (кільце -2 або кільце -3) PSP, зазначені уразливості матимуть
можливість віддалено відстежувати та контролювати будь-яку машину з підтримкою PSP
абсолютно поза знаннями користувача.

Подібно до Intel Boot Guard (додаток Intel
Management Engine), PSP від AMD також може діяти як тиран, перевіряючи
підписи будь-якої завантажувальної мікропрограми, яку ви прошиваєте, унеможливлюючи заміну
завантажувальної мікропрограми (наприклад, canoeboot, coreboot) на деяких платах. Ранні
неофіційні повідомлення свідчать про те, що аналог AMD boot guard буде використовуватися
на більшості апаратного забезпечення OEM, відключений лише на так званих процесорах
"ентузіастів".

#### Прошивка AMD IMC

Прочитайте <https://www.coreboot.org/AMD_IMC>.

ПРИМІТКА: Ця секція є застарілою, та потребує очищення.

#### Прошивка AMD SMU

ПРИМІТКА: Ця секція є застарілою, та потребує очищення.

Керує деякими функціями керування живленням для пристроїв PCIe (без цього ваш ноутбук
не працюватиме належним чином) і кількома іншими функціями,
пов'язаними з керуванням живлення.

Мікропрограма підписана, хоча на старішому апаратному забезпеченні AMD це симетричний
ключ, що означає, що з доступом до ключа (у разі витоку) ви можете підписати
свою власну модифіковану версію та запустити її. Рудольф Марек (хакер coreboot)
дізнався, як видобути цей ключ [у цій відео
демонстрації](https://media.ccc.de/v/31c3_-_6103_-_en_-_saal_2_-_201412272145_-_amd_x86_smu_firmware_analysis_-_rudolf_marek),
і на основі цієї роботи, Демієн Замміт (інший хакер coreboot)
[частково замінив її](https://github.com/zamaudio/smutool/) вільною
прошивкою, але у відповідній системі (ASUS F2A85-M) все ще були присутні
інші блоби (Відео BIOS та інші).

#### Прошивка AMD AGESA 

ПРИМІТКА: Більше має бути написано про це, щоб відобразити сучасну реальність.
Ситуація з AMD в останні роки змінилась. Інформація на цій сторінці поширених
запитань застаріла кілька років тому.

Це відповідає практично за всю ініціалізацію основного обладнання в
сучасних системах AMD. У 2011 році AMD почала співпрацювати з проектом coreboot,
випустивши це як джерельний код під вільною ліцензією. В 2014 році
вони припинили випускати джерельний код і замість цього почали випускати AGESA у вигляді
бінарних блобів. Це робить AGESA еквівалентом [Intel FSP](#fsp).

#### Оновлення мікрокоду ЦП AMD

Прочитайте розділ Intel 
практично так само, хоча було виявлено, що з набагато пізнішим апаратним забезпеченням
AMD можна працювати без оновлень мікрокоду. Невідомо, чи потрібні оновлення на всіх
платах AMD (залежить від ЦП).

Проект Canoeboot не розцінює оновлення мікрокоду проблемою, і він
вмикає їх за замовчуванням на всьому апаратному забезпеченні,
яке підтримується.

#### AMD не співпрацює

Здавалося, що AMD була на правильному шляху в 2011 році, коли вони почала
співпрацювати та випускати джерельний код для кількох критичних
компонентів для проекту coreboot. Цьому не було бути. З так званих
економічних причин вони вирішили, що більше не варто витрачати час на інвестування
в проект coreboot. На жаль, вони навіть не поділилися джерельним
кодом бібліотеки AGESA для архітектур сімейства 15h Steamroller/Excavator
(які, як і попередні fam15h Bulldozer/Piledriver, не
мають PSP) і випустили його для проекту coreboot лише як двійковий файл.

Перехід компанії від такої хорошої до такої поганої лише за 3 роки
свідчить, що з AMD щось серйозно не так. Подібно Intel, вони
не заслуговують ваших грошей.

Враховуючи поточний стан апаратного забезпечення Intel з Management Engine, ми
вважаємо, що все продуктивне апаратне забезпечення x86, новіше, ніж ЦП AMD
Family 15h (на стороні AMD) або будь-яке інше, випущене після 2009 року на стороні Intel
є дефектним за своєю конструкцією і не може бути безпечно використаним для зберігання, передачі
або обробки конфіденційних даних. Конфіденційні дані - це будь-які дані, у яких
порушення може завдати значної економічної шкоди суб'єкту, який створив
або був відповідальний за збереження цих даних, тому це включатиме банки,
компанії, що видають кредитні картки, або роздрібних продавців (записи рахунків клієнтів), в
додаток до "звичайних" інжинірингових фірм та фірм з розробки програмного забезпечення.
Це також стосується викривачів або будь-кого, кому потрібна справжня конфіденційність та
безпека.

### Привіт, у мене &lt;вставте сюди випадкову систему&gt;, чи підтримується вона?

Якщо в coreboot бракує підтримки для вашого апаратного забезпечення, ви мусите додати підтримку для нього.
Будь-ласка, проконсультуйтесь з проектом coreboot для наставництва.

Загальні питання
----------------

### Як встановити Canoeboot?

Подивіться [посібник з встановлення](docs/install/)

### Як запрограмувати флеш-чіп SPI?

Зверніться до:\
[Зовнішній перезапис 25xx NOR flash через протокол SPI](docs/install/spi.md)

Можна використовувати 16-контактний затискач SOIC на 8-контактній мікросхемі SOIC, якщо
правильно впорядкувати контакти. Як правило, з'єднання більш міцне.

### Як захистити флеш-чіп від запису?

За замовчуванням немає захисту від запису на системі Canoeboot. Це
з міркувань зручності використання, оскільки більшість людей не мають легкого доступу до зовнішнього
програматора для перепрошивання їх мікропрограми, або вони знаходять
незручним використання зовнішнього програматора.

У деяких системах можна захистити мікропрограму від запису, щоб вона
була доступна лише для читання на рівні ОС (зовнішнє перепрошивання все ще
можливе за допомогою спеціального обладнання). Наприклад, на сучасних ноутбуках GM45
(таких як, ThinkPad X200, T400) можна захистити від запису (див.
[утиліту ICH9 gen](docs/install/ich9utils.md#ich9gen)).

Захист від запису можна встановити на всіх системах Canoeboot, але інструкції
потрібно написати. Документація знаходиться в основному репозиторії git, тому ви можете
надсилати виправлення, додаючи ці інструкції.

ЗРОБИТИ: Задокументувати захист флеш-пам'яті на основі PRx на платформах Intel і дослідити інші
методи на системах AMD.

### Як змінити налаштування BIOS?

Більшість налаштувань Canoeboot насправді використовує [корисне навантаження
GRUB](http://www.coreboot.org/GRUB2). Більше інформації про корисні навантаження
може бути знайдено на
[coreboot.org/Payloads](http://www.coreboot.org/Payloads). SeaBIOS також
доступний. Конфігурацію *CMOS* жорстко закодовано в Canoeboot.

Проект Canoeboot успадковує модульну концепцію корисного навантаження від coreboot, що
означає, що програми *налаштування BIOS* не дуже
практичні. Coreboot (та Canoeboot) включає утиліту, названу
*nvramtool*, яка може бути використана для зміни деяких налаштувань. Ви можете знайти
nvramtool у *coreboot/util/nvramtool/*, в архівах джерельного коду
Canoeboot.

Параметр *-a* у nvramtool покаже список доступних параметрів, і *-w*
може бути використано для їх зміни. Зверніться до документації nvramtool на
coreboot вікі для більшої інформації.

На практиці, у більшості випадків, вам не потрібно змінювати жодні з цих
налаштувань.

Налаштування Canoeboot за замовчуванням блокують таблицю CMOS, щоб забезпечити узгоджену функціональність
для всіх користувачів. Ви можете використовувати:

	nvramtool -C вашаROM.rom -w деякеналаштування=деякезначення

Щоб отримати повний список доступних опцій, зробіть це:

	nvramtool -C вашаROM.rom -a

Це змінить за замовчуванням всередині образа ROM, і потім ви можете
перепрошити його.

### Як заповнити ROM перед перепрошивкою?

Бажано просто використовувати більший образ ROM. Цей розділ був написаний здебільшого для
материнських плат ASUS KCMA-D8 та KGPE-D16, де раніше ми надавали
тільки образи ROM розміром 2 MБ у Canoeboot, але тепер ми надаємо образи ROM розміром 16 МБ.
Інші розміри не надаються, оскільки на практиці хтось, оновлюючи один із
цих чіпів, використовуватиме лише 16 МБ. Доступні більші розміри, але 16 МБ
це максимум, який ви можете використати на всіх підтримуваних системах Canoeboot, які
використовують флеш-пам'ять SPI.

Необхідно для ROM, де образ ROM менший за флеш-чіп
(наприклад, запис 2 МБ ROM на флеш-чіп 16 МБ).

Створіть порожній (00 байти) файл із різницею розміру між
ROM та флеш-чіпом. Випадок вище, наприклад:

	truncate -s +14MiB pad.bin

Для бездескрипторних x86 образів потрібно додавати *з початку* ROM:

	cat pad.bin вашrom.rom > вашrom.rom.new

Для ARM та x86 з intel flash descriptor, вам потрібно додавати після образу:

	cat вашrom.rom pad.bin > вашrom.rom.new

Прошийте отриманий файл. Зауважте, що cbfstool не зможе працювати
з образами, доповненими таким чином, тому обов'язково внесіть усі зміни до образу, включаючи
конфігурацію середовища виконання, перед доповненням.

Щоб видалити заповнення, наприклад, після зчитування його з флеш-чіпа,
просто скористайтеся dd(1), щоб вилучити лише незаповнену частину. Продовжуючи
наведені вище приклади, щоб видобути ROM без дескрипторів 2 МБ x86 із доповненого
образа 16 МБ, виконайте наступне:

	dd if=flashprogread.rom of=вашrom.rom ibs=14MiB skip=1

Після видалення заповнення cbfstool зможе працювати із образом як зазвичай.

### Чи потрібно встановлювати завантажувач під час встановлення дистрибутива?

Більшість налаштувань Canoeboot уже інтегрують завантажувач GRUB як
*[корисне навантаження](http://www.coreboot.org/Payloads)*. Це означає, що завантажувач GRUB
фактично *прошивається* як частина завантажувальної прошивки
(Canoeboot). Це означає, що вам не потрібно встановлювати завантажувач на
HDD або SSD під час встановлення нового дистрибутива. Ви зможете нормально завантажитися,
використовуючи завантажувач (GRUB), який знаходиться у мікросхемі флеш-пам'яті.

Це означає, що навіть якщо ви виймете жорсткий диск або твердотільний накопичувач, у вас всеодно
буде встановлено функціонуючий завантажувач, який можна використовувати для завантаження програми
встановлення дистрибутива з флеш-пам'яті USB. Див.
[Як інсталювати GNU/Linux у системі Canoeboot](../docs/linux/grub_boot_installer.md)

В даний час також передбачені інші корисні навантаження. Якщо ви використовуєте корисне навантаження SeaBIOS,
тоді на вашому HDD або SSD використовується звичайний завантажувальний сектор MBR, як і слід було
очікувати. Отже, наведені вище параграфи стосуються лише корисного навантаження GRUB.

### Чи потрібно мені перепрошивати, коли я перевстановлю дистрибутив?

Більше ні. Останні версії Canoeboot (з використанням корисного навантаження GRUB)
автоматично переключатимуться на конфігурацію GRUB на HDD або SSD, якщо
існує. Ви також можете завантажити іншу конфігурацію GRUB з будь-якого пристрою, який підтримується
GRUB (наприклад, флеш-накопичувач USB). Для
більшої інформації див.
[Змінення конфігурації GRUB в системах Canoeboot](../docs/linux/grub_cbfs.md)

Якщо ви використовуєте корисне навантаження SeaBIOS, це ще простіше. Це працює так, як ви
очікували. SeaBIOS реалізує звичайний інтерфейс x86 BIOS.

### Як виглядає флеш-чіп?

Ви можете знайти фотографії різних видів чипів на наступній сторінці:\
[Керівництво зовнішньої прошивки 25xx NOR](docs/install/spi.md)

### tlp

Ви можете встановити пакет `tlp` та розпочати той сервіс. Наприклад, на
Debian:

```
apt-get install tlp tlp-rdw
systemctl enable tlp
systemctl start tlp
```

Тепер прочитайте документацію:

```
man tlp-stat
```

Від імені root, ви можете зробити:

```
tlp-stat -b
```

Це надасть інформацію про батарею.

Яке ще мікропрограмне забезпечення існує за межами Canoeboot?
------------------------------------------------------

#### Зовнішні графічні карти

Відео BIOS наявний на більшості графічних карт. Для інтегрованої графіки
VBIOS (спеціальний вид OptionROM) зазвичай вбудовано
в основну завантажувальну прошивку. Для зовнішньої графічної карти VBIOS зазвичай
на самій графічній карті. Він зазвичай пропрієтарний; єдина
різниця в тому, що SeaBIOS може виконати це (як варіант, ви вбудовуєте це
в образ ROM coreboot і coreboot виконує його, якщо у вас
інше корисне навантаження, таке як GRUB).

*Проект coreboot* надає вільний код ініціалізації, на багатьох платах, і
Canoeboot буде використовувати цей код, коли він наявний, в залежності від конфігурації.

В конфігураціях, де SeaBIOS і власна ініціалізація GPU використовуються разом,
додається спеціальна прокладка VBIOS, яка використовує лінійний кадровий буфер coreboot.

#### Прошивка EC (вбудований контролер) 

Це є у більшості (всіх?) ноутбуків. EC (вбудований контролер) - це невеликий,
окремий процесор, який в основному обробляє вхідні/вихідні дані, характерні
для ноутбуків. Наприклад:

-   Коли ви натискаєте перемикач увімкнення/вимкнення радіо, EC увімкне/вимкне
    бездротові пристрої (wifi, bluetooth і так далі) і ввімкне/вимкне
    світлодіод, який вказує, чи це увімкнено, чи ні.
-   Слухає іншу мікросхему, яка виконує вимірювання показників температури, налаштовуючи
    швидкість вентилятора відповідним чином (або вмикає/вимикає вентилятор).
-   Отримує певні введення з клавіатури, напр. збільшення/зменшення яскравості,
    збільшення/зменшення гучності.
-   Визначати, коли кришка закрита або відкрита, і надсилати сигнал, що
    вказує на це.
-   Тощо.

EC присутній ледь не на всіх ноутбуках. Інші пристрої використовують, залежно від складності,
або EC, або варіант із прошивкою в Mask ROM - SuperIO.

#### Прошивка HDD/SSD

Жорсткі диски та твердотільні накопичувачі містять вбудоване програмне забезпечення,
призначене для обробки внутрішньої роботи пристрою, водночас відкриваючи простий, стандартний інтерфейс (наприклад,
AHCI/SATA), який програмне забезпечення ОС може використовувати, як правило. Ця прошивка є невидимою
для користувача накопичувача.

Жорсткі диски та твердотільні накопичувачі є досить складними, і сьогодні містять досить складне
обладнання, яке навіть здатне запускати цілу операційну систему (під цим ми маємо
на увазі, що сам диск здатний запускати свою власну вбудовану ОС), навіть
GNU/Linux або BusyBox/GNU/Linux.

SSD та HDD є особливим випадком, оскільки вони є постійними пристроями зберігання,
а також комп'ютерами.

Приклад атаки, яку може здійснити зловмисне програмне забезпечення: заміна ваших ключів SSH,
що дозволяє невідомому зловмиснику неавторизований віддалений доступ. Або, можливо,
підміна ваших ключів GPG. Диски SATA також можуть мати DMA (через
контролер), що означає, що вони можуть читать з системної пам'яті;
теоретично диск може мати власне приховане сховище, де він міг би читати ваші ключі
LUKS і зберігати їх у незашифрованому вигляді для майбутнього вилучення
загрозою.

З належним IOMMU та використанням USB замість SATA можна було б пом'якшити
будь-які проблеми, пов'язані з DMA, які можуть виникнути.

Було продемонстровано деякі докази концепцій. Для HDD:
<https://spritesmods.com/?art=hddhack&page=1> Для SSD:
<http://www.bunniestudios.com/blog/?p=3554>

Про існування життєздатної вільної заміни прошивки наразі невідомо. Для
SSD проект
[OpenSSD](https://web.archive.org/web/20220425071606/http://www.openssd-project.org/wiki/The_OpenSSD_Project)
може бути цікавим.

Очевидно, диски SATA самі по собі не мають DMA, але можуть використовувати його
через контролер. Це
<http://web.archive.org/web/20170319043915/http://www.lttconn.com/res/lttconn/pdres/201005/20100521170123066.pdf>
(сторінки 388-414, 420-421, 427, 446-465, 492-522, 631-638) і це
<http://www.intel.co.uk/content/dam/www/public/us/en/documents/technical-specifications/serial-ata-ahci-spec-rev1_3.pdf>
(сторінки 59, 67, 94, 99).

Згідно з цими приведеними документами, тип FIS 39h - це *"DMA Activate FIS
- Device to Host"*. У ньому згадується *"передача даних від хоста до
пристрою, і далі сказано: після отримання DMA Activate,
якщо контролер DMA адаптера хоста було запрограмовано та увімкнено, адаптер
хоста ініціює передачу Data FIS і передасть
в цьому FIS дані, які відповідають регіонам пам'яті хоста, вказані
контекстом контролера DMA."* FIS - це одиниця протоколу (Інформаційна
структура кадру, Frame Information Structure). Базуючись на цьому, здається, що накопичувач може повідомити
контролеру хоста, що він хоче, щоб відбувся DMA, але допоки програмне забезпечення хоста
не налаштувало або не хотітиме в майбутньому налаштувати передачу DMA,
нічого не відбудеться. **Диск також може відправити DMA Setup**. Якщо DMA
Setup FIS відправлено першим, з встановленим бітом Auto-Activate, тоді це
вже налаштовано, і диск може ініціювати DMA. Далі в документі йдеться
*"Отримавши DMA Setup, одержувач FIS повинен
перевірити отриманий запит на DMA Setup."* - іншими словами, хост
повинен перевірити; але, можливо, тут є помилка. Далі в документі
сказано *"Конкретна реалізація ідентифікатора буфера
та перевірки буфера/адреси не визначена"* - тому ніхто
насправді не буде турбуватися. *"отримувач FIS"* - у випадку, який ми
розглядаємо, це обладнання хост-контроллера в чіпсеті та/або
драйвер ядра (швидше за все, драйвер ядра). Всі пристрої SATA мають
мікропрограму, з можливістю оновлення флеш-пам'яті,
яку зазвичай можна оновити, запустивши програмне забезпечення у вашій ОС; **зловмисне ПЗ, запущене від імені root,
може оновити цю мікропрограму, або мікропрограма
вже може бути шкідливою**. Ваш жорсткий диск або SSD є ідеальним місцем для зловмисника,
щоб встановити зловмисне програмне забезпечення, оскільки це постійний пристрій зберігання даних,
а також комп'ютер.

Виходячи з цього, можна з упевненістю сказати, що використання USB замість SATA є
доцільним, якщо питання безпеки викликає занепокоєння. USB 2.0 має достатню пропускну здатність
багатьох жорстких дисків (декілька високоякісних дисків можуть використовувати більшу пропускну здатність, ніж USB 2.0),
але для SSD це може бути проблематично (якщо ви не використовуєте
USB 3.0, який ще не можна використовувати в свободі. Подивіться

Використання USB також не є абсолютною гарантією безпеки, тому будьте обережні.
Поверхня для атаки стає набагато меншою, але шкідливий накопичувач все одно може
спробувати здійснити "фуззингову" атаку (наприклад, надсилання некоректних USB-
дескрипторів, завдяки чому було зламано DRM тиранію Playstation 3,
щоб користувачі могли запускати власну операційну систему та запускати
непідписаний код). (Ви, мабуть, у безпеці, якщо немає недоліку безпеки
в USB-бібліотеці/драйвері, який використовує ваша ОС. USB зазвичай вважається
одним із найбезпечніших протоколів, саме тому, що USB-пристрої не мають DMA)

Інші посилання:

-   <https://www.vice.com/en_us/article/ypwkwk/the-nsas-undetectable-hard-drive-hack-was-first-demonstrated-a-year-ago>

Рекомендовано використовувати повне шифрування диска на жорстких дисках,
підключених через USB. У мережі є кілька адаптерів, які дозволяють підключати жорсткі диски
SATA через USB, і проект Canoeboot здатний завантажуватись з них
звичайним чином. Проконсультуйтесь з документацією для вашої операційної системи GNU/Linux/BSD,
щоб знати те, як встановити їх з *повнодисковим шифруванням*:

Поточна теорія (недоведена) полягає в тому, що це принаймні запобіжить
зловмисним дискам неправильно маніпулювати даними, які зчитуються з диска
або записуються на диск, оскільки він не може отримати доступ до вашого ключа LUKS,
якщо він знаходиться лише в оперативній пам'яті, за умови що жорсткий диск не має DMA (USB-пристрої не
мають DMA). Найгірше, що він може зробити в цьому випадку, це знищити ваші дані.
Звичайно, ви повинні переконатися, що ніколи не розміщуєте ключові файли в заголовку LUKS.
**Сприймайте сказане в цьому абзаці з дрібкою солі. Це все ще обговорюється
і нічого з цього не доведено.**

#### NIC (контролер ethernet) 

Мережеві карти Ethernet зазвичай запускають вбудоване програмне забезпечення, яке відповідає
за внутрішню ініціалізацію пристрою. Теоретично його можна налаштувати
на відкидання пакетів або навіть їх модифікацію.

З належним IOMMU можна було би пом'якшити проблеми, пов'язані з DMA.
Також можна використовувати мережевий адаптер USB, який не має DMA.

#### Мікрокод процесора

Мікрокод налаштовує масиви логічних вентилів у мікропроцесорі для реалізації
архітектури набору інструкцій. Спеціальні *декодери* в мікропроцесорі налаштують
схему на основі цього мікрокоду.

#### Звукова карта 

Звукове обладнання (інтегроване чи дискретне) зазвичай має вбудоване програмне забезпечення
(DSP) для обробки введення/виведення. Знову ж таки, USB DAC є хорошим
обхідним шляхом.

#### Веб-камера 

Веб-камери мають вбудоване програмне забезпечення, яке обробляє зображення, що вводиться
в камеру; налаштування фокуса, балансу білого тощо. Можна використовувати апаратне забезпечення
веб-камери USB, щоб вирішити можливі проблеми DMA; інтегровані веб-камери
(наприклад, на ноутбуках) не рекомендовані проектом Canoeboot з
міркувань безпеки.

#### Хост-контролер USB 

Хост-контролери USB потребують мікропрограми. Іноді це потрібно надати
самому coreboot.

#### Прошивка WWAN 

Деякі ноутбуки можуть мати пристрій для зчитування SIM-карт із карткою для роботи з
WWAN, підключення до мережі 3g/4g (наприклад, GSM). Це та
сама технологія, яка використовується в мобільних телефонах для віддаленого доступу до мережі (наприклад,
інтернет).

ПРИМІТКА: не плутати з wifi. Wifi - це інша технологія, яка
абсолютно не пов'язана з нею.

Процесор базової смуги всередині мікросхеми WWAN матиме власну вбудовану
операційну систему, швидше за все, пропрієтарну. Використання цієї технології також
передбачає ті ж проблеми конфіденційності, що й у випадку з мобільними телефонами (віддалене відстеження
за допомогою мережі GSM, шляхом тріангуляції сигналу).

На деяких ноутбуках ці карти використовують USB (внутрішньо), тому не матимуть DMA,
але це все одно є великою проблемою свободи та конфіденційності. Якщо у вас є
внутрішній чіп/карта WWAN, проект Canoeboot рекомендує вимкнути та
(в ідеалі, якщо можливо) фізично видалити апаратне забезпечення. Якщо вам абсолютно
необхідно використовувати цю технологію, зовнішній USB-адаптер набагато
кращий, оскільки його можна легко вийняти, коли він вам не потрібен, тим самим
вимикаючи будь-які зовнішні об'єкти від відстеження вашого місцезнаходження.

Рекомендується використовувати ethernet або wifi, на відміну від мобільних мереж,
оскільки вони, як правило, набагато безпечніші.

Операційні системи
------------------

### Чи я можу використовувати GNU/Linux?

Абсолютно! Він добре перевірений в Canoeboot, та дуже рекомендований. Подивіться
[встановлення GNU/Linux](../docs/linux/grub_boot_installer.md) та
[запуск GNU/Linux](../docs/linux/grub_cbfs.md).

Будь-який сучасний дистрибутив має працювати, допоки він використовує KMS (kernel mode
setting) для графіки.

### Fedora не завантажується? (також може бути застосовано до Redhat/CentOS)

У Fedora типово grub.cfg намагається завантажити linux в 16-розрядному режимі.
Вам просто потрібно змінити конфігурацію GRUB Fedora.
Зверніться до [сторінки GNU/Linux](docs/linux/).

### Чи я можу використовувати BSD?

Абсолютно! Прошивка Canoeboot має добру підтримку для FreeBSD, NetBSD та
OpenBSD. Інші системи не перевірені, але мають працювти нормально.

Дивіться:
[docs/bsd/](docs/bsd/index.uk.md)

### Windows??

Yes, you can use Windows 10 and 11. They are not officially supported and the
Canoeboot project recommends that you *avoid* this choice, because Windows is
proprietary software. What this means is that you do *not* have the freedom
to use, study, adapt and share the software in any reasonable way. You are
entirely at the mercy of Microsoft, whose motive is profit, as opposed to the
general advancement of computer science and the welfare of everyone.

See: [What is Free Software?](https://writefreesoftware.org/learn)

In addition to being proprietary software, Windows is known to be full of bugs,
including *backdoors*. When you *use* Windows, it will send information about
you to third parties, used for a variety of purposes such as advertising, but
it's quite possible that three-letter agencies may also receive your data if
you use Windows.

For the sake of your freedom, you should never, ever use Windows. Use GNU/Linux or
BSD systems, which are well-supported. Anyway:

[Video of Windows 10 booting up](https://yewtu.be/watch?v=BWq6XnWKQnM)

[Video of Windows 11 booting up](https://yewtu.be/watch?v=OFHiMfVNNeA)

Of note: Windows 11 officially requires at least TPM 1.2 to be supported, and
it requires use of UEFI SecureBoot. To bypass this requirement, MajorGeeks has
a guide, see: <https://www.majorgeeks.com/content/page/bypass_tpm.html>

The person who tested this also stated that they were unable to perform an
in-place upgrade from 10 to 11, so they had to wipe the drive and perform a
clean (note: not clean, because Windows is full of NSA spyware) installation.

In both cases, as shown above, the Windows operating system was booting from
SeaBIOS, with the coreboot framebuffer initialised at startup, on an Intel GPU
initialised via coreboot's *libgfxinit*, on November 2023 versions of Canoeboot.
We do not yet support booting with UEFI on x86 machines.

### Чи підтримуються інші операційні системи?

Невідомо. Можливо, але неможливо сказати без подальшого випробовування.

Який рівень програмної свободи дає мені Canoeboot?
--------------------------------------------------

Прошивка Canoeboot надає ініціалізацію апаратного забезпечення хоста всередині файлів ROM,
що може бути записано на флеш NOR, але на багатьох системах існує
набагато більше маленьких комп'ютерів на материнській платі, виконуючих двійкові прошивки.
Деякі з них неможливо замінити через те, що вони розташовані на Mask ROM.
Наприклад, більшість ноутбуків мають вбудоване програмне забезпечення EC (вбудований контролер).

Крім самого програмного забезпечення (вбудованого в ROM чи ні), більшість апаратного забезпечення
(від мікросхем до друкованих плат) не випускається за ліцензіями з відкритим джерелом.
У нас немає жодного пристрою, який можна вважати на "100% вільним",
і таких абсолютів майже неможливо досягти.

Відомі пропрієтарні блоби (неповний список):

* Всі пристрої
	* Прошивка жорсткого диска SATA/PATA/оптичного дисковода
  ([часто має потужний, заснований на ARM комп'ютер](
  http://spritesmods.com/?art=hddhack&page=1))
	* Флеш-накопичувачі та будь-які периферійні USB-пристрої - вони містять комп'ютер
  із запущеним кодом, щонайменше, для обробки протоколу USB
* ThinkPad:
	* Прошивка EC (H8S до включаючи Sandy Bridge, пізніше заснований на ARC MEC16xx)
	* Прошивка TrackPoint (8051)
	* Пристрої Penabled містять мікроконтролер µPD78F0514 на підплаті wacom,
  і Atmega (AVR) на світлодіодному індикаторі/платі кнопок
	* BMS акумулятора, bq8030 (CoolRISC C816)
* Хромбуки C201PA/C100PA:
	* BMS акумулятора, bq30z55
	* Тачпад Elan
	* Прошивка [контролера флеш-пам'яті](https://en.wikipedia.org/wiki/Flash_memory_controller) eMMC

Одного дня ми житимемо у світі, де будь-хто зможе виготовити власні чіпи, включаючи
процесори, а також будь-які інші типи мікросхем. Зусилля зробити домашнє виробництво чіпів реальністю
зараз знаходяться в зародковому стані, але такі зусилля
існують, наприклад, робота, виконана Семом Зелофом і проектом Libre Silicon:

* <https://www.youtube.com/channel/UC7E8-0Ou69hwScPW1_fQApA>
* <http://sam.zeloof.xyz/>
* <https://libresilicon.com/>

(Сем буквально робить процесори в своєму гаражі)

Де я можу вивчати більше про електроніку
----------------------------------------

* Основи пайки та переробки від PACE  
    Обидві серії відео є обов'язковими незалежно від ваших навичок паяння.
    * [Базове паяння](https://yewtu.be/playlist?list=PL926EC0F1F93C1837)
    * [Переробка та ремонт](https://yewtu.be/playlist?list=PL958FF32927823D12)
    Наведені вище серії PACE охоплюють класичні методи, але не стосуються
    *сучасної* електроніки. Для цього дивіться:
    * [Уроки мікропайки iFixit із Джессою
	Джонс](https://yewtu.be/playlist?list=PL4INaL5vWobD_CltiZXr7K46oJ33KvwBt)
    * Також перегляньте посилання на youtube нижче, особливо відео Луї Россмана, щоб дізнатися
      (набагато) більше.
* [Курс edX з основ електроніки](https://www.edx.org/course/circuits-and-electronics-1-basic-circuit-analysi-2)  
    У більшості країн зміст цього курсу розглядається в середній та старшій
    школі. Це також добре послужить, щоб освіжити вашу пам'ять,
    якщо ви з тих пір не користувались цими знаннями.
* Вступ до імпедансу
    * [Подібності в поведінці хвиль](https://yewtu.be/watch?v=DovunOxlY1k)
    * [Відбиття в лінії передачі](https://yewtu.be/watch?v=y8GMH7vMAsQ)
    * Заглушки:
        * [Стаття на Вікіпедії про заглушки](https://en.wikipedia.org/wiki/Stub_(electronics))
        * [Стаття Polar Instruments про заглушки](http://www.polarinstruments.com/support/si/AP8166.html)  
        З зовнішньої прошивкою SPI ми дбаємо лише про заглушки непередбачених друкованих плат
* [Як точно виміряти крок конектора](https://www.microcontrollertips.com/accurately-measure-headerconnector-pitch/)
* Інші YouTube-канали з корисним контентом про електроніку
    * [EEVblog](https://yewtu.be/channel/UC2DjFE7Xf11URZqWBigcVOQ)
	(загалом про електроніку, огляди обладнання і так далі, деякі
	відео ремонту)
    * [Луї Россман](https://yewtu.be/channel/UCl2mFZoRqjw_ELax4Yisf6w)
	(пропаганда права на ремонт, багато відео про ремонт macbook)
    * [mikeselectricstuff](https://yewtu.be/channel/UCcs0ZkP_as4PpHDhFcmCHyA)
    * [bigclive](https://yewtu.be/channel/UCtM5z2gkrGRuWd0JQMx76qA)
    * [ElectroBOOM](https://yewtu.be/channel/UCJ0-OtVpF0wOKEqT2Z1HEtA)
	(він підриває речі та показує, як цього не робити)
    * [Jeri Ellsworth](https://yewtu.be/user/jeriellsworth/playlists)
	(має відео, що показує як виготовити *транзистор* самостійно)
    * [Sam Zeloof](https://yewtu.be/channel/UC7E8-0Ou69hwScPW1_fQApA)
	(Сем буквально робить процесори в своєму гаражі, натхненний роботою Джері Еллсуорт
	з транзисторами)
    * [iPad Rehab with Jessa Jones](https://yewtu.be/channel/UCPjp41qeXe1o_lp1US9TpWA)
	(дуже точна пайка. вона займається ремонтом мобільних телефонів і подібного, про що
	також йдеться в серії iFixit про ремонт компонентів)
* Файли Boardview може бути відкрито в [OpenBoardview](https://github.com/OpenBoardView/OpenBoardView),
що є вільним програмним забезпеченням під ліцензією MIT.

Використання `yt-dlp` (покращеного відгалудження `youtube-dl`) рекомендовано для посилань
на `youtube.com`. Дивіться: <https://github.com/yt-dlp/yt-dlp>

Нарешті найважливіше повідомлення для всіх, хто починає це чудове нове хобі - [Секрет вивчення електроніки](https://yewtu.be/watch?v=xhQ7d3BK3KQ)
