/*
    This file is part of Akregator.

    SPDX-FileCopyrightText: 2008 Frank Osterfeld <osterfeld@kde.org>

    SPDX-License-Identifier: GPL-2.0-or-later WITH Qt-Commercial-exception-1.0
*/

#ifndef AKREGATOR_DELETESUBSCRIPTIONCOMMAND_H
#define AKREGATOR_DELETESUBSCRIPTIONCOMMAND_H

#include "command.h"

#include <QWeakPointer>

namespace Akregator
{
class FeedList;

class DeleteSubscriptionCommand : public Command
{
    Q_OBJECT
public:
    explicit DeleteSubscriptionCommand(QObject *parent = nullptr);
    ~DeleteSubscriptionCommand() override;

    void setSubscription(const QWeakPointer<FeedList> &feedList, int subId);

    int subscriptionId() const;
    QWeakPointer<FeedList> feedList() const;

private:
    void doStart() override;
    void doAbort() override;

private:
    class Private;
    Private *const d;
};
}

#endif // AKREGATOR_DELETESUBSCRIPTIONCOMMAND_H
