/*************************************************************************
 *  Copyright (C) 2010 by Volker Lanz <vl@fidra.de>                      *
 *                                                                       *
 *  This program is free software; you can redistribute it and/or        *
 *  modify it under the terms of the GNU General Public License as       *
 *  published by the Free Software Foundation; either version 3 of       *
 *  the License, or (at your option) any later version.                  *
 *                                                                       *
 *  This program is distributed in the hope that it will be useful,      *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *  GNU General Public License for more details.                         *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.*
 *************************************************************************/

#ifndef KPMCORE_SMARTATTRIBUTE_H
#define KPMCORE_SMARTATTRIBUTE_H

#include "util/libpartitionmanagerexport.h"

#include <QString>

class SmartAttributeParsedData;

class LIBKPMCORE_EXPORT SmartAttribute
{
public:
    enum class FailureType {
        PreFailure,
        OldAge
    };

    enum class UpdateType {
        Online,
        Offline
    };

    enum class Assessment {
        NotApplicable,
        Failing,
        HasFailed,
        Warning,
        Good
    };

public:
    SmartAttribute(const SmartAttributeParsedData& a);

public:
    qint32 id() const {
        return m_Id;
    }
    const QString& name() const {
        return m_Name;
    }
    const QString& desc() const {
        return m_Desc;
    }
    FailureType failureType() const {
        return m_FailureType;
    }
    UpdateType updateType() const {
        return m_UpdateType;
    }
    qint32 current() const {
        return m_Current;
    }
    qint32 worst() const {
        return m_Worst;
    }
    qint32 threshold() const {
        return m_Threshold;
    }
    const QString& raw() const {
        return m_Raw;
    }
    Assessment assessment() const {
        return m_Assessment;
    }
    const QString& value() const {
        return m_Value;
    }

    QString assessmentToString() const {
        return assessmentToString(assessment());
    }
    static QString assessmentToString(Assessment a);

private:
    qint32 m_Id;
    QString m_Name;
    QString m_Desc;
    FailureType m_FailureType;
    UpdateType m_UpdateType;
    qint32 m_Current;
    qint32 m_Worst;
    qint32 m_Threshold;
    QString m_Raw;
    Assessment m_Assessment;
    QString m_Value;
};

#endif
