/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;

public class ReverseArrayIterator
implements UnfailingIterator,
ReversibleIterator,
LookaheadIterator,
LastPositionFinder {
    Item[] items;
    int index = 0;
    int start;
    int end;
    Item current = null;

    public ReverseArrayIterator(Item[] items, int start, int end) {
        this.items = items;
        this.end = end;
        this.start = start;
        this.index = end - 1;
    }

    public boolean hasNext() {
        return this.index >= this.start;
    }

    public Item next() {
        if (this.index >= this.start) {
            this.current = this.items[this.index--];
            return this.current;
        }
        this.current = null;
        return null;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        if (this.index < this.start - 1) {
            return -1;
        }
        return this.end - 1 - this.index;
    }

    public int getLastPosition() {
        return this.end - this.start;
    }

    public void close() {
    }

    public SequenceIterator getAnother() {
        return new ReverseArrayIterator(this.items, this.start, this.end);
    }

    public int getProperties() {
        return 2;
    }

    public SequenceIterator getReverseIterator() {
        return new ArrayIterator(this.items, this.start, this.end);
    }
}

