// re2rust $INPUT -o $OUTPUT

// Maximum number of capturing groups among all rules.
/*!maxnmatch:re2c*/

#[derive(Debug, PartialEq)]
struct SemVer(u32, u32, u32); // version: (major, minor, patch)

fn s2n(str: &[u8]) -> u32 { // convert a pre-parsed string to a number
    let mut n = 0;
    for i in str { n = n * 10 + *i as u32 - 48; }
    return n;
}

fn parse(str: &[u8]) -> Option<SemVer> {
    let (mut cur, mut mar) = (0, 0);

    // Allocate memory for capturing parentheses (twice the number of groups).
    let yynmatch: usize;
    let mut yypmatch = [0; YYMAXNMATCH*2];

    // Autogenerated tag variables used by the lexer to track tag values.
    const NONE: usize = std::usize::MAX;
    /*!stags:re2c format = 'let mut @@{tag} = NONE;'; */

    /*!re2c
        re2c:define:YYCTYPE     = u8;
        re2c:define:YYPEEK      = "*str.get_unchecked(cur)";
        re2c:define:YYSKIP      = "cur += 1;";
        re2c:define:YYBACKUP    = "mar = cur;";
        re2c:define:YYRESTORE   = "cur = mar;";
        re2c:define:YYSTAGP     = "@@{tag} = cur;";
        re2c:define:YYSTAGN     = "@@{tag} = NONE;";
        re2c:define:YYSHIFTSTAG = "@@{tag} -= -@@{shift}isize as usize;";
        re2c:yyfill:enable = 0;
        re2c:posix-captures = 1;

        num = [0-9]+;

        (num) "." (num) ("." num)? [\x00] {
            // `yynmatch` is the number of capturing groups
            assert_eq!(yynmatch, 4);

            // Even `yypmatch` values are for opening parentheses, odd values
            // are for closing parentheses, the first group is the whole match.
            let major = s2n(&str[yypmatch[2]..yypmatch[3]]);
            let minor = s2n(&str[yypmatch[4]..yypmatch[5]]);
            let patch = if yypmatch[6] == NONE {0}
                else {s2n(&str[yypmatch[6] + 1..yypmatch[7]])};

            return Some(SemVer(major, minor, patch));
        }
        * { return None; }
    */
}

fn main() {
    assert_eq!(parse(b"23.34\0"), Some(SemVer(23, 34, 0)));
    assert_eq!(parse(b"1.2.99999\0"), Some(SemVer(1, 2, 99999)));
    assert_eq!(parse(b"1.a\0"), None);
}
