/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.fr.FrenchStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FrenchAnalyzer
extends Analyzer {
    public static final String[] FRENCH_STOP_WORDS = new String[]{"a", "afin", "ai", "ainsi", "apr\u00e8s", "attendu", "au", "aujourd", "auquel", "aussi", "autre", "autres", "aux", "auxquelles", "auxquels", "avait", "avant", "avec", "avoir", "c", "car", "ce", "ceci", "cela", "celle", "celles", "celui", "cependant", "certain", "certaine", "certaines", "certains", "ces", "cet", "cette", "ceux", "chez", "ci", "combien", "comme", "comment", "concernant", "contre", "d", "dans", "de", "debout", "dedans", "dehors", "del\u00e0", "depuis", "derri\u00e8re", "des", "d\u00e9sormais", "desquelles", "desquels", "dessous", "dessus", "devant", "devers", "devra", "divers", "diverse", "diverses", "doit", "donc", "dont", "du", "duquel", "durant", "d\u00e8s", "elle", "elles", "en", "entre", "environ", "est", "et", "etc", "etre", "eu", "eux", "except\u00e9", "hormis", "hors", "h\u00e9las", "hui", "il", "ils", "j", "je", "jusqu", "jusque", "l", "la", "laquelle", "le", "lequel", "les", "lesquelles", "lesquels", "leur", "leurs", "lorsque", "lui", "l\u00e0", "ma", "mais", "malgr\u00e9", "me", "merci", "mes", "mien", "mienne", "miennes", "miens", "moi", "moins", "mon", "moyennant", "m\u00eame", "m\u00eames", "n", "ne", "ni", "non", "nos", "notre", "nous", "n\u00e9anmoins", "n\u00f4tre", "n\u00f4tres", "on", "ont", "ou", "outre", "o\u00f9", "par", "parmi", "partant", "pas", "pass\u00e9", "pendant", "plein", "plus", "plusieurs", "pour", "pourquoi", "proche", "pr\u00e8s", "puisque", "qu", "quand", "que", "quel", "quelle", "quelles", "quels", "qui", "quoi", "quoique", "revoici", "revoil\u00e0", "s", "sa", "sans", "sauf", "se", "selon", "seront", "ses", "si", "sien", "sienne", "siennes", "siens", "sinon", "soi", "soit", "son", "sont", "sous", "suivant", "sur", "ta", "te", "tes", "tien", "tienne", "tiennes", "tiens", "toi", "ton", "tous", "tout", "toute", "toutes", "tu", "un", "une", "va", "vers", "voici", "voil\u00e0", "vos", "votre", "vous", "vu", "v\u00f4tre", "v\u00f4tres", "y", "\u00e0", "\u00e7a", "\u00e8s", "\u00e9t\u00e9", "\u00eatre", "\u00f4"};
    private final Set<?> stoptable;
    private Set<?> excltable = new HashSet();
    private final Version matchVersion;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public FrenchAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public FrenchAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public FrenchAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclutionSet) {
        this.matchVersion = matchVersion;
        this.stoptable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stopwords));
        this.excltable = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stemExclutionSet));
    }

    public FrenchAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((String[])stopwords));
    }

    public FrenchAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((File)stopwords));
    }

    public void setStemExclusionTable(String ... exclusionlist) {
        this.excltable = StopFilter.makeStopSet((String[])exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(Map exclusionlist) {
        this.excltable = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.excltable = new HashSet(WordlistLoader.getWordSet((File)exclusionlist));
        this.setPreviousTokenStream(null);
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stoptable);
        result = new FrenchStemFilter((TokenStream)result, this.excltable);
        result = new LowerCaseFilter((TokenStream)result);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter((TokenStream)streams.source);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stoptable);
            streams.result = new FrenchStemFilter(streams.result, this.excltable);
            streams.result = new LowerCaseFilter(streams.result);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList(FRENCH_STOP_WORDS), false));

        private DefaultSetHolder() {
        }
    }
}

