/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.util.SmallFloat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Similarity
implements Serializable {
    private static Similarity defaultImpl = new DefaultSimilarity();
    public static final int NO_DOC_ID_PROVIDED = -1;
    private static final float[] NORM_TABLE = new float[256];

    public static void setDefault(Similarity similarity) {
        defaultImpl = similarity;
    }

    public static Similarity getDefault() {
        return defaultImpl;
    }

    public static float decodeNorm(byte b) {
        return NORM_TABLE[b & 0xFF];
    }

    public static float[] getNormDecoder() {
        return NORM_TABLE;
    }

    public float computeNorm(String field, FieldInvertState state) {
        return state.getBoost() * this.lengthNorm(field, state.getLength());
    }

    public abstract float lengthNorm(String var1, int var2);

    public abstract float queryNorm(float var1);

    public static byte encodeNorm(float f) {
        return SmallFloat.floatToByte315(f);
    }

    public float tf(int freq) {
        return this.tf((float)freq);
    }

    public abstract float sloppyFreq(int var1);

    public abstract float tf(float var1);

    public Explanation.IDFExplanation idfExplain(Term term, Searcher searcher) throws IOException {
        final int df = searcher.docFreq(term);
        final int max = searcher.maxDoc();
        final float idf = this.idf(df, max);
        return new Explanation.IDFExplanation(){

            public String explain() {
                return "idf(docFreq=" + df + ", maxDocs=" + max + ")";
            }

            public float getIdf() {
                return idf;
            }
        };
    }

    public Explanation.IDFExplanation idfExplain(Collection<Term> terms, Searcher searcher) throws IOException {
        int max = searcher.maxDoc();
        float idf = 0.0f;
        final StringBuilder exp = new StringBuilder();
        for (Term term : terms) {
            int df = searcher.docFreq(term);
            idf += this.idf(df, max);
            exp.append(" ");
            exp.append(term.text());
            exp.append("=");
            exp.append(df);
        }
        final float fIdf = idf;
        return new Explanation.IDFExplanation(){

            public float getIdf() {
                return fIdf;
            }

            public String explain() {
                return exp.toString();
            }
        };
    }

    public abstract float idf(int var1, int var2);

    public abstract float coord(int var1, int var2);

    public float scorePayload(int docId, String fieldName, int start, int end, byte[] payload, int offset, int length) {
        return 1.0f;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Similarity.NORM_TABLE[i] = SmallFloat.byte315ToFloat((byte)i);
        }
    }
}

