/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;

public abstract class XSLLeafNodeConstructor
extends StyleElement {
    protected Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void validate(Declaration decl) throws XPathException {
        if (this.select != null && this.hasChildNodes()) {
            String errorCode = this.getErrorCodeForSelectPlusContent();
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", errorCode);
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo first = (NodeInfo)kids.next();
        if (this.select == null) {
            if (first == null) {
                this.select = new StringLiteral(StringValue.EMPTY_STRING);
            } else if (kids.next() == null && first.getNodeKind() == 3) {
                this.select = new StringLiteral(first.getStringValue());
            }
        }
    }

    protected abstract String getErrorCodeForSelectPlusContent();

    protected void compileContent(Executable exec, Declaration decl, SimpleNodeConstructor inst, Expression separator) throws XPathException {
        if (separator == null) {
            separator = new StringLiteral(StringValue.SINGLE_SPACE);
        }
        try {
            if (this.select == null) {
                this.select = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
            }
            this.select = XSLLeafNodeConstructor.makeSimpleContentConstructor(this.select, separator);
            inst.setSelect(this.select, exec.getConfiguration());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public static Expression makeSimpleContentConstructor(Expression select, Expression separator) {
        select = new AdjacentTextNodeMerger(select);
        select = new Atomizer(select);
        select = new AtomicSequenceConverter(select, BuiltInAtomicType.STRING);
        select = SystemFunction.makeSystemFunction("string-join", new Expression[]{select, separator});
        return select;
    }
}

