# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DESCRIPTION="Default C++ library configuration for clang"
HOMEPAGE="https://clang.llvm.org/"
S=${WORKDIR}

LICENSE="public-domain"
SLOT="${PV}"
KEYWORDS="amd64 arm arm64 ~loong ~mips ~ppc ~ppc64 ~riscv ~sparc x86 ~arm64-macos ~x64-macos"
IUSE="default-libcxx"

RDEPEND="
	default-libcxx? ( >=llvm-runtimes/libcxx-${PV}[static-libs] )
	!default-libcxx? ( sys-devel/gcc )
"

src_install() {
	insinto "/etc/clang/${SLOT}"
	newins - gentoo-stdlib.cfg <<-EOF
		# This file is initially generated by ${CATEGORY}/${PN}.
		# It is used to control the default C++ standard library used by clang.

		--stdlib=$(usex default-libcxx libc++ libstdc++)
	EOF
}
