import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import React, { forwardRef, memo, useMemo } from 'react';
import { useDragDropContext } from '../drag-drop-context/internal-context';
import { useDraggableDimensions } from '../hooks/use-captured-dimensions';
import { attributes } from '../utils/attributes';
export var Placeholder = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function Placeholder(_ref, ref) {
  var styleProp = _ref.style;
  var dimensions = useDraggableDimensions();
  var _useDragDropContext = useDragDropContext(),
    contextId = _useDragDropContext.contextId;
  var dataAttributes = _defineProperty({}, attributes.placeholder.contextId, contextId);
  var style = useMemo(function () {
    if (!dimensions) {
      return;
    }
    var margin = dimensions.margin,
      rect = dimensions.rect;
    return _objectSpread({
      boxSizing: 'border-box',
      width: rect.width,
      height: rect.height,
      margin: margin
    }, styleProp);
  }, [dimensions, styleProp]);

  // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
  return /*#__PURE__*/React.createElement("div", _extends({
    ref: ref,
    style: style
  }, dataAttributes));
}));