// Source: https://github.com/atlassian/react-beautiful-dnd

import config from '../../config';
import { minScroll } from '../../constants';
import { getPercentage } from '../../get-percentage';
const accelerateAt = config.durationDampening.accelerateAt;
const stopAt = config.durationDampening.stopDampeningAt;
export const dampenValueByTime = (proposedScroll, dragStartTime) => {
  const startOfRange = dragStartTime;
  const endOfRange = stopAt;
  const now = Date.now();
  const runTime = now - startOfRange;

  // we have finished the time dampening period
  if (runTime >= stopAt) {
    return proposedScroll;
  }

  // Up to this point we know there is a proposed scroll
  // but we have not reached our accelerate point
  // Return the minimum amount of scroll
  if (runTime < accelerateAt) {
    return minScroll;
  }
  const betweenAccelerateAtAndStopAtPercentage = getPercentage({
    startOfRange: accelerateAt,
    endOfRange,
    current: runTime
  });
  const scroll = proposedScroll * config.ease(betweenAccelerateAtAndStopAtPercentage);
  return Math.ceil(scroll);
};