package portalrevision

import (
	"fmt"

	"github.com/hashicorp/go-azure-sdk/sdk/client/resourcemanager"
	sdkEnv "github.com/hashicorp/go-azure-sdk/sdk/environments"
)

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See NOTICE.txt in the project root for license information.

type PortalRevisionClient struct {
	Client *resourcemanager.Client
}

func NewPortalRevisionClientWithBaseURI(sdkApi sdkEnv.Api) (*PortalRevisionClient, error) {
	client, err := resourcemanager.NewClient(sdkApi, "portalrevision", defaultApiVersion)
	if err != nil {
		return nil, fmt.Errorf("instantiating PortalRevisionClient: %+v", err)
	}

	return &PortalRevisionClient{
		Client: client,
	}, nil
}
