/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Mode : # Street modes    - `WALK`   - `BIKE`   - `RENTAL` Experimental. Expect unannounced breaking changes (without version bumps).   - `CAR`   - `CAR_PARKING`  # Transit modes    - `TRANSIT`: translates to `RAIL,SUBWAY,TRAM,BUS,FERRY,AIRPLANE,COACH`   - `TRAM`: trams   - `SUBWAY`: subway trains   - `FERRY`: ferries   - `AIRPLANE`: airline flights   - `BUS`: short distance buses (does not include `COACH`)   - `COACH`: long distance buses (does not include `BUS`)   - `RAIL`: translates to `HIGHSPEED_RAIL,LONG_DISTANCE_RAIL,NIGHT_RAIL,REGIONAL_RAIL,REGIONAL_FAST_RAIL`   - `METRO`: metro trains   - `HIGHSPEED_RAIL`: long distance high speed trains (e.g. TGV)   - `LONG_DISTANCE`: long distance inter city trains   - `NIGHT_RAIL`: long distance night trains   - `REGIONAL_FAST_RAIL`: regional express routes that skip low traffic stops to be faster   - `REGIONAL_RAIL`: regional train 
/// # Street modes    - `WALK`   - `BIKE`   - `RENTAL` Experimental. Expect unannounced breaking changes (without version bumps).   - `CAR`   - `CAR_PARKING`  # Transit modes    - `TRANSIT`: translates to `RAIL,SUBWAY,TRAM,BUS,FERRY,AIRPLANE,COACH`   - `TRAM`: trams   - `SUBWAY`: subway trains   - `FERRY`: ferries   - `AIRPLANE`: airline flights   - `BUS`: short distance buses (does not include `COACH`)   - `COACH`: long distance buses (does not include `BUS`)   - `RAIL`: translates to `HIGHSPEED_RAIL,LONG_DISTANCE_RAIL,NIGHT_RAIL,REGIONAL_RAIL,REGIONAL_FAST_RAIL`   - `METRO`: metro trains   - `HIGHSPEED_RAIL`: long distance high speed trains (e.g. TGV)   - `LONG_DISTANCE`: long distance inter city trains   - `NIGHT_RAIL`: long distance night trains   - `REGIONAL_FAST_RAIL`: regional express routes that skip low traffic stops to be faster   - `REGIONAL_RAIL`: regional train 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Mode {
    #[serde(rename = "WALK")]
    Walk,
    #[serde(rename = "BIKE")]
    Bike,
    #[serde(rename = "RENTAL")]
    Rental,
    #[serde(rename = "CAR")]
    Car,
    #[serde(rename = "CAR_PARKING")]
    CarParking,
    #[serde(rename = "TRANSIT")]
    Transit,
    #[serde(rename = "TRAM")]
    Tram,
    #[serde(rename = "SUBWAY")]
    Subway,
    #[serde(rename = "FERRY")]
    Ferry,
    #[serde(rename = "AIRPLANE")]
    Airplane,
    #[serde(rename = "METRO")]
    Metro,
    #[serde(rename = "BUS")]
    Bus,
    #[serde(rename = "COACH")]
    Coach,
    #[serde(rename = "RAIL")]
    Rail,
    #[serde(rename = "HIGHSPEED_RAIL")]
    HighspeedRail,
    #[serde(rename = "LONG_DISTANCE")]
    LongDistance,
    #[serde(rename = "NIGHT_RAIL")]
    NightRail,
    #[serde(rename = "REGIONAL_FAST_RAIL")]
    RegionalFastRail,
    #[serde(rename = "REGIONAL_RAIL")]
    RegionalRail,
    #[serde(rename = "OTHER")]
    Other,

}

impl std::fmt::Display for Mode {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::Walk => write!(f, "WALK"),
            Self::Bike => write!(f, "BIKE"),
            Self::Rental => write!(f, "RENTAL"),
            Self::Car => write!(f, "CAR"),
            Self::CarParking => write!(f, "CAR_PARKING"),
            Self::Transit => write!(f, "TRANSIT"),
            Self::Tram => write!(f, "TRAM"),
            Self::Subway => write!(f, "SUBWAY"),
            Self::Ferry => write!(f, "FERRY"),
            Self::Airplane => write!(f, "AIRPLANE"),
            Self::Metro => write!(f, "METRO"),
            Self::Bus => write!(f, "BUS"),
            Self::Coach => write!(f, "COACH"),
            Self::Rail => write!(f, "RAIL"),
            Self::HighspeedRail => write!(f, "HIGHSPEED_RAIL"),
            Self::LongDistance => write!(f, "LONG_DISTANCE"),
            Self::NightRail => write!(f, "NIGHT_RAIL"),
            Self::RegionalFastRail => write!(f, "REGIONAL_FAST_RAIL"),
            Self::RegionalRail => write!(f, "REGIONAL_RAIL"),
            Self::Other => write!(f, "OTHER"),
        }
    }
}

impl Default for Mode {
    fn default() -> Mode {
        Self::Walk
    }
}

