//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// Preferred actions available to the user in Settings.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipencilpreferredaction?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIPencilPreferredAction(pub NSInteger);
impl UIPencilPreferredAction {
    /// No action, or the user has disabled pencil interactions in Accessibility settings
    #[doc(alias = "UIPencilPreferredActionIgnore")]
    pub const Ignore: Self = Self(0);
    /// Switch between the current tool and eraser
    #[doc(alias = "UIPencilPreferredActionSwitchEraser")]
    pub const SwitchEraser: Self = Self(1);
    /// Switch between the current tool and the previously used tool
    #[doc(alias = "UIPencilPreferredActionSwitchPrevious")]
    pub const SwitchPrevious: Self = Self(2);
    /// Show and hide the color palette
    #[doc(alias = "UIPencilPreferredActionShowColorPalette")]
    pub const ShowColorPalette: Self = Self(3);
    /// Show the ink attributes palette
    #[doc(alias = "UIPencilPreferredActionShowInkAttributes")]
    pub const ShowInkAttributes: Self = Self(4);
    /// Show a contextual palette of markup tools, or undo/redo options if tools are not available
    #[doc(alias = "UIPencilPreferredActionShowContextualPalette")]
    pub const ShowContextualPalette: Self = Self(5);
    /// The user has selected a system shortcut to run
    #[doc(alias = "UIPencilPreferredActionRunSystemShortcut")]
    pub const RunSystemShortcut: Self = Self(6);
}

unsafe impl Encode for UIPencilPreferredAction {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIPencilPreferredAction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The phase of an interaction gesture performed on the pencil.
///
/// If the gesture is discrete, the phase will be ``UIPencilInteractionPhaseEnded``
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipencilinteractionphase?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIPencilInteractionPhase(pub NSUInteger);
impl UIPencilInteractionPhase {
    /// A continuous gesture on the pencil began
    #[doc(alias = "UIPencilInteractionPhaseBegan")]
    pub const Began: Self = Self(0);
    /// A continuous gesture on the pencil changed
    #[doc(alias = "UIPencilInteractionPhaseChanged")]
    pub const Changed: Self = Self(1);
    /// A continuous gesture on the pencil ended, or a discrete gesture on the pencil recognized
    #[doc(alias = "UIPencilInteractionPhaseEnded")]
    pub const Ended: Self = Self(2);
    /// A continuous gesture on the pencil was cancelled
    #[doc(alias = "UIPencilInteractionPhaseCancelled")]
    pub const Cancelled: Self = Self(3);
}

unsafe impl Encode for UIPencilInteractionPhase {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIPencilInteractionPhase {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipencilinteraction?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPencilInteraction;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPencilInteraction {}
);

#[cfg(feature = "UIInteraction")]
extern_conformance!(
    unsafe impl UIInteraction for UIPencilInteraction {}
);

impl UIPencilInteraction {
    extern_methods!(
        /// The user’s preferred double-tap action as set in Settings app
        #[unsafe(method(preferredTapAction))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredTapAction(mtm: MainThreadMarker) -> UIPencilPreferredAction;

        /// The user’s preferred squeeze action as set in Settings app
        #[unsafe(method(preferredSqueezeAction))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredSqueezeAction(mtm: MainThreadMarker) -> UIPencilPreferredAction;

        /// The user's preference for drawing with pencil only as set in Settings app or the system tool picker
        #[unsafe(method(prefersPencilOnlyDrawing))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersPencilOnlyDrawing(mtm: MainThreadMarker) -> bool;

        /// The user's preference for if hovering with pencil should show a preview of the current drawing tool as set in Settings app
        #[unsafe(method(prefersHoverToolPreview))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersHoverToolPreview(mtm: MainThreadMarker) -> bool;

        /// Initialize an interaction and set the provided delegate
        #[unsafe(method(initWithDelegate:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDelegate(
            this: Allocated<Self>,
            delegate: &ProtocolObject<dyn UIPencilInteractionDelegate>,
        ) -> Retained<Self>;

        /// The interaction's delegate
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIPencilInteractionDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UIPencilInteractionDelegate>>,
        );

        /// Whether the interaction is enabled or not
        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEnabled(&self) -> bool;

        /// Setter for [`isEnabled`][Self::isEnabled].
        #[unsafe(method(setEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEnabled(&self, enabled: bool);
    );
}

/// Methods declared on superclass `NSObject`.
impl UIPencilInteraction {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// An object that describes the hover pose of the pencil while performing a gesture on the pencil
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipencilhoverpose?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPencilHoverPose;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPencilHoverPose {}
);

impl UIPencilHoverPose {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// The hover location of the pencil in the interaction's view while performing the associated action. If the pencil is removed from hover range during a continuous interaction,
        /// this will be the last reported location.
        #[unsafe(method(location))]
        #[unsafe(method_family = none)]
        pub unsafe fn location(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// The normalized distance from the screen of the hovering pencil. This value will be 1 at the maximum distance from the screen and will approach 0 as the pencil gets
        /// closer to the screen.
        #[unsafe(method(zOffset))]
        #[unsafe(method_family = none)]
        pub unsafe fn zOffset(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// The azimuth angle in radians of the pencil in the interaction's view while performing the associated action. Zero radians points along the positive X axis.
        #[unsafe(method(azimuthAngle))]
        #[unsafe(method_family = none)]
        pub unsafe fn azimuthAngle(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// The azimuth unit vector of the pencil in the interaction's view while performing the associated action. The unit vector points in the direction of the azimuth angle.
        #[unsafe(method(azimuthUnitVector))]
        #[unsafe(method_family = none)]
        pub unsafe fn azimuthUnitVector(&self) -> CGVector;

        #[cfg(feature = "objc2-core-foundation")]
        /// The altitude angle in radians of the pencil while performing the associated action. Zero radians indicates that the stylus is parallel to the screen surface, while `M_PI/2`
        /// radians indicates that it is normal to the screen surface.
        #[unsafe(method(altitudeAngle))]
        #[unsafe(method_family = none)]
        pub unsafe fn altitudeAngle(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// The roll angle in radians of the pencil while performing the associated action. For pencils that don't support roll, this value will be 0.
        #[unsafe(method(rollAngle))]
        #[unsafe(method_family = none)]
        pub unsafe fn rollAngle(&self) -> CGFloat;
    );
}

extern_class!(
    /// An object that describes a tap performed on the pencil
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipencilinteractiontap?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPencilInteractionTap;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPencilInteractionTap {}
);

impl UIPencilInteractionTap {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// The time in seconds from system start up when this tap occured
        #[unsafe(method(timestamp))]
        #[unsafe(method_family = none)]
        pub unsafe fn timestamp(&self) -> NSTimeInterval;

        /// The hover pose of the pencil while performing a tap. Returns `nil` if the pencil was not in hover range or if hover is not supported on the device.
        #[unsafe(method(hoverPose))]
        #[unsafe(method_family = none)]
        pub unsafe fn hoverPose(&self) -> Option<Retained<UIPencilHoverPose>>;
    );
}

extern_class!(
    /// An object that describes a squeeze performed on the pencil
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uipencilinteractionsqueeze?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPencilInteractionSqueeze;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPencilInteractionSqueeze {}
);

impl UIPencilInteractionSqueeze {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// The time in seconds from system start up when this squeeze occured
        #[unsafe(method(timestamp))]
        #[unsafe(method_family = none)]
        pub unsafe fn timestamp(&self) -> NSTimeInterval;

        /// The phase of the squeeze
        #[unsafe(method(phase))]
        #[unsafe(method_family = none)]
        pub unsafe fn phase(&self) -> UIPencilInteractionPhase;

        /// The hover pose of the pencil while performing a squeeze. Returns `nil` if the pencil was not in hover range or if hover is not supported on the device.
        #[unsafe(method(hoverPose))]
        #[unsafe(method_family = none)]
        pub unsafe fn hoverPose(&self) -> Option<Retained<UIPencilHoverPose>>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipencilinteractiondelegate?language=objc)
    pub unsafe trait UIPencilInteractionDelegate: NSObjectProtocol + MainThreadOnly {
        /// Called when the user taps on the side of the pencil if the interaction's view is in a visible view hierarchy.
        ///
        /// The delegate may do anything in this method.  To perform the user's preferred tap action (as set in Settings), consult the ``preferredTapAction`` class property
        /// of ``UIPencilInteraction``.
        ///
        /// - Note: If ``pencilInteraction(_:didReceiveTap:)`` is implemented, this method will not be called.
        #[deprecated = "Use pencilInteraction(_:didReceiveTap:) instead"]
        #[optional]
        #[unsafe(method(pencilInteractionDidTap:))]
        #[unsafe(method_family = none)]
        unsafe fn pencilInteractionDidTap(&self, interaction: &UIPencilInteraction);

        /// Called when the user taps on the side of the pencil if the interaction's view is in a visible view hierarchy.
        ///
        /// The delegate may do anything in this method.  To perform the user's preferred tap action (as set in Settings), consult the ``preferredTapAction`` class property
        /// of ``UIPencilInteraction``.
        ///
        /// - Note: If both this method and the deprecated ``pencilInteractionDidTap(_:)`` are implemented, then only this method will be called.
        #[optional]
        #[unsafe(method(pencilInteraction:didReceiveTap:))]
        #[unsafe(method_family = none)]
        unsafe fn pencilInteraction_didReceiveTap(
            &self,
            interaction: &UIPencilInteraction,
            tap: &UIPencilInteractionTap,
        );

        /// Called when the user squeezes side of the pencil if the interaction's view is in a visible view hierarchy.
        ///
        /// The delegate may do anything in this method.  To perform the user's preferred squeeze action (as set in Settings), consult the ``preferredSqueezeAction`` class
        /// property of ``UIPencilInteraction``.
        #[optional]
        #[unsafe(method(pencilInteraction:didReceiveSqueeze:))]
        #[unsafe(method_family = none)]
        unsafe fn pencilInteraction_didReceiveSqueeze(
            &self,
            interaction: &UIPencilInteraction,
            squeeze: &UIPencilInteractionSqueeze,
        );
    }
);
