/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper;

import de.undercouch.citeproc.bibtex.PageRange;
import org.apache.commons.lang3.StringUtils;

public class PageRangeFormatter {
    public static final String DEFAULT_DELIMITER = "\u2013";

    public static String format(PageRange range, Format format) {
        return PageRangeFormatter.format(range, format, DEFAULT_DELIMITER);
    }

    public static String format(PageRange range, Format format, String delimiter) {
        String first = range.getPageFirst();
        String last = range.getPageLast();
        if (first == null || last == null || first.equals(last)) {
            return range.getLiteral().replace("-", delimiter);
        }
        if (last.length() <= first.length()) {
            if (last.length() < first.length()) {
                last = PageRangeFormatter.expanded(first, last);
            }
            switch (format) {
                case CHICAGO15: {
                    last = PageRangeFormatter.chicago15(first, last);
                    break;
                }
                case CHICAGO16: {
                    last = PageRangeFormatter.chicago16(first, last);
                    break;
                }
                case EXPANDED: {
                    break;
                }
                case MINIMAL: {
                    last = PageRangeFormatter.minimal(first, last);
                    break;
                }
                case MINIMAL2: {
                    last = PageRangeFormatter.minimal2(first, last);
                }
            }
        }
        return first + delimiter + last;
    }

    private static String expanded(String first, String last) {
        String fp = PageRangeFormatter.getAlphabeticPrefix(first);
        String lp = PageRangeFormatter.getAlphabeticPrefix(last);
        if (fp != null && lp == null || fp == null && lp != null) {
            return last;
        }
        if (fp != null) {
            if (fp.equals(lp)) {
                last = last.substring(lp.length());
            } else {
                return last;
            }
        }
        return first.substring(0, first.length() - last.length()) + last;
    }

    private static String getAlphabeticPrefix(String str) {
        int i;
        for (i = 0; i < str.length() && Character.isAlphabetic(str.charAt(i)); ++i) {
        }
        if (i == 0 || i == str.length()) {
            return null;
        }
        return str.substring(0, i);
    }

    private static String minimal(String first, String last) {
        int i;
        for (i = 0; i < first.length() && first.charAt(i) == last.charAt(i); ++i) {
        }
        return last.substring(i);
    }

    private static String minimal2(String first, String last) {
        int i;
        for (i = 0; i < first.length() - 2 && first.charAt(i) == last.charAt(i); ++i) {
        }
        return StringUtils.stripStart((String)last.substring(i), (String)"0");
    }

    private static String chicago15(String first, String last) {
        int nLast;
        int nFirst;
        String fp = PageRangeFormatter.getAlphabeticPrefix(first);
        String lp = PageRangeFormatter.getAlphabeticPrefix(last);
        if (fp != null && lp == null || fp == null && lp != null) {
            return last;
        }
        if (fp != null) {
            if (fp.equals(lp)) {
                first = first.substring(fp.length());
                last = last.substring(lp.length());
            } else {
                return last;
            }
        }
        if (lp == null) {
            lp = "";
        }
        try {
            nFirst = Integer.parseInt(first);
            nLast = Integer.parseInt(last);
        }
        catch (NumberFormatException e) {
            return lp + last;
        }
        if ((nFirst <= 1000 || nFirst > 9999 || nFirst / 100 == nLast / 100) && nFirst > 100 && nFirst % 100 > 0) {
            last = PageRangeFormatter.minimal2(first, last);
        }
        return lp + last;
    }

    private static String chicago16(String first, String last) {
        int nFirst;
        String fp = PageRangeFormatter.getAlphabeticPrefix(first);
        String lp = PageRangeFormatter.getAlphabeticPrefix(last);
        if (fp != null && lp == null || fp == null && lp != null) {
            return last;
        }
        if (fp != null) {
            if (fp.equals(lp)) {
                first = first.substring(fp.length());
                last = last.substring(lp.length());
            } else {
                return last;
            }
        }
        if (lp == null) {
            lp = "";
        }
        try {
            nFirst = Integer.parseInt(first);
            Integer.parseInt(last);
        }
        catch (NumberFormatException e) {
            return lp + last;
        }
        if (nFirst > 100 && nFirst % 100 > 0) {
            last = StringUtils.stripStart((String)PageRangeFormatter.minimal2(first, last), (String)"0");
        }
        return lp + last;
    }

    public static enum Format {
        CHICAGO15,
        CHICAGO16,
        EXPANDED,
        MINIMAL,
        MINIMAL2;

    }
}

