/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal.format;

import de.undercouch.citeproc.csl.internal.RenderContext;
import de.undercouch.citeproc.csl.internal.TokenBuffer;
import de.undercouch.citeproc.csl.internal.behavior.FormattingAttributes;
import de.undercouch.citeproc.csl.internal.token.DisplayGroupToken;
import de.undercouch.citeproc.csl.internal.token.TextToken;
import de.undercouch.citeproc.csl.internal.token.Token;
import de.undercouch.citeproc.helper.FrenchPunctuationSpacing;
import de.undercouch.citeproc.helper.SmartQuotes;
import de.undercouch.citeproc.helper.StringHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseFormat
implements de.undercouch.citeproc.csl.internal.format.Format {
    private static final Map<String, String> MERGE_PUNCTUATION_MAP = Map.ofEntries(Map.entry("!.", "!"), Map.entry("!:", "!"), Map.entry("?.", "?"), Map.entry("?:", "?"), Map.entry(":!", "!"), Map.entry(":?", "?"), Map.entry(":.", ":"), Map.entry(";!", "!"), Map.entry(";?", "?"), Map.entry(";:", ";"), Map.entry(";.", ";"));
    protected boolean convertLinks = false;

    protected void postProcess(TokenBuffer buffer, RenderContext ctx) {
        String rest;
        TextToken t1;
        Token ti;
        TextToken tt;
        Token t;
        int i;
        List<Token> tokens = buffer.getTokens();
        SmartQuotes sq = new SmartQuotes(ctx.getTerm("open-inner-quote"), ctx.getTerm("close-inner-quote"), ctx.getTerm("open-quote"), ctx.getTerm("close-quote"), ctx.getLocale().getLang());
        for (i = 0; i < tokens.size(); ++i) {
            String nt;
            TextToken.Type type;
            t = tokens.get(i);
            if (!(t instanceof TextToken) || (type = (tt = (TextToken)t).getType()) != TextToken.Type.TEXT && type != TextToken.Type.PREFIX && type != TextToken.Type.SUFFIX && type != TextToken.Type.DELIMITER || (nt = sq.apply(tt.getText())).equals(tt.getText())) continue;
            tokens.set(i, tt.copyWithText(nt));
        }
        if (ctx.getLocale().getStyleOptions().isPunctuationInQuote()) {
            for (i = 0; i < tokens.size() - 1; ++i) {
                ti = tokens.get(i);
                if (!(ti instanceof TextToken)) continue;
                TextToken t0 = (TextToken)ti;
                int j = BaseFormat.findNextText(tokens, i);
                if (j < 0) break;
                TextToken t12 = (TextToken)tokens.get(j);
                if (t0.getType() != TextToken.Type.CLOSE_QUOTE || t12.getText().isEmpty() || t12.getText().charAt(0) != ',' && t12.getText().charAt(0) != '.') continue;
                String nextText = t12.getText();
                String punctuation = nextText.substring(0, 1);
                String rest2 = nextText.substring(1);
                tokens.set(j, t12.copyWithText(rest2));
                if (i > 0 && tokens.get(i - 1) instanceof TextToken && ((TextToken)tokens.get(i - 1)).getType() == TextToken.Type.TEXT) {
                    TextToken tt2 = (TextToken)tokens.get(i - 1);
                    String ttt = tt2.getText();
                    int len = ttt.length();
                    String cq = ctx.getTerm("close-quote");
                    String ciq = ctx.getTerm("close-inner-quote");
                    while (len > 0) {
                        String ss = ttt.substring(0, len);
                        if (ss.endsWith(cq)) {
                            len -= cq.length();
                            continue;
                        }
                        if (!ss.endsWith(ciq)) break;
                        len -= ciq.length();
                    }
                    if (len == 0) {
                        --i;
                    } else if (len < ttt.length()) {
                        String ttr = ttt.substring(len);
                        ttt = ttt.substring(0, len);
                        tokens.set(i - 1, tt2.copyWithText(ttt));
                        tokens.add(i, tt2.copyWithText(ttr));
                    }
                }
                tokens.add(i, t12.copyWithText(punctuation));
                i = j;
            }
        }
        for (i = 1; i < tokens.size(); ++i) {
            int overlap;
            int j;
            boolean mergeableSuffix;
            ti = tokens.get(i);
            if (!(ti instanceof TextToken)) continue;
            t1 = (TextToken)ti;
            boolean bl = mergeableSuffix = t1.getType() == TextToken.Type.SUFFIX && !t1.getText().startsWith(")");
            if (t1.getType() != TextToken.Type.PREFIX && !mergeableSuffix && t1.getType() != TextToken.Type.DELIMITER || (j = BaseFormat.findPreviousNonQuote(tokens, i)) < 0) continue;
            TextToken t0 = (TextToken)tokens.get(j);
            String t0str = t0.getText();
            if (t0str.length() < t1.getText().length()) {
                StringBuilder pre = new StringBuilder(t0str);
                while (pre.length() < t1.getText().length() && j > 0) {
                    Token tj;
                    if (!((tj = tokens.get(--j)) instanceof TextToken)) continue;
                    t0 = (TextToken)tj;
                    pre.insert(0, t0.getText());
                }
                t0str = pre.toString();
            }
            if ((overlap = StringHelper.overlap(t0str, t1.getText())) <= 0) continue;
            rest = t1.getText().substring(overlap);
            if (rest.isEmpty()) {
                tokens.remove(i);
                --i;
                continue;
            }
            tokens.set(i, t1.copyWithText(rest));
        }
        for (i = 1; i < tokens.size(); ++i) {
            String lookup;
            String replacement;
            TextToken t0;
            ti = tokens.get(i);
            if (!(ti instanceof TextToken)) continue;
            t1 = (TextToken)ti;
            int j = BaseFormat.findPreviousNonQuote(tokens, i);
            if (j < 0 || (t0 = (TextToken)tokens.get(j)).getText().isEmpty() || t1.getText().isEmpty() || t1.getType() != TextToken.Type.PREFIX && t1.getType() != TextToken.Type.SUFFIX && t1.getType() != TextToken.Type.DELIMITER || (replacement = MERGE_PUNCTUATION_MAP.get(lookup = t0.getText().substring(t0.getText().length() - 1) + t1.getText().charAt(0))) == null) continue;
            String nt0 = t0.getText().substring(0, t0.getText().length() - 1) + replacement;
            tokens.set(j, t0.copyWithText(nt0));
            rest = t1.getText().substring(1);
            if (rest.isEmpty()) {
                tokens.remove(i);
                --i;
                continue;
            }
            tokens.set(i, t1.copyWithText(rest));
        }
        if (ctx.getLocale().getLang().getLanguage().equals(Locale.FRENCH.getLanguage())) {
            for (i = 0; i < tokens.size(); ++i) {
                String nt;
                TextToken.Type type;
                t = tokens.get(i);
                if (!(t instanceof TextToken) || (type = (tt = (TextToken)t).getType()) != TextToken.Type.TEXT && type != TextToken.Type.PREFIX && type != TextToken.Type.SUFFIX && type != TextToken.Type.DELIMITER || (nt = FrenchPunctuationSpacing.apply(tt.getText())).equals(tt.getText())) continue;
                tokens.set(i, tt.copyWithText(nt));
            }
        }
        if (this.convertLinks) {
            for (i = 1; i < tokens.size(); ++i) {
                ti = tokens.get(i);
                if (!(ti instanceof TextToken)) continue;
                t1 = (TextToken)ti;
                int j = BaseFormat.findPreviousText(tokens, i);
                if (j < 0) continue;
                TextToken t0 = (TextToken)tokens.get(j);
                if (t1.getType() != TextToken.Type.DOI || t0.getType() != TextToken.Type.PREFIX || !t0.getText().matches("^https?://doi.org/?$")) continue;
                String url = this.addDOIPrefix(t1.getText());
                if (!url.equals(t1.getText())) {
                    tokens.set(i, t1.copyWithText(url));
                }
                tokens.remove(j);
            }
        }
    }

    private static int findNextText(List<Token> tokens, int i) {
        for (int j = i + 1; j < tokens.size(); ++j) {
            if (!(tokens.get(j) instanceof TextToken)) continue;
            return j;
        }
        return -1;
    }

    private static int findPreviousText(List<Token> tokens, int i) {
        for (int j = i - 1; j >= 0; --j) {
            if (!(tokens.get(j) instanceof TextToken)) continue;
            return j;
        }
        return -1;
    }

    private static int findPreviousNonQuote(List<Token> tokens, int i) {
        for (int j = i - 1; j >= 0; --j) {
            Token t = tokens.get(j);
            if (!(t instanceof TextToken) || ((TextToken)t).getType() == TextToken.Type.CLOSE_QUOTE) continue;
            return j;
        }
        return -1;
    }

    @Override
    public void setConvertLinks(boolean convert) {
        this.convertLinks = convert;
    }

    @Override
    public String formatCitation(RenderContext ctx) {
        TokenBuffer buffer = new TokenBuffer();
        buffer.append(ctx.getResult());
        this.postProcess(buffer, ctx);
        return this.doFormatCitation(buffer, ctx);
    }

    protected abstract String doFormatCitation(TokenBuffer var1, RenderContext var2);

    @Override
    public String formatBibliographyEntry(RenderContext ctx, int index) {
        TokenBuffer buffer = new TokenBuffer();
        buffer.append(ctx.getResult());
        this.postProcess(buffer, ctx);
        return this.doFormatBibliographyEntry(buffer, ctx, index);
    }

    protected abstract String doFormatBibliographyEntry(TokenBuffer var1, RenderContext var2, int var3);

    protected String formatURL(String str) {
        String escapedStr = this.escape(str);
        return this.doFormatLink(escapedStr, escapedStr);
    }

    protected String addDOIPrefix(String str) {
        if (!((String)str).matches("^https?://.*$")) {
            str = "https://doi.org/" + (String)str;
        }
        return str;
    }

    protected String formatDOI(String str) {
        String uri = this.addDOIPrefix(str);
        return this.doFormatLink(this.escape(str), this.escape(uri));
    }

    protected abstract String doFormatLink(String var1, String var2);

    protected String escape(String str) {
        return str;
    }

    protected String format(TokenBuffer buffer) {
        StringBuilder result = new StringBuilder();
        ArrayList<Pair> formattingStack = new ArrayList<Pair>();
        for (Token t : buffer.getTokens()) {
            Pair f;
            int i;
            EnumMap<Format, Integer> tokenFormattingAttributes = new EnumMap<Format, Integer>(Format.class);
            tokenFormattingAttributes.put(Format.FontStyle, FormattingAttributes.getFontStyle(t.getFormattingAttributes()));
            tokenFormattingAttributes.put(Format.FontVariant, FormattingAttributes.getFontVariant(t.getFormattingAttributes()));
            tokenFormattingAttributes.put(Format.FontWeight, FormattingAttributes.getFontWeight(t.getFormattingAttributes()));
            tokenFormattingAttributes.put(Format.TextDecoration, FormattingAttributes.getTextDecoration(t.getFormattingAttributes()));
            tokenFormattingAttributes.put(Format.VerticalAlign, FormattingAttributes.getVerticalAlign(t.getFormattingAttributes()));
            boolean[] closed = new boolean[formattingStack.size()];
            int firstClosed = formattingStack.size();
            for (i = 0; i < formattingStack.size(); ++i) {
                f = (Pair)formattingStack.get(i);
                int newValue = tokenFormattingAttributes.getOrDefault(f.getKey(), 0);
                boolean bl = closed[i] = newValue != (Integer)f.getValue();
                if (!closed[i] || firstClosed != formattingStack.size()) continue;
                firstClosed = i;
            }
            for (i = formattingStack.size(); i > firstClosed; --i) {
                f = (Pair)formattingStack.get(i - 1);
                this.closeFormattingAttribute((Format)((Object)f.getKey()), (Integer)f.getValue(), result);
            }
            EnumSet<Format> remaining = EnumSet.allOf(Format.class);
            int j = 0;
            Iterator iter = formattingStack.iterator();
            while (iter.hasNext()) {
                Pair f2 = (Pair)iter.next();
                if (closed[j]) {
                    iter.remove();
                } else {
                    remaining.remove(f2.getKey());
                }
                ++j;
            }
            for (Format r : remaining) {
                int v = tokenFormattingAttributes.getOrDefault((Object)r, 0);
                if (v == 0) continue;
                formattingStack.add(Pair.of((Object)((Object)r), (Object)v));
            }
            for (int i2 = firstClosed; i2 < formattingStack.size(); ++i2) {
                Pair f3 = (Pair)formattingStack.get(i2);
                this.openFormattingAttribute((Format)((Object)f3.getKey()), (Integer)f3.getValue(), result);
            }
            if (t instanceof DisplayGroupToken) {
                DisplayGroupToken dgt = (DisplayGroupToken)t;
                String str = dgt.isOpen() ? this.openDisplayGroup(dgt.getType()) : this.closeDisplayGroup(dgt.getType());
                if (str == null) continue;
                result.append(str);
                continue;
            }
            if (!(t instanceof TextToken)) continue;
            TextToken tt = (TextToken)t;
            if (this.convertLinks && (tt.getType() == TextToken.Type.URL || tt.getType() == TextToken.Type.DOI)) {
                String link = tt.getType() == TextToken.Type.URL ? this.formatURL(tt.getText()) : this.formatDOI(tt.getText());
                result.append(link);
                continue;
            }
            result.append(this.escape(tt.getText()));
        }
        for (int i = formattingStack.size(); i > 0; --i) {
            Pair f = (Pair)formattingStack.get(i - 1);
            this.closeFormattingAttribute((Format)((Object)f.getKey()), (Integer)f.getValue(), result);
        }
        return result.toString();
    }

    private void openFormattingAttribute(Format f, int value, StringBuilder result) {
        if (value == 0 || value == 1) {
            return;
        }
        String str = null;
        switch (f) {
            case FontStyle: {
                str = this.openFontStyle(value);
                break;
            }
            case FontVariant: {
                str = this.openFontVariant(value);
                break;
            }
            case FontWeight: {
                str = this.openFontWeight(value);
                break;
            }
            case TextDecoration: {
                str = this.openTextDecoration(value);
                break;
            }
            case VerticalAlign: {
                str = this.openVerticalAlign(value);
            }
        }
        if (str != null) {
            result.append(str);
        }
    }

    private void closeFormattingAttribute(Format f, int value, StringBuilder result) {
        if (value == 0 || value == 1) {
            return;
        }
        String str = null;
        switch (f) {
            case FontStyle: {
                str = this.closeFontStyle(value);
                break;
            }
            case FontVariant: {
                str = this.closeFontVariant(value);
                break;
            }
            case FontWeight: {
                str = this.closeFontWeight(value);
                break;
            }
            case TextDecoration: {
                str = this.closeTextDecoration(value);
                break;
            }
            case VerticalAlign: {
                str = this.closeVerticalAlign(value);
            }
        }
        if (str != null) {
            result.append(str);
        }
    }

    protected String openFontStyle(int fontStyle) {
        return null;
    }

    protected String closeFontStyle(int fontStyle) {
        return null;
    }

    protected String openFontVariant(int fontVariant) {
        return null;
    }

    protected String closeFontVariant(int fontVariant) {
        return null;
    }

    protected String openFontWeight(int fontWeight) {
        return null;
    }

    protected String closeFontWeight(int fontWeight) {
        return null;
    }

    protected String openTextDecoration(int textDecoration) {
        return null;
    }

    protected String closeTextDecoration(int textDecoration) {
        return null;
    }

    protected String openVerticalAlign(int verticalAlign) {
        return null;
    }

    protected String closeVerticalAlign(int verticalAlign) {
        return null;
    }

    protected String openDisplayGroup(DisplayGroupToken.Type type) {
        return null;
    }

    protected String closeDisplayGroup(DisplayGroupToken.Type type) {
        return null;
    }

    private static enum Format {
        FontStyle,
        FontVariant,
        FontWeight,
        TextDecoration,
        VerticalAlign;

    }
}

