/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx;

import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.SegmentCell;
import com.dlsc.pickerfx.skins.SegmentSkin;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class Segment<T, S>
extends Control {
    private final Picker<T> picker;
    private final ObservableList<S> items = FXCollections.observableArrayList();
    private final ObjectProperty<S> value = new SimpleObjectProperty((Object)this, "value");
    private final BooleanProperty wrapItems = new SimpleBooleanProperty((Object)this, "wrapItems", true);
    private final ObjectProperty<Callback<Segment<T, S>, SegmentCell<S>>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final BooleanProperty readOnly = new SimpleBooleanProperty((Object)this, "readOnly");

    public Segment(Picker<T> picker) {
        this.picker = Objects.requireNonNull(picker);
        this.getStyleClass().add((Object)"segment");
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.setCellFactory(p -> new SegmentCell());
        this.readOnlyProperty().bind((ObservableValue)picker.readOnlyProperty());
    }

    protected Skin<?> createDefaultSkin() {
        return new SegmentSkin(this);
    }

    public final Picker<T> getPicker() {
        return this.picker;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Segment.getClassCssMetaData();
    }

    public final ObservableList<S> getItems() {
        return this.items;
    }

    public final ObjectProperty<S> valueProperty() {
        return this.value;
    }

    public final S getValue() {
        return (S)this.valueProperty().get();
    }

    public final void setValue(S value) {
        this.value.set(value);
    }

    public final BooleanProperty wrapItemsProperty() {
        return this.wrapItems;
    }

    public final boolean isWrapItems() {
        return this.wrapItems.get();
    }

    public final void setWrapItems(boolean wrapItems) {
        this.wrapItems.set(wrapItems);
    }

    public final ObjectProperty<Callback<Segment<T, S>, SegmentCell<S>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final Callback<Segment<T, S>, SegmentCell<S>> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public final void setCellFactory(Callback<Segment<T, S>, SegmentCell<S>> cellFactory) {
        this.cellFactoryProperty().set(cellFactory);
    }

    public final BooleanProperty readOnlyProperty() {
        return this.readOnly;
    }

    public final boolean isReadOnly() {
        return this.readOnlyProperty().get();
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnlyProperty().set(readOnly);
    }
}

